/***************************************************************************
                          kscribbledoc.h  -  description
                             -------------------
    begin                : Mon Jan 31 11:05:05 CET 2000
    copyright            : (C) 2000 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSCRIBBLEDOC_H
#define KSCRIBBLEDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>

#include <qsize.h>
#include <qpen.h>
#include <qpoint.h>
//#include <qpixmap.h>
#include <qpointarray.h>

#include <kpixmap.h>


// forward declaration of the KScribble classes
class KScribbleView;

/**	KScribbleDoc provides a document object for a document-view model.
  *
  * The KScribbleDoc class provides a document object that can be used in conjunction with the classes
  * KScribbleApp and KScribbleView to create a document-view model for MDI (Multiple Document Interface)
  * KDE 2 applications based on KApplication and KTMainWindow as main classes and QWorkspace as MDI manager widget.
  * Thereby, the document object is created by the KScribbleApp instance (and kept in a document list) and contains
  * the document structure with the according methods for manipulating the document
  * data by KScribbleView objects. Also, KScribbleDoc contains the methods for serialization of the document data
  * from and to files.
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 1.1 code generation
  */
class KScribbleDoc : public QObject
{
  Q_OBJECT

  friend KScribbleView;

  public:
    /** Constructor for the fileclass of the application */
    KScribbleDoc();
    /** Destructor for the fileclass of the application */
    ~KScribbleDoc();

    /** adds a view to the document which represents the document contents. Usually this is your main view. */
    void addView(KScribbleView *view);
    /** removes a view from the list of currently connected views */
    void removeView(KScribbleView *view);
		/** gets called if a view is removed or added */
		void changedViewList();
    /** returns the first view instance */
		KScribbleView* firstView(){ return pViewList->first(); };
		/** returns true, if the requested view is the last view of the document */
    bool isLastView();
    /** This method gets called when the user is about to close a frame window. It checks, if more than one view
    	* is connected to the document (then the frame can be closed), if pFrame is the last view and the document is
    	* modified, the user gets asked if he wants to save the document.
    	*/
		bool canCloseFrame(KScribbleView* pFrame);
    /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
    void setModified(bool _m=true){ modified=_m; };
    /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
    bool isModified(){ return modified; };
    /** deletes the document's contents */
    void deleteContents();
    /** initializes the document generally */
    bool newDocument();
    /** closes the acutal document */
    void closeDocument();
    /** loads the document by filename and format and emits the updateViews() signal */
    bool openDocument(const QString &filename, const char *format=0);
    /** saves the document under filename and format.*/	
    bool saveDocument(const QString &filename, const char *format=0);
    /** sets the path to the file connected with the document */
    void setPathName(const QString &name);
    /** returns the pathname of the current document file*/
    const QString& pathName() const;

    /** sets the filename of the document */
    void setTitle(const QString &title);
    /** returns the title of the document */
    const QString& title() const;
    /** get the current Pen */
    const QPen currentPen(){ return pen;};	
		/** returns the pen width */
		const int penWidth() { return pen.width(); }
    /** returns the pen color */
    const QColor penColor(){ return pen.color(); }
    /** sets the pen width */
    void setPenWidth( int w ){ pen.setWidth( w ); }
		/** sets the pen color */
  	void setPenColor( const QColor &c ){ pen.setColor( c ); }
    /** sets the pen style by a second toolbar */
    void setPenStyle( PenStyle s){ pen.setStyle(s);}
    /** clears the document contents */
    void editClearAll();

    /** get the document size */
    const QSize docSize(){ return size;};
  /** sets the pixmap contents. Used by KScribbleApp
    to create a new document by drop events */
    void setPixmap(KPixmap pix) { buffer=pix;};
    void resizeDocument(QSize m_size) { size=m_size; };
  public slots:
    /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     * As this view normally repaints itself, it is excluded from the paintEvent.
     */
    void updateAllViews(KScribbleView *sender);
	
	protected:
	
		QPen pen;
		QPointArray polyline;
		KPixmap buffer;
 	
  private:
    /** the modified flag of the current document */
    bool modified;
    QString m_title;
    QString m_filename;
    /** the list of the views currently connected to the document */
    QList<KScribbleView> *pViewList;	
    QSize size;
};

#endif // KSCRIBBLEDOC_H
