
#include "nodefilter.h"

#include <dom/dom_element.h>

NodeFilter::NodeFilter( const QStringList &tags )
    : m_tags( tags )
{
}

short NodeFilter::acceptNode( const DOM::Node &node )
{
    DOM::Element e = node;
    if ( e.isNull() || m_tags.findIndex( e.tagName().string() ) == -1 )
        return DOM::NodeFilter::FILTER_SKIP;

    return DOM::NodeFilter::FILTER_ACCEPT;
}

/*
 * vim:ts=4:ts=4:et
 */
