/**
 * $Id: kuickconfigdlg.cpp,v 1.4 2002/01/27 14:54:53 ellis Exp $
 *
 * Copyright 1998-2001 by Carsten Pfeiffer
 */

#ifdef index
#undef index
#endif
#include "kuickconfigdlg.h"

#include <qkeycode.h>
#include <qvbox.h>

#include <kaccel.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>

#include "imagewindow.h"
#include "defaultswidget.h"
#include "generalwidget.h"
#include "kuickdata.h"


KuickConfigDialog::KuickConfigDialog( KActionCollection *_coll, QWidget *parent,
				      const char *name, bool modal )
    : LogoTabDialog( KJanusWidget::Tabbed, i18n("KuickShow Configuration"),
		     Help | Default | Ok | Apply | Cancel, Ok,
		     parent, name, modal )
{
    coll = _coll;
    QVBox *box = addVBoxPage( i18n("General") );
    generalWidget = new GeneralWidget( box, "general widget" );

    box = addVBoxPage( i18n("Modifications") );
    defaultsWidget = new DefaultsWidget( box, "defaults widget" );

    box = addVBoxPage( i18n("Viewer Shortcuts") );

    imageWindow = new ImageWindow(); // just to get the accel...
    imageWindow->hide();

    imageKeyChooser = new KKeyChooser( imageWindow->accel(), box );

    box = addVBoxPage( i18n("Browser Shortcuts") );
    browserKeyChooser = new KKeyChooser( coll, box );

    connect( this, SIGNAL( defaultClicked() ), SLOT( resetDefaults() ));
}

KuickConfigDialog::~KuickConfigDialog()
{
    imageWindow->close( true );
}

void KuickConfigDialog::applyConfig()
{
    generalWidget->applySettings();
    defaultsWidget->applySettings();

    imageKeyChooser->commitChanges();
    imageWindow->accel()->writeSettings();

    browserKeyChooser->commitChanges();
    // remove QString::null parameter -- ellis
    coll->writeShortcutSettings( QString::null );

    KGlobal::config()->sync();
}


void KuickConfigDialog::resetDefaults()
{
    generalWidget->resetDefaults();
    defaultsWidget->resetDefaults();
    imageKeyChooser->allDefault();
    browserKeyChooser->allDefault();
}

#include "kuickconfigdlg.moc"
