#include <kglobal.h>
#include <klocale.h>
#include <kapplication.h>
#include <kmenubar.h>
#include <kdialog.h>
#include <dcopclient.h>
#include <qpopupmenu.h>
#include <kstdaccel.h>

#include "pamview.h"
#include "secpolicywin.h"

SecPolicyWin::SecPolicyWin(const char *name)
  : KMainWindow(0,name)
{
  view = new PamView(this);
  setCentralWidget(view);

  KMenuBar *mBar = menuBar();
  QPopupMenu *fileMenu = new QPopupMenu(this);
	fileMenu->insertItem(i18n("&Quit"), kapp, SLOT(closeAllWindows()), KStdAccel::key(KStdAccel::Quit));
  mBar->insertItem(i18n("&File"), fileMenu);
  
  connect(kapp, SIGNAL(lastWindowClosed()), kapp, SLOT(quit()));

  adjustSize();
  // work around KTMainWindow sizing bug.
  resize(sizeHint().width(), sizeHint().height() + mBar->height() +
	 KDialog::marginHint());
  show();
}

SecPolicyWin::~SecPolicyWin()
{
}

void SecPolicyWin::closeEvent(QCloseEvent *e)
{
  e->accept();
}
