/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicTabbedPaneUI
extends TabbedPaneUI
implements SwingConstants {
    protected JTabbedPane tabPane;
    protected Color highlight;
    protected Color lightHighlight;
    protected Color shadow;
    protected Color darkShadow;
    protected Color focus;
    private Color selectedColor;
    protected int textIconGap;
    protected int tabRunOverlay;
    protected Insets tabInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets contentBorderInsets;
    protected KeyStroke upKey;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected int[] tabRuns = new int[10];
    protected int runCount = 0;
    protected int selectedRun = -1;
    protected Rectangle[] rects = new Rectangle[0];
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected ChangeListener tabChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected FocusListener focusListener;
    private ContainerListener containerListener;
    private Insets currentPadInsets = new Insets(0, 0, 0, 0);
    private Insets currentTabAreaInsets = new Insets(0, 0, 0, 0);
    private Component visibleComponent;
    private Vector htmlViews;
    private Hashtable mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    private ScrollableTabSupport tabScroller;
    protected transient Rectangle calcRect = new Rectangle(0, 0, 0, 0);
    private int tabCount;
    private int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    private int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    private static final int CROP_SEGMENT = 12;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.tabPane = (JTabbedPane)jComponent;
        jComponent.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        jComponent.setLayout(null);
        this.tabPane = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout();
        }
        return new TabbedPaneLayout();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
            this.tabPane.add(this.tabScroller.scrollForwardButton);
            this.tabPane.add(this.tabScroller.scrollBackwardButton);
        }
    }

    protected void uninstallComponents() {
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabScroller = null;
        }
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.highlight = UIManager.getColor("TabbedPane.light");
        this.lightHighlight = UIManager.getColor("TabbedPane.highlight");
        this.shadow = UIManager.getColor("TabbedPane.shadow");
        this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
        this.focus = UIManager.getColor("TabbedPane.focus");
        this.selectedColor = UIManager.getColor("TabbedPane.selected");
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
        this.selectedTabPadInsets = UIManager.getInsets("TabbedPane.selectedTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        this.contentBorderInsets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        this.tabRunOverlay = UIManager.getInt("TabbedPane.tabRunOverlay");
    }

    protected void uninstallDefaults() {
        this.highlight = null;
        this.lightHighlight = null;
        this.shadow = null;
        this.darkShadow = null;
        this.focus = null;
        this.tabInsets = null;
        this.selectedTabPadInsets = null;
        this.tabAreaInsets = null;
        this.contentBorderInsets = null;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.addMouseListener(this.mouseListener);
            } else {
                this.tabPane.addMouseListener(this.mouseListener);
            }
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        if ((this.containerListener = new ContainerHandler()) != null) {
            this.tabPane.addContainerListener(this.containerListener);
            if (this.tabPane.getTabCount() > 0) {
                this.htmlViews = this.createHTMLVector();
            }
        }
    }

    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.removeMouseListener(this.mouseListener);
            } else {
                this.tabPane.removeMouseListener(this.mouseListener);
            }
            this.mouseListener = null;
        }
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.containerListener != null) {
            this.tabPane.removeContainerListener(this.containerListener);
            this.containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.tabPane, actionMap);
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.scrollForwardButton.setAction(actionMap.get("scrollTabsForwardAction"));
            this.tabScroller.scrollBackwardButton.setAction(actionMap.get("scrollTabsBackwardAction"));
        }
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            return (InputMap)UIManager.get("TabbedPane.ancestorInputMap");
        }
        if (n2 == 0) {
            return (InputMap)UIManager.get("TabbedPane.focusInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("TabbedPane.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("TabbedPane.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("navigateNext", new NextAction());
        actionMapUIResource.put("navigatePrevious", new PreviousAction());
        actionMapUIResource.put("navigateRight", new RightAction());
        actionMapUIResource.put("navigateLeft", new LeftAction());
        actionMapUIResource.put("navigateUp", new UpAction());
        actionMapUIResource.put("navigateDown", new DownAction());
        actionMapUIResource.put("navigatePageUp", new PageUpAction());
        actionMapUIResource.put("navigatePageDown", new PageDownAction());
        actionMapUIResource.put("requestFocus", new RequestFocusAction());
        actionMapUIResource.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        actionMapUIResource.put("setSelectedIndex", new SetSelectedIndexAction());
        actionMapUIResource.put("scrollTabsForwardAction", new ScrollTabsForwardAction());
        actionMapUIResource.put("scrollTabsBackwardAction", new ScrollTabsBackwardAction());
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
    }

    private void updateMnemonics() {
        this.resetMnemonics();
        int n2 = this.tabPane.getTabCount() - 1;
        while (n2 >= 0) {
            int n3 = this.tabPane.getMnemonicAt(n2);
            if (n3 > 0) {
                this.addMnemonic(n2, n3);
            }
            --n2;
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int n2, int n3) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(n3, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(new Integer(n3), new Integer(n2));
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new InputMapUIResource();
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 1));
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, this.mnemonicInputMap);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n2 = this.tabPane.getTabCount();
        if (this.tabCount != n2) {
            this.tabCount = n2;
            this.updateMnemonics();
        }
        int n3 = this.tabPane.getSelectedIndex();
        int n4 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(graphics, n4, n3);
        }
        this.paintContentBorder(graphics, n4, n3);
    }

    protected void paintTabArea(Graphics graphics, int n2, int n3) {
        int n4 = this.tabPane.getTabCount();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = graphics.getClipBounds();
        int n5 = this.runCount - 1;
        while (n5 >= 0) {
            int n6 = this.tabRuns[n5];
            int n7 = this.tabRuns[n5 == this.runCount - 1 ? 0 : n5 + 1];
            int n8 = n7 != 0 ? n7 - 1 : n4 - 1;
            int n9 = n6;
            while (n9 <= n8) {
                if (this.rects[n9].intersects(rectangle3)) {
                    this.paintTab(graphics, n2, this.rects, n9, rectangle, rectangle2);
                }
                ++n9;
            }
            --n5;
        }
        if (n3 >= 0 && this.getRunForTab(n4, n3) == 0 && this.rects[n3].intersects(rectangle3)) {
            this.paintTab(graphics, n2, this.rects, n3, rectangle, rectangle2);
        }
    }

    protected void paintTab(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2) {
        Object object;
        Rectangle rectangle3 = rectangleArray[n3];
        int n4 = this.tabPane.getSelectedIndex();
        boolean bl2 = n4 == n3;
        Graphics2D graphics2D = null;
        Polygon polygon = null;
        Shape shape = null;
        int n5 = 0;
        int n6 = 0;
        if (this.scrollableTabLayoutEnabled() && graphics instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics;
            object = this.tabScroller.viewport.getViewRect();
            switch (n2) {
                case 2: 
                case 4: {
                    int n7 = ((Rectangle)object).y + ((Rectangle)object).height;
                    if (rectangle3.y >= n7 || rectangle3.y + rectangle3.height <= n7) break;
                    polygon = this.createCroppedTabClip(n2, rectangle3, n7);
                    n5 = rectangle3.x;
                    n6 = n7 - 1;
                    break;
                }
                default: {
                    int n7 = ((Rectangle)object).x + ((Rectangle)object).width;
                    if (rectangle3.x >= n7 || rectangle3.x + rectangle3.width <= n7) break;
                    polygon = this.createCroppedTabClip(n2, rectangle3, n7);
                    n5 = n7 - 1;
                    n6 = rectangle3.y;
                }
            }
            if (polygon != null) {
                shape = graphics2D.getClip();
                graphics2D.clip(polygon);
            }
        }
        this.paintTabBackground(graphics, n2, n3, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl2);
        this.paintTabBorder(graphics, n2, n3, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl2);
        object = this.tabPane.getTitleAt(n3);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Icon icon = this.getIconForTab(n3);
        this.layoutLabel(n2, fontMetrics, n3, (String)object, icon, rectangle3, rectangle, rectangle2, bl2);
        this.paintText(graphics, n2, font, fontMetrics, n3, (String)object, rectangle2, bl2);
        this.paintIcon(graphics, n2, n3, icon, rectangle, bl2);
        this.paintFocusIndicator(graphics, n2, rectangleArray, n3, rectangle, rectangle2, bl2);
        if (polygon != null) {
            this.paintCroppedTabEdge(graphics, n2, n3, bl2, n5, n6);
            graphics2D.setClip(shape);
        }
    }

    private Polygon createCroppedTabClip(int n2, Rectangle rectangle, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        switch (n2) {
            case 2: 
            case 4: {
                n4 = rectangle.width;
                n5 = rectangle.x;
                n6 = rectangle.x + rectangle.width;
                n7 = rectangle.y;
                break;
            }
            default: {
                n4 = rectangle.height;
                n5 = rectangle.y;
                n6 = rectangle.y + rectangle.height;
                n7 = rectangle.x;
            }
        }
        int n8 = n4 / 12;
        if (n4 % 12 > 0) {
            ++n8;
        }
        int n9 = 2 + n8 * 8;
        int[] nArray = new int[n9];
        int[] nArray2 = new int[n9];
        int n10 = 0;
        nArray[n10] = n7;
        nArray2[n10++] = n6;
        nArray[n10] = n7;
        nArray2[n10++] = n5;
        int n11 = 0;
        while (n11 < n8) {
            int n12 = 0;
            while (n12 < this.xCropLen.length) {
                nArray[n10] = n3 - this.xCropLen[n12];
                nArray2[n10] = n5 + n11 * 12 + this.yCropLen[n12];
                if (nArray2[n10] >= n6) {
                    nArray2[n10] = n6;
                    ++n10;
                    break;
                }
                ++n10;
                ++n12;
            }
            ++n11;
        }
        if (n2 == 1 || n2 == 3) {
            return new Polygon(nArray, nArray2, n10);
        }
        return new Polygon(nArray2, nArray, n10);
    }

    private void paintCroppedTabEdge(Graphics graphics, int n2, int n3, boolean bl2, int n4, int n5) {
        switch (n2) {
            case 2: 
            case 4: {
                int n6 = n4;
                graphics.setColor(this.shadow);
                while (n6 <= n4 + this.rects[n3].width) {
                    int n7 = 0;
                    while (n7 < this.xCropLen.length) {
                        graphics.drawLine(n6 + this.yCropLen[n7], n5 - this.xCropLen[n7], n6 + this.yCropLen[n7 + 1] - 1, n5 - this.xCropLen[n7 + 1]);
                        n7 += 2;
                    }
                    n6 += 12;
                }
                break;
            }
            default: {
                int n8 = n5;
                graphics.setColor(this.shadow);
                while (n8 <= n5 + this.rects[n3].height) {
                    int n9 = 0;
                    while (n9 < this.xCropLen.length) {
                        graphics.drawLine(n4 - this.xCropLen[n9], n8 + this.yCropLen[n9], n4 - this.xCropLen[n9 + 1], n8 + this.yCropLen[n9 + 1] - 1);
                        n9 += 2;
                    }
                    n8 += 12;
                }
                break block0;
            }
        }
    }

    protected void layoutLabel(int n2, FontMetrics fontMetrics, int n3, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl2) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n3);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int n4 = this.getTabLabelShiftX(n2, n3, bl2);
        int n5 = this.getTabLabelShiftY(n2, n3, bl2);
        rectangle2.x += n4;
        rectangle2.y += n5;
        rectangle3.x += n4;
        rectangle3.y += n5;
    }

    protected void paintIcon(Graphics graphics, int n2, int n3, Icon icon, Rectangle rectangle, boolean bl2) {
        if (icon != null) {
            icon.paintIcon(this.tabPane, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintText(Graphics graphics, int n2, Font font, FontMetrics fontMetrics, int n3, String string, Rectangle rectangle, boolean bl2) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n3);
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            int n4 = this.tabPane.getDisplayedMnemonicIndexAt(n3);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n3)) {
                graphics.setColor(this.tabPane.getForegroundAt(n3));
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(this.tabPane.getBackgroundAt(n3).brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(this.tabPane.getBackgroundAt(n3).darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        }
    }

    protected int getTabLabelShiftX(int n2, int n3, boolean bl2) {
        Rectangle rectangle = this.rects[n3];
        int n4 = 0;
        switch (n2) {
            case 2: {
                n4 = bl2 ? -1 : 1;
                break;
            }
            case 4: {
                n4 = bl2 ? 1 : -1;
                break;
            }
            default: {
                n4 = rectangle.width % 2;
            }
        }
        return n4;
    }

    protected int getTabLabelShiftY(int n2, int n3, boolean bl2) {
        Rectangle rectangle = this.rects[n3];
        int n4 = 0;
        switch (n2) {
            case 3: {
                n4 = bl2 ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                n4 = rectangle.height % 2;
                break;
            }
            default: {
                n4 = bl2 ? -1 : 1;
            }
        }
        return n4;
    }

    protected void paintFocusIndicator(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
        Rectangle rectangle3 = rectangleArray[n3];
        if (this.tabPane.hasFocus() && bl2) {
            int n4;
            int n5;
            int n6;
            int n7;
            graphics.setColor(this.focus);
            switch (n2) {
                case 2: {
                    n7 = rectangle3.x + 3;
                    n6 = rectangle3.y + 3;
                    n5 = rectangle3.width - 5;
                    n4 = rectangle3.height - 6;
                    break;
                }
                case 4: {
                    n7 = rectangle3.x + 2;
                    n6 = rectangle3.y + 3;
                    n5 = rectangle3.width - 5;
                    n4 = rectangle3.height - 6;
                    break;
                }
                case 3: {
                    n7 = rectangle3.x + 3;
                    n6 = rectangle3.y + 2;
                    n5 = rectangle3.width - 6;
                    n4 = rectangle3.height - 5;
                    break;
                }
                default: {
                    n7 = rectangle3.x + 3;
                    n6 = rectangle3.y + 3;
                    n5 = rectangle3.width - 6;
                    n4 = rectangle3.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(graphics, n7, n6, n5, n4);
        }
    }

    protected void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        graphics.setColor(this.lightHighlight);
        switch (n2) {
            case 2: {
                graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + 1, n5 + n7 - 2);
                graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 3);
                graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 1);
                graphics.drawLine(n4 + 2, n5, n4 + n6 - 1, n5);
                graphics.setColor(this.shadow);
                graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + n6 - 1, n5 + n7 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n4 + 2, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
                break;
            }
            case 4: {
                graphics.drawLine(n4, n5, n4 + n6 - 3, n5);
                graphics.setColor(this.shadow);
                graphics.drawLine(n4, n5 + n7 - 2, n4 + n6 - 3, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 3);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 3);
                graphics.drawLine(n4, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                break;
            }
            case 3: {
                graphics.drawLine(n4, n5, n4, n5 + n7 - 3);
                graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + 1, n5 + n7 - 2);
                graphics.setColor(this.shadow);
                graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + n6 - 3, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 2, n5, n4 + n6 - 2, n5 + n7 - 3);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n4 + 2, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7 - 3);
                break;
            }
            default: {
                graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 1);
                graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 1);
                graphics.drawLine(n4 + 2, n5, n4 + n6 - 3, n5);
                graphics.setColor(this.shadow);
                graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 1);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 1);
                graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
            }
        }
    }

    protected void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        graphics.setColor(!bl2 || this.selectedColor == null ? this.tabPane.getBackgroundAt(n3) : this.selectedColor);
        switch (n2) {
            case 2: {
                graphics.fillRect(n4 + 1, n5 + 1, n6 - 2, n7 - 3);
                break;
            }
            case 4: {
                graphics.fillRect(n4, n5 + 1, n6 - 2, n7 - 3);
                break;
            }
            case 3: {
                graphics.fillRect(n4 + 1, n5, n6 - 3, n7 - 1);
                break;
            }
            default: {
                graphics.fillRect(n4 + 1, n5 + 1, n6 - 3, n7 - 1);
            }
        }
    }

    protected void paintContentBorder(Graphics graphics, int n2, int n3) {
        int n4 = this.tabPane.getWidth();
        int n5 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n6 = insets.left;
        int n7 = insets.top;
        int n8 = n4 - insets.right - insets.left;
        int n9 = n5 - insets.top - insets.bottom;
        switch (n2) {
            case 2: {
                n8 -= (n6 += this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n8 -= this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n9 -= this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n9 -= (n7 += this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        if (this.selectedColor == null) {
            graphics.setColor(this.tabPane.getBackground());
        } else {
            graphics.setColor(this.selectedColor);
        }
        graphics.fillRect(n6, n7, n8, n9);
        this.paintContentBorderTopEdge(graphics, n2, n3, n6, n7, n8, n9);
        this.paintContentBorderLeftEdge(graphics, n2, n3, n6, n7, n8, n9);
        this.paintContentBorderBottomEdge(graphics, n2, n3, n6, n7, n8, n9);
        this.paintContentBorderRightEdge(graphics, n2, n3, n6, n7, n8, n9);
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.lightHighlight);
        if (n2 != 1 || n3 < 0 || rectangle.y + rectangle.height + 1 < n5 || rectangle.x < n4 || rectangle.x > n4 + n6) {
            graphics.drawLine(n4, n5, n4 + n6 - 2, n5);
        } else {
            graphics.drawLine(n4, n5, rectangle.x - 1, n5);
            if (rectangle.x + rectangle.width < n4 + n6 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width, n5, n4 + n6 - 2, n5);
            } else {
                graphics.setColor(this.shadow);
                graphics.drawLine(n4 + n6 - 2, n5, n4 + n6 - 2, n5);
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.lightHighlight);
        if (n2 != 2 || n3 < 0 || rectangle.x + rectangle.width + 1 < n4 || rectangle.y < n5 || rectangle.y > n5 + n7) {
            graphics.drawLine(n4, n5, n4, n5 + n7 - 2);
        } else {
            graphics.drawLine(n4, n5, n4, rectangle.y - 1);
            if (rectangle.y + rectangle.height < n5 + n7 - 2) {
                graphics.drawLine(n4, rectangle.y + rectangle.height, n4, n5 + n7 - 2);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.shadow);
        if (n2 != 3 || n3 < 0 || rectangle.y - 1 > n7 || rectangle.x < n4 || rectangle.x > n4 + n6) {
            graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n4, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
        } else {
            graphics.drawLine(n4 + 1, n5 + n7 - 2, rectangle.x - 1, n5 + n7 - 2);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n4, n5 + n7 - 1, rectangle.x - 1, n5 + n7 - 1);
            if (rectangle.x + rectangle.width < n4 + n6 - 2) {
                graphics.setColor(this.shadow);
                graphics.drawLine(rectangle.x + rectangle.width, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(rectangle.x + rectangle.width, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.shadow);
        if (n2 != 4 || n3 < 0 || rectangle.x - 1 > n6 || rectangle.y < n5 || rectangle.y > n5 + n7) {
            graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + n7 - 3);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7 - 1);
        } else {
            graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, rectangle.y - 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, rectangle.y - 1);
            if (rectangle.y + rectangle.height < n5 + n7 - 2) {
                graphics.setColor(this.shadow);
                graphics.drawLine(n4 + n6 - 2, rectangle.y + rectangle.height, n4 + n6 - 2, n5 + n7 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n4 + n6 - 1, rectangle.y + rectangle.height, n4 + n6 - 1, n5 + n7 - 2);
            }
        }
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            TabbedPaneLayout tabbedPaneLayout = (TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n2) {
        this.ensureCurrentLayout();
        Rectangle rectangle = new Rectangle();
        return this.getTabBounds(n2, rectangle);
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        this.ensureCurrentLayout();
        return this.runCount;
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n2, int n3) {
        this.ensureCurrentLayout();
        Point point = new Point(n2, n3);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(n2, n3, point);
        }
        int n4 = this.tabPane.getTabCount();
        int n5 = 0;
        while (n5 < n4) {
            if (this.rects[n5].contains(point.x, point.y)) {
                return n5;
            }
            ++n5;
        }
        return -1;
    }

    protected Rectangle getTabBounds(int n2, Rectangle rectangle) {
        rectangle.width = this.rects[n2].width;
        rectangle.height = this.rects[n2].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point point = this.tabScroller.viewport.getLocation();
            Point point2 = this.tabScroller.viewport.getViewPosition();
            rectangle.x = this.rects[n2].x - point.x - point2.x;
            rectangle.y = this.rects[n2].y - point.y - point2.y;
        } else {
            rectangle.x = this.rects[n2].x;
            rectangle.y = this.rects[n2].y;
        }
        return rectangle;
    }

    private int getTabAtLocation(int n2, int n3) {
        this.ensureCurrentLayout();
        int n4 = this.tabPane.getTabCount();
        int n5 = 0;
        while (n5 < n4) {
            if (this.rects[n5].contains(n2, n3)) {
                return n5;
            }
            ++n5;
        }
        return -1;
    }

    private int getClosestTab(int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = n4 = Math.min(this.rects.length, this.tabPane.getTabCount());
        int n7 = this.tabPane.getTabPlacement();
        boolean bl2 = n7 == 1 || n7 == 3;
        int n8 = bl2 ? n2 : n3;
        while (n5 != n6) {
            int n9;
            int n10;
            int n11 = (n6 + n5) / 2;
            if (bl2) {
                n10 = this.rects[n11].x;
                n9 = n10 + this.rects[n11].width;
            } else {
                n10 = this.rects[n11].y;
                n9 = n10 + this.rects[n11].height;
            }
            if (n8 < n10) {
                n6 = n11;
                if (n5 != n6) continue;
                return Math.max(0, n11 - 1);
            }
            if (n8 >= n9) {
                n5 = n11;
                if (n6 - n5 > 1) continue;
                return Math.max(n11 + 1, n4 - 1);
            }
            return n11;
        }
        return n5;
    }

    private Point translatePointToTabPanel(int n2, int n3, Point point) {
        Point point2 = this.tabScroller.viewport.getLocation();
        Point point3 = this.tabScroller.viewport.getViewPosition();
        point.x = n2 + point2.x + point3.x;
        point.y = n3 + point2.y + point3.y;
        return point;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent == component) {
            return;
        }
        if (this.visibleComponent != null && this.visibleComponent.getParent() == this.tabPane) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected void assureRectsCreated(int n2) {
        int n3 = this.rects.length;
        if (n2 != n3) {
            Rectangle[] rectangleArray = new Rectangle[n2];
            System.arraycopy(this.rects, 0, rectangleArray, 0, Math.min(n3, n2));
            this.rects = rectangleArray;
            int n4 = n3;
            while (n4 < n2) {
                this.rects[n4] = new Rectangle();
                ++n4;
            }
        }
    }

    protected void expandTabRunsArray() {
        int n2 = this.tabRuns.length;
        int[] nArray = new int[n2 + 10];
        System.arraycopy(this.tabRuns, 0, nArray, 0, this.runCount);
        this.tabRuns = nArray;
    }

    protected int getRunForTab(int n2, int n3) {
        int n4 = 0;
        while (n4 < this.runCount) {
            int n5 = this.tabRuns[n4];
            int n6 = this.lastTabInRun(n2, n4);
            if (n3 >= n5 && n3 <= n6) {
                return n4;
            }
            ++n4;
        }
        return 0;
    }

    protected int lastTabInRun(int n2, int n3) {
        int n4;
        if (this.runCount == 1) {
            return n2 - 1;
        }
        int n5 = n4 = n3 == this.runCount - 1 ? 0 : n3 + 1;
        if (this.tabRuns[n4] == 0) {
            return n2 - 1;
        }
        return this.tabRuns[n4] - 1;
    }

    protected int getTabRunOverlay(int n2) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int n2, int n3) {
        return 0;
    }

    protected boolean shouldPadTabRun(int n2, int n3) {
        return this.runCount > 1;
    }

    protected boolean shouldRotateTabRuns(int n2) {
        return true;
    }

    protected Icon getIconForTab(int n2) {
        return !this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n2) ? this.tabPane.getDisabledIconAt(n2) : this.tabPane.getIconAt(n2);
    }

    protected View getTextViewForTab(int n2) {
        if (this.htmlViews != null) {
            return (View)this.htmlViews.elementAt(n2);
        }
        return null;
    }

    protected int calculateTabHeight(int n2, int n3, int n4) {
        int n5 = 0;
        View view = this.getTextViewForTab(n3);
        n5 = view != null ? (n5 += (int)view.getPreferredSpan(1)) : (n5 += n4);
        Icon icon = this.getIconForTab(n3);
        Insets insets = this.getTabInsets(n2, n3);
        if (icon != null) {
            n5 = Math.max(n5, icon.getIconHeight());
        }
        return n5 += insets.top + insets.bottom + 2;
    }

    protected int calculateMaxTabHeight(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n3 = this.tabPane.getTabCount();
        int n4 = 0;
        int n5 = fontMetrics.getHeight();
        int n6 = 0;
        while (n6 < n3) {
            n4 = Math.max(this.calculateTabHeight(n2, n6, n5), n4);
            ++n6;
        }
        return n4;
    }

    protected int calculateTabWidth(int n2, int n3, FontMetrics fontMetrics) {
        View view;
        Icon icon = this.getIconForTab(n3);
        Insets insets = this.getTabInsets(n2, n3);
        int n4 = insets.left + insets.right + 3;
        if (icon != null) {
            n4 += icon.getIconWidth() + this.textIconGap;
        }
        if ((view = this.getTextViewForTab(n3)) != null) {
            n4 += (int)view.getPreferredSpan(0);
        } else {
            String string = this.tabPane.getTitleAt(n3);
            n4 += SwingUtilities.computeStringWidth(fontMetrics, string);
        }
        return n4;
    }

    protected int calculateMaxTabWidth(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n3 = this.tabPane.getTabCount();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            n4 = Math.max(this.calculateTabWidth(n2, n5, fontMetrics), n4);
            ++n5;
        }
        return n4;
    }

    protected int calculateTabAreaHeight(int n2, int n3, int n4) {
        Insets insets = this.getTabAreaInsets(n2);
        int n5 = this.getTabRunOverlay(n2);
        return n3 > 0 ? n3 * (n4 - n5) + n5 + insets.top + insets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int n2, int n3, int n4) {
        Insets insets = this.getTabAreaInsets(n2);
        int n5 = this.getTabRunOverlay(n2);
        return n3 > 0 ? n3 * (n4 - n5) + n5 + insets.left + insets.right : 0;
    }

    protected Insets getTabInsets(int n2, int n3) {
        return this.tabInsets;
    }

    protected Insets getSelectedTabPadInsets(int n2) {
        BasicTabbedPaneUI.rotateInsets(this.selectedTabPadInsets, this.currentPadInsets, n2);
        return this.currentPadInsets;
    }

    protected Insets getTabAreaInsets(int n2) {
        BasicTabbedPaneUI.rotateInsets(this.tabAreaInsets, this.currentTabAreaInsets, n2);
        return this.currentTabAreaInsets;
    }

    protected Insets getContentBorderInsets(int n2) {
        return this.contentBorderInsets;
    }

    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont();
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    protected void navigateSelectedTab(int n2) {
        int n3 = this.tabPane.getTabPlacement();
        int n4 = this.tabPane.getSelectedIndex();
        int n5 = this.tabPane.getTabCount();
        block0 : switch (n3) {
            case 12: {
                this.selectNextTab(n4);
                break;
            }
            case 13: {
                this.selectPreviousTab(n4);
                break;
            }
            case 2: 
            case 4: {
                switch (n2) {
                    case 1: {
                        this.selectPreviousTabInRun(n4);
                        break block0;
                    }
                    case 5: {
                        this.selectNextTabInRun(n4);
                        break block0;
                    }
                    case 7: {
                        int n6 = this.getTabRunOffset(n3, n5, n4, false);
                        this.selectAdjacentRunTab(n3, n4, n6);
                        break block0;
                    }
                    case 3: {
                        int n7 = this.getTabRunOffset(n3, n5, n4, true);
                        this.selectAdjacentRunTab(n3, n4, n7);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (n2) {
                    case 1: {
                        int n8 = this.getTabRunOffset(n3, n5, n4, false);
                        this.selectAdjacentRunTab(n3, n4, n8);
                        break block0;
                    }
                    case 5: {
                        int n9 = this.getTabRunOffset(n3, n5, n4, true);
                        this.selectAdjacentRunTab(n3, n4, n9);
                        break block0;
                    }
                    case 3: {
                        this.selectNextTabInRun(n4);
                        break block0;
                    }
                    case 7: {
                        this.selectPreviousTabInRun(n4);
                        break block0;
                    }
                }
            }
        }
    }

    protected void selectNextTabInRun(int n2) {
        int n3 = this.tabPane.getTabCount();
        int n4 = this.getNextTabIndexInRun(n3, n2);
        while (n4 != n2 && !this.tabPane.isEnabledAt(n4)) {
            n4 = this.getNextTabIndexInRun(n3, n4);
        }
        this.tabPane.setSelectedIndex(n4);
    }

    protected void selectPreviousTabInRun(int n2) {
        int n3 = this.tabPane.getTabCount();
        int n4 = this.getPreviousTabIndexInRun(n3, n2);
        while (n4 != n2 && !this.tabPane.isEnabledAt(n4)) {
            n4 = this.getPreviousTabIndexInRun(n3, n4);
        }
        this.tabPane.setSelectedIndex(n4);
    }

    protected void selectNextTab(int n2) {
        int n3 = this.getNextTabIndex(n2);
        while (n3 != n2 && !this.tabPane.isEnabledAt(n3)) {
            n3 = this.getNextTabIndex(n3);
        }
        this.tabPane.setSelectedIndex(n3);
    }

    protected void selectPreviousTab(int n2) {
        int n3 = this.getPreviousTabIndex(n2);
        while (n3 != n2 && !this.tabPane.isEnabledAt(n3)) {
            n3 = this.getPreviousTabIndex(n3);
        }
        this.tabPane.setSelectedIndex(n3);
    }

    protected void selectAdjacentRunTab(int n2, int n3, int n4) {
        int n5;
        if (this.runCount < 2) {
            return;
        }
        Rectangle rectangle = this.rects[n3];
        switch (n2) {
            case 2: 
            case 4: {
                n5 = this.getTabAtLocation(rectangle.x + rectangle.width / 2 + n4, rectangle.y + rectangle.height / 2);
                break;
            }
            default: {
                n5 = this.getTabAtLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 + n4);
            }
        }
        if (n5 != -1) {
            while (!this.tabPane.isEnabledAt(n5) && n5 != n3) {
                n5 = this.getNextTabIndex(n5);
            }
            this.tabPane.setSelectedIndex(n5);
        }
    }

    protected int getTabRunOffset(int n2, int n3, int n4, boolean bl2) {
        int n5;
        int n6 = this.getRunForTab(n3, n4);
        switch (n2) {
            case 2: {
                if (n6 == 0) {
                    n5 = bl2 ? -(this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                if (n6 == this.runCount - 1) {
                    n5 = bl2 ? this.maxTabWidth : this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                n5 = bl2 ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 4: {
                if (n6 == 0) {
                    n5 = bl2 ? this.maxTabWidth : this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                if (n6 == this.runCount - 1) {
                    n5 = bl2 ? -(this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                n5 = bl2 ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 3: {
                if (n6 == 0) {
                    n5 = bl2 ? this.maxTabHeight : this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight) - this.maxTabHeight;
                    break;
                }
                if (n6 == this.runCount - 1) {
                    n5 = bl2 ? -(this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight;
                    break;
                }
                n5 = bl2 ? this.maxTabHeight : -this.maxTabHeight;
                break;
            }
            default: {
                n5 = n6 == 0 ? (bl2 ? -(this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight) : (n6 == this.runCount - 1 ? (bl2 ? this.maxTabHeight : this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight) - this.maxTabHeight) : (bl2 ? this.maxTabHeight : -this.maxTabHeight));
            }
        }
        return n5;
    }

    protected int getPreviousTabIndex(int n2) {
        int n3 = n2 - 1 >= 0 ? n2 - 1 : this.tabPane.getTabCount() - 1;
        return n3 >= 0 ? n3 : 0;
    }

    protected int getNextTabIndex(int n2) {
        return (n2 + 1) % this.tabPane.getTabCount();
    }

    protected int getNextTabIndexInRun(int n2, int n3) {
        if (this.runCount < 2) {
            return this.getNextTabIndex(n3);
        }
        int n4 = this.getRunForTab(n2, n3);
        int n5 = this.getNextTabIndex(n3);
        if (n5 == this.tabRuns[this.getNextTabRun(n4)]) {
            return this.tabRuns[n4];
        }
        return n5;
    }

    protected int getPreviousTabIndexInRun(int n2, int n3) {
        if (this.runCount < 2) {
            return this.getPreviousTabIndex(n3);
        }
        int n4 = this.getRunForTab(n2, n3);
        if (n3 == this.tabRuns[n4]) {
            int n5 = this.tabRuns[this.getNextTabRun(n4)] - 1;
            return n5 != -1 ? n5 : n2 - 1;
        }
        return this.getPreviousTabIndex(n3);
    }

    protected int getPreviousTabRun(int n2) {
        int n3 = n2 - 1 >= 0 ? n2 - 1 : this.runCount - 1;
        return n3 >= 0 ? n3 : 0;
    }

    protected int getNextTabRun(int n2) {
        return (n2 + 1) % this.runCount;
    }

    protected static void rotateInsets(Insets insets, Insets insets2, int n2) {
        switch (n2) {
            case 2: {
                insets2.top = insets.left;
                insets2.left = insets.top;
                insets2.bottom = insets.right;
                insets2.right = insets.bottom;
                break;
            }
            case 3: {
                insets2.top = insets.bottom;
                insets2.left = insets.left;
                insets2.bottom = insets.top;
                insets2.right = insets.right;
                break;
            }
            case 4: {
                insets2.top = insets.left;
                insets2.left = insets.bottom;
                insets2.bottom = insets.right;
                insets2.right = insets.top;
                break;
            }
            default: {
                insets2.top = insets.top;
                insets2.left = insets.left;
                insets2.bottom = insets.bottom;
                insets2.right = insets.right;
            }
        }
    }

    boolean requestFocusForVisibleComponent() {
        Component component = this.getVisibleComponent();
        if (component.isFocusTraversable()) {
            component.requestFocus();
            return true;
        }
        return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
    }

    private Vector createHTMLVector() {
        Vector vector = new Vector();
        int n2 = this.tabPane.getTabCount();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                String string = this.tabPane.getTitleAt(n3);
                if (BasicHTML.isHTMLString(string)) {
                    vector.addElement(BasicHTML.createHTMLView(this.tabPane, string));
                } else {
                    vector.addElement(null);
                }
                ++n3;
            }
        }
        return vector;
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            int n2 = jTabbedPane.indexOfComponent(component);
            String string = jTabbedPane.getTitleAt(n2);
            boolean bl2 = BasicHTML.isHTMLString(string);
            if (bl2) {
                if (BasicTabbedPaneUI.this.htmlViews == null) {
                    BasicTabbedPaneUI.this.htmlViews = BasicTabbedPaneUI.this.createHTMLVector();
                } else {
                    View view = BasicHTML.createHTMLView(jTabbedPane, string);
                    BasicTabbedPaneUI.this.htmlViews.insertElementAt(view, n2);
                }
            } else if (BasicTabbedPaneUI.this.htmlViews != null) {
                BasicTabbedPaneUI.this.htmlViews.insertElementAt(null, n2);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            int n2 = jTabbedPane.indexOfComponent(component);
            if (BasicTabbedPaneUI.this.htmlViews != null && BasicTabbedPaneUI.this.htmlViews.size() >= n2) {
                BasicTabbedPaneUI.this.htmlViews.removeElementAt(n2);
            }
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        public void focusGained(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n2 = jTabbedPane.getTabCount();
            if (n2 > 0 && n2 == BasicTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(BasicTabbedPaneUI.this.rects[jTabbedPane.getSelectedIndex()]);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n2 = jTabbedPane.getTabCount();
            if (n2 > 0 && n2 == BasicTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(BasicTabbedPaneUI.this.rects[jTabbedPane.getSelectedIndex()]);
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int n2 = BasicTabbedPaneUI.this.getTabAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n2 >= 0 && BasicTabbedPaneUI.this.tabPane.isEnabledAt(n2)) {
                if (n2 == BasicTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (BasicTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                        BasicTabbedPaneUI.this.tabPane.requestFocus();
                        BasicTabbedPaneUI.this.tabPane.repaint(BasicTabbedPaneUI.this.rects[n2]);
                    }
                } else {
                    BasicTabbedPaneUI.this.tabPane.setSelectedIndex(n2);
                }
            }
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            jTabbedPane.revalidate();
            jTabbedPane.repaint();
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if ("mnemonicAt".equals(string)) {
                BasicTabbedPaneUI.this.updateMnemonics();
                jTabbedPane.repaint();
            } else if ("displayedMnemonicIndexAt".equals(string)) {
                jTabbedPane.repaint();
            } else if (string.equals("indexForTitle")) {
                int n2 = (Integer)propertyChangeEvent.getNewValue();
                String string2 = BasicTabbedPaneUI.this.tabPane.getTitleAt(n2);
                if (BasicHTML.isHTMLString(string2)) {
                    if (BasicTabbedPaneUI.this.htmlViews == null) {
                        BasicTabbedPaneUI.this.htmlViews = BasicTabbedPaneUI.this.createHTMLVector();
                    } else {
                        View view = BasicHTML.createHTMLView(BasicTabbedPaneUI.this.tabPane, string2);
                        BasicTabbedPaneUI.this.htmlViews.setElementAt(view, n2);
                    }
                } else if (BasicTabbedPaneUI.this.htmlViews != null && BasicTabbedPaneUI.this.htmlViews.elementAt(n2) != null) {
                    BasicTabbedPaneUI.this.htmlViews.setElementAt(null, n2);
                }
                BasicTabbedPaneUI.this.updateMnemonics();
            } else if (string.equals("tabLayoutPolicy")) {
                BasicTabbedPaneUI.this.uninstallUI(jTabbedPane);
                BasicTabbedPaneUI.this.installUI(jTabbedPane);
            }
        }
    }

    private class ScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int n2) {
            super(n2, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
        }

        public boolean scrollsForward() {
            return this.direction == 3 || this.direction == 5;
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            this.setLayout(null);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            BasicTabbedPaneUI.this.paintTabArea(graphics, BasicTabbedPaneUI.this.tabPane.getTabPlacement(), BasicTabbedPaneUI.this.tabPane.getSelectedIndex());
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setScrollMode(0);
        }
    }

    private class ScrollableTabSupport
    implements ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public ScrollableTabButton scrollForwardButton;
        public ScrollableTabButton scrollBackwardButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int n2) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            if (n2 == 1 || n2 == 3) {
                this.scrollForwardButton = new ScrollableTabButton(3);
                this.scrollBackwardButton = new ScrollableTabButton(7);
            } else {
                this.scrollForwardButton = new ScrollableTabButton(5);
                this.scrollBackwardButton = new ScrollableTabButton(1);
            }
        }

        public void scrollForward(int n2) {
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            if (n2 == 1 || n2 == 3 ? rectangle.width >= dimension.width - rectangle.x : rectangle.height >= dimension.height - rectangle.y) {
                return;
            }
            this.setLeadingTabIndex(n2, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int n2) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(n2, this.leadingTabIndex - 1);
        }

        public void setLeadingTabIndex(int n2, int n3) {
            this.leadingTabIndex = n3;
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            switch (n2) {
                case 1: 
                case 3: {
                    int n4 = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : BasicTabbedPaneUI.this.rects[this.leadingTabIndex].x;
                    if (dimension.width - this.tabViewPosition.x >= rectangle.width) break;
                    Dimension dimension2 = new Dimension(dimension.width - this.tabViewPosition.x, rectangle.height);
                    this.viewport.setExtentSize(dimension2);
                    break;
                }
                case 2: 
                case 4: {
                    int n5 = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : BasicTabbedPaneUI.this.rects[this.leadingTabIndex].y;
                    if (dimension.height - this.tabViewPosition.y >= rectangle.height) break;
                    Dimension dimension3 = new Dimension(rectangle.width, dimension.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(dimension3);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            int n3 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            Rectangle rectangle = jViewport.getBounds();
            Dimension dimension = jViewport.getViewSize();
            Rectangle rectangle2 = jViewport.getViewRect();
            this.leadingTabIndex = BasicTabbedPaneUI.this.getClosestTab(rectangle2.x, rectangle2.y);
            if (this.leadingTabIndex + 1 < n3) {
                switch (n2) {
                    case 1: 
                    case 3: {
                        if (BasicTabbedPaneUI.this.rects[this.leadingTabIndex].x >= rectangle2.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (BasicTabbedPaneUI.this.rects[this.leadingTabIndex].y >= rectangle2.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets insets = BasicTabbedPaneUI.this.getContentBorderInsets(n2);
            switch (n2) {
                case 2: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x + rectangle.width, rectangle.y, insets.left, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 4: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x - insets.right, rectangle.y, insets.right, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 3: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y - insets.bottom, rectangle.width, insets.bottom);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y + rectangle.height, rectangle.width, insets.top);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                }
            }
        }

        public String toString() {
            return new String("viewport.viewSize=" + this.viewport.getViewSize() + "\n" + "viewport.viewRectangle=" + this.viewport.getViewRect() + "\n" + "leadingTabIndex=" + this.leadingTabIndex + "\n" + "tabViewPosition=" + this.tabViewPosition);
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private TabbedPaneScrollLayout() {
        }

        protected int preferredTabAreaHeight(int n2, int n3) {
            return BasicTabbedPaneUI.this.calculateMaxTabHeight(n2);
        }

        protected int preferredTabAreaWidth(int n2, int n3) {
            return BasicTabbedPaneUI.this.calculateMaxTabWidth(n2);
        }

        public void layoutContainer(Container container) {
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            int n3 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            int n4 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = BasicTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (n4 < 0) {
                if (component != null) {
                    BasicTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component component2 = BasicTabbedPaneUI.this.tabPane.getComponentAt(n4);
                boolean bl2 = false;
                if (component2 != null && component2 != component) {
                    if (component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl2 = true;
                    }
                    BasicTabbedPaneUI.this.setVisibleComponent(component2);
                }
                Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n2);
                Rectangle rectangle = BasicTabbedPaneUI.this.tabPane.getBounds();
                int n5 = BasicTabbedPaneUI.this.tabPane.getComponentCount();
                if (n5 > 0) {
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    switch (n2) {
                        case 2: {
                            n13 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n12 = rectangle.height - insets.top - insets.bottom;
                            n11 = insets.left;
                            n10 = insets.top;
                            n9 = n11 + n13 + insets2.left;
                            n8 = n10 + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - n13 - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 4: {
                            n13 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n12 = rectangle.height - insets.top - insets.bottom;
                            n11 = rectangle.width - insets.right - n13;
                            n10 = insets.top;
                            n9 = insets.left + insets2.left;
                            n8 = insets.top + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - n13 - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 3: {
                            n13 = rectangle.width - insets.left - insets.right;
                            n12 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n11 = insets.left;
                            n10 = rectangle.height - insets.bottom - n12;
                            n9 = insets.left + insets2.left;
                            n8 = insets.top + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - n12 - insets2.top - insets2.bottom;
                            break;
                        }
                        default: {
                            n13 = rectangle.width - insets.left - insets.right;
                            n12 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n11 = insets.left;
                            n10 = insets.top;
                            n9 = n11 + insets2.left;
                            n8 = n10 + n12 + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - n12 - insets2.top - insets2.bottom;
                        }
                    }
                    int n14 = 0;
                    while (n14 < n5) {
                        int n15;
                        int n16;
                        int n17;
                        int n18;
                        Cloneable cloneable;
                        JComponent jComponent;
                        Component component3 = BasicTabbedPaneUI.this.tabPane.getComponent(n14);
                        if (component3 instanceof ScrollableTabViewport) {
                            jComponent = (JViewport)component3;
                            cloneable = ((JViewport)jComponent).getViewRect();
                            n18 = n13;
                            n17 = n12;
                            switch (n2) {
                                case 2: 
                                case 4: {
                                    n16 = BasicTabbedPaneUI.this.rects[n3 - 1].y + BasicTabbedPaneUI.this.rects[n3 - 1].height;
                                    if (n16 <= n12 || n16 - cloneable.y > (n17 = Math.max(n12 - 36, 36))) break;
                                    n17 = n16 - cloneable.y;
                                    break;
                                }
                                default: {
                                    n15 = BasicTabbedPaneUI.this.rects[n3 - 1].x + BasicTabbedPaneUI.this.rects[n3 - 1].width;
                                    if (n15 <= n13 || n15 - cloneable.x > (n18 = Math.max(n13 - 36, 36))) break;
                                    n18 = n15 - cloneable.x;
                                }
                            }
                            component3.setBounds(n11, n10, n18, n17);
                        } else if (component3 instanceof ScrollableTabButton) {
                            jComponent = (ScrollableTabButton)component3;
                            cloneable = ((BasicArrowButton)jComponent).getPreferredSize();
                            n18 = 0;
                            n17 = 0;
                            n16 = ((Dimension)cloneable).width;
                            n15 = ((Dimension)cloneable).height;
                            boolean bl3 = false;
                            switch (n2) {
                                case 2: 
                                case 4: {
                                    int n19 = BasicTabbedPaneUI.this.rects[n3 - 1].y + BasicTabbedPaneUI.this.rects[n3 - 1].height;
                                    if (n19 <= n12) break;
                                    int n20 = ((ScrollableTabButton)jComponent).scrollsForward() ? 5 : 1;
                                    ((BasicArrowButton)jComponent).setDirection(n20);
                                    bl3 = true;
                                    n18 = n2 == 2 ? n11 + n13 - ((Dimension)cloneable).width : n11;
                                    n17 = n20 == 5 ? rectangle.height - insets.bottom - ((Dimension)cloneable).height : rectangle.height - insets.bottom - 2 * ((Dimension)cloneable).height;
                                    break;
                                }
                                default: {
                                    int n20 = BasicTabbedPaneUI.this.rects[n3 - 1].x + BasicTabbedPaneUI.this.rects[n3 - 1].width;
                                    if (n20 <= n13) break;
                                    int n21 = ((ScrollableTabButton)jComponent).scrollsForward() ? 3 : 7;
                                    ((BasicArrowButton)jComponent).setDirection(n21);
                                    bl3 = true;
                                    n18 = n21 == 3 ? rectangle.width - insets.left - ((Dimension)cloneable).width : rectangle.width - insets.left - 2 * ((Dimension)cloneable).width;
                                    n17 = n2 == 1 ? n10 + n12 - ((Dimension)cloneable).height : n10;
                                }
                            }
                            component3.setVisible(bl3);
                            if (bl3) {
                                component3.setBounds(n18, n17, n16, n15);
                            }
                        } else {
                            component3.setBounds(n9, n8, n7, n6);
                        }
                        ++n14;
                    }
                    if (bl2 && !BasicTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                        BasicTabbedPaneUI.this.tabPane.requestFocus();
                    }
                }
            }
        }

        protected void calculateTabRects(int n2, int n3) {
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = BasicTabbedPaneUI.this.tabPane.getSize();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getTabAreaInsets(n2);
            int n4 = fontMetrics.getHeight();
            int n5 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean bl2 = n2 == 2 || n2 == 4;
            boolean bl3 = BasicGraphicsUtils.isLeftToRight(BasicTabbedPaneUI.this.tabPane);
            int n6 = insets2.left;
            int n7 = insets2.top;
            int n8 = 0;
            int n9 = 0;
            switch (n2) {
                case 2: 
                case 4: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n2);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n2);
                }
            }
            BasicTabbedPaneUI.this.runCount = 0;
            BasicTabbedPaneUI.this.selectedRun = -1;
            if (n3 == 0) {
                return;
            }
            BasicTabbedPaneUI.this.selectedRun = 0;
            BasicTabbedPaneUI.this.runCount = 1;
            int n10 = 0;
            while (n10 < n3) {
                Rectangle rectangle = BasicTabbedPaneUI.this.rects[n10];
                if (!bl2) {
                    if (n10 > 0) {
                        rectangle.x = BasicTabbedPaneUI.this.rects[n10 - 1].x + BasicTabbedPaneUI.this.rects[n10 - 1].width;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.maxTabWidth = 0;
                        n9 += BasicTabbedPaneUI.this.maxTabHeight;
                        rectangle.x = n6;
                    }
                    rectangle.width = BasicTabbedPaneUI.this.calculateTabWidth(n2, n10, fontMetrics);
                    n8 = rectangle.x + rectangle.width;
                    BasicTabbedPaneUI.this.maxTabWidth = Math.max(BasicTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    rectangle.y = n7;
                    rectangle.height = BasicTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (n10 > 0) {
                        rectangle.y = BasicTabbedPaneUI.this.rects[n10 - 1].y + BasicTabbedPaneUI.this.rects[n10 - 1].height;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.maxTabHeight = 0;
                        n8 = BasicTabbedPaneUI.this.maxTabWidth;
                        rectangle.y = n7;
                    }
                    rectangle.height = BasicTabbedPaneUI.this.calculateTabHeight(n2, n10, n4);
                    n9 = rectangle.y + rectangle.height;
                    BasicTabbedPaneUI.this.maxTabHeight = Math.max(BasicTabbedPaneUI.this.maxTabHeight, rectangle.height);
                    rectangle.x = n6;
                    rectangle.width = BasicTabbedPaneUI.this.maxTabWidth;
                }
                ++n10;
            }
            if (!bl3 && !bl2) {
                int n11 = dimension.width - (insets.right + insets2.right);
                n10 = 0;
                while (n10 < n3) {
                    BasicTabbedPaneUI.this.rects[n10].x = n11 - BasicTabbedPaneUI.this.rects[n10].x - BasicTabbedPaneUI.this.rects[n10].width;
                    ++n10;
                }
            }
            ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.tabPanel.setPreferredSize(new Dimension(n8, n9));
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.calculateSize(false);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.calculateSize(true);
        }

        protected Dimension calculateSize(boolean bl2) {
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n2);
            Insets insets3 = BasicTabbedPaneUI.this.getTabAreaInsets(n2);
            Dimension dimension = new Dimension(0, 0);
            int n3 = insets2.top + insets2.bottom;
            int n4 = insets2.left + insets2.right;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < BasicTabbedPaneUI.this.tabPane.getTabCount()) {
                Component component = BasicTabbedPaneUI.this.tabPane.getComponentAt(n7);
                if (component != null) {
                    Dimension dimension2 = dimension;
                    Dimension dimension3 = dimension2 = bl2 ? component.getMinimumSize() : component.getPreferredSize();
                    if (dimension2 != null) {
                        n6 = Math.max(dimension2.height, n6);
                        n5 = Math.max(dimension2.width, n5);
                    }
                }
                ++n7;
            }
            n4 += n5;
            n3 += n6;
            int n8 = 0;
            switch (n2) {
                case 2: 
                case 4: {
                    n3 = Math.max(n3, BasicTabbedPaneUI.this.calculateMaxTabHeight(n2) + insets3.top + insets3.bottom);
                    n8 = this.preferredTabAreaWidth(n2, n3);
                    n4 += n8;
                    break;
                }
                default: {
                    n4 = Math.max(n4, BasicTabbedPaneUI.this.calculateMaxTabWidth(n2) + insets3.left + insets3.right);
                    n8 = this.preferredTabAreaHeight(n2, n4);
                    n3 += n8;
                }
            }
            return new Dimension(n4 + insets.left + insets.right, n3 + insets.bottom + insets.top);
        }

        protected int preferredTabAreaHeight(int n2, int n3) {
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            int n4 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            int n5 = 0;
            if (n4 > 0) {
                int n6 = 1;
                int n7 = 0;
                int n8 = BasicTabbedPaneUI.this.calculateMaxTabHeight(n2);
                int n9 = 0;
                while (n9 < n4) {
                    int n10 = BasicTabbedPaneUI.this.calculateTabWidth(n2, n9, fontMetrics);
                    if (n7 != 0 && n7 + n10 > n3) {
                        ++n6;
                        n7 = 0;
                    }
                    n7 += n10;
                    ++n9;
                }
                n5 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n2, n6, n8);
            }
            return n5;
        }

        protected int preferredTabAreaWidth(int n2, int n3) {
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            int n4 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            int n5 = 0;
            if (n4 > 0) {
                int n6 = 1;
                int n7 = 0;
                int n8 = fontMetrics.getHeight();
                BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n2);
                int n9 = 0;
                while (n9 < n4) {
                    int n10 = BasicTabbedPaneUI.this.calculateTabHeight(n2, n9, n8);
                    if (n7 != 0 && n7 + n10 > n3) {
                        ++n6;
                        n7 = 0;
                    }
                    n7 += n10;
                    ++n9;
                }
                n5 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n2, n6, BasicTabbedPaneUI.this.maxTabWidth);
            }
            return n5;
        }

        public void layoutContainer(Container container) {
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            int n3 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = BasicTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (n3 < 0) {
                if (component != null) {
                    BasicTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                int n4 = 0;
                int n5 = 0;
                Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n2);
                Component component2 = BasicTabbedPaneUI.this.tabPane.getComponentAt(n3);
                boolean bl2 = false;
                if (component2 != null && component2 != component) {
                    if (component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl2 = true;
                    }
                    BasicTabbedPaneUI.this.setVisibleComponent(component2);
                }
                Rectangle rectangle = BasicTabbedPaneUI.this.tabPane.getBounds();
                int n6 = BasicTabbedPaneUI.this.tabPane.getComponentCount();
                if (n6 > 0) {
                    int n7;
                    int n8;
                    switch (n2) {
                        case 2: {
                            n4 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n8 = insets.left + n4 + insets2.left;
                            n7 = insets.top + insets2.top;
                            break;
                        }
                        case 4: {
                            n4 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + insets2.top;
                            break;
                        }
                        case 3: {
                            n5 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + insets2.top;
                            break;
                        }
                        default: {
                            n5 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + n5 + insets2.top;
                        }
                    }
                    int n9 = rectangle.width - n4 - insets.left - insets.right - insets2.left - insets2.right;
                    int n10 = rectangle.height - n5 - insets.top - insets.bottom - insets2.top - insets2.bottom;
                    int n11 = 0;
                    while (n11 < n6) {
                        Component component3 = BasicTabbedPaneUI.this.tabPane.getComponent(n11);
                        component3.setBounds(n8, n7, n9, n10);
                        ++n11;
                    }
                }
                if (bl2 && !BasicTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                    BasicTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        public void calculateLayoutInfo() {
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            BasicTabbedPaneUI.this.assureRectsCreated(n2);
            this.calculateTabRects(BasicTabbedPaneUI.this.tabPane.getTabPlacement(), n2);
        }

        protected void calculateTabRects(int n2, int n3) {
            int n4;
            Rectangle rectangle;
            int n5;
            int n6;
            int n7;
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = BasicTabbedPaneUI.this.tabPane.getSize();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getTabAreaInsets(n2);
            int n8 = fontMetrics.getHeight();
            int n9 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean bl2 = n2 == 2 || n2 == 4;
            boolean bl3 = BasicGraphicsUtils.isLeftToRight(BasicTabbedPaneUI.this.tabPane);
            switch (n2) {
                case 2: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n2);
                    n7 = insets.left + insets2.left;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n2);
                    n7 = dimension.width - insets.right - insets2.right - BasicTabbedPaneUI.this.maxTabWidth;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n2);
                    n7 = insets.left + insets2.left;
                    n6 = dimension.height - insets.bottom - insets2.bottom - BasicTabbedPaneUI.this.maxTabHeight;
                    n5 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n2);
                    n7 = insets.left + insets2.left;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.width - (insets.right + insets2.right);
                }
            }
            int n10 = BasicTabbedPaneUI.this.getTabRunOverlay(n2);
            BasicTabbedPaneUI.this.runCount = 0;
            BasicTabbedPaneUI.this.selectedRun = -1;
            if (n3 == 0) {
                return;
            }
            int n11 = 0;
            while (n11 < n3) {
                rectangle = BasicTabbedPaneUI.this.rects[n11];
                if (!bl2) {
                    if (n11 > 0) {
                        rectangle.x = BasicTabbedPaneUI.this.rects[n11 - 1].x + BasicTabbedPaneUI.this.rects[n11 - 1].width;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.runCount = 1;
                        BasicTabbedPaneUI.this.maxTabWidth = 0;
                        rectangle.x = n7;
                    }
                    rectangle.width = BasicTabbedPaneUI.this.calculateTabWidth(n2, n11, fontMetrics);
                    BasicTabbedPaneUI.this.maxTabWidth = Math.max(BasicTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    if (rectangle.x != 2 + insets.left && rectangle.x + rectangle.width > n5) {
                        if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount] = n11;
                        ++BasicTabbedPaneUI.this.runCount;
                        rectangle.x = n7;
                    }
                    rectangle.y = n6;
                    rectangle.height = BasicTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (n11 > 0) {
                        rectangle.y = BasicTabbedPaneUI.this.rects[n11 - 1].y + BasicTabbedPaneUI.this.rects[n11 - 1].height;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.runCount = 1;
                        BasicTabbedPaneUI.this.maxTabHeight = 0;
                        rectangle.y = n6;
                    }
                    rectangle.height = BasicTabbedPaneUI.this.calculateTabHeight(n2, n11, n8);
                    BasicTabbedPaneUI.this.maxTabHeight = Math.max(BasicTabbedPaneUI.this.maxTabHeight, rectangle.height);
                    if (rectangle.y != 2 + insets.top && rectangle.y + rectangle.height > n5) {
                        if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount] = n11;
                        ++BasicTabbedPaneUI.this.runCount;
                        rectangle.y = n6;
                    }
                    rectangle.x = n7;
                    rectangle.width = BasicTabbedPaneUI.this.maxTabWidth;
                }
                if (n11 == n9) {
                    BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.runCount - 1;
                }
                ++n11;
            }
            if (BasicTabbedPaneUI.this.runCount > 1) {
                this.normalizeTabRuns(n2, n3, bl2 ? n6 : n7, n5);
                BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.getRunForTab(n3, n9);
                if (BasicTabbedPaneUI.this.shouldRotateTabRuns(n2)) {
                    this.rotateTabRuns(n2, BasicTabbedPaneUI.this.selectedRun);
                }
            }
            n11 = BasicTabbedPaneUI.this.runCount - 1;
            while (n11 >= 0) {
                int n12;
                int n13;
                n4 = BasicTabbedPaneUI.this.tabRuns[n11];
                int n14 = BasicTabbedPaneUI.this.tabRuns[n11 == BasicTabbedPaneUI.this.runCount - 1 ? 0 : n11 + 1];
                int n15 = n13 = n14 != 0 ? n14 - 1 : n3 - 1;
                if (!bl2) {
                    n12 = n4;
                    while (n12 <= n13) {
                        rectangle = BasicTabbedPaneUI.this.rects[n12];
                        rectangle.y = n6;
                        rectangle.x += BasicTabbedPaneUI.this.getTabRunIndent(n2, n11);
                        ++n12;
                    }
                    if (BasicTabbedPaneUI.this.shouldPadTabRun(n2, n11)) {
                        this.padTabRun(n2, n4, n13, n5);
                    }
                    n6 = n2 == 3 ? (n6 -= BasicTabbedPaneUI.this.maxTabHeight - n10) : (n6 += BasicTabbedPaneUI.this.maxTabHeight - n10);
                } else {
                    n12 = n4;
                    while (n12 <= n13) {
                        rectangle = BasicTabbedPaneUI.this.rects[n12];
                        rectangle.x = n7;
                        rectangle.y += BasicTabbedPaneUI.this.getTabRunIndent(n2, n11);
                        ++n12;
                    }
                    if (BasicTabbedPaneUI.this.shouldPadTabRun(n2, n11)) {
                        this.padTabRun(n2, n4, n13, n5);
                    }
                    n7 = n2 == 4 ? (n7 -= BasicTabbedPaneUI.this.maxTabWidth - n10) : (n7 += BasicTabbedPaneUI.this.maxTabWidth - n10);
                }
                --n11;
            }
            this.padSelectedTab(n2, n9);
            if (!bl3 && !bl2) {
                n4 = dimension.width - (insets.right + insets2.right);
                n11 = 0;
                while (n11 < n3) {
                    BasicTabbedPaneUI.this.rects[n11].x = n4 - BasicTabbedPaneUI.this.rects[n11].x - BasicTabbedPaneUI.this.rects[n11].width;
                    ++n11;
                }
            }
        }

        protected void rotateTabRuns(int n2, int n3) {
            int n4 = 0;
            while (n4 < n3) {
                int n5 = BasicTabbedPaneUI.this.tabRuns[0];
                int n6 = 1;
                while (n6 < BasicTabbedPaneUI.this.runCount) {
                    BasicTabbedPaneUI.this.tabRuns[n6 - 1] = BasicTabbedPaneUI.this.tabRuns[n6];
                    ++n6;
                }
                BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount - 1] = n5;
                ++n4;
            }
        }

        protected void normalizeTabRuns(int n2, int n3, int n4, int n5) {
            boolean bl2 = n2 == 2 || n2 == 4;
            int n6 = BasicTabbedPaneUI.this.runCount - 1;
            boolean bl3 = true;
            double d2 = 1.25;
            while (bl3) {
                int n7;
                int n8;
                int n9 = BasicTabbedPaneUI.this.lastTabInRun(n3, n6);
                int n10 = BasicTabbedPaneUI.this.lastTabInRun(n3, n6 - 1);
                if (!bl2) {
                    n8 = BasicTabbedPaneUI.this.rects[n9].x + BasicTabbedPaneUI.this.rects[n9].width;
                    n7 = (int)((double)BasicTabbedPaneUI.this.maxTabWidth * d2);
                } else {
                    n8 = BasicTabbedPaneUI.this.rects[n9].y + BasicTabbedPaneUI.this.rects[n9].height;
                    n7 = (int)((double)BasicTabbedPaneUI.this.maxTabHeight * d2 * 2.0);
                }
                if (n5 - n8 > n7) {
                    BasicTabbedPaneUI.this.tabRuns[n6] = n10;
                    if (!bl2) {
                        BasicTabbedPaneUI.this.rects[n10].x = n4;
                    } else {
                        BasicTabbedPaneUI.this.rects[n10].y = n4;
                    }
                    int n11 = n10 + 1;
                    while (n11 <= n9) {
                        if (!bl2) {
                            BasicTabbedPaneUI.this.rects[n11].x = BasicTabbedPaneUI.this.rects[n11 - 1].x + BasicTabbedPaneUI.this.rects[n11 - 1].width;
                        } else {
                            BasicTabbedPaneUI.this.rects[n11].y = BasicTabbedPaneUI.this.rects[n11 - 1].y + BasicTabbedPaneUI.this.rects[n11 - 1].height;
                        }
                        ++n11;
                    }
                } else if (n6 == BasicTabbedPaneUI.this.runCount - 1) {
                    bl3 = false;
                }
                if (n6 - 1 > 0) {
                    --n6;
                    continue;
                }
                n6 = BasicTabbedPaneUI.this.runCount - 1;
                d2 += 0.25;
            }
        }

        protected void padTabRun(int n2, int n3, int n4, int n5) {
            Rectangle rectangle = BasicTabbedPaneUI.this.rects[n4];
            if (n2 == 1 || n2 == 3) {
                int n6 = rectangle.x + rectangle.width - BasicTabbedPaneUI.this.rects[n3].x;
                int n7 = n5 - (rectangle.x + rectangle.width);
                float f2 = (float)n7 / (float)n6;
                int n8 = n3;
                while (n8 <= n4) {
                    Rectangle rectangle2 = BasicTabbedPaneUI.this.rects[n8];
                    if (n8 > n3) {
                        rectangle2.x = BasicTabbedPaneUI.this.rects[n8 - 1].x + BasicTabbedPaneUI.this.rects[n8 - 1].width;
                    }
                    rectangle2.width += Math.round((float)rectangle2.width * f2);
                    ++n8;
                }
                rectangle.width = n5 - rectangle.x;
            } else {
                int n9 = rectangle.y + rectangle.height - BasicTabbedPaneUI.this.rects[n3].y;
                int n10 = n5 - (rectangle.y + rectangle.height);
                float f3 = (float)n10 / (float)n9;
                int n11 = n3;
                while (n11 <= n4) {
                    Rectangle rectangle3 = BasicTabbedPaneUI.this.rects[n11];
                    if (n11 > n3) {
                        rectangle3.y = BasicTabbedPaneUI.this.rects[n11 - 1].y + BasicTabbedPaneUI.this.rects[n11 - 1].height;
                    }
                    rectangle3.height += Math.round((float)rectangle3.height * f3);
                    ++n11;
                }
                rectangle.height = n5 - rectangle.y;
            }
        }

        protected void padSelectedTab(int n2, int n3) {
            if (n3 >= 0) {
                Rectangle rectangle = BasicTabbedPaneUI.this.rects[n3];
                Insets insets = BasicTabbedPaneUI.this.getSelectedTabPadInsets(n2);
                rectangle.x -= insets.left;
                rectangle.width += insets.left + insets.right;
                rectangle.y -= insets.top;
                rectangle.height += insets.top + insets.bottom;
            }
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        private ScrollTabsBackwardAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof ScrollableTabButton) {
                jTabbedPane = (JTabbedPane)((ScrollableTabButton)object).getParent();
            } else {
                return;
            }
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            if (basicTabbedPaneUI.scrollableTabLayoutEnabled()) {
                basicTabbedPaneUI.tabScroller.scrollBackward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        private ScrollTabsForwardAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof ScrollableTabButton) {
                jTabbedPane = (JTabbedPane)((ScrollableTabButton)object).getParent();
            } else {
                return;
            }
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            if (basicTabbedPaneUI.scrollableTabLayoutEnabled()) {
                basicTabbedPaneUI.tabScroller.scrollForward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private static class SetSelectedIndexAction
    extends AbstractAction {
        private SetSelectedIndexAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            if (jTabbedPane != null && jTabbedPane.getUI() instanceof BasicTabbedPaneUI) {
                BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
                String string = actionEvent.getActionCommand();
                if (string != null && string.length() > 0) {
                    Integer n2;
                    int n3 = actionEvent.getActionCommand().charAt(0);
                    if (n3 >= 97 && n3 <= 122) {
                        n3 -= 32;
                    }
                    if ((n2 = (Integer)basicTabbedPaneUI.mnemonicToIndexMap.get(new Integer(n3))) != null) {
                        jTabbedPane.setSelectedIndex(n2);
                    }
                }
            }
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        private RequestFocusForVisibleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.requestFocusForVisibleComponent();
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        private RequestFocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            jTabbedPane.requestFocus();
        }
    }

    private static class PageDownAction
    extends AbstractAction {
        private PageDownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            int n2 = jTabbedPane.getTabPlacement();
            if (n2 == 1 || n2 == 3) {
                basicTabbedPaneUI.navigateSelectedTab(3);
            } else {
                basicTabbedPaneUI.navigateSelectedTab(5);
            }
        }
    }

    private static class PageUpAction
    extends AbstractAction {
        private PageUpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            int n2 = jTabbedPane.getTabPlacement();
            if (n2 == 1 || n2 == 3) {
                basicTabbedPaneUI.navigateSelectedTab(7);
            } else {
                basicTabbedPaneUI.navigateSelectedTab(1);
            }
        }
    }

    private static class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(13);
        }
    }

    private static class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(12);
        }
    }

    private static class DownAction
    extends AbstractAction {
        private DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(5);
        }
    }

    private static class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(1);
        }
    }

    private static class LeftAction
    extends AbstractAction {
        private LeftAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(7);
        }
    }

    private static class RightAction
    extends AbstractAction {
        private RightAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(3);
        }
    }
}

