/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import sun.security.action.LoadLibraryAction;

public class ZipFile
implements ZipConstants {
    private long jzfile;
    private String name;
    private int total;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private Vector inflaters = new Vector();

    private static native void initIDs();

    public ZipFile(String string) throws IOException {
        this(new File(string), 1);
    }

    public ZipFile(File file, int n2) throws IOException {
        if ((n2 & 1) == 0 || (n2 & 0xFFFFFFFA) != 0) {
            throw new IllegalArgumentException("Illegal mode: 0x" + Integer.toHexString(n2));
        }
        String string = file.getPath();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
            if ((n2 & 4) != 0) {
                securityManager.checkDelete(string);
            }
        }
        this.jzfile = ZipFile.open(string, n2, file.lastModified());
        this.name = string;
        this.total = ZipFile.getTotal(this.jzfile);
    }

    private static native long open(String var0, int var1, long var2);

    private static native int getTotal(long var0);

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    public ZipEntry getEntry(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (this.jzfile == 0L) {
            throw new IllegalStateException("zip file closed");
        }
        long l2 = ZipFile.getEntry(this.jzfile, string);
        if (l2 == 0L && !string.endsWith("/")) {
            l2 = ZipFile.getEntry(this.jzfile, string + "/");
        }
        if (l2 != 0L) {
            ZipEntry zipEntry = new ZipEntry(string, l2);
            ZipFile.freeEntry(this.jzfile, l2);
            return zipEntry;
        }
        return null;
    }

    private static native long getEntry(long var0, String var2);

    private static native void freeEntry(long var0, long var2);

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return this.getInputStream(zipEntry.name);
    }

    private InputStream getInputStream(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.ensureOpen(this.jzfile);
        long l2 = ZipFile.getEntry(this.jzfile, string);
        if (l2 == 0L) {
            return null;
        }
        ZipFileInputStream zipFileInputStream = new ZipFileInputStream(this.jzfile, l2, this);
        switch (ZipFile.getMethod(l2)) {
            case 0: {
                return zipFileInputStream;
            }
            case 8: {
                return new InflaterInputStream(zipFileInputStream, this.getInflater()){
                    private boolean isClosed;
                    private boolean eof;
                    {
                        this.isClosed = false;
                    }

                    public void close() throws IOException {
                        if (!this.isClosed) {
                            ZipFile.this.releaseInflater(this.inf);
                            this.in.close();
                            this.isClosed = true;
                        }
                    }

                    protected void fill() throws IOException {
                        if (this.eof) {
                            throw new EOFException("Unexpected end of ZLIB input stream");
                        }
                        this.len = this.in.read(this.buf, 0, this.buf.length);
                        if (this.len == -1) {
                            this.buf[0] = 0;
                            this.len = 1;
                            this.eof = true;
                        }
                        this.inf.setInput(this.buf, 0, this.len);
                    }

                    public int available() throws IOException {
                        if (super.available() != 0) {
                            return this.in.available();
                        }
                        return 0;
                    }
                };
            }
        }
        throw new ZipException("invalid compression method");
    }

    private static native int getMethod(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inflater getInflater() {
        Vector vector = this.inflaters;
        synchronized (vector) {
            block4: {
                int n2 = this.inflaters.size();
                if (n2 <= 0) break block4;
                Inflater inflater = (Inflater)this.inflaters.remove(n2 - 1);
                inflater.reset();
                Inflater inflater2 = inflater;
                return inflater2;
            }
            Inflater inflater = new Inflater(true);
            return inflater;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInflater(Inflater inflater) {
        Vector vector = this.inflaters;
        synchronized (vector) {
            this.inflaters.add(inflater);
        }
    }

    public String getName() {
        return this.name;
    }

    public Enumeration entries() {
        this.ensureOpen(this.jzfile);
        return new Enumeration(){
            private int i = 0;

            public boolean hasMoreElements() {
                ZipFile.this.ensureOpen(ZipFile.this.jzfile);
                return this.i < ZipFile.this.total;
            }

            public Object nextElement() throws NoSuchElementException {
                ZipFile.this.ensureOpen(ZipFile.this.jzfile);
                if (this.i >= ZipFile.this.total) {
                    throw new NoSuchElementException();
                }
                long l2 = ZipFile.getNextEntry(ZipFile.this.jzfile, this.i++);
                if (l2 == 0L) {
                    String string = ZipFile.this.jzfile == 0L ? "ZipFile concurrently closed" : ZipFile.getZipMessage(ZipFile.this.jzfile);
                    throw new InternalError("jzentry == 0,\n jzfile = " + ZipFile.this.jzfile + ",\n total = " + ZipFile.this.total + ",\n name = " + ZipFile.this.name + ",\n i = " + this.i + ",\n message = " + string);
                }
                ZipEntry zipEntry = new ZipEntry(l2);
                ZipFile.freeEntry(ZipFile.this.jzfile, l2);
                return zipEntry;
            }
        };
    }

    private static native long getNextEntry(long var0, int var2);

    public int size() {
        if (this.jzfile == 0L) {
            throw new IllegalStateException("zip file closed");
        }
        return this.total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.jzfile != 0L) {
            long l2 = this.jzfile;
            this.jzfile = 0L;
            ZipFile.close(l2);
            Vector vector = this.inflaters;
            synchronized (vector) {
                int n2 = this.inflaters.size();
                int n3 = 0;
                while (n3 < n2) {
                    Inflater inflater = (Inflater)this.inflaters.get(n3);
                    inflater.end();
                    ++n3;
                }
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private static native void close(long var0);

    private void ensureOpen(long l2) {
        if (l2 == 0L) {
            throw new IllegalStateException("zip file closed");
        }
    }

    private static native int read(long var0, long var2, int var4, byte[] var5, int var6, int var7);

    private static native int getCSize(long var0);

    private static native int getSize(long var0);

    private static native String getZipMessage(long var0);

    static {
        AccessController.doPrivileged(new LoadLibraryAction("zip"));
        ZipFile.initIDs();
    }

    private static class ZipFileInputStream
    extends InputStream {
        private long jzfile;
        private long jzentry;
        private int pos;
        private int rem;
        private int size;
        private ZipFile handle;

        ZipFileInputStream(long l2, long l3, ZipFile zipFile) {
            this.jzfile = l2;
            this.jzentry = l3;
            this.pos = 0;
            this.rem = ZipFile.getCSize(l3);
            this.size = ZipFile.getSize(l3);
            this.handle = zipFile;
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (this.rem == 0) {
                return -1;
            }
            if (n3 <= 0) {
                return 0;
            }
            if (n3 > this.rem) {
                n3 = this.rem;
            }
            if ((n3 = ZipFile.read(this.jzfile, this.jzentry, this.pos, byArray, n2, n3)) > 0) {
                this.pos += n3;
                this.rem -= n3;
            }
            if (this.rem == 0) {
                this.cleanup();
            }
            return n3;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        public long skip(long l2) {
            int n2 = l2 > (long)this.rem ? this.rem : (int)l2;
            this.pos += n2;
            this.rem -= n2;
            if (this.rem == 0) {
                this.cleanup();
            }
            return n2;
        }

        public int available() {
            return this.size;
        }

        private void cleanup() {
            this.rem = 0;
            if (this.jzentry != 0L) {
                ZipFile.freeEntry(this.jzfile, this.jzentry);
                this.jzentry = 0L;
            }
        }

        public void close() {
            this.cleanup();
        }
    }
}

