/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public class MultiPixelPackedSampleModel
extends SampleModel {
    int pixelBitStride;
    int bitMask;
    int pixelsPerDataElement;
    int dataElementSize;
    int dataBitOffset;
    int scanlineStride;

    public MultiPixelPackedSampleModel(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, (n3 * n5 + DataBuffer.getDataTypeSize(n2) - 1) / DataBuffer.getDataTypeSize(n2), 0);
        if (n2 != 0 && n2 != 1 && n2 != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n2);
        }
    }

    public MultiPixelPackedSampleModel(int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n2, n3, n4, 1);
        if (n2 != 0 && n2 != 1 && n2 != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n2);
        }
        this.dataType = n2;
        this.pixelBitStride = n5;
        this.scanlineStride = n6;
        this.dataBitOffset = n7;
        this.dataElementSize = DataBuffer.getDataTypeSize(n2);
        this.pixelsPerDataElement = this.dataElementSize / n5;
        if (this.pixelsPerDataElement * n5 != this.dataElementSize) {
            throw new RasterFormatException("MultiPixelPackedSampleModel does not allow pixels to span data element boundaries");
        }
        this.bitMask = (1 << n5) - 1;
    }

    public SampleModel createCompatibleSampleModel(int n2, int n3) {
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(this.dataType, n2, n3, this.pixelBitStride);
        return multiPixelPackedSampleModel;
    }

    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n2 = this.scanlineStride * this.height;
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n2 + (this.dataBitOffset + 7) / 8);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n2 + (this.dataBitOffset + 15) / 16);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n2 + (this.dataBitOffset + 31) / 32);
            }
        }
        return dataBuffer;
    }

    public int getNumDataElements() {
        return 1;
    }

    public int[] getSampleSize() {
        int[] nArray = new int[]{this.pixelBitStride};
        return nArray;
    }

    public int getSampleSize(int n2) {
        return this.pixelBitStride;
    }

    public int getOffset(int n2, int n3) {
        int n4 = n3 * this.scanlineStride;
        return n4 += (n2 * this.pixelBitStride + this.dataBitOffset) / this.dataElementSize;
    }

    public int getBitOffset(int n2) {
        return (n2 * this.pixelBitStride + this.dataBitOffset) % this.dataElementSize;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelBitStride() {
        return this.pixelBitStride;
    }

    public int getDataBitOffset() {
        return this.dataBitOffset;
    }

    public int getTransferType() {
        if (this.pixelBitStride > 16) {
            return 3;
        }
        if (this.pixelBitStride > 8) {
            return 1;
        }
        return 0;
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray != null && nArray.length != 1) {
            throw new RasterFormatException("MultiPixelPackedSampleModel has only one band.");
        }
        SampleModel sampleModel = this.createCompatibleSampleModel(this.width, this.height);
        return sampleModel;
    }

    public int getSample(int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height || n4 != 0) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = this.dataBitOffset + n2 * this.pixelBitStride;
        int n6 = dataBuffer.getElem(n3 * this.scanlineStride + n5 / this.dataElementSize);
        int n7 = this.dataElementSize - (n5 & this.dataElementSize - 1) - this.pixelBitStride;
        return n6 >> n7 & this.bitMask;
    }

    public void setSample(int n2, int n3, int n4, int n5, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height || n4 != 0) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = this.dataBitOffset + n2 * this.pixelBitStride;
        int n7 = n3 * this.scanlineStride + n6 / this.dataElementSize;
        int n8 = this.dataElementSize - (n6 & this.dataElementSize - 1) - this.pixelBitStride;
        int n9 = dataBuffer.getElem(n7);
        n9 &= ~(this.bitMask << n8);
        dataBuffer.setElem(n7, n9 |= (n5 & this.bitMask) << n8);
    }

    public Object getDataElements(int n2, int n3, Object object, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = this.getTransferType();
        int n5 = this.dataBitOffset + n2 * this.pixelBitStride;
        int n6 = this.dataElementSize - (n5 & this.dataElementSize - 1) - this.pixelBitStride;
        int n7 = 0;
        switch (n4) {
            case 0: {
                byte[] byArray = object == null ? new byte[1] : (byte[])object;
                n7 = dataBuffer.getElem(n3 * this.scanlineStride + n5 / this.dataElementSize);
                byArray[0] = (byte)(n7 >> n6 & this.bitMask);
                object = byArray;
                break;
            }
            case 1: {
                short[] sArray = object == null ? new short[1] : (short[])object;
                n7 = dataBuffer.getElem(n3 * this.scanlineStride + n5 / this.dataElementSize);
                sArray[0] = (short)(n7 >> n6 & this.bitMask);
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[1] : (int[])object;
                n7 = dataBuffer.getElem(n3 * this.scanlineStride + n5 / this.dataElementSize);
                nArray[0] = n7 >> n6 & this.bitMask;
                object = nArray;
            }
        }
        return object;
    }

    public int[] getPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands];
        int n4 = this.dataBitOffset + n2 * this.pixelBitStride;
        int n5 = dataBuffer.getElem(n3 * this.scanlineStride + n4 / this.dataElementSize);
        int n6 = this.dataElementSize - (n4 & this.dataElementSize - 1) - this.pixelBitStride;
        nArray2[0] = n5 >> n6 & this.bitMask;
        return nArray2;
    }

    public void setDataElements(int n2, int n3, Object object, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = this.getTransferType();
        int n5 = this.dataBitOffset + n2 * this.pixelBitStride;
        int n6 = n3 * this.scanlineStride + n5 / this.dataElementSize;
        int n7 = this.dataElementSize - (n5 & this.dataElementSize - 1) - this.pixelBitStride;
        int n8 = dataBuffer.getElem(n6);
        n8 &= ~(this.bitMask << n7);
        switch (n4) {
            case 0: {
                byte[] byArray = (byte[])object;
                dataBuffer.setElem(n6, n8 |= (byArray[0] & 0xFF & this.bitMask) << n7);
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                dataBuffer.setElem(n6, n8 |= (sArray[0] & 0xFFFF & this.bitMask) << n7);
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                dataBuffer.setElem(n6, n8 |= (nArray[0] & this.bitMask) << n7);
            }
        }
    }

    public void setPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = this.dataBitOffset + n2 * this.pixelBitStride;
        int n5 = n3 * this.scanlineStride + n4 / this.dataElementSize;
        int n6 = this.dataElementSize - (n4 & this.dataElementSize - 1) - this.pixelBitStride;
        int n7 = dataBuffer.getElem(n5);
        n7 &= ~(this.bitMask << n6);
        dataBuffer.setElem(n5, n7 |= (nArray[0] & this.bitMask) << n6);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof MultiPixelPackedSampleModel)) {
            return false;
        }
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)object;
        return this.width == multiPixelPackedSampleModel.width && this.height == multiPixelPackedSampleModel.height && this.numBands == multiPixelPackedSampleModel.numBands && this.dataType == multiPixelPackedSampleModel.dataType && this.pixelBitStride == multiPixelPackedSampleModel.pixelBitStride && this.bitMask == multiPixelPackedSampleModel.bitMask && this.pixelsPerDataElement == multiPixelPackedSampleModel.pixelsPerDataElement && this.dataElementSize == multiPixelPackedSampleModel.dataElementSize && this.dataBitOffset == multiPixelPackedSampleModel.dataBitOffset && this.scanlineStride == multiPixelPackedSampleModel.scanlineStride;
    }

    public int hashCode() {
        int n2 = 0;
        n2 = this.width;
        n2 <<= 8;
        n2 ^= this.height;
        n2 <<= 8;
        n2 ^= this.numBands;
        n2 <<= 8;
        n2 ^= this.dataType;
        n2 <<= 8;
        n2 ^= this.pixelBitStride;
        n2 <<= 8;
        n2 ^= this.bitMask;
        n2 <<= 8;
        n2 ^= this.pixelsPerDataElement;
        n2 <<= 8;
        n2 ^= this.dataElementSize;
        n2 <<= 8;
        n2 ^= this.dataBitOffset;
        n2 <<= 8;
        return n2 ^= this.scanlineStride;
    }
}

