/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class WindowsRootPaneUI
extends BasicRootPaneUI {
    private static final WindowsRootPaneUI windowsRootPaneUI = new WindowsRootPaneUI();
    private static final RepaintAction repaintAction = new RepaintAction();

    public static ComponentUI createUI(JComponent jComponent) {
        return windowsRootPaneUI;
    }

    protected void installKeyboardActions(JRootPane jRootPane) {
        super.installKeyboardActions(jRootPane);
        InputMap inputMap = SwingUtilities.getUIInputMap(jRootPane, 1);
        if (inputMap == null) {
            inputMap = new InputMapUIResource();
            SwingUtilities.replaceUIInputMap(jRootPane, 1, inputMap);
        }
        inputMap.put(KeyStroke.getKeyStroke(18, 8, false), "repaint");
        ActionMap actionMap = SwingUtilities.getUIActionMap(jRootPane);
        if (actionMap == null) {
            actionMap = new ActionMapUIResource();
            SwingUtilities.replaceUIActionMap(jRootPane, actionMap);
        }
        actionMap.put("repaint", repaintAction);
    }

    protected void uninstallKeyboardActions(JRootPane jRootPane) {
        super.uninstallKeyboardActions(jRootPane);
        SwingUtilities.replaceUIInputMap(jRootPane, 1, null);
        SwingUtilities.replaceUIActionMap(jRootPane, null);
    }

    static class RepaintAction
    extends AbstractAction {
        RepaintAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WindowsLookAndFeel.setMnemonicHidden(false);
            Object object = actionEvent.getSource();
            if (object instanceof Component) {
                Component component = null;
                Component component2 = (Component)object;
                while (component2 != null) {
                    if (component2 instanceof JRootPane) {
                        component = (JRootPane)component2;
                    }
                    component2 = component2.getParent();
                }
                if (component != null) {
                    component.repaint();
                } else {
                    ((Component)object).repaint();
                }
            }
        }
    }
}

