/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class BasicPermission
extends Permission
implements Serializable {
    public BasicPermission(String name) throws IllegalArgumentException, NullPointerException {
        super(name);
        if (name.indexOf("*") != -1) {
            if (!name.endsWith(".*") && !name.equals("*")) {
                throw new IllegalArgumentException("Bad wildcard: " + name);
            }
            if (name.indexOf("*") != name.lastIndexOf("*")) {
                throw new IllegalArgumentException("Bad wildcard: " + name);
            }
        }
    }

    public BasicPermission(String name, String actions) throws IllegalArgumentException, NullPointerException {
        this(name);
    }

    public boolean implies(Permission perm) {
        if (!(perm instanceof BasicPermission)) {
            return false;
        }
        String otherName = perm.getName();
        String name = this.getName();
        if (name.equals(otherName)) {
            return true;
        }
        int last = name.length() - 1;
        return name.charAt(last) == '*' && otherName.startsWith(name.substring(0, last));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BasicPermission)) {
            return false;
        }
        return this.getName().equals(((BasicPermission)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new PermissionCollection(this){
            private /* synthetic */ BasicPermission this$0;
            Hashtable permissions;
            boolean allAllowed;
            {
                this.this$0 = this$0;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.permissions = new Hashtable();
                this.allAllowed = false;
            }

            public void add(Permission permission) {
                if (this.isReadOnly()) {
                    throw new IllegalStateException("readonly");
                }
                BasicPermission bp = (BasicPermission)permission;
                String name = bp.getName();
                if (name.equals("*")) {
                    this.allAllowed = true;
                }
                this.permissions.put(name, bp);
            }

            public boolean implies(Permission permission) {
                if (!(permission instanceof BasicPermission)) {
                    return false;
                }
                if (this.allAllowed) {
                    return true;
                }
                BasicPermission toImply = (BasicPermission)permission;
                String name = toImply.getName();
                if (name.equals("*")) {
                    return false;
                }
                int prefixLength = name.length();
                if (name.endsWith("*")) {
                    prefixLength -= 2;
                }
                while (this.permissions.get(name) == null) {
                    if ((prefixLength = name.lastIndexOf(46, prefixLength)) < 0) {
                        return false;
                    }
                    name = name.substring(0, prefixLength + 1) + '*';
                }
                return true;
            }

            public Enumeration elements() {
                return this.permissions.elements();
            }
        };
    }
}

