/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PipedWriter;
import java.io.Reader;

public class PipedReader
extends Reader {
    PipedWriter source;
    boolean closed;
    static final int PIPE_SIZE = 2048;
    char[] buffer;
    int in;
    int out;
    char[] read_buf;

    private /* synthetic */ void finit$() {
        this.buffer = new char[2048];
        this.in = -1;
        this.out = 0;
        this.read_buf = new char[1];
    }

    public PipedReader() {
        this.finit$();
    }

    public PipedReader(PipedWriter source) throws IOException {
        this.finit$();
        this.connect(source);
    }

    public void connect(PipedWriter source) throws IOException {
        if (this.source != null || source.sink != null) {
            throw new IOException("Already connected");
        }
        source.sink = this;
        this.source = source;
    }

    void receive(char[] buf, int offset, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.closed) {
                    throw new IOException("Pipe closed");
                }
                int bufpos = offset;
                while (len > 0) {
                    try {
                        while (this.in == this.out) {
                            this.lock.notifyAll();
                            this.lock.wait();
                            if (!this.closed) continue;
                            throw new IOException("Pipe closed");
                        }
                    }
                    catch (InterruptedException ix) {
                        throw new InterruptedIOException();
                    }
                    if (this.in < 0) {
                        this.in = 0;
                    }
                    int copylen = this.in < this.out ? Math.min(len, this.out - this.in) : Math.min(len, this.buffer.length - this.in);
                    System.arraycopy(buf, bufpos, this.buffer, this.in, copylen);
                    len -= copylen;
                    bufpos += copylen;
                    this.in += copylen;
                    if (this.in != this.buffer.length) continue;
                    this.in = 0;
                }
                this.lock.notifyAll();
            }
            finally {
                Object var5_6 = null;
            }
            return;
        }
    }

    public int read() throws IOException {
        int r = this.read(this.read_buf, 0, 1);
        if (r == -1) {
            return -1;
        }
        return this.read_buf[0];
    }

    public int read(char[] buf, int offset, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n;
            try {
                if (this.source == null) {
                    throw new IOException("Not connected");
                }
                if (this.closed) {
                    throw new IOException("Pipe closed");
                }
                try {
                    while (this.in < 0) {
                        if (this.source.closed) {
                            int n2 = -1;
                            Object var6_7 = null;
                            return n2;
                        }
                        this.lock.wait();
                    }
                }
                catch (InterruptedException ix) {
                    throw new InterruptedIOException();
                }
                int total = 0;
                do {
                    int copylen = this.out < this.in ? Math.min(len, this.in - this.out) : Math.min(len, this.buffer.length - this.out);
                    System.arraycopy(this.buffer, this.out, buf, offset, copylen);
                    offset += copylen;
                    len -= copylen;
                    this.out += copylen;
                    total += copylen;
                    if (this.out == this.buffer.length) {
                        this.out = 0;
                    }
                    if (this.out != this.in) continue;
                    this.in = -1;
                    this.out = 0;
                } while (len != 0 && this.in != -1);
                this.lock.notifyAll();
                n = total;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                throw throwable;
            }
            Object var6_10 = null;
            return n;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            try {
                if (this.closed) {
                    throw new IOException("Pipe closed");
                }
                if (this.in < 0) {
                    boolean bl2 = false;
                    Object var3_4 = null;
                    return bl2;
                }
                int count = this.out < this.in ? this.in - this.out : this.buffer.length - this.out - this.in;
                bl = count > 0;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                throw throwable;
            }
            Object var3_6 = null;
            return bl;
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.closed = true;
                this.lock.notifyAll();
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }
}

