/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class Line2D
implements Shape,
Cloneable {
    protected Line2D() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException _) {
            return null;
        }
    }

    public boolean contains(double x, double y) {
        double x1 = this.getX1();
        double t1 = (x - x1) / (this.getX2() - x1);
        if (t1 < 0.0 || t1 > 1.0) {
            return false;
        }
        double y1 = this.getY1();
        double t2 = (y - y1) / (this.getY2() - y1);
        return t2 >= 0.0 && t2 <= 1.0 && t1 == t2;
    }

    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(Rectangle2D r) {
        return false;
    }

    public Rectangle getBounds() {
        double x1 = this.getX1();
        double y1 = this.getY1();
        double x2 = this.getX2();
        double y2 = this.getY2();
        double x = Math.min(x1, x2);
        double y = Math.min(y1, y2);
        double w = Math.abs(x1 - x2);
        double h = Math.abs(y1 - y2);
        return new Rectangle((int)x, (int)y, (int)w, (int)h);
    }

    public abstract Point2D getP1();

    public abstract Point2D getP2();

    public PathIterator getPathIterator(AffineTransform at) {
        return this.getPathIterator(at, 0.0);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new AffineTransform.Iterator(at, new Iterator(this));
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract double getX2();

    public abstract double getY2();

    public boolean intersects(double x, double y, double w, double h) {
        double x1 = this.getX1();
        double y1 = this.getY1();
        double x2 = this.getX2();
        double y2 = this.getY2();
        if (x1 >= x && x1 <= x + w && y1 >= y && y1 <= y + h) {
            return true;
        }
        if (x2 >= x && x2 <= x + w && y2 >= y && y2 <= y + h) {
            return true;
        }
        double x3 = x + w;
        double y3 = y + h;
        return Line2D.linesIntersect(x1, y1, x2, y2, x, y, x, y3) || Line2D.linesIntersect(x1, y1, x2, y2, x, y3, x3, y3) || Line2D.linesIntersect(x1, y1, x2, y2, x3, y3, x3, y) || Line2D.linesIntersect(x1, y1, x2, y2, x3, y, x, y);
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        return Line2D.linesIntersect(this.getX1(), this.getY1(), this.getX2(), this.getY2(), x1, y1, x2, y2);
    }

    public boolean intersectsLine(Line2D l) {
        return Line2D.linesIntersect(this.getX1(), this.getY1(), this.getX2(), this.getY2(), l.getX1(), l.getY1(), l.getX2(), l.getY2());
    }

    public static boolean linesIntersect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double beta = ((y1 - y3) * (x4 - x3) + (x1 - x3) * (y4 - y3)) / ((y2 - y1) * (x4 - x3) + (x2 - x1) * (y4 - y3));
        if (beta < 0.0 || beta > 1.0) {
            return false;
        }
        double alpha = (x1 + beta * (x2 - x1) - x3) / (x4 - x3);
        return alpha >= 0.0 && alpha <= 1.0;
    }

    public double ptLineDist(double px, double py) {
        return Line2D.ptLineDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public static double ptLineDist(double x1, double y1, double x2, double y2, double px, double py) {
        return Math.sqrt(Line2D.ptLineDistSq(x1, y1, x2, y2, px, py));
    }

    public double ptLineDist(Point2D p) {
        return Line2D.ptLineDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    public double ptLineDistSq(double px, double py) {
        return Line2D.ptLineDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public static double ptLineDistSq(double x1, double y1, double x2, double y2, double px, double py) {
        double y;
        double x;
        double pd2 = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
        if (pd2 == 0.0) {
            x = x1;
            y = y2;
        } else {
            double u = ((px - x1) * (x2 - x1) + (py - y1) * (y2 - y1)) / pd2;
            x = x1 + u * (x2 - x1);
            y = y1 + u * (y2 - y1);
        }
        return (x - px) * (x - px) + (y - py) * (y - py);
    }

    public double ptLineDistSq(Point2D p) {
        return Line2D.ptLineDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    public double ptSegDist(double px, double py) {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public static double ptSegDist(double x1, double y1, double x2, double y2, double px, double py) {
        return Math.sqrt(Line2D.ptSegDistSq(x1, y1, x2, y2, px, py));
    }

    public double ptSegDist(Point2D p) {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    public double ptSegDistSq(double px, double py) {
        return Line2D.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public static double ptSegDistSq(double x1, double y1, double x2, double y2, double px, double py) {
        double y;
        double x;
        double pd2 = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
        if (pd2 == 0.0) {
            x = x1;
            y = y2;
        } else {
            double u = ((px - x1) * (x2 - x1) + (py - y1) * (y2 - y1)) / pd2;
            if (u < 0.0) {
                x = x1;
                y = y1;
            } else if (u > 1.0) {
                x = x2;
                y = y2;
            } else {
                x = x1 + u * (x2 - x1);
                y = y1 + u * (y2 - y1);
            }
        }
        return (x - px) * (x - px) + (y - py) * (y - py);
    }

    public double ptSegDistSq(Point2D p) {
        return Line2D.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    public int relativeCCW(double px, double py) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public static int relativeCCW(double x1, double y1, double x2, double y2, double px, double py) {
        double a2;
        double a1 = Math.atan2(y2 - y1, x2 - x1);
        double a = (a1 - (a2 = Math.atan2(py - y1, px - x1))) % (Math.PI * 2);
        if (a == 0.0 || a == Math.PI) {
            double u = (px - x1) * (x2 - x1) + (py - y1) * (y2 - y1);
            if (u < 0.0) {
                return 1;
            }
            if (u > 1.0) {
                return -1;
            }
            return 0;
        }
        if (a > 0.0 && a < Math.PI) {
            return 1;
        }
        return -1;
    }

    public int relativeCCW(Point2D p) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    public abstract void setLine(double var1, double var3, double var5, double var7);

    public void setLine(Line2D l) {
        this.setLine(l.getX1(), l.getY1(), l.getX2(), l.getY2());
    }

    public void setLine(Point2D p1, Point2D p2) {
        this.setLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    class Iterator
    implements PathIterator {
        private /* synthetic */ Line2D this$0;
        private int coord = 0;
        private static final int START = 0;
        private static final int END_PLUS_ONE = 2;

        public Iterator(Line2D this$0) {
            this.this$0 = this$0;
        }

        public int currentSegment(double[] coords) {
            int r = 0;
            if (this.coord == 0) {
                coords[0] = this.this$0.getX1();
                coords[1] = this.this$0.getY1();
            } else if (this.coord == 1) {
                coords[0] = this.this$0.getX2();
                coords[1] = this.this$0.getY2();
            } else {
                r = 4;
            }
            return r;
        }

        public int currentSegment(float[] coords) {
            int r = 0;
            if (this.coord == 0) {
                coords[0] = (float)this.this$0.getX1();
                coords[1] = (float)this.this$0.getY1();
            } else if (this.coord == 1) {
                coords[0] = (float)this.this$0.getX2();
                coords[1] = (float)this.this$0.getY2();
            } else {
                r = 4;
            }
            return r;
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return this.coord == 2;
        }

        public void next() {
            if (this.coord < 2) {
                ++this.coord;
            }
        }
    }

    public static class Double
    extends Line2D {
        double x1;
        double y1;
        double x2;
        double y2;

        public Double() {
            this(0.0, 0.0, 0.0, 0.0);
        }

        public Double(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Double(Point2D p1, Point2D p2) {
            this.x1 = p1.getX();
            this.y1 = p1.getY();
            this.x2 = p2.getX();
            this.y2 = p2.getY();
        }

        public Rectangle2D getBounds2D() {
            double x = Math.min(this.x1, this.x2);
            double w = Math.abs(this.x1 - this.x2);
            double y = Math.min(this.y1, this.y2);
            double h = Math.abs(this.y1 - this.y2);
            return new Rectangle2D.Double(x, y, w, h);
        }

        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public void setLine(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }
    }

    public static class Float
    extends Line2D {
        float x1;
        float y1;
        float x2;
        float y2;

        public Float() {
            this(0.0f, 0.0f, 0.0f, 0.0f);
        }

        public Float(float x1, float y1, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Float(Point2D p1, Point2D p2) {
            this.x1 = (float)p1.getX();
            this.y1 = (float)p1.getY();
            this.x2 = (float)p2.getX();
            this.y2 = (float)p2.getY();
        }

        public Rectangle2D getBounds2D() {
            float x = Math.min(this.x1, this.x2);
            float w = Math.abs(this.x1 - this.x2);
            float y = Math.min(this.y1, this.y2);
            float h = Math.abs(this.y1 - this.y2);
            return new Rectangle2D.Float(x, y, w, h);
        }

        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public void setLine(double x1, double y1, double x2, double y2) {
            this.x1 = (float)x1;
            this.y1 = (float)y1;
            this.x2 = (float)x2;
            this.y2 = (float)y2;
        }

        public void setLine(float x1, float y1, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }
    }
}

