/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class CardLayout
implements LayoutManager2,
Serializable {
    private int hgap;
    private int vgap;
    private Hashtable tab;
    private int FIRST;
    private int LAST;
    private int NEXT;
    private int PREV;
    private int NONE;
    private int MIN;
    private int MAX;
    private int PREF;

    private /* synthetic */ void finit$() {
        this.FIRST = 0;
        this.LAST = 1;
        this.NEXT = 2;
        this.PREV = 3;
        this.NONE = 4;
        this.MIN = 0;
        this.MAX = 1;
        this.PREF = 2;
    }

    public CardLayout() {
        this(0, 0);
    }

    public CardLayout(int hgap, int vgap) {
        this.finit$();
        this.hgap = hgap;
        this.vgap = vgap;
        this.tab = new Hashtable();
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (!(constraints instanceof String)) {
            throw new IllegalArgumentException("Object " + constraints + " is not a string");
        }
        this.tab.put(constraints, comp);
    }

    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, name);
    }

    public void first(Container parent) {
        this.gotoComponent(parent, this.FIRST, null);
    }

    public int getHgap() {
        return this.hgap;
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void invalidateLayout(Container target) {
    }

    public void last(Container parent) {
        this.gotoComponent(parent, this.LAST, null);
    }

    public void layoutContainer(Container parent) {
        int width = parent.width;
        int height = parent.height;
        Insets ins = parent.getInsets();
        int num = parent.ncomponents;
        Component[] comps = parent.component;
        int x = ins.left + this.hgap;
        int y = ins.top + this.vgap;
        width = width - 2 * this.hgap - ins.left - ins.right;
        height = height - 2 * this.vgap - ins.top - ins.bottom;
        for (int i = 0; i < num; ++i) {
            comps[i].setBounds(x, y, width, height);
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return this.getSize(target, this.MAX);
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.getSize(target, this.MIN);
    }

    public void next(Container parent) {
        this.gotoComponent(parent, this.NEXT, null);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.getSize(parent, this.PREF);
    }

    public void previous(Container parent) {
        this.gotoComponent(parent, this.PREV, null);
    }

    public void removeLayoutComponent(Component comp) {
        Enumeration e = this.tab.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (this.tab.get(key) != comp) continue;
            this.tab.remove(key);
            break;
        }
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void show(Container parent, String name) {
        Object target = this.tab.get(name);
        if (target != null) {
            this.gotoComponent(parent, this.NONE, (Component)target);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.hgap + "," + this.vgap + "]";
    }

    private void gotoComponent(Container parent, int what, Component target) {
        int num = parent.ncomponents;
        Component[] comps = parent.component;
        int choice = -1;
        if (what == this.FIRST) {
            choice = 0;
        } else if (what == this.LAST) {
            choice = num - 1;
        } else if (what >= 0) {
            choice = what;
        }
        for (int i = 0; i < num; ++i) {
            if (target != null && target == comps[i]) {
                choice = i;
            }
            if (!comps[i].isVisible()) continue;
            if (what == this.NEXT) {
                choice = i + 1;
                if (choice == num) {
                    choice = 0;
                }
            } else if (what == this.PREV) {
                choice = i - 1;
                if (choice < 0) {
                    choice = num - 1;
                }
            } else if (choice == i) {
                return;
            }
            comps[i].setVisible(false);
            if (choice >= 0) break;
        }
        if (choice >= 0 && choice < num) {
            comps[choice].setVisible(true);
        }
    }

    private Dimension getSize(Container parent, int what) {
        int w = 0;
        int h = 0;
        int num = parent.ncomponents;
        Component[] comps = parent.component;
        for (int i = 0; i < num; ++i) {
            Dimension d = what == this.MIN ? comps[i].getMinimumSize() : (what == this.MAX ? comps[i].getMaximumSize() : comps[i].getPreferredSize());
            w = Math.max(d.width, w);
            h = Math.max(d.height, h);
        }
        Insets i = parent.getInsets();
        h += 2 * this.vgap + i.bottom + i.top;
        if ((w += 2 * this.hgap + i.right + i.left) < 0) {
            w = Integer.MAX_VALUE;
        }
        if (h < 0) {
            h = Integer.MAX_VALUE;
        }
        return new Dimension(w, h);
    }
}

