.\" $Id: mirror.man,v 2.6 1994/06/10 18:28:26 lmjm Exp lmjm $
.\" $Log: mirror.man,v $
.\" Revision 2.6  1994/06/10  18:28:26  lmjm
.\" added proxy_ftp_port warning.
.\" show other netware formats
.\" added dosish
.\"
.\" Revision 2.5  1994/04/29  20:11:08  lmjm
.\" added stupid note.
.\"
.\" Revision 2.4  1994/01/26  15:50:03  lmjm
.\" Added new remote_fs types, compress_size_floor and get_missing.
.\"
.\" Revision 2.3  1994/01/18  21:58:23  lmjm
.\" Lots of typos fixes (from Pieter).
.\"
.\" Revision 2.2  1993/12/14  11:09:12  lmjm
.\" Comment on all the new ls types.
.\" More cross referencing.
.\"
.\" Revision 2.1  1993/06/28  15:19:57  lmjm
.\" Full 2.1 release
.\"
.\"
.\"
.de Rv
.ds Rs Mirror \\$2
..
.de kV
.TP 15m
.I \\$1
\\$3
.if !'\\$2'' [\\$2]
..
.de eG
.LP
.RS
.ft B
.nf
..
.de Ge
.fi
.ft R
.RE
.LP
..
.Rv $Revision: 2.6 $
.TH MIRROR 1L "\*(Rs"
.SH NAME
mirror \- mirror packages on remote sites
.SH SYNOPSIS
.B mirror
.B [flags] \-g\fIsite\fP:\fIpathname\fP
.br
.B mirror
.B [flags] [config-files]
.SH DESCRIPTION
.B Mirror
is a package written in Perl that uses the ftp protocol
to duplicate a directory hierarchy between the machine it is run on and
a remote host.  It avoids copying files unnecessarily by comparing the
file time-stamps and sizes before transferring.  Amongst other things, it
can optionally compress, gzip, and split files.
.LP
It was written for use by archive maintainers but can be
used by anyone wanting to transfer a lot of files via ftp.
.LP
Regardless of how it is called,
.B mirror
always performs the same basic steps.  It connects to the remote site,
internally builds a directory listing of the local target directory, builds one
for the remote directory, compares them, creates any subdirectories
required, transfers the appropriate files (setting their time-stamps to
match those on the remote site), creates any symbolic links, removes any
unnecessary objects and finally drops the connection.
.LP
.B Mirror
can handle symbolic links but not ordinary links.  It does not
duplicate owner or group information.  If you require any of these
options, use
.BR rdist (1)
instead.
.LP
.B Mirror
is called in one of two ways shown in the synopsis above.
.LP
The first method is used to retrieve a remote directory into the
current directory.  If you are mirroring a directory, it would be best
to end the pathname in a slash ('/') so the remote recursive listing
is smaller or use the
.B \-r
flag to suppress recursion (see
.B \-g
below).  The
.B mirror.defaults
file is not used.
.LP
In the second method given in the synopsis above,
a minimal number of arguments are required and
.B mirror
is controlled by the settings read from the configuration files (or
standard input).  If a file named
.B mirror.defaults
can be found in either the directory the
.B mirror
executable is in or in the
.B PERLLIB
path, then it is loaded first. This is used to
provide common defaults for all config-files.
.LP
.B Mirror
was written to mirror remote Un*x archives, but has grown (like topsy).
.SH OPTIONS
.TP
.B \-d
Enable debugging.  If this argument is given more than once, the
debugging level will increase.  Currently the maximum useful level is
four.
.TP
.BR \-p package
Only mirror the given package.  This option may be given multiple
times in which case all the given packages will be mirrored.  Without
this option, all packages will be mirrored.  Package is
a regexp matched against the package variable.
.TP
.BR \-R package
Similar to
.B \-p
but skips all packages until it reaches the given package.  Useful for
restarting failed mirror runs from where they left off.
.TP
.B \-n
Do nothing except compare local and remote directories, no file
transfers are done.  Sets debug level to two, so you are shown a
trace of what would be done.
.TP
.B \-F
Use temporary 
.B dbm
files for the information about files.  This is useful if you mirror a
very large directory.  See the variable
.IR use_files .
.TP
.BR \-g site\fB:\fPpath
Get all files on given site.  If path matches \ \ .*/.+\ \  then
it is the name of the directory and the last part is the
pattern of filenames to get.  If path matches \ \ .*/\ \  then
it is the name of a directory and all its contents are retrieved.
Otherwise path is the pattern to be used in '/'.  If you use
host:/fred, a full directory listing of / on the remote host will
be done.  If all you wanted was the contents of the directory /fred,
specify host:/fred/.
.TP
.B \-r
Equivalent to
.BI \-k recursive\fR=false\fP
.TP
.B \-v
Print the version details of mirror and exit.
.TP
.B \-T
Force the time stamps of any local files to be reset to be the same as
the remote files.  Normally only used when initialising a mirror area
using existing files contents.
.TP
.B \-U[\fRfilename\fP]
Record all uploads into the given filename.  Remember that mirror changes into
\fIlocal_dir\fP to do its work, so it should be a full pathname.  If no
parameter is given, it defaults to \`pwd\`/upload_log.day.month.year.
.TP
.BR \-k \fIkey\fP=value
Override any default key/value.
.TP
.B \-m
Equivalent to
.BR \-k \fImode_copy\fP=true
.TP
.B \-t
Equivalent to
.BR \-k \fItext_mode\fP=true
.TP
.B \-f
Equivalent to
.BR \-k \fIforce\fP=true
.TP
.BR \-s site
Equivalent to
.BR \-k \fIsite\fP=site
.TP
.BR \-u user
Equivalent to
.BR \-k \fIremote_user\fP=user
You are then prompted for a password, with echo turned off.  The
password is used to set
.IR remote_password .
.TP
.B \-L
Just generate a pretty printed version of the input and exit.
.TP
.B \-G
Get files from the remote machine.  The local and remote directories
have to be given on the command line.  (This option is no longer supported.)
.TP
.B \-P
Put files onto the remote machine.  The local and remote directories
have to be given on the command line.  (This option is no longer supported.)
.TP
.BR \-C file
Specify config-files.  Needed to give config-files with
.B \-P
and
.B \-G
options.  (This option is no longer supported.)
.LP
.SH CONFIGURATION FILE
Configuration files are parsed as a series of statements.
Blank lines and lines beginning with a hash are ignored.  Each
statement is of the form
.PD 0
.IP
.IR keyword \fB=\fPvalue
.P
or
.IP
.IR keyword \fB+\fPvalue
.PD
.LP
You can add whitespace before the keyword and the equals/plus.
Everything immediately following the equals/plus is the value,
including any leading or trailing whitespace.  The equals version sets
the keyword to this value, while the plus version concatenates the value
onto the end of the default.
.LP
A statement can be continued over multiple lines by ending all lines
except the last, with the character ampersand ('&').  The line
following the ampersand, is appended to the current line with
all leading whitespace removed.
.LP
Here is a list of the keywords and their values with defaults
given inside square brackets.  Those options flagged with a star are
not yet implemented.
.LP
Although there are a lot of keywords that can be set, the built-in
defaults will handle most cases.  Normally only
.IR package ,
.IR site ,
.I remote_dir
and
.I local_dir
need to be set.
.kV package '' "Should be a unique name for the package to be mirrored.
.kV comment '' "Used in reports.
.kV skip '' "Setting this entry causes this package to be skipped. \
The value is reported as the reason for skipping.  \
(It is easier than commenting the entry out.)
.kV site '' "Site-name or IP address of the remote site.
.kV remote_dir '' "Remote directory to mirror. See also \fIrecurse_hard\fP.
.kV local_dir '' "Local directory.
.kV remote_user anonymous "Username to use at remote site.
.kV remote_password user@localhostname "Password to use at remote site.
.kV remote_account '' "Account name/password (to use \
at remote site, after logging in anonymously (for systems that use it).
.kV get_patt . "Regexp of remote pathnames to retrieve.
.kV failed_gets_excl '' "Regexp of messages to ignore, when the ftp get \
command failed.
.kV exclude_patt '' "Regexp of remote pathnames to ignore.
.kV update_local false "Set \fIget_patt\fP to be \fIlocal_dir\fP/*.  \
This is useful if you only want to mirror selected subdirectories \
of a remote archive.
.kV local_ignore '' "Regexp of local pathnames to ignore.  \
Useful to skip restricted local directories.
.kV do_deletes false "Delete destination files if not in source tree.
.kV delete_patt . "Regexp of local pathnames to check for deletions.  \
Names that are not matched are not checked.  The match by \fIdelete_excl\fP \
is done to all files selected by this pattern.
.kV delete_get_patt false "Set \fIdelete_patt\fP to be \fIget_patt\fP.
.kV delete_excl '' "Regexp of local pathnames to never delete.
.kV save_deletes false "Save local files into \fIsave_dir\fP rather than \
deleting.
.kV save_dir Old "Where local files no longer on remote site are transferred to.
.kV max_delete_files 10% "If there are more than this many files to delete, \
do not delete, just warn.  If the value ends with percent character \
the this is the percentage of files before deletion disabled.
.kV max_delete_dirs 10% "If there are more than this many directories \
to delete, do not delete, just warn.  If the value ends with percent character \
the this is the percentage of directories before deletion disabled.
.kV max_days 0 "If >0, ignore files older than this many days.  \
Any ignored files will not be transferred or deleted.
.kV store_remote_listing '' "Local pathname where remote listings are \
kept.  Useful if you have a slow network or want to perform several \
operations on the same package without retrieving the index every time.
.kV split_max 0 "If >0 and the size of the file is greater than this, the file \
is split up to be stored locally (filename must also match \fIsplit_patt\fP).
.kV split_patt '' "regexp of remote pathnames to split up before \
storing locally.
.kV split_chunk 102400 "Size of chunks to split files into.
.kV ls_lR_file '' "Remote file containing ls-lR, otherwise run remote ls.
.kV local_ls_lR_file '' "Local file containing ls-lR, otherwise use \
remote \fIls_lR_file\fP.  This is useful when first mirroring a large package.
.kV recursive true "Do subdirectories as well.
.kV recurse_hard false "Have to generate remote ls by doing cwd and ls \
for each subdirectory.  In this case remote_dir must be absolute \
(begin with a /) not relative. Use the pwd command in ftp to find the \
path for  the start of the remote archive area.
.kV flags_recursive '-lRat' "Flags to send to remote ls to do a \
recursive listing.
.kV flags_nonrecursive '-lat' "Flags to send to remote ls to do a \
non-recursive listing.
.kV remote_fs unix "Remote file store type.  Handles \fBunix\fP, \fBdls\fP, \
\fBnetware\fP, \fBdosftp\fP, \fBmacos\fP, \fBlsparse\fP and \
\fBinfomac\fP.  See the FILESTORES section below for more details.
.kV name_mappings '' "Remote to local pathname mappings \
(a perl \fBs\fP command, eg. s:old:new:).
.kV external_mapping '' "External routine to perform name mappings.
.kV get_newer true "Get the remote file if its date is newer than local.
.kV get_size_change true "Get the file if the size is different from \
local.  If a file is compressed when fetched, the size is \
automatically ignored.
.kV compress_patt '' "Regexp of files to compress before storing \
locally.  See \fIget_size_change\fP.
.kV compress_excl \e.(z|gz)$ "Regexp of files not to compress \
(case insensitive).
.kV compress_prog compress "Program to compress files.  \
If set to the word compress or gzip, the full pathname and correct \
\fIcompress_suffix\fP will automatically be set.  When using gzip, level -9 is \
used.  Note that \fIcompress_suffix\fP can be reset to a non-standard value \
by setting it after \fIcompress_prog\fP.
.kV compress_suffix '' "Character(s) the compress program \
appends to files.  If \fIcompress_prog\fP is compress, this defaults \
to .Z.  If \fIcompress_prog\fP is gzip, this defaults to .gz.
.kV compress_conv_patt (\e.Z|\e.taz)$ "If \fIcompress_prog\fP is gzip, files \
matching this pattern are uncompressed and gzip'ed before storing locally.  \
Compression conversion is only meant to do compress to gzip conversion.
.kV compress_conv_expr s/\e.Z$/\e.gz/;s/\e.taz$/\e.tgz/ "Perl expression \
to convert suffix from compress to gzip style.
.\" Default is  s/// expressions \
.\" to change \e.Z to \e.z and \e.taz to \e.tgz.
.kV compress_size_floor 0 "Only compress files smaller than this size.
.kV force_times yes "Force local times to match remote times.
.kV retry_call yes "If initial connect fails, retry ONCE after ONE \
minute.  This is to handle sites which reverse lookup the incoming \
host but sometimes timeout on the first attempt.
.kV update_log '' "Filename, relative to \fIlocal_dir\fP, where an \
update report is to be kept.
.kV mail_to '' "Mail a log of the work done to this comma separated \
list of people.
.kV user '' "User name or uid to give to local pathnames.
.kV group '' "Group name or gid to give to local pathnames.
.kV file_mode 0444 "Mode to give files created locally.
.kV dir_mode 0755 "Mode to give directories created locally.
.kV timeout 40 "Timeout ftp requests after this many seconds.
.kV ftp_port 21 "Port number of remote ftp daemon.
.kV proxy 0 "Set to 1 to use proxy ftp service.
.kV proxy_ftp_port 4514 "Port number of proxy-service ftp daemon.  This value \
should be changed depending on which proxy library you are using.
.kV proxy_gateway internet-gateway "Name of proxy-service, \
may also be supplied by the environment variable \fBINTERNET_HOST\fP.
.kV using_socks 0 "Set to 1 if you are using a SOCKS version of perl.
.kV passive_ftp 0 "Set to 1 if you want to use the PASV extension of the \
FTP protocol.  Especially useful with firewalls, other proxy FTP servers, \
and the variable \fIusing_socks\fP."
.kV mode_copy false "Flag indicating if we need to copy the mode bits.
.kV interactive false "A non-batch transfer.  Implied by \fB\-g\fP flag.
.kV text_mode false "If true, files are transferred in text mode.  \
Un*x prefers binary so that is the default.
.kV force false "If true, all files will be transferred regardless of \
size or time-stamp.
.kV get_file true "Perform get, not put by default.
.kV verbose false "Verbose messages.
.kV delete_source false "Delete the source files and directories once \
transferred.  (This is no longer supported.)
.kV disconnect false "Disconnect from remote site at end of package.
.kV mail_prog '' "Program called to send to the \fImail_to\fP list.  \
May be passed the argument \fImail_subject\fP.  Defaults to mailx, Mail, \
mail or whatever is available on your system.
.kV mail_subject '-s "mirror update"' "This argument is evaluated \
just before use, so you can include variables like $package.
.\" Defaults to '-s "mirror update"'.
.kV hostname '' "Mirror automatically skips packages whose site variable \
matches this host.  Defaults to the local hostname.
.kV use_files false "Put the associative arrays that mirror uses into tmp files.
.kV umask 07000 "Do not allow setuid things across by default.
.kV use_timelocal true "Time-stamp files to local time zone.  If false, the \
time zone is set to offset 0 (compatible with older versions of \fBmirror\fP).
.kV remote_group '' "If present set the remote 'site group'.
.kV remote_gpass '' "If present set the remote 'site gpass'.
.kV remote_idle '' "If not null, try and set the remote idle timer to this.
.kV make_bad_symlinks false "If true, symlinks will be made to invalid \
(non-existent) pathnames.  Under older versions this defaulted to true.
.kV follow_local_symlinks '' "Regexp of pathnames that should be \
followed to the file or directory they point at.  This makes local \
symlinks invisible to \fBmirror\fP.
.kV get_missing true "Really get files.  When set to false, only deletions \
and symlinking will be done.  Used to delete expired files older than \
\fImax_days\fP without retrieving older files.
.LP
Each group of keywords defines how to mirror a particular package and
should begin with a unique
.I package
line.  The package name is used in report generation and by the
.B \-p
argument, so pick something mnemonic.  The minimum needed for each
package is the
.IR package ,
.IR site ,
.I remote_dir
and
.IR local_dir .
On finding a package line, all the default values are reset.
.LP
If the package name is
.BR defaults ,
then no site is contacted, but the default values given for any
keywords are changed.  Normally all the defaults are in the file
.B mirror.defaults
which will be automatically loaded before any package details.
.eG
# Sample mirror.defaults
package=defaults
	# The LOCAL hostname - if not the same as `hostname` returns
	# (I advertise the name src.doc.ic.ac.uk but the machine is
	#  really puffin.doc.ic.ac.uk.)
	hostname=src.doc.ic.ac.uk
	# Keep all local_dirs relative to here
	local_dir=/public/
	remote_password=ukuug-soft@doc.ic.ac.uk
.Ge
If the package is not
.BR defaults ,
then
.B mirror
will perform the following steps.  Unless an internal failure is
detected, any error will cause the current package to be skipped and
the next one tried.
.LP
If 
.B mirror
is not already connected to the site, it will disconnect from any site it
is already connected to and attempt to connect to the remote site's
.B ftp
daemon.  It will then login using the given remote username and password.  Once
connected,
.B mirror
turns on binary mode transfers.  Next it changes to the given local directory
and scans it to get the details of the local files that already exist.  If
necessary, the local directory will be created.  Once this is completed, the
remote directory is scanned in a similar fashion.
.B Mirror
does this by changing to the remote directory and running the ftp LIST
command, passing the
.I flags_recursive
options or
.I flags_nonrecursive
depending on the value of
.I recursive.
Alternatively a file containing the directory listing may be
retrieved.  Each remote pathname will have any specified mappings
performed on it to create a local pathname.  Then any checks specified
by the
.IR exclude_patt ,
.IR max_days ,
.I get_newer
and
.IR get_size_change
keywords are applied on names of files or symlinks.  Only 
.IR exclude_patt
checking is applied to directories.
.LP
The above creates a list of all required remote files and the local pathnames
to store them in.
.LP
Once the directory listing is completed, all required files are
fetched from the remote site into their local path names.  This is
done by retrieving the file into a temporary file in the target directory.
If required, the temporary file is compressed, gzip'ed or split (or
compressed or gzip'ed and then split).
The temporary file is renamed when the transfer is successful.
.SH FILESTORES
.LP
Mirror uses the remote directory listing to work out what files are
available.  Mirror was originally targetted connect to unix ftp daemons
using a standard
.I ls
command.  To use a unix host with a non-standard ls or a non unix host
it is necessary to set the \fIremote_fs\fP variable to match the kind
of directory listing that will be returned.  There is some interaction
between \fIremote_fs\fP and other variables in particular
\fIflags_recursive\fP, \fIrecurse_hard\fP and \fIget_size_change\fP.
The following sub sections show examples of the results of running the
ftp \fIdir\fP command on the various kinds of archive and
recommendations for related variables.  With some unusually setups
archive you may have to vary from the recommended variable setups.
.SS remote_fs=unix
.eG
total 65
-rw-r--r-- 1 ukuug  ukuug   2245 Jun 28 20:06 README
-rw-r--r-- 1 ukuug  ukuug  61949 Jun 29 19:13 mirror-2.1.tar.gz
.Ge
This is the default and you should not normally have to reset any
other variables.
.SS remote_fs=dls
.eG
00index.txt      189916  
0readme            5793  
1_x/                  =  OS/2 1.x-specific files
.Ge
This is an
.I ls
variant used on some unix archives.  It provides descriptions
of known items in the listing. Set \fIflags_recursive\fP to \-dtR.
.SS remote_fs=netware
.eG
- [R----F--] jrd                  1646       May 07 21:43    index
d [R----F--] jrd                   512       Sep 09 10:52    netwire
d [R----F--] jrd                   512       Sep 02 01:31    pktdrvr
d [RWCE-F--] jrd                   512       Sep 04 10:55    incoming
.Ge
or
.eG
-[R----F--] 1 jrd                  1646       May 07 21:43    index
d[R----F--] 1 jrd                   512       Sep 09 10:52    netwire
d[R----F--] 1 jrd                   512       Sep 02 01:31    pktdrvr
.Ge
This is used by Novell archives.  Set \fIrecurse_hard\fP to true and
set \fIflags_recursive\fP to be nothing.  See also \fIremote_dir\fP.
.SS dosftp
.eG
00-index.txt  6,471 13:54  7/20/93   alabama.txt   1,246 23:29  5/08/92
alaska.txt      873 23:29  5/08/92   alberta.txt   2,162 23:29  5/08/92
.Ge
dosftp is for an ftp daemon on dos boxes.  Set \fIrecurse_hard\fP to
true and set \fIflags_recursive\fP to nothing.  See also \fIremote_dir\fP.
.SS remote_fs=macos
.eG
-------r--      0      127   127 Aug 27 13:53 !Gopher Links
drwxrwxr-x          folder    32 Sep  9 16:30 FAQ
drwxrwx-wx          folder     0 Sep  9 09:59 incoming
.Ge
macos is for one of Macintosh ftp daemon variants.  Although the
output is similar to unix it the unix \fIremote_fs\fP type cannot cope
with it because there are three file sizes for each file.
Set\fIrecurse_hard\fP to true, \fIflags_recursive\fP to nothing,
\fIget_size_change\fP to false and \fIcompress_patt\fP to nothing
(this last setting is due to the unusual file names upsetting the
shell used to run compress).  See also \fIremote_dir\fP.
.SS remote_fs=infomac
This is a special just meant to handle the sumex-aim.stanford.edu
info-mac directory listing stored on that archive in help/all-files.
\fIrecurse_hard\fP should be set to true.
.SS remote_fs=dosish
This is for a DOS/Windows FTP server with a faintly DOS like output
.eG
03-04-94  08:45PM       <DIR>          .
03-04-94  08:45PM       <DIR>          ..
03-04-94  09:58AM                 9718 Conduit
03-04-94  09:59AM                 8745 Eve
.Ge
\fIrecurse_hard\fP should be set to true and \fIflags_recursive\fP to
nothing.
.SS remote_fs=lsparse
Allow reparsing of the listing generated by mirror with debugging
turned to a high level.  Meant only for mirror wizards.
.SH EXAMPLES
.LP
Here is the mirror.defaults file from the archive on
src.doc.ic.ac.uk:
.eG
# This is the default mirror settings used by my site:
# src.doc.ic.ac.uk (146.169.2.1)
# This is home of the UKUUG Software Distribution Service

package=defaults
	# The LOCAL hostname - if not the same as `hostname`
	# (I advertise the name src.doc.ic.ac.uk but the machine is
	#  really puffin.doc.ic.ac.uk)
	hostname=src.doc.ic.ac.uk
	# Keep all local_dirs relative to here
	local_dir=/public/
	remote_password=ukuug-soft@doc.ic.ac.uk
	mail_to=
	# Don't mirror file modes.  Set all dirs/files to these
	dir_mode=0755
	file_mode=0444
	# By default, files are owned by root.zero
	user=0
	group=0
#	# Keep a log file in each updated directory
#	update_log=.mirror
	update_log=
	# Don't overwrite my mirror log with the remote one.
	# Don't retrieve any of their mirror temporary files.
	# Don't touch anything whose name begins with a space!
	# nor any FSP or gopher files...
	exclude_patt=(^|/)(\.mirror$|\.in\..*\.$|MIRROR.LOG|#.*#|\.FSP|\.cache|\.zipped|lost+found/|\ )
	# Try to compress everything
	compress_patt=.
	compress_prog=compress
	# Don't compress information files, files that don't benefit from
	# being compressed, files that tell ftpd, gopher, wais... to do things,
	# the sources for compression programs...
	# (Note this is the only regexp that is case insensitive.)
	compress_excl+|^\.notar$|-z|\.taz$|\.tar.Z|\.arc$|\.zip$|\.lzh$|\.zoo$|\.exe$|\.lha$|\.zom$|\.gif$|\.jpeg$|\.jpg$|\.mpeg$|\.au$|read.*me|index|\.message|info|faq|gzip|compress
	# Don't delete own mirror log or any .notar files (incl in subdirs)
	delete_excl=(^|/)\.(mirror|notar)$
	# Ignore any local readme files
	local_ignore=README.doc.ic
	# Automatically delete local copies of files that the
	# remote site has zapped
	do_deletes=true
.Ge
Here are some sample package descriptions:
.eG
package=gnu
	comment=Powerful and free Un*x utilities
	site=prep.ai.mit.edu
	remote_dir=/pub/gnu
	# Local_dir+ causes gnu to be appended to the default local_dir
	# so making /public/gnu
	local_dir+gnu
	exclude_patt+|^ListArchives/|^lost+found/|^scheme-7.0/|^\.history
	# I tend to only keep the latest couple of versions of things
	# this stops mirror from retrieving the older versions I've removed
	max_days=30
	do_deletes=false

package=X11R5
	comment=X Windows (windowing graphics system for Un*x)
	site=export.lcs.mit.edu
	remote_dir=/pub/R5
	local_dir+computing/graphics/systems/X11/pub/R5
	# This is a local symlink to the free-for-all contrib area
	# and is mirrored elsewhere
	local_ignore=^contrib$
	# Don't compress a thing.  It is already compressed 
	# but doesn't look it.
	compress_patt=

package=cnews
	comment=The C News system
	site=ftp.cs.toronto.edu
	remote_dir=/pub/c-news
	local_dir+computing/usenet/software/transport/c
	compress_excl+|patches/PATCHDATES|WhereFrom

# and on, and on ...
.Ge
.SH HINTS
.LP
On adding a new package, first check it out by turning on the
.B \-n
option.
.LP
If you are adding to an existing archive, then it is usually best to
force the time-stamps of the existing local files so time comparisons
with the remote files will work.
.LP
Try and keep all packages that are being retrieved from the same site
together.  That way
.B mirror
will only have to login once.
.LP
Remember that all regexp's are Perl regular expressions.
.LP
If the remote site contains symlinks that you want to "flatten out"
into the corresponding files, then do this by changing the flags passed
to the remote ls:
.PD 0
.IP
.IR flags_recursive \fB+\fPL
.P
or
.IP
.IR flags_nonrecursive \fB+\fPL
.PD
.LP
First test this by trying a
.B ls\ \-lRatL
on the remote site under the ftp
command to check whether the remote file-store has any symlink loops.
.LP
If you are mirroring a very large site that changes infrequently, add
\fImax_days\fP=7 to the settings after it is initially mirrored.  That
way mirror will only have to consider recent files when updating.  Then
once a week, or whenever necessary, call mirror with
\fB\-k\fP\fImax_days\fP=0 to force a full update.
.LP
If you don't want to compress anything from the remote site the
easiest way to do this is to set the \fIcompress_patt\fP to nothing.
.LP
If you want to run a command at the end of mirroring a package a
useful trick is to reset the \fImail_prog\fP variable to be the
program name and \fImail_to\fP to be the arguments.
.LP
For netware, dosftp, macos and VMS you should normally set remote_dir
to be the home directory of the remote ftp daemon.  Connect in
manually and before changing directory use the pwd command to find
where home is.  If you are only mirroring part of the tree then give
the full path name including this home directory at the start.
.LP
macos names can sometimes contain characters that make it hard to pass
them through un*x shells.  Since compressing files is done via a shell
it would be best to turn off compression with compress_patt=
.LP
macos files seem to always change size when transfered, in either
binary or text mode.  So it would be best to set get_size_change=false
.SH NETIQUETTE
If you are going to mirror a remote site, please obey any restrictions
that the site administrators place on access.  You can generally find
the restrictions on connecting to the archive using the standard \fBftp\fP
command.  Any restrictions are normally given as a login banner or in
a (hopefully) obvious file.
.LP
Here are, what I hope are, some good general rules:
.LP
Only mirror a site well outside the working hours of both the local
and remote sites.
.LP
It is probably unfriendly to try to mirror a remote site more
than once a day.
.LP
Before trying to mirror a remote site, try and find the packages you
want from local archives, as no one will be pleased if you soak up a
lot of network bandwidth needlessly.
.LP
If you have a local archive, then tell people about it so they don't
have to waste bandwidth and CPU at the remote site.
.LP
Do remember to check your config-files from time to time in case the
remote archive has changed their access restrictions.
.LP
Check the remote site regularly for any new restrictions.
.SH SEE ALSO
perl(l), ftp(1), mm(1)
.SH BUGS
.LP
Some of the netiquette guidelines should be enforced.
.LP
Should be able to cope with links as well as symlinks.
.LP
Suffers from \fIcreeping featurism\fP.
.SH REMEMBER
.LP
Objects in a mirror are closer than you think!
.SH AUTHOR
Written by Lee McLoughlin <lmjm@doc.ic.ac.uk>.  It uses a heavily
rewritten and extended version of the ftp.pl package originally
by: Alan R. Martello <al@ee.pitt.edu> which uses lchat.pl which is based on
the chat2.pl package by: Randal L. Schwartz <merlyn@ora.com>
.LP
Special thanks to the following people for patches, comments and other
suggestions that have helped to improve mirror.  If I have omitted anyone,
please contact me.
.LP
James Revell <revell@uunet.uu.net>
.br
Chris Myers <chris@wugate.wustl.edu>
.br
Amos Shapira <amoss@cs.huji.ac.il>
.br
Paul A Vixie <vixie@pa.dec.com>
.br
Jonathan Kamens <jik@pit-manager.mit.edu>
.br
Christian Andretzky <casys@otto.mb3.tu-chemnitz.de>
.br
Kean Stump <kean@ucs.orst.edu>
.br
Anita Eijs <anita@hermes.bouw.tno.nl>
.br
Simon E Sperro <S.E.Sperro@gdr.bath.ac.uk>
.br
Aaron Wohl <aw0g+@andrew.cmu.edu>
.br
Michael Meissner <meissner@osf.org>
.br
Michael Graff <explorer@iastate.edu>
.br
Bradley Rhoades <us267388@mail.mmmg.com>
.br
Edwards Reed <eer@cinops.xerox.com>
.br
Joachim Schrod <schrod@iti.informatik.th-darmstadt.de>
.br
David Woodgate <David.Woodgate@mel.dit.csiro.au>
.br
Pieter Immelman <pi@itu1.sun.ac.za>
.br
Jost Krieger <x920031@bus072.rz.ruhr-uni-bochum.de>
.br
Erez HWank1 Zadok <ezk@cs.columbia.edu>

