/* Copyright (C) 1991, 1992 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <ansidecl.h>
#include <stdio.h>
#include <signal.h>


#if !defined(HAVE_GNU_LD) && !defined (__ELF__)
#define	_sys_siglist	sys_siglist
#endif

#if NLS
#include "nl_types.h"
#endif

#ifndef linux
/* Defined in sys_siglist.c.  */
extern CONST char *CONST _sys_siglist[];
#endif

/* Print out on stderr a line consisting of the test in S, a colon, a space,
   a message describing the meaning of the signal number SIG and a newline.
   If S is NULL or "", the colon and space are omitted.  */
void
DEFUN(psignal, (sig, s), int sig AND register CONST char *s)
{
  CONST char *colon;

#if NLS
  libc_nls_init();
#endif

  if (s == NULL || s == '\0')
    s = colon = "";
  else
    colon = ": ";

  if (sig >= 0 && sig < NSIG)
#if NLS
    (void) fprintf(stderr, "%s%s%s\n", s, colon,
	   catgets(_libc_cat, SignalListSet, sig +1, (char *) _sys_siglist[sig]));
#else
    (void) fprintf(stderr, "%s%s%s\n", s, colon, _sys_siglist[sig]);
#endif
  else
#if NLS
    (void) fprintf(stderr, "%s%s%s %d\n", s, colon,
		   catgets(_libc_cat, SignalListSet, 1,  "Unknown signal"),
		   sig);
#else
    (void) fprintf(stderr, "%s%s%s %d\n", s, colon, "Unknown signal", sig);
#endif
}
