/* GL dispatch code.
 * This is code-generated from the GL API XML files from Khronos.
 * 
 * Copyright (c) 2013-2014 The Khronos Group Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and/or associated documentation files (the
 * "Materials"), to deal in the Materials without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Materials, and to
 * permit persons to whom the Materials are furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Materials.
 * 
 * THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * MATERIALS OR THE USE OR OTHER DEALINGS IN THE MATERIALS.
 * 
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "dispatch_common.h"
#include "epoxy/gl.h"

#ifdef __GNUC__
#define EPOXY_NOINLINE __attribute__((noinline))
#elif defined (_MSC_VER)
#define EPOXY_NOINLINE __declspec(noinline)
#endif
struct dispatch_table {
    PFNGLACCUMPROC epoxy_glAccum;
    PFNGLACCUMXOESPROC epoxy_glAccumxOES;
    PFNGLACTIVEPROGRAMEXTPROC epoxy_glActiveProgramEXT;
    PFNGLACTIVESHADERPROGRAMPROC epoxy_glActiveShaderProgram;
    PFNGLACTIVESHADERPROGRAMEXTPROC epoxy_glActiveShaderProgramEXT;
    PFNGLACTIVESTENCILFACEEXTPROC epoxy_glActiveStencilFaceEXT;
    PFNGLACTIVETEXTUREPROC epoxy_glActiveTexture;
    PFNGLACTIVETEXTUREARBPROC epoxy_glActiveTextureARB;
    PFNGLACTIVEVARYINGNVPROC epoxy_glActiveVaryingNV;
    PFNGLALPHAFRAGMENTOP1ATIPROC epoxy_glAlphaFragmentOp1ATI;
    PFNGLALPHAFRAGMENTOP2ATIPROC epoxy_glAlphaFragmentOp2ATI;
    PFNGLALPHAFRAGMENTOP3ATIPROC epoxy_glAlphaFragmentOp3ATI;
    PFNGLALPHAFUNCPROC epoxy_glAlphaFunc;
    PFNGLALPHAFUNCQCOMPROC epoxy_glAlphaFuncQCOM;
    PFNGLALPHAFUNCXPROC epoxy_glAlphaFuncx;
    PFNGLALPHAFUNCXOESPROC epoxy_glAlphaFuncxOES;
    PFNGLAPPLYTEXTUREEXTPROC epoxy_glApplyTextureEXT;
    PFNGLAREPROGRAMSRESIDENTNVPROC epoxy_glAreProgramsResidentNV;
    PFNGLARETEXTURESRESIDENTPROC epoxy_glAreTexturesResident;
    PFNGLARETEXTURESRESIDENTEXTPROC epoxy_glAreTexturesResidentEXT;
    PFNGLARRAYELEMENTPROC epoxy_glArrayElement;
    PFNGLARRAYELEMENTEXTPROC epoxy_glArrayElementEXT;
    PFNGLARRAYOBJECTATIPROC epoxy_glArrayObjectATI;
    PFNGLASYNCMARKERSGIXPROC epoxy_glAsyncMarkerSGIX;
    PFNGLATTACHOBJECTARBPROC epoxy_glAttachObjectARB;
    PFNGLATTACHSHADERPROC epoxy_glAttachShader;
    PFNGLBEGINPROC epoxy_glBegin_unwrapped;
    PFNGLBEGINCONDITIONALRENDERPROC epoxy_glBeginConditionalRender;
    PFNGLBEGINCONDITIONALRENDERNVPROC epoxy_glBeginConditionalRenderNV;
    PFNGLBEGINCONDITIONALRENDERNVXPROC epoxy_glBeginConditionalRenderNVX;
    PFNGLBEGINFRAGMENTSHADERATIPROC epoxy_glBeginFragmentShaderATI;
    PFNGLBEGINOCCLUSIONQUERYNVPROC epoxy_glBeginOcclusionQueryNV;
    PFNGLBEGINPERFMONITORAMDPROC epoxy_glBeginPerfMonitorAMD;
    PFNGLBEGINPERFQUERYINTELPROC epoxy_glBeginPerfQueryINTEL;
    PFNGLBEGINQUERYPROC epoxy_glBeginQuery;
    PFNGLBEGINQUERYARBPROC epoxy_glBeginQueryARB;
    PFNGLBEGINQUERYEXTPROC epoxy_glBeginQueryEXT;
    PFNGLBEGINQUERYINDEXEDPROC epoxy_glBeginQueryIndexed;
    PFNGLBEGINTRANSFORMFEEDBACKPROC epoxy_glBeginTransformFeedback;
    PFNGLBEGINTRANSFORMFEEDBACKEXTPROC epoxy_glBeginTransformFeedbackEXT;
    PFNGLBEGINTRANSFORMFEEDBACKNVPROC epoxy_glBeginTransformFeedbackNV;
    PFNGLBEGINVERTEXSHADEREXTPROC epoxy_glBeginVertexShaderEXT;
    PFNGLBEGINVIDEOCAPTURENVPROC epoxy_glBeginVideoCaptureNV;
    PFNGLBINDATTRIBLOCATIONPROC epoxy_glBindAttribLocation;
    PFNGLBINDATTRIBLOCATIONARBPROC epoxy_glBindAttribLocationARB;
    PFNGLBINDBUFFERPROC epoxy_glBindBuffer;
    PFNGLBINDBUFFERARBPROC epoxy_glBindBufferARB;
    PFNGLBINDBUFFERBASEPROC epoxy_glBindBufferBase;
    PFNGLBINDBUFFERBASEEXTPROC epoxy_glBindBufferBaseEXT;
    PFNGLBINDBUFFERBASENVPROC epoxy_glBindBufferBaseNV;
    PFNGLBINDBUFFEROFFSETEXTPROC epoxy_glBindBufferOffsetEXT;
    PFNGLBINDBUFFEROFFSETNVPROC epoxy_glBindBufferOffsetNV;
    PFNGLBINDBUFFERRANGEPROC epoxy_glBindBufferRange;
    PFNGLBINDBUFFERRANGEEXTPROC epoxy_glBindBufferRangeEXT;
    PFNGLBINDBUFFERRANGENVPROC epoxy_glBindBufferRangeNV;
    PFNGLBINDBUFFERSBASEPROC epoxy_glBindBuffersBase;
    PFNGLBINDBUFFERSRANGEPROC epoxy_glBindBuffersRange;
    PFNGLBINDFRAGDATALOCATIONPROC epoxy_glBindFragDataLocation;
    PFNGLBINDFRAGDATALOCATIONEXTPROC epoxy_glBindFragDataLocationEXT;
    PFNGLBINDFRAGDATALOCATIONINDEXEDPROC epoxy_glBindFragDataLocationIndexed;
    PFNGLBINDFRAGMENTSHADERATIPROC epoxy_glBindFragmentShaderATI;
    PFNGLBINDFRAMEBUFFERPROC epoxy_glBindFramebuffer;
    PFNGLBINDFRAMEBUFFEREXTPROC epoxy_glBindFramebufferEXT;
    PFNGLBINDFRAMEBUFFEROESPROC epoxy_glBindFramebufferOES;
    PFNGLBINDIMAGETEXTUREPROC epoxy_glBindImageTexture;
    PFNGLBINDIMAGETEXTUREEXTPROC epoxy_glBindImageTextureEXT;
    PFNGLBINDIMAGETEXTURESPROC epoxy_glBindImageTextures;
    PFNGLBINDLIGHTPARAMETEREXTPROC epoxy_glBindLightParameterEXT;
    PFNGLBINDMATERIALPARAMETEREXTPROC epoxy_glBindMaterialParameterEXT;
    PFNGLBINDMULTITEXTUREEXTPROC epoxy_glBindMultiTextureEXT;
    PFNGLBINDPARAMETEREXTPROC epoxy_glBindParameterEXT;
    PFNGLBINDPROGRAMARBPROC epoxy_glBindProgramARB;
    PFNGLBINDPROGRAMNVPROC epoxy_glBindProgramNV;
    PFNGLBINDPROGRAMPIPELINEPROC epoxy_glBindProgramPipeline;
    PFNGLBINDPROGRAMPIPELINEEXTPROC epoxy_glBindProgramPipelineEXT;
    PFNGLBINDRENDERBUFFERPROC epoxy_glBindRenderbuffer;
    PFNGLBINDRENDERBUFFEREXTPROC epoxy_glBindRenderbufferEXT;
    PFNGLBINDRENDERBUFFEROESPROC epoxy_glBindRenderbufferOES;
    PFNGLBINDSAMPLERPROC epoxy_glBindSampler;
    PFNGLBINDSAMPLERSPROC epoxy_glBindSamplers;
    PFNGLBINDTEXGENPARAMETEREXTPROC epoxy_glBindTexGenParameterEXT;
    PFNGLBINDTEXTUREPROC epoxy_glBindTexture;
    PFNGLBINDTEXTUREEXTPROC epoxy_glBindTextureEXT;
    PFNGLBINDTEXTUREUNITPROC epoxy_glBindTextureUnit;
    PFNGLBINDTEXTUREUNITPARAMETEREXTPROC epoxy_glBindTextureUnitParameterEXT;
    PFNGLBINDTEXTURESPROC epoxy_glBindTextures;
    PFNGLBINDTRANSFORMFEEDBACKPROC epoxy_glBindTransformFeedback;
    PFNGLBINDTRANSFORMFEEDBACKNVPROC epoxy_glBindTransformFeedbackNV;
    PFNGLBINDVERTEXARRAYPROC epoxy_glBindVertexArray;
    PFNGLBINDVERTEXARRAYAPPLEPROC epoxy_glBindVertexArrayAPPLE;
    PFNGLBINDVERTEXARRAYOESPROC epoxy_glBindVertexArrayOES;
    PFNGLBINDVERTEXBUFFERPROC epoxy_glBindVertexBuffer;
    PFNGLBINDVERTEXBUFFERSPROC epoxy_glBindVertexBuffers;
    PFNGLBINDVERTEXSHADEREXTPROC epoxy_glBindVertexShaderEXT;
    PFNGLBINDVIDEOCAPTURESTREAMBUFFERNVPROC epoxy_glBindVideoCaptureStreamBufferNV;
    PFNGLBINDVIDEOCAPTURESTREAMTEXTURENVPROC epoxy_glBindVideoCaptureStreamTextureNV;
    PFNGLBINORMAL3BEXTPROC epoxy_glBinormal3bEXT;
    PFNGLBINORMAL3BVEXTPROC epoxy_glBinormal3bvEXT;
    PFNGLBINORMAL3DEXTPROC epoxy_glBinormal3dEXT;
    PFNGLBINORMAL3DVEXTPROC epoxy_glBinormal3dvEXT;
    PFNGLBINORMAL3FEXTPROC epoxy_glBinormal3fEXT;
    PFNGLBINORMAL3FVEXTPROC epoxy_glBinormal3fvEXT;
    PFNGLBINORMAL3IEXTPROC epoxy_glBinormal3iEXT;
    PFNGLBINORMAL3IVEXTPROC epoxy_glBinormal3ivEXT;
    PFNGLBINORMAL3SEXTPROC epoxy_glBinormal3sEXT;
    PFNGLBINORMAL3SVEXTPROC epoxy_glBinormal3svEXT;
    PFNGLBINORMALPOINTEREXTPROC epoxy_glBinormalPointerEXT;
    PFNGLBITMAPPROC epoxy_glBitmap;
    PFNGLBITMAPXOESPROC epoxy_glBitmapxOES;
    PFNGLBLENDBARRIERKHRPROC epoxy_glBlendBarrierKHR;
    PFNGLBLENDBARRIERNVPROC epoxy_glBlendBarrierNV;
    PFNGLBLENDCOLORPROC epoxy_glBlendColor;
    PFNGLBLENDCOLOREXTPROC epoxy_glBlendColorEXT;
    PFNGLBLENDCOLORXOESPROC epoxy_glBlendColorxOES;
    PFNGLBLENDEQUATIONPROC epoxy_glBlendEquation;
    PFNGLBLENDEQUATIONEXTPROC epoxy_glBlendEquationEXT;
    PFNGLBLENDEQUATIONINDEXEDAMDPROC epoxy_glBlendEquationIndexedAMD;
    PFNGLBLENDEQUATIONOESPROC epoxy_glBlendEquationOES;
    PFNGLBLENDEQUATIONSEPARATEPROC epoxy_glBlendEquationSeparate;
    PFNGLBLENDEQUATIONSEPARATEEXTPROC epoxy_glBlendEquationSeparateEXT;
    PFNGLBLENDEQUATIONSEPARATEINDEXEDAMDPROC epoxy_glBlendEquationSeparateIndexedAMD;
    PFNGLBLENDEQUATIONSEPARATEOESPROC epoxy_glBlendEquationSeparateOES;
    PFNGLBLENDEQUATIONSEPARATEIPROC epoxy_glBlendEquationSeparatei;
    PFNGLBLENDEQUATIONSEPARATEIARBPROC epoxy_glBlendEquationSeparateiARB;
    PFNGLBLENDEQUATIONSEPARATEIEXTPROC epoxy_glBlendEquationSeparateiEXT;
    PFNGLBLENDEQUATIONSEPARATEIOESPROC epoxy_glBlendEquationSeparateiOES;
    PFNGLBLENDEQUATIONIPROC epoxy_glBlendEquationi;
    PFNGLBLENDEQUATIONIARBPROC epoxy_glBlendEquationiARB;
    PFNGLBLENDEQUATIONIEXTPROC epoxy_glBlendEquationiEXT;
    PFNGLBLENDEQUATIONIOESPROC epoxy_glBlendEquationiOES;
    PFNGLBLENDFUNCPROC epoxy_glBlendFunc;
    PFNGLBLENDFUNCINDEXEDAMDPROC epoxy_glBlendFuncIndexedAMD;
    PFNGLBLENDFUNCSEPARATEPROC epoxy_glBlendFuncSeparate;
    PFNGLBLENDFUNCSEPARATEEXTPROC epoxy_glBlendFuncSeparateEXT;
    PFNGLBLENDFUNCSEPARATEINGRPROC epoxy_glBlendFuncSeparateINGR;
    PFNGLBLENDFUNCSEPARATEINDEXEDAMDPROC epoxy_glBlendFuncSeparateIndexedAMD;
    PFNGLBLENDFUNCSEPARATEOESPROC epoxy_glBlendFuncSeparateOES;
    PFNGLBLENDFUNCSEPARATEIPROC epoxy_glBlendFuncSeparatei;
    PFNGLBLENDFUNCSEPARATEIARBPROC epoxy_glBlendFuncSeparateiARB;
    PFNGLBLENDFUNCSEPARATEIEXTPROC epoxy_glBlendFuncSeparateiEXT;
    PFNGLBLENDFUNCSEPARATEIOESPROC epoxy_glBlendFuncSeparateiOES;
    PFNGLBLENDFUNCIPROC epoxy_glBlendFunci;
    PFNGLBLENDFUNCIARBPROC epoxy_glBlendFunciARB;
    PFNGLBLENDFUNCIEXTPROC epoxy_glBlendFunciEXT;
    PFNGLBLENDFUNCIOESPROC epoxy_glBlendFunciOES;
    PFNGLBLENDPARAMETERINVPROC epoxy_glBlendParameteriNV;
    PFNGLBLITFRAMEBUFFERPROC epoxy_glBlitFramebuffer;
    PFNGLBLITFRAMEBUFFERANGLEPROC epoxy_glBlitFramebufferANGLE;
    PFNGLBLITFRAMEBUFFEREXTPROC epoxy_glBlitFramebufferEXT;
    PFNGLBLITFRAMEBUFFERNVPROC epoxy_glBlitFramebufferNV;
    PFNGLBLITNAMEDFRAMEBUFFERPROC epoxy_glBlitNamedFramebuffer;
    PFNGLBUFFERADDRESSRANGENVPROC epoxy_glBufferAddressRangeNV;
    PFNGLBUFFERDATAPROC epoxy_glBufferData;
    PFNGLBUFFERDATAARBPROC epoxy_glBufferDataARB;
    PFNGLBUFFERPAGECOMMITMENTARBPROC epoxy_glBufferPageCommitmentARB;
    PFNGLBUFFERPARAMETERIAPPLEPROC epoxy_glBufferParameteriAPPLE;
    PFNGLBUFFERSTORAGEPROC epoxy_glBufferStorage;
    PFNGLBUFFERSTORAGEEXTPROC epoxy_glBufferStorageEXT;
    PFNGLBUFFERSUBDATAPROC epoxy_glBufferSubData;
    PFNGLBUFFERSUBDATAARBPROC epoxy_glBufferSubDataARB;
    PFNGLCALLCOMMANDLISTNVPROC epoxy_glCallCommandListNV;
    PFNGLCALLLISTPROC epoxy_glCallList;
    PFNGLCALLLISTSPROC epoxy_glCallLists;
    PFNGLCHECKFRAMEBUFFERSTATUSPROC epoxy_glCheckFramebufferStatus;
    PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC epoxy_glCheckFramebufferStatusEXT;
    PFNGLCHECKFRAMEBUFFERSTATUSOESPROC epoxy_glCheckFramebufferStatusOES;
    PFNGLCHECKNAMEDFRAMEBUFFERSTATUSPROC epoxy_glCheckNamedFramebufferStatus;
    PFNGLCHECKNAMEDFRAMEBUFFERSTATUSEXTPROC epoxy_glCheckNamedFramebufferStatusEXT;
    PFNGLCLAMPCOLORPROC epoxy_glClampColor;
    PFNGLCLAMPCOLORARBPROC epoxy_glClampColorARB;
    PFNGLCLEARPROC epoxy_glClear;
    PFNGLCLEARACCUMPROC epoxy_glClearAccum;
    PFNGLCLEARACCUMXOESPROC epoxy_glClearAccumxOES;
    PFNGLCLEARBUFFERDATAPROC epoxy_glClearBufferData;
    PFNGLCLEARBUFFERSUBDATAPROC epoxy_glClearBufferSubData;
    PFNGLCLEARBUFFERFIPROC epoxy_glClearBufferfi;
    PFNGLCLEARBUFFERFVPROC epoxy_glClearBufferfv;
    PFNGLCLEARBUFFERIVPROC epoxy_glClearBufferiv;
    PFNGLCLEARBUFFERUIVPROC epoxy_glClearBufferuiv;
    PFNGLCLEARCOLORPROC epoxy_glClearColor;
    PFNGLCLEARCOLORIIEXTPROC epoxy_glClearColorIiEXT;
    PFNGLCLEARCOLORIUIEXTPROC epoxy_glClearColorIuiEXT;
    PFNGLCLEARCOLORXPROC epoxy_glClearColorx;
    PFNGLCLEARCOLORXOESPROC epoxy_glClearColorxOES;
    PFNGLCLEARDEPTHPROC epoxy_glClearDepth;
    PFNGLCLEARDEPTHDNVPROC epoxy_glClearDepthdNV;
    PFNGLCLEARDEPTHFPROC epoxy_glClearDepthf;
    PFNGLCLEARDEPTHFOESPROC epoxy_glClearDepthfOES;
    PFNGLCLEARDEPTHXPROC epoxy_glClearDepthx;
    PFNGLCLEARDEPTHXOESPROC epoxy_glClearDepthxOES;
    PFNGLCLEARINDEXPROC epoxy_glClearIndex;
    PFNGLCLEARNAMEDBUFFERDATAPROC epoxy_glClearNamedBufferData;
    PFNGLCLEARNAMEDBUFFERDATAEXTPROC epoxy_glClearNamedBufferDataEXT;
    PFNGLCLEARNAMEDBUFFERSUBDATAPROC epoxy_glClearNamedBufferSubData;
    PFNGLCLEARNAMEDBUFFERSUBDATAEXTPROC epoxy_glClearNamedBufferSubDataEXT;
    PFNGLCLEARNAMEDFRAMEBUFFERFIPROC epoxy_glClearNamedFramebufferfi;
    PFNGLCLEARNAMEDFRAMEBUFFERFVPROC epoxy_glClearNamedFramebufferfv;
    PFNGLCLEARNAMEDFRAMEBUFFERIVPROC epoxy_glClearNamedFramebufferiv;
    PFNGLCLEARNAMEDFRAMEBUFFERUIVPROC epoxy_glClearNamedFramebufferuiv;
    PFNGLCLEARSTENCILPROC epoxy_glClearStencil;
    PFNGLCLEARTEXIMAGEPROC epoxy_glClearTexImage;
    PFNGLCLEARTEXSUBIMAGEPROC epoxy_glClearTexSubImage;
    PFNGLCLIENTACTIVETEXTUREPROC epoxy_glClientActiveTexture;
    PFNGLCLIENTACTIVETEXTUREARBPROC epoxy_glClientActiveTextureARB;
    PFNGLCLIENTACTIVEVERTEXSTREAMATIPROC epoxy_glClientActiveVertexStreamATI;
    PFNGLCLIENTATTRIBDEFAULTEXTPROC epoxy_glClientAttribDefaultEXT;
    PFNGLCLIENTWAITSYNCPROC epoxy_glClientWaitSync;
    PFNGLCLIENTWAITSYNCAPPLEPROC epoxy_glClientWaitSyncAPPLE;
    PFNGLCLIPCONTROLPROC epoxy_glClipControl;
    PFNGLCLIPPLANEPROC epoxy_glClipPlane;
    PFNGLCLIPPLANEFPROC epoxy_glClipPlanef;
    PFNGLCLIPPLANEFIMGPROC epoxy_glClipPlanefIMG;
    PFNGLCLIPPLANEFOESPROC epoxy_glClipPlanefOES;
    PFNGLCLIPPLANEXPROC epoxy_glClipPlanex;
    PFNGLCLIPPLANEXIMGPROC epoxy_glClipPlanexIMG;
    PFNGLCLIPPLANEXOESPROC epoxy_glClipPlanexOES;
    PFNGLCOLOR3BPROC epoxy_glColor3b;
    PFNGLCOLOR3BVPROC epoxy_glColor3bv;
    PFNGLCOLOR3DPROC epoxy_glColor3d;
    PFNGLCOLOR3DVPROC epoxy_glColor3dv;
    PFNGLCOLOR3FPROC epoxy_glColor3f;
    PFNGLCOLOR3FVERTEX3FSUNPROC epoxy_glColor3fVertex3fSUN;
    PFNGLCOLOR3FVERTEX3FVSUNPROC epoxy_glColor3fVertex3fvSUN;
    PFNGLCOLOR3FVPROC epoxy_glColor3fv;
    PFNGLCOLOR3HNVPROC epoxy_glColor3hNV;
    PFNGLCOLOR3HVNVPROC epoxy_glColor3hvNV;
    PFNGLCOLOR3IPROC epoxy_glColor3i;
    PFNGLCOLOR3IVPROC epoxy_glColor3iv;
    PFNGLCOLOR3SPROC epoxy_glColor3s;
    PFNGLCOLOR3SVPROC epoxy_glColor3sv;
    PFNGLCOLOR3UBPROC epoxy_glColor3ub;
    PFNGLCOLOR3UBVPROC epoxy_glColor3ubv;
    PFNGLCOLOR3UIPROC epoxy_glColor3ui;
    PFNGLCOLOR3UIVPROC epoxy_glColor3uiv;
    PFNGLCOLOR3USPROC epoxy_glColor3us;
    PFNGLCOLOR3USVPROC epoxy_glColor3usv;
    PFNGLCOLOR3XOESPROC epoxy_glColor3xOES;
    PFNGLCOLOR3XVOESPROC epoxy_glColor3xvOES;
    PFNGLCOLOR4BPROC epoxy_glColor4b;
    PFNGLCOLOR4BVPROC epoxy_glColor4bv;
    PFNGLCOLOR4DPROC epoxy_glColor4d;
    PFNGLCOLOR4DVPROC epoxy_glColor4dv;
    PFNGLCOLOR4FPROC epoxy_glColor4f;
    PFNGLCOLOR4FNORMAL3FVERTEX3FSUNPROC epoxy_glColor4fNormal3fVertex3fSUN;
    PFNGLCOLOR4FNORMAL3FVERTEX3FVSUNPROC epoxy_glColor4fNormal3fVertex3fvSUN;
    PFNGLCOLOR4FVPROC epoxy_glColor4fv;
    PFNGLCOLOR4HNVPROC epoxy_glColor4hNV;
    PFNGLCOLOR4HVNVPROC epoxy_glColor4hvNV;
    PFNGLCOLOR4IPROC epoxy_glColor4i;
    PFNGLCOLOR4IVPROC epoxy_glColor4iv;
    PFNGLCOLOR4SPROC epoxy_glColor4s;
    PFNGLCOLOR4SVPROC epoxy_glColor4sv;
    PFNGLCOLOR4UBPROC epoxy_glColor4ub;
    PFNGLCOLOR4UBVERTEX2FSUNPROC epoxy_glColor4ubVertex2fSUN;
    PFNGLCOLOR4UBVERTEX2FVSUNPROC epoxy_glColor4ubVertex2fvSUN;
    PFNGLCOLOR4UBVERTEX3FSUNPROC epoxy_glColor4ubVertex3fSUN;
    PFNGLCOLOR4UBVERTEX3FVSUNPROC epoxy_glColor4ubVertex3fvSUN;
    PFNGLCOLOR4UBVPROC epoxy_glColor4ubv;
    PFNGLCOLOR4UIPROC epoxy_glColor4ui;
    PFNGLCOLOR4UIVPROC epoxy_glColor4uiv;
    PFNGLCOLOR4USPROC epoxy_glColor4us;
    PFNGLCOLOR4USVPROC epoxy_glColor4usv;
    PFNGLCOLOR4XPROC epoxy_glColor4x;
    PFNGLCOLOR4XOESPROC epoxy_glColor4xOES;
    PFNGLCOLOR4XVOESPROC epoxy_glColor4xvOES;
    PFNGLCOLORFORMATNVPROC epoxy_glColorFormatNV;
    PFNGLCOLORFRAGMENTOP1ATIPROC epoxy_glColorFragmentOp1ATI;
    PFNGLCOLORFRAGMENTOP2ATIPROC epoxy_glColorFragmentOp2ATI;
    PFNGLCOLORFRAGMENTOP3ATIPROC epoxy_glColorFragmentOp3ATI;
    PFNGLCOLORMASKPROC epoxy_glColorMask;
    PFNGLCOLORMASKINDEXEDEXTPROC epoxy_glColorMaskIndexedEXT;
    PFNGLCOLORMASKIPROC epoxy_glColorMaski;
    PFNGLCOLORMASKIEXTPROC epoxy_glColorMaskiEXT;
    PFNGLCOLORMASKIOESPROC epoxy_glColorMaskiOES;
    PFNGLCOLORMATERIALPROC epoxy_glColorMaterial;
    PFNGLCOLORP3UIPROC epoxy_glColorP3ui;
    PFNGLCOLORP3UIVPROC epoxy_glColorP3uiv;
    PFNGLCOLORP4UIPROC epoxy_glColorP4ui;
    PFNGLCOLORP4UIVPROC epoxy_glColorP4uiv;
    PFNGLCOLORPOINTERPROC epoxy_glColorPointer;
    PFNGLCOLORPOINTEREXTPROC epoxy_glColorPointerEXT;
    PFNGLCOLORPOINTERLISTIBMPROC epoxy_glColorPointerListIBM;
    PFNGLCOLORPOINTERVINTELPROC epoxy_glColorPointervINTEL;
    PFNGLCOLORSUBTABLEPROC epoxy_glColorSubTable;
    PFNGLCOLORSUBTABLEEXTPROC epoxy_glColorSubTableEXT;
    PFNGLCOLORTABLEPROC epoxy_glColorTable;
    PFNGLCOLORTABLEEXTPROC epoxy_glColorTableEXT;
    PFNGLCOLORTABLEPARAMETERFVPROC epoxy_glColorTableParameterfv;
    PFNGLCOLORTABLEPARAMETERFVSGIPROC epoxy_glColorTableParameterfvSGI;
    PFNGLCOLORTABLEPARAMETERIVPROC epoxy_glColorTableParameteriv;
    PFNGLCOLORTABLEPARAMETERIVSGIPROC epoxy_glColorTableParameterivSGI;
    PFNGLCOLORTABLESGIPROC epoxy_glColorTableSGI;
    PFNGLCOMBINERINPUTNVPROC epoxy_glCombinerInputNV;
    PFNGLCOMBINEROUTPUTNVPROC epoxy_glCombinerOutputNV;
    PFNGLCOMBINERPARAMETERFNVPROC epoxy_glCombinerParameterfNV;
    PFNGLCOMBINERPARAMETERFVNVPROC epoxy_glCombinerParameterfvNV;
    PFNGLCOMBINERPARAMETERINVPROC epoxy_glCombinerParameteriNV;
    PFNGLCOMBINERPARAMETERIVNVPROC epoxy_glCombinerParameterivNV;
    PFNGLCOMBINERSTAGEPARAMETERFVNVPROC epoxy_glCombinerStageParameterfvNV;
    PFNGLCOMMANDLISTSEGMENTSNVPROC epoxy_glCommandListSegmentsNV;
    PFNGLCOMPILECOMMANDLISTNVPROC epoxy_glCompileCommandListNV;
    PFNGLCOMPILESHADERPROC epoxy_glCompileShader;
    PFNGLCOMPILESHADERARBPROC epoxy_glCompileShaderARB;
    PFNGLCOMPILESHADERINCLUDEARBPROC epoxy_glCompileShaderIncludeARB;
    PFNGLCOMPRESSEDMULTITEXIMAGE1DEXTPROC epoxy_glCompressedMultiTexImage1DEXT;
    PFNGLCOMPRESSEDMULTITEXIMAGE2DEXTPROC epoxy_glCompressedMultiTexImage2DEXT;
    PFNGLCOMPRESSEDMULTITEXIMAGE3DEXTPROC epoxy_glCompressedMultiTexImage3DEXT;
    PFNGLCOMPRESSEDMULTITEXSUBIMAGE1DEXTPROC epoxy_glCompressedMultiTexSubImage1DEXT;
    PFNGLCOMPRESSEDMULTITEXSUBIMAGE2DEXTPROC epoxy_glCompressedMultiTexSubImage2DEXT;
    PFNGLCOMPRESSEDMULTITEXSUBIMAGE3DEXTPROC epoxy_glCompressedMultiTexSubImage3DEXT;
    PFNGLCOMPRESSEDTEXIMAGE1DPROC epoxy_glCompressedTexImage1D;
    PFNGLCOMPRESSEDTEXIMAGE1DARBPROC epoxy_glCompressedTexImage1DARB;
    PFNGLCOMPRESSEDTEXIMAGE2DPROC epoxy_glCompressedTexImage2D;
    PFNGLCOMPRESSEDTEXIMAGE2DARBPROC epoxy_glCompressedTexImage2DARB;
    PFNGLCOMPRESSEDTEXIMAGE3DPROC epoxy_glCompressedTexImage3D;
    PFNGLCOMPRESSEDTEXIMAGE3DARBPROC epoxy_glCompressedTexImage3DARB;
    PFNGLCOMPRESSEDTEXIMAGE3DOESPROC epoxy_glCompressedTexImage3DOES;
    PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC epoxy_glCompressedTexSubImage1D;
    PFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC epoxy_glCompressedTexSubImage1DARB;
    PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC epoxy_glCompressedTexSubImage2D;
    PFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC epoxy_glCompressedTexSubImage2DARB;
    PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC epoxy_glCompressedTexSubImage3D;
    PFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC epoxy_glCompressedTexSubImage3DARB;
    PFNGLCOMPRESSEDTEXSUBIMAGE3DOESPROC epoxy_glCompressedTexSubImage3DOES;
    PFNGLCOMPRESSEDTEXTUREIMAGE1DEXTPROC epoxy_glCompressedTextureImage1DEXT;
    PFNGLCOMPRESSEDTEXTUREIMAGE2DEXTPROC epoxy_glCompressedTextureImage2DEXT;
    PFNGLCOMPRESSEDTEXTUREIMAGE3DEXTPROC epoxy_glCompressedTextureImage3DEXT;
    PFNGLCOMPRESSEDTEXTURESUBIMAGE1DPROC epoxy_glCompressedTextureSubImage1D;
    PFNGLCOMPRESSEDTEXTURESUBIMAGE1DEXTPROC epoxy_glCompressedTextureSubImage1DEXT;
    PFNGLCOMPRESSEDTEXTURESUBIMAGE2DPROC epoxy_glCompressedTextureSubImage2D;
    PFNGLCOMPRESSEDTEXTURESUBIMAGE2DEXTPROC epoxy_glCompressedTextureSubImage2DEXT;
    PFNGLCOMPRESSEDTEXTURESUBIMAGE3DPROC epoxy_glCompressedTextureSubImage3D;
    PFNGLCOMPRESSEDTEXTURESUBIMAGE3DEXTPROC epoxy_glCompressedTextureSubImage3DEXT;
    PFNGLCONVOLUTIONFILTER1DPROC epoxy_glConvolutionFilter1D;
    PFNGLCONVOLUTIONFILTER1DEXTPROC epoxy_glConvolutionFilter1DEXT;
    PFNGLCONVOLUTIONFILTER2DPROC epoxy_glConvolutionFilter2D;
    PFNGLCONVOLUTIONFILTER2DEXTPROC epoxy_glConvolutionFilter2DEXT;
    PFNGLCONVOLUTIONPARAMETERFPROC epoxy_glConvolutionParameterf;
    PFNGLCONVOLUTIONPARAMETERFEXTPROC epoxy_glConvolutionParameterfEXT;
    PFNGLCONVOLUTIONPARAMETERFVPROC epoxy_glConvolutionParameterfv;
    PFNGLCONVOLUTIONPARAMETERFVEXTPROC epoxy_glConvolutionParameterfvEXT;
    PFNGLCONVOLUTIONPARAMETERIPROC epoxy_glConvolutionParameteri;
    PFNGLCONVOLUTIONPARAMETERIEXTPROC epoxy_glConvolutionParameteriEXT;
    PFNGLCONVOLUTIONPARAMETERIVPROC epoxy_glConvolutionParameteriv;
    PFNGLCONVOLUTIONPARAMETERIVEXTPROC epoxy_glConvolutionParameterivEXT;
    PFNGLCONVOLUTIONPARAMETERXOESPROC epoxy_glConvolutionParameterxOES;
    PFNGLCONVOLUTIONPARAMETERXVOESPROC epoxy_glConvolutionParameterxvOES;
    PFNGLCOPYBUFFERSUBDATAPROC epoxy_glCopyBufferSubData;
    PFNGLCOPYBUFFERSUBDATANVPROC epoxy_glCopyBufferSubDataNV;
    PFNGLCOPYCOLORSUBTABLEPROC epoxy_glCopyColorSubTable;
    PFNGLCOPYCOLORSUBTABLEEXTPROC epoxy_glCopyColorSubTableEXT;
    PFNGLCOPYCOLORTABLEPROC epoxy_glCopyColorTable;
    PFNGLCOPYCOLORTABLESGIPROC epoxy_glCopyColorTableSGI;
    PFNGLCOPYCONVOLUTIONFILTER1DPROC epoxy_glCopyConvolutionFilter1D;
    PFNGLCOPYCONVOLUTIONFILTER1DEXTPROC epoxy_glCopyConvolutionFilter1DEXT;
    PFNGLCOPYCONVOLUTIONFILTER2DPROC epoxy_glCopyConvolutionFilter2D;
    PFNGLCOPYCONVOLUTIONFILTER2DEXTPROC epoxy_glCopyConvolutionFilter2DEXT;
    PFNGLCOPYIMAGESUBDATAPROC epoxy_glCopyImageSubData;
    PFNGLCOPYIMAGESUBDATAEXTPROC epoxy_glCopyImageSubDataEXT;
    PFNGLCOPYIMAGESUBDATANVPROC epoxy_glCopyImageSubDataNV;
    PFNGLCOPYIMAGESUBDATAOESPROC epoxy_glCopyImageSubDataOES;
    PFNGLCOPYMULTITEXIMAGE1DEXTPROC epoxy_glCopyMultiTexImage1DEXT;
    PFNGLCOPYMULTITEXIMAGE2DEXTPROC epoxy_glCopyMultiTexImage2DEXT;
    PFNGLCOPYMULTITEXSUBIMAGE1DEXTPROC epoxy_glCopyMultiTexSubImage1DEXT;
    PFNGLCOPYMULTITEXSUBIMAGE2DEXTPROC epoxy_glCopyMultiTexSubImage2DEXT;
    PFNGLCOPYMULTITEXSUBIMAGE3DEXTPROC epoxy_glCopyMultiTexSubImage3DEXT;
    PFNGLCOPYNAMEDBUFFERSUBDATAPROC epoxy_glCopyNamedBufferSubData;
    PFNGLCOPYPATHNVPROC epoxy_glCopyPathNV;
    PFNGLCOPYPIXELSPROC epoxy_glCopyPixels;
    PFNGLCOPYTEXIMAGE1DPROC epoxy_glCopyTexImage1D;
    PFNGLCOPYTEXIMAGE1DEXTPROC epoxy_glCopyTexImage1DEXT;
    PFNGLCOPYTEXIMAGE2DPROC epoxy_glCopyTexImage2D;
    PFNGLCOPYTEXIMAGE2DEXTPROC epoxy_glCopyTexImage2DEXT;
    PFNGLCOPYTEXSUBIMAGE1DPROC epoxy_glCopyTexSubImage1D;
    PFNGLCOPYTEXSUBIMAGE1DEXTPROC epoxy_glCopyTexSubImage1DEXT;
    PFNGLCOPYTEXSUBIMAGE2DPROC epoxy_glCopyTexSubImage2D;
    PFNGLCOPYTEXSUBIMAGE2DEXTPROC epoxy_glCopyTexSubImage2DEXT;
    PFNGLCOPYTEXSUBIMAGE3DPROC epoxy_glCopyTexSubImage3D;
    PFNGLCOPYTEXSUBIMAGE3DEXTPROC epoxy_glCopyTexSubImage3DEXT;
    PFNGLCOPYTEXSUBIMAGE3DOESPROC epoxy_glCopyTexSubImage3DOES;
    PFNGLCOPYTEXTUREIMAGE1DEXTPROC epoxy_glCopyTextureImage1DEXT;
    PFNGLCOPYTEXTUREIMAGE2DEXTPROC epoxy_glCopyTextureImage2DEXT;
    PFNGLCOPYTEXTURELEVELSAPPLEPROC epoxy_glCopyTextureLevelsAPPLE;
    PFNGLCOPYTEXTURESUBIMAGE1DPROC epoxy_glCopyTextureSubImage1D;
    PFNGLCOPYTEXTURESUBIMAGE1DEXTPROC epoxy_glCopyTextureSubImage1DEXT;
    PFNGLCOPYTEXTURESUBIMAGE2DPROC epoxy_glCopyTextureSubImage2D;
    PFNGLCOPYTEXTURESUBIMAGE2DEXTPROC epoxy_glCopyTextureSubImage2DEXT;
    PFNGLCOPYTEXTURESUBIMAGE3DPROC epoxy_glCopyTextureSubImage3D;
    PFNGLCOPYTEXTURESUBIMAGE3DEXTPROC epoxy_glCopyTextureSubImage3DEXT;
    PFNGLCOVERFILLPATHINSTANCEDNVPROC epoxy_glCoverFillPathInstancedNV;
    PFNGLCOVERFILLPATHNVPROC epoxy_glCoverFillPathNV;
    PFNGLCOVERSTROKEPATHINSTANCEDNVPROC epoxy_glCoverStrokePathInstancedNV;
    PFNGLCOVERSTROKEPATHNVPROC epoxy_glCoverStrokePathNV;
    PFNGLCOVERAGEMASKNVPROC epoxy_glCoverageMaskNV;
    PFNGLCOVERAGEMODULATIONNVPROC epoxy_glCoverageModulationNV;
    PFNGLCOVERAGEMODULATIONTABLENVPROC epoxy_glCoverageModulationTableNV;
    PFNGLCOVERAGEOPERATIONNVPROC epoxy_glCoverageOperationNV;
    PFNGLCREATEBUFFERSPROC epoxy_glCreateBuffers;
    PFNGLCREATECOMMANDLISTSNVPROC epoxy_glCreateCommandListsNV;
    PFNGLCREATEFRAMEBUFFERSPROC epoxy_glCreateFramebuffers;
    PFNGLCREATEPERFQUERYINTELPROC epoxy_glCreatePerfQueryINTEL;
    PFNGLCREATEPROGRAMPROC epoxy_glCreateProgram;
    PFNGLCREATEPROGRAMOBJECTARBPROC epoxy_glCreateProgramObjectARB;
    PFNGLCREATEPROGRAMPIPELINESPROC epoxy_glCreateProgramPipelines;
    PFNGLCREATEQUERIESPROC epoxy_glCreateQueries;
    PFNGLCREATERENDERBUFFERSPROC epoxy_glCreateRenderbuffers;
    PFNGLCREATESAMPLERSPROC epoxy_glCreateSamplers;
    PFNGLCREATESHADERPROC epoxy_glCreateShader;
    PFNGLCREATESHADEROBJECTARBPROC epoxy_glCreateShaderObjectARB;
    PFNGLCREATESHADERPROGRAMEXTPROC epoxy_glCreateShaderProgramEXT;
    PFNGLCREATESHADERPROGRAMVPROC epoxy_glCreateShaderProgramv;
    PFNGLCREATESHADERPROGRAMVEXTPROC epoxy_glCreateShaderProgramvEXT;
    PFNGLCREATESTATESNVPROC epoxy_glCreateStatesNV;
    PFNGLCREATESYNCFROMCLEVENTARBPROC epoxy_glCreateSyncFromCLeventARB;
    PFNGLCREATETEXTURESPROC epoxy_glCreateTextures;
    PFNGLCREATETRANSFORMFEEDBACKSPROC epoxy_glCreateTransformFeedbacks;
    PFNGLCREATEVERTEXARRAYSPROC epoxy_glCreateVertexArrays;
    PFNGLCULLFACEPROC epoxy_glCullFace;
    PFNGLCULLPARAMETERDVEXTPROC epoxy_glCullParameterdvEXT;
    PFNGLCULLPARAMETERFVEXTPROC epoxy_glCullParameterfvEXT;
    PFNGLCURRENTPALETTEMATRIXARBPROC epoxy_glCurrentPaletteMatrixARB;
    PFNGLCURRENTPALETTEMATRIXOESPROC epoxy_glCurrentPaletteMatrixOES;
    PFNGLDEBUGMESSAGECALLBACKPROC epoxy_glDebugMessageCallback;
    PFNGLDEBUGMESSAGECALLBACKAMDPROC epoxy_glDebugMessageCallbackAMD;
    PFNGLDEBUGMESSAGECALLBACKARBPROC epoxy_glDebugMessageCallbackARB;
    PFNGLDEBUGMESSAGECALLBACKKHRPROC epoxy_glDebugMessageCallbackKHR;
    PFNGLDEBUGMESSAGECONTROLPROC epoxy_glDebugMessageControl;
    PFNGLDEBUGMESSAGECONTROLARBPROC epoxy_glDebugMessageControlARB;
    PFNGLDEBUGMESSAGECONTROLKHRPROC epoxy_glDebugMessageControlKHR;
    PFNGLDEBUGMESSAGEENABLEAMDPROC epoxy_glDebugMessageEnableAMD;
    PFNGLDEBUGMESSAGEINSERTPROC epoxy_glDebugMessageInsert;
    PFNGLDEBUGMESSAGEINSERTAMDPROC epoxy_glDebugMessageInsertAMD;
    PFNGLDEBUGMESSAGEINSERTARBPROC epoxy_glDebugMessageInsertARB;
    PFNGLDEBUGMESSAGEINSERTKHRPROC epoxy_glDebugMessageInsertKHR;
    PFNGLDEFORMSGIXPROC epoxy_glDeformSGIX;
    PFNGLDEFORMATIONMAP3DSGIXPROC epoxy_glDeformationMap3dSGIX;
    PFNGLDEFORMATIONMAP3FSGIXPROC epoxy_glDeformationMap3fSGIX;
    PFNGLDELETEASYNCMARKERSSGIXPROC epoxy_glDeleteAsyncMarkersSGIX;
    PFNGLDELETEBUFFERSPROC epoxy_glDeleteBuffers;
    PFNGLDELETEBUFFERSARBPROC epoxy_glDeleteBuffersARB;
    PFNGLDELETECOMMANDLISTSNVPROC epoxy_glDeleteCommandListsNV;
    PFNGLDELETEFENCESAPPLEPROC epoxy_glDeleteFencesAPPLE;
    PFNGLDELETEFENCESNVPROC epoxy_glDeleteFencesNV;
    PFNGLDELETEFRAGMENTSHADERATIPROC epoxy_glDeleteFragmentShaderATI;
    PFNGLDELETEFRAMEBUFFERSPROC epoxy_glDeleteFramebuffers;
    PFNGLDELETEFRAMEBUFFERSEXTPROC epoxy_glDeleteFramebuffersEXT;
    PFNGLDELETEFRAMEBUFFERSOESPROC epoxy_glDeleteFramebuffersOES;
    PFNGLDELETELISTSPROC epoxy_glDeleteLists;
    PFNGLDELETENAMEDSTRINGARBPROC epoxy_glDeleteNamedStringARB;
    PFNGLDELETENAMESAMDPROC epoxy_glDeleteNamesAMD;
    PFNGLDELETEOBJECTARBPROC epoxy_glDeleteObjectARB;
    PFNGLDELETEOCCLUSIONQUERIESNVPROC epoxy_glDeleteOcclusionQueriesNV;
    PFNGLDELETEPATHSNVPROC epoxy_glDeletePathsNV;
    PFNGLDELETEPERFMONITORSAMDPROC epoxy_glDeletePerfMonitorsAMD;
    PFNGLDELETEPERFQUERYINTELPROC epoxy_glDeletePerfQueryINTEL;
    PFNGLDELETEPROGRAMPROC epoxy_glDeleteProgram;
    PFNGLDELETEPROGRAMPIPELINESPROC epoxy_glDeleteProgramPipelines;
    PFNGLDELETEPROGRAMPIPELINESEXTPROC epoxy_glDeleteProgramPipelinesEXT;
    PFNGLDELETEPROGRAMSARBPROC epoxy_glDeleteProgramsARB;
    PFNGLDELETEPROGRAMSNVPROC epoxy_glDeleteProgramsNV;
    PFNGLDELETEQUERIESPROC epoxy_glDeleteQueries;
    PFNGLDELETEQUERIESARBPROC epoxy_glDeleteQueriesARB;
    PFNGLDELETEQUERIESEXTPROC epoxy_glDeleteQueriesEXT;
    PFNGLDELETERENDERBUFFERSPROC epoxy_glDeleteRenderbuffers;
    PFNGLDELETERENDERBUFFERSEXTPROC epoxy_glDeleteRenderbuffersEXT;
    PFNGLDELETERENDERBUFFERSOESPROC epoxy_glDeleteRenderbuffersOES;
    PFNGLDELETESAMPLERSPROC epoxy_glDeleteSamplers;
    PFNGLDELETESHADERPROC epoxy_glDeleteShader;
    PFNGLDELETESTATESNVPROC epoxy_glDeleteStatesNV;
    PFNGLDELETESYNCPROC epoxy_glDeleteSync;
    PFNGLDELETESYNCAPPLEPROC epoxy_glDeleteSyncAPPLE;
    PFNGLDELETETEXTURESPROC epoxy_glDeleteTextures;
    PFNGLDELETETEXTURESEXTPROC epoxy_glDeleteTexturesEXT;
    PFNGLDELETETRANSFORMFEEDBACKSPROC epoxy_glDeleteTransformFeedbacks;
    PFNGLDELETETRANSFORMFEEDBACKSNVPROC epoxy_glDeleteTransformFeedbacksNV;
    PFNGLDELETEVERTEXARRAYSPROC epoxy_glDeleteVertexArrays;
    PFNGLDELETEVERTEXARRAYSAPPLEPROC epoxy_glDeleteVertexArraysAPPLE;
    PFNGLDELETEVERTEXARRAYSOESPROC epoxy_glDeleteVertexArraysOES;
    PFNGLDELETEVERTEXSHADEREXTPROC epoxy_glDeleteVertexShaderEXT;
    PFNGLDEPTHBOUNDSEXTPROC epoxy_glDepthBoundsEXT;
    PFNGLDEPTHBOUNDSDNVPROC epoxy_glDepthBoundsdNV;
    PFNGLDEPTHFUNCPROC epoxy_glDepthFunc;
    PFNGLDEPTHMASKPROC epoxy_glDepthMask;
    PFNGLDEPTHRANGEPROC epoxy_glDepthRange;
    PFNGLDEPTHRANGEARRAYFVNVPROC epoxy_glDepthRangeArrayfvNV;
    PFNGLDEPTHRANGEARRAYVPROC epoxy_glDepthRangeArrayv;
    PFNGLDEPTHRANGEINDEXEDPROC epoxy_glDepthRangeIndexed;
    PFNGLDEPTHRANGEINDEXEDFNVPROC epoxy_glDepthRangeIndexedfNV;
    PFNGLDEPTHRANGEDNVPROC epoxy_glDepthRangedNV;
    PFNGLDEPTHRANGEFPROC epoxy_glDepthRangef;
    PFNGLDEPTHRANGEFOESPROC epoxy_glDepthRangefOES;
    PFNGLDEPTHRANGEXPROC epoxy_glDepthRangex;
    PFNGLDEPTHRANGEXOESPROC epoxy_glDepthRangexOES;
    PFNGLDETACHOBJECTARBPROC epoxy_glDetachObjectARB;
    PFNGLDETACHSHADERPROC epoxy_glDetachShader;
    PFNGLDETAILTEXFUNCSGISPROC epoxy_glDetailTexFuncSGIS;
    PFNGLDISABLEPROC epoxy_glDisable;
    PFNGLDISABLECLIENTSTATEPROC epoxy_glDisableClientState;
    PFNGLDISABLECLIENTSTATEINDEXEDEXTPROC epoxy_glDisableClientStateIndexedEXT;
    PFNGLDISABLECLIENTSTATEIEXTPROC epoxy_glDisableClientStateiEXT;
    PFNGLDISABLEDRIVERCONTROLQCOMPROC epoxy_glDisableDriverControlQCOM;
    PFNGLDISABLEINDEXEDEXTPROC epoxy_glDisableIndexedEXT;
    PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC epoxy_glDisableVariantClientStateEXT;
    PFNGLDISABLEVERTEXARRAYATTRIBPROC epoxy_glDisableVertexArrayAttrib;
    PFNGLDISABLEVERTEXARRAYATTRIBEXTPROC epoxy_glDisableVertexArrayAttribEXT;
    PFNGLDISABLEVERTEXARRAYEXTPROC epoxy_glDisableVertexArrayEXT;
    PFNGLDISABLEVERTEXATTRIBAPPLEPROC epoxy_glDisableVertexAttribAPPLE;
    PFNGLDISABLEVERTEXATTRIBARRAYPROC epoxy_glDisableVertexAttribArray;
    PFNGLDISABLEVERTEXATTRIBARRAYARBPROC epoxy_glDisableVertexAttribArrayARB;
    PFNGLDISABLEIPROC epoxy_glDisablei;
    PFNGLDISABLEIEXTPROC epoxy_glDisableiEXT;
    PFNGLDISABLEINVPROC epoxy_glDisableiNV;
    PFNGLDISABLEIOESPROC epoxy_glDisableiOES;
    PFNGLDISCARDFRAMEBUFFEREXTPROC epoxy_glDiscardFramebufferEXT;
    PFNGLDISPATCHCOMPUTEPROC epoxy_glDispatchCompute;
    PFNGLDISPATCHCOMPUTEGROUPSIZEARBPROC epoxy_glDispatchComputeGroupSizeARB;
    PFNGLDISPATCHCOMPUTEINDIRECTPROC epoxy_glDispatchComputeIndirect;
    PFNGLDRAWARRAYSPROC epoxy_glDrawArrays;
    PFNGLDRAWARRAYSEXTPROC epoxy_glDrawArraysEXT;
    PFNGLDRAWARRAYSINDIRECTPROC epoxy_glDrawArraysIndirect;
    PFNGLDRAWARRAYSINSTANCEDPROC epoxy_glDrawArraysInstanced;
    PFNGLDRAWARRAYSINSTANCEDANGLEPROC epoxy_glDrawArraysInstancedANGLE;
    PFNGLDRAWARRAYSINSTANCEDARBPROC epoxy_glDrawArraysInstancedARB;
    PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC epoxy_glDrawArraysInstancedBaseInstance;
    PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEEXTPROC epoxy_glDrawArraysInstancedBaseInstanceEXT;
    PFNGLDRAWARRAYSINSTANCEDEXTPROC epoxy_glDrawArraysInstancedEXT;
    PFNGLDRAWARRAYSINSTANCEDNVPROC epoxy_glDrawArraysInstancedNV;
    PFNGLDRAWBUFFERPROC epoxy_glDrawBuffer;
    PFNGLDRAWBUFFERSPROC epoxy_glDrawBuffers;
    PFNGLDRAWBUFFERSARBPROC epoxy_glDrawBuffersARB;
    PFNGLDRAWBUFFERSATIPROC epoxy_glDrawBuffersATI;
    PFNGLDRAWBUFFERSEXTPROC epoxy_glDrawBuffersEXT;
    PFNGLDRAWBUFFERSINDEXEDEXTPROC epoxy_glDrawBuffersIndexedEXT;
    PFNGLDRAWBUFFERSNVPROC epoxy_glDrawBuffersNV;
    PFNGLDRAWCOMMANDSADDRESSNVPROC epoxy_glDrawCommandsAddressNV;
    PFNGLDRAWCOMMANDSNVPROC epoxy_glDrawCommandsNV;
    PFNGLDRAWCOMMANDSSTATESADDRESSNVPROC epoxy_glDrawCommandsStatesAddressNV;
    PFNGLDRAWCOMMANDSSTATESNVPROC epoxy_glDrawCommandsStatesNV;
    PFNGLDRAWELEMENTARRAYAPPLEPROC epoxy_glDrawElementArrayAPPLE;
    PFNGLDRAWELEMENTARRAYATIPROC epoxy_glDrawElementArrayATI;
    PFNGLDRAWELEMENTSPROC epoxy_glDrawElements;
    PFNGLDRAWELEMENTSBASEVERTEXPROC epoxy_glDrawElementsBaseVertex;
    PFNGLDRAWELEMENTSBASEVERTEXEXTPROC epoxy_glDrawElementsBaseVertexEXT;
    PFNGLDRAWELEMENTSBASEVERTEXOESPROC epoxy_glDrawElementsBaseVertexOES;
    PFNGLDRAWELEMENTSINDIRECTPROC epoxy_glDrawElementsIndirect;
    PFNGLDRAWELEMENTSINSTANCEDPROC epoxy_glDrawElementsInstanced;
    PFNGLDRAWELEMENTSINSTANCEDANGLEPROC epoxy_glDrawElementsInstancedANGLE;
    PFNGLDRAWELEMENTSINSTANCEDARBPROC epoxy_glDrawElementsInstancedARB;
    PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC epoxy_glDrawElementsInstancedBaseInstance;
    PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEEXTPROC epoxy_glDrawElementsInstancedBaseInstanceEXT;
    PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC epoxy_glDrawElementsInstancedBaseVertex;
    PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC epoxy_glDrawElementsInstancedBaseVertexBaseInstance;
    PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEEXTPROC epoxy_glDrawElementsInstancedBaseVertexBaseInstanceEXT;
    PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXEXTPROC epoxy_glDrawElementsInstancedBaseVertexEXT;
    PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXOESPROC epoxy_glDrawElementsInstancedBaseVertexOES;
    PFNGLDRAWELEMENTSINSTANCEDEXTPROC epoxy_glDrawElementsInstancedEXT;
    PFNGLDRAWELEMENTSINSTANCEDNVPROC epoxy_glDrawElementsInstancedNV;
    PFNGLDRAWMESHARRAYSSUNPROC epoxy_glDrawMeshArraysSUN;
    PFNGLDRAWPIXELSPROC epoxy_glDrawPixels;
    PFNGLDRAWRANGEELEMENTARRAYAPPLEPROC epoxy_glDrawRangeElementArrayAPPLE;
    PFNGLDRAWRANGEELEMENTARRAYATIPROC epoxy_glDrawRangeElementArrayATI;
    PFNGLDRAWRANGEELEMENTSPROC epoxy_glDrawRangeElements;
    PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC epoxy_glDrawRangeElementsBaseVertex;
    PFNGLDRAWRANGEELEMENTSBASEVERTEXEXTPROC epoxy_glDrawRangeElementsBaseVertexEXT;
    PFNGLDRAWRANGEELEMENTSBASEVERTEXOESPROC epoxy_glDrawRangeElementsBaseVertexOES;
    PFNGLDRAWRANGEELEMENTSEXTPROC epoxy_glDrawRangeElementsEXT;
    PFNGLDRAWTEXFOESPROC epoxy_glDrawTexfOES;
    PFNGLDRAWTEXFVOESPROC epoxy_glDrawTexfvOES;
    PFNGLDRAWTEXIOESPROC epoxy_glDrawTexiOES;
    PFNGLDRAWTEXIVOESPROC epoxy_glDrawTexivOES;
    PFNGLDRAWTEXSOESPROC epoxy_glDrawTexsOES;
    PFNGLDRAWTEXSVOESPROC epoxy_glDrawTexsvOES;
    PFNGLDRAWTEXTURENVPROC epoxy_glDrawTextureNV;
    PFNGLDRAWTEXXOESPROC epoxy_glDrawTexxOES;
    PFNGLDRAWTEXXVOESPROC epoxy_glDrawTexxvOES;
    PFNGLDRAWTRANSFORMFEEDBACKPROC epoxy_glDrawTransformFeedback;
    PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC epoxy_glDrawTransformFeedbackInstanced;
    PFNGLDRAWTRANSFORMFEEDBACKNVPROC epoxy_glDrawTransformFeedbackNV;
    PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC epoxy_glDrawTransformFeedbackStream;
    PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC epoxy_glDrawTransformFeedbackStreamInstanced;
    PFNGLEGLIMAGETARGETRENDERBUFFERSTORAGEOESPROC epoxy_glEGLImageTargetRenderbufferStorageOES;
    PFNGLEGLIMAGETARGETTEXTURE2DOESPROC epoxy_glEGLImageTargetTexture2DOES;
    PFNGLEDGEFLAGPROC epoxy_glEdgeFlag;
    PFNGLEDGEFLAGFORMATNVPROC epoxy_glEdgeFlagFormatNV;
    PFNGLEDGEFLAGPOINTERPROC epoxy_glEdgeFlagPointer;
    PFNGLEDGEFLAGPOINTEREXTPROC epoxy_glEdgeFlagPointerEXT;
    PFNGLEDGEFLAGPOINTERLISTIBMPROC epoxy_glEdgeFlagPointerListIBM;
    PFNGLEDGEFLAGVPROC epoxy_glEdgeFlagv;
    PFNGLELEMENTPOINTERAPPLEPROC epoxy_glElementPointerAPPLE;
    PFNGLELEMENTPOINTERATIPROC epoxy_glElementPointerATI;
    PFNGLENABLEPROC epoxy_glEnable;
    PFNGLENABLECLIENTSTATEPROC epoxy_glEnableClientState;
    PFNGLENABLECLIENTSTATEINDEXEDEXTPROC epoxy_glEnableClientStateIndexedEXT;
    PFNGLENABLECLIENTSTATEIEXTPROC epoxy_glEnableClientStateiEXT;
    PFNGLENABLEDRIVERCONTROLQCOMPROC epoxy_glEnableDriverControlQCOM;
    PFNGLENABLEINDEXEDEXTPROC epoxy_glEnableIndexedEXT;
    PFNGLENABLEVARIANTCLIENTSTATEEXTPROC epoxy_glEnableVariantClientStateEXT;
    PFNGLENABLEVERTEXARRAYATTRIBPROC epoxy_glEnableVertexArrayAttrib;
    PFNGLENABLEVERTEXARRAYATTRIBEXTPROC epoxy_glEnableVertexArrayAttribEXT;
    PFNGLENABLEVERTEXARRAYEXTPROC epoxy_glEnableVertexArrayEXT;
    PFNGLENABLEVERTEXATTRIBAPPLEPROC epoxy_glEnableVertexAttribAPPLE;
    PFNGLENABLEVERTEXATTRIBARRAYPROC epoxy_glEnableVertexAttribArray;
    PFNGLENABLEVERTEXATTRIBARRAYARBPROC epoxy_glEnableVertexAttribArrayARB;
    PFNGLENABLEIPROC epoxy_glEnablei;
    PFNGLENABLEIEXTPROC epoxy_glEnableiEXT;
    PFNGLENABLEINVPROC epoxy_glEnableiNV;
    PFNGLENABLEIOESPROC epoxy_glEnableiOES;
    PFNGLENDPROC epoxy_glEnd_unwrapped;
    PFNGLENDCONDITIONALRENDERPROC epoxy_glEndConditionalRender;
    PFNGLENDCONDITIONALRENDERNVPROC epoxy_glEndConditionalRenderNV;
    PFNGLENDCONDITIONALRENDERNVXPROC epoxy_glEndConditionalRenderNVX;
    PFNGLENDFRAGMENTSHADERATIPROC epoxy_glEndFragmentShaderATI;
    PFNGLENDLISTPROC epoxy_glEndList;
    PFNGLENDOCCLUSIONQUERYNVPROC epoxy_glEndOcclusionQueryNV;
    PFNGLENDPERFMONITORAMDPROC epoxy_glEndPerfMonitorAMD;
    PFNGLENDPERFQUERYINTELPROC epoxy_glEndPerfQueryINTEL;
    PFNGLENDQUERYPROC epoxy_glEndQuery;
    PFNGLENDQUERYARBPROC epoxy_glEndQueryARB;
    PFNGLENDQUERYEXTPROC epoxy_glEndQueryEXT;
    PFNGLENDQUERYINDEXEDPROC epoxy_glEndQueryIndexed;
    PFNGLENDTILINGQCOMPROC epoxy_glEndTilingQCOM;
    PFNGLENDTRANSFORMFEEDBACKPROC epoxy_glEndTransformFeedback;
    PFNGLENDTRANSFORMFEEDBACKEXTPROC epoxy_glEndTransformFeedbackEXT;
    PFNGLENDTRANSFORMFEEDBACKNVPROC epoxy_glEndTransformFeedbackNV;
    PFNGLENDVERTEXSHADEREXTPROC epoxy_glEndVertexShaderEXT;
    PFNGLENDVIDEOCAPTURENVPROC epoxy_glEndVideoCaptureNV;
    PFNGLEVALCOORD1DPROC epoxy_glEvalCoord1d;
    PFNGLEVALCOORD1DVPROC epoxy_glEvalCoord1dv;
    PFNGLEVALCOORD1FPROC epoxy_glEvalCoord1f;
    PFNGLEVALCOORD1FVPROC epoxy_glEvalCoord1fv;
    PFNGLEVALCOORD1XOESPROC epoxy_glEvalCoord1xOES;
    PFNGLEVALCOORD1XVOESPROC epoxy_glEvalCoord1xvOES;
    PFNGLEVALCOORD2DPROC epoxy_glEvalCoord2d;
    PFNGLEVALCOORD2DVPROC epoxy_glEvalCoord2dv;
    PFNGLEVALCOORD2FPROC epoxy_glEvalCoord2f;
    PFNGLEVALCOORD2FVPROC epoxy_glEvalCoord2fv;
    PFNGLEVALCOORD2XOESPROC epoxy_glEvalCoord2xOES;
    PFNGLEVALCOORD2XVOESPROC epoxy_glEvalCoord2xvOES;
    PFNGLEVALMAPSNVPROC epoxy_glEvalMapsNV;
    PFNGLEVALMESH1PROC epoxy_glEvalMesh1;
    PFNGLEVALMESH2PROC epoxy_glEvalMesh2;
    PFNGLEVALPOINT1PROC epoxy_glEvalPoint1;
    PFNGLEVALPOINT2PROC epoxy_glEvalPoint2;
    PFNGLEXECUTEPROGRAMNVPROC epoxy_glExecuteProgramNV;
    PFNGLEXTGETBUFFERPOINTERVQCOMPROC epoxy_glExtGetBufferPointervQCOM;
    PFNGLEXTGETBUFFERSQCOMPROC epoxy_glExtGetBuffersQCOM;
    PFNGLEXTGETFRAMEBUFFERSQCOMPROC epoxy_glExtGetFramebuffersQCOM;
    PFNGLEXTGETPROGRAMBINARYSOURCEQCOMPROC epoxy_glExtGetProgramBinarySourceQCOM;
    PFNGLEXTGETPROGRAMSQCOMPROC epoxy_glExtGetProgramsQCOM;
    PFNGLEXTGETRENDERBUFFERSQCOMPROC epoxy_glExtGetRenderbuffersQCOM;
    PFNGLEXTGETSHADERSQCOMPROC epoxy_glExtGetShadersQCOM;
    PFNGLEXTGETTEXLEVELPARAMETERIVQCOMPROC epoxy_glExtGetTexLevelParameterivQCOM;
    PFNGLEXTGETTEXSUBIMAGEQCOMPROC epoxy_glExtGetTexSubImageQCOM;
    PFNGLEXTGETTEXTURESQCOMPROC epoxy_glExtGetTexturesQCOM;
    PFNGLEXTISPROGRAMBINARYQCOMPROC epoxy_glExtIsProgramBinaryQCOM;
    PFNGLEXTTEXOBJECTSTATEOVERRIDEIQCOMPROC epoxy_glExtTexObjectStateOverrideiQCOM;
    PFNGLEXTRACTCOMPONENTEXTPROC epoxy_glExtractComponentEXT;
    PFNGLFEEDBACKBUFFERPROC epoxy_glFeedbackBuffer;
    PFNGLFEEDBACKBUFFERXOESPROC epoxy_glFeedbackBufferxOES;
    PFNGLFENCESYNCPROC epoxy_glFenceSync;
    PFNGLFENCESYNCAPPLEPROC epoxy_glFenceSyncAPPLE;
    PFNGLFINALCOMBINERINPUTNVPROC epoxy_glFinalCombinerInputNV;
    PFNGLFINISHPROC epoxy_glFinish;
    PFNGLFINISHASYNCSGIXPROC epoxy_glFinishAsyncSGIX;
    PFNGLFINISHFENCEAPPLEPROC epoxy_glFinishFenceAPPLE;
    PFNGLFINISHFENCENVPROC epoxy_glFinishFenceNV;
    PFNGLFINISHOBJECTAPPLEPROC epoxy_glFinishObjectAPPLE;
    PFNGLFINISHTEXTURESUNXPROC epoxy_glFinishTextureSUNX;
    PFNGLFLUSHPROC epoxy_glFlush;
    PFNGLFLUSHMAPPEDBUFFERRANGEPROC epoxy_glFlushMappedBufferRange;
    PFNGLFLUSHMAPPEDBUFFERRANGEAPPLEPROC epoxy_glFlushMappedBufferRangeAPPLE;
    PFNGLFLUSHMAPPEDBUFFERRANGEEXTPROC epoxy_glFlushMappedBufferRangeEXT;
    PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEPROC epoxy_glFlushMappedNamedBufferRange;
    PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEEXTPROC epoxy_glFlushMappedNamedBufferRangeEXT;
    PFNGLFLUSHPIXELDATARANGENVPROC epoxy_glFlushPixelDataRangeNV;
    PFNGLFLUSHRASTERSGIXPROC epoxy_glFlushRasterSGIX;
    PFNGLFLUSHSTATICDATAIBMPROC epoxy_glFlushStaticDataIBM;
    PFNGLFLUSHVERTEXARRAYRANGEAPPLEPROC epoxy_glFlushVertexArrayRangeAPPLE;
    PFNGLFLUSHVERTEXARRAYRANGENVPROC epoxy_glFlushVertexArrayRangeNV;
    PFNGLFOGCOORDFORMATNVPROC epoxy_glFogCoordFormatNV;
    PFNGLFOGCOORDPOINTERPROC epoxy_glFogCoordPointer;
    PFNGLFOGCOORDPOINTEREXTPROC epoxy_glFogCoordPointerEXT;
    PFNGLFOGCOORDPOINTERLISTIBMPROC epoxy_glFogCoordPointerListIBM;
    PFNGLFOGCOORDDPROC epoxy_glFogCoordd;
    PFNGLFOGCOORDDEXTPROC epoxy_glFogCoorddEXT;
    PFNGLFOGCOORDDVPROC epoxy_glFogCoorddv;
    PFNGLFOGCOORDDVEXTPROC epoxy_glFogCoorddvEXT;
    PFNGLFOGCOORDFPROC epoxy_glFogCoordf;
    PFNGLFOGCOORDFEXTPROC epoxy_glFogCoordfEXT;
    PFNGLFOGCOORDFVPROC epoxy_glFogCoordfv;
    PFNGLFOGCOORDFVEXTPROC epoxy_glFogCoordfvEXT;
    PFNGLFOGCOORDHNVPROC epoxy_glFogCoordhNV;
    PFNGLFOGCOORDHVNVPROC epoxy_glFogCoordhvNV;
    PFNGLFOGFUNCSGISPROC epoxy_glFogFuncSGIS;
    PFNGLFOGFPROC epoxy_glFogf;
    PFNGLFOGFVPROC epoxy_glFogfv;
    PFNGLFOGIPROC epoxy_glFogi;
    PFNGLFOGIVPROC epoxy_glFogiv;
    PFNGLFOGXPROC epoxy_glFogx;
    PFNGLFOGXOESPROC epoxy_glFogxOES;
    PFNGLFOGXVPROC epoxy_glFogxv;
    PFNGLFOGXVOESPROC epoxy_glFogxvOES;
    PFNGLFRAGMENTCOLORMATERIALSGIXPROC epoxy_glFragmentColorMaterialSGIX;
    PFNGLFRAGMENTCOVERAGECOLORNVPROC epoxy_glFragmentCoverageColorNV;
    PFNGLFRAGMENTLIGHTMODELFSGIXPROC epoxy_glFragmentLightModelfSGIX;
    PFNGLFRAGMENTLIGHTMODELFVSGIXPROC epoxy_glFragmentLightModelfvSGIX;
    PFNGLFRAGMENTLIGHTMODELISGIXPROC epoxy_glFragmentLightModeliSGIX;
    PFNGLFRAGMENTLIGHTMODELIVSGIXPROC epoxy_glFragmentLightModelivSGIX;
    PFNGLFRAGMENTLIGHTFSGIXPROC epoxy_glFragmentLightfSGIX;
    PFNGLFRAGMENTLIGHTFVSGIXPROC epoxy_glFragmentLightfvSGIX;
    PFNGLFRAGMENTLIGHTISGIXPROC epoxy_glFragmentLightiSGIX;
    PFNGLFRAGMENTLIGHTIVSGIXPROC epoxy_glFragmentLightivSGIX;
    PFNGLFRAGMENTMATERIALFSGIXPROC epoxy_glFragmentMaterialfSGIX;
    PFNGLFRAGMENTMATERIALFVSGIXPROC epoxy_glFragmentMaterialfvSGIX;
    PFNGLFRAGMENTMATERIALISGIXPROC epoxy_glFragmentMaterialiSGIX;
    PFNGLFRAGMENTMATERIALIVSGIXPROC epoxy_glFragmentMaterialivSGIX;
    PFNGLFRAMETERMINATORGREMEDYPROC epoxy_glFrameTerminatorGREMEDY;
    PFNGLFRAMEZOOMSGIXPROC epoxy_glFrameZoomSGIX;
    PFNGLFRAMEBUFFERDRAWBUFFEREXTPROC epoxy_glFramebufferDrawBufferEXT;
    PFNGLFRAMEBUFFERDRAWBUFFERSEXTPROC epoxy_glFramebufferDrawBuffersEXT;
    PFNGLFRAMEBUFFERPARAMETERIPROC epoxy_glFramebufferParameteri;
    PFNGLFRAMEBUFFERREADBUFFEREXTPROC epoxy_glFramebufferReadBufferEXT;
    PFNGLFRAMEBUFFERRENDERBUFFERPROC epoxy_glFramebufferRenderbuffer;
    PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC epoxy_glFramebufferRenderbufferEXT;
    PFNGLFRAMEBUFFERRENDERBUFFEROESPROC epoxy_glFramebufferRenderbufferOES;
    PFNGLFRAMEBUFFERSAMPLELOCATIONSFVNVPROC epoxy_glFramebufferSampleLocationsfvNV;
    PFNGLFRAMEBUFFERTEXTUREPROC epoxy_glFramebufferTexture;
    PFNGLFRAMEBUFFERTEXTURE1DPROC epoxy_glFramebufferTexture1D;
    PFNGLFRAMEBUFFERTEXTURE1DEXTPROC epoxy_glFramebufferTexture1DEXT;
    PFNGLFRAMEBUFFERTEXTURE2DPROC epoxy_glFramebufferTexture2D;
    PFNGLFRAMEBUFFERTEXTURE2DEXTPROC epoxy_glFramebufferTexture2DEXT;
    PFNGLFRAMEBUFFERTEXTURE2DMULTISAMPLEEXTPROC epoxy_glFramebufferTexture2DMultisampleEXT;
    PFNGLFRAMEBUFFERTEXTURE2DMULTISAMPLEIMGPROC epoxy_glFramebufferTexture2DMultisampleIMG;
    PFNGLFRAMEBUFFERTEXTURE2DOESPROC epoxy_glFramebufferTexture2DOES;
    PFNGLFRAMEBUFFERTEXTURE3DPROC epoxy_glFramebufferTexture3D;
    PFNGLFRAMEBUFFERTEXTURE3DEXTPROC epoxy_glFramebufferTexture3DEXT;
    PFNGLFRAMEBUFFERTEXTURE3DOESPROC epoxy_glFramebufferTexture3DOES;
    PFNGLFRAMEBUFFERTEXTUREARBPROC epoxy_glFramebufferTextureARB;
    PFNGLFRAMEBUFFERTEXTUREEXTPROC epoxy_glFramebufferTextureEXT;
    PFNGLFRAMEBUFFERTEXTUREFACEARBPROC epoxy_glFramebufferTextureFaceARB;
    PFNGLFRAMEBUFFERTEXTUREFACEEXTPROC epoxy_glFramebufferTextureFaceEXT;
    PFNGLFRAMEBUFFERTEXTURELAYERPROC epoxy_glFramebufferTextureLayer;
    PFNGLFRAMEBUFFERTEXTURELAYERARBPROC epoxy_glFramebufferTextureLayerARB;
    PFNGLFRAMEBUFFERTEXTURELAYEREXTPROC epoxy_glFramebufferTextureLayerEXT;
    PFNGLFRAMEBUFFERTEXTUREMULTIVIEWOVRPROC epoxy_glFramebufferTextureMultiviewOVR;
    PFNGLFRAMEBUFFERTEXTUREOESPROC epoxy_glFramebufferTextureOES;
    PFNGLFREEOBJECTBUFFERATIPROC epoxy_glFreeObjectBufferATI;
    PFNGLFRONTFACEPROC epoxy_glFrontFace;
    PFNGLFRUSTUMPROC epoxy_glFrustum;
    PFNGLFRUSTUMFPROC epoxy_glFrustumf;
    PFNGLFRUSTUMFOESPROC epoxy_glFrustumfOES;
    PFNGLFRUSTUMXPROC epoxy_glFrustumx;
    PFNGLFRUSTUMXOESPROC epoxy_glFrustumxOES;
    PFNGLGENASYNCMARKERSSGIXPROC epoxy_glGenAsyncMarkersSGIX;
    PFNGLGENBUFFERSPROC epoxy_glGenBuffers;
    PFNGLGENBUFFERSARBPROC epoxy_glGenBuffersARB;
    PFNGLGENFENCESAPPLEPROC epoxy_glGenFencesAPPLE;
    PFNGLGENFENCESNVPROC epoxy_glGenFencesNV;
    PFNGLGENFRAGMENTSHADERSATIPROC epoxy_glGenFragmentShadersATI;
    PFNGLGENFRAMEBUFFERSPROC epoxy_glGenFramebuffers;
    PFNGLGENFRAMEBUFFERSEXTPROC epoxy_glGenFramebuffersEXT;
    PFNGLGENFRAMEBUFFERSOESPROC epoxy_glGenFramebuffersOES;
    PFNGLGENLISTSPROC epoxy_glGenLists;
    PFNGLGENNAMESAMDPROC epoxy_glGenNamesAMD;
    PFNGLGENOCCLUSIONQUERIESNVPROC epoxy_glGenOcclusionQueriesNV;
    PFNGLGENPATHSNVPROC epoxy_glGenPathsNV;
    PFNGLGENPERFMONITORSAMDPROC epoxy_glGenPerfMonitorsAMD;
    PFNGLGENPROGRAMPIPELINESPROC epoxy_glGenProgramPipelines;
    PFNGLGENPROGRAMPIPELINESEXTPROC epoxy_glGenProgramPipelinesEXT;
    PFNGLGENPROGRAMSARBPROC epoxy_glGenProgramsARB;
    PFNGLGENPROGRAMSNVPROC epoxy_glGenProgramsNV;
    PFNGLGENQUERIESPROC epoxy_glGenQueries;
    PFNGLGENQUERIESARBPROC epoxy_glGenQueriesARB;
    PFNGLGENQUERIESEXTPROC epoxy_glGenQueriesEXT;
    PFNGLGENRENDERBUFFERSPROC epoxy_glGenRenderbuffers;
    PFNGLGENRENDERBUFFERSEXTPROC epoxy_glGenRenderbuffersEXT;
    PFNGLGENRENDERBUFFERSOESPROC epoxy_glGenRenderbuffersOES;
    PFNGLGENSAMPLERSPROC epoxy_glGenSamplers;
    PFNGLGENSYMBOLSEXTPROC epoxy_glGenSymbolsEXT;
    PFNGLGENTEXTURESPROC epoxy_glGenTextures;
    PFNGLGENTEXTURESEXTPROC epoxy_glGenTexturesEXT;
    PFNGLGENTRANSFORMFEEDBACKSPROC epoxy_glGenTransformFeedbacks;
    PFNGLGENTRANSFORMFEEDBACKSNVPROC epoxy_glGenTransformFeedbacksNV;
    PFNGLGENVERTEXARRAYSPROC epoxy_glGenVertexArrays;
    PFNGLGENVERTEXARRAYSAPPLEPROC epoxy_glGenVertexArraysAPPLE;
    PFNGLGENVERTEXARRAYSOESPROC epoxy_glGenVertexArraysOES;
    PFNGLGENVERTEXSHADERSEXTPROC epoxy_glGenVertexShadersEXT;
    PFNGLGENERATEMIPMAPPROC epoxy_glGenerateMipmap;
    PFNGLGENERATEMIPMAPEXTPROC epoxy_glGenerateMipmapEXT;
    PFNGLGENERATEMIPMAPOESPROC epoxy_glGenerateMipmapOES;
    PFNGLGENERATEMULTITEXMIPMAPEXTPROC epoxy_glGenerateMultiTexMipmapEXT;
    PFNGLGENERATETEXTUREMIPMAPPROC epoxy_glGenerateTextureMipmap;
    PFNGLGENERATETEXTUREMIPMAPEXTPROC epoxy_glGenerateTextureMipmapEXT;
    PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC epoxy_glGetActiveAtomicCounterBufferiv;
    PFNGLGETACTIVEATTRIBPROC epoxy_glGetActiveAttrib;
    PFNGLGETACTIVEATTRIBARBPROC epoxy_glGetActiveAttribARB;
    PFNGLGETACTIVESUBROUTINENAMEPROC epoxy_glGetActiveSubroutineName;
    PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC epoxy_glGetActiveSubroutineUniformName;
    PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC epoxy_glGetActiveSubroutineUniformiv;
    PFNGLGETACTIVEUNIFORMPROC epoxy_glGetActiveUniform;
    PFNGLGETACTIVEUNIFORMARBPROC epoxy_glGetActiveUniformARB;
    PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC epoxy_glGetActiveUniformBlockName;
    PFNGLGETACTIVEUNIFORMBLOCKIVPROC epoxy_glGetActiveUniformBlockiv;
    PFNGLGETACTIVEUNIFORMNAMEPROC epoxy_glGetActiveUniformName;
    PFNGLGETACTIVEUNIFORMSIVPROC epoxy_glGetActiveUniformsiv;
    PFNGLGETACTIVEVARYINGNVPROC epoxy_glGetActiveVaryingNV;
    PFNGLGETARRAYOBJECTFVATIPROC epoxy_glGetArrayObjectfvATI;
    PFNGLGETARRAYOBJECTIVATIPROC epoxy_glGetArrayObjectivATI;
    PFNGLGETATTACHEDOBJECTSARBPROC epoxy_glGetAttachedObjectsARB;
    PFNGLGETATTACHEDSHADERSPROC epoxy_glGetAttachedShaders;
    PFNGLGETATTRIBLOCATIONPROC epoxy_glGetAttribLocation;
    PFNGLGETATTRIBLOCATIONARBPROC epoxy_glGetAttribLocationARB;
    PFNGLGETBOOLEANINDEXEDVEXTPROC epoxy_glGetBooleanIndexedvEXT;
    PFNGLGETBOOLEANI_VPROC epoxy_glGetBooleani_v;
    PFNGLGETBOOLEANVPROC epoxy_glGetBooleanv;
    PFNGLGETBUFFERPARAMETERI64VPROC epoxy_glGetBufferParameteri64v;
    PFNGLGETBUFFERPARAMETERIVPROC epoxy_glGetBufferParameteriv;
    PFNGLGETBUFFERPARAMETERIVARBPROC epoxy_glGetBufferParameterivARB;
    PFNGLGETBUFFERPARAMETERUI64VNVPROC epoxy_glGetBufferParameterui64vNV;
    PFNGLGETBUFFERPOINTERVPROC epoxy_glGetBufferPointerv;
    PFNGLGETBUFFERPOINTERVARBPROC epoxy_glGetBufferPointervARB;
    PFNGLGETBUFFERPOINTERVOESPROC epoxy_glGetBufferPointervOES;
    PFNGLGETBUFFERSUBDATAPROC epoxy_glGetBufferSubData;
    PFNGLGETBUFFERSUBDATAARBPROC epoxy_glGetBufferSubDataARB;
    PFNGLGETCLIPPLANEPROC epoxy_glGetClipPlane;
    PFNGLGETCLIPPLANEFPROC epoxy_glGetClipPlanef;
    PFNGLGETCLIPPLANEFOESPROC epoxy_glGetClipPlanefOES;
    PFNGLGETCLIPPLANEXPROC epoxy_glGetClipPlanex;
    PFNGLGETCLIPPLANEXOESPROC epoxy_glGetClipPlanexOES;
    PFNGLGETCOLORTABLEPROC epoxy_glGetColorTable;
    PFNGLGETCOLORTABLEEXTPROC epoxy_glGetColorTableEXT;
    PFNGLGETCOLORTABLEPARAMETERFVPROC epoxy_glGetColorTableParameterfv;
    PFNGLGETCOLORTABLEPARAMETERFVEXTPROC epoxy_glGetColorTableParameterfvEXT;
    PFNGLGETCOLORTABLEPARAMETERFVSGIPROC epoxy_glGetColorTableParameterfvSGI;
    PFNGLGETCOLORTABLEPARAMETERIVPROC epoxy_glGetColorTableParameteriv;
    PFNGLGETCOLORTABLEPARAMETERIVEXTPROC epoxy_glGetColorTableParameterivEXT;
    PFNGLGETCOLORTABLEPARAMETERIVSGIPROC epoxy_glGetColorTableParameterivSGI;
    PFNGLGETCOLORTABLESGIPROC epoxy_glGetColorTableSGI;
    PFNGLGETCOMBINERINPUTPARAMETERFVNVPROC epoxy_glGetCombinerInputParameterfvNV;
    PFNGLGETCOMBINERINPUTPARAMETERIVNVPROC epoxy_glGetCombinerInputParameterivNV;
    PFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC epoxy_glGetCombinerOutputParameterfvNV;
    PFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC epoxy_glGetCombinerOutputParameterivNV;
    PFNGLGETCOMBINERSTAGEPARAMETERFVNVPROC epoxy_glGetCombinerStageParameterfvNV;
    PFNGLGETCOMMANDHEADERNVPROC epoxy_glGetCommandHeaderNV;
    PFNGLGETCOMPRESSEDMULTITEXIMAGEEXTPROC epoxy_glGetCompressedMultiTexImageEXT;
    PFNGLGETCOMPRESSEDTEXIMAGEPROC epoxy_glGetCompressedTexImage;
    PFNGLGETCOMPRESSEDTEXIMAGEARBPROC epoxy_glGetCompressedTexImageARB;
    PFNGLGETCOMPRESSEDTEXTUREIMAGEPROC epoxy_glGetCompressedTextureImage;
    PFNGLGETCOMPRESSEDTEXTUREIMAGEEXTPROC epoxy_glGetCompressedTextureImageEXT;
    PFNGLGETCOMPRESSEDTEXTURESUBIMAGEPROC epoxy_glGetCompressedTextureSubImage;
    PFNGLGETCONVOLUTIONFILTERPROC epoxy_glGetConvolutionFilter;
    PFNGLGETCONVOLUTIONFILTEREXTPROC epoxy_glGetConvolutionFilterEXT;
    PFNGLGETCONVOLUTIONPARAMETERFVPROC epoxy_glGetConvolutionParameterfv;
    PFNGLGETCONVOLUTIONPARAMETERFVEXTPROC epoxy_glGetConvolutionParameterfvEXT;
    PFNGLGETCONVOLUTIONPARAMETERIVPROC epoxy_glGetConvolutionParameteriv;
    PFNGLGETCONVOLUTIONPARAMETERIVEXTPROC epoxy_glGetConvolutionParameterivEXT;
    PFNGLGETCONVOLUTIONPARAMETERXVOESPROC epoxy_glGetConvolutionParameterxvOES;
    PFNGLGETCOVERAGEMODULATIONTABLENVPROC epoxy_glGetCoverageModulationTableNV;
    PFNGLGETDEBUGMESSAGELOGPROC epoxy_glGetDebugMessageLog;
    PFNGLGETDEBUGMESSAGELOGAMDPROC epoxy_glGetDebugMessageLogAMD;
    PFNGLGETDEBUGMESSAGELOGARBPROC epoxy_glGetDebugMessageLogARB;
    PFNGLGETDEBUGMESSAGELOGKHRPROC epoxy_glGetDebugMessageLogKHR;
    PFNGLGETDETAILTEXFUNCSGISPROC epoxy_glGetDetailTexFuncSGIS;
    PFNGLGETDOUBLEINDEXEDVEXTPROC epoxy_glGetDoubleIndexedvEXT;
    PFNGLGETDOUBLEI_VPROC epoxy_glGetDoublei_v;
    PFNGLGETDOUBLEI_VEXTPROC epoxy_glGetDoublei_vEXT;
    PFNGLGETDOUBLEVPROC epoxy_glGetDoublev;
    PFNGLGETDRIVERCONTROLSTRINGQCOMPROC epoxy_glGetDriverControlStringQCOM;
    PFNGLGETDRIVERCONTROLSQCOMPROC epoxy_glGetDriverControlsQCOM;
    PFNGLGETERRORPROC epoxy_glGetError;
    PFNGLGETFENCEIVNVPROC epoxy_glGetFenceivNV;
    PFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC epoxy_glGetFinalCombinerInputParameterfvNV;
    PFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC epoxy_glGetFinalCombinerInputParameterivNV;
    PFNGLGETFIRSTPERFQUERYIDINTELPROC epoxy_glGetFirstPerfQueryIdINTEL;
    PFNGLGETFIXEDVPROC epoxy_glGetFixedv;
    PFNGLGETFIXEDVOESPROC epoxy_glGetFixedvOES;
    PFNGLGETFLOATINDEXEDVEXTPROC epoxy_glGetFloatIndexedvEXT;
    PFNGLGETFLOATI_VPROC epoxy_glGetFloati_v;
    PFNGLGETFLOATI_VEXTPROC epoxy_glGetFloati_vEXT;
    PFNGLGETFLOATI_VNVPROC epoxy_glGetFloati_vNV;
    PFNGLGETFLOATVPROC epoxy_glGetFloatv;
    PFNGLGETFOGFUNCSGISPROC epoxy_glGetFogFuncSGIS;
    PFNGLGETFRAGDATAINDEXPROC epoxy_glGetFragDataIndex;
    PFNGLGETFRAGDATALOCATIONPROC epoxy_glGetFragDataLocation;
    PFNGLGETFRAGDATALOCATIONEXTPROC epoxy_glGetFragDataLocationEXT;
    PFNGLGETFRAGMENTLIGHTFVSGIXPROC epoxy_glGetFragmentLightfvSGIX;
    PFNGLGETFRAGMENTLIGHTIVSGIXPROC epoxy_glGetFragmentLightivSGIX;
    PFNGLGETFRAGMENTMATERIALFVSGIXPROC epoxy_glGetFragmentMaterialfvSGIX;
    PFNGLGETFRAGMENTMATERIALIVSGIXPROC epoxy_glGetFragmentMaterialivSGIX;
    PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC epoxy_glGetFramebufferAttachmentParameteriv;
    PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC epoxy_glGetFramebufferAttachmentParameterivEXT;
    PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVOESPROC epoxy_glGetFramebufferAttachmentParameterivOES;
    PFNGLGETFRAMEBUFFERPARAMETERIVPROC epoxy_glGetFramebufferParameteriv;
    PFNGLGETFRAMEBUFFERPARAMETERIVEXTPROC epoxy_glGetFramebufferParameterivEXT;
    PFNGLGETGRAPHICSRESETSTATUSPROC epoxy_glGetGraphicsResetStatus;
    PFNGLGETGRAPHICSRESETSTATUSARBPROC epoxy_glGetGraphicsResetStatusARB;
    PFNGLGETGRAPHICSRESETSTATUSEXTPROC epoxy_glGetGraphicsResetStatusEXT;
    PFNGLGETGRAPHICSRESETSTATUSKHRPROC epoxy_glGetGraphicsResetStatusKHR;
    PFNGLGETHANDLEARBPROC epoxy_glGetHandleARB;
    PFNGLGETHISTOGRAMPROC epoxy_glGetHistogram;
    PFNGLGETHISTOGRAMEXTPROC epoxy_glGetHistogramEXT;
    PFNGLGETHISTOGRAMPARAMETERFVPROC epoxy_glGetHistogramParameterfv;
    PFNGLGETHISTOGRAMPARAMETERFVEXTPROC epoxy_glGetHistogramParameterfvEXT;
    PFNGLGETHISTOGRAMPARAMETERIVPROC epoxy_glGetHistogramParameteriv;
    PFNGLGETHISTOGRAMPARAMETERIVEXTPROC epoxy_glGetHistogramParameterivEXT;
    PFNGLGETHISTOGRAMPARAMETERXVOESPROC epoxy_glGetHistogramParameterxvOES;
    PFNGLGETIMAGEHANDLEARBPROC epoxy_glGetImageHandleARB;
    PFNGLGETIMAGEHANDLENVPROC epoxy_glGetImageHandleNV;
    PFNGLGETIMAGETRANSFORMPARAMETERFVHPPROC epoxy_glGetImageTransformParameterfvHP;
    PFNGLGETIMAGETRANSFORMPARAMETERIVHPPROC epoxy_glGetImageTransformParameterivHP;
    PFNGLGETINFOLOGARBPROC epoxy_glGetInfoLogARB;
    PFNGLGETINSTRUMENTSSGIXPROC epoxy_glGetInstrumentsSGIX;
    PFNGLGETINTEGER64I_VPROC epoxy_glGetInteger64i_v;
    PFNGLGETINTEGER64VPROC epoxy_glGetInteger64v;
    PFNGLGETINTEGER64VAPPLEPROC epoxy_glGetInteger64vAPPLE;
    PFNGLGETINTEGERINDEXEDVEXTPROC epoxy_glGetIntegerIndexedvEXT;
    PFNGLGETINTEGERI_VPROC epoxy_glGetIntegeri_v;
    PFNGLGETINTEGERI_VEXTPROC epoxy_glGetIntegeri_vEXT;
    PFNGLGETINTEGERUI64I_VNVPROC epoxy_glGetIntegerui64i_vNV;
    PFNGLGETINTEGERUI64VNVPROC epoxy_glGetIntegerui64vNV;
    PFNGLGETINTEGERVPROC epoxy_glGetIntegerv;
    PFNGLGETINTERNALFORMATSAMPLEIVNVPROC epoxy_glGetInternalformatSampleivNV;
    PFNGLGETINTERNALFORMATI64VPROC epoxy_glGetInternalformati64v;
    PFNGLGETINTERNALFORMATIVPROC epoxy_glGetInternalformativ;
    PFNGLGETINVARIANTBOOLEANVEXTPROC epoxy_glGetInvariantBooleanvEXT;
    PFNGLGETINVARIANTFLOATVEXTPROC epoxy_glGetInvariantFloatvEXT;
    PFNGLGETINVARIANTINTEGERVEXTPROC epoxy_glGetInvariantIntegervEXT;
    PFNGLGETLIGHTFVPROC epoxy_glGetLightfv;
    PFNGLGETLIGHTIVPROC epoxy_glGetLightiv;
    PFNGLGETLIGHTXOESPROC epoxy_glGetLightxOES;
    PFNGLGETLIGHTXVPROC epoxy_glGetLightxv;
    PFNGLGETLIGHTXVOESPROC epoxy_glGetLightxvOES;
    PFNGLGETLISTPARAMETERFVSGIXPROC epoxy_glGetListParameterfvSGIX;
    PFNGLGETLISTPARAMETERIVSGIXPROC epoxy_glGetListParameterivSGIX;
    PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC epoxy_glGetLocalConstantBooleanvEXT;
    PFNGLGETLOCALCONSTANTFLOATVEXTPROC epoxy_glGetLocalConstantFloatvEXT;
    PFNGLGETLOCALCONSTANTINTEGERVEXTPROC epoxy_glGetLocalConstantIntegervEXT;
    PFNGLGETMAPATTRIBPARAMETERFVNVPROC epoxy_glGetMapAttribParameterfvNV;
    PFNGLGETMAPATTRIBPARAMETERIVNVPROC epoxy_glGetMapAttribParameterivNV;
    PFNGLGETMAPCONTROLPOINTSNVPROC epoxy_glGetMapControlPointsNV;
    PFNGLGETMAPPARAMETERFVNVPROC epoxy_glGetMapParameterfvNV;
    PFNGLGETMAPPARAMETERIVNVPROC epoxy_glGetMapParameterivNV;
    PFNGLGETMAPDVPROC epoxy_glGetMapdv;
    PFNGLGETMAPFVPROC epoxy_glGetMapfv;
    PFNGLGETMAPIVPROC epoxy_glGetMapiv;
    PFNGLGETMAPXVOESPROC epoxy_glGetMapxvOES;
    PFNGLGETMATERIALFVPROC epoxy_glGetMaterialfv;
    PFNGLGETMATERIALIVPROC epoxy_glGetMaterialiv;
    PFNGLGETMATERIALXOESPROC epoxy_glGetMaterialxOES;
    PFNGLGETMATERIALXVPROC epoxy_glGetMaterialxv;
    PFNGLGETMATERIALXVOESPROC epoxy_glGetMaterialxvOES;
    PFNGLGETMINMAXPROC epoxy_glGetMinmax;
    PFNGLGETMINMAXEXTPROC epoxy_glGetMinmaxEXT;
    PFNGLGETMINMAXPARAMETERFVPROC epoxy_glGetMinmaxParameterfv;
    PFNGLGETMINMAXPARAMETERFVEXTPROC epoxy_glGetMinmaxParameterfvEXT;
    PFNGLGETMINMAXPARAMETERIVPROC epoxy_glGetMinmaxParameteriv;
    PFNGLGETMINMAXPARAMETERIVEXTPROC epoxy_glGetMinmaxParameterivEXT;
    PFNGLGETMULTITEXENVFVEXTPROC epoxy_glGetMultiTexEnvfvEXT;
    PFNGLGETMULTITEXENVIVEXTPROC epoxy_glGetMultiTexEnvivEXT;
    PFNGLGETMULTITEXGENDVEXTPROC epoxy_glGetMultiTexGendvEXT;
    PFNGLGETMULTITEXGENFVEXTPROC epoxy_glGetMultiTexGenfvEXT;
    PFNGLGETMULTITEXGENIVEXTPROC epoxy_glGetMultiTexGenivEXT;
    PFNGLGETMULTITEXIMAGEEXTPROC epoxy_glGetMultiTexImageEXT;
    PFNGLGETMULTITEXLEVELPARAMETERFVEXTPROC epoxy_glGetMultiTexLevelParameterfvEXT;
    PFNGLGETMULTITEXLEVELPARAMETERIVEXTPROC epoxy_glGetMultiTexLevelParameterivEXT;
    PFNGLGETMULTITEXPARAMETERIIVEXTPROC epoxy_glGetMultiTexParameterIivEXT;
    PFNGLGETMULTITEXPARAMETERIUIVEXTPROC epoxy_glGetMultiTexParameterIuivEXT;
    PFNGLGETMULTITEXPARAMETERFVEXTPROC epoxy_glGetMultiTexParameterfvEXT;
    PFNGLGETMULTITEXPARAMETERIVEXTPROC epoxy_glGetMultiTexParameterivEXT;
    PFNGLGETMULTISAMPLEFVPROC epoxy_glGetMultisamplefv;
    PFNGLGETMULTISAMPLEFVNVPROC epoxy_glGetMultisamplefvNV;
    PFNGLGETNAMEDBUFFERPARAMETERI64VPROC epoxy_glGetNamedBufferParameteri64v;
    PFNGLGETNAMEDBUFFERPARAMETERIVPROC epoxy_glGetNamedBufferParameteriv;
    PFNGLGETNAMEDBUFFERPARAMETERIVEXTPROC epoxy_glGetNamedBufferParameterivEXT;
    PFNGLGETNAMEDBUFFERPARAMETERUI64VNVPROC epoxy_glGetNamedBufferParameterui64vNV;
    PFNGLGETNAMEDBUFFERPOINTERVPROC epoxy_glGetNamedBufferPointerv;
    PFNGLGETNAMEDBUFFERPOINTERVEXTPROC epoxy_glGetNamedBufferPointervEXT;
    PFNGLGETNAMEDBUFFERSUBDATAPROC epoxy_glGetNamedBufferSubData;
    PFNGLGETNAMEDBUFFERSUBDATAEXTPROC epoxy_glGetNamedBufferSubDataEXT;
    PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVPROC epoxy_glGetNamedFramebufferAttachmentParameteriv;
    PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC epoxy_glGetNamedFramebufferAttachmentParameterivEXT;
    PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVPROC epoxy_glGetNamedFramebufferParameteriv;
    PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVEXTPROC epoxy_glGetNamedFramebufferParameterivEXT;
    PFNGLGETNAMEDPROGRAMLOCALPARAMETERIIVEXTPROC epoxy_glGetNamedProgramLocalParameterIivEXT;
    PFNGLGETNAMEDPROGRAMLOCALPARAMETERIUIVEXTPROC epoxy_glGetNamedProgramLocalParameterIuivEXT;
    PFNGLGETNAMEDPROGRAMLOCALPARAMETERDVEXTPROC epoxy_glGetNamedProgramLocalParameterdvEXT;
    PFNGLGETNAMEDPROGRAMLOCALPARAMETERFVEXTPROC epoxy_glGetNamedProgramLocalParameterfvEXT;
    PFNGLGETNAMEDPROGRAMSTRINGEXTPROC epoxy_glGetNamedProgramStringEXT;
    PFNGLGETNAMEDPROGRAMIVEXTPROC epoxy_glGetNamedProgramivEXT;
    PFNGLGETNAMEDRENDERBUFFERPARAMETERIVPROC epoxy_glGetNamedRenderbufferParameteriv;
    PFNGLGETNAMEDRENDERBUFFERPARAMETERIVEXTPROC epoxy_glGetNamedRenderbufferParameterivEXT;
    PFNGLGETNAMEDSTRINGARBPROC epoxy_glGetNamedStringARB;
    PFNGLGETNAMEDSTRINGIVARBPROC epoxy_glGetNamedStringivARB;
    PFNGLGETNEXTPERFQUERYIDINTELPROC epoxy_glGetNextPerfQueryIdINTEL;
    PFNGLGETOBJECTBUFFERFVATIPROC epoxy_glGetObjectBufferfvATI;
    PFNGLGETOBJECTBUFFERIVATIPROC epoxy_glGetObjectBufferivATI;
    PFNGLGETOBJECTLABELPROC epoxy_glGetObjectLabel;
    PFNGLGETOBJECTLABELEXTPROC epoxy_glGetObjectLabelEXT;
    PFNGLGETOBJECTLABELKHRPROC epoxy_glGetObjectLabelKHR;
    PFNGLGETOBJECTPARAMETERFVARBPROC epoxy_glGetObjectParameterfvARB;
    PFNGLGETOBJECTPARAMETERIVAPPLEPROC epoxy_glGetObjectParameterivAPPLE;
    PFNGLGETOBJECTPARAMETERIVARBPROC epoxy_glGetObjectParameterivARB;
    PFNGLGETOBJECTPTRLABELPROC epoxy_glGetObjectPtrLabel;
    PFNGLGETOBJECTPTRLABELKHRPROC epoxy_glGetObjectPtrLabelKHR;
    PFNGLGETOCCLUSIONQUERYIVNVPROC epoxy_glGetOcclusionQueryivNV;
    PFNGLGETOCCLUSIONQUERYUIVNVPROC epoxy_glGetOcclusionQueryuivNV;
    PFNGLGETPATHCOLORGENFVNVPROC epoxy_glGetPathColorGenfvNV;
    PFNGLGETPATHCOLORGENIVNVPROC epoxy_glGetPathColorGenivNV;
    PFNGLGETPATHCOMMANDSNVPROC epoxy_glGetPathCommandsNV;
    PFNGLGETPATHCOORDSNVPROC epoxy_glGetPathCoordsNV;
    PFNGLGETPATHDASHARRAYNVPROC epoxy_glGetPathDashArrayNV;
    PFNGLGETPATHLENGTHNVPROC epoxy_glGetPathLengthNV;
    PFNGLGETPATHMETRICRANGENVPROC epoxy_glGetPathMetricRangeNV;
    PFNGLGETPATHMETRICSNVPROC epoxy_glGetPathMetricsNV;
    PFNGLGETPATHPARAMETERFVNVPROC epoxy_glGetPathParameterfvNV;
    PFNGLGETPATHPARAMETERIVNVPROC epoxy_glGetPathParameterivNV;
    PFNGLGETPATHSPACINGNVPROC epoxy_glGetPathSpacingNV;
    PFNGLGETPATHTEXGENFVNVPROC epoxy_glGetPathTexGenfvNV;
    PFNGLGETPATHTEXGENIVNVPROC epoxy_glGetPathTexGenivNV;
    PFNGLGETPERFCOUNTERINFOINTELPROC epoxy_glGetPerfCounterInfoINTEL;
    PFNGLGETPERFMONITORCOUNTERDATAAMDPROC epoxy_glGetPerfMonitorCounterDataAMD;
    PFNGLGETPERFMONITORCOUNTERINFOAMDPROC epoxy_glGetPerfMonitorCounterInfoAMD;
    PFNGLGETPERFMONITORCOUNTERSTRINGAMDPROC epoxy_glGetPerfMonitorCounterStringAMD;
    PFNGLGETPERFMONITORCOUNTERSAMDPROC epoxy_glGetPerfMonitorCountersAMD;
    PFNGLGETPERFMONITORGROUPSTRINGAMDPROC epoxy_glGetPerfMonitorGroupStringAMD;
    PFNGLGETPERFMONITORGROUPSAMDPROC epoxy_glGetPerfMonitorGroupsAMD;
    PFNGLGETPERFQUERYDATAINTELPROC epoxy_glGetPerfQueryDataINTEL;
    PFNGLGETPERFQUERYIDBYNAMEINTELPROC epoxy_glGetPerfQueryIdByNameINTEL;
    PFNGLGETPERFQUERYINFOINTELPROC epoxy_glGetPerfQueryInfoINTEL;
    PFNGLGETPIXELMAPFVPROC epoxy_glGetPixelMapfv;
    PFNGLGETPIXELMAPUIVPROC epoxy_glGetPixelMapuiv;
    PFNGLGETPIXELMAPUSVPROC epoxy_glGetPixelMapusv;
    PFNGLGETPIXELMAPXVPROC epoxy_glGetPixelMapxv;
    PFNGLGETPIXELTEXGENPARAMETERFVSGISPROC epoxy_glGetPixelTexGenParameterfvSGIS;
    PFNGLGETPIXELTEXGENPARAMETERIVSGISPROC epoxy_glGetPixelTexGenParameterivSGIS;
    PFNGLGETPIXELTRANSFORMPARAMETERFVEXTPROC epoxy_glGetPixelTransformParameterfvEXT;
    PFNGLGETPIXELTRANSFORMPARAMETERIVEXTPROC epoxy_glGetPixelTransformParameterivEXT;
    PFNGLGETPOINTERINDEXEDVEXTPROC epoxy_glGetPointerIndexedvEXT;
    PFNGLGETPOINTERI_VEXTPROC epoxy_glGetPointeri_vEXT;
    PFNGLGETPOINTERVPROC epoxy_glGetPointerv;
    PFNGLGETPOINTERVEXTPROC epoxy_glGetPointervEXT;
    PFNGLGETPOINTERVKHRPROC epoxy_glGetPointervKHR;
    PFNGLGETPOLYGONSTIPPLEPROC epoxy_glGetPolygonStipple;
    PFNGLGETPROGRAMBINARYPROC epoxy_glGetProgramBinary;
    PFNGLGETPROGRAMBINARYOESPROC epoxy_glGetProgramBinaryOES;
    PFNGLGETPROGRAMENVPARAMETERIIVNVPROC epoxy_glGetProgramEnvParameterIivNV;
    PFNGLGETPROGRAMENVPARAMETERIUIVNVPROC epoxy_glGetProgramEnvParameterIuivNV;
    PFNGLGETPROGRAMENVPARAMETERDVARBPROC epoxy_glGetProgramEnvParameterdvARB;
    PFNGLGETPROGRAMENVPARAMETERFVARBPROC epoxy_glGetProgramEnvParameterfvARB;
    PFNGLGETPROGRAMINFOLOGPROC epoxy_glGetProgramInfoLog;
    PFNGLGETPROGRAMINTERFACEIVPROC epoxy_glGetProgramInterfaceiv;
    PFNGLGETPROGRAMLOCALPARAMETERIIVNVPROC epoxy_glGetProgramLocalParameterIivNV;
    PFNGLGETPROGRAMLOCALPARAMETERIUIVNVPROC epoxy_glGetProgramLocalParameterIuivNV;
    PFNGLGETPROGRAMLOCALPARAMETERDVARBPROC epoxy_glGetProgramLocalParameterdvARB;
    PFNGLGETPROGRAMLOCALPARAMETERFVARBPROC epoxy_glGetProgramLocalParameterfvARB;
    PFNGLGETPROGRAMNAMEDPARAMETERDVNVPROC epoxy_glGetProgramNamedParameterdvNV;
    PFNGLGETPROGRAMNAMEDPARAMETERFVNVPROC epoxy_glGetProgramNamedParameterfvNV;
    PFNGLGETPROGRAMPARAMETERDVNVPROC epoxy_glGetProgramParameterdvNV;
    PFNGLGETPROGRAMPARAMETERFVNVPROC epoxy_glGetProgramParameterfvNV;
    PFNGLGETPROGRAMPIPELINEINFOLOGPROC epoxy_glGetProgramPipelineInfoLog;
    PFNGLGETPROGRAMPIPELINEINFOLOGEXTPROC epoxy_glGetProgramPipelineInfoLogEXT;
    PFNGLGETPROGRAMPIPELINEIVPROC epoxy_glGetProgramPipelineiv;
    PFNGLGETPROGRAMPIPELINEIVEXTPROC epoxy_glGetProgramPipelineivEXT;
    PFNGLGETPROGRAMRESOURCEINDEXPROC epoxy_glGetProgramResourceIndex;
    PFNGLGETPROGRAMRESOURCELOCATIONPROC epoxy_glGetProgramResourceLocation;
    PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC epoxy_glGetProgramResourceLocationIndex;
    PFNGLGETPROGRAMRESOURCENAMEPROC epoxy_glGetProgramResourceName;
    PFNGLGETPROGRAMRESOURCEFVNVPROC epoxy_glGetProgramResourcefvNV;
    PFNGLGETPROGRAMRESOURCEIVPROC epoxy_glGetProgramResourceiv;
    PFNGLGETPROGRAMSTAGEIVPROC epoxy_glGetProgramStageiv;
    PFNGLGETPROGRAMSTRINGARBPROC epoxy_glGetProgramStringARB;
    PFNGLGETPROGRAMSTRINGNVPROC epoxy_glGetProgramStringNV;
    PFNGLGETPROGRAMSUBROUTINEPARAMETERUIVNVPROC epoxy_glGetProgramSubroutineParameteruivNV;
    PFNGLGETPROGRAMIVPROC epoxy_glGetProgramiv;
    PFNGLGETPROGRAMIVARBPROC epoxy_glGetProgramivARB;
    PFNGLGETPROGRAMIVNVPROC epoxy_glGetProgramivNV;
    PFNGLGETQUERYBUFFEROBJECTI64VPROC epoxy_glGetQueryBufferObjecti64v;
    PFNGLGETQUERYBUFFEROBJECTIVPROC epoxy_glGetQueryBufferObjectiv;
    PFNGLGETQUERYBUFFEROBJECTUI64VPROC epoxy_glGetQueryBufferObjectui64v;
    PFNGLGETQUERYBUFFEROBJECTUIVPROC epoxy_glGetQueryBufferObjectuiv;
    PFNGLGETQUERYINDEXEDIVPROC epoxy_glGetQueryIndexediv;
    PFNGLGETQUERYOBJECTI64VPROC epoxy_glGetQueryObjecti64v;
    PFNGLGETQUERYOBJECTI64VEXTPROC epoxy_glGetQueryObjecti64vEXT;
    PFNGLGETQUERYOBJECTIVPROC epoxy_glGetQueryObjectiv;
    PFNGLGETQUERYOBJECTIVARBPROC epoxy_glGetQueryObjectivARB;
    PFNGLGETQUERYOBJECTIVEXTPROC epoxy_glGetQueryObjectivEXT;
    PFNGLGETQUERYOBJECTUI64VPROC epoxy_glGetQueryObjectui64v;
    PFNGLGETQUERYOBJECTUI64VEXTPROC epoxy_glGetQueryObjectui64vEXT;
    PFNGLGETQUERYOBJECTUIVPROC epoxy_glGetQueryObjectuiv;
    PFNGLGETQUERYOBJECTUIVARBPROC epoxy_glGetQueryObjectuivARB;
    PFNGLGETQUERYOBJECTUIVEXTPROC epoxy_glGetQueryObjectuivEXT;
    PFNGLGETQUERYIVPROC epoxy_glGetQueryiv;
    PFNGLGETQUERYIVARBPROC epoxy_glGetQueryivARB;
    PFNGLGETQUERYIVEXTPROC epoxy_glGetQueryivEXT;
    PFNGLGETRENDERBUFFERPARAMETERIVPROC epoxy_glGetRenderbufferParameteriv;
    PFNGLGETRENDERBUFFERPARAMETERIVEXTPROC epoxy_glGetRenderbufferParameterivEXT;
    PFNGLGETRENDERBUFFERPARAMETERIVOESPROC epoxy_glGetRenderbufferParameterivOES;
    PFNGLGETSAMPLERPARAMETERIIVPROC epoxy_glGetSamplerParameterIiv;
    PFNGLGETSAMPLERPARAMETERIIVEXTPROC epoxy_glGetSamplerParameterIivEXT;
    PFNGLGETSAMPLERPARAMETERIIVOESPROC epoxy_glGetSamplerParameterIivOES;
    PFNGLGETSAMPLERPARAMETERIUIVPROC epoxy_glGetSamplerParameterIuiv;
    PFNGLGETSAMPLERPARAMETERIUIVEXTPROC epoxy_glGetSamplerParameterIuivEXT;
    PFNGLGETSAMPLERPARAMETERIUIVOESPROC epoxy_glGetSamplerParameterIuivOES;
    PFNGLGETSAMPLERPARAMETERFVPROC epoxy_glGetSamplerParameterfv;
    PFNGLGETSAMPLERPARAMETERIVPROC epoxy_glGetSamplerParameteriv;
    PFNGLGETSEPARABLEFILTERPROC epoxy_glGetSeparableFilter;
    PFNGLGETSEPARABLEFILTEREXTPROC epoxy_glGetSeparableFilterEXT;
    PFNGLGETSHADERINFOLOGPROC epoxy_glGetShaderInfoLog;
    PFNGLGETSHADERPRECISIONFORMATPROC epoxy_glGetShaderPrecisionFormat;
    PFNGLGETSHADERSOURCEPROC epoxy_glGetShaderSource;
    PFNGLGETSHADERSOURCEARBPROC epoxy_glGetShaderSourceARB;
    PFNGLGETSHADERIVPROC epoxy_glGetShaderiv;
    PFNGLGETSHARPENTEXFUNCSGISPROC epoxy_glGetSharpenTexFuncSGIS;
    PFNGLGETSTAGEINDEXNVPROC epoxy_glGetStageIndexNV;
    PFNGLGETSTRINGPROC epoxy_glGetString;
    PFNGLGETSTRINGIPROC epoxy_glGetStringi;
    PFNGLGETSUBROUTINEINDEXPROC epoxy_glGetSubroutineIndex;
    PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC epoxy_glGetSubroutineUniformLocation;
    PFNGLGETSYNCIVPROC epoxy_glGetSynciv;
    PFNGLGETSYNCIVAPPLEPROC epoxy_glGetSyncivAPPLE;
    PFNGLGETTEXBUMPPARAMETERFVATIPROC epoxy_glGetTexBumpParameterfvATI;
    PFNGLGETTEXBUMPPARAMETERIVATIPROC epoxy_glGetTexBumpParameterivATI;
    PFNGLGETTEXENVFVPROC epoxy_glGetTexEnvfv;
    PFNGLGETTEXENVIVPROC epoxy_glGetTexEnviv;
    PFNGLGETTEXENVXVPROC epoxy_glGetTexEnvxv;
    PFNGLGETTEXENVXVOESPROC epoxy_glGetTexEnvxvOES;
    PFNGLGETTEXFILTERFUNCSGISPROC epoxy_glGetTexFilterFuncSGIS;
    PFNGLGETTEXGENDVPROC epoxy_glGetTexGendv;
    PFNGLGETTEXGENFVPROC epoxy_glGetTexGenfv;
    PFNGLGETTEXGENFVOESPROC epoxy_glGetTexGenfvOES;
    PFNGLGETTEXGENIVPROC epoxy_glGetTexGeniv;
    PFNGLGETTEXGENIVOESPROC epoxy_glGetTexGenivOES;
    PFNGLGETTEXGENXVOESPROC epoxy_glGetTexGenxvOES;
    PFNGLGETTEXIMAGEPROC epoxy_glGetTexImage;
    PFNGLGETTEXLEVELPARAMETERFVPROC epoxy_glGetTexLevelParameterfv;
    PFNGLGETTEXLEVELPARAMETERIVPROC epoxy_glGetTexLevelParameteriv;
    PFNGLGETTEXLEVELPARAMETERXVOESPROC epoxy_glGetTexLevelParameterxvOES;
    PFNGLGETTEXPARAMETERIIVPROC epoxy_glGetTexParameterIiv;
    PFNGLGETTEXPARAMETERIIVEXTPROC epoxy_glGetTexParameterIivEXT;
    PFNGLGETTEXPARAMETERIIVOESPROC epoxy_glGetTexParameterIivOES;
    PFNGLGETTEXPARAMETERIUIVPROC epoxy_glGetTexParameterIuiv;
    PFNGLGETTEXPARAMETERIUIVEXTPROC epoxy_glGetTexParameterIuivEXT;
    PFNGLGETTEXPARAMETERIUIVOESPROC epoxy_glGetTexParameterIuivOES;
    PFNGLGETTEXPARAMETERPOINTERVAPPLEPROC epoxy_glGetTexParameterPointervAPPLE;
    PFNGLGETTEXPARAMETERFVPROC epoxy_glGetTexParameterfv;
    PFNGLGETTEXPARAMETERIVPROC epoxy_glGetTexParameteriv;
    PFNGLGETTEXPARAMETERXVPROC epoxy_glGetTexParameterxv;
    PFNGLGETTEXPARAMETERXVOESPROC epoxy_glGetTexParameterxvOES;
    PFNGLGETTEXTUREHANDLEARBPROC epoxy_glGetTextureHandleARB;
    PFNGLGETTEXTUREHANDLENVPROC epoxy_glGetTextureHandleNV;
    PFNGLGETTEXTUREIMAGEPROC epoxy_glGetTextureImage;
    PFNGLGETTEXTUREIMAGEEXTPROC epoxy_glGetTextureImageEXT;
    PFNGLGETTEXTURELEVELPARAMETERFVPROC epoxy_glGetTextureLevelParameterfv;
    PFNGLGETTEXTURELEVELPARAMETERFVEXTPROC epoxy_glGetTextureLevelParameterfvEXT;
    PFNGLGETTEXTURELEVELPARAMETERIVPROC epoxy_glGetTextureLevelParameteriv;
    PFNGLGETTEXTURELEVELPARAMETERIVEXTPROC epoxy_glGetTextureLevelParameterivEXT;
    PFNGLGETTEXTUREPARAMETERIIVPROC epoxy_glGetTextureParameterIiv;
    PFNGLGETTEXTUREPARAMETERIIVEXTPROC epoxy_glGetTextureParameterIivEXT;
    PFNGLGETTEXTUREPARAMETERIUIVPROC epoxy_glGetTextureParameterIuiv;
    PFNGLGETTEXTUREPARAMETERIUIVEXTPROC epoxy_glGetTextureParameterIuivEXT;
    PFNGLGETTEXTUREPARAMETERFVPROC epoxy_glGetTextureParameterfv;
    PFNGLGETTEXTUREPARAMETERFVEXTPROC epoxy_glGetTextureParameterfvEXT;
    PFNGLGETTEXTUREPARAMETERIVPROC epoxy_glGetTextureParameteriv;
    PFNGLGETTEXTUREPARAMETERIVEXTPROC epoxy_glGetTextureParameterivEXT;
    PFNGLGETTEXTURESAMPLERHANDLEARBPROC epoxy_glGetTextureSamplerHandleARB;
    PFNGLGETTEXTURESAMPLERHANDLENVPROC epoxy_glGetTextureSamplerHandleNV;
    PFNGLGETTEXTURESUBIMAGEPROC epoxy_glGetTextureSubImage;
    PFNGLGETTRACKMATRIXIVNVPROC epoxy_glGetTrackMatrixivNV;
    PFNGLGETTRANSFORMFEEDBACKVARYINGPROC epoxy_glGetTransformFeedbackVarying;
    PFNGLGETTRANSFORMFEEDBACKVARYINGEXTPROC epoxy_glGetTransformFeedbackVaryingEXT;
    PFNGLGETTRANSFORMFEEDBACKVARYINGNVPROC epoxy_glGetTransformFeedbackVaryingNV;
    PFNGLGETTRANSFORMFEEDBACKI64_VPROC epoxy_glGetTransformFeedbacki64_v;
    PFNGLGETTRANSFORMFEEDBACKI_VPROC epoxy_glGetTransformFeedbacki_v;
    PFNGLGETTRANSFORMFEEDBACKIVPROC epoxy_glGetTransformFeedbackiv;
    PFNGLGETTRANSLATEDSHADERSOURCEANGLEPROC epoxy_glGetTranslatedShaderSourceANGLE;
    PFNGLGETUNIFORMBLOCKINDEXPROC epoxy_glGetUniformBlockIndex;
    PFNGLGETUNIFORMBUFFERSIZEEXTPROC epoxy_glGetUniformBufferSizeEXT;
    PFNGLGETUNIFORMINDICESPROC epoxy_glGetUniformIndices;
    PFNGLGETUNIFORMLOCATIONPROC epoxy_glGetUniformLocation;
    PFNGLGETUNIFORMLOCATIONARBPROC epoxy_glGetUniformLocationARB;
    PFNGLGETUNIFORMOFFSETEXTPROC epoxy_glGetUniformOffsetEXT;
    PFNGLGETUNIFORMSUBROUTINEUIVPROC epoxy_glGetUniformSubroutineuiv;
    PFNGLGETUNIFORMDVPROC epoxy_glGetUniformdv;
    PFNGLGETUNIFORMFVPROC epoxy_glGetUniformfv;
    PFNGLGETUNIFORMFVARBPROC epoxy_glGetUniformfvARB;
    PFNGLGETUNIFORMI64VNVPROC epoxy_glGetUniformi64vNV;
    PFNGLGETUNIFORMIVPROC epoxy_glGetUniformiv;
    PFNGLGETUNIFORMIVARBPROC epoxy_glGetUniformivARB;
    PFNGLGETUNIFORMUI64VNVPROC epoxy_glGetUniformui64vNV;
    PFNGLGETUNIFORMUIVPROC epoxy_glGetUniformuiv;
    PFNGLGETUNIFORMUIVEXTPROC epoxy_glGetUniformuivEXT;
    PFNGLGETVARIANTARRAYOBJECTFVATIPROC epoxy_glGetVariantArrayObjectfvATI;
    PFNGLGETVARIANTARRAYOBJECTIVATIPROC epoxy_glGetVariantArrayObjectivATI;
    PFNGLGETVARIANTBOOLEANVEXTPROC epoxy_glGetVariantBooleanvEXT;
    PFNGLGETVARIANTFLOATVEXTPROC epoxy_glGetVariantFloatvEXT;
    PFNGLGETVARIANTINTEGERVEXTPROC epoxy_glGetVariantIntegervEXT;
    PFNGLGETVARIANTPOINTERVEXTPROC epoxy_glGetVariantPointervEXT;
    PFNGLGETVARYINGLOCATIONNVPROC epoxy_glGetVaryingLocationNV;
    PFNGLGETVERTEXARRAYINDEXED64IVPROC epoxy_glGetVertexArrayIndexed64iv;
    PFNGLGETVERTEXARRAYINDEXEDIVPROC epoxy_glGetVertexArrayIndexediv;
    PFNGLGETVERTEXARRAYINTEGERI_VEXTPROC epoxy_glGetVertexArrayIntegeri_vEXT;
    PFNGLGETVERTEXARRAYINTEGERVEXTPROC epoxy_glGetVertexArrayIntegervEXT;
    PFNGLGETVERTEXARRAYPOINTERI_VEXTPROC epoxy_glGetVertexArrayPointeri_vEXT;
    PFNGLGETVERTEXARRAYPOINTERVEXTPROC epoxy_glGetVertexArrayPointervEXT;
    PFNGLGETVERTEXARRAYIVPROC epoxy_glGetVertexArrayiv;
    PFNGLGETVERTEXATTRIBARRAYOBJECTFVATIPROC epoxy_glGetVertexAttribArrayObjectfvATI;
    PFNGLGETVERTEXATTRIBARRAYOBJECTIVATIPROC epoxy_glGetVertexAttribArrayObjectivATI;
    PFNGLGETVERTEXATTRIBIIVPROC epoxy_glGetVertexAttribIiv;
    PFNGLGETVERTEXATTRIBIIVEXTPROC epoxy_glGetVertexAttribIivEXT;
    PFNGLGETVERTEXATTRIBIUIVPROC epoxy_glGetVertexAttribIuiv;
    PFNGLGETVERTEXATTRIBIUIVEXTPROC epoxy_glGetVertexAttribIuivEXT;
    PFNGLGETVERTEXATTRIBLDVPROC epoxy_glGetVertexAttribLdv;
    PFNGLGETVERTEXATTRIBLDVEXTPROC epoxy_glGetVertexAttribLdvEXT;
    PFNGLGETVERTEXATTRIBLI64VNVPROC epoxy_glGetVertexAttribLi64vNV;
    PFNGLGETVERTEXATTRIBLUI64VARBPROC epoxy_glGetVertexAttribLui64vARB;
    PFNGLGETVERTEXATTRIBLUI64VNVPROC epoxy_glGetVertexAttribLui64vNV;
    PFNGLGETVERTEXATTRIBPOINTERVPROC epoxy_glGetVertexAttribPointerv;
    PFNGLGETVERTEXATTRIBPOINTERVARBPROC epoxy_glGetVertexAttribPointervARB;
    PFNGLGETVERTEXATTRIBPOINTERVNVPROC epoxy_glGetVertexAttribPointervNV;
    PFNGLGETVERTEXATTRIBDVPROC epoxy_glGetVertexAttribdv;
    PFNGLGETVERTEXATTRIBDVARBPROC epoxy_glGetVertexAttribdvARB;
    PFNGLGETVERTEXATTRIBDVNVPROC epoxy_glGetVertexAttribdvNV;
    PFNGLGETVERTEXATTRIBFVPROC epoxy_glGetVertexAttribfv;
    PFNGLGETVERTEXATTRIBFVARBPROC epoxy_glGetVertexAttribfvARB;
    PFNGLGETVERTEXATTRIBFVNVPROC epoxy_glGetVertexAttribfvNV;
    PFNGLGETVERTEXATTRIBIVPROC epoxy_glGetVertexAttribiv;
    PFNGLGETVERTEXATTRIBIVARBPROC epoxy_glGetVertexAttribivARB;
    PFNGLGETVERTEXATTRIBIVNVPROC epoxy_glGetVertexAttribivNV;
    PFNGLGETVIDEOCAPTURESTREAMDVNVPROC epoxy_glGetVideoCaptureStreamdvNV;
    PFNGLGETVIDEOCAPTURESTREAMFVNVPROC epoxy_glGetVideoCaptureStreamfvNV;
    PFNGLGETVIDEOCAPTURESTREAMIVNVPROC epoxy_glGetVideoCaptureStreamivNV;
    PFNGLGETVIDEOCAPTUREIVNVPROC epoxy_glGetVideoCaptureivNV;
    PFNGLGETVIDEOI64VNVPROC epoxy_glGetVideoi64vNV;
    PFNGLGETVIDEOIVNVPROC epoxy_glGetVideoivNV;
    PFNGLGETVIDEOUI64VNVPROC epoxy_glGetVideoui64vNV;
    PFNGLGETVIDEOUIVNVPROC epoxy_glGetVideouivNV;
    PFNGLGETNCOLORTABLEPROC epoxy_glGetnColorTable;
    PFNGLGETNCOLORTABLEARBPROC epoxy_glGetnColorTableARB;
    PFNGLGETNCOMPRESSEDTEXIMAGEPROC epoxy_glGetnCompressedTexImage;
    PFNGLGETNCOMPRESSEDTEXIMAGEARBPROC epoxy_glGetnCompressedTexImageARB;
    PFNGLGETNCONVOLUTIONFILTERPROC epoxy_glGetnConvolutionFilter;
    PFNGLGETNCONVOLUTIONFILTERARBPROC epoxy_glGetnConvolutionFilterARB;
    PFNGLGETNHISTOGRAMPROC epoxy_glGetnHistogram;
    PFNGLGETNHISTOGRAMARBPROC epoxy_glGetnHistogramARB;
    PFNGLGETNMAPDVPROC epoxy_glGetnMapdv;
    PFNGLGETNMAPDVARBPROC epoxy_glGetnMapdvARB;
    PFNGLGETNMAPFVPROC epoxy_glGetnMapfv;
    PFNGLGETNMAPFVARBPROC epoxy_glGetnMapfvARB;
    PFNGLGETNMAPIVPROC epoxy_glGetnMapiv;
    PFNGLGETNMAPIVARBPROC epoxy_glGetnMapivARB;
    PFNGLGETNMINMAXPROC epoxy_glGetnMinmax;
    PFNGLGETNMINMAXARBPROC epoxy_glGetnMinmaxARB;
    PFNGLGETNPIXELMAPFVPROC epoxy_glGetnPixelMapfv;
    PFNGLGETNPIXELMAPFVARBPROC epoxy_glGetnPixelMapfvARB;
    PFNGLGETNPIXELMAPUIVPROC epoxy_glGetnPixelMapuiv;
    PFNGLGETNPIXELMAPUIVARBPROC epoxy_glGetnPixelMapuivARB;
    PFNGLGETNPIXELMAPUSVPROC epoxy_glGetnPixelMapusv;
    PFNGLGETNPIXELMAPUSVARBPROC epoxy_glGetnPixelMapusvARB;
    PFNGLGETNPOLYGONSTIPPLEPROC epoxy_glGetnPolygonStipple;
    PFNGLGETNPOLYGONSTIPPLEARBPROC epoxy_glGetnPolygonStippleARB;
    PFNGLGETNSEPARABLEFILTERPROC epoxy_glGetnSeparableFilter;
    PFNGLGETNSEPARABLEFILTERARBPROC epoxy_glGetnSeparableFilterARB;
    PFNGLGETNTEXIMAGEPROC epoxy_glGetnTexImage;
    PFNGLGETNTEXIMAGEARBPROC epoxy_glGetnTexImageARB;
    PFNGLGETNUNIFORMDVPROC epoxy_glGetnUniformdv;
    PFNGLGETNUNIFORMDVARBPROC epoxy_glGetnUniformdvARB;
    PFNGLGETNUNIFORMFVPROC epoxy_glGetnUniformfv;
    PFNGLGETNUNIFORMFVARBPROC epoxy_glGetnUniformfvARB;
    PFNGLGETNUNIFORMFVEXTPROC epoxy_glGetnUniformfvEXT;
    PFNGLGETNUNIFORMFVKHRPROC epoxy_glGetnUniformfvKHR;
    PFNGLGETNUNIFORMIVPROC epoxy_glGetnUniformiv;
    PFNGLGETNUNIFORMIVARBPROC epoxy_glGetnUniformivARB;
    PFNGLGETNUNIFORMIVEXTPROC epoxy_glGetnUniformivEXT;
    PFNGLGETNUNIFORMIVKHRPROC epoxy_glGetnUniformivKHR;
    PFNGLGETNUNIFORMUIVPROC epoxy_glGetnUniformuiv;
    PFNGLGETNUNIFORMUIVARBPROC epoxy_glGetnUniformuivARB;
    PFNGLGETNUNIFORMUIVKHRPROC epoxy_glGetnUniformuivKHR;
    PFNGLGLOBALALPHAFACTORBSUNPROC epoxy_glGlobalAlphaFactorbSUN;
    PFNGLGLOBALALPHAFACTORDSUNPROC epoxy_glGlobalAlphaFactordSUN;
    PFNGLGLOBALALPHAFACTORFSUNPROC epoxy_glGlobalAlphaFactorfSUN;
    PFNGLGLOBALALPHAFACTORISUNPROC epoxy_glGlobalAlphaFactoriSUN;
    PFNGLGLOBALALPHAFACTORSSUNPROC epoxy_glGlobalAlphaFactorsSUN;
    PFNGLGLOBALALPHAFACTORUBSUNPROC epoxy_glGlobalAlphaFactorubSUN;
    PFNGLGLOBALALPHAFACTORUISUNPROC epoxy_glGlobalAlphaFactoruiSUN;
    PFNGLGLOBALALPHAFACTORUSSUNPROC epoxy_glGlobalAlphaFactorusSUN;
    PFNGLHINTPROC epoxy_glHint;
    PFNGLHINTPGIPROC epoxy_glHintPGI;
    PFNGLHISTOGRAMPROC epoxy_glHistogram;
    PFNGLHISTOGRAMEXTPROC epoxy_glHistogramEXT;
    PFNGLIGLOOINTERFACESGIXPROC epoxy_glIglooInterfaceSGIX;
    PFNGLIMAGETRANSFORMPARAMETERFHPPROC epoxy_glImageTransformParameterfHP;
    PFNGLIMAGETRANSFORMPARAMETERFVHPPROC epoxy_glImageTransformParameterfvHP;
    PFNGLIMAGETRANSFORMPARAMETERIHPPROC epoxy_glImageTransformParameteriHP;
    PFNGLIMAGETRANSFORMPARAMETERIVHPPROC epoxy_glImageTransformParameterivHP;
    PFNGLIMPORTSYNCEXTPROC epoxy_glImportSyncEXT;
    PFNGLINDEXFORMATNVPROC epoxy_glIndexFormatNV;
    PFNGLINDEXFUNCEXTPROC epoxy_glIndexFuncEXT;
    PFNGLINDEXMASKPROC epoxy_glIndexMask;
    PFNGLINDEXMATERIALEXTPROC epoxy_glIndexMaterialEXT;
    PFNGLINDEXPOINTERPROC epoxy_glIndexPointer;
    PFNGLINDEXPOINTEREXTPROC epoxy_glIndexPointerEXT;
    PFNGLINDEXPOINTERLISTIBMPROC epoxy_glIndexPointerListIBM;
    PFNGLINDEXDPROC epoxy_glIndexd;
    PFNGLINDEXDVPROC epoxy_glIndexdv;
    PFNGLINDEXFPROC epoxy_glIndexf;
    PFNGLINDEXFVPROC epoxy_glIndexfv;
    PFNGLINDEXIPROC epoxy_glIndexi;
    PFNGLINDEXIVPROC epoxy_glIndexiv;
    PFNGLINDEXSPROC epoxy_glIndexs;
    PFNGLINDEXSVPROC epoxy_glIndexsv;
    PFNGLINDEXUBPROC epoxy_glIndexub;
    PFNGLINDEXUBVPROC epoxy_glIndexubv;
    PFNGLINDEXXOESPROC epoxy_glIndexxOES;
    PFNGLINDEXXVOESPROC epoxy_glIndexxvOES;
    PFNGLINITNAMESPROC epoxy_glInitNames;
    PFNGLINSERTCOMPONENTEXTPROC epoxy_glInsertComponentEXT;
    PFNGLINSERTEVENTMARKEREXTPROC epoxy_glInsertEventMarkerEXT;
    PFNGLINSTRUMENTSBUFFERSGIXPROC epoxy_glInstrumentsBufferSGIX;
    PFNGLINTERLEAVEDARRAYSPROC epoxy_glInterleavedArrays;
    PFNGLINTERPOLATEPATHSNVPROC epoxy_glInterpolatePathsNV;
    PFNGLINVALIDATEBUFFERDATAPROC epoxy_glInvalidateBufferData;
    PFNGLINVALIDATEBUFFERSUBDATAPROC epoxy_glInvalidateBufferSubData;
    PFNGLINVALIDATEFRAMEBUFFERPROC epoxy_glInvalidateFramebuffer;
    PFNGLINVALIDATENAMEDFRAMEBUFFERDATAPROC epoxy_glInvalidateNamedFramebufferData;
    PFNGLINVALIDATENAMEDFRAMEBUFFERSUBDATAPROC epoxy_glInvalidateNamedFramebufferSubData;
    PFNGLINVALIDATESUBFRAMEBUFFERPROC epoxy_glInvalidateSubFramebuffer;
    PFNGLINVALIDATETEXIMAGEPROC epoxy_glInvalidateTexImage;
    PFNGLINVALIDATETEXSUBIMAGEPROC epoxy_glInvalidateTexSubImage;
    PFNGLISASYNCMARKERSGIXPROC epoxy_glIsAsyncMarkerSGIX;
    PFNGLISBUFFERPROC epoxy_glIsBuffer;
    PFNGLISBUFFERARBPROC epoxy_glIsBufferARB;
    PFNGLISBUFFERRESIDENTNVPROC epoxy_glIsBufferResidentNV;
    PFNGLISCOMMANDLISTNVPROC epoxy_glIsCommandListNV;
    PFNGLISENABLEDPROC epoxy_glIsEnabled;
    PFNGLISENABLEDINDEXEDEXTPROC epoxy_glIsEnabledIndexedEXT;
    PFNGLISENABLEDIPROC epoxy_glIsEnabledi;
    PFNGLISENABLEDIEXTPROC epoxy_glIsEnablediEXT;
    PFNGLISENABLEDINVPROC epoxy_glIsEnablediNV;
    PFNGLISENABLEDIOESPROC epoxy_glIsEnablediOES;
    PFNGLISFENCEAPPLEPROC epoxy_glIsFenceAPPLE;
    PFNGLISFENCENVPROC epoxy_glIsFenceNV;
    PFNGLISFRAMEBUFFERPROC epoxy_glIsFramebuffer;
    PFNGLISFRAMEBUFFEREXTPROC epoxy_glIsFramebufferEXT;
    PFNGLISFRAMEBUFFEROESPROC epoxy_glIsFramebufferOES;
    PFNGLISIMAGEHANDLERESIDENTARBPROC epoxy_glIsImageHandleResidentARB;
    PFNGLISIMAGEHANDLERESIDENTNVPROC epoxy_glIsImageHandleResidentNV;
    PFNGLISLISTPROC epoxy_glIsList;
    PFNGLISNAMEAMDPROC epoxy_glIsNameAMD;
    PFNGLISNAMEDBUFFERRESIDENTNVPROC epoxy_glIsNamedBufferResidentNV;
    PFNGLISNAMEDSTRINGARBPROC epoxy_glIsNamedStringARB;
    PFNGLISOBJECTBUFFERATIPROC epoxy_glIsObjectBufferATI;
    PFNGLISOCCLUSIONQUERYNVPROC epoxy_glIsOcclusionQueryNV;
    PFNGLISPATHNVPROC epoxy_glIsPathNV;
    PFNGLISPOINTINFILLPATHNVPROC epoxy_glIsPointInFillPathNV;
    PFNGLISPOINTINSTROKEPATHNVPROC epoxy_glIsPointInStrokePathNV;
    PFNGLISPROGRAMPROC epoxy_glIsProgram;
    PFNGLISPROGRAMARBPROC epoxy_glIsProgramARB;
    PFNGLISPROGRAMNVPROC epoxy_glIsProgramNV;
    PFNGLISPROGRAMPIPELINEPROC epoxy_glIsProgramPipeline;
    PFNGLISPROGRAMPIPELINEEXTPROC epoxy_glIsProgramPipelineEXT;
    PFNGLISQUERYPROC epoxy_glIsQuery;
    PFNGLISQUERYARBPROC epoxy_glIsQueryARB;
    PFNGLISQUERYEXTPROC epoxy_glIsQueryEXT;
    PFNGLISRENDERBUFFERPROC epoxy_glIsRenderbuffer;
    PFNGLISRENDERBUFFEREXTPROC epoxy_glIsRenderbufferEXT;
    PFNGLISRENDERBUFFEROESPROC epoxy_glIsRenderbufferOES;
    PFNGLISSAMPLERPROC epoxy_glIsSampler;
    PFNGLISSHADERPROC epoxy_glIsShader;
    PFNGLISSTATENVPROC epoxy_glIsStateNV;
    PFNGLISSYNCPROC epoxy_glIsSync;
    PFNGLISSYNCAPPLEPROC epoxy_glIsSyncAPPLE;
    PFNGLISTEXTUREPROC epoxy_glIsTexture;
    PFNGLISTEXTUREEXTPROC epoxy_glIsTextureEXT;
    PFNGLISTEXTUREHANDLERESIDENTARBPROC epoxy_glIsTextureHandleResidentARB;
    PFNGLISTEXTUREHANDLERESIDENTNVPROC epoxy_glIsTextureHandleResidentNV;
    PFNGLISTRANSFORMFEEDBACKPROC epoxy_glIsTransformFeedback;
    PFNGLISTRANSFORMFEEDBACKNVPROC epoxy_glIsTransformFeedbackNV;
    PFNGLISVARIANTENABLEDEXTPROC epoxy_glIsVariantEnabledEXT;
    PFNGLISVERTEXARRAYPROC epoxy_glIsVertexArray;
    PFNGLISVERTEXARRAYAPPLEPROC epoxy_glIsVertexArrayAPPLE;
    PFNGLISVERTEXARRAYOESPROC epoxy_glIsVertexArrayOES;
    PFNGLISVERTEXATTRIBENABLEDAPPLEPROC epoxy_glIsVertexAttribEnabledAPPLE;
    PFNGLLABELOBJECTEXTPROC epoxy_glLabelObjectEXT;
    PFNGLLIGHTENVISGIXPROC epoxy_glLightEnviSGIX;
    PFNGLLIGHTMODELFPROC epoxy_glLightModelf;
    PFNGLLIGHTMODELFVPROC epoxy_glLightModelfv;
    PFNGLLIGHTMODELIPROC epoxy_glLightModeli;
    PFNGLLIGHTMODELIVPROC epoxy_glLightModeliv;
    PFNGLLIGHTMODELXPROC epoxy_glLightModelx;
    PFNGLLIGHTMODELXOESPROC epoxy_glLightModelxOES;
    PFNGLLIGHTMODELXVPROC epoxy_glLightModelxv;
    PFNGLLIGHTMODELXVOESPROC epoxy_glLightModelxvOES;
    PFNGLLIGHTFPROC epoxy_glLightf;
    PFNGLLIGHTFVPROC epoxy_glLightfv;
    PFNGLLIGHTIPROC epoxy_glLighti;
    PFNGLLIGHTIVPROC epoxy_glLightiv;
    PFNGLLIGHTXPROC epoxy_glLightx;
    PFNGLLIGHTXOESPROC epoxy_glLightxOES;
    PFNGLLIGHTXVPROC epoxy_glLightxv;
    PFNGLLIGHTXVOESPROC epoxy_glLightxvOES;
    PFNGLLINESTIPPLEPROC epoxy_glLineStipple;
    PFNGLLINEWIDTHPROC epoxy_glLineWidth;
    PFNGLLINEWIDTHXPROC epoxy_glLineWidthx;
    PFNGLLINEWIDTHXOESPROC epoxy_glLineWidthxOES;
    PFNGLLINKPROGRAMPROC epoxy_glLinkProgram;
    PFNGLLINKPROGRAMARBPROC epoxy_glLinkProgramARB;
    PFNGLLISTBASEPROC epoxy_glListBase;
    PFNGLLISTDRAWCOMMANDSSTATESCLIENTNVPROC epoxy_glListDrawCommandsStatesClientNV;
    PFNGLLISTPARAMETERFSGIXPROC epoxy_glListParameterfSGIX;
    PFNGLLISTPARAMETERFVSGIXPROC epoxy_glListParameterfvSGIX;
    PFNGLLISTPARAMETERISGIXPROC epoxy_glListParameteriSGIX;
    PFNGLLISTPARAMETERIVSGIXPROC epoxy_glListParameterivSGIX;
    PFNGLLOADIDENTITYPROC epoxy_glLoadIdentity;
    PFNGLLOADIDENTITYDEFORMATIONMAPSGIXPROC epoxy_glLoadIdentityDeformationMapSGIX;
    PFNGLLOADMATRIXDPROC epoxy_glLoadMatrixd;
    PFNGLLOADMATRIXFPROC epoxy_glLoadMatrixf;
    PFNGLLOADMATRIXXPROC epoxy_glLoadMatrixx;
    PFNGLLOADMATRIXXOESPROC epoxy_glLoadMatrixxOES;
    PFNGLLOADNAMEPROC epoxy_glLoadName;
    PFNGLLOADPALETTEFROMMODELVIEWMATRIXOESPROC epoxy_glLoadPaletteFromModelViewMatrixOES;
    PFNGLLOADPROGRAMNVPROC epoxy_glLoadProgramNV;
    PFNGLLOADTRANSPOSEMATRIXDPROC epoxy_glLoadTransposeMatrixd;
    PFNGLLOADTRANSPOSEMATRIXDARBPROC epoxy_glLoadTransposeMatrixdARB;
    PFNGLLOADTRANSPOSEMATRIXFPROC epoxy_glLoadTransposeMatrixf;
    PFNGLLOADTRANSPOSEMATRIXFARBPROC epoxy_glLoadTransposeMatrixfARB;
    PFNGLLOADTRANSPOSEMATRIXXOESPROC epoxy_glLoadTransposeMatrixxOES;
    PFNGLLOCKARRAYSEXTPROC epoxy_glLockArraysEXT;
    PFNGLLOGICOPPROC epoxy_glLogicOp;
    PFNGLMAKEBUFFERNONRESIDENTNVPROC epoxy_glMakeBufferNonResidentNV;
    PFNGLMAKEBUFFERRESIDENTNVPROC epoxy_glMakeBufferResidentNV;
    PFNGLMAKEIMAGEHANDLENONRESIDENTARBPROC epoxy_glMakeImageHandleNonResidentARB;
    PFNGLMAKEIMAGEHANDLENONRESIDENTNVPROC epoxy_glMakeImageHandleNonResidentNV;
    PFNGLMAKEIMAGEHANDLERESIDENTARBPROC epoxy_glMakeImageHandleResidentARB;
    PFNGLMAKEIMAGEHANDLERESIDENTNVPROC epoxy_glMakeImageHandleResidentNV;
    PFNGLMAKENAMEDBUFFERNONRESIDENTNVPROC epoxy_glMakeNamedBufferNonResidentNV;
    PFNGLMAKENAMEDBUFFERRESIDENTNVPROC epoxy_glMakeNamedBufferResidentNV;
    PFNGLMAKETEXTUREHANDLENONRESIDENTARBPROC epoxy_glMakeTextureHandleNonResidentARB;
    PFNGLMAKETEXTUREHANDLENONRESIDENTNVPROC epoxy_glMakeTextureHandleNonResidentNV;
    PFNGLMAKETEXTUREHANDLERESIDENTARBPROC epoxy_glMakeTextureHandleResidentARB;
    PFNGLMAKETEXTUREHANDLERESIDENTNVPROC epoxy_glMakeTextureHandleResidentNV;
    PFNGLMAP1DPROC epoxy_glMap1d;
    PFNGLMAP1FPROC epoxy_glMap1f;
    PFNGLMAP1XOESPROC epoxy_glMap1xOES;
    PFNGLMAP2DPROC epoxy_glMap2d;
    PFNGLMAP2FPROC epoxy_glMap2f;
    PFNGLMAP2XOESPROC epoxy_glMap2xOES;
    PFNGLMAPBUFFERPROC epoxy_glMapBuffer;
    PFNGLMAPBUFFERARBPROC epoxy_glMapBufferARB;
    PFNGLMAPBUFFEROESPROC epoxy_glMapBufferOES;
    PFNGLMAPBUFFERRANGEPROC epoxy_glMapBufferRange;
    PFNGLMAPBUFFERRANGEEXTPROC epoxy_glMapBufferRangeEXT;
    PFNGLMAPCONTROLPOINTSNVPROC epoxy_glMapControlPointsNV;
    PFNGLMAPGRID1DPROC epoxy_glMapGrid1d;
    PFNGLMAPGRID1FPROC epoxy_glMapGrid1f;
    PFNGLMAPGRID1XOESPROC epoxy_glMapGrid1xOES;
    PFNGLMAPGRID2DPROC epoxy_glMapGrid2d;
    PFNGLMAPGRID2FPROC epoxy_glMapGrid2f;
    PFNGLMAPGRID2XOESPROC epoxy_glMapGrid2xOES;
    PFNGLMAPNAMEDBUFFERPROC epoxy_glMapNamedBuffer;
    PFNGLMAPNAMEDBUFFEREXTPROC epoxy_glMapNamedBufferEXT;
    PFNGLMAPNAMEDBUFFERRANGEPROC epoxy_glMapNamedBufferRange;
    PFNGLMAPNAMEDBUFFERRANGEEXTPROC epoxy_glMapNamedBufferRangeEXT;
    PFNGLMAPOBJECTBUFFERATIPROC epoxy_glMapObjectBufferATI;
    PFNGLMAPPARAMETERFVNVPROC epoxy_glMapParameterfvNV;
    PFNGLMAPPARAMETERIVNVPROC epoxy_glMapParameterivNV;
    PFNGLMAPTEXTURE2DINTELPROC epoxy_glMapTexture2DINTEL;
    PFNGLMAPVERTEXATTRIB1DAPPLEPROC epoxy_glMapVertexAttrib1dAPPLE;
    PFNGLMAPVERTEXATTRIB1FAPPLEPROC epoxy_glMapVertexAttrib1fAPPLE;
    PFNGLMAPVERTEXATTRIB2DAPPLEPROC epoxy_glMapVertexAttrib2dAPPLE;
    PFNGLMAPVERTEXATTRIB2FAPPLEPROC epoxy_glMapVertexAttrib2fAPPLE;
    PFNGLMATERIALFPROC epoxy_glMaterialf;
    PFNGLMATERIALFVPROC epoxy_glMaterialfv;
    PFNGLMATERIALIPROC epoxy_glMateriali;
    PFNGLMATERIALIVPROC epoxy_glMaterialiv;
    PFNGLMATERIALXPROC epoxy_glMaterialx;
    PFNGLMATERIALXOESPROC epoxy_glMaterialxOES;
    PFNGLMATERIALXVPROC epoxy_glMaterialxv;
    PFNGLMATERIALXVOESPROC epoxy_glMaterialxvOES;
    PFNGLMATRIXFRUSTUMEXTPROC epoxy_glMatrixFrustumEXT;
    PFNGLMATRIXINDEXPOINTERARBPROC epoxy_glMatrixIndexPointerARB;
    PFNGLMATRIXINDEXPOINTEROESPROC epoxy_glMatrixIndexPointerOES;
    PFNGLMATRIXINDEXUBVARBPROC epoxy_glMatrixIndexubvARB;
    PFNGLMATRIXINDEXUIVARBPROC epoxy_glMatrixIndexuivARB;
    PFNGLMATRIXINDEXUSVARBPROC epoxy_glMatrixIndexusvARB;
    PFNGLMATRIXLOAD3X2FNVPROC epoxy_glMatrixLoad3x2fNV;
    PFNGLMATRIXLOAD3X3FNVPROC epoxy_glMatrixLoad3x3fNV;
    PFNGLMATRIXLOADIDENTITYEXTPROC epoxy_glMatrixLoadIdentityEXT;
    PFNGLMATRIXLOADTRANSPOSE3X3FNVPROC epoxy_glMatrixLoadTranspose3x3fNV;
    PFNGLMATRIXLOADTRANSPOSEDEXTPROC epoxy_glMatrixLoadTransposedEXT;
    PFNGLMATRIXLOADTRANSPOSEFEXTPROC epoxy_glMatrixLoadTransposefEXT;
    PFNGLMATRIXLOADDEXTPROC epoxy_glMatrixLoaddEXT;
    PFNGLMATRIXLOADFEXTPROC epoxy_glMatrixLoadfEXT;
    PFNGLMATRIXMODEPROC epoxy_glMatrixMode;
    PFNGLMATRIXMULT3X2FNVPROC epoxy_glMatrixMult3x2fNV;
    PFNGLMATRIXMULT3X3FNVPROC epoxy_glMatrixMult3x3fNV;
    PFNGLMATRIXMULTTRANSPOSE3X3FNVPROC epoxy_glMatrixMultTranspose3x3fNV;
    PFNGLMATRIXMULTTRANSPOSEDEXTPROC epoxy_glMatrixMultTransposedEXT;
    PFNGLMATRIXMULTTRANSPOSEFEXTPROC epoxy_glMatrixMultTransposefEXT;
    PFNGLMATRIXMULTDEXTPROC epoxy_glMatrixMultdEXT;
    PFNGLMATRIXMULTFEXTPROC epoxy_glMatrixMultfEXT;
    PFNGLMATRIXORTHOEXTPROC epoxy_glMatrixOrthoEXT;
    PFNGLMATRIXPOPEXTPROC epoxy_glMatrixPopEXT;
    PFNGLMATRIXPUSHEXTPROC epoxy_glMatrixPushEXT;
    PFNGLMATRIXROTATEDEXTPROC epoxy_glMatrixRotatedEXT;
    PFNGLMATRIXROTATEFEXTPROC epoxy_glMatrixRotatefEXT;
    PFNGLMATRIXSCALEDEXTPROC epoxy_glMatrixScaledEXT;
    PFNGLMATRIXSCALEFEXTPROC epoxy_glMatrixScalefEXT;
    PFNGLMATRIXTRANSLATEDEXTPROC epoxy_glMatrixTranslatedEXT;
    PFNGLMATRIXTRANSLATEFEXTPROC epoxy_glMatrixTranslatefEXT;
    PFNGLMEMORYBARRIERPROC epoxy_glMemoryBarrier;
    PFNGLMEMORYBARRIERBYREGIONPROC epoxy_glMemoryBarrierByRegion;
    PFNGLMEMORYBARRIEREXTPROC epoxy_glMemoryBarrierEXT;
    PFNGLMINSAMPLESHADINGPROC epoxy_glMinSampleShading;
    PFNGLMINSAMPLESHADINGARBPROC epoxy_glMinSampleShadingARB;
    PFNGLMINSAMPLESHADINGOESPROC epoxy_glMinSampleShadingOES;
    PFNGLMINMAXPROC epoxy_glMinmax;
    PFNGLMINMAXEXTPROC epoxy_glMinmaxEXT;
    PFNGLMULTMATRIXDPROC epoxy_glMultMatrixd;
    PFNGLMULTMATRIXFPROC epoxy_glMultMatrixf;
    PFNGLMULTMATRIXXPROC epoxy_glMultMatrixx;
    PFNGLMULTMATRIXXOESPROC epoxy_glMultMatrixxOES;
    PFNGLMULTTRANSPOSEMATRIXDPROC epoxy_glMultTransposeMatrixd;
    PFNGLMULTTRANSPOSEMATRIXDARBPROC epoxy_glMultTransposeMatrixdARB;
    PFNGLMULTTRANSPOSEMATRIXFPROC epoxy_glMultTransposeMatrixf;
    PFNGLMULTTRANSPOSEMATRIXFARBPROC epoxy_glMultTransposeMatrixfARB;
    PFNGLMULTTRANSPOSEMATRIXXOESPROC epoxy_glMultTransposeMatrixxOES;
    PFNGLMULTIDRAWARRAYSPROC epoxy_glMultiDrawArrays;
    PFNGLMULTIDRAWARRAYSEXTPROC epoxy_glMultiDrawArraysEXT;
    PFNGLMULTIDRAWARRAYSINDIRECTPROC epoxy_glMultiDrawArraysIndirect;
    PFNGLMULTIDRAWARRAYSINDIRECTAMDPROC epoxy_glMultiDrawArraysIndirectAMD;
    PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSCOUNTNVPROC epoxy_glMultiDrawArraysIndirectBindlessCountNV;
    PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSNVPROC epoxy_glMultiDrawArraysIndirectBindlessNV;
    PFNGLMULTIDRAWARRAYSINDIRECTCOUNTARBPROC epoxy_glMultiDrawArraysIndirectCountARB;
    PFNGLMULTIDRAWARRAYSINDIRECTEXTPROC epoxy_glMultiDrawArraysIndirectEXT;
    PFNGLMULTIDRAWELEMENTARRAYAPPLEPROC epoxy_glMultiDrawElementArrayAPPLE;
    PFNGLMULTIDRAWELEMENTSPROC epoxy_glMultiDrawElements;
    PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC epoxy_glMultiDrawElementsBaseVertex;
    PFNGLMULTIDRAWELEMENTSBASEVERTEXEXTPROC epoxy_glMultiDrawElementsBaseVertexEXT;
    PFNGLMULTIDRAWELEMENTSBASEVERTEXOESPROC epoxy_glMultiDrawElementsBaseVertexOES;
    PFNGLMULTIDRAWELEMENTSEXTPROC epoxy_glMultiDrawElementsEXT;
    PFNGLMULTIDRAWELEMENTSINDIRECTPROC epoxy_glMultiDrawElementsIndirect;
    PFNGLMULTIDRAWELEMENTSINDIRECTAMDPROC epoxy_glMultiDrawElementsIndirectAMD;
    PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSCOUNTNVPROC epoxy_glMultiDrawElementsIndirectBindlessCountNV;
    PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSNVPROC epoxy_glMultiDrawElementsIndirectBindlessNV;
    PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTARBPROC epoxy_glMultiDrawElementsIndirectCountARB;
    PFNGLMULTIDRAWELEMENTSINDIRECTEXTPROC epoxy_glMultiDrawElementsIndirectEXT;
    PFNGLMULTIDRAWRANGEELEMENTARRAYAPPLEPROC epoxy_glMultiDrawRangeElementArrayAPPLE;
    PFNGLMULTIMODEDRAWARRAYSIBMPROC epoxy_glMultiModeDrawArraysIBM;
    PFNGLMULTIMODEDRAWELEMENTSIBMPROC epoxy_glMultiModeDrawElementsIBM;
    PFNGLMULTITEXBUFFEREXTPROC epoxy_glMultiTexBufferEXT;
    PFNGLMULTITEXCOORD1BOESPROC epoxy_glMultiTexCoord1bOES;
    PFNGLMULTITEXCOORD1BVOESPROC epoxy_glMultiTexCoord1bvOES;
    PFNGLMULTITEXCOORD1DPROC epoxy_glMultiTexCoord1d;
    PFNGLMULTITEXCOORD1DARBPROC epoxy_glMultiTexCoord1dARB;
    PFNGLMULTITEXCOORD1DVPROC epoxy_glMultiTexCoord1dv;
    PFNGLMULTITEXCOORD1DVARBPROC epoxy_glMultiTexCoord1dvARB;
    PFNGLMULTITEXCOORD1FPROC epoxy_glMultiTexCoord1f;
    PFNGLMULTITEXCOORD1FARBPROC epoxy_glMultiTexCoord1fARB;
    PFNGLMULTITEXCOORD1FVPROC epoxy_glMultiTexCoord1fv;
    PFNGLMULTITEXCOORD1FVARBPROC epoxy_glMultiTexCoord1fvARB;
    PFNGLMULTITEXCOORD1HNVPROC epoxy_glMultiTexCoord1hNV;
    PFNGLMULTITEXCOORD1HVNVPROC epoxy_glMultiTexCoord1hvNV;
    PFNGLMULTITEXCOORD1IPROC epoxy_glMultiTexCoord1i;
    PFNGLMULTITEXCOORD1IARBPROC epoxy_glMultiTexCoord1iARB;
    PFNGLMULTITEXCOORD1IVPROC epoxy_glMultiTexCoord1iv;
    PFNGLMULTITEXCOORD1IVARBPROC epoxy_glMultiTexCoord1ivARB;
    PFNGLMULTITEXCOORD1SPROC epoxy_glMultiTexCoord1s;
    PFNGLMULTITEXCOORD1SARBPROC epoxy_glMultiTexCoord1sARB;
    PFNGLMULTITEXCOORD1SVPROC epoxy_glMultiTexCoord1sv;
    PFNGLMULTITEXCOORD1SVARBPROC epoxy_glMultiTexCoord1svARB;
    PFNGLMULTITEXCOORD1XOESPROC epoxy_glMultiTexCoord1xOES;
    PFNGLMULTITEXCOORD1XVOESPROC epoxy_glMultiTexCoord1xvOES;
    PFNGLMULTITEXCOORD2BOESPROC epoxy_glMultiTexCoord2bOES;
    PFNGLMULTITEXCOORD2BVOESPROC epoxy_glMultiTexCoord2bvOES;
    PFNGLMULTITEXCOORD2DPROC epoxy_glMultiTexCoord2d;
    PFNGLMULTITEXCOORD2DARBPROC epoxy_glMultiTexCoord2dARB;
    PFNGLMULTITEXCOORD2DVPROC epoxy_glMultiTexCoord2dv;
    PFNGLMULTITEXCOORD2DVARBPROC epoxy_glMultiTexCoord2dvARB;
    PFNGLMULTITEXCOORD2FPROC epoxy_glMultiTexCoord2f;
    PFNGLMULTITEXCOORD2FARBPROC epoxy_glMultiTexCoord2fARB;
    PFNGLMULTITEXCOORD2FVPROC epoxy_glMultiTexCoord2fv;
    PFNGLMULTITEXCOORD2FVARBPROC epoxy_glMultiTexCoord2fvARB;
    PFNGLMULTITEXCOORD2HNVPROC epoxy_glMultiTexCoord2hNV;
    PFNGLMULTITEXCOORD2HVNVPROC epoxy_glMultiTexCoord2hvNV;
    PFNGLMULTITEXCOORD2IPROC epoxy_glMultiTexCoord2i;
    PFNGLMULTITEXCOORD2IARBPROC epoxy_glMultiTexCoord2iARB;
    PFNGLMULTITEXCOORD2IVPROC epoxy_glMultiTexCoord2iv;
    PFNGLMULTITEXCOORD2IVARBPROC epoxy_glMultiTexCoord2ivARB;
    PFNGLMULTITEXCOORD2SPROC epoxy_glMultiTexCoord2s;
    PFNGLMULTITEXCOORD2SARBPROC epoxy_glMultiTexCoord2sARB;
    PFNGLMULTITEXCOORD2SVPROC epoxy_glMultiTexCoord2sv;
    PFNGLMULTITEXCOORD2SVARBPROC epoxy_glMultiTexCoord2svARB;
    PFNGLMULTITEXCOORD2XOESPROC epoxy_glMultiTexCoord2xOES;
    PFNGLMULTITEXCOORD2XVOESPROC epoxy_glMultiTexCoord2xvOES;
    PFNGLMULTITEXCOORD3BOESPROC epoxy_glMultiTexCoord3bOES;
    PFNGLMULTITEXCOORD3BVOESPROC epoxy_glMultiTexCoord3bvOES;
    PFNGLMULTITEXCOORD3DPROC epoxy_glMultiTexCoord3d;
    PFNGLMULTITEXCOORD3DARBPROC epoxy_glMultiTexCoord3dARB;
    PFNGLMULTITEXCOORD3DVPROC epoxy_glMultiTexCoord3dv;
    PFNGLMULTITEXCOORD3DVARBPROC epoxy_glMultiTexCoord3dvARB;
    PFNGLMULTITEXCOORD3FPROC epoxy_glMultiTexCoord3f;
    PFNGLMULTITEXCOORD3FARBPROC epoxy_glMultiTexCoord3fARB;
    PFNGLMULTITEXCOORD3FVPROC epoxy_glMultiTexCoord3fv;
    PFNGLMULTITEXCOORD3FVARBPROC epoxy_glMultiTexCoord3fvARB;
    PFNGLMULTITEXCOORD3HNVPROC epoxy_glMultiTexCoord3hNV;
    PFNGLMULTITEXCOORD3HVNVPROC epoxy_glMultiTexCoord3hvNV;
    PFNGLMULTITEXCOORD3IPROC epoxy_glMultiTexCoord3i;
    PFNGLMULTITEXCOORD3IARBPROC epoxy_glMultiTexCoord3iARB;
    PFNGLMULTITEXCOORD3IVPROC epoxy_glMultiTexCoord3iv;
    PFNGLMULTITEXCOORD3IVARBPROC epoxy_glMultiTexCoord3ivARB;
    PFNGLMULTITEXCOORD3SPROC epoxy_glMultiTexCoord3s;
    PFNGLMULTITEXCOORD3SARBPROC epoxy_glMultiTexCoord3sARB;
    PFNGLMULTITEXCOORD3SVPROC epoxy_glMultiTexCoord3sv;
    PFNGLMULTITEXCOORD3SVARBPROC epoxy_glMultiTexCoord3svARB;
    PFNGLMULTITEXCOORD3XOESPROC epoxy_glMultiTexCoord3xOES;
    PFNGLMULTITEXCOORD3XVOESPROC epoxy_glMultiTexCoord3xvOES;
    PFNGLMULTITEXCOORD4BOESPROC epoxy_glMultiTexCoord4bOES;
    PFNGLMULTITEXCOORD4BVOESPROC epoxy_glMultiTexCoord4bvOES;
    PFNGLMULTITEXCOORD4DPROC epoxy_glMultiTexCoord4d;
    PFNGLMULTITEXCOORD4DARBPROC epoxy_glMultiTexCoord4dARB;
    PFNGLMULTITEXCOORD4DVPROC epoxy_glMultiTexCoord4dv;
    PFNGLMULTITEXCOORD4DVARBPROC epoxy_glMultiTexCoord4dvARB;
    PFNGLMULTITEXCOORD4FPROC epoxy_glMultiTexCoord4f;
    PFNGLMULTITEXCOORD4FARBPROC epoxy_glMultiTexCoord4fARB;
    PFNGLMULTITEXCOORD4FVPROC epoxy_glMultiTexCoord4fv;
    PFNGLMULTITEXCOORD4FVARBPROC epoxy_glMultiTexCoord4fvARB;
    PFNGLMULTITEXCOORD4HNVPROC epoxy_glMultiTexCoord4hNV;
    PFNGLMULTITEXCOORD4HVNVPROC epoxy_glMultiTexCoord4hvNV;
    PFNGLMULTITEXCOORD4IPROC epoxy_glMultiTexCoord4i;
    PFNGLMULTITEXCOORD4IARBPROC epoxy_glMultiTexCoord4iARB;
    PFNGLMULTITEXCOORD4IVPROC epoxy_glMultiTexCoord4iv;
    PFNGLMULTITEXCOORD4IVARBPROC epoxy_glMultiTexCoord4ivARB;
    PFNGLMULTITEXCOORD4SPROC epoxy_glMultiTexCoord4s;
    PFNGLMULTITEXCOORD4SARBPROC epoxy_glMultiTexCoord4sARB;
    PFNGLMULTITEXCOORD4SVPROC epoxy_glMultiTexCoord4sv;
    PFNGLMULTITEXCOORD4SVARBPROC epoxy_glMultiTexCoord4svARB;
    PFNGLMULTITEXCOORD4XPROC epoxy_glMultiTexCoord4x;
    PFNGLMULTITEXCOORD4XOESPROC epoxy_glMultiTexCoord4xOES;
    PFNGLMULTITEXCOORD4XVOESPROC epoxy_glMultiTexCoord4xvOES;
    PFNGLMULTITEXCOORDP1UIPROC epoxy_glMultiTexCoordP1ui;
    PFNGLMULTITEXCOORDP1UIVPROC epoxy_glMultiTexCoordP1uiv;
    PFNGLMULTITEXCOORDP2UIPROC epoxy_glMultiTexCoordP2ui;
    PFNGLMULTITEXCOORDP2UIVPROC epoxy_glMultiTexCoordP2uiv;
    PFNGLMULTITEXCOORDP3UIPROC epoxy_glMultiTexCoordP3ui;
    PFNGLMULTITEXCOORDP3UIVPROC epoxy_glMultiTexCoordP3uiv;
    PFNGLMULTITEXCOORDP4UIPROC epoxy_glMultiTexCoordP4ui;
    PFNGLMULTITEXCOORDP4UIVPROC epoxy_glMultiTexCoordP4uiv;
    PFNGLMULTITEXCOORDPOINTEREXTPROC epoxy_glMultiTexCoordPointerEXT;
    PFNGLMULTITEXENVFEXTPROC epoxy_glMultiTexEnvfEXT;
    PFNGLMULTITEXENVFVEXTPROC epoxy_glMultiTexEnvfvEXT;
    PFNGLMULTITEXENVIEXTPROC epoxy_glMultiTexEnviEXT;
    PFNGLMULTITEXENVIVEXTPROC epoxy_glMultiTexEnvivEXT;
    PFNGLMULTITEXGENDEXTPROC epoxy_glMultiTexGendEXT;
    PFNGLMULTITEXGENDVEXTPROC epoxy_glMultiTexGendvEXT;
    PFNGLMULTITEXGENFEXTPROC epoxy_glMultiTexGenfEXT;
    PFNGLMULTITEXGENFVEXTPROC epoxy_glMultiTexGenfvEXT;
    PFNGLMULTITEXGENIEXTPROC epoxy_glMultiTexGeniEXT;
    PFNGLMULTITEXGENIVEXTPROC epoxy_glMultiTexGenivEXT;
    PFNGLMULTITEXIMAGE1DEXTPROC epoxy_glMultiTexImage1DEXT;
    PFNGLMULTITEXIMAGE2DEXTPROC epoxy_glMultiTexImage2DEXT;
    PFNGLMULTITEXIMAGE3DEXTPROC epoxy_glMultiTexImage3DEXT;
    PFNGLMULTITEXPARAMETERIIVEXTPROC epoxy_glMultiTexParameterIivEXT;
    PFNGLMULTITEXPARAMETERIUIVEXTPROC epoxy_glMultiTexParameterIuivEXT;
    PFNGLMULTITEXPARAMETERFEXTPROC epoxy_glMultiTexParameterfEXT;
    PFNGLMULTITEXPARAMETERFVEXTPROC epoxy_glMultiTexParameterfvEXT;
    PFNGLMULTITEXPARAMETERIEXTPROC epoxy_glMultiTexParameteriEXT;
    PFNGLMULTITEXPARAMETERIVEXTPROC epoxy_glMultiTexParameterivEXT;
    PFNGLMULTITEXRENDERBUFFEREXTPROC epoxy_glMultiTexRenderbufferEXT;
    PFNGLMULTITEXSUBIMAGE1DEXTPROC epoxy_glMultiTexSubImage1DEXT;
    PFNGLMULTITEXSUBIMAGE2DEXTPROC epoxy_glMultiTexSubImage2DEXT;
    PFNGLMULTITEXSUBIMAGE3DEXTPROC epoxy_glMultiTexSubImage3DEXT;
    PFNGLNAMEDBUFFERDATAPROC epoxy_glNamedBufferData;
    PFNGLNAMEDBUFFERDATAEXTPROC epoxy_glNamedBufferDataEXT;
    PFNGLNAMEDBUFFERPAGECOMMITMENTARBPROC epoxy_glNamedBufferPageCommitmentARB;
    PFNGLNAMEDBUFFERPAGECOMMITMENTEXTPROC epoxy_glNamedBufferPageCommitmentEXT;
    PFNGLNAMEDBUFFERSTORAGEPROC epoxy_glNamedBufferStorage;
    PFNGLNAMEDBUFFERSTORAGEEXTPROC epoxy_glNamedBufferStorageEXT;
    PFNGLNAMEDBUFFERSUBDATAPROC epoxy_glNamedBufferSubData;
    PFNGLNAMEDBUFFERSUBDATAEXTPROC epoxy_glNamedBufferSubDataEXT;
    PFNGLNAMEDCOPYBUFFERSUBDATAEXTPROC epoxy_glNamedCopyBufferSubDataEXT;
    PFNGLNAMEDFRAMEBUFFERDRAWBUFFERPROC epoxy_glNamedFramebufferDrawBuffer;
    PFNGLNAMEDFRAMEBUFFERDRAWBUFFERSPROC epoxy_glNamedFramebufferDrawBuffers;
    PFNGLNAMEDFRAMEBUFFERPARAMETERIPROC epoxy_glNamedFramebufferParameteri;
    PFNGLNAMEDFRAMEBUFFERPARAMETERIEXTPROC epoxy_glNamedFramebufferParameteriEXT;
    PFNGLNAMEDFRAMEBUFFERREADBUFFERPROC epoxy_glNamedFramebufferReadBuffer;
    PFNGLNAMEDFRAMEBUFFERRENDERBUFFERPROC epoxy_glNamedFramebufferRenderbuffer;
    PFNGLNAMEDFRAMEBUFFERRENDERBUFFEREXTPROC epoxy_glNamedFramebufferRenderbufferEXT;
    PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVNVPROC epoxy_glNamedFramebufferSampleLocationsfvNV;
    PFNGLNAMEDFRAMEBUFFERTEXTUREPROC epoxy_glNamedFramebufferTexture;
    PFNGLNAMEDFRAMEBUFFERTEXTURE1DEXTPROC epoxy_glNamedFramebufferTexture1DEXT;
    PFNGLNAMEDFRAMEBUFFERTEXTURE2DEXTPROC epoxy_glNamedFramebufferTexture2DEXT;
    PFNGLNAMEDFRAMEBUFFERTEXTURE3DEXTPROC epoxy_glNamedFramebufferTexture3DEXT;
    PFNGLNAMEDFRAMEBUFFERTEXTUREEXTPROC epoxy_glNamedFramebufferTextureEXT;
    PFNGLNAMEDFRAMEBUFFERTEXTUREFACEEXTPROC epoxy_glNamedFramebufferTextureFaceEXT;
    PFNGLNAMEDFRAMEBUFFERTEXTURELAYERPROC epoxy_glNamedFramebufferTextureLayer;
    PFNGLNAMEDFRAMEBUFFERTEXTURELAYEREXTPROC epoxy_glNamedFramebufferTextureLayerEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETER4DEXTPROC epoxy_glNamedProgramLocalParameter4dEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETER4DVEXTPROC epoxy_glNamedProgramLocalParameter4dvEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETER4FEXTPROC epoxy_glNamedProgramLocalParameter4fEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETER4FVEXTPROC epoxy_glNamedProgramLocalParameter4fvEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETERI4IEXTPROC epoxy_glNamedProgramLocalParameterI4iEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETERI4IVEXTPROC epoxy_glNamedProgramLocalParameterI4ivEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIEXTPROC epoxy_glNamedProgramLocalParameterI4uiEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIVEXTPROC epoxy_glNamedProgramLocalParameterI4uivEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETERS4FVEXTPROC epoxy_glNamedProgramLocalParameters4fvEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETERSI4IVEXTPROC epoxy_glNamedProgramLocalParametersI4ivEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETERSI4UIVEXTPROC epoxy_glNamedProgramLocalParametersI4uivEXT;
    PFNGLNAMEDPROGRAMSTRINGEXTPROC epoxy_glNamedProgramStringEXT;
    PFNGLNAMEDRENDERBUFFERSTORAGEPROC epoxy_glNamedRenderbufferStorage;
    PFNGLNAMEDRENDERBUFFERSTORAGEEXTPROC epoxy_glNamedRenderbufferStorageEXT;
    PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEPROC epoxy_glNamedRenderbufferStorageMultisample;
    PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLECOVERAGEEXTPROC epoxy_glNamedRenderbufferStorageMultisampleCoverageEXT;
    PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC epoxy_glNamedRenderbufferStorageMultisampleEXT;
    PFNGLNAMEDSTRINGARBPROC epoxy_glNamedStringARB;
    PFNGLNEWLISTPROC epoxy_glNewList;
    PFNGLNEWOBJECTBUFFERATIPROC epoxy_glNewObjectBufferATI;
    PFNGLNORMAL3BPROC epoxy_glNormal3b;
    PFNGLNORMAL3BVPROC epoxy_glNormal3bv;
    PFNGLNORMAL3DPROC epoxy_glNormal3d;
    PFNGLNORMAL3DVPROC epoxy_glNormal3dv;
    PFNGLNORMAL3FPROC epoxy_glNormal3f;
    PFNGLNORMAL3FVERTEX3FSUNPROC epoxy_glNormal3fVertex3fSUN;
    PFNGLNORMAL3FVERTEX3FVSUNPROC epoxy_glNormal3fVertex3fvSUN;
    PFNGLNORMAL3FVPROC epoxy_glNormal3fv;
    PFNGLNORMAL3HNVPROC epoxy_glNormal3hNV;
    PFNGLNORMAL3HVNVPROC epoxy_glNormal3hvNV;
    PFNGLNORMAL3IPROC epoxy_glNormal3i;
    PFNGLNORMAL3IVPROC epoxy_glNormal3iv;
    PFNGLNORMAL3SPROC epoxy_glNormal3s;
    PFNGLNORMAL3SVPROC epoxy_glNormal3sv;
    PFNGLNORMAL3XPROC epoxy_glNormal3x;
    PFNGLNORMAL3XOESPROC epoxy_glNormal3xOES;
    PFNGLNORMAL3XVOESPROC epoxy_glNormal3xvOES;
    PFNGLNORMALFORMATNVPROC epoxy_glNormalFormatNV;
    PFNGLNORMALP3UIPROC epoxy_glNormalP3ui;
    PFNGLNORMALP3UIVPROC epoxy_glNormalP3uiv;
    PFNGLNORMALPOINTERPROC epoxy_glNormalPointer;
    PFNGLNORMALPOINTEREXTPROC epoxy_glNormalPointerEXT;
    PFNGLNORMALPOINTERLISTIBMPROC epoxy_glNormalPointerListIBM;
    PFNGLNORMALPOINTERVINTELPROC epoxy_glNormalPointervINTEL;
    PFNGLNORMALSTREAM3BATIPROC epoxy_glNormalStream3bATI;
    PFNGLNORMALSTREAM3BVATIPROC epoxy_glNormalStream3bvATI;
    PFNGLNORMALSTREAM3DATIPROC epoxy_glNormalStream3dATI;
    PFNGLNORMALSTREAM3DVATIPROC epoxy_glNormalStream3dvATI;
    PFNGLNORMALSTREAM3FATIPROC epoxy_glNormalStream3fATI;
    PFNGLNORMALSTREAM3FVATIPROC epoxy_glNormalStream3fvATI;
    PFNGLNORMALSTREAM3IATIPROC epoxy_glNormalStream3iATI;
    PFNGLNORMALSTREAM3IVATIPROC epoxy_glNormalStream3ivATI;
    PFNGLNORMALSTREAM3SATIPROC epoxy_glNormalStream3sATI;
    PFNGLNORMALSTREAM3SVATIPROC epoxy_glNormalStream3svATI;
    PFNGLOBJECTLABELPROC epoxy_glObjectLabel;
    PFNGLOBJECTLABELKHRPROC epoxy_glObjectLabelKHR;
    PFNGLOBJECTPTRLABELPROC epoxy_glObjectPtrLabel;
    PFNGLOBJECTPTRLABELKHRPROC epoxy_glObjectPtrLabelKHR;
    PFNGLOBJECTPURGEABLEAPPLEPROC epoxy_glObjectPurgeableAPPLE;
    PFNGLOBJECTUNPURGEABLEAPPLEPROC epoxy_glObjectUnpurgeableAPPLE;
    PFNGLORTHOPROC epoxy_glOrtho;
    PFNGLORTHOFPROC epoxy_glOrthof;
    PFNGLORTHOFOESPROC epoxy_glOrthofOES;
    PFNGLORTHOXPROC epoxy_glOrthox;
    PFNGLORTHOXOESPROC epoxy_glOrthoxOES;
    PFNGLPNTRIANGLESFATIPROC epoxy_glPNTrianglesfATI;
    PFNGLPNTRIANGLESIATIPROC epoxy_glPNTrianglesiATI;
    PFNGLPASSTEXCOORDATIPROC epoxy_glPassTexCoordATI;
    PFNGLPASSTHROUGHPROC epoxy_glPassThrough;
    PFNGLPASSTHROUGHXOESPROC epoxy_glPassThroughxOES;
    PFNGLPATCHPARAMETERFVPROC epoxy_glPatchParameterfv;
    PFNGLPATCHPARAMETERIPROC epoxy_glPatchParameteri;
    PFNGLPATCHPARAMETERIEXTPROC epoxy_glPatchParameteriEXT;
    PFNGLPATCHPARAMETERIOESPROC epoxy_glPatchParameteriOES;
    PFNGLPATHCOLORGENNVPROC epoxy_glPathColorGenNV;
    PFNGLPATHCOMMANDSNVPROC epoxy_glPathCommandsNV;
    PFNGLPATHCOORDSNVPROC epoxy_glPathCoordsNV;
    PFNGLPATHCOVERDEPTHFUNCNVPROC epoxy_glPathCoverDepthFuncNV;
    PFNGLPATHDASHARRAYNVPROC epoxy_glPathDashArrayNV;
    PFNGLPATHFOGGENNVPROC epoxy_glPathFogGenNV;
    PFNGLPATHGLYPHINDEXARRAYNVPROC epoxy_glPathGlyphIndexArrayNV;
    PFNGLPATHGLYPHINDEXRANGENVPROC epoxy_glPathGlyphIndexRangeNV;
    PFNGLPATHGLYPHRANGENVPROC epoxy_glPathGlyphRangeNV;
    PFNGLPATHGLYPHSNVPROC epoxy_glPathGlyphsNV;
    PFNGLPATHMEMORYGLYPHINDEXARRAYNVPROC epoxy_glPathMemoryGlyphIndexArrayNV;
    PFNGLPATHPARAMETERFNVPROC epoxy_glPathParameterfNV;
    PFNGLPATHPARAMETERFVNVPROC epoxy_glPathParameterfvNV;
    PFNGLPATHPARAMETERINVPROC epoxy_glPathParameteriNV;
    PFNGLPATHPARAMETERIVNVPROC epoxy_glPathParameterivNV;
    PFNGLPATHSTENCILDEPTHOFFSETNVPROC epoxy_glPathStencilDepthOffsetNV;
    PFNGLPATHSTENCILFUNCNVPROC epoxy_glPathStencilFuncNV;
    PFNGLPATHSTRINGNVPROC epoxy_glPathStringNV;
    PFNGLPATHSUBCOMMANDSNVPROC epoxy_glPathSubCommandsNV;
    PFNGLPATHSUBCOORDSNVPROC epoxy_glPathSubCoordsNV;
    PFNGLPATHTEXGENNVPROC epoxy_glPathTexGenNV;
    PFNGLPAUSETRANSFORMFEEDBACKPROC epoxy_glPauseTransformFeedback;
    PFNGLPAUSETRANSFORMFEEDBACKNVPROC epoxy_glPauseTransformFeedbackNV;
    PFNGLPIXELDATARANGENVPROC epoxy_glPixelDataRangeNV;
    PFNGLPIXELMAPFVPROC epoxy_glPixelMapfv;
    PFNGLPIXELMAPUIVPROC epoxy_glPixelMapuiv;
    PFNGLPIXELMAPUSVPROC epoxy_glPixelMapusv;
    PFNGLPIXELMAPXPROC epoxy_glPixelMapx;
    PFNGLPIXELSTOREFPROC epoxy_glPixelStoref;
    PFNGLPIXELSTOREIPROC epoxy_glPixelStorei;
    PFNGLPIXELSTOREXPROC epoxy_glPixelStorex;
    PFNGLPIXELTEXGENPARAMETERFSGISPROC epoxy_glPixelTexGenParameterfSGIS;
    PFNGLPIXELTEXGENPARAMETERFVSGISPROC epoxy_glPixelTexGenParameterfvSGIS;
    PFNGLPIXELTEXGENPARAMETERISGISPROC epoxy_glPixelTexGenParameteriSGIS;
    PFNGLPIXELTEXGENPARAMETERIVSGISPROC epoxy_glPixelTexGenParameterivSGIS;
    PFNGLPIXELTEXGENSGIXPROC epoxy_glPixelTexGenSGIX;
    PFNGLPIXELTRANSFERFPROC epoxy_glPixelTransferf;
    PFNGLPIXELTRANSFERIPROC epoxy_glPixelTransferi;
    PFNGLPIXELTRANSFERXOESPROC epoxy_glPixelTransferxOES;
    PFNGLPIXELTRANSFORMPARAMETERFEXTPROC epoxy_glPixelTransformParameterfEXT;
    PFNGLPIXELTRANSFORMPARAMETERFVEXTPROC epoxy_glPixelTransformParameterfvEXT;
    PFNGLPIXELTRANSFORMPARAMETERIEXTPROC epoxy_glPixelTransformParameteriEXT;
    PFNGLPIXELTRANSFORMPARAMETERIVEXTPROC epoxy_glPixelTransformParameterivEXT;
    PFNGLPIXELZOOMPROC epoxy_glPixelZoom;
    PFNGLPIXELZOOMXOESPROC epoxy_glPixelZoomxOES;
    PFNGLPOINTALONGPATHNVPROC epoxy_glPointAlongPathNV;
    PFNGLPOINTPARAMETERFPROC epoxy_glPointParameterf;
    PFNGLPOINTPARAMETERFARBPROC epoxy_glPointParameterfARB;
    PFNGLPOINTPARAMETERFEXTPROC epoxy_glPointParameterfEXT;
    PFNGLPOINTPARAMETERFSGISPROC epoxy_glPointParameterfSGIS;
    PFNGLPOINTPARAMETERFVPROC epoxy_glPointParameterfv;
    PFNGLPOINTPARAMETERFVARBPROC epoxy_glPointParameterfvARB;
    PFNGLPOINTPARAMETERFVEXTPROC epoxy_glPointParameterfvEXT;
    PFNGLPOINTPARAMETERFVSGISPROC epoxy_glPointParameterfvSGIS;
    PFNGLPOINTPARAMETERIPROC epoxy_glPointParameteri;
    PFNGLPOINTPARAMETERINVPROC epoxy_glPointParameteriNV;
    PFNGLPOINTPARAMETERIVPROC epoxy_glPointParameteriv;
    PFNGLPOINTPARAMETERIVNVPROC epoxy_glPointParameterivNV;
    PFNGLPOINTPARAMETERXPROC epoxy_glPointParameterx;
    PFNGLPOINTPARAMETERXOESPROC epoxy_glPointParameterxOES;
    PFNGLPOINTPARAMETERXVPROC epoxy_glPointParameterxv;
    PFNGLPOINTPARAMETERXVOESPROC epoxy_glPointParameterxvOES;
    PFNGLPOINTSIZEPROC epoxy_glPointSize;
    PFNGLPOINTSIZEPOINTEROESPROC epoxy_glPointSizePointerOES;
    PFNGLPOINTSIZEXPROC epoxy_glPointSizex;
    PFNGLPOINTSIZEXOESPROC epoxy_glPointSizexOES;
    PFNGLPOLLASYNCSGIXPROC epoxy_glPollAsyncSGIX;
    PFNGLPOLLINSTRUMENTSSGIXPROC epoxy_glPollInstrumentsSGIX;
    PFNGLPOLYGONMODEPROC epoxy_glPolygonMode;
    PFNGLPOLYGONMODENVPROC epoxy_glPolygonModeNV;
    PFNGLPOLYGONOFFSETPROC epoxy_glPolygonOffset;
    PFNGLPOLYGONOFFSETCLAMPEXTPROC epoxy_glPolygonOffsetClampEXT;
    PFNGLPOLYGONOFFSETEXTPROC epoxy_glPolygonOffsetEXT;
    PFNGLPOLYGONOFFSETXPROC epoxy_glPolygonOffsetx;
    PFNGLPOLYGONOFFSETXOESPROC epoxy_glPolygonOffsetxOES;
    PFNGLPOLYGONSTIPPLEPROC epoxy_glPolygonStipple;
    PFNGLPOPATTRIBPROC epoxy_glPopAttrib;
    PFNGLPOPCLIENTATTRIBPROC epoxy_glPopClientAttrib;
    PFNGLPOPDEBUGGROUPPROC epoxy_glPopDebugGroup;
    PFNGLPOPDEBUGGROUPKHRPROC epoxy_glPopDebugGroupKHR;
    PFNGLPOPGROUPMARKEREXTPROC epoxy_glPopGroupMarkerEXT;
    PFNGLPOPMATRIXPROC epoxy_glPopMatrix;
    PFNGLPOPNAMEPROC epoxy_glPopName;
    PFNGLPRESENTFRAMEDUALFILLNVPROC epoxy_glPresentFrameDualFillNV;
    PFNGLPRESENTFRAMEKEYEDNVPROC epoxy_glPresentFrameKeyedNV;
    PFNGLPRIMITIVEBOUNDINGBOXEXTPROC epoxy_glPrimitiveBoundingBoxEXT;
    PFNGLPRIMITIVEBOUNDINGBOXOESPROC epoxy_glPrimitiveBoundingBoxOES;
    PFNGLPRIMITIVERESTARTINDEXPROC epoxy_glPrimitiveRestartIndex;
    PFNGLPRIMITIVERESTARTINDEXNVPROC epoxy_glPrimitiveRestartIndexNV;
    PFNGLPRIMITIVERESTARTNVPROC epoxy_glPrimitiveRestartNV;
    PFNGLPRIORITIZETEXTURESPROC epoxy_glPrioritizeTextures;
    PFNGLPRIORITIZETEXTURESEXTPROC epoxy_glPrioritizeTexturesEXT;
    PFNGLPRIORITIZETEXTURESXOESPROC epoxy_glPrioritizeTexturesxOES;
    PFNGLPROGRAMBINARYPROC epoxy_glProgramBinary;
    PFNGLPROGRAMBINARYOESPROC epoxy_glProgramBinaryOES;
    PFNGLPROGRAMBUFFERPARAMETERSIIVNVPROC epoxy_glProgramBufferParametersIivNV;
    PFNGLPROGRAMBUFFERPARAMETERSIUIVNVPROC epoxy_glProgramBufferParametersIuivNV;
    PFNGLPROGRAMBUFFERPARAMETERSFVNVPROC epoxy_glProgramBufferParametersfvNV;
    PFNGLPROGRAMENVPARAMETER4DARBPROC epoxy_glProgramEnvParameter4dARB;
    PFNGLPROGRAMENVPARAMETER4DVARBPROC epoxy_glProgramEnvParameter4dvARB;
    PFNGLPROGRAMENVPARAMETER4FARBPROC epoxy_glProgramEnvParameter4fARB;
    PFNGLPROGRAMENVPARAMETER4FVARBPROC epoxy_glProgramEnvParameter4fvARB;
    PFNGLPROGRAMENVPARAMETERI4INVPROC epoxy_glProgramEnvParameterI4iNV;
    PFNGLPROGRAMENVPARAMETERI4IVNVPROC epoxy_glProgramEnvParameterI4ivNV;
    PFNGLPROGRAMENVPARAMETERI4UINVPROC epoxy_glProgramEnvParameterI4uiNV;
    PFNGLPROGRAMENVPARAMETERI4UIVNVPROC epoxy_glProgramEnvParameterI4uivNV;
    PFNGLPROGRAMENVPARAMETERS4FVEXTPROC epoxy_glProgramEnvParameters4fvEXT;
    PFNGLPROGRAMENVPARAMETERSI4IVNVPROC epoxy_glProgramEnvParametersI4ivNV;
    PFNGLPROGRAMENVPARAMETERSI4UIVNVPROC epoxy_glProgramEnvParametersI4uivNV;
    PFNGLPROGRAMLOCALPARAMETER4DARBPROC epoxy_glProgramLocalParameter4dARB;
    PFNGLPROGRAMLOCALPARAMETER4DVARBPROC epoxy_glProgramLocalParameter4dvARB;
    PFNGLPROGRAMLOCALPARAMETER4FARBPROC epoxy_glProgramLocalParameter4fARB;
    PFNGLPROGRAMLOCALPARAMETER4FVARBPROC epoxy_glProgramLocalParameter4fvARB;
    PFNGLPROGRAMLOCALPARAMETERI4INVPROC epoxy_glProgramLocalParameterI4iNV;
    PFNGLPROGRAMLOCALPARAMETERI4IVNVPROC epoxy_glProgramLocalParameterI4ivNV;
    PFNGLPROGRAMLOCALPARAMETERI4UINVPROC epoxy_glProgramLocalParameterI4uiNV;
    PFNGLPROGRAMLOCALPARAMETERI4UIVNVPROC epoxy_glProgramLocalParameterI4uivNV;
    PFNGLPROGRAMLOCALPARAMETERS4FVEXTPROC epoxy_glProgramLocalParameters4fvEXT;
    PFNGLPROGRAMLOCALPARAMETERSI4IVNVPROC epoxy_glProgramLocalParametersI4ivNV;
    PFNGLPROGRAMLOCALPARAMETERSI4UIVNVPROC epoxy_glProgramLocalParametersI4uivNV;
    PFNGLPROGRAMNAMEDPARAMETER4DNVPROC epoxy_glProgramNamedParameter4dNV;
    PFNGLPROGRAMNAMEDPARAMETER4DVNVPROC epoxy_glProgramNamedParameter4dvNV;
    PFNGLPROGRAMNAMEDPARAMETER4FNVPROC epoxy_glProgramNamedParameter4fNV;
    PFNGLPROGRAMNAMEDPARAMETER4FVNVPROC epoxy_glProgramNamedParameter4fvNV;
    PFNGLPROGRAMPARAMETER4DNVPROC epoxy_glProgramParameter4dNV;
    PFNGLPROGRAMPARAMETER4DVNVPROC epoxy_glProgramParameter4dvNV;
    PFNGLPROGRAMPARAMETER4FNVPROC epoxy_glProgramParameter4fNV;
    PFNGLPROGRAMPARAMETER4FVNVPROC epoxy_glProgramParameter4fvNV;
    PFNGLPROGRAMPARAMETERIPROC epoxy_glProgramParameteri;
    PFNGLPROGRAMPARAMETERIARBPROC epoxy_glProgramParameteriARB;
    PFNGLPROGRAMPARAMETERIEXTPROC epoxy_glProgramParameteriEXT;
    PFNGLPROGRAMPARAMETERS4DVNVPROC epoxy_glProgramParameters4dvNV;
    PFNGLPROGRAMPARAMETERS4FVNVPROC epoxy_glProgramParameters4fvNV;
    PFNGLPROGRAMPATHFRAGMENTINPUTGENNVPROC epoxy_glProgramPathFragmentInputGenNV;
    PFNGLPROGRAMSTRINGARBPROC epoxy_glProgramStringARB;
    PFNGLPROGRAMSUBROUTINEPARAMETERSUIVNVPROC epoxy_glProgramSubroutineParametersuivNV;
    PFNGLPROGRAMUNIFORM1DPROC epoxy_glProgramUniform1d;
    PFNGLPROGRAMUNIFORM1DEXTPROC epoxy_glProgramUniform1dEXT;
    PFNGLPROGRAMUNIFORM1DVPROC epoxy_glProgramUniform1dv;
    PFNGLPROGRAMUNIFORM1DVEXTPROC epoxy_glProgramUniform1dvEXT;
    PFNGLPROGRAMUNIFORM1FPROC epoxy_glProgramUniform1f;
    PFNGLPROGRAMUNIFORM1FEXTPROC epoxy_glProgramUniform1fEXT;
    PFNGLPROGRAMUNIFORM1FVPROC epoxy_glProgramUniform1fv;
    PFNGLPROGRAMUNIFORM1FVEXTPROC epoxy_glProgramUniform1fvEXT;
    PFNGLPROGRAMUNIFORM1IPROC epoxy_glProgramUniform1i;
    PFNGLPROGRAMUNIFORM1I64NVPROC epoxy_glProgramUniform1i64NV;
    PFNGLPROGRAMUNIFORM1I64VNVPROC epoxy_glProgramUniform1i64vNV;
    PFNGLPROGRAMUNIFORM1IEXTPROC epoxy_glProgramUniform1iEXT;
    PFNGLPROGRAMUNIFORM1IVPROC epoxy_glProgramUniform1iv;
    PFNGLPROGRAMUNIFORM1IVEXTPROC epoxy_glProgramUniform1ivEXT;
    PFNGLPROGRAMUNIFORM1UIPROC epoxy_glProgramUniform1ui;
    PFNGLPROGRAMUNIFORM1UI64NVPROC epoxy_glProgramUniform1ui64NV;
    PFNGLPROGRAMUNIFORM1UI64VNVPROC epoxy_glProgramUniform1ui64vNV;
    PFNGLPROGRAMUNIFORM1UIEXTPROC epoxy_glProgramUniform1uiEXT;
    PFNGLPROGRAMUNIFORM1UIVPROC epoxy_glProgramUniform1uiv;
    PFNGLPROGRAMUNIFORM1UIVEXTPROC epoxy_glProgramUniform1uivEXT;
    PFNGLPROGRAMUNIFORM2DPROC epoxy_glProgramUniform2d;
    PFNGLPROGRAMUNIFORM2DEXTPROC epoxy_glProgramUniform2dEXT;
    PFNGLPROGRAMUNIFORM2DVPROC epoxy_glProgramUniform2dv;
    PFNGLPROGRAMUNIFORM2DVEXTPROC epoxy_glProgramUniform2dvEXT;
    PFNGLPROGRAMUNIFORM2FPROC epoxy_glProgramUniform2f;
    PFNGLPROGRAMUNIFORM2FEXTPROC epoxy_glProgramUniform2fEXT;
    PFNGLPROGRAMUNIFORM2FVPROC epoxy_glProgramUniform2fv;
    PFNGLPROGRAMUNIFORM2FVEXTPROC epoxy_glProgramUniform2fvEXT;
    PFNGLPROGRAMUNIFORM2IPROC epoxy_glProgramUniform2i;
    PFNGLPROGRAMUNIFORM2I64NVPROC epoxy_glProgramUniform2i64NV;
    PFNGLPROGRAMUNIFORM2I64VNVPROC epoxy_glProgramUniform2i64vNV;
    PFNGLPROGRAMUNIFORM2IEXTPROC epoxy_glProgramUniform2iEXT;
    PFNGLPROGRAMUNIFORM2IVPROC epoxy_glProgramUniform2iv;
    PFNGLPROGRAMUNIFORM2IVEXTPROC epoxy_glProgramUniform2ivEXT;
    PFNGLPROGRAMUNIFORM2UIPROC epoxy_glProgramUniform2ui;
    PFNGLPROGRAMUNIFORM2UI64NVPROC epoxy_glProgramUniform2ui64NV;
    PFNGLPROGRAMUNIFORM2UI64VNVPROC epoxy_glProgramUniform2ui64vNV;
    PFNGLPROGRAMUNIFORM2UIEXTPROC epoxy_glProgramUniform2uiEXT;
    PFNGLPROGRAMUNIFORM2UIVPROC epoxy_glProgramUniform2uiv;
    PFNGLPROGRAMUNIFORM2UIVEXTPROC epoxy_glProgramUniform2uivEXT;
    PFNGLPROGRAMUNIFORM3DPROC epoxy_glProgramUniform3d;
    PFNGLPROGRAMUNIFORM3DEXTPROC epoxy_glProgramUniform3dEXT;
    PFNGLPROGRAMUNIFORM3DVPROC epoxy_glProgramUniform3dv;
    PFNGLPROGRAMUNIFORM3DVEXTPROC epoxy_glProgramUniform3dvEXT;
    PFNGLPROGRAMUNIFORM3FPROC epoxy_glProgramUniform3f;
    PFNGLPROGRAMUNIFORM3FEXTPROC epoxy_glProgramUniform3fEXT;
    PFNGLPROGRAMUNIFORM3FVPROC epoxy_glProgramUniform3fv;
    PFNGLPROGRAMUNIFORM3FVEXTPROC epoxy_glProgramUniform3fvEXT;
    PFNGLPROGRAMUNIFORM3IPROC epoxy_glProgramUniform3i;
    PFNGLPROGRAMUNIFORM3I64NVPROC epoxy_glProgramUniform3i64NV;
    PFNGLPROGRAMUNIFORM3I64VNVPROC epoxy_glProgramUniform3i64vNV;
    PFNGLPROGRAMUNIFORM3IEXTPROC epoxy_glProgramUniform3iEXT;
    PFNGLPROGRAMUNIFORM3IVPROC epoxy_glProgramUniform3iv;
    PFNGLPROGRAMUNIFORM3IVEXTPROC epoxy_glProgramUniform3ivEXT;
    PFNGLPROGRAMUNIFORM3UIPROC epoxy_glProgramUniform3ui;
    PFNGLPROGRAMUNIFORM3UI64NVPROC epoxy_glProgramUniform3ui64NV;
    PFNGLPROGRAMUNIFORM3UI64VNVPROC epoxy_glProgramUniform3ui64vNV;
    PFNGLPROGRAMUNIFORM3UIEXTPROC epoxy_glProgramUniform3uiEXT;
    PFNGLPROGRAMUNIFORM3UIVPROC epoxy_glProgramUniform3uiv;
    PFNGLPROGRAMUNIFORM3UIVEXTPROC epoxy_glProgramUniform3uivEXT;
    PFNGLPROGRAMUNIFORM4DPROC epoxy_glProgramUniform4d;
    PFNGLPROGRAMUNIFORM4DEXTPROC epoxy_glProgramUniform4dEXT;
    PFNGLPROGRAMUNIFORM4DVPROC epoxy_glProgramUniform4dv;
    PFNGLPROGRAMUNIFORM4DVEXTPROC epoxy_glProgramUniform4dvEXT;
    PFNGLPROGRAMUNIFORM4FPROC epoxy_glProgramUniform4f;
    PFNGLPROGRAMUNIFORM4FEXTPROC epoxy_glProgramUniform4fEXT;
    PFNGLPROGRAMUNIFORM4FVPROC epoxy_glProgramUniform4fv;
    PFNGLPROGRAMUNIFORM4FVEXTPROC epoxy_glProgramUniform4fvEXT;
    PFNGLPROGRAMUNIFORM4IPROC epoxy_glProgramUniform4i;
    PFNGLPROGRAMUNIFORM4I64NVPROC epoxy_glProgramUniform4i64NV;
    PFNGLPROGRAMUNIFORM4I64VNVPROC epoxy_glProgramUniform4i64vNV;
    PFNGLPROGRAMUNIFORM4IEXTPROC epoxy_glProgramUniform4iEXT;
    PFNGLPROGRAMUNIFORM4IVPROC epoxy_glProgramUniform4iv;
    PFNGLPROGRAMUNIFORM4IVEXTPROC epoxy_glProgramUniform4ivEXT;
    PFNGLPROGRAMUNIFORM4UIPROC epoxy_glProgramUniform4ui;
    PFNGLPROGRAMUNIFORM4UI64NVPROC epoxy_glProgramUniform4ui64NV;
    PFNGLPROGRAMUNIFORM4UI64VNVPROC epoxy_glProgramUniform4ui64vNV;
    PFNGLPROGRAMUNIFORM4UIEXTPROC epoxy_glProgramUniform4uiEXT;
    PFNGLPROGRAMUNIFORM4UIVPROC epoxy_glProgramUniform4uiv;
    PFNGLPROGRAMUNIFORM4UIVEXTPROC epoxy_glProgramUniform4uivEXT;
    PFNGLPROGRAMUNIFORMHANDLEUI64ARBPROC epoxy_glProgramUniformHandleui64ARB;
    PFNGLPROGRAMUNIFORMHANDLEUI64NVPROC epoxy_glProgramUniformHandleui64NV;
    PFNGLPROGRAMUNIFORMHANDLEUI64VARBPROC epoxy_glProgramUniformHandleui64vARB;
    PFNGLPROGRAMUNIFORMHANDLEUI64VNVPROC epoxy_glProgramUniformHandleui64vNV;
    PFNGLPROGRAMUNIFORMMATRIX2DVPROC epoxy_glProgramUniformMatrix2dv;
    PFNGLPROGRAMUNIFORMMATRIX2DVEXTPROC epoxy_glProgramUniformMatrix2dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX2FVPROC epoxy_glProgramUniformMatrix2fv;
    PFNGLPROGRAMUNIFORMMATRIX2FVEXTPROC epoxy_glProgramUniformMatrix2fvEXT;
    PFNGLPROGRAMUNIFORMMATRIX2X3DVPROC epoxy_glProgramUniformMatrix2x3dv;
    PFNGLPROGRAMUNIFORMMATRIX2X3DVEXTPROC epoxy_glProgramUniformMatrix2x3dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX2X3FVPROC epoxy_glProgramUniformMatrix2x3fv;
    PFNGLPROGRAMUNIFORMMATRIX2X3FVEXTPROC epoxy_glProgramUniformMatrix2x3fvEXT;
    PFNGLPROGRAMUNIFORMMATRIX2X4DVPROC epoxy_glProgramUniformMatrix2x4dv;
    PFNGLPROGRAMUNIFORMMATRIX2X4DVEXTPROC epoxy_glProgramUniformMatrix2x4dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX2X4FVPROC epoxy_glProgramUniformMatrix2x4fv;
    PFNGLPROGRAMUNIFORMMATRIX2X4FVEXTPROC epoxy_glProgramUniformMatrix2x4fvEXT;
    PFNGLPROGRAMUNIFORMMATRIX3DVPROC epoxy_glProgramUniformMatrix3dv;
    PFNGLPROGRAMUNIFORMMATRIX3DVEXTPROC epoxy_glProgramUniformMatrix3dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX3FVPROC epoxy_glProgramUniformMatrix3fv;
    PFNGLPROGRAMUNIFORMMATRIX3FVEXTPROC epoxy_glProgramUniformMatrix3fvEXT;
    PFNGLPROGRAMUNIFORMMATRIX3X2DVPROC epoxy_glProgramUniformMatrix3x2dv;
    PFNGLPROGRAMUNIFORMMATRIX3X2DVEXTPROC epoxy_glProgramUniformMatrix3x2dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX3X2FVPROC epoxy_glProgramUniformMatrix3x2fv;
    PFNGLPROGRAMUNIFORMMATRIX3X2FVEXTPROC epoxy_glProgramUniformMatrix3x2fvEXT;
    PFNGLPROGRAMUNIFORMMATRIX3X4DVPROC epoxy_glProgramUniformMatrix3x4dv;
    PFNGLPROGRAMUNIFORMMATRIX3X4DVEXTPROC epoxy_glProgramUniformMatrix3x4dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX3X4FVPROC epoxy_glProgramUniformMatrix3x4fv;
    PFNGLPROGRAMUNIFORMMATRIX3X4FVEXTPROC epoxy_glProgramUniformMatrix3x4fvEXT;
    PFNGLPROGRAMUNIFORMMATRIX4DVPROC epoxy_glProgramUniformMatrix4dv;
    PFNGLPROGRAMUNIFORMMATRIX4DVEXTPROC epoxy_glProgramUniformMatrix4dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX4FVPROC epoxy_glProgramUniformMatrix4fv;
    PFNGLPROGRAMUNIFORMMATRIX4FVEXTPROC epoxy_glProgramUniformMatrix4fvEXT;
    PFNGLPROGRAMUNIFORMMATRIX4X2DVPROC epoxy_glProgramUniformMatrix4x2dv;
    PFNGLPROGRAMUNIFORMMATRIX4X2DVEXTPROC epoxy_glProgramUniformMatrix4x2dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX4X2FVPROC epoxy_glProgramUniformMatrix4x2fv;
    PFNGLPROGRAMUNIFORMMATRIX4X2FVEXTPROC epoxy_glProgramUniformMatrix4x2fvEXT;
    PFNGLPROGRAMUNIFORMMATRIX4X3DVPROC epoxy_glProgramUniformMatrix4x3dv;
    PFNGLPROGRAMUNIFORMMATRIX4X3DVEXTPROC epoxy_glProgramUniformMatrix4x3dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX4X3FVPROC epoxy_glProgramUniformMatrix4x3fv;
    PFNGLPROGRAMUNIFORMMATRIX4X3FVEXTPROC epoxy_glProgramUniformMatrix4x3fvEXT;
    PFNGLPROGRAMUNIFORMUI64NVPROC epoxy_glProgramUniformui64NV;
    PFNGLPROGRAMUNIFORMUI64VNVPROC epoxy_glProgramUniformui64vNV;
    PFNGLPROGRAMVERTEXLIMITNVPROC epoxy_glProgramVertexLimitNV;
    PFNGLPROVOKINGVERTEXPROC epoxy_glProvokingVertex;
    PFNGLPROVOKINGVERTEXEXTPROC epoxy_glProvokingVertexEXT;
    PFNGLPUSHATTRIBPROC epoxy_glPushAttrib;
    PFNGLPUSHCLIENTATTRIBPROC epoxy_glPushClientAttrib;
    PFNGLPUSHCLIENTATTRIBDEFAULTEXTPROC epoxy_glPushClientAttribDefaultEXT;
    PFNGLPUSHDEBUGGROUPPROC epoxy_glPushDebugGroup;
    PFNGLPUSHDEBUGGROUPKHRPROC epoxy_glPushDebugGroupKHR;
    PFNGLPUSHGROUPMARKEREXTPROC epoxy_glPushGroupMarkerEXT;
    PFNGLPUSHMATRIXPROC epoxy_glPushMatrix;
    PFNGLPUSHNAMEPROC epoxy_glPushName;
    PFNGLQUERYCOUNTERPROC epoxy_glQueryCounter;
    PFNGLQUERYCOUNTEREXTPROC epoxy_glQueryCounterEXT;
    PFNGLQUERYMATRIXXOESPROC epoxy_glQueryMatrixxOES;
    PFNGLQUERYOBJECTPARAMETERUIAMDPROC epoxy_glQueryObjectParameteruiAMD;
    PFNGLRASTERPOS2DPROC epoxy_glRasterPos2d;
    PFNGLRASTERPOS2DVPROC epoxy_glRasterPos2dv;
    PFNGLRASTERPOS2FPROC epoxy_glRasterPos2f;
    PFNGLRASTERPOS2FVPROC epoxy_glRasterPos2fv;
    PFNGLRASTERPOS2IPROC epoxy_glRasterPos2i;
    PFNGLRASTERPOS2IVPROC epoxy_glRasterPos2iv;
    PFNGLRASTERPOS2SPROC epoxy_glRasterPos2s;
    PFNGLRASTERPOS2SVPROC epoxy_glRasterPos2sv;
    PFNGLRASTERPOS2XOESPROC epoxy_glRasterPos2xOES;
    PFNGLRASTERPOS2XVOESPROC epoxy_glRasterPos2xvOES;
    PFNGLRASTERPOS3DPROC epoxy_glRasterPos3d;
    PFNGLRASTERPOS3DVPROC epoxy_glRasterPos3dv;
    PFNGLRASTERPOS3FPROC epoxy_glRasterPos3f;
    PFNGLRASTERPOS3FVPROC epoxy_glRasterPos3fv;
    PFNGLRASTERPOS3IPROC epoxy_glRasterPos3i;
    PFNGLRASTERPOS3IVPROC epoxy_glRasterPos3iv;
    PFNGLRASTERPOS3SPROC epoxy_glRasterPos3s;
    PFNGLRASTERPOS3SVPROC epoxy_glRasterPos3sv;
    PFNGLRASTERPOS3XOESPROC epoxy_glRasterPos3xOES;
    PFNGLRASTERPOS3XVOESPROC epoxy_glRasterPos3xvOES;
    PFNGLRASTERPOS4DPROC epoxy_glRasterPos4d;
    PFNGLRASTERPOS4DVPROC epoxy_glRasterPos4dv;
    PFNGLRASTERPOS4FPROC epoxy_glRasterPos4f;
    PFNGLRASTERPOS4FVPROC epoxy_glRasterPos4fv;
    PFNGLRASTERPOS4IPROC epoxy_glRasterPos4i;
    PFNGLRASTERPOS4IVPROC epoxy_glRasterPos4iv;
    PFNGLRASTERPOS4SPROC epoxy_glRasterPos4s;
    PFNGLRASTERPOS4SVPROC epoxy_glRasterPos4sv;
    PFNGLRASTERPOS4XOESPROC epoxy_glRasterPos4xOES;
    PFNGLRASTERPOS4XVOESPROC epoxy_glRasterPos4xvOES;
    PFNGLRASTERSAMPLESEXTPROC epoxy_glRasterSamplesEXT;
    PFNGLREADBUFFERPROC epoxy_glReadBuffer;
    PFNGLREADBUFFERINDEXEDEXTPROC epoxy_glReadBufferIndexedEXT;
    PFNGLREADBUFFERNVPROC epoxy_glReadBufferNV;
    PFNGLREADINSTRUMENTSSGIXPROC epoxy_glReadInstrumentsSGIX;
    PFNGLREADPIXELSPROC epoxy_glReadPixels;
    PFNGLREADNPIXELSPROC epoxy_glReadnPixels;
    PFNGLREADNPIXELSARBPROC epoxy_glReadnPixelsARB;
    PFNGLREADNPIXELSEXTPROC epoxy_glReadnPixelsEXT;
    PFNGLREADNPIXELSKHRPROC epoxy_glReadnPixelsKHR;
    PFNGLRECTDPROC epoxy_glRectd;
    PFNGLRECTDVPROC epoxy_glRectdv;
    PFNGLRECTFPROC epoxy_glRectf;
    PFNGLRECTFVPROC epoxy_glRectfv;
    PFNGLRECTIPROC epoxy_glRecti;
    PFNGLRECTIVPROC epoxy_glRectiv;
    PFNGLRECTSPROC epoxy_glRects;
    PFNGLRECTSVPROC epoxy_glRectsv;
    PFNGLRECTXOESPROC epoxy_glRectxOES;
    PFNGLRECTXVOESPROC epoxy_glRectxvOES;
    PFNGLREFERENCEPLANESGIXPROC epoxy_glReferencePlaneSGIX;
    PFNGLRELEASESHADERCOMPILERPROC epoxy_glReleaseShaderCompiler;
    PFNGLRENDERMODEPROC epoxy_glRenderMode;
    PFNGLRENDERBUFFERSTORAGEPROC epoxy_glRenderbufferStorage;
    PFNGLRENDERBUFFERSTORAGEEXTPROC epoxy_glRenderbufferStorageEXT;
    PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC epoxy_glRenderbufferStorageMultisample;
    PFNGLRENDERBUFFERSTORAGEMULTISAMPLEANGLEPROC epoxy_glRenderbufferStorageMultisampleANGLE;
    PFNGLRENDERBUFFERSTORAGEMULTISAMPLEAPPLEPROC epoxy_glRenderbufferStorageMultisampleAPPLE;
    PFNGLRENDERBUFFERSTORAGEMULTISAMPLECOVERAGENVPROC epoxy_glRenderbufferStorageMultisampleCoverageNV;
    PFNGLRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC epoxy_glRenderbufferStorageMultisampleEXT;
    PFNGLRENDERBUFFERSTORAGEMULTISAMPLEIMGPROC epoxy_glRenderbufferStorageMultisampleIMG;
    PFNGLRENDERBUFFERSTORAGEMULTISAMPLENVPROC epoxy_glRenderbufferStorageMultisampleNV;
    PFNGLRENDERBUFFERSTORAGEOESPROC epoxy_glRenderbufferStorageOES;
    PFNGLREPLACEMENTCODEPOINTERSUNPROC epoxy_glReplacementCodePointerSUN;
    PFNGLREPLACEMENTCODEUBSUNPROC epoxy_glReplacementCodeubSUN;
    PFNGLREPLACEMENTCODEUBVSUNPROC epoxy_glReplacementCodeubvSUN;
    PFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FSUNPROC epoxy_glReplacementCodeuiColor3fVertex3fSUN;
    PFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUNPROC epoxy_glReplacementCodeuiColor3fVertex3fvSUN;
    PFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUNPROC epoxy_glReplacementCodeuiColor4fNormal3fVertex3fSUN;
    PFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUNPROC epoxy_glReplacementCodeuiColor4fNormal3fVertex3fvSUN;
    PFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUNPROC epoxy_glReplacementCodeuiColor4ubVertex3fSUN;
    PFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUNPROC epoxy_glReplacementCodeuiColor4ubVertex3fvSUN;
    PFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FSUNPROC epoxy_glReplacementCodeuiNormal3fVertex3fSUN;
    PFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUNPROC epoxy_glReplacementCodeuiNormal3fVertex3fvSUN;
    PFNGLREPLACEMENTCODEUISUNPROC epoxy_glReplacementCodeuiSUN;
    PFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC epoxy_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN;
    PFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC epoxy_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN;
    PFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUNPROC epoxy_glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN;
    PFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUNPROC epoxy_glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN;
    PFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUNPROC epoxy_glReplacementCodeuiTexCoord2fVertex3fSUN;
    PFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUNPROC epoxy_glReplacementCodeuiTexCoord2fVertex3fvSUN;
    PFNGLREPLACEMENTCODEUIVERTEX3FSUNPROC epoxy_glReplacementCodeuiVertex3fSUN;
    PFNGLREPLACEMENTCODEUIVERTEX3FVSUNPROC epoxy_glReplacementCodeuiVertex3fvSUN;
    PFNGLREPLACEMENTCODEUIVSUNPROC epoxy_glReplacementCodeuivSUN;
    PFNGLREPLACEMENTCODEUSSUNPROC epoxy_glReplacementCodeusSUN;
    PFNGLREPLACEMENTCODEUSVSUNPROC epoxy_glReplacementCodeusvSUN;
    PFNGLREQUESTRESIDENTPROGRAMSNVPROC epoxy_glRequestResidentProgramsNV;
    PFNGLRESETHISTOGRAMPROC epoxy_glResetHistogram;
    PFNGLRESETHISTOGRAMEXTPROC epoxy_glResetHistogramEXT;
    PFNGLRESETMINMAXPROC epoxy_glResetMinmax;
    PFNGLRESETMINMAXEXTPROC epoxy_glResetMinmaxEXT;
    PFNGLRESIZEBUFFERSMESAPROC epoxy_glResizeBuffersMESA;
    PFNGLRESOLVEDEPTHVALUESNVPROC epoxy_glResolveDepthValuesNV;
    PFNGLRESOLVEMULTISAMPLEFRAMEBUFFERAPPLEPROC epoxy_glResolveMultisampleFramebufferAPPLE;
    PFNGLRESUMETRANSFORMFEEDBACKPROC epoxy_glResumeTransformFeedback;
    PFNGLRESUMETRANSFORMFEEDBACKNVPROC epoxy_glResumeTransformFeedbackNV;
    PFNGLROTATEDPROC epoxy_glRotated;
    PFNGLROTATEFPROC epoxy_glRotatef;
    PFNGLROTATEXPROC epoxy_glRotatex;
    PFNGLROTATEXOESPROC epoxy_glRotatexOES;
    PFNGLSAMPLECOVERAGEPROC epoxy_glSampleCoverage;
    PFNGLSAMPLECOVERAGEARBPROC epoxy_glSampleCoverageARB;
    PFNGLSAMPLECOVERAGEXPROC epoxy_glSampleCoveragex;
    PFNGLSAMPLECOVERAGEXOESPROC epoxy_glSampleCoveragexOES;
    PFNGLSAMPLEMAPATIPROC epoxy_glSampleMapATI;
    PFNGLSAMPLEMASKEXTPROC epoxy_glSampleMaskEXT;
    PFNGLSAMPLEMASKINDEXEDNVPROC epoxy_glSampleMaskIndexedNV;
    PFNGLSAMPLEMASKSGISPROC epoxy_glSampleMaskSGIS;
    PFNGLSAMPLEMASKIPROC epoxy_glSampleMaski;
    PFNGLSAMPLEPATTERNEXTPROC epoxy_glSamplePatternEXT;
    PFNGLSAMPLEPATTERNSGISPROC epoxy_glSamplePatternSGIS;
    PFNGLSAMPLERPARAMETERIIVPROC epoxy_glSamplerParameterIiv;
    PFNGLSAMPLERPARAMETERIIVEXTPROC epoxy_glSamplerParameterIivEXT;
    PFNGLSAMPLERPARAMETERIIVOESPROC epoxy_glSamplerParameterIivOES;
    PFNGLSAMPLERPARAMETERIUIVPROC epoxy_glSamplerParameterIuiv;
    PFNGLSAMPLERPARAMETERIUIVEXTPROC epoxy_glSamplerParameterIuivEXT;
    PFNGLSAMPLERPARAMETERIUIVOESPROC epoxy_glSamplerParameterIuivOES;
    PFNGLSAMPLERPARAMETERFPROC epoxy_glSamplerParameterf;
    PFNGLSAMPLERPARAMETERFVPROC epoxy_glSamplerParameterfv;
    PFNGLSAMPLERPARAMETERIPROC epoxy_glSamplerParameteri;
    PFNGLSAMPLERPARAMETERIVPROC epoxy_glSamplerParameteriv;
    PFNGLSCALEDPROC epoxy_glScaled;
    PFNGLSCALEFPROC epoxy_glScalef;
    PFNGLSCALEXPROC epoxy_glScalex;
    PFNGLSCALEXOESPROC epoxy_glScalexOES;
    PFNGLSCISSORPROC epoxy_glScissor;
    PFNGLSCISSORARRAYVPROC epoxy_glScissorArrayv;
    PFNGLSCISSORARRAYVNVPROC epoxy_glScissorArrayvNV;
    PFNGLSCISSORINDEXEDPROC epoxy_glScissorIndexed;
    PFNGLSCISSORINDEXEDNVPROC epoxy_glScissorIndexedNV;
    PFNGLSCISSORINDEXEDVPROC epoxy_glScissorIndexedv;
    PFNGLSCISSORINDEXEDVNVPROC epoxy_glScissorIndexedvNV;
    PFNGLSECONDARYCOLOR3BPROC epoxy_glSecondaryColor3b;
    PFNGLSECONDARYCOLOR3BEXTPROC epoxy_glSecondaryColor3bEXT;
    PFNGLSECONDARYCOLOR3BVPROC epoxy_glSecondaryColor3bv;
    PFNGLSECONDARYCOLOR3BVEXTPROC epoxy_glSecondaryColor3bvEXT;
    PFNGLSECONDARYCOLOR3DPROC epoxy_glSecondaryColor3d;
    PFNGLSECONDARYCOLOR3DEXTPROC epoxy_glSecondaryColor3dEXT;
    PFNGLSECONDARYCOLOR3DVPROC epoxy_glSecondaryColor3dv;
    PFNGLSECONDARYCOLOR3DVEXTPROC epoxy_glSecondaryColor3dvEXT;
    PFNGLSECONDARYCOLOR3FPROC epoxy_glSecondaryColor3f;
    PFNGLSECONDARYCOLOR3FEXTPROC epoxy_glSecondaryColor3fEXT;
    PFNGLSECONDARYCOLOR3FVPROC epoxy_glSecondaryColor3fv;
    PFNGLSECONDARYCOLOR3FVEXTPROC epoxy_glSecondaryColor3fvEXT;
    PFNGLSECONDARYCOLOR3HNVPROC epoxy_glSecondaryColor3hNV;
    PFNGLSECONDARYCOLOR3HVNVPROC epoxy_glSecondaryColor3hvNV;
    PFNGLSECONDARYCOLOR3IPROC epoxy_glSecondaryColor3i;
    PFNGLSECONDARYCOLOR3IEXTPROC epoxy_glSecondaryColor3iEXT;
    PFNGLSECONDARYCOLOR3IVPROC epoxy_glSecondaryColor3iv;
    PFNGLSECONDARYCOLOR3IVEXTPROC epoxy_glSecondaryColor3ivEXT;
    PFNGLSECONDARYCOLOR3SPROC epoxy_glSecondaryColor3s;
    PFNGLSECONDARYCOLOR3SEXTPROC epoxy_glSecondaryColor3sEXT;
    PFNGLSECONDARYCOLOR3SVPROC epoxy_glSecondaryColor3sv;
    PFNGLSECONDARYCOLOR3SVEXTPROC epoxy_glSecondaryColor3svEXT;
    PFNGLSECONDARYCOLOR3UBPROC epoxy_glSecondaryColor3ub;
    PFNGLSECONDARYCOLOR3UBEXTPROC epoxy_glSecondaryColor3ubEXT;
    PFNGLSECONDARYCOLOR3UBVPROC epoxy_glSecondaryColor3ubv;
    PFNGLSECONDARYCOLOR3UBVEXTPROC epoxy_glSecondaryColor3ubvEXT;
    PFNGLSECONDARYCOLOR3UIPROC epoxy_glSecondaryColor3ui;
    PFNGLSECONDARYCOLOR3UIEXTPROC epoxy_glSecondaryColor3uiEXT;
    PFNGLSECONDARYCOLOR3UIVPROC epoxy_glSecondaryColor3uiv;
    PFNGLSECONDARYCOLOR3UIVEXTPROC epoxy_glSecondaryColor3uivEXT;
    PFNGLSECONDARYCOLOR3USPROC epoxy_glSecondaryColor3us;
    PFNGLSECONDARYCOLOR3USEXTPROC epoxy_glSecondaryColor3usEXT;
    PFNGLSECONDARYCOLOR3USVPROC epoxy_glSecondaryColor3usv;
    PFNGLSECONDARYCOLOR3USVEXTPROC epoxy_glSecondaryColor3usvEXT;
    PFNGLSECONDARYCOLORFORMATNVPROC epoxy_glSecondaryColorFormatNV;
    PFNGLSECONDARYCOLORP3UIPROC epoxy_glSecondaryColorP3ui;
    PFNGLSECONDARYCOLORP3UIVPROC epoxy_glSecondaryColorP3uiv;
    PFNGLSECONDARYCOLORPOINTERPROC epoxy_glSecondaryColorPointer;
    PFNGLSECONDARYCOLORPOINTEREXTPROC epoxy_glSecondaryColorPointerEXT;
    PFNGLSECONDARYCOLORPOINTERLISTIBMPROC epoxy_glSecondaryColorPointerListIBM;
    PFNGLSELECTBUFFERPROC epoxy_glSelectBuffer;
    PFNGLSELECTPERFMONITORCOUNTERSAMDPROC epoxy_glSelectPerfMonitorCountersAMD;
    PFNGLSEPARABLEFILTER2DPROC epoxy_glSeparableFilter2D;
    PFNGLSEPARABLEFILTER2DEXTPROC epoxy_glSeparableFilter2DEXT;
    PFNGLSETFENCEAPPLEPROC epoxy_glSetFenceAPPLE;
    PFNGLSETFENCENVPROC epoxy_glSetFenceNV;
    PFNGLSETFRAGMENTSHADERCONSTANTATIPROC epoxy_glSetFragmentShaderConstantATI;
    PFNGLSETINVARIANTEXTPROC epoxy_glSetInvariantEXT;
    PFNGLSETLOCALCONSTANTEXTPROC epoxy_glSetLocalConstantEXT;
    PFNGLSETMULTISAMPLEFVAMDPROC epoxy_glSetMultisamplefvAMD;
    PFNGLSHADEMODELPROC epoxy_glShadeModel;
    PFNGLSHADERBINARYPROC epoxy_glShaderBinary;
    PFNGLSHADEROP1EXTPROC epoxy_glShaderOp1EXT;
    PFNGLSHADEROP2EXTPROC epoxy_glShaderOp2EXT;
    PFNGLSHADEROP3EXTPROC epoxy_glShaderOp3EXT;
    PFNGLSHADERSOURCEPROC epoxy_glShaderSource;
    PFNGLSHADERSOURCEARBPROC epoxy_glShaderSourceARB;
    PFNGLSHADERSTORAGEBLOCKBINDINGPROC epoxy_glShaderStorageBlockBinding;
    PFNGLSHARPENTEXFUNCSGISPROC epoxy_glSharpenTexFuncSGIS;
    PFNGLSPRITEPARAMETERFSGIXPROC epoxy_glSpriteParameterfSGIX;
    PFNGLSPRITEPARAMETERFVSGIXPROC epoxy_glSpriteParameterfvSGIX;
    PFNGLSPRITEPARAMETERISGIXPROC epoxy_glSpriteParameteriSGIX;
    PFNGLSPRITEPARAMETERIVSGIXPROC epoxy_glSpriteParameterivSGIX;
    PFNGLSTARTINSTRUMENTSSGIXPROC epoxy_glStartInstrumentsSGIX;
    PFNGLSTARTTILINGQCOMPROC epoxy_glStartTilingQCOM;
    PFNGLSTATECAPTURENVPROC epoxy_glStateCaptureNV;
    PFNGLSTENCILCLEARTAGEXTPROC epoxy_glStencilClearTagEXT;
    PFNGLSTENCILFILLPATHINSTANCEDNVPROC epoxy_glStencilFillPathInstancedNV;
    PFNGLSTENCILFILLPATHNVPROC epoxy_glStencilFillPathNV;
    PFNGLSTENCILFUNCPROC epoxy_glStencilFunc;
    PFNGLSTENCILFUNCSEPARATEPROC epoxy_glStencilFuncSeparate;
    PFNGLSTENCILFUNCSEPARATEATIPROC epoxy_glStencilFuncSeparateATI;
    PFNGLSTENCILMASKPROC epoxy_glStencilMask;
    PFNGLSTENCILMASKSEPARATEPROC epoxy_glStencilMaskSeparate;
    PFNGLSTENCILOPPROC epoxy_glStencilOp;
    PFNGLSTENCILOPSEPARATEPROC epoxy_glStencilOpSeparate;
    PFNGLSTENCILOPSEPARATEATIPROC epoxy_glStencilOpSeparateATI;
    PFNGLSTENCILOPVALUEAMDPROC epoxy_glStencilOpValueAMD;
    PFNGLSTENCILSTROKEPATHINSTANCEDNVPROC epoxy_glStencilStrokePathInstancedNV;
    PFNGLSTENCILSTROKEPATHNVPROC epoxy_glStencilStrokePathNV;
    PFNGLSTENCILTHENCOVERFILLPATHINSTANCEDNVPROC epoxy_glStencilThenCoverFillPathInstancedNV;
    PFNGLSTENCILTHENCOVERFILLPATHNVPROC epoxy_glStencilThenCoverFillPathNV;
    PFNGLSTENCILTHENCOVERSTROKEPATHINSTANCEDNVPROC epoxy_glStencilThenCoverStrokePathInstancedNV;
    PFNGLSTENCILTHENCOVERSTROKEPATHNVPROC epoxy_glStencilThenCoverStrokePathNV;
    PFNGLSTOPINSTRUMENTSSGIXPROC epoxy_glStopInstrumentsSGIX;
    PFNGLSTRINGMARKERGREMEDYPROC epoxy_glStringMarkerGREMEDY;
    PFNGLSUBPIXELPRECISIONBIASNVPROC epoxy_glSubpixelPrecisionBiasNV;
    PFNGLSWIZZLEEXTPROC epoxy_glSwizzleEXT;
    PFNGLSYNCTEXTUREINTELPROC epoxy_glSyncTextureINTEL;
    PFNGLTAGSAMPLEBUFFERSGIXPROC epoxy_glTagSampleBufferSGIX;
    PFNGLTANGENT3BEXTPROC epoxy_glTangent3bEXT;
    PFNGLTANGENT3BVEXTPROC epoxy_glTangent3bvEXT;
    PFNGLTANGENT3DEXTPROC epoxy_glTangent3dEXT;
    PFNGLTANGENT3DVEXTPROC epoxy_glTangent3dvEXT;
    PFNGLTANGENT3FEXTPROC epoxy_glTangent3fEXT;
    PFNGLTANGENT3FVEXTPROC epoxy_glTangent3fvEXT;
    PFNGLTANGENT3IEXTPROC epoxy_glTangent3iEXT;
    PFNGLTANGENT3IVEXTPROC epoxy_glTangent3ivEXT;
    PFNGLTANGENT3SEXTPROC epoxy_glTangent3sEXT;
    PFNGLTANGENT3SVEXTPROC epoxy_glTangent3svEXT;
    PFNGLTANGENTPOINTEREXTPROC epoxy_glTangentPointerEXT;
    PFNGLTBUFFERMASK3DFXPROC epoxy_glTbufferMask3DFX;
    PFNGLTESSELLATIONFACTORAMDPROC epoxy_glTessellationFactorAMD;
    PFNGLTESSELLATIONMODEAMDPROC epoxy_glTessellationModeAMD;
    PFNGLTESTFENCEAPPLEPROC epoxy_glTestFenceAPPLE;
    PFNGLTESTFENCENVPROC epoxy_glTestFenceNV;
    PFNGLTESTOBJECTAPPLEPROC epoxy_glTestObjectAPPLE;
    PFNGLTEXBUFFERPROC epoxy_glTexBuffer;
    PFNGLTEXBUFFERARBPROC epoxy_glTexBufferARB;
    PFNGLTEXBUFFEREXTPROC epoxy_glTexBufferEXT;
    PFNGLTEXBUFFEROESPROC epoxy_glTexBufferOES;
    PFNGLTEXBUFFERRANGEPROC epoxy_glTexBufferRange;
    PFNGLTEXBUFFERRANGEEXTPROC epoxy_glTexBufferRangeEXT;
    PFNGLTEXBUFFERRANGEOESPROC epoxy_glTexBufferRangeOES;
    PFNGLTEXBUMPPARAMETERFVATIPROC epoxy_glTexBumpParameterfvATI;
    PFNGLTEXBUMPPARAMETERIVATIPROC epoxy_glTexBumpParameterivATI;
    PFNGLTEXCOORD1BOESPROC epoxy_glTexCoord1bOES;
    PFNGLTEXCOORD1BVOESPROC epoxy_glTexCoord1bvOES;
    PFNGLTEXCOORD1DPROC epoxy_glTexCoord1d;
    PFNGLTEXCOORD1DVPROC epoxy_glTexCoord1dv;
    PFNGLTEXCOORD1FPROC epoxy_glTexCoord1f;
    PFNGLTEXCOORD1FVPROC epoxy_glTexCoord1fv;
    PFNGLTEXCOORD1HNVPROC epoxy_glTexCoord1hNV;
    PFNGLTEXCOORD1HVNVPROC epoxy_glTexCoord1hvNV;
    PFNGLTEXCOORD1IPROC epoxy_glTexCoord1i;
    PFNGLTEXCOORD1IVPROC epoxy_glTexCoord1iv;
    PFNGLTEXCOORD1SPROC epoxy_glTexCoord1s;
    PFNGLTEXCOORD1SVPROC epoxy_glTexCoord1sv;
    PFNGLTEXCOORD1XOESPROC epoxy_glTexCoord1xOES;
    PFNGLTEXCOORD1XVOESPROC epoxy_glTexCoord1xvOES;
    PFNGLTEXCOORD2BOESPROC epoxy_glTexCoord2bOES;
    PFNGLTEXCOORD2BVOESPROC epoxy_glTexCoord2bvOES;
    PFNGLTEXCOORD2DPROC epoxy_glTexCoord2d;
    PFNGLTEXCOORD2DVPROC epoxy_glTexCoord2dv;
    PFNGLTEXCOORD2FPROC epoxy_glTexCoord2f;
    PFNGLTEXCOORD2FCOLOR3FVERTEX3FSUNPROC epoxy_glTexCoord2fColor3fVertex3fSUN;
    PFNGLTEXCOORD2FCOLOR3FVERTEX3FVSUNPROC epoxy_glTexCoord2fColor3fVertex3fvSUN;
    PFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC epoxy_glTexCoord2fColor4fNormal3fVertex3fSUN;
    PFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC epoxy_glTexCoord2fColor4fNormal3fVertex3fvSUN;
    PFNGLTEXCOORD2FCOLOR4UBVERTEX3FSUNPROC epoxy_glTexCoord2fColor4ubVertex3fSUN;
    PFNGLTEXCOORD2FCOLOR4UBVERTEX3FVSUNPROC epoxy_glTexCoord2fColor4ubVertex3fvSUN;
    PFNGLTEXCOORD2FNORMAL3FVERTEX3FSUNPROC epoxy_glTexCoord2fNormal3fVertex3fSUN;
    PFNGLTEXCOORD2FNORMAL3FVERTEX3FVSUNPROC epoxy_glTexCoord2fNormal3fVertex3fvSUN;
    PFNGLTEXCOORD2FVERTEX3FSUNPROC epoxy_glTexCoord2fVertex3fSUN;
    PFNGLTEXCOORD2FVERTEX3FVSUNPROC epoxy_glTexCoord2fVertex3fvSUN;
    PFNGLTEXCOORD2FVPROC epoxy_glTexCoord2fv;
    PFNGLTEXCOORD2HNVPROC epoxy_glTexCoord2hNV;
    PFNGLTEXCOORD2HVNVPROC epoxy_glTexCoord2hvNV;
    PFNGLTEXCOORD2IPROC epoxy_glTexCoord2i;
    PFNGLTEXCOORD2IVPROC epoxy_glTexCoord2iv;
    PFNGLTEXCOORD2SPROC epoxy_glTexCoord2s;
    PFNGLTEXCOORD2SVPROC epoxy_glTexCoord2sv;
    PFNGLTEXCOORD2XOESPROC epoxy_glTexCoord2xOES;
    PFNGLTEXCOORD2XVOESPROC epoxy_glTexCoord2xvOES;
    PFNGLTEXCOORD3BOESPROC epoxy_glTexCoord3bOES;
    PFNGLTEXCOORD3BVOESPROC epoxy_glTexCoord3bvOES;
    PFNGLTEXCOORD3DPROC epoxy_glTexCoord3d;
    PFNGLTEXCOORD3DVPROC epoxy_glTexCoord3dv;
    PFNGLTEXCOORD3FPROC epoxy_glTexCoord3f;
    PFNGLTEXCOORD3FVPROC epoxy_glTexCoord3fv;
    PFNGLTEXCOORD3HNVPROC epoxy_glTexCoord3hNV;
    PFNGLTEXCOORD3HVNVPROC epoxy_glTexCoord3hvNV;
    PFNGLTEXCOORD3IPROC epoxy_glTexCoord3i;
    PFNGLTEXCOORD3IVPROC epoxy_glTexCoord3iv;
    PFNGLTEXCOORD3SPROC epoxy_glTexCoord3s;
    PFNGLTEXCOORD3SVPROC epoxy_glTexCoord3sv;
    PFNGLTEXCOORD3XOESPROC epoxy_glTexCoord3xOES;
    PFNGLTEXCOORD3XVOESPROC epoxy_glTexCoord3xvOES;
    PFNGLTEXCOORD4BOESPROC epoxy_glTexCoord4bOES;
    PFNGLTEXCOORD4BVOESPROC epoxy_glTexCoord4bvOES;
    PFNGLTEXCOORD4DPROC epoxy_glTexCoord4d;
    PFNGLTEXCOORD4DVPROC epoxy_glTexCoord4dv;
    PFNGLTEXCOORD4FPROC epoxy_glTexCoord4f;
    PFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUNPROC epoxy_glTexCoord4fColor4fNormal3fVertex4fSUN;
    PFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUNPROC epoxy_glTexCoord4fColor4fNormal3fVertex4fvSUN;
    PFNGLTEXCOORD4FVERTEX4FSUNPROC epoxy_glTexCoord4fVertex4fSUN;
    PFNGLTEXCOORD4FVERTEX4FVSUNPROC epoxy_glTexCoord4fVertex4fvSUN;
    PFNGLTEXCOORD4FVPROC epoxy_glTexCoord4fv;
    PFNGLTEXCOORD4HNVPROC epoxy_glTexCoord4hNV;
    PFNGLTEXCOORD4HVNVPROC epoxy_glTexCoord4hvNV;
    PFNGLTEXCOORD4IPROC epoxy_glTexCoord4i;
    PFNGLTEXCOORD4IVPROC epoxy_glTexCoord4iv;
    PFNGLTEXCOORD4SPROC epoxy_glTexCoord4s;
    PFNGLTEXCOORD4SVPROC epoxy_glTexCoord4sv;
    PFNGLTEXCOORD4XOESPROC epoxy_glTexCoord4xOES;
    PFNGLTEXCOORD4XVOESPROC epoxy_glTexCoord4xvOES;
    PFNGLTEXCOORDFORMATNVPROC epoxy_glTexCoordFormatNV;
    PFNGLTEXCOORDP1UIPROC epoxy_glTexCoordP1ui;
    PFNGLTEXCOORDP1UIVPROC epoxy_glTexCoordP1uiv;
    PFNGLTEXCOORDP2UIPROC epoxy_glTexCoordP2ui;
    PFNGLTEXCOORDP2UIVPROC epoxy_glTexCoordP2uiv;
    PFNGLTEXCOORDP3UIPROC epoxy_glTexCoordP3ui;
    PFNGLTEXCOORDP3UIVPROC epoxy_glTexCoordP3uiv;
    PFNGLTEXCOORDP4UIPROC epoxy_glTexCoordP4ui;
    PFNGLTEXCOORDP4UIVPROC epoxy_glTexCoordP4uiv;
    PFNGLTEXCOORDPOINTERPROC epoxy_glTexCoordPointer;
    PFNGLTEXCOORDPOINTEREXTPROC epoxy_glTexCoordPointerEXT;
    PFNGLTEXCOORDPOINTERLISTIBMPROC epoxy_glTexCoordPointerListIBM;
    PFNGLTEXCOORDPOINTERVINTELPROC epoxy_glTexCoordPointervINTEL;
    PFNGLTEXENVFPROC epoxy_glTexEnvf;
    PFNGLTEXENVFVPROC epoxy_glTexEnvfv;
    PFNGLTEXENVIPROC epoxy_glTexEnvi;
    PFNGLTEXENVIVPROC epoxy_glTexEnviv;
    PFNGLTEXENVXPROC epoxy_glTexEnvx;
    PFNGLTEXENVXOESPROC epoxy_glTexEnvxOES;
    PFNGLTEXENVXVPROC epoxy_glTexEnvxv;
    PFNGLTEXENVXVOESPROC epoxy_glTexEnvxvOES;
    PFNGLTEXFILTERFUNCSGISPROC epoxy_glTexFilterFuncSGIS;
    PFNGLTEXGENDPROC epoxy_glTexGend;
    PFNGLTEXGENDVPROC epoxy_glTexGendv;
    PFNGLTEXGENFPROC epoxy_glTexGenf;
    PFNGLTEXGENFOESPROC epoxy_glTexGenfOES;
    PFNGLTEXGENFVPROC epoxy_glTexGenfv;
    PFNGLTEXGENFVOESPROC epoxy_glTexGenfvOES;
    PFNGLTEXGENIPROC epoxy_glTexGeni;
    PFNGLTEXGENIOESPROC epoxy_glTexGeniOES;
    PFNGLTEXGENIVPROC epoxy_glTexGeniv;
    PFNGLTEXGENIVOESPROC epoxy_glTexGenivOES;
    PFNGLTEXGENXOESPROC epoxy_glTexGenxOES;
    PFNGLTEXGENXVOESPROC epoxy_glTexGenxvOES;
    PFNGLTEXIMAGE1DPROC epoxy_glTexImage1D;
    PFNGLTEXIMAGE2DPROC epoxy_glTexImage2D;
    PFNGLTEXIMAGE2DMULTISAMPLEPROC epoxy_glTexImage2DMultisample;
    PFNGLTEXIMAGE2DMULTISAMPLECOVERAGENVPROC epoxy_glTexImage2DMultisampleCoverageNV;
    PFNGLTEXIMAGE3DPROC epoxy_glTexImage3D;
    PFNGLTEXIMAGE3DEXTPROC epoxy_glTexImage3DEXT;
    PFNGLTEXIMAGE3DMULTISAMPLEPROC epoxy_glTexImage3DMultisample;
    PFNGLTEXIMAGE3DMULTISAMPLECOVERAGENVPROC epoxy_glTexImage3DMultisampleCoverageNV;
    PFNGLTEXIMAGE3DOESPROC epoxy_glTexImage3DOES;
    PFNGLTEXIMAGE4DSGISPROC epoxy_glTexImage4DSGIS;
    PFNGLTEXPAGECOMMITMENTARBPROC epoxy_glTexPageCommitmentARB;
    PFNGLTEXPAGECOMMITMENTEXTPROC epoxy_glTexPageCommitmentEXT;
    PFNGLTEXPARAMETERIIVPROC epoxy_glTexParameterIiv;
    PFNGLTEXPARAMETERIIVEXTPROC epoxy_glTexParameterIivEXT;
    PFNGLTEXPARAMETERIIVOESPROC epoxy_glTexParameterIivOES;
    PFNGLTEXPARAMETERIUIVPROC epoxy_glTexParameterIuiv;
    PFNGLTEXPARAMETERIUIVEXTPROC epoxy_glTexParameterIuivEXT;
    PFNGLTEXPARAMETERIUIVOESPROC epoxy_glTexParameterIuivOES;
    PFNGLTEXPARAMETERFPROC epoxy_glTexParameterf;
    PFNGLTEXPARAMETERFVPROC epoxy_glTexParameterfv;
    PFNGLTEXPARAMETERIPROC epoxy_glTexParameteri;
    PFNGLTEXPARAMETERIVPROC epoxy_glTexParameteriv;
    PFNGLTEXPARAMETERXPROC epoxy_glTexParameterx;
    PFNGLTEXPARAMETERXOESPROC epoxy_glTexParameterxOES;
    PFNGLTEXPARAMETERXVPROC epoxy_glTexParameterxv;
    PFNGLTEXPARAMETERXVOESPROC epoxy_glTexParameterxvOES;
    PFNGLTEXRENDERBUFFERNVPROC epoxy_glTexRenderbufferNV;
    PFNGLTEXSTORAGE1DPROC epoxy_glTexStorage1D;
    PFNGLTEXSTORAGE1DEXTPROC epoxy_glTexStorage1DEXT;
    PFNGLTEXSTORAGE2DPROC epoxy_glTexStorage2D;
    PFNGLTEXSTORAGE2DEXTPROC epoxy_glTexStorage2DEXT;
    PFNGLTEXSTORAGE2DMULTISAMPLEPROC epoxy_glTexStorage2DMultisample;
    PFNGLTEXSTORAGE3DPROC epoxy_glTexStorage3D;
    PFNGLTEXSTORAGE3DEXTPROC epoxy_glTexStorage3DEXT;
    PFNGLTEXSTORAGE3DMULTISAMPLEPROC epoxy_glTexStorage3DMultisample;
    PFNGLTEXSTORAGE3DMULTISAMPLEOESPROC epoxy_glTexStorage3DMultisampleOES;
    PFNGLTEXSTORAGESPARSEAMDPROC epoxy_glTexStorageSparseAMD;
    PFNGLTEXSUBIMAGE1DPROC epoxy_glTexSubImage1D;
    PFNGLTEXSUBIMAGE1DEXTPROC epoxy_glTexSubImage1DEXT;
    PFNGLTEXSUBIMAGE2DPROC epoxy_glTexSubImage2D;
    PFNGLTEXSUBIMAGE2DEXTPROC epoxy_glTexSubImage2DEXT;
    PFNGLTEXSUBIMAGE3DPROC epoxy_glTexSubImage3D;
    PFNGLTEXSUBIMAGE3DEXTPROC epoxy_glTexSubImage3DEXT;
    PFNGLTEXSUBIMAGE3DOESPROC epoxy_glTexSubImage3DOES;
    PFNGLTEXSUBIMAGE4DSGISPROC epoxy_glTexSubImage4DSGIS;
    PFNGLTEXTUREBARRIERPROC epoxy_glTextureBarrier;
    PFNGLTEXTUREBARRIERNVPROC epoxy_glTextureBarrierNV;
    PFNGLTEXTUREBUFFERPROC epoxy_glTextureBuffer;
    PFNGLTEXTUREBUFFEREXTPROC epoxy_glTextureBufferEXT;
    PFNGLTEXTUREBUFFERRANGEPROC epoxy_glTextureBufferRange;
    PFNGLTEXTUREBUFFERRANGEEXTPROC epoxy_glTextureBufferRangeEXT;
    PFNGLTEXTURECOLORMASKSGISPROC epoxy_glTextureColorMaskSGIS;
    PFNGLTEXTUREIMAGE1DEXTPROC epoxy_glTextureImage1DEXT;
    PFNGLTEXTUREIMAGE2DEXTPROC epoxy_glTextureImage2DEXT;
    PFNGLTEXTUREIMAGE2DMULTISAMPLECOVERAGENVPROC epoxy_glTextureImage2DMultisampleCoverageNV;
    PFNGLTEXTUREIMAGE2DMULTISAMPLENVPROC epoxy_glTextureImage2DMultisampleNV;
    PFNGLTEXTUREIMAGE3DEXTPROC epoxy_glTextureImage3DEXT;
    PFNGLTEXTUREIMAGE3DMULTISAMPLECOVERAGENVPROC epoxy_glTextureImage3DMultisampleCoverageNV;
    PFNGLTEXTUREIMAGE3DMULTISAMPLENVPROC epoxy_glTextureImage3DMultisampleNV;
    PFNGLTEXTURELIGHTEXTPROC epoxy_glTextureLightEXT;
    PFNGLTEXTUREMATERIALEXTPROC epoxy_glTextureMaterialEXT;
    PFNGLTEXTURENORMALEXTPROC epoxy_glTextureNormalEXT;
    PFNGLTEXTUREPAGECOMMITMENTEXTPROC epoxy_glTexturePageCommitmentEXT;
    PFNGLTEXTUREPARAMETERIIVPROC epoxy_glTextureParameterIiv;
    PFNGLTEXTUREPARAMETERIIVEXTPROC epoxy_glTextureParameterIivEXT;
    PFNGLTEXTUREPARAMETERIUIVPROC epoxy_glTextureParameterIuiv;
    PFNGLTEXTUREPARAMETERIUIVEXTPROC epoxy_glTextureParameterIuivEXT;
    PFNGLTEXTUREPARAMETERFPROC epoxy_glTextureParameterf;
    PFNGLTEXTUREPARAMETERFEXTPROC epoxy_glTextureParameterfEXT;
    PFNGLTEXTUREPARAMETERFVPROC epoxy_glTextureParameterfv;
    PFNGLTEXTUREPARAMETERFVEXTPROC epoxy_glTextureParameterfvEXT;
    PFNGLTEXTUREPARAMETERIPROC epoxy_glTextureParameteri;
    PFNGLTEXTUREPARAMETERIEXTPROC epoxy_glTextureParameteriEXT;
    PFNGLTEXTUREPARAMETERIVPROC epoxy_glTextureParameteriv;
    PFNGLTEXTUREPARAMETERIVEXTPROC epoxy_glTextureParameterivEXT;
    PFNGLTEXTURERANGEAPPLEPROC epoxy_glTextureRangeAPPLE;
    PFNGLTEXTURERENDERBUFFEREXTPROC epoxy_glTextureRenderbufferEXT;
    PFNGLTEXTURESTORAGE1DPROC epoxy_glTextureStorage1D;
    PFNGLTEXTURESTORAGE1DEXTPROC epoxy_glTextureStorage1DEXT;
    PFNGLTEXTURESTORAGE2DPROC epoxy_glTextureStorage2D;
    PFNGLTEXTURESTORAGE2DEXTPROC epoxy_glTextureStorage2DEXT;
    PFNGLTEXTURESTORAGE2DMULTISAMPLEPROC epoxy_glTextureStorage2DMultisample;
    PFNGLTEXTURESTORAGE2DMULTISAMPLEEXTPROC epoxy_glTextureStorage2DMultisampleEXT;
    PFNGLTEXTURESTORAGE3DPROC epoxy_glTextureStorage3D;
    PFNGLTEXTURESTORAGE3DEXTPROC epoxy_glTextureStorage3DEXT;
    PFNGLTEXTURESTORAGE3DMULTISAMPLEPROC epoxy_glTextureStorage3DMultisample;
    PFNGLTEXTURESTORAGE3DMULTISAMPLEEXTPROC epoxy_glTextureStorage3DMultisampleEXT;
    PFNGLTEXTURESTORAGESPARSEAMDPROC epoxy_glTextureStorageSparseAMD;
    PFNGLTEXTURESUBIMAGE1DPROC epoxy_glTextureSubImage1D;
    PFNGLTEXTURESUBIMAGE1DEXTPROC epoxy_glTextureSubImage1DEXT;
    PFNGLTEXTURESUBIMAGE2DPROC epoxy_glTextureSubImage2D;
    PFNGLTEXTURESUBIMAGE2DEXTPROC epoxy_glTextureSubImage2DEXT;
    PFNGLTEXTURESUBIMAGE3DPROC epoxy_glTextureSubImage3D;
    PFNGLTEXTURESUBIMAGE3DEXTPROC epoxy_glTextureSubImage3DEXT;
    PFNGLTEXTUREVIEWPROC epoxy_glTextureView;
    PFNGLTEXTUREVIEWEXTPROC epoxy_glTextureViewEXT;
    PFNGLTEXTUREVIEWOESPROC epoxy_glTextureViewOES;
    PFNGLTRACKMATRIXNVPROC epoxy_glTrackMatrixNV;
    PFNGLTRANSFORMFEEDBACKATTRIBSNVPROC epoxy_glTransformFeedbackAttribsNV;
    PFNGLTRANSFORMFEEDBACKBUFFERBASEPROC epoxy_glTransformFeedbackBufferBase;
    PFNGLTRANSFORMFEEDBACKBUFFERRANGEPROC epoxy_glTransformFeedbackBufferRange;
    PFNGLTRANSFORMFEEDBACKSTREAMATTRIBSNVPROC epoxy_glTransformFeedbackStreamAttribsNV;
    PFNGLTRANSFORMFEEDBACKVARYINGSPROC epoxy_glTransformFeedbackVaryings;
    PFNGLTRANSFORMFEEDBACKVARYINGSEXTPROC epoxy_glTransformFeedbackVaryingsEXT;
    PFNGLTRANSFORMFEEDBACKVARYINGSNVPROC epoxy_glTransformFeedbackVaryingsNV;
    PFNGLTRANSFORMPATHNVPROC epoxy_glTransformPathNV;
    PFNGLTRANSLATEDPROC epoxy_glTranslated;
    PFNGLTRANSLATEFPROC epoxy_glTranslatef;
    PFNGLTRANSLATEXPROC epoxy_glTranslatex;
    PFNGLTRANSLATEXOESPROC epoxy_glTranslatexOES;
    PFNGLUNIFORM1DPROC epoxy_glUniform1d;
    PFNGLUNIFORM1DVPROC epoxy_glUniform1dv;
    PFNGLUNIFORM1FPROC epoxy_glUniform1f;
    PFNGLUNIFORM1FARBPROC epoxy_glUniform1fARB;
    PFNGLUNIFORM1FVPROC epoxy_glUniform1fv;
    PFNGLUNIFORM1FVARBPROC epoxy_glUniform1fvARB;
    PFNGLUNIFORM1IPROC epoxy_glUniform1i;
    PFNGLUNIFORM1I64NVPROC epoxy_glUniform1i64NV;
    PFNGLUNIFORM1I64VNVPROC epoxy_glUniform1i64vNV;
    PFNGLUNIFORM1IARBPROC epoxy_glUniform1iARB;
    PFNGLUNIFORM1IVPROC epoxy_glUniform1iv;
    PFNGLUNIFORM1IVARBPROC epoxy_glUniform1ivARB;
    PFNGLUNIFORM1UIPROC epoxy_glUniform1ui;
    PFNGLUNIFORM1UI64NVPROC epoxy_glUniform1ui64NV;
    PFNGLUNIFORM1UI64VNVPROC epoxy_glUniform1ui64vNV;
    PFNGLUNIFORM1UIEXTPROC epoxy_glUniform1uiEXT;
    PFNGLUNIFORM1UIVPROC epoxy_glUniform1uiv;
    PFNGLUNIFORM1UIVEXTPROC epoxy_glUniform1uivEXT;
    PFNGLUNIFORM2DPROC epoxy_glUniform2d;
    PFNGLUNIFORM2DVPROC epoxy_glUniform2dv;
    PFNGLUNIFORM2FPROC epoxy_glUniform2f;
    PFNGLUNIFORM2FARBPROC epoxy_glUniform2fARB;
    PFNGLUNIFORM2FVPROC epoxy_glUniform2fv;
    PFNGLUNIFORM2FVARBPROC epoxy_glUniform2fvARB;
    PFNGLUNIFORM2IPROC epoxy_glUniform2i;
    PFNGLUNIFORM2I64NVPROC epoxy_glUniform2i64NV;
    PFNGLUNIFORM2I64VNVPROC epoxy_glUniform2i64vNV;
    PFNGLUNIFORM2IARBPROC epoxy_glUniform2iARB;
    PFNGLUNIFORM2IVPROC epoxy_glUniform2iv;
    PFNGLUNIFORM2IVARBPROC epoxy_glUniform2ivARB;
    PFNGLUNIFORM2UIPROC epoxy_glUniform2ui;
    PFNGLUNIFORM2UI64NVPROC epoxy_glUniform2ui64NV;
    PFNGLUNIFORM2UI64VNVPROC epoxy_glUniform2ui64vNV;
    PFNGLUNIFORM2UIEXTPROC epoxy_glUniform2uiEXT;
    PFNGLUNIFORM2UIVPROC epoxy_glUniform2uiv;
    PFNGLUNIFORM2UIVEXTPROC epoxy_glUniform2uivEXT;
    PFNGLUNIFORM3DPROC epoxy_glUniform3d;
    PFNGLUNIFORM3DVPROC epoxy_glUniform3dv;
    PFNGLUNIFORM3FPROC epoxy_glUniform3f;
    PFNGLUNIFORM3FARBPROC epoxy_glUniform3fARB;
    PFNGLUNIFORM3FVPROC epoxy_glUniform3fv;
    PFNGLUNIFORM3FVARBPROC epoxy_glUniform3fvARB;
    PFNGLUNIFORM3IPROC epoxy_glUniform3i;
    PFNGLUNIFORM3I64NVPROC epoxy_glUniform3i64NV;
    PFNGLUNIFORM3I64VNVPROC epoxy_glUniform3i64vNV;
    PFNGLUNIFORM3IARBPROC epoxy_glUniform3iARB;
    PFNGLUNIFORM3IVPROC epoxy_glUniform3iv;
    PFNGLUNIFORM3IVARBPROC epoxy_glUniform3ivARB;
    PFNGLUNIFORM3UIPROC epoxy_glUniform3ui;
    PFNGLUNIFORM3UI64NVPROC epoxy_glUniform3ui64NV;
    PFNGLUNIFORM3UI64VNVPROC epoxy_glUniform3ui64vNV;
    PFNGLUNIFORM3UIEXTPROC epoxy_glUniform3uiEXT;
    PFNGLUNIFORM3UIVPROC epoxy_glUniform3uiv;
    PFNGLUNIFORM3UIVEXTPROC epoxy_glUniform3uivEXT;
    PFNGLUNIFORM4DPROC epoxy_glUniform4d;
    PFNGLUNIFORM4DVPROC epoxy_glUniform4dv;
    PFNGLUNIFORM4FPROC epoxy_glUniform4f;
    PFNGLUNIFORM4FARBPROC epoxy_glUniform4fARB;
    PFNGLUNIFORM4FVPROC epoxy_glUniform4fv;
    PFNGLUNIFORM4FVARBPROC epoxy_glUniform4fvARB;
    PFNGLUNIFORM4IPROC epoxy_glUniform4i;
    PFNGLUNIFORM4I64NVPROC epoxy_glUniform4i64NV;
    PFNGLUNIFORM4I64VNVPROC epoxy_glUniform4i64vNV;
    PFNGLUNIFORM4IARBPROC epoxy_glUniform4iARB;
    PFNGLUNIFORM4IVPROC epoxy_glUniform4iv;
    PFNGLUNIFORM4IVARBPROC epoxy_glUniform4ivARB;
    PFNGLUNIFORM4UIPROC epoxy_glUniform4ui;
    PFNGLUNIFORM4UI64NVPROC epoxy_glUniform4ui64NV;
    PFNGLUNIFORM4UI64VNVPROC epoxy_glUniform4ui64vNV;
    PFNGLUNIFORM4UIEXTPROC epoxy_glUniform4uiEXT;
    PFNGLUNIFORM4UIVPROC epoxy_glUniform4uiv;
    PFNGLUNIFORM4UIVEXTPROC epoxy_glUniform4uivEXT;
    PFNGLUNIFORMBLOCKBINDINGPROC epoxy_glUniformBlockBinding;
    PFNGLUNIFORMBUFFEREXTPROC epoxy_glUniformBufferEXT;
    PFNGLUNIFORMHANDLEUI64ARBPROC epoxy_glUniformHandleui64ARB;
    PFNGLUNIFORMHANDLEUI64NVPROC epoxy_glUniformHandleui64NV;
    PFNGLUNIFORMHANDLEUI64VARBPROC epoxy_glUniformHandleui64vARB;
    PFNGLUNIFORMHANDLEUI64VNVPROC epoxy_glUniformHandleui64vNV;
    PFNGLUNIFORMMATRIX2DVPROC epoxy_glUniformMatrix2dv;
    PFNGLUNIFORMMATRIX2FVPROC epoxy_glUniformMatrix2fv;
    PFNGLUNIFORMMATRIX2FVARBPROC epoxy_glUniformMatrix2fvARB;
    PFNGLUNIFORMMATRIX2X3DVPROC epoxy_glUniformMatrix2x3dv;
    PFNGLUNIFORMMATRIX2X3FVPROC epoxy_glUniformMatrix2x3fv;
    PFNGLUNIFORMMATRIX2X3FVNVPROC epoxy_glUniformMatrix2x3fvNV;
    PFNGLUNIFORMMATRIX2X4DVPROC epoxy_glUniformMatrix2x4dv;
    PFNGLUNIFORMMATRIX2X4FVPROC epoxy_glUniformMatrix2x4fv;
    PFNGLUNIFORMMATRIX2X4FVNVPROC epoxy_glUniformMatrix2x4fvNV;
    PFNGLUNIFORMMATRIX3DVPROC epoxy_glUniformMatrix3dv;
    PFNGLUNIFORMMATRIX3FVPROC epoxy_glUniformMatrix3fv;
    PFNGLUNIFORMMATRIX3FVARBPROC epoxy_glUniformMatrix3fvARB;
    PFNGLUNIFORMMATRIX3X2DVPROC epoxy_glUniformMatrix3x2dv;
    PFNGLUNIFORMMATRIX3X2FVPROC epoxy_glUniformMatrix3x2fv;
    PFNGLUNIFORMMATRIX3X2FVNVPROC epoxy_glUniformMatrix3x2fvNV;
    PFNGLUNIFORMMATRIX3X4DVPROC epoxy_glUniformMatrix3x4dv;
    PFNGLUNIFORMMATRIX3X4FVPROC epoxy_glUniformMatrix3x4fv;
    PFNGLUNIFORMMATRIX3X4FVNVPROC epoxy_glUniformMatrix3x4fvNV;
    PFNGLUNIFORMMATRIX4DVPROC epoxy_glUniformMatrix4dv;
    PFNGLUNIFORMMATRIX4FVPROC epoxy_glUniformMatrix4fv;
    PFNGLUNIFORMMATRIX4FVARBPROC epoxy_glUniformMatrix4fvARB;
    PFNGLUNIFORMMATRIX4X2DVPROC epoxy_glUniformMatrix4x2dv;
    PFNGLUNIFORMMATRIX4X2FVPROC epoxy_glUniformMatrix4x2fv;
    PFNGLUNIFORMMATRIX4X2FVNVPROC epoxy_glUniformMatrix4x2fvNV;
    PFNGLUNIFORMMATRIX4X3DVPROC epoxy_glUniformMatrix4x3dv;
    PFNGLUNIFORMMATRIX4X3FVPROC epoxy_glUniformMatrix4x3fv;
    PFNGLUNIFORMMATRIX4X3FVNVPROC epoxy_glUniformMatrix4x3fvNV;
    PFNGLUNIFORMSUBROUTINESUIVPROC epoxy_glUniformSubroutinesuiv;
    PFNGLUNIFORMUI64NVPROC epoxy_glUniformui64NV;
    PFNGLUNIFORMUI64VNVPROC epoxy_glUniformui64vNV;
    PFNGLUNLOCKARRAYSEXTPROC epoxy_glUnlockArraysEXT;
    PFNGLUNMAPBUFFERPROC epoxy_glUnmapBuffer;
    PFNGLUNMAPBUFFERARBPROC epoxy_glUnmapBufferARB;
    PFNGLUNMAPBUFFEROESPROC epoxy_glUnmapBufferOES;
    PFNGLUNMAPNAMEDBUFFERPROC epoxy_glUnmapNamedBuffer;
    PFNGLUNMAPNAMEDBUFFEREXTPROC epoxy_glUnmapNamedBufferEXT;
    PFNGLUNMAPOBJECTBUFFERATIPROC epoxy_glUnmapObjectBufferATI;
    PFNGLUNMAPTEXTURE2DINTELPROC epoxy_glUnmapTexture2DINTEL;
    PFNGLUPDATEOBJECTBUFFERATIPROC epoxy_glUpdateObjectBufferATI;
    PFNGLUSEPROGRAMPROC epoxy_glUseProgram;
    PFNGLUSEPROGRAMOBJECTARBPROC epoxy_glUseProgramObjectARB;
    PFNGLUSEPROGRAMSTAGESPROC epoxy_glUseProgramStages;
    PFNGLUSEPROGRAMSTAGESEXTPROC epoxy_glUseProgramStagesEXT;
    PFNGLUSESHADERPROGRAMEXTPROC epoxy_glUseShaderProgramEXT;
    PFNGLVDPAUFININVPROC epoxy_glVDPAUFiniNV;
    PFNGLVDPAUGETSURFACEIVNVPROC epoxy_glVDPAUGetSurfaceivNV;
    PFNGLVDPAUINITNVPROC epoxy_glVDPAUInitNV;
    PFNGLVDPAUISSURFACENVPROC epoxy_glVDPAUIsSurfaceNV;
    PFNGLVDPAUMAPSURFACESNVPROC epoxy_glVDPAUMapSurfacesNV;
    PFNGLVDPAUREGISTEROUTPUTSURFACENVPROC epoxy_glVDPAURegisterOutputSurfaceNV;
    PFNGLVDPAUREGISTERVIDEOSURFACENVPROC epoxy_glVDPAURegisterVideoSurfaceNV;
    PFNGLVDPAUSURFACEACCESSNVPROC epoxy_glVDPAUSurfaceAccessNV;
    PFNGLVDPAUUNMAPSURFACESNVPROC epoxy_glVDPAUUnmapSurfacesNV;
    PFNGLVDPAUUNREGISTERSURFACENVPROC epoxy_glVDPAUUnregisterSurfaceNV;
    PFNGLVALIDATEPROGRAMPROC epoxy_glValidateProgram;
    PFNGLVALIDATEPROGRAMARBPROC epoxy_glValidateProgramARB;
    PFNGLVALIDATEPROGRAMPIPELINEPROC epoxy_glValidateProgramPipeline;
    PFNGLVALIDATEPROGRAMPIPELINEEXTPROC epoxy_glValidateProgramPipelineEXT;
    PFNGLVARIANTARRAYOBJECTATIPROC epoxy_glVariantArrayObjectATI;
    PFNGLVARIANTPOINTEREXTPROC epoxy_glVariantPointerEXT;
    PFNGLVARIANTBVEXTPROC epoxy_glVariantbvEXT;
    PFNGLVARIANTDVEXTPROC epoxy_glVariantdvEXT;
    PFNGLVARIANTFVEXTPROC epoxy_glVariantfvEXT;
    PFNGLVARIANTIVEXTPROC epoxy_glVariantivEXT;
    PFNGLVARIANTSVEXTPROC epoxy_glVariantsvEXT;
    PFNGLVARIANTUBVEXTPROC epoxy_glVariantubvEXT;
    PFNGLVARIANTUIVEXTPROC epoxy_glVariantuivEXT;
    PFNGLVARIANTUSVEXTPROC epoxy_glVariantusvEXT;
    PFNGLVERTEX2BOESPROC epoxy_glVertex2bOES;
    PFNGLVERTEX2BVOESPROC epoxy_glVertex2bvOES;
    PFNGLVERTEX2DPROC epoxy_glVertex2d;
    PFNGLVERTEX2DVPROC epoxy_glVertex2dv;
    PFNGLVERTEX2FPROC epoxy_glVertex2f;
    PFNGLVERTEX2FVPROC epoxy_glVertex2fv;
    PFNGLVERTEX2HNVPROC epoxy_glVertex2hNV;
    PFNGLVERTEX2HVNVPROC epoxy_glVertex2hvNV;
    PFNGLVERTEX2IPROC epoxy_glVertex2i;
    PFNGLVERTEX2IVPROC epoxy_glVertex2iv;
    PFNGLVERTEX2SPROC epoxy_glVertex2s;
    PFNGLVERTEX2SVPROC epoxy_glVertex2sv;
    PFNGLVERTEX2XOESPROC epoxy_glVertex2xOES;
    PFNGLVERTEX2XVOESPROC epoxy_glVertex2xvOES;
    PFNGLVERTEX3BOESPROC epoxy_glVertex3bOES;
    PFNGLVERTEX3BVOESPROC epoxy_glVertex3bvOES;
    PFNGLVERTEX3DPROC epoxy_glVertex3d;
    PFNGLVERTEX3DVPROC epoxy_glVertex3dv;
    PFNGLVERTEX3FPROC epoxy_glVertex3f;
    PFNGLVERTEX3FVPROC epoxy_glVertex3fv;
    PFNGLVERTEX3HNVPROC epoxy_glVertex3hNV;
    PFNGLVERTEX3HVNVPROC epoxy_glVertex3hvNV;
    PFNGLVERTEX3IPROC epoxy_glVertex3i;
    PFNGLVERTEX3IVPROC epoxy_glVertex3iv;
    PFNGLVERTEX3SPROC epoxy_glVertex3s;
    PFNGLVERTEX3SVPROC epoxy_glVertex3sv;
    PFNGLVERTEX3XOESPROC epoxy_glVertex3xOES;
    PFNGLVERTEX3XVOESPROC epoxy_glVertex3xvOES;
    PFNGLVERTEX4BOESPROC epoxy_glVertex4bOES;
    PFNGLVERTEX4BVOESPROC epoxy_glVertex4bvOES;
    PFNGLVERTEX4DPROC epoxy_glVertex4d;
    PFNGLVERTEX4DVPROC epoxy_glVertex4dv;
    PFNGLVERTEX4FPROC epoxy_glVertex4f;
    PFNGLVERTEX4FVPROC epoxy_glVertex4fv;
    PFNGLVERTEX4HNVPROC epoxy_glVertex4hNV;
    PFNGLVERTEX4HVNVPROC epoxy_glVertex4hvNV;
    PFNGLVERTEX4IPROC epoxy_glVertex4i;
    PFNGLVERTEX4IVPROC epoxy_glVertex4iv;
    PFNGLVERTEX4SPROC epoxy_glVertex4s;
    PFNGLVERTEX4SVPROC epoxy_glVertex4sv;
    PFNGLVERTEX4XOESPROC epoxy_glVertex4xOES;
    PFNGLVERTEX4XVOESPROC epoxy_glVertex4xvOES;
    PFNGLVERTEXARRAYATTRIBBINDINGPROC epoxy_glVertexArrayAttribBinding;
    PFNGLVERTEXARRAYATTRIBFORMATPROC epoxy_glVertexArrayAttribFormat;
    PFNGLVERTEXARRAYATTRIBIFORMATPROC epoxy_glVertexArrayAttribIFormat;
    PFNGLVERTEXARRAYATTRIBLFORMATPROC epoxy_glVertexArrayAttribLFormat;
    PFNGLVERTEXARRAYBINDVERTEXBUFFEREXTPROC epoxy_glVertexArrayBindVertexBufferEXT;
    PFNGLVERTEXARRAYBINDINGDIVISORPROC epoxy_glVertexArrayBindingDivisor;
    PFNGLVERTEXARRAYCOLOROFFSETEXTPROC epoxy_glVertexArrayColorOffsetEXT;
    PFNGLVERTEXARRAYEDGEFLAGOFFSETEXTPROC epoxy_glVertexArrayEdgeFlagOffsetEXT;
    PFNGLVERTEXARRAYELEMENTBUFFERPROC epoxy_glVertexArrayElementBuffer;
    PFNGLVERTEXARRAYFOGCOORDOFFSETEXTPROC epoxy_glVertexArrayFogCoordOffsetEXT;
    PFNGLVERTEXARRAYINDEXOFFSETEXTPROC epoxy_glVertexArrayIndexOffsetEXT;
    PFNGLVERTEXARRAYMULTITEXCOORDOFFSETEXTPROC epoxy_glVertexArrayMultiTexCoordOffsetEXT;
    PFNGLVERTEXARRAYNORMALOFFSETEXTPROC epoxy_glVertexArrayNormalOffsetEXT;
    PFNGLVERTEXARRAYPARAMETERIAPPLEPROC epoxy_glVertexArrayParameteriAPPLE;
    PFNGLVERTEXARRAYRANGEAPPLEPROC epoxy_glVertexArrayRangeAPPLE;
    PFNGLVERTEXARRAYRANGENVPROC epoxy_glVertexArrayRangeNV;
    PFNGLVERTEXARRAYSECONDARYCOLOROFFSETEXTPROC epoxy_glVertexArraySecondaryColorOffsetEXT;
    PFNGLVERTEXARRAYTEXCOORDOFFSETEXTPROC epoxy_glVertexArrayTexCoordOffsetEXT;
    PFNGLVERTEXARRAYVERTEXATTRIBBINDINGEXTPROC epoxy_glVertexArrayVertexAttribBindingEXT;
    PFNGLVERTEXARRAYVERTEXATTRIBDIVISOREXTPROC epoxy_glVertexArrayVertexAttribDivisorEXT;
    PFNGLVERTEXARRAYVERTEXATTRIBFORMATEXTPROC epoxy_glVertexArrayVertexAttribFormatEXT;
    PFNGLVERTEXARRAYVERTEXATTRIBIFORMATEXTPROC epoxy_glVertexArrayVertexAttribIFormatEXT;
    PFNGLVERTEXARRAYVERTEXATTRIBIOFFSETEXTPROC epoxy_glVertexArrayVertexAttribIOffsetEXT;
    PFNGLVERTEXARRAYVERTEXATTRIBLFORMATEXTPROC epoxy_glVertexArrayVertexAttribLFormatEXT;
    PFNGLVERTEXARRAYVERTEXATTRIBLOFFSETEXTPROC epoxy_glVertexArrayVertexAttribLOffsetEXT;
    PFNGLVERTEXARRAYVERTEXATTRIBOFFSETEXTPROC epoxy_glVertexArrayVertexAttribOffsetEXT;
    PFNGLVERTEXARRAYVERTEXBINDINGDIVISOREXTPROC epoxy_glVertexArrayVertexBindingDivisorEXT;
    PFNGLVERTEXARRAYVERTEXBUFFERPROC epoxy_glVertexArrayVertexBuffer;
    PFNGLVERTEXARRAYVERTEXBUFFERSPROC epoxy_glVertexArrayVertexBuffers;
    PFNGLVERTEXARRAYVERTEXOFFSETEXTPROC epoxy_glVertexArrayVertexOffsetEXT;
    PFNGLVERTEXATTRIB1DPROC epoxy_glVertexAttrib1d;
    PFNGLVERTEXATTRIB1DARBPROC epoxy_glVertexAttrib1dARB;
    PFNGLVERTEXATTRIB1DNVPROC epoxy_glVertexAttrib1dNV;
    PFNGLVERTEXATTRIB1DVPROC epoxy_glVertexAttrib1dv;
    PFNGLVERTEXATTRIB1DVARBPROC epoxy_glVertexAttrib1dvARB;
    PFNGLVERTEXATTRIB1DVNVPROC epoxy_glVertexAttrib1dvNV;
    PFNGLVERTEXATTRIB1FPROC epoxy_glVertexAttrib1f;
    PFNGLVERTEXATTRIB1FARBPROC epoxy_glVertexAttrib1fARB;
    PFNGLVERTEXATTRIB1FNVPROC epoxy_glVertexAttrib1fNV;
    PFNGLVERTEXATTRIB1FVPROC epoxy_glVertexAttrib1fv;
    PFNGLVERTEXATTRIB1FVARBPROC epoxy_glVertexAttrib1fvARB;
    PFNGLVERTEXATTRIB1FVNVPROC epoxy_glVertexAttrib1fvNV;
    PFNGLVERTEXATTRIB1HNVPROC epoxy_glVertexAttrib1hNV;
    PFNGLVERTEXATTRIB1HVNVPROC epoxy_glVertexAttrib1hvNV;
    PFNGLVERTEXATTRIB1SPROC epoxy_glVertexAttrib1s;
    PFNGLVERTEXATTRIB1SARBPROC epoxy_glVertexAttrib1sARB;
    PFNGLVERTEXATTRIB1SNVPROC epoxy_glVertexAttrib1sNV;
    PFNGLVERTEXATTRIB1SVPROC epoxy_glVertexAttrib1sv;
    PFNGLVERTEXATTRIB1SVARBPROC epoxy_glVertexAttrib1svARB;
    PFNGLVERTEXATTRIB1SVNVPROC epoxy_glVertexAttrib1svNV;
    PFNGLVERTEXATTRIB2DPROC epoxy_glVertexAttrib2d;
    PFNGLVERTEXATTRIB2DARBPROC epoxy_glVertexAttrib2dARB;
    PFNGLVERTEXATTRIB2DNVPROC epoxy_glVertexAttrib2dNV;
    PFNGLVERTEXATTRIB2DVPROC epoxy_glVertexAttrib2dv;
    PFNGLVERTEXATTRIB2DVARBPROC epoxy_glVertexAttrib2dvARB;
    PFNGLVERTEXATTRIB2DVNVPROC epoxy_glVertexAttrib2dvNV;
    PFNGLVERTEXATTRIB2FPROC epoxy_glVertexAttrib2f;
    PFNGLVERTEXATTRIB2FARBPROC epoxy_glVertexAttrib2fARB;
    PFNGLVERTEXATTRIB2FNVPROC epoxy_glVertexAttrib2fNV;
    PFNGLVERTEXATTRIB2FVPROC epoxy_glVertexAttrib2fv;
    PFNGLVERTEXATTRIB2FVARBPROC epoxy_glVertexAttrib2fvARB;
    PFNGLVERTEXATTRIB2FVNVPROC epoxy_glVertexAttrib2fvNV;
    PFNGLVERTEXATTRIB2HNVPROC epoxy_glVertexAttrib2hNV;
    PFNGLVERTEXATTRIB2HVNVPROC epoxy_glVertexAttrib2hvNV;
    PFNGLVERTEXATTRIB2SPROC epoxy_glVertexAttrib2s;
    PFNGLVERTEXATTRIB2SARBPROC epoxy_glVertexAttrib2sARB;
    PFNGLVERTEXATTRIB2SNVPROC epoxy_glVertexAttrib2sNV;
    PFNGLVERTEXATTRIB2SVPROC epoxy_glVertexAttrib2sv;
    PFNGLVERTEXATTRIB2SVARBPROC epoxy_glVertexAttrib2svARB;
    PFNGLVERTEXATTRIB2SVNVPROC epoxy_glVertexAttrib2svNV;
    PFNGLVERTEXATTRIB3DPROC epoxy_glVertexAttrib3d;
    PFNGLVERTEXATTRIB3DARBPROC epoxy_glVertexAttrib3dARB;
    PFNGLVERTEXATTRIB3DNVPROC epoxy_glVertexAttrib3dNV;
    PFNGLVERTEXATTRIB3DVPROC epoxy_glVertexAttrib3dv;
    PFNGLVERTEXATTRIB3DVARBPROC epoxy_glVertexAttrib3dvARB;
    PFNGLVERTEXATTRIB3DVNVPROC epoxy_glVertexAttrib3dvNV;
    PFNGLVERTEXATTRIB3FPROC epoxy_glVertexAttrib3f;
    PFNGLVERTEXATTRIB3FARBPROC epoxy_glVertexAttrib3fARB;
    PFNGLVERTEXATTRIB3FNVPROC epoxy_glVertexAttrib3fNV;
    PFNGLVERTEXATTRIB3FVPROC epoxy_glVertexAttrib3fv;
    PFNGLVERTEXATTRIB3FVARBPROC epoxy_glVertexAttrib3fvARB;
    PFNGLVERTEXATTRIB3FVNVPROC epoxy_glVertexAttrib3fvNV;
    PFNGLVERTEXATTRIB3HNVPROC epoxy_glVertexAttrib3hNV;
    PFNGLVERTEXATTRIB3HVNVPROC epoxy_glVertexAttrib3hvNV;
    PFNGLVERTEXATTRIB3SPROC epoxy_glVertexAttrib3s;
    PFNGLVERTEXATTRIB3SARBPROC epoxy_glVertexAttrib3sARB;
    PFNGLVERTEXATTRIB3SNVPROC epoxy_glVertexAttrib3sNV;
    PFNGLVERTEXATTRIB3SVPROC epoxy_glVertexAttrib3sv;
    PFNGLVERTEXATTRIB3SVARBPROC epoxy_glVertexAttrib3svARB;
    PFNGLVERTEXATTRIB3SVNVPROC epoxy_glVertexAttrib3svNV;
    PFNGLVERTEXATTRIB4NBVPROC epoxy_glVertexAttrib4Nbv;
    PFNGLVERTEXATTRIB4NBVARBPROC epoxy_glVertexAttrib4NbvARB;
    PFNGLVERTEXATTRIB4NIVPROC epoxy_glVertexAttrib4Niv;
    PFNGLVERTEXATTRIB4NIVARBPROC epoxy_glVertexAttrib4NivARB;
    PFNGLVERTEXATTRIB4NSVPROC epoxy_glVertexAttrib4Nsv;
    PFNGLVERTEXATTRIB4NSVARBPROC epoxy_glVertexAttrib4NsvARB;
    PFNGLVERTEXATTRIB4NUBPROC epoxy_glVertexAttrib4Nub;
    PFNGLVERTEXATTRIB4NUBARBPROC epoxy_glVertexAttrib4NubARB;
    PFNGLVERTEXATTRIB4NUBVPROC epoxy_glVertexAttrib4Nubv;
    PFNGLVERTEXATTRIB4NUBVARBPROC epoxy_glVertexAttrib4NubvARB;
    PFNGLVERTEXATTRIB4NUIVPROC epoxy_glVertexAttrib4Nuiv;
    PFNGLVERTEXATTRIB4NUIVARBPROC epoxy_glVertexAttrib4NuivARB;
    PFNGLVERTEXATTRIB4NUSVPROC epoxy_glVertexAttrib4Nusv;
    PFNGLVERTEXATTRIB4NUSVARBPROC epoxy_glVertexAttrib4NusvARB;
    PFNGLVERTEXATTRIB4BVPROC epoxy_glVertexAttrib4bv;
    PFNGLVERTEXATTRIB4BVARBPROC epoxy_glVertexAttrib4bvARB;
    PFNGLVERTEXATTRIB4DPROC epoxy_glVertexAttrib4d;
    PFNGLVERTEXATTRIB4DARBPROC epoxy_glVertexAttrib4dARB;
    PFNGLVERTEXATTRIB4DNVPROC epoxy_glVertexAttrib4dNV;
    PFNGLVERTEXATTRIB4DVPROC epoxy_glVertexAttrib4dv;
    PFNGLVERTEXATTRIB4DVARBPROC epoxy_glVertexAttrib4dvARB;
    PFNGLVERTEXATTRIB4DVNVPROC epoxy_glVertexAttrib4dvNV;
    PFNGLVERTEXATTRIB4FPROC epoxy_glVertexAttrib4f;
    PFNGLVERTEXATTRIB4FARBPROC epoxy_glVertexAttrib4fARB;
    PFNGLVERTEXATTRIB4FNVPROC epoxy_glVertexAttrib4fNV;
    PFNGLVERTEXATTRIB4FVPROC epoxy_glVertexAttrib4fv;
    PFNGLVERTEXATTRIB4FVARBPROC epoxy_glVertexAttrib4fvARB;
    PFNGLVERTEXATTRIB4FVNVPROC epoxy_glVertexAttrib4fvNV;
    PFNGLVERTEXATTRIB4HNVPROC epoxy_glVertexAttrib4hNV;
    PFNGLVERTEXATTRIB4HVNVPROC epoxy_glVertexAttrib4hvNV;
    PFNGLVERTEXATTRIB4IVPROC epoxy_glVertexAttrib4iv;
    PFNGLVERTEXATTRIB4IVARBPROC epoxy_glVertexAttrib4ivARB;
    PFNGLVERTEXATTRIB4SPROC epoxy_glVertexAttrib4s;
    PFNGLVERTEXATTRIB4SARBPROC epoxy_glVertexAttrib4sARB;
    PFNGLVERTEXATTRIB4SNVPROC epoxy_glVertexAttrib4sNV;
    PFNGLVERTEXATTRIB4SVPROC epoxy_glVertexAttrib4sv;
    PFNGLVERTEXATTRIB4SVARBPROC epoxy_glVertexAttrib4svARB;
    PFNGLVERTEXATTRIB4SVNVPROC epoxy_glVertexAttrib4svNV;
    PFNGLVERTEXATTRIB4UBNVPROC epoxy_glVertexAttrib4ubNV;
    PFNGLVERTEXATTRIB4UBVPROC epoxy_glVertexAttrib4ubv;
    PFNGLVERTEXATTRIB4UBVARBPROC epoxy_glVertexAttrib4ubvARB;
    PFNGLVERTEXATTRIB4UBVNVPROC epoxy_glVertexAttrib4ubvNV;
    PFNGLVERTEXATTRIB4UIVPROC epoxy_glVertexAttrib4uiv;
    PFNGLVERTEXATTRIB4UIVARBPROC epoxy_glVertexAttrib4uivARB;
    PFNGLVERTEXATTRIB4USVPROC epoxy_glVertexAttrib4usv;
    PFNGLVERTEXATTRIB4USVARBPROC epoxy_glVertexAttrib4usvARB;
    PFNGLVERTEXATTRIBARRAYOBJECTATIPROC epoxy_glVertexAttribArrayObjectATI;
    PFNGLVERTEXATTRIBBINDINGPROC epoxy_glVertexAttribBinding;
    PFNGLVERTEXATTRIBDIVISORPROC epoxy_glVertexAttribDivisor;
    PFNGLVERTEXATTRIBDIVISORANGLEPROC epoxy_glVertexAttribDivisorANGLE;
    PFNGLVERTEXATTRIBDIVISORARBPROC epoxy_glVertexAttribDivisorARB;
    PFNGLVERTEXATTRIBDIVISOREXTPROC epoxy_glVertexAttribDivisorEXT;
    PFNGLVERTEXATTRIBDIVISORNVPROC epoxy_glVertexAttribDivisorNV;
    PFNGLVERTEXATTRIBFORMATPROC epoxy_glVertexAttribFormat;
    PFNGLVERTEXATTRIBFORMATNVPROC epoxy_glVertexAttribFormatNV;
    PFNGLVERTEXATTRIBI1IPROC epoxy_glVertexAttribI1i;
    PFNGLVERTEXATTRIBI1IEXTPROC epoxy_glVertexAttribI1iEXT;
    PFNGLVERTEXATTRIBI1IVPROC epoxy_glVertexAttribI1iv;
    PFNGLVERTEXATTRIBI1IVEXTPROC epoxy_glVertexAttribI1ivEXT;
    PFNGLVERTEXATTRIBI1UIPROC epoxy_glVertexAttribI1ui;
    PFNGLVERTEXATTRIBI1UIEXTPROC epoxy_glVertexAttribI1uiEXT;
    PFNGLVERTEXATTRIBI1UIVPROC epoxy_glVertexAttribI1uiv;
    PFNGLVERTEXATTRIBI1UIVEXTPROC epoxy_glVertexAttribI1uivEXT;
    PFNGLVERTEXATTRIBI2IPROC epoxy_glVertexAttribI2i;
    PFNGLVERTEXATTRIBI2IEXTPROC epoxy_glVertexAttribI2iEXT;
    PFNGLVERTEXATTRIBI2IVPROC epoxy_glVertexAttribI2iv;
    PFNGLVERTEXATTRIBI2IVEXTPROC epoxy_glVertexAttribI2ivEXT;
    PFNGLVERTEXATTRIBI2UIPROC epoxy_glVertexAttribI2ui;
    PFNGLVERTEXATTRIBI2UIEXTPROC epoxy_glVertexAttribI2uiEXT;
    PFNGLVERTEXATTRIBI2UIVPROC epoxy_glVertexAttribI2uiv;
    PFNGLVERTEXATTRIBI2UIVEXTPROC epoxy_glVertexAttribI2uivEXT;
    PFNGLVERTEXATTRIBI3IPROC epoxy_glVertexAttribI3i;
    PFNGLVERTEXATTRIBI3IEXTPROC epoxy_glVertexAttribI3iEXT;
    PFNGLVERTEXATTRIBI3IVPROC epoxy_glVertexAttribI3iv;
    PFNGLVERTEXATTRIBI3IVEXTPROC epoxy_glVertexAttribI3ivEXT;
    PFNGLVERTEXATTRIBI3UIPROC epoxy_glVertexAttribI3ui;
    PFNGLVERTEXATTRIBI3UIEXTPROC epoxy_glVertexAttribI3uiEXT;
    PFNGLVERTEXATTRIBI3UIVPROC epoxy_glVertexAttribI3uiv;
    PFNGLVERTEXATTRIBI3UIVEXTPROC epoxy_glVertexAttribI3uivEXT;
    PFNGLVERTEXATTRIBI4BVPROC epoxy_glVertexAttribI4bv;
    PFNGLVERTEXATTRIBI4BVEXTPROC epoxy_glVertexAttribI4bvEXT;
    PFNGLVERTEXATTRIBI4IPROC epoxy_glVertexAttribI4i;
    PFNGLVERTEXATTRIBI4IEXTPROC epoxy_glVertexAttribI4iEXT;
    PFNGLVERTEXATTRIBI4IVPROC epoxy_glVertexAttribI4iv;
    PFNGLVERTEXATTRIBI4IVEXTPROC epoxy_glVertexAttribI4ivEXT;
    PFNGLVERTEXATTRIBI4SVPROC epoxy_glVertexAttribI4sv;
    PFNGLVERTEXATTRIBI4SVEXTPROC epoxy_glVertexAttribI4svEXT;
    PFNGLVERTEXATTRIBI4UBVPROC epoxy_glVertexAttribI4ubv;
    PFNGLVERTEXATTRIBI4UBVEXTPROC epoxy_glVertexAttribI4ubvEXT;
    PFNGLVERTEXATTRIBI4UIPROC epoxy_glVertexAttribI4ui;
    PFNGLVERTEXATTRIBI4UIEXTPROC epoxy_glVertexAttribI4uiEXT;
    PFNGLVERTEXATTRIBI4UIVPROC epoxy_glVertexAttribI4uiv;
    PFNGLVERTEXATTRIBI4UIVEXTPROC epoxy_glVertexAttribI4uivEXT;
    PFNGLVERTEXATTRIBI4USVPROC epoxy_glVertexAttribI4usv;
    PFNGLVERTEXATTRIBI4USVEXTPROC epoxy_glVertexAttribI4usvEXT;
    PFNGLVERTEXATTRIBIFORMATPROC epoxy_glVertexAttribIFormat;
    PFNGLVERTEXATTRIBIFORMATNVPROC epoxy_glVertexAttribIFormatNV;
    PFNGLVERTEXATTRIBIPOINTERPROC epoxy_glVertexAttribIPointer;
    PFNGLVERTEXATTRIBIPOINTEREXTPROC epoxy_glVertexAttribIPointerEXT;
    PFNGLVERTEXATTRIBL1DPROC epoxy_glVertexAttribL1d;
    PFNGLVERTEXATTRIBL1DEXTPROC epoxy_glVertexAttribL1dEXT;
    PFNGLVERTEXATTRIBL1DVPROC epoxy_glVertexAttribL1dv;
    PFNGLVERTEXATTRIBL1DVEXTPROC epoxy_glVertexAttribL1dvEXT;
    PFNGLVERTEXATTRIBL1I64NVPROC epoxy_glVertexAttribL1i64NV;
    PFNGLVERTEXATTRIBL1I64VNVPROC epoxy_glVertexAttribL1i64vNV;
    PFNGLVERTEXATTRIBL1UI64ARBPROC epoxy_glVertexAttribL1ui64ARB;
    PFNGLVERTEXATTRIBL1UI64NVPROC epoxy_glVertexAttribL1ui64NV;
    PFNGLVERTEXATTRIBL1UI64VARBPROC epoxy_glVertexAttribL1ui64vARB;
    PFNGLVERTEXATTRIBL1UI64VNVPROC epoxy_glVertexAttribL1ui64vNV;
    PFNGLVERTEXATTRIBL2DPROC epoxy_glVertexAttribL2d;
    PFNGLVERTEXATTRIBL2DEXTPROC epoxy_glVertexAttribL2dEXT;
    PFNGLVERTEXATTRIBL2DVPROC epoxy_glVertexAttribL2dv;
    PFNGLVERTEXATTRIBL2DVEXTPROC epoxy_glVertexAttribL2dvEXT;
    PFNGLVERTEXATTRIBL2I64NVPROC epoxy_glVertexAttribL2i64NV;
    PFNGLVERTEXATTRIBL2I64VNVPROC epoxy_glVertexAttribL2i64vNV;
    PFNGLVERTEXATTRIBL2UI64NVPROC epoxy_glVertexAttribL2ui64NV;
    PFNGLVERTEXATTRIBL2UI64VNVPROC epoxy_glVertexAttribL2ui64vNV;
    PFNGLVERTEXATTRIBL3DPROC epoxy_glVertexAttribL3d;
    PFNGLVERTEXATTRIBL3DEXTPROC epoxy_glVertexAttribL3dEXT;
    PFNGLVERTEXATTRIBL3DVPROC epoxy_glVertexAttribL3dv;
    PFNGLVERTEXATTRIBL3DVEXTPROC epoxy_glVertexAttribL3dvEXT;
    PFNGLVERTEXATTRIBL3I64NVPROC epoxy_glVertexAttribL3i64NV;
    PFNGLVERTEXATTRIBL3I64VNVPROC epoxy_glVertexAttribL3i64vNV;
    PFNGLVERTEXATTRIBL3UI64NVPROC epoxy_glVertexAttribL3ui64NV;
    PFNGLVERTEXATTRIBL3UI64VNVPROC epoxy_glVertexAttribL3ui64vNV;
    PFNGLVERTEXATTRIBL4DPROC epoxy_glVertexAttribL4d;
    PFNGLVERTEXATTRIBL4DEXTPROC epoxy_glVertexAttribL4dEXT;
    PFNGLVERTEXATTRIBL4DVPROC epoxy_glVertexAttribL4dv;
    PFNGLVERTEXATTRIBL4DVEXTPROC epoxy_glVertexAttribL4dvEXT;
    PFNGLVERTEXATTRIBL4I64NVPROC epoxy_glVertexAttribL4i64NV;
    PFNGLVERTEXATTRIBL4I64VNVPROC epoxy_glVertexAttribL4i64vNV;
    PFNGLVERTEXATTRIBL4UI64NVPROC epoxy_glVertexAttribL4ui64NV;
    PFNGLVERTEXATTRIBL4UI64VNVPROC epoxy_glVertexAttribL4ui64vNV;
    PFNGLVERTEXATTRIBLFORMATPROC epoxy_glVertexAttribLFormat;
    PFNGLVERTEXATTRIBLFORMATNVPROC epoxy_glVertexAttribLFormatNV;
    PFNGLVERTEXATTRIBLPOINTERPROC epoxy_glVertexAttribLPointer;
    PFNGLVERTEXATTRIBLPOINTEREXTPROC epoxy_glVertexAttribLPointerEXT;
    PFNGLVERTEXATTRIBP1UIPROC epoxy_glVertexAttribP1ui;
    PFNGLVERTEXATTRIBP1UIVPROC epoxy_glVertexAttribP1uiv;
    PFNGLVERTEXATTRIBP2UIPROC epoxy_glVertexAttribP2ui;
    PFNGLVERTEXATTRIBP2UIVPROC epoxy_glVertexAttribP2uiv;
    PFNGLVERTEXATTRIBP3UIPROC epoxy_glVertexAttribP3ui;
    PFNGLVERTEXATTRIBP3UIVPROC epoxy_glVertexAttribP3uiv;
    PFNGLVERTEXATTRIBP4UIPROC epoxy_glVertexAttribP4ui;
    PFNGLVERTEXATTRIBP4UIVPROC epoxy_glVertexAttribP4uiv;
    PFNGLVERTEXATTRIBPARAMETERIAMDPROC epoxy_glVertexAttribParameteriAMD;
    PFNGLVERTEXATTRIBPOINTERPROC epoxy_glVertexAttribPointer;
    PFNGLVERTEXATTRIBPOINTERARBPROC epoxy_glVertexAttribPointerARB;
    PFNGLVERTEXATTRIBPOINTERNVPROC epoxy_glVertexAttribPointerNV;
    PFNGLVERTEXATTRIBS1DVNVPROC epoxy_glVertexAttribs1dvNV;
    PFNGLVERTEXATTRIBS1FVNVPROC epoxy_glVertexAttribs1fvNV;
    PFNGLVERTEXATTRIBS1HVNVPROC epoxy_glVertexAttribs1hvNV;
    PFNGLVERTEXATTRIBS1SVNVPROC epoxy_glVertexAttribs1svNV;
    PFNGLVERTEXATTRIBS2DVNVPROC epoxy_glVertexAttribs2dvNV;
    PFNGLVERTEXATTRIBS2FVNVPROC epoxy_glVertexAttribs2fvNV;
    PFNGLVERTEXATTRIBS2HVNVPROC epoxy_glVertexAttribs2hvNV;
    PFNGLVERTEXATTRIBS2SVNVPROC epoxy_glVertexAttribs2svNV;
    PFNGLVERTEXATTRIBS3DVNVPROC epoxy_glVertexAttribs3dvNV;
    PFNGLVERTEXATTRIBS3FVNVPROC epoxy_glVertexAttribs3fvNV;
    PFNGLVERTEXATTRIBS3HVNVPROC epoxy_glVertexAttribs3hvNV;
    PFNGLVERTEXATTRIBS3SVNVPROC epoxy_glVertexAttribs3svNV;
    PFNGLVERTEXATTRIBS4DVNVPROC epoxy_glVertexAttribs4dvNV;
    PFNGLVERTEXATTRIBS4FVNVPROC epoxy_glVertexAttribs4fvNV;
    PFNGLVERTEXATTRIBS4HVNVPROC epoxy_glVertexAttribs4hvNV;
    PFNGLVERTEXATTRIBS4SVNVPROC epoxy_glVertexAttribs4svNV;
    PFNGLVERTEXATTRIBS4UBVNVPROC epoxy_glVertexAttribs4ubvNV;
    PFNGLVERTEXBINDINGDIVISORPROC epoxy_glVertexBindingDivisor;
    PFNGLVERTEXBLENDARBPROC epoxy_glVertexBlendARB;
    PFNGLVERTEXBLENDENVFATIPROC epoxy_glVertexBlendEnvfATI;
    PFNGLVERTEXBLENDENVIATIPROC epoxy_glVertexBlendEnviATI;
    PFNGLVERTEXFORMATNVPROC epoxy_glVertexFormatNV;
    PFNGLVERTEXP2UIPROC epoxy_glVertexP2ui;
    PFNGLVERTEXP2UIVPROC epoxy_glVertexP2uiv;
    PFNGLVERTEXP3UIPROC epoxy_glVertexP3ui;
    PFNGLVERTEXP3UIVPROC epoxy_glVertexP3uiv;
    PFNGLVERTEXP4UIPROC epoxy_glVertexP4ui;
    PFNGLVERTEXP4UIVPROC epoxy_glVertexP4uiv;
    PFNGLVERTEXPOINTERPROC epoxy_glVertexPointer;
    PFNGLVERTEXPOINTEREXTPROC epoxy_glVertexPointerEXT;
    PFNGLVERTEXPOINTERLISTIBMPROC epoxy_glVertexPointerListIBM;
    PFNGLVERTEXPOINTERVINTELPROC epoxy_glVertexPointervINTEL;
    PFNGLVERTEXSTREAM1DATIPROC epoxy_glVertexStream1dATI;
    PFNGLVERTEXSTREAM1DVATIPROC epoxy_glVertexStream1dvATI;
    PFNGLVERTEXSTREAM1FATIPROC epoxy_glVertexStream1fATI;
    PFNGLVERTEXSTREAM1FVATIPROC epoxy_glVertexStream1fvATI;
    PFNGLVERTEXSTREAM1IATIPROC epoxy_glVertexStream1iATI;
    PFNGLVERTEXSTREAM1IVATIPROC epoxy_glVertexStream1ivATI;
    PFNGLVERTEXSTREAM1SATIPROC epoxy_glVertexStream1sATI;
    PFNGLVERTEXSTREAM1SVATIPROC epoxy_glVertexStream1svATI;
    PFNGLVERTEXSTREAM2DATIPROC epoxy_glVertexStream2dATI;
    PFNGLVERTEXSTREAM2DVATIPROC epoxy_glVertexStream2dvATI;
    PFNGLVERTEXSTREAM2FATIPROC epoxy_glVertexStream2fATI;
    PFNGLVERTEXSTREAM2FVATIPROC epoxy_glVertexStream2fvATI;
    PFNGLVERTEXSTREAM2IATIPROC epoxy_glVertexStream2iATI;
    PFNGLVERTEXSTREAM2IVATIPROC epoxy_glVertexStream2ivATI;
    PFNGLVERTEXSTREAM2SATIPROC epoxy_glVertexStream2sATI;
    PFNGLVERTEXSTREAM2SVATIPROC epoxy_glVertexStream2svATI;
    PFNGLVERTEXSTREAM3DATIPROC epoxy_glVertexStream3dATI;
    PFNGLVERTEXSTREAM3DVATIPROC epoxy_glVertexStream3dvATI;
    PFNGLVERTEXSTREAM3FATIPROC epoxy_glVertexStream3fATI;
    PFNGLVERTEXSTREAM3FVATIPROC epoxy_glVertexStream3fvATI;
    PFNGLVERTEXSTREAM3IATIPROC epoxy_glVertexStream3iATI;
    PFNGLVERTEXSTREAM3IVATIPROC epoxy_glVertexStream3ivATI;
    PFNGLVERTEXSTREAM3SATIPROC epoxy_glVertexStream3sATI;
    PFNGLVERTEXSTREAM3SVATIPROC epoxy_glVertexStream3svATI;
    PFNGLVERTEXSTREAM4DATIPROC epoxy_glVertexStream4dATI;
    PFNGLVERTEXSTREAM4DVATIPROC epoxy_glVertexStream4dvATI;
    PFNGLVERTEXSTREAM4FATIPROC epoxy_glVertexStream4fATI;
    PFNGLVERTEXSTREAM4FVATIPROC epoxy_glVertexStream4fvATI;
    PFNGLVERTEXSTREAM4IATIPROC epoxy_glVertexStream4iATI;
    PFNGLVERTEXSTREAM4IVATIPROC epoxy_glVertexStream4ivATI;
    PFNGLVERTEXSTREAM4SATIPROC epoxy_glVertexStream4sATI;
    PFNGLVERTEXSTREAM4SVATIPROC epoxy_glVertexStream4svATI;
    PFNGLVERTEXWEIGHTPOINTEREXTPROC epoxy_glVertexWeightPointerEXT;
    PFNGLVERTEXWEIGHTFEXTPROC epoxy_glVertexWeightfEXT;
    PFNGLVERTEXWEIGHTFVEXTPROC epoxy_glVertexWeightfvEXT;
    PFNGLVERTEXWEIGHTHNVPROC epoxy_glVertexWeighthNV;
    PFNGLVERTEXWEIGHTHVNVPROC epoxy_glVertexWeighthvNV;
    PFNGLVIDEOCAPTURENVPROC epoxy_glVideoCaptureNV;
    PFNGLVIDEOCAPTURESTREAMPARAMETERDVNVPROC epoxy_glVideoCaptureStreamParameterdvNV;
    PFNGLVIDEOCAPTURESTREAMPARAMETERFVNVPROC epoxy_glVideoCaptureStreamParameterfvNV;
    PFNGLVIDEOCAPTURESTREAMPARAMETERIVNVPROC epoxy_glVideoCaptureStreamParameterivNV;
    PFNGLVIEWPORTPROC epoxy_glViewport;
    PFNGLVIEWPORTARRAYVPROC epoxy_glViewportArrayv;
    PFNGLVIEWPORTARRAYVNVPROC epoxy_glViewportArrayvNV;
    PFNGLVIEWPORTINDEXEDFPROC epoxy_glViewportIndexedf;
    PFNGLVIEWPORTINDEXEDFNVPROC epoxy_glViewportIndexedfNV;
    PFNGLVIEWPORTINDEXEDFVPROC epoxy_glViewportIndexedfv;
    PFNGLVIEWPORTINDEXEDFVNVPROC epoxy_glViewportIndexedfvNV;
    PFNGLWAITSYNCPROC epoxy_glWaitSync;
    PFNGLWAITSYNCAPPLEPROC epoxy_glWaitSyncAPPLE;
    PFNGLWEIGHTPATHSNVPROC epoxy_glWeightPathsNV;
    PFNGLWEIGHTPOINTERARBPROC epoxy_glWeightPointerARB;
    PFNGLWEIGHTPOINTEROESPROC epoxy_glWeightPointerOES;
    PFNGLWEIGHTBVARBPROC epoxy_glWeightbvARB;
    PFNGLWEIGHTDVARBPROC epoxy_glWeightdvARB;
    PFNGLWEIGHTFVARBPROC epoxy_glWeightfvARB;
    PFNGLWEIGHTIVARBPROC epoxy_glWeightivARB;
    PFNGLWEIGHTSVARBPROC epoxy_glWeightsvARB;
    PFNGLWEIGHTUBVARBPROC epoxy_glWeightubvARB;
    PFNGLWEIGHTUIVARBPROC epoxy_glWeightuivARB;
    PFNGLWEIGHTUSVARBPROC epoxy_glWeightusvARB;
    PFNGLWINDOWPOS2DPROC epoxy_glWindowPos2d;
    PFNGLWINDOWPOS2DARBPROC epoxy_glWindowPos2dARB;
    PFNGLWINDOWPOS2DMESAPROC epoxy_glWindowPos2dMESA;
    PFNGLWINDOWPOS2DVPROC epoxy_glWindowPos2dv;
    PFNGLWINDOWPOS2DVARBPROC epoxy_glWindowPos2dvARB;
    PFNGLWINDOWPOS2DVMESAPROC epoxy_glWindowPos2dvMESA;
    PFNGLWINDOWPOS2FPROC epoxy_glWindowPos2f;
    PFNGLWINDOWPOS2FARBPROC epoxy_glWindowPos2fARB;
    PFNGLWINDOWPOS2FMESAPROC epoxy_glWindowPos2fMESA;
    PFNGLWINDOWPOS2FVPROC epoxy_glWindowPos2fv;
    PFNGLWINDOWPOS2FVARBPROC epoxy_glWindowPos2fvARB;
    PFNGLWINDOWPOS2FVMESAPROC epoxy_glWindowPos2fvMESA;
    PFNGLWINDOWPOS2IPROC epoxy_glWindowPos2i;
    PFNGLWINDOWPOS2IARBPROC epoxy_glWindowPos2iARB;
    PFNGLWINDOWPOS2IMESAPROC epoxy_glWindowPos2iMESA;
    PFNGLWINDOWPOS2IVPROC epoxy_glWindowPos2iv;
    PFNGLWINDOWPOS2IVARBPROC epoxy_glWindowPos2ivARB;
    PFNGLWINDOWPOS2IVMESAPROC epoxy_glWindowPos2ivMESA;
    PFNGLWINDOWPOS2SPROC epoxy_glWindowPos2s;
    PFNGLWINDOWPOS2SARBPROC epoxy_glWindowPos2sARB;
    PFNGLWINDOWPOS2SMESAPROC epoxy_glWindowPos2sMESA;
    PFNGLWINDOWPOS2SVPROC epoxy_glWindowPos2sv;
    PFNGLWINDOWPOS2SVARBPROC epoxy_glWindowPos2svARB;
    PFNGLWINDOWPOS2SVMESAPROC epoxy_glWindowPos2svMESA;
    PFNGLWINDOWPOS3DPROC epoxy_glWindowPos3d;
    PFNGLWINDOWPOS3DARBPROC epoxy_glWindowPos3dARB;
    PFNGLWINDOWPOS3DMESAPROC epoxy_glWindowPos3dMESA;
    PFNGLWINDOWPOS3DVPROC epoxy_glWindowPos3dv;
    PFNGLWINDOWPOS3DVARBPROC epoxy_glWindowPos3dvARB;
    PFNGLWINDOWPOS3DVMESAPROC epoxy_glWindowPos3dvMESA;
    PFNGLWINDOWPOS3FPROC epoxy_glWindowPos3f;
    PFNGLWINDOWPOS3FARBPROC epoxy_glWindowPos3fARB;
    PFNGLWINDOWPOS3FMESAPROC epoxy_glWindowPos3fMESA;
    PFNGLWINDOWPOS3FVPROC epoxy_glWindowPos3fv;
    PFNGLWINDOWPOS3FVARBPROC epoxy_glWindowPos3fvARB;
    PFNGLWINDOWPOS3FVMESAPROC epoxy_glWindowPos3fvMESA;
    PFNGLWINDOWPOS3IPROC epoxy_glWindowPos3i;
    PFNGLWINDOWPOS3IARBPROC epoxy_glWindowPos3iARB;
    PFNGLWINDOWPOS3IMESAPROC epoxy_glWindowPos3iMESA;
    PFNGLWINDOWPOS3IVPROC epoxy_glWindowPos3iv;
    PFNGLWINDOWPOS3IVARBPROC epoxy_glWindowPos3ivARB;
    PFNGLWINDOWPOS3IVMESAPROC epoxy_glWindowPos3ivMESA;
    PFNGLWINDOWPOS3SPROC epoxy_glWindowPos3s;
    PFNGLWINDOWPOS3SARBPROC epoxy_glWindowPos3sARB;
    PFNGLWINDOWPOS3SMESAPROC epoxy_glWindowPos3sMESA;
    PFNGLWINDOWPOS3SVPROC epoxy_glWindowPos3sv;
    PFNGLWINDOWPOS3SVARBPROC epoxy_glWindowPos3svARB;
    PFNGLWINDOWPOS3SVMESAPROC epoxy_glWindowPos3svMESA;
    PFNGLWINDOWPOS4DMESAPROC epoxy_glWindowPos4dMESA;
    PFNGLWINDOWPOS4DVMESAPROC epoxy_glWindowPos4dvMESA;
    PFNGLWINDOWPOS4FMESAPROC epoxy_glWindowPos4fMESA;
    PFNGLWINDOWPOS4FVMESAPROC epoxy_glWindowPos4fvMESA;
    PFNGLWINDOWPOS4IMESAPROC epoxy_glWindowPos4iMESA;
    PFNGLWINDOWPOS4IVMESAPROC epoxy_glWindowPos4ivMESA;
    PFNGLWINDOWPOS4SMESAPROC epoxy_glWindowPos4sMESA;
    PFNGLWINDOWPOS4SVMESAPROC epoxy_glWindowPos4svMESA;
    PFNGLWRITEMASKEXTPROC epoxy_glWriteMaskEXT;
};

#if USING_DISPATCH_TABLE
static inline struct dispatch_table *
get_dispatch_table(void);

#endif
enum gl_provider {
    gl_provider_terminator = 0,
    Desktop_OpenGL_1_0,
    Desktop_OpenGL_1_1,
    Desktop_OpenGL_1_2,
    Desktop_OpenGL_1_3,
    Desktop_OpenGL_1_4,
    Desktop_OpenGL_1_5,
    Desktop_OpenGL_2_0,
    Desktop_OpenGL_2_1,
    Desktop_OpenGL_3_0,
    Desktop_OpenGL_3_1,
    Desktop_OpenGL_3_2,
    Desktop_OpenGL_3_3,
    Desktop_OpenGL_4_0,
    Desktop_OpenGL_4_1,
    Desktop_OpenGL_4_2,
    Desktop_OpenGL_4_3,
    Desktop_OpenGL_4_4,
    Desktop_OpenGL_4_5,
    GL_extension_GL_3DFX_tbuffer,
    GL_extension_GL_AMD_debug_output,
    GL_extension_GL_AMD_draw_buffers_blend,
    GL_extension_GL_AMD_gpu_shader_int64,
    GL_extension_GL_AMD_interleaved_elements,
    GL_extension_GL_AMD_multi_draw_indirect,
    GL_extension_GL_AMD_name_gen_delete,
    GL_extension_GL_AMD_occlusion_query_event,
    GL_extension_GL_AMD_performance_monitor,
    GL_extension_GL_AMD_sample_positions,
    GL_extension_GL_AMD_sparse_texture,
    GL_extension_GL_AMD_stencil_operation_extended,
    GL_extension_GL_AMD_vertex_shader_tessellator,
    GL_extension_GL_ANGLE_framebuffer_blit,
    GL_extension_GL_ANGLE_framebuffer_multisample,
    GL_extension_GL_ANGLE_instanced_arrays,
    GL_extension_GL_ANGLE_translated_shader_source,
    GL_extension_GL_APPLE_copy_texture_levels,
    GL_extension_GL_APPLE_element_array,
    GL_extension_GL_APPLE_fence,
    GL_extension_GL_APPLE_flush_buffer_range,
    GL_extension_GL_APPLE_framebuffer_multisample,
    GL_extension_GL_APPLE_object_purgeable,
    GL_extension_GL_APPLE_sync,
    GL_extension_GL_APPLE_texture_range,
    GL_extension_GL_APPLE_vertex_array_object,
    GL_extension_GL_APPLE_vertex_array_range,
    GL_extension_GL_APPLE_vertex_program_evaluators,
    GL_extension_GL_ARB_ES2_compatibility,
    GL_extension_GL_ARB_ES3_1_compatibility,
    GL_extension_GL_ARB_base_instance,
    GL_extension_GL_ARB_bindless_texture,
    GL_extension_GL_ARB_blend_func_extended,
    GL_extension_GL_ARB_buffer_storage,
    GL_extension_GL_ARB_cl_event,
    GL_extension_GL_ARB_clear_buffer_object,
    GL_extension_GL_ARB_clear_texture,
    GL_extension_GL_ARB_clip_control,
    GL_extension_GL_ARB_color_buffer_float,
    GL_extension_GL_ARB_compute_shader,
    GL_extension_GL_ARB_compute_variable_group_size,
    GL_extension_GL_ARB_copy_buffer,
    GL_extension_GL_ARB_copy_image,
    GL_extension_GL_ARB_debug_output,
    GL_extension_GL_ARB_direct_state_access,
    GL_extension_GL_ARB_draw_buffers,
    GL_extension_GL_ARB_draw_buffers_blend,
    GL_extension_GL_ARB_draw_elements_base_vertex,
    GL_extension_GL_ARB_draw_indirect,
    GL_extension_GL_ARB_draw_instanced,
    GL_extension_GL_ARB_fragment_program,
    GL_extension_GL_ARB_framebuffer_no_attachments,
    GL_extension_GL_ARB_framebuffer_object,
    GL_extension_GL_ARB_geometry_shader4,
    GL_extension_GL_ARB_get_program_binary,
    GL_extension_GL_ARB_get_texture_sub_image,
    GL_extension_GL_ARB_gpu_shader_fp64,
    GL_extension_GL_ARB_imaging,
    GL_extension_GL_ARB_indirect_parameters,
    GL_extension_GL_ARB_instanced_arrays,
    GL_extension_GL_ARB_internalformat_query2,
    GL_extension_GL_ARB_internalformat_query,
    GL_extension_GL_ARB_invalidate_subdata,
    GL_extension_GL_ARB_map_buffer_range,
    GL_extension_GL_ARB_matrix_palette,
    GL_extension_GL_ARB_multi_bind,
    GL_extension_GL_ARB_multi_draw_indirect,
    GL_extension_GL_ARB_multisample,
    GL_extension_GL_ARB_multitexture,
    GL_extension_GL_ARB_occlusion_query,
    GL_extension_GL_ARB_point_parameters,
    GL_extension_GL_ARB_program_interface_query,
    GL_extension_GL_ARB_provoking_vertex,
    GL_extension_GL_ARB_robustness,
    GL_extension_GL_ARB_sample_shading,
    GL_extension_GL_ARB_sampler_objects,
    GL_extension_GL_ARB_separate_shader_objects,
    GL_extension_GL_ARB_shader_atomic_counters,
    GL_extension_GL_ARB_shader_image_load_store,
    GL_extension_GL_ARB_shader_objects,
    GL_extension_GL_ARB_shader_storage_buffer_object,
    GL_extension_GL_ARB_shader_subroutine,
    GL_extension_GL_ARB_shading_language_include,
    GL_extension_GL_ARB_sparse_buffer,
    GL_extension_GL_ARB_sparse_texture,
    GL_extension_GL_ARB_sync,
    GL_extension_GL_ARB_tessellation_shader,
    GL_extension_GL_ARB_texture_barrier,
    GL_extension_GL_ARB_texture_buffer_object,
    GL_extension_GL_ARB_texture_buffer_range,
    GL_extension_GL_ARB_texture_compression,
    GL_extension_GL_ARB_texture_multisample,
    GL_extension_GL_ARB_texture_storage,
    GL_extension_GL_ARB_texture_storage_multisample,
    GL_extension_GL_ARB_texture_view,
    GL_extension_GL_ARB_timer_query,
    GL_extension_GL_ARB_transform_feedback2,
    GL_extension_GL_ARB_transform_feedback3,
    GL_extension_GL_ARB_transform_feedback_instanced,
    GL_extension_GL_ARB_transpose_matrix,
    GL_extension_GL_ARB_uniform_buffer_object,
    GL_extension_GL_ARB_vertex_array_object,
    GL_extension_GL_ARB_vertex_attrib_64bit,
    GL_extension_GL_ARB_vertex_attrib_binding,
    GL_extension_GL_ARB_vertex_blend,
    GL_extension_GL_ARB_vertex_buffer_object,
    GL_extension_GL_ARB_vertex_program,
    GL_extension_GL_ARB_vertex_shader,
    GL_extension_GL_ARB_vertex_type_2_10_10_10_rev,
    GL_extension_GL_ARB_viewport_array,
    GL_extension_GL_ARB_window_pos,
    GL_extension_GL_ATI_draw_buffers,
    GL_extension_GL_ATI_element_array,
    GL_extension_GL_ATI_envmap_bumpmap,
    GL_extension_GL_ATI_fragment_shader,
    GL_extension_GL_ATI_map_object_buffer,
    GL_extension_GL_ATI_pn_triangles,
    GL_extension_GL_ATI_separate_stencil,
    GL_extension_GL_ATI_vertex_array_object,
    GL_extension_GL_ATI_vertex_attrib_array_object,
    GL_extension_GL_ATI_vertex_streams,
    GL_extension_GL_EXT_base_instance,
    GL_extension_GL_EXT_bindable_uniform,
    GL_extension_GL_EXT_blend_color,
    GL_extension_GL_EXT_blend_equation_separate,
    GL_extension_GL_EXT_blend_func_separate,
    GL_extension_GL_EXT_blend_minmax,
    GL_extension_GL_EXT_buffer_storage,
    GL_extension_GL_EXT_color_subtable,
    GL_extension_GL_EXT_compiled_vertex_array,
    GL_extension_GL_EXT_convolution,
    GL_extension_GL_EXT_coordinate_frame,
    GL_extension_GL_EXT_copy_image,
    GL_extension_GL_EXT_copy_texture,
    GL_extension_GL_EXT_cull_vertex,
    GL_extension_GL_EXT_debug_label,
    GL_extension_GL_EXT_debug_marker,
    GL_extension_GL_EXT_depth_bounds_test,
    GL_extension_GL_EXT_direct_state_access,
    GL_extension_GL_EXT_discard_framebuffer,
    GL_extension_GL_EXT_disjoint_timer_query,
    GL_extension_GL_EXT_draw_buffers2,
    GL_extension_GL_EXT_draw_buffers,
    GL_extension_GL_EXT_draw_buffers_indexed,
    GL_extension_GL_EXT_draw_elements_base_vertex,
    GL_extension_GL_EXT_draw_instanced,
    GL_extension_GL_EXT_draw_range_elements,
    GL_extension_GL_EXT_fog_coord,
    GL_extension_GL_EXT_framebuffer_blit,
    GL_extension_GL_EXT_framebuffer_multisample,
    GL_extension_GL_EXT_framebuffer_object,
    GL_extension_GL_EXT_geometry_shader4,
    GL_extension_GL_EXT_geometry_shader,
    GL_extension_GL_EXT_gpu_program_parameters,
    GL_extension_GL_EXT_gpu_shader4,
    GL_extension_GL_EXT_histogram,
    GL_extension_GL_EXT_index_func,
    GL_extension_GL_EXT_index_material,
    GL_extension_GL_EXT_instanced_arrays,
    GL_extension_GL_EXT_light_texture,
    GL_extension_GL_EXT_map_buffer_range,
    GL_extension_GL_EXT_multi_draw_arrays,
    GL_extension_GL_EXT_multi_draw_indirect,
    GL_extension_GL_EXT_multisample,
    GL_extension_GL_EXT_multisampled_render_to_texture,
    GL_extension_GL_EXT_multiview_draw_buffers,
    GL_extension_GL_EXT_occlusion_query_boolean,
    GL_extension_GL_EXT_paletted_texture,
    GL_extension_GL_EXT_pixel_transform,
    GL_extension_GL_EXT_point_parameters,
    GL_extension_GL_EXT_polygon_offset,
    GL_extension_GL_EXT_polygon_offset_clamp,
    GL_extension_GL_EXT_primitive_bounding_box,
    GL_extension_GL_EXT_provoking_vertex,
    GL_extension_GL_EXT_raster_multisample,
    GL_extension_GL_EXT_robustness,
    GL_extension_GL_EXT_secondary_color,
    GL_extension_GL_EXT_separate_shader_objects,
    GL_extension_GL_EXT_shader_image_load_store,
    GL_extension_GL_EXT_sparse_texture,
    GL_extension_GL_EXT_stencil_clear_tag,
    GL_extension_GL_EXT_stencil_two_side,
    GL_extension_GL_EXT_subtexture,
    GL_extension_GL_EXT_tessellation_shader,
    GL_extension_GL_EXT_texture3D,
    GL_extension_GL_EXT_texture_array,
    GL_extension_GL_EXT_texture_border_clamp,
    GL_extension_GL_EXT_texture_buffer,
    GL_extension_GL_EXT_texture_buffer_object,
    GL_extension_GL_EXT_texture_filter_minmax,
    GL_extension_GL_EXT_texture_integer,
    GL_extension_GL_EXT_texture_object,
    GL_extension_GL_EXT_texture_perturb_normal,
    GL_extension_GL_EXT_texture_storage,
    GL_extension_GL_EXT_texture_view,
    GL_extension_GL_EXT_timer_query,
    GL_extension_GL_EXT_transform_feedback,
    GL_extension_GL_EXT_vertex_array,
    GL_extension_GL_EXT_vertex_attrib_64bit,
    GL_extension_GL_EXT_vertex_shader,
    GL_extension_GL_EXT_vertex_weighting,
    GL_extension_GL_EXT_x11_sync_object,
    GL_extension_GL_GREMEDY_frame_terminator,
    GL_extension_GL_GREMEDY_string_marker,
    GL_extension_GL_HP_image_transform,
    GL_extension_GL_IBM_multimode_draw_arrays,
    GL_extension_GL_IBM_static_data,
    GL_extension_GL_IBM_vertex_array_lists,
    GL_extension_GL_IMG_multisampled_render_to_texture,
    GL_extension_GL_IMG_user_clip_plane,
    GL_extension_GL_INGR_blend_func_separate,
    GL_extension_GL_INTEL_map_texture,
    GL_extension_GL_INTEL_parallel_arrays,
    GL_extension_GL_INTEL_performance_query,
    GL_extension_GL_KHR_blend_equation_advanced,
    GL_extension_GL_KHR_debug,
    GL_extension_GL_KHR_robustness,
    GL_extension_GL_MESA_resize_buffers,
    GL_extension_GL_MESA_window_pos,
    GL_extension_GL_NVX_conditional_render,
    GL_extension_GL_NV_bindless_multi_draw_indirect,
    GL_extension_GL_NV_bindless_multi_draw_indirect_count,
    GL_extension_GL_NV_bindless_texture,
    GL_extension_GL_NV_blend_equation_advanced,
    GL_extension_GL_NV_command_list,
    GL_extension_GL_NV_conditional_render,
    GL_extension_GL_NV_conservative_raster,
    GL_extension_GL_NV_copy_buffer,
    GL_extension_GL_NV_copy_image,
    GL_extension_GL_NV_coverage_sample,
    GL_extension_GL_NV_depth_buffer_float,
    GL_extension_GL_NV_draw_buffers,
    GL_extension_GL_NV_draw_instanced,
    GL_extension_GL_NV_draw_texture,
    GL_extension_GL_NV_evaluators,
    GL_extension_GL_NV_explicit_multisample,
    GL_extension_GL_NV_fence,
    GL_extension_GL_NV_fragment_coverage_to_color,
    GL_extension_GL_NV_fragment_program,
    GL_extension_GL_NV_framebuffer_blit,
    GL_extension_GL_NV_framebuffer_mixed_samples,
    GL_extension_GL_NV_framebuffer_multisample,
    GL_extension_GL_NV_framebuffer_multisample_coverage,
    GL_extension_GL_NV_geometry_program4,
    GL_extension_GL_NV_gpu_program4,
    GL_extension_GL_NV_gpu_program5,
    GL_extension_GL_NV_gpu_shader5,
    GL_extension_GL_NV_half_float,
    GL_extension_GL_NV_instanced_arrays,
    GL_extension_GL_NV_internalformat_sample_query,
    GL_extension_GL_NV_non_square_matrices,
    GL_extension_GL_NV_occlusion_query,
    GL_extension_GL_NV_parameter_buffer_object,
    GL_extension_GL_NV_path_rendering,
    GL_extension_GL_NV_pixel_data_range,
    GL_extension_GL_NV_point_sprite,
    GL_extension_GL_NV_polygon_mode,
    GL_extension_GL_NV_present_video,
    GL_extension_GL_NV_primitive_restart,
    GL_extension_GL_NV_read_buffer,
    GL_extension_GL_NV_register_combiners2,
    GL_extension_GL_NV_register_combiners,
    GL_extension_GL_NV_sample_locations,
    GL_extension_GL_NV_shader_buffer_load,
    GL_extension_GL_NV_texture_barrier,
    GL_extension_GL_NV_texture_multisample,
    GL_extension_GL_NV_transform_feedback2,
    GL_extension_GL_NV_transform_feedback,
    GL_extension_GL_NV_vdpau_interop,
    GL_extension_GL_NV_vertex_array_range,
    GL_extension_GL_NV_vertex_attrib_integer_64bit,
    GL_extension_GL_NV_vertex_buffer_unified_memory,
    GL_extension_GL_NV_vertex_program4,
    GL_extension_GL_NV_vertex_program,
    GL_extension_GL_NV_video_capture,
    GL_extension_GL_NV_viewport_array,
    GL_extension_GL_OES_EGL_image,
    GL_extension_GL_OES_blend_equation_separate,
    GL_extension_GL_OES_blend_func_separate,
    GL_extension_GL_OES_blend_subtract,
    GL_extension_GL_OES_byte_coordinates,
    GL_extension_GL_OES_copy_image,
    GL_extension_GL_OES_draw_buffers_indexed,
    GL_extension_GL_OES_draw_elements_base_vertex,
    GL_extension_GL_OES_draw_texture,
    GL_extension_GL_OES_fixed_point,
    GL_extension_GL_OES_framebuffer_object,
    GL_extension_GL_OES_geometry_shader,
    GL_extension_GL_OES_get_program_binary,
    GL_extension_GL_OES_mapbuffer,
    GL_extension_GL_OES_matrix_palette,
    GL_extension_GL_OES_point_size_array,
    GL_extension_GL_OES_primitive_bounding_box,
    GL_extension_GL_OES_query_matrix,
    GL_extension_GL_OES_sample_shading,
    GL_extension_GL_OES_single_precision,
    GL_extension_GL_OES_tessellation_shader,
    GL_extension_GL_OES_texture_3D,
    GL_extension_GL_OES_texture_border_clamp,
    GL_extension_GL_OES_texture_buffer,
    GL_extension_GL_OES_texture_cube_map,
    GL_extension_GL_OES_texture_storage_multisample_2d_array,
    GL_extension_GL_OES_texture_view,
    GL_extension_GL_OES_vertex_array_object,
    GL_extension_GL_OVR_multiview,
    GL_extension_GL_PGI_misc_hints,
    GL_extension_GL_QCOM_alpha_test,
    GL_extension_GL_QCOM_driver_control,
    GL_extension_GL_QCOM_extended_get2,
    GL_extension_GL_QCOM_extended_get,
    GL_extension_GL_QCOM_tiled_rendering,
    GL_extension_GL_SGIS_detail_texture,
    GL_extension_GL_SGIS_fog_function,
    GL_extension_GL_SGIS_multisample,
    GL_extension_GL_SGIS_pixel_texture,
    GL_extension_GL_SGIS_point_parameters,
    GL_extension_GL_SGIS_sharpen_texture,
    GL_extension_GL_SGIS_texture4D,
    GL_extension_GL_SGIS_texture_color_mask,
    GL_extension_GL_SGIS_texture_filter4,
    GL_extension_GL_SGIX_async,
    GL_extension_GL_SGIX_flush_raster,
    GL_extension_GL_SGIX_fragment_lighting,
    GL_extension_GL_SGIX_framezoom,
    GL_extension_GL_SGIX_igloo_interface,
    GL_extension_GL_SGIX_instruments,
    GL_extension_GL_SGIX_list_priority,
    GL_extension_GL_SGIX_pixel_texture,
    GL_extension_GL_SGIX_polynomial_ffd,
    GL_extension_GL_SGIX_reference_plane,
    GL_extension_GL_SGIX_sprite,
    GL_extension_GL_SGIX_tag_sample_buffer,
    GL_extension_GL_SGI_color_table,
    GL_extension_GL_SUNX_constant_data,
    GL_extension_GL_SUN_global_alpha,
    GL_extension_GL_SUN_mesh_array,
    GL_extension_GL_SUN_triangle_list,
    GL_extension_GL_SUN_vertex,
    OpenGL_ES_1_0,
    OpenGL_ES_2_0,
    OpenGL_ES_3_0,
    OpenGL_ES_3_1,
    always_present,
} PACKED;

static const char *enum_string =
    "Desktop OpenGL 1.0\0"
    "Desktop OpenGL 1.1\0"
    "Desktop OpenGL 1.2\0"
    "Desktop OpenGL 1.3\0"
    "Desktop OpenGL 1.4\0"
    "Desktop OpenGL 1.5\0"
    "Desktop OpenGL 2.0\0"
    "Desktop OpenGL 2.1\0"
    "Desktop OpenGL 3.0\0"
    "Desktop OpenGL 3.1\0"
    "Desktop OpenGL 3.2\0"
    "Desktop OpenGL 3.3\0"
    "Desktop OpenGL 4.0\0"
    "Desktop OpenGL 4.1\0"
    "Desktop OpenGL 4.2\0"
    "Desktop OpenGL 4.3\0"
    "Desktop OpenGL 4.4\0"
    "Desktop OpenGL 4.5\0"
    "GL extension \"GL_3DFX_tbuffer\"\0"
    "GL extension \"GL_AMD_debug_output\"\0"
    "GL extension \"GL_AMD_draw_buffers_blend\"\0"
    "GL extension \"GL_AMD_gpu_shader_int64\"\0"
    "GL extension \"GL_AMD_interleaved_elements\"\0"
    "GL extension \"GL_AMD_multi_draw_indirect\"\0"
    "GL extension \"GL_AMD_name_gen_delete\"\0"
    "GL extension \"GL_AMD_occlusion_query_event\"\0"
    "GL extension \"GL_AMD_performance_monitor\"\0"
    "GL extension \"GL_AMD_sample_positions\"\0"
    "GL extension \"GL_AMD_sparse_texture\"\0"
    "GL extension \"GL_AMD_stencil_operation_extended\"\0"
    "GL extension \"GL_AMD_vertex_shader_tessellator\"\0"
    "GL extension \"GL_ANGLE_framebuffer_blit\"\0"
    "GL extension \"GL_ANGLE_framebuffer_multisample\"\0"
    "GL extension \"GL_ANGLE_instanced_arrays\"\0"
    "GL extension \"GL_ANGLE_translated_shader_source\"\0"
    "GL extension \"GL_APPLE_copy_texture_levels\"\0"
    "GL extension \"GL_APPLE_element_array\"\0"
    "GL extension \"GL_APPLE_fence\"\0"
    "GL extension \"GL_APPLE_flush_buffer_range\"\0"
    "GL extension \"GL_APPLE_framebuffer_multisample\"\0"
    "GL extension \"GL_APPLE_object_purgeable\"\0"
    "GL extension \"GL_APPLE_sync\"\0"
    "GL extension \"GL_APPLE_texture_range\"\0"
    "GL extension \"GL_APPLE_vertex_array_object\"\0"
    "GL extension \"GL_APPLE_vertex_array_range\"\0"
    "GL extension \"GL_APPLE_vertex_program_evaluators\"\0"
    "GL extension \"GL_ARB_ES2_compatibility\"\0"
    "GL extension \"GL_ARB_ES3_1_compatibility\"\0"
    "GL extension \"GL_ARB_base_instance\"\0"
    "GL extension \"GL_ARB_bindless_texture\"\0"
    "GL extension \"GL_ARB_blend_func_extended\"\0"
    "GL extension \"GL_ARB_buffer_storage\"\0"
    "GL extension \"GL_ARB_cl_event\"\0"
    "GL extension \"GL_ARB_clear_buffer_object\"\0"
    "GL extension \"GL_ARB_clear_texture\"\0"
    "GL extension \"GL_ARB_clip_control\"\0"
    "GL extension \"GL_ARB_color_buffer_float\"\0"
    "GL extension \"GL_ARB_compute_shader\"\0"
    "GL extension \"GL_ARB_compute_variable_group_size\"\0"
    "GL extension \"GL_ARB_copy_buffer\"\0"
    "GL extension \"GL_ARB_copy_image\"\0"
    "GL extension \"GL_ARB_debug_output\"\0"
    "GL extension \"GL_ARB_direct_state_access\"\0"
    "GL extension \"GL_ARB_draw_buffers\"\0"
    "GL extension \"GL_ARB_draw_buffers_blend\"\0"
    "GL extension \"GL_ARB_draw_elements_base_vertex\"\0"
    "GL extension \"GL_ARB_draw_indirect\"\0"
    "GL extension \"GL_ARB_draw_instanced\"\0"
    "GL extension \"GL_ARB_fragment_program\"\0"
    "GL extension \"GL_ARB_framebuffer_no_attachments\"\0"
    "GL extension \"GL_ARB_framebuffer_object\"\0"
    "GL extension \"GL_ARB_geometry_shader4\"\0"
    "GL extension \"GL_ARB_get_program_binary\"\0"
    "GL extension \"GL_ARB_get_texture_sub_image\"\0"
    "GL extension \"GL_ARB_gpu_shader_fp64\"\0"
    "GL extension \"GL_ARB_imaging\"\0"
    "GL extension \"GL_ARB_indirect_parameters\"\0"
    "GL extension \"GL_ARB_instanced_arrays\"\0"
    "GL extension \"GL_ARB_internalformat_query2\"\0"
    "GL extension \"GL_ARB_internalformat_query\"\0"
    "GL extension \"GL_ARB_invalidate_subdata\"\0"
    "GL extension \"GL_ARB_map_buffer_range\"\0"
    "GL extension \"GL_ARB_matrix_palette\"\0"
    "GL extension \"GL_ARB_multi_bind\"\0"
    "GL extension \"GL_ARB_multi_draw_indirect\"\0"
    "GL extension \"GL_ARB_multisample\"\0"
    "GL extension \"GL_ARB_multitexture\"\0"
    "GL extension \"GL_ARB_occlusion_query\"\0"
    "GL extension \"GL_ARB_point_parameters\"\0"
    "GL extension \"GL_ARB_program_interface_query\"\0"
    "GL extension \"GL_ARB_provoking_vertex\"\0"
    "GL extension \"GL_ARB_robustness\"\0"
    "GL extension \"GL_ARB_sample_shading\"\0"
    "GL extension \"GL_ARB_sampler_objects\"\0"
    "GL extension \"GL_ARB_separate_shader_objects\"\0"
    "GL extension \"GL_ARB_shader_atomic_counters\"\0"
    "GL extension \"GL_ARB_shader_image_load_store\"\0"
    "GL extension \"GL_ARB_shader_objects\"\0"
    "GL extension \"GL_ARB_shader_storage_buffer_object\"\0"
    "GL extension \"GL_ARB_shader_subroutine\"\0"
    "GL extension \"GL_ARB_shading_language_include\"\0"
    "GL extension \"GL_ARB_sparse_buffer\"\0"
    "GL extension \"GL_ARB_sparse_texture\"\0"
    "GL extension \"GL_ARB_sync\"\0"
    "GL extension \"GL_ARB_tessellation_shader\"\0"
    "GL extension \"GL_ARB_texture_barrier\"\0"
    "GL extension \"GL_ARB_texture_buffer_object\"\0"
    "GL extension \"GL_ARB_texture_buffer_range\"\0"
    "GL extension \"GL_ARB_texture_compression\"\0"
    "GL extension \"GL_ARB_texture_multisample\"\0"
    "GL extension \"GL_ARB_texture_storage\"\0"
    "GL extension \"GL_ARB_texture_storage_multisample\"\0"
    "GL extension \"GL_ARB_texture_view\"\0"
    "GL extension \"GL_ARB_timer_query\"\0"
    "GL extension \"GL_ARB_transform_feedback2\"\0"
    "GL extension \"GL_ARB_transform_feedback3\"\0"
    "GL extension \"GL_ARB_transform_feedback_instanced\"\0"
    "GL extension \"GL_ARB_transpose_matrix\"\0"
    "GL extension \"GL_ARB_uniform_buffer_object\"\0"
    "GL extension \"GL_ARB_vertex_array_object\"\0"
    "GL extension \"GL_ARB_vertex_attrib_64bit\"\0"
    "GL extension \"GL_ARB_vertex_attrib_binding\"\0"
    "GL extension \"GL_ARB_vertex_blend\"\0"
    "GL extension \"GL_ARB_vertex_buffer_object\"\0"
    "GL extension \"GL_ARB_vertex_program\"\0"
    "GL extension \"GL_ARB_vertex_shader\"\0"
    "GL extension \"GL_ARB_vertex_type_2_10_10_10_rev\"\0"
    "GL extension \"GL_ARB_viewport_array\"\0"
    "GL extension \"GL_ARB_window_pos\"\0"
    "GL extension \"GL_ATI_draw_buffers\"\0"
    "GL extension \"GL_ATI_element_array\"\0"
    "GL extension \"GL_ATI_envmap_bumpmap\"\0"
    "GL extension \"GL_ATI_fragment_shader\"\0"
    "GL extension \"GL_ATI_map_object_buffer\"\0"
    "GL extension \"GL_ATI_pn_triangles\"\0"
    "GL extension \"GL_ATI_separate_stencil\"\0"
    "GL extension \"GL_ATI_vertex_array_object\"\0"
    "GL extension \"GL_ATI_vertex_attrib_array_object\"\0"
    "GL extension \"GL_ATI_vertex_streams\"\0"
    "GL extension \"GL_EXT_base_instance\"\0"
    "GL extension \"GL_EXT_bindable_uniform\"\0"
    "GL extension \"GL_EXT_blend_color\"\0"
    "GL extension \"GL_EXT_blend_equation_separate\"\0"
    "GL extension \"GL_EXT_blend_func_separate\"\0"
    "GL extension \"GL_EXT_blend_minmax\"\0"
    "GL extension \"GL_EXT_buffer_storage\"\0"
    "GL extension \"GL_EXT_color_subtable\"\0"
    "GL extension \"GL_EXT_compiled_vertex_array\"\0"
    "GL extension \"GL_EXT_convolution\"\0"
    "GL extension \"GL_EXT_coordinate_frame\"\0"
    "GL extension \"GL_EXT_copy_image\"\0"
    "GL extension \"GL_EXT_copy_texture\"\0"
    "GL extension \"GL_EXT_cull_vertex\"\0"
    "GL extension \"GL_EXT_debug_label\"\0"
    "GL extension \"GL_EXT_debug_marker\"\0"
    "GL extension \"GL_EXT_depth_bounds_test\"\0"
    "GL extension \"GL_EXT_direct_state_access\"\0"
    "GL extension \"GL_EXT_discard_framebuffer\"\0"
    "GL extension \"GL_EXT_disjoint_timer_query\"\0"
    "GL extension \"GL_EXT_draw_buffers2\"\0"
    "GL extension \"GL_EXT_draw_buffers\"\0"
    "GL extension \"GL_EXT_draw_buffers_indexed\"\0"
    "GL extension \"GL_EXT_draw_elements_base_vertex\"\0"
    "GL extension \"GL_EXT_draw_instanced\"\0"
    "GL extension \"GL_EXT_draw_range_elements\"\0"
    "GL extension \"GL_EXT_fog_coord\"\0"
    "GL extension \"GL_EXT_framebuffer_blit\"\0"
    "GL extension \"GL_EXT_framebuffer_multisample\"\0"
    "GL extension \"GL_EXT_framebuffer_object\"\0"
    "GL extension \"GL_EXT_geometry_shader4\"\0"
    "GL extension \"GL_EXT_geometry_shader\"\0"
    "GL extension \"GL_EXT_gpu_program_parameters\"\0"
    "GL extension \"GL_EXT_gpu_shader4\"\0"
    "GL extension \"GL_EXT_histogram\"\0"
    "GL extension \"GL_EXT_index_func\"\0"
    "GL extension \"GL_EXT_index_material\"\0"
    "GL extension \"GL_EXT_instanced_arrays\"\0"
    "GL extension \"GL_EXT_light_texture\"\0"
    "GL extension \"GL_EXT_map_buffer_range\"\0"
    "GL extension \"GL_EXT_multi_draw_arrays\"\0"
    "GL extension \"GL_EXT_multi_draw_indirect\"\0"
    "GL extension \"GL_EXT_multisample\"\0"
    "GL extension \"GL_EXT_multisampled_render_to_texture\"\0"
    "GL extension \"GL_EXT_multiview_draw_buffers\"\0"
    "GL extension \"GL_EXT_occlusion_query_boolean\"\0"
    "GL extension \"GL_EXT_paletted_texture\"\0"
    "GL extension \"GL_EXT_pixel_transform\"\0"
    "GL extension \"GL_EXT_point_parameters\"\0"
    "GL extension \"GL_EXT_polygon_offset\"\0"
    "GL extension \"GL_EXT_polygon_offset_clamp\"\0"
    "GL extension \"GL_EXT_primitive_bounding_box\"\0"
    "GL extension \"GL_EXT_provoking_vertex\"\0"
    "GL extension \"GL_EXT_raster_multisample\"\0"
    "GL extension \"GL_EXT_robustness\"\0"
    "GL extension \"GL_EXT_secondary_color\"\0"
    "GL extension \"GL_EXT_separate_shader_objects\"\0"
    "GL extension \"GL_EXT_shader_image_load_store\"\0"
    "GL extension \"GL_EXT_sparse_texture\"\0"
    "GL extension \"GL_EXT_stencil_clear_tag\"\0"
    "GL extension \"GL_EXT_stencil_two_side\"\0"
    "GL extension \"GL_EXT_subtexture\"\0"
    "GL extension \"GL_EXT_tessellation_shader\"\0"
    "GL extension \"GL_EXT_texture3D\"\0"
    "GL extension \"GL_EXT_texture_array\"\0"
    "GL extension \"GL_EXT_texture_border_clamp\"\0"
    "GL extension \"GL_EXT_texture_buffer\"\0"
    "GL extension \"GL_EXT_texture_buffer_object\"\0"
    "GL extension \"GL_EXT_texture_filter_minmax\"\0"
    "GL extension \"GL_EXT_texture_integer\"\0"
    "GL extension \"GL_EXT_texture_object\"\0"
    "GL extension \"GL_EXT_texture_perturb_normal\"\0"
    "GL extension \"GL_EXT_texture_storage\"\0"
    "GL extension \"GL_EXT_texture_view\"\0"
    "GL extension \"GL_EXT_timer_query\"\0"
    "GL extension \"GL_EXT_transform_feedback\"\0"
    "GL extension \"GL_EXT_vertex_array\"\0"
    "GL extension \"GL_EXT_vertex_attrib_64bit\"\0"
    "GL extension \"GL_EXT_vertex_shader\"\0"
    "GL extension \"GL_EXT_vertex_weighting\"\0"
    "GL extension \"GL_EXT_x11_sync_object\"\0"
    "GL extension \"GL_GREMEDY_frame_terminator\"\0"
    "GL extension \"GL_GREMEDY_string_marker\"\0"
    "GL extension \"GL_HP_image_transform\"\0"
    "GL extension \"GL_IBM_multimode_draw_arrays\"\0"
    "GL extension \"GL_IBM_static_data\"\0"
    "GL extension \"GL_IBM_vertex_array_lists\"\0"
    "GL extension \"GL_IMG_multisampled_render_to_texture\"\0"
    "GL extension \"GL_IMG_user_clip_plane\"\0"
    "GL extension \"GL_INGR_blend_func_separate\"\0"
    "GL extension \"GL_INTEL_map_texture\"\0"
    "GL extension \"GL_INTEL_parallel_arrays\"\0"
    "GL extension \"GL_INTEL_performance_query\"\0"
    "GL extension \"GL_KHR_blend_equation_advanced\"\0"
    "GL extension \"GL_KHR_debug\"\0"
    "GL extension \"GL_KHR_robustness\"\0"
    "GL extension \"GL_MESA_resize_buffers\"\0"
    "GL extension \"GL_MESA_window_pos\"\0"
    "GL extension \"GL_NVX_conditional_render\"\0"
    "GL extension \"GL_NV_bindless_multi_draw_indirect\"\0"
    "GL extension \"GL_NV_bindless_multi_draw_indirect_count\"\0"
    "GL extension \"GL_NV_bindless_texture\"\0"
    "GL extension \"GL_NV_blend_equation_advanced\"\0"
    "GL extension \"GL_NV_command_list\"\0"
    "GL extension \"GL_NV_conditional_render\"\0"
    "GL extension \"GL_NV_conservative_raster\"\0"
    "GL extension \"GL_NV_copy_buffer\"\0"
    "GL extension \"GL_NV_copy_image\"\0"
    "GL extension \"GL_NV_coverage_sample\"\0"
    "GL extension \"GL_NV_depth_buffer_float\"\0"
    "GL extension \"GL_NV_draw_buffers\"\0"
    "GL extension \"GL_NV_draw_instanced\"\0"
    "GL extension \"GL_NV_draw_texture\"\0"
    "GL extension \"GL_NV_evaluators\"\0"
    "GL extension \"GL_NV_explicit_multisample\"\0"
    "GL extension \"GL_NV_fence\"\0"
    "GL extension \"GL_NV_fragment_coverage_to_color\"\0"
    "GL extension \"GL_NV_fragment_program\"\0"
    "GL extension \"GL_NV_framebuffer_blit\"\0"
    "GL extension \"GL_NV_framebuffer_mixed_samples\"\0"
    "GL extension \"GL_NV_framebuffer_multisample\"\0"
    "GL extension \"GL_NV_framebuffer_multisample_coverage\"\0"
    "GL extension \"GL_NV_geometry_program4\"\0"
    "GL extension \"GL_NV_gpu_program4\"\0"
    "GL extension \"GL_NV_gpu_program5\"\0"
    "GL extension \"GL_NV_gpu_shader5\"\0"
    "GL extension \"GL_NV_half_float\"\0"
    "GL extension \"GL_NV_instanced_arrays\"\0"
    "GL extension \"GL_NV_internalformat_sample_query\"\0"
    "GL extension \"GL_NV_non_square_matrices\"\0"
    "GL extension \"GL_NV_occlusion_query\"\0"
    "GL extension \"GL_NV_parameter_buffer_object\"\0"
    "GL extension \"GL_NV_path_rendering\"\0"
    "GL extension \"GL_NV_pixel_data_range\"\0"
    "GL extension \"GL_NV_point_sprite\"\0"
    "GL extension \"GL_NV_polygon_mode\"\0"
    "GL extension \"GL_NV_present_video\"\0"
    "GL extension \"GL_NV_primitive_restart\"\0"
    "GL extension \"GL_NV_read_buffer\"\0"
    "GL extension \"GL_NV_register_combiners2\"\0"
    "GL extension \"GL_NV_register_combiners\"\0"
    "GL extension \"GL_NV_sample_locations\"\0"
    "GL extension \"GL_NV_shader_buffer_load\"\0"
    "GL extension \"GL_NV_texture_barrier\"\0"
    "GL extension \"GL_NV_texture_multisample\"\0"
    "GL extension \"GL_NV_transform_feedback2\"\0"
    "GL extension \"GL_NV_transform_feedback\"\0"
    "GL extension \"GL_NV_vdpau_interop\"\0"
    "GL extension \"GL_NV_vertex_array_range\"\0"
    "GL extension \"GL_NV_vertex_attrib_integer_64bit\"\0"
    "GL extension \"GL_NV_vertex_buffer_unified_memory\"\0"
    "GL extension \"GL_NV_vertex_program4\"\0"
    "GL extension \"GL_NV_vertex_program\"\0"
    "GL extension \"GL_NV_video_capture\"\0"
    "GL extension \"GL_NV_viewport_array\"\0"
    "GL extension \"GL_OES_EGL_image\"\0"
    "GL extension \"GL_OES_blend_equation_separate\"\0"
    "GL extension \"GL_OES_blend_func_separate\"\0"
    "GL extension \"GL_OES_blend_subtract\"\0"
    "GL extension \"GL_OES_byte_coordinates\"\0"
    "GL extension \"GL_OES_copy_image\"\0"
    "GL extension \"GL_OES_draw_buffers_indexed\"\0"
    "GL extension \"GL_OES_draw_elements_base_vertex\"\0"
    "GL extension \"GL_OES_draw_texture\"\0"
    "GL extension \"GL_OES_fixed_point\"\0"
    "GL extension \"GL_OES_framebuffer_object\"\0"
    "GL extension \"GL_OES_geometry_shader\"\0"
    "GL extension \"GL_OES_get_program_binary\"\0"
    "GL extension \"GL_OES_mapbuffer\"\0"
    "GL extension \"GL_OES_matrix_palette\"\0"
    "GL extension \"GL_OES_point_size_array\"\0"
    "GL extension \"GL_OES_primitive_bounding_box\"\0"
    "GL extension \"GL_OES_query_matrix\"\0"
    "GL extension \"GL_OES_sample_shading\"\0"
    "GL extension \"GL_OES_single_precision\"\0"
    "GL extension \"GL_OES_tessellation_shader\"\0"
    "GL extension \"GL_OES_texture_3D\"\0"
    "GL extension \"GL_OES_texture_border_clamp\"\0"
    "GL extension \"GL_OES_texture_buffer\"\0"
    "GL extension \"GL_OES_texture_cube_map\"\0"
    "GL extension \"GL_OES_texture_storage_multisample_2d_array\"\0"
    "GL extension \"GL_OES_texture_view\"\0"
    "GL extension \"GL_OES_vertex_array_object\"\0"
    "GL extension \"GL_OVR_multiview\"\0"
    "GL extension \"GL_PGI_misc_hints\"\0"
    "GL extension \"GL_QCOM_alpha_test\"\0"
    "GL extension \"GL_QCOM_driver_control\"\0"
    "GL extension \"GL_QCOM_extended_get2\"\0"
    "GL extension \"GL_QCOM_extended_get\"\0"
    "GL extension \"GL_QCOM_tiled_rendering\"\0"
    "GL extension \"GL_SGIS_detail_texture\"\0"
    "GL extension \"GL_SGIS_fog_function\"\0"
    "GL extension \"GL_SGIS_multisample\"\0"
    "GL extension \"GL_SGIS_pixel_texture\"\0"
    "GL extension \"GL_SGIS_point_parameters\"\0"
    "GL extension \"GL_SGIS_sharpen_texture\"\0"
    "GL extension \"GL_SGIS_texture4D\"\0"
    "GL extension \"GL_SGIS_texture_color_mask\"\0"
    "GL extension \"GL_SGIS_texture_filter4\"\0"
    "GL extension \"GL_SGIX_async\"\0"
    "GL extension \"GL_SGIX_flush_raster\"\0"
    "GL extension \"GL_SGIX_fragment_lighting\"\0"
    "GL extension \"GL_SGIX_framezoom\"\0"
    "GL extension \"GL_SGIX_igloo_interface\"\0"
    "GL extension \"GL_SGIX_instruments\"\0"
    "GL extension \"GL_SGIX_list_priority\"\0"
    "GL extension \"GL_SGIX_pixel_texture\"\0"
    "GL extension \"GL_SGIX_polynomial_ffd\"\0"
    "GL extension \"GL_SGIX_reference_plane\"\0"
    "GL extension \"GL_SGIX_sprite\"\0"
    "GL extension \"GL_SGIX_tag_sample_buffer\"\0"
    "GL extension \"GL_SGI_color_table\"\0"
    "GL extension \"GL_SUNX_constant_data\"\0"
    "GL extension \"GL_SUN_global_alpha\"\0"
    "GL extension \"GL_SUN_mesh_array\"\0"
    "GL extension \"GL_SUN_triangle_list\"\0"
    "GL extension \"GL_SUN_vertex\"\0"
    "OpenGL ES 1.0\0"
    "OpenGL ES 2.0\0"
    "OpenGL ES 3.0\0"
    "OpenGL ES 3.1\0"
    "always present\0"
     ;

static const uint16_t enum_string_offsets[] = {
    [Desktop_OpenGL_1_0] = 0,
    [Desktop_OpenGL_1_1] = 19,
    [Desktop_OpenGL_1_2] = 38,
    [Desktop_OpenGL_1_3] = 57,
    [Desktop_OpenGL_1_4] = 76,
    [Desktop_OpenGL_1_5] = 95,
    [Desktop_OpenGL_2_0] = 114,
    [Desktop_OpenGL_2_1] = 133,
    [Desktop_OpenGL_3_0] = 152,
    [Desktop_OpenGL_3_1] = 171,
    [Desktop_OpenGL_3_2] = 190,
    [Desktop_OpenGL_3_3] = 209,
    [Desktop_OpenGL_4_0] = 228,
    [Desktop_OpenGL_4_1] = 247,
    [Desktop_OpenGL_4_2] = 266,
    [Desktop_OpenGL_4_3] = 285,
    [Desktop_OpenGL_4_4] = 304,
    [Desktop_OpenGL_4_5] = 323,
    [GL_extension_GL_3DFX_tbuffer] = 342,
    [GL_extension_GL_AMD_debug_output] = 373,
    [GL_extension_GL_AMD_draw_buffers_blend] = 408,
    [GL_extension_GL_AMD_gpu_shader_int64] = 449,
    [GL_extension_GL_AMD_interleaved_elements] = 488,
    [GL_extension_GL_AMD_multi_draw_indirect] = 531,
    [GL_extension_GL_AMD_name_gen_delete] = 573,
    [GL_extension_GL_AMD_occlusion_query_event] = 611,
    [GL_extension_GL_AMD_performance_monitor] = 655,
    [GL_extension_GL_AMD_sample_positions] = 697,
    [GL_extension_GL_AMD_sparse_texture] = 736,
    [GL_extension_GL_AMD_stencil_operation_extended] = 773,
    [GL_extension_GL_AMD_vertex_shader_tessellator] = 822,
    [GL_extension_GL_ANGLE_framebuffer_blit] = 870,
    [GL_extension_GL_ANGLE_framebuffer_multisample] = 911,
    [GL_extension_GL_ANGLE_instanced_arrays] = 959,
    [GL_extension_GL_ANGLE_translated_shader_source] = 1000,
    [GL_extension_GL_APPLE_copy_texture_levels] = 1049,
    [GL_extension_GL_APPLE_element_array] = 1093,
    [GL_extension_GL_APPLE_fence] = 1131,
    [GL_extension_GL_APPLE_flush_buffer_range] = 1161,
    [GL_extension_GL_APPLE_framebuffer_multisample] = 1204,
    [GL_extension_GL_APPLE_object_purgeable] = 1252,
    [GL_extension_GL_APPLE_sync] = 1293,
    [GL_extension_GL_APPLE_texture_range] = 1322,
    [GL_extension_GL_APPLE_vertex_array_object] = 1360,
    [GL_extension_GL_APPLE_vertex_array_range] = 1404,
    [GL_extension_GL_APPLE_vertex_program_evaluators] = 1447,
    [GL_extension_GL_ARB_ES2_compatibility] = 1497,
    [GL_extension_GL_ARB_ES3_1_compatibility] = 1537,
    [GL_extension_GL_ARB_base_instance] = 1579,
    [GL_extension_GL_ARB_bindless_texture] = 1615,
    [GL_extension_GL_ARB_blend_func_extended] = 1654,
    [GL_extension_GL_ARB_buffer_storage] = 1696,
    [GL_extension_GL_ARB_cl_event] = 1733,
    [GL_extension_GL_ARB_clear_buffer_object] = 1764,
    [GL_extension_GL_ARB_clear_texture] = 1806,
    [GL_extension_GL_ARB_clip_control] = 1842,
    [GL_extension_GL_ARB_color_buffer_float] = 1877,
    [GL_extension_GL_ARB_compute_shader] = 1918,
    [GL_extension_GL_ARB_compute_variable_group_size] = 1955,
    [GL_extension_GL_ARB_copy_buffer] = 2005,
    [GL_extension_GL_ARB_copy_image] = 2039,
    [GL_extension_GL_ARB_debug_output] = 2072,
    [GL_extension_GL_ARB_direct_state_access] = 2107,
    [GL_extension_GL_ARB_draw_buffers] = 2149,
    [GL_extension_GL_ARB_draw_buffers_blend] = 2184,
    [GL_extension_GL_ARB_draw_elements_base_vertex] = 2225,
    [GL_extension_GL_ARB_draw_indirect] = 2273,
    [GL_extension_GL_ARB_draw_instanced] = 2309,
    [GL_extension_GL_ARB_fragment_program] = 2346,
    [GL_extension_GL_ARB_framebuffer_no_attachments] = 2385,
    [GL_extension_GL_ARB_framebuffer_object] = 2434,
    [GL_extension_GL_ARB_geometry_shader4] = 2475,
    [GL_extension_GL_ARB_get_program_binary] = 2514,
    [GL_extension_GL_ARB_get_texture_sub_image] = 2555,
    [GL_extension_GL_ARB_gpu_shader_fp64] = 2599,
    [GL_extension_GL_ARB_imaging] = 2637,
    [GL_extension_GL_ARB_indirect_parameters] = 2667,
    [GL_extension_GL_ARB_instanced_arrays] = 2709,
    [GL_extension_GL_ARB_internalformat_query2] = 2748,
    [GL_extension_GL_ARB_internalformat_query] = 2792,
    [GL_extension_GL_ARB_invalidate_subdata] = 2835,
    [GL_extension_GL_ARB_map_buffer_range] = 2876,
    [GL_extension_GL_ARB_matrix_palette] = 2915,
    [GL_extension_GL_ARB_multi_bind] = 2952,
    [GL_extension_GL_ARB_multi_draw_indirect] = 2985,
    [GL_extension_GL_ARB_multisample] = 3027,
    [GL_extension_GL_ARB_multitexture] = 3061,
    [GL_extension_GL_ARB_occlusion_query] = 3096,
    [GL_extension_GL_ARB_point_parameters] = 3134,
    [GL_extension_GL_ARB_program_interface_query] = 3173,
    [GL_extension_GL_ARB_provoking_vertex] = 3219,
    [GL_extension_GL_ARB_robustness] = 3258,
    [GL_extension_GL_ARB_sample_shading] = 3291,
    [GL_extension_GL_ARB_sampler_objects] = 3328,
    [GL_extension_GL_ARB_separate_shader_objects] = 3366,
    [GL_extension_GL_ARB_shader_atomic_counters] = 3412,
    [GL_extension_GL_ARB_shader_image_load_store] = 3457,
    [GL_extension_GL_ARB_shader_objects] = 3503,
    [GL_extension_GL_ARB_shader_storage_buffer_object] = 3540,
    [GL_extension_GL_ARB_shader_subroutine] = 3591,
    [GL_extension_GL_ARB_shading_language_include] = 3631,
    [GL_extension_GL_ARB_sparse_buffer] = 3678,
    [GL_extension_GL_ARB_sparse_texture] = 3714,
    [GL_extension_GL_ARB_sync] = 3751,
    [GL_extension_GL_ARB_tessellation_shader] = 3778,
    [GL_extension_GL_ARB_texture_barrier] = 3820,
    [GL_extension_GL_ARB_texture_buffer_object] = 3858,
    [GL_extension_GL_ARB_texture_buffer_range] = 3902,
    [GL_extension_GL_ARB_texture_compression] = 3945,
    [GL_extension_GL_ARB_texture_multisample] = 3987,
    [GL_extension_GL_ARB_texture_storage] = 4029,
    [GL_extension_GL_ARB_texture_storage_multisample] = 4067,
    [GL_extension_GL_ARB_texture_view] = 4117,
    [GL_extension_GL_ARB_timer_query] = 4152,
    [GL_extension_GL_ARB_transform_feedback2] = 4186,
    [GL_extension_GL_ARB_transform_feedback3] = 4228,
    [GL_extension_GL_ARB_transform_feedback_instanced] = 4270,
    [GL_extension_GL_ARB_transpose_matrix] = 4321,
    [GL_extension_GL_ARB_uniform_buffer_object] = 4360,
    [GL_extension_GL_ARB_vertex_array_object] = 4404,
    [GL_extension_GL_ARB_vertex_attrib_64bit] = 4446,
    [GL_extension_GL_ARB_vertex_attrib_binding] = 4488,
    [GL_extension_GL_ARB_vertex_blend] = 4532,
    [GL_extension_GL_ARB_vertex_buffer_object] = 4567,
    [GL_extension_GL_ARB_vertex_program] = 4610,
    [GL_extension_GL_ARB_vertex_shader] = 4647,
    [GL_extension_GL_ARB_vertex_type_2_10_10_10_rev] = 4683,
    [GL_extension_GL_ARB_viewport_array] = 4732,
    [GL_extension_GL_ARB_window_pos] = 4769,
    [GL_extension_GL_ATI_draw_buffers] = 4802,
    [GL_extension_GL_ATI_element_array] = 4837,
    [GL_extension_GL_ATI_envmap_bumpmap] = 4873,
    [GL_extension_GL_ATI_fragment_shader] = 4910,
    [GL_extension_GL_ATI_map_object_buffer] = 4948,
    [GL_extension_GL_ATI_pn_triangles] = 4988,
    [GL_extension_GL_ATI_separate_stencil] = 5023,
    [GL_extension_GL_ATI_vertex_array_object] = 5062,
    [GL_extension_GL_ATI_vertex_attrib_array_object] = 5104,
    [GL_extension_GL_ATI_vertex_streams] = 5153,
    [GL_extension_GL_EXT_base_instance] = 5190,
    [GL_extension_GL_EXT_bindable_uniform] = 5226,
    [GL_extension_GL_EXT_blend_color] = 5265,
    [GL_extension_GL_EXT_blend_equation_separate] = 5299,
    [GL_extension_GL_EXT_blend_func_separate] = 5345,
    [GL_extension_GL_EXT_blend_minmax] = 5387,
    [GL_extension_GL_EXT_buffer_storage] = 5422,
    [GL_extension_GL_EXT_color_subtable] = 5459,
    [GL_extension_GL_EXT_compiled_vertex_array] = 5496,
    [GL_extension_GL_EXT_convolution] = 5540,
    [GL_extension_GL_EXT_coordinate_frame] = 5574,
    [GL_extension_GL_EXT_copy_image] = 5613,
    [GL_extension_GL_EXT_copy_texture] = 5646,
    [GL_extension_GL_EXT_cull_vertex] = 5681,
    [GL_extension_GL_EXT_debug_label] = 5715,
    [GL_extension_GL_EXT_debug_marker] = 5749,
    [GL_extension_GL_EXT_depth_bounds_test] = 5784,
    [GL_extension_GL_EXT_direct_state_access] = 5824,
    [GL_extension_GL_EXT_discard_framebuffer] = 5866,
    [GL_extension_GL_EXT_disjoint_timer_query] = 5908,
    [GL_extension_GL_EXT_draw_buffers2] = 5951,
    [GL_extension_GL_EXT_draw_buffers] = 5987,
    [GL_extension_GL_EXT_draw_buffers_indexed] = 6022,
    [GL_extension_GL_EXT_draw_elements_base_vertex] = 6065,
    [GL_extension_GL_EXT_draw_instanced] = 6113,
    [GL_extension_GL_EXT_draw_range_elements] = 6150,
    [GL_extension_GL_EXT_fog_coord] = 6192,
    [GL_extension_GL_EXT_framebuffer_blit] = 6224,
    [GL_extension_GL_EXT_framebuffer_multisample] = 6263,
    [GL_extension_GL_EXT_framebuffer_object] = 6309,
    [GL_extension_GL_EXT_geometry_shader4] = 6350,
    [GL_extension_GL_EXT_geometry_shader] = 6389,
    [GL_extension_GL_EXT_gpu_program_parameters] = 6427,
    [GL_extension_GL_EXT_gpu_shader4] = 6472,
    [GL_extension_GL_EXT_histogram] = 6506,
    [GL_extension_GL_EXT_index_func] = 6538,
    [GL_extension_GL_EXT_index_material] = 6571,
    [GL_extension_GL_EXT_instanced_arrays] = 6608,
    [GL_extension_GL_EXT_light_texture] = 6647,
    [GL_extension_GL_EXT_map_buffer_range] = 6683,
    [GL_extension_GL_EXT_multi_draw_arrays] = 6722,
    [GL_extension_GL_EXT_multi_draw_indirect] = 6762,
    [GL_extension_GL_EXT_multisample] = 6804,
    [GL_extension_GL_EXT_multisampled_render_to_texture] = 6838,
    [GL_extension_GL_EXT_multiview_draw_buffers] = 6891,
    [GL_extension_GL_EXT_occlusion_query_boolean] = 6936,
    [GL_extension_GL_EXT_paletted_texture] = 6982,
    [GL_extension_GL_EXT_pixel_transform] = 7021,
    [GL_extension_GL_EXT_point_parameters] = 7059,
    [GL_extension_GL_EXT_polygon_offset] = 7098,
    [GL_extension_GL_EXT_polygon_offset_clamp] = 7135,
    [GL_extension_GL_EXT_primitive_bounding_box] = 7178,
    [GL_extension_GL_EXT_provoking_vertex] = 7223,
    [GL_extension_GL_EXT_raster_multisample] = 7262,
    [GL_extension_GL_EXT_robustness] = 7303,
    [GL_extension_GL_EXT_secondary_color] = 7336,
    [GL_extension_GL_EXT_separate_shader_objects] = 7374,
    [GL_extension_GL_EXT_shader_image_load_store] = 7420,
    [GL_extension_GL_EXT_sparse_texture] = 7466,
    [GL_extension_GL_EXT_stencil_clear_tag] = 7503,
    [GL_extension_GL_EXT_stencil_two_side] = 7543,
    [GL_extension_GL_EXT_subtexture] = 7582,
    [GL_extension_GL_EXT_tessellation_shader] = 7615,
    [GL_extension_GL_EXT_texture3D] = 7657,
    [GL_extension_GL_EXT_texture_array] = 7689,
    [GL_extension_GL_EXT_texture_border_clamp] = 7725,
    [GL_extension_GL_EXT_texture_buffer] = 7768,
    [GL_extension_GL_EXT_texture_buffer_object] = 7805,
    [GL_extension_GL_EXT_texture_filter_minmax] = 7849,
    [GL_extension_GL_EXT_texture_integer] = 7893,
    [GL_extension_GL_EXT_texture_object] = 7931,
    [GL_extension_GL_EXT_texture_perturb_normal] = 7968,
    [GL_extension_GL_EXT_texture_storage] = 8013,
    [GL_extension_GL_EXT_texture_view] = 8051,
    [GL_extension_GL_EXT_timer_query] = 8086,
    [GL_extension_GL_EXT_transform_feedback] = 8120,
    [GL_extension_GL_EXT_vertex_array] = 8161,
    [GL_extension_GL_EXT_vertex_attrib_64bit] = 8196,
    [GL_extension_GL_EXT_vertex_shader] = 8238,
    [GL_extension_GL_EXT_vertex_weighting] = 8274,
    [GL_extension_GL_EXT_x11_sync_object] = 8313,
    [GL_extension_GL_GREMEDY_frame_terminator] = 8351,
    [GL_extension_GL_GREMEDY_string_marker] = 8394,
    [GL_extension_GL_HP_image_transform] = 8434,
    [GL_extension_GL_IBM_multimode_draw_arrays] = 8471,
    [GL_extension_GL_IBM_static_data] = 8515,
    [GL_extension_GL_IBM_vertex_array_lists] = 8549,
    [GL_extension_GL_IMG_multisampled_render_to_texture] = 8590,
    [GL_extension_GL_IMG_user_clip_plane] = 8643,
    [GL_extension_GL_INGR_blend_func_separate] = 8681,
    [GL_extension_GL_INTEL_map_texture] = 8724,
    [GL_extension_GL_INTEL_parallel_arrays] = 8760,
    [GL_extension_GL_INTEL_performance_query] = 8800,
    [GL_extension_GL_KHR_blend_equation_advanced] = 8842,
    [GL_extension_GL_KHR_debug] = 8888,
    [GL_extension_GL_KHR_robustness] = 8916,
    [GL_extension_GL_MESA_resize_buffers] = 8949,
    [GL_extension_GL_MESA_window_pos] = 8987,
    [GL_extension_GL_NVX_conditional_render] = 9021,
    [GL_extension_GL_NV_bindless_multi_draw_indirect] = 9062,
    [GL_extension_GL_NV_bindless_multi_draw_indirect_count] = 9112,
    [GL_extension_GL_NV_bindless_texture] = 9168,
    [GL_extension_GL_NV_blend_equation_advanced] = 9206,
    [GL_extension_GL_NV_command_list] = 9251,
    [GL_extension_GL_NV_conditional_render] = 9285,
    [GL_extension_GL_NV_conservative_raster] = 9325,
    [GL_extension_GL_NV_copy_buffer] = 9366,
    [GL_extension_GL_NV_copy_image] = 9399,
    [GL_extension_GL_NV_coverage_sample] = 9431,
    [GL_extension_GL_NV_depth_buffer_float] = 9468,
    [GL_extension_GL_NV_draw_buffers] = 9508,
    [GL_extension_GL_NV_draw_instanced] = 9542,
    [GL_extension_GL_NV_draw_texture] = 9578,
    [GL_extension_GL_NV_evaluators] = 9612,
    [GL_extension_GL_NV_explicit_multisample] = 9644,
    [GL_extension_GL_NV_fence] = 9686,
    [GL_extension_GL_NV_fragment_coverage_to_color] = 9713,
    [GL_extension_GL_NV_fragment_program] = 9761,
    [GL_extension_GL_NV_framebuffer_blit] = 9799,
    [GL_extension_GL_NV_framebuffer_mixed_samples] = 9837,
    [GL_extension_GL_NV_framebuffer_multisample] = 9884,
    [GL_extension_GL_NV_framebuffer_multisample_coverage] = 9929,
    [GL_extension_GL_NV_geometry_program4] = 9983,
    [GL_extension_GL_NV_gpu_program4] = 10022,
    [GL_extension_GL_NV_gpu_program5] = 10056,
    [GL_extension_GL_NV_gpu_shader5] = 10090,
    [GL_extension_GL_NV_half_float] = 10123,
    [GL_extension_GL_NV_instanced_arrays] = 10155,
    [GL_extension_GL_NV_internalformat_sample_query] = 10193,
    [GL_extension_GL_NV_non_square_matrices] = 10242,
    [GL_extension_GL_NV_occlusion_query] = 10283,
    [GL_extension_GL_NV_parameter_buffer_object] = 10320,
    [GL_extension_GL_NV_path_rendering] = 10365,
    [GL_extension_GL_NV_pixel_data_range] = 10401,
    [GL_extension_GL_NV_point_sprite] = 10439,
    [GL_extension_GL_NV_polygon_mode] = 10473,
    [GL_extension_GL_NV_present_video] = 10507,
    [GL_extension_GL_NV_primitive_restart] = 10542,
    [GL_extension_GL_NV_read_buffer] = 10581,
    [GL_extension_GL_NV_register_combiners2] = 10614,
    [GL_extension_GL_NV_register_combiners] = 10655,
    [GL_extension_GL_NV_sample_locations] = 10695,
    [GL_extension_GL_NV_shader_buffer_load] = 10733,
    [GL_extension_GL_NV_texture_barrier] = 10773,
    [GL_extension_GL_NV_texture_multisample] = 10810,
    [GL_extension_GL_NV_transform_feedback2] = 10851,
    [GL_extension_GL_NV_transform_feedback] = 10892,
    [GL_extension_GL_NV_vdpau_interop] = 10932,
    [GL_extension_GL_NV_vertex_array_range] = 10967,
    [GL_extension_GL_NV_vertex_attrib_integer_64bit] = 11007,
    [GL_extension_GL_NV_vertex_buffer_unified_memory] = 11056,
    [GL_extension_GL_NV_vertex_program4] = 11106,
    [GL_extension_GL_NV_vertex_program] = 11143,
    [GL_extension_GL_NV_video_capture] = 11179,
    [GL_extension_GL_NV_viewport_array] = 11214,
    [GL_extension_GL_OES_EGL_image] = 11250,
    [GL_extension_GL_OES_blend_equation_separate] = 11282,
    [GL_extension_GL_OES_blend_func_separate] = 11328,
    [GL_extension_GL_OES_blend_subtract] = 11370,
    [GL_extension_GL_OES_byte_coordinates] = 11407,
    [GL_extension_GL_OES_copy_image] = 11446,
    [GL_extension_GL_OES_draw_buffers_indexed] = 11479,
    [GL_extension_GL_OES_draw_elements_base_vertex] = 11522,
    [GL_extension_GL_OES_draw_texture] = 11570,
    [GL_extension_GL_OES_fixed_point] = 11605,
    [GL_extension_GL_OES_framebuffer_object] = 11639,
    [GL_extension_GL_OES_geometry_shader] = 11680,
    [GL_extension_GL_OES_get_program_binary] = 11718,
    [GL_extension_GL_OES_mapbuffer] = 11759,
    [GL_extension_GL_OES_matrix_palette] = 11791,
    [GL_extension_GL_OES_point_size_array] = 11828,
    [GL_extension_GL_OES_primitive_bounding_box] = 11867,
    [GL_extension_GL_OES_query_matrix] = 11912,
    [GL_extension_GL_OES_sample_shading] = 11947,
    [GL_extension_GL_OES_single_precision] = 11984,
    [GL_extension_GL_OES_tessellation_shader] = 12023,
    [GL_extension_GL_OES_texture_3D] = 12065,
    [GL_extension_GL_OES_texture_border_clamp] = 12098,
    [GL_extension_GL_OES_texture_buffer] = 12141,
    [GL_extension_GL_OES_texture_cube_map] = 12178,
    [GL_extension_GL_OES_texture_storage_multisample_2d_array] = 12217,
    [GL_extension_GL_OES_texture_view] = 12276,
    [GL_extension_GL_OES_vertex_array_object] = 12311,
    [GL_extension_GL_OVR_multiview] = 12353,
    [GL_extension_GL_PGI_misc_hints] = 12385,
    [GL_extension_GL_QCOM_alpha_test] = 12418,
    [GL_extension_GL_QCOM_driver_control] = 12452,
    [GL_extension_GL_QCOM_extended_get2] = 12490,
    [GL_extension_GL_QCOM_extended_get] = 12527,
    [GL_extension_GL_QCOM_tiled_rendering] = 12563,
    [GL_extension_GL_SGIS_detail_texture] = 12602,
    [GL_extension_GL_SGIS_fog_function] = 12640,
    [GL_extension_GL_SGIS_multisample] = 12676,
    [GL_extension_GL_SGIS_pixel_texture] = 12711,
    [GL_extension_GL_SGIS_point_parameters] = 12748,
    [GL_extension_GL_SGIS_sharpen_texture] = 12788,
    [GL_extension_GL_SGIS_texture4D] = 12827,
    [GL_extension_GL_SGIS_texture_color_mask] = 12860,
    [GL_extension_GL_SGIS_texture_filter4] = 12902,
    [GL_extension_GL_SGIX_async] = 12941,
    [GL_extension_GL_SGIX_flush_raster] = 12970,
    [GL_extension_GL_SGIX_fragment_lighting] = 13006,
    [GL_extension_GL_SGIX_framezoom] = 13047,
    [GL_extension_GL_SGIX_igloo_interface] = 13080,
    [GL_extension_GL_SGIX_instruments] = 13119,
    [GL_extension_GL_SGIX_list_priority] = 13154,
    [GL_extension_GL_SGIX_pixel_texture] = 13191,
    [GL_extension_GL_SGIX_polynomial_ffd] = 13228,
    [GL_extension_GL_SGIX_reference_plane] = 13266,
    [GL_extension_GL_SGIX_sprite] = 13305,
    [GL_extension_GL_SGIX_tag_sample_buffer] = 13335,
    [GL_extension_GL_SGI_color_table] = 13376,
    [GL_extension_GL_SUNX_constant_data] = 13410,
    [GL_extension_GL_SUN_global_alpha] = 13447,
    [GL_extension_GL_SUN_mesh_array] = 13482,
    [GL_extension_GL_SUN_triangle_list] = 13515,
    [GL_extension_GL_SUN_vertex] = 13551,
    [OpenGL_ES_1_0] = 13580,
    [OpenGL_ES_2_0] = 13594,
    [OpenGL_ES_3_0] = 13608,
    [OpenGL_ES_3_1] = 13622,
    [always_present] = 13636,
};

static const char entrypoint_strings[] = 
   "glAccum\0"
   "glAccumxOES\0"
   "glActiveProgramEXT\0"
   "glActiveShaderProgram\0"
   "glActiveShaderProgramEXT\0"
   "glActiveStencilFaceEXT\0"
   "glActiveTexture\0"
   "glActiveTextureARB\0"
   "glActiveVaryingNV\0"
   "glAlphaFragmentOp1ATI\0"
   "glAlphaFragmentOp2ATI\0"
   "glAlphaFragmentOp3ATI\0"
   "glAlphaFunc\0"
   "glAlphaFuncQCOM\0"
   "glAlphaFuncx\0"
   "glAlphaFuncxOES\0"
   "glApplyTextureEXT\0"
   "glAreProgramsResidentNV\0"
   "glAreTexturesResident\0"
   "glAreTexturesResidentEXT\0"
   "glArrayElement\0"
   "glArrayElementEXT\0"
   "glArrayObjectATI\0"
   "glAsyncMarkerSGIX\0"
   "glAttachObjectARB\0"
   "glAttachShader\0"
   "glBegin\0"
   "glBeginConditionalRender\0"
   "glBeginConditionalRenderNV\0"
   "glBeginConditionalRenderNVX\0"
   "glBeginFragmentShaderATI\0"
   "glBeginOcclusionQueryNV\0"
   "glBeginPerfMonitorAMD\0"
   "glBeginPerfQueryINTEL\0"
   "glBeginQuery\0"
   "glBeginQueryARB\0"
   "glBeginQueryEXT\0"
   "glBeginQueryIndexed\0"
   "glBeginTransformFeedback\0"
   "glBeginTransformFeedbackEXT\0"
   "glBeginTransformFeedbackNV\0"
   "glBeginVertexShaderEXT\0"
   "glBeginVideoCaptureNV\0"
   "glBindAttribLocation\0"
   "glBindAttribLocationARB\0"
   "glBindBuffer\0"
   "glBindBufferARB\0"
   "glBindBufferBase\0"
   "glBindBufferBaseEXT\0"
   "glBindBufferBaseNV\0"
   "glBindBufferOffsetEXT\0"
   "glBindBufferOffsetNV\0"
   "glBindBufferRange\0"
   "glBindBufferRangeEXT\0"
   "glBindBufferRangeNV\0"
   "glBindBuffersBase\0"
   "glBindBuffersRange\0"
   "glBindFragDataLocation\0"
   "glBindFragDataLocationEXT\0"
   "glBindFragDataLocationIndexed\0"
   "glBindFragmentShaderATI\0"
   "glBindFramebuffer\0"
   "glBindFramebufferEXT\0"
   "glBindFramebufferOES\0"
   "glBindImageTexture\0"
   "glBindImageTextureEXT\0"
   "glBindImageTextures\0"
   "glBindLightParameterEXT\0"
   "glBindMaterialParameterEXT\0"
   "glBindMultiTextureEXT\0"
   "glBindParameterEXT\0"
   "glBindProgramARB\0"
   "glBindProgramNV\0"
   "glBindProgramPipeline\0"
   "glBindProgramPipelineEXT\0"
   "glBindRenderbuffer\0"
   "glBindRenderbufferEXT\0"
   "glBindRenderbufferOES\0"
   "glBindSampler\0"
   "glBindSamplers\0"
   "glBindTexGenParameterEXT\0"
   "glBindTexture\0"
   "glBindTextureEXT\0"
   "glBindTextureUnit\0"
   "glBindTextureUnitParameterEXT\0"
   "glBindTextures\0"
   "glBindTransformFeedback\0"
   "glBindTransformFeedbackNV\0"
   "glBindVertexArray\0"
   "glBindVertexArrayAPPLE\0"
   "glBindVertexArrayOES\0"
   "glBindVertexBuffer\0"
   "glBindVertexBuffers\0"
   "glBindVertexShaderEXT\0"
   "glBindVideoCaptureStreamBufferNV\0"
   "glBindVideoCaptureStreamTextureNV\0"
   "glBinormal3bEXT\0"
   "glBinormal3bvEXT\0"
   "glBinormal3dEXT\0"
   "glBinormal3dvEXT\0"
   "glBinormal3fEXT\0"
   "glBinormal3fvEXT\0"
   "glBinormal3iEXT\0"
   "glBinormal3ivEXT\0"
   "glBinormal3sEXT\0"
   "glBinormal3svEXT\0"
   "glBinormalPointerEXT\0"
   "glBitmap\0"
   "glBitmapxOES\0"
   "glBlendBarrierKHR\0"
   "glBlendBarrierNV\0"
   "glBlendColor\0"
   "glBlendColorEXT\0"
   "glBlendColorxOES\0"
   "glBlendEquation\0"
   "glBlendEquationEXT\0"
   "glBlendEquationIndexedAMD\0"
   "glBlendEquationOES\0"
   "glBlendEquationSeparate\0"
   "glBlendEquationSeparateEXT\0"
   "glBlendEquationSeparateIndexedAMD\0"
   "glBlendEquationSeparateOES\0"
   "glBlendEquationSeparatei\0"
   "glBlendEquationSeparateiARB\0"
   "glBlendEquationSeparateiEXT\0"
   "glBlendEquationSeparateiOES\0"
   "glBlendEquationi\0"
   "glBlendEquationiARB\0"
   "glBlendEquationiEXT\0"
   "glBlendEquationiOES\0"
   "glBlendFunc\0"
   "glBlendFuncIndexedAMD\0"
   "glBlendFuncSeparate\0"
   "glBlendFuncSeparateEXT\0"
   "glBlendFuncSeparateINGR\0"
   "glBlendFuncSeparateIndexedAMD\0"
   "glBlendFuncSeparateOES\0"
   "glBlendFuncSeparatei\0"
   "glBlendFuncSeparateiARB\0"
   "glBlendFuncSeparateiEXT\0"
   "glBlendFuncSeparateiOES\0"
   "glBlendFunci\0"
   "glBlendFunciARB\0"
   "glBlendFunciEXT\0"
   "glBlendFunciOES\0"
   "glBlendParameteriNV\0"
   "glBlitFramebuffer\0"
   "glBlitFramebufferANGLE\0"
   "glBlitFramebufferEXT\0"
   "glBlitFramebufferNV\0"
   "glBlitNamedFramebuffer\0"
   "glBufferAddressRangeNV\0"
   "glBufferData\0"
   "glBufferDataARB\0"
   "glBufferPageCommitmentARB\0"
   "glBufferParameteriAPPLE\0"
   "glBufferStorage\0"
   "glBufferStorageEXT\0"
   "glBufferSubData\0"
   "glBufferSubDataARB\0"
   "glCallCommandListNV\0"
   "glCallList\0"
   "glCallLists\0"
   "glCheckFramebufferStatus\0"
   "glCheckFramebufferStatusEXT\0"
   "glCheckFramebufferStatusOES\0"
   "glCheckNamedFramebufferStatus\0"
   "glCheckNamedFramebufferStatusEXT\0"
   "glClampColor\0"
   "glClampColorARB\0"
   "glClear\0"
   "glClearAccum\0"
   "glClearAccumxOES\0"
   "glClearBufferData\0"
   "glClearBufferSubData\0"
   "glClearBufferfi\0"
   "glClearBufferfv\0"
   "glClearBufferiv\0"
   "glClearBufferuiv\0"
   "glClearColor\0"
   "glClearColorIiEXT\0"
   "glClearColorIuiEXT\0"
   "glClearColorx\0"
   "glClearColorxOES\0"
   "glClearDepth\0"
   "glClearDepthdNV\0"
   "glClearDepthf\0"
   "glClearDepthfOES\0"
   "glClearDepthx\0"
   "glClearDepthxOES\0"
   "glClearIndex\0"
   "glClearNamedBufferData\0"
   "glClearNamedBufferDataEXT\0"
   "glClearNamedBufferSubData\0"
   "glClearNamedBufferSubDataEXT\0"
   "glClearNamedFramebufferfi\0"
   "glClearNamedFramebufferfv\0"
   "glClearNamedFramebufferiv\0"
   "glClearNamedFramebufferuiv\0"
   "glClearStencil\0"
   "glClearTexImage\0"
   "glClearTexSubImage\0"
   "glClientActiveTexture\0"
   "glClientActiveTextureARB\0"
   "glClientActiveVertexStreamATI\0"
   "glClientAttribDefaultEXT\0"
   "glClientWaitSync\0"
   "glClientWaitSyncAPPLE\0"
   "glClipControl\0"
   "glClipPlane\0"
   "glClipPlanef\0"
   "glClipPlanefIMG\0"
   "glClipPlanefOES\0"
   "glClipPlanex\0"
   "glClipPlanexIMG\0"
   "glClipPlanexOES\0"
   "glColor3b\0"
   "glColor3bv\0"
   "glColor3d\0"
   "glColor3dv\0"
   "glColor3f\0"
   "glColor3fVertex3fSUN\0"
   "glColor3fVertex3fvSUN\0"
   "glColor3fv\0"
   "glColor3hNV\0"
   "glColor3hvNV\0"
   "glColor3i\0"
   "glColor3iv\0"
   "glColor3s\0"
   "glColor3sv\0"
   "glColor3ub\0"
   "glColor3ubv\0"
   "glColor3ui\0"
   "glColor3uiv\0"
   "glColor3us\0"
   "glColor3usv\0"
   "glColor3xOES\0"
   "glColor3xvOES\0"
   "glColor4b\0"
   "glColor4bv\0"
   "glColor4d\0"
   "glColor4dv\0"
   "glColor4f\0"
   "glColor4fNormal3fVertex3fSUN\0"
   "glColor4fNormal3fVertex3fvSUN\0"
   "glColor4fv\0"
   "glColor4hNV\0"
   "glColor4hvNV\0"
   "glColor4i\0"
   "glColor4iv\0"
   "glColor4s\0"
   "glColor4sv\0"
   "glColor4ub\0"
   "glColor4ubVertex2fSUN\0"
   "glColor4ubVertex2fvSUN\0"
   "glColor4ubVertex3fSUN\0"
   "glColor4ubVertex3fvSUN\0"
   "glColor4ubv\0"
   "glColor4ui\0"
   "glColor4uiv\0"
   "glColor4us\0"
   "glColor4usv\0"
   "glColor4x\0"
   "glColor4xOES\0"
   "glColor4xvOES\0"
   "glColorFormatNV\0"
   "glColorFragmentOp1ATI\0"
   "glColorFragmentOp2ATI\0"
   "glColorFragmentOp3ATI\0"
   "glColorMask\0"
   "glColorMaskIndexedEXT\0"
   "glColorMaski\0"
   "glColorMaskiEXT\0"
   "glColorMaskiOES\0"
   "glColorMaterial\0"
   "glColorP3ui\0"
   "glColorP3uiv\0"
   "glColorP4ui\0"
   "glColorP4uiv\0"
   "glColorPointer\0"
   "glColorPointerEXT\0"
   "glColorPointerListIBM\0"
   "glColorPointervINTEL\0"
   "glColorSubTable\0"
   "glColorSubTableEXT\0"
   "glColorTable\0"
   "glColorTableEXT\0"
   "glColorTableParameterfv\0"
   "glColorTableParameterfvSGI\0"
   "glColorTableParameteriv\0"
   "glColorTableParameterivSGI\0"
   "glColorTableSGI\0"
   "glCombinerInputNV\0"
   "glCombinerOutputNV\0"
   "glCombinerParameterfNV\0"
   "glCombinerParameterfvNV\0"
   "glCombinerParameteriNV\0"
   "glCombinerParameterivNV\0"
   "glCombinerStageParameterfvNV\0"
   "glCommandListSegmentsNV\0"
   "glCompileCommandListNV\0"
   "glCompileShader\0"
   "glCompileShaderARB\0"
   "glCompileShaderIncludeARB\0"
   "glCompressedMultiTexImage1DEXT\0"
   "glCompressedMultiTexImage2DEXT\0"
   "glCompressedMultiTexImage3DEXT\0"
   "glCompressedMultiTexSubImage1DEXT\0"
   "glCompressedMultiTexSubImage2DEXT\0"
   "glCompressedMultiTexSubImage3DEXT\0"
   "glCompressedTexImage1D\0"
   "glCompressedTexImage1DARB\0"
   "glCompressedTexImage2D\0"
   "glCompressedTexImage2DARB\0"
   "glCompressedTexImage3D\0"
   "glCompressedTexImage3DARB\0"
   "glCompressedTexImage3DOES\0"
   "glCompressedTexSubImage1D\0"
   "glCompressedTexSubImage1DARB\0"
   "glCompressedTexSubImage2D\0"
   "glCompressedTexSubImage2DARB\0"
   "glCompressedTexSubImage3D\0"
   "glCompressedTexSubImage3DARB\0"
   "glCompressedTexSubImage3DOES\0"
   "glCompressedTextureImage1DEXT\0"
   "glCompressedTextureImage2DEXT\0"
   "glCompressedTextureImage3DEXT\0"
   "glCompressedTextureSubImage1D\0"
   "glCompressedTextureSubImage1DEXT\0"
   "glCompressedTextureSubImage2D\0"
   "glCompressedTextureSubImage2DEXT\0"
   "glCompressedTextureSubImage3D\0"
   "glCompressedTextureSubImage3DEXT\0"
   "glConvolutionFilter1D\0"
   "glConvolutionFilter1DEXT\0"
   "glConvolutionFilter2D\0"
   "glConvolutionFilter2DEXT\0"
   "glConvolutionParameterf\0"
   "glConvolutionParameterfEXT\0"
   "glConvolutionParameterfv\0"
   "glConvolutionParameterfvEXT\0"
   "glConvolutionParameteri\0"
   "glConvolutionParameteriEXT\0"
   "glConvolutionParameteriv\0"
   "glConvolutionParameterivEXT\0"
   "glConvolutionParameterxOES\0"
   "glConvolutionParameterxvOES\0"
   "glCopyBufferSubData\0"
   "glCopyBufferSubDataNV\0"
   "glCopyColorSubTable\0"
   "glCopyColorSubTableEXT\0"
   "glCopyColorTable\0"
   "glCopyColorTableSGI\0"
   "glCopyConvolutionFilter1D\0"
   "glCopyConvolutionFilter1DEXT\0"
   "glCopyConvolutionFilter2D\0"
   "glCopyConvolutionFilter2DEXT\0"
   "glCopyImageSubData\0"
   "glCopyImageSubDataEXT\0"
   "glCopyImageSubDataNV\0"
   "glCopyImageSubDataOES\0"
   "glCopyMultiTexImage1DEXT\0"
   "glCopyMultiTexImage2DEXT\0"
   "glCopyMultiTexSubImage1DEXT\0"
   "glCopyMultiTexSubImage2DEXT\0"
   "glCopyMultiTexSubImage3DEXT\0"
   "glCopyNamedBufferSubData\0"
   "glCopyPathNV\0"
   "glCopyPixels\0"
   "glCopyTexImage1D\0"
   "glCopyTexImage1DEXT\0"
   "glCopyTexImage2D\0"
   "glCopyTexImage2DEXT\0"
   "glCopyTexSubImage1D\0"
   "glCopyTexSubImage1DEXT\0"
   "glCopyTexSubImage2D\0"
   "glCopyTexSubImage2DEXT\0"
   "glCopyTexSubImage3D\0"
   "glCopyTexSubImage3DEXT\0"
   "glCopyTexSubImage3DOES\0"
   "glCopyTextureImage1DEXT\0"
   "glCopyTextureImage2DEXT\0"
   "glCopyTextureLevelsAPPLE\0"
   "glCopyTextureSubImage1D\0"
   "glCopyTextureSubImage1DEXT\0"
   "glCopyTextureSubImage2D\0"
   "glCopyTextureSubImage2DEXT\0"
   "glCopyTextureSubImage3D\0"
   "glCopyTextureSubImage3DEXT\0"
   "glCoverFillPathInstancedNV\0"
   "glCoverFillPathNV\0"
   "glCoverStrokePathInstancedNV\0"
   "glCoverStrokePathNV\0"
   "glCoverageMaskNV\0"
   "glCoverageModulationNV\0"
   "glCoverageModulationTableNV\0"
   "glCoverageOperationNV\0"
   "glCreateBuffers\0"
   "glCreateCommandListsNV\0"
   "glCreateFramebuffers\0"
   "glCreatePerfQueryINTEL\0"
   "glCreateProgram\0"
   "glCreateProgramObjectARB\0"
   "glCreateProgramPipelines\0"
   "glCreateQueries\0"
   "glCreateRenderbuffers\0"
   "glCreateSamplers\0"
   "glCreateShader\0"
   "glCreateShaderObjectARB\0"
   "glCreateShaderProgramEXT\0"
   "glCreateShaderProgramv\0"
   "glCreateShaderProgramvEXT\0"
   "glCreateStatesNV\0"
   "glCreateSyncFromCLeventARB\0"
   "glCreateTextures\0"
   "glCreateTransformFeedbacks\0"
   "glCreateVertexArrays\0"
   "glCullFace\0"
   "glCullParameterdvEXT\0"
   "glCullParameterfvEXT\0"
   "glCurrentPaletteMatrixARB\0"
   "glCurrentPaletteMatrixOES\0"
   "glDebugMessageCallback\0"
   "glDebugMessageCallbackAMD\0"
   "glDebugMessageCallbackARB\0"
   "glDebugMessageCallbackKHR\0"
   "glDebugMessageControl\0"
   "glDebugMessageControlARB\0"
   "glDebugMessageControlKHR\0"
   "glDebugMessageEnableAMD\0"
   "glDebugMessageInsert\0"
   "glDebugMessageInsertAMD\0"
   "glDebugMessageInsertARB\0"
   "glDebugMessageInsertKHR\0"
   "glDeformSGIX\0"
   "glDeformationMap3dSGIX\0"
   "glDeformationMap3fSGIX\0"
   "glDeleteAsyncMarkersSGIX\0"
   "glDeleteBuffers\0"
   "glDeleteBuffersARB\0"
   "glDeleteCommandListsNV\0"
   "glDeleteFencesAPPLE\0"
   "glDeleteFencesNV\0"
   "glDeleteFragmentShaderATI\0"
   "glDeleteFramebuffers\0"
   "glDeleteFramebuffersEXT\0"
   "glDeleteFramebuffersOES\0"
   "glDeleteLists\0"
   "glDeleteNamedStringARB\0"
   "glDeleteNamesAMD\0"
   "glDeleteObjectARB\0"
   "glDeleteOcclusionQueriesNV\0"
   "glDeletePathsNV\0"
   "glDeletePerfMonitorsAMD\0"
   "glDeletePerfQueryINTEL\0"
   "glDeleteProgram\0"
   "glDeleteProgramPipelines\0"
   "glDeleteProgramPipelinesEXT\0"
   "glDeleteProgramsARB\0"
   "glDeleteProgramsNV\0"
   "glDeleteQueries\0"
   "glDeleteQueriesARB\0"
   "glDeleteQueriesEXT\0"
   "glDeleteRenderbuffers\0"
   "glDeleteRenderbuffersEXT\0"
   "glDeleteRenderbuffersOES\0"
   "glDeleteSamplers\0"
   "glDeleteShader\0"
   "glDeleteStatesNV\0"
   "glDeleteSync\0"
   "glDeleteSyncAPPLE\0"
   "glDeleteTextures\0"
   "glDeleteTexturesEXT\0"
   "glDeleteTransformFeedbacks\0"
   "glDeleteTransformFeedbacksNV\0"
   "glDeleteVertexArrays\0"
   "glDeleteVertexArraysAPPLE\0"
   "glDeleteVertexArraysOES\0"
   "glDeleteVertexShaderEXT\0"
   "glDepthBoundsEXT\0"
   "glDepthBoundsdNV\0"
   "glDepthFunc\0"
   "glDepthMask\0"
   "glDepthRange\0"
   "glDepthRangeArrayfvNV\0"
   "glDepthRangeArrayv\0"
   "glDepthRangeIndexed\0"
   "glDepthRangeIndexedfNV\0"
   "glDepthRangedNV\0"
   "glDepthRangef\0"
   "glDepthRangefOES\0"
   "glDepthRangex\0"
   "glDepthRangexOES\0"
   "glDetachObjectARB\0"
   "glDetachShader\0"
   "glDetailTexFuncSGIS\0"
   "glDisable\0"
   "glDisableClientState\0"
   "glDisableClientStateIndexedEXT\0"
   "glDisableClientStateiEXT\0"
   "glDisableDriverControlQCOM\0"
   "glDisableIndexedEXT\0"
   "glDisableVariantClientStateEXT\0"
   "glDisableVertexArrayAttrib\0"
   "glDisableVertexArrayAttribEXT\0"
   "glDisableVertexArrayEXT\0"
   "glDisableVertexAttribAPPLE\0"
   "glDisableVertexAttribArray\0"
   "glDisableVertexAttribArrayARB\0"
   "glDisablei\0"
   "glDisableiEXT\0"
   "glDisableiNV\0"
   "glDisableiOES\0"
   "glDiscardFramebufferEXT\0"
   "glDispatchCompute\0"
   "glDispatchComputeGroupSizeARB\0"
   "glDispatchComputeIndirect\0"
   "glDrawArrays\0"
   "glDrawArraysEXT\0"
   "glDrawArraysIndirect\0"
   "glDrawArraysInstanced\0"
   "glDrawArraysInstancedANGLE\0"
   "glDrawArraysInstancedARB\0"
   "glDrawArraysInstancedBaseInstance\0"
   "glDrawArraysInstancedBaseInstanceEXT\0"
   "glDrawArraysInstancedEXT\0"
   "glDrawArraysInstancedNV\0"
   "glDrawBuffer\0"
   "glDrawBuffers\0"
   "glDrawBuffersARB\0"
   "glDrawBuffersATI\0"
   "glDrawBuffersEXT\0"
   "glDrawBuffersIndexedEXT\0"
   "glDrawBuffersNV\0"
   "glDrawCommandsAddressNV\0"
   "glDrawCommandsNV\0"
   "glDrawCommandsStatesAddressNV\0"
   "glDrawCommandsStatesNV\0"
   "glDrawElementArrayAPPLE\0"
   "glDrawElementArrayATI\0"
   "glDrawElements\0"
   "glDrawElementsBaseVertex\0"
   "glDrawElementsBaseVertexEXT\0"
   "glDrawElementsBaseVertexOES\0"
   "glDrawElementsIndirect\0"
   "glDrawElementsInstanced\0"
   "glDrawElementsInstancedANGLE\0"
   "glDrawElementsInstancedARB\0"
   "glDrawElementsInstancedBaseInstance\0"
   "glDrawElementsInstancedBaseInstanceEXT\0"
   "glDrawElementsInstancedBaseVertex\0"
   "glDrawElementsInstancedBaseVertexBaseInstance\0"
   "glDrawElementsInstancedBaseVertexBaseInstanceEXT\0"
   "glDrawElementsInstancedBaseVertexEXT\0"
   "glDrawElementsInstancedBaseVertexOES\0"
   "glDrawElementsInstancedEXT\0"
   "glDrawElementsInstancedNV\0"
   "glDrawMeshArraysSUN\0"
   "glDrawPixels\0"
   "glDrawRangeElementArrayAPPLE\0"
   "glDrawRangeElementArrayATI\0"
   "glDrawRangeElements\0"
   "glDrawRangeElementsBaseVertex\0"
   "glDrawRangeElementsBaseVertexEXT\0"
   "glDrawRangeElementsBaseVertexOES\0"
   "glDrawRangeElementsEXT\0"
   "glDrawTexfOES\0"
   "glDrawTexfvOES\0"
   "glDrawTexiOES\0"
   "glDrawTexivOES\0"
   "glDrawTexsOES\0"
   "glDrawTexsvOES\0"
   "glDrawTextureNV\0"
   "glDrawTexxOES\0"
   "glDrawTexxvOES\0"
   "glDrawTransformFeedback\0"
   "glDrawTransformFeedbackInstanced\0"
   "glDrawTransformFeedbackNV\0"
   "glDrawTransformFeedbackStream\0"
   "glDrawTransformFeedbackStreamInstanced\0"
   "glEGLImageTargetRenderbufferStorageOES\0"
   "glEGLImageTargetTexture2DOES\0"
   "glEdgeFlag\0"
   "glEdgeFlagFormatNV\0"
   "glEdgeFlagPointer\0"
   "glEdgeFlagPointerEXT\0"
   "glEdgeFlagPointerListIBM\0"
   "glEdgeFlagv\0"
   "glElementPointerAPPLE\0"
   "glElementPointerATI\0"
   "glEnable\0"
   "glEnableClientState\0"
   "glEnableClientStateIndexedEXT\0"
   "glEnableClientStateiEXT\0"
   "glEnableDriverControlQCOM\0"
   "glEnableIndexedEXT\0"
   "glEnableVariantClientStateEXT\0"
   "glEnableVertexArrayAttrib\0"
   "glEnableVertexArrayAttribEXT\0"
   "glEnableVertexArrayEXT\0"
   "glEnableVertexAttribAPPLE\0"
   "glEnableVertexAttribArray\0"
   "glEnableVertexAttribArrayARB\0"
   "glEnablei\0"
   "glEnableiEXT\0"
   "glEnableiNV\0"
   "glEnableiOES\0"
   "glEnd\0"
   "glEndConditionalRender\0"
   "glEndConditionalRenderNV\0"
   "glEndConditionalRenderNVX\0"
   "glEndFragmentShaderATI\0"
   "glEndList\0"
   "glEndOcclusionQueryNV\0"
   "glEndPerfMonitorAMD\0"
   "glEndPerfQueryINTEL\0"
   "glEndQuery\0"
   "glEndQueryARB\0"
   "glEndQueryEXT\0"
   "glEndQueryIndexed\0"
   "glEndTilingQCOM\0"
   "glEndTransformFeedback\0"
   "glEndTransformFeedbackEXT\0"
   "glEndTransformFeedbackNV\0"
   "glEndVertexShaderEXT\0"
   "glEndVideoCaptureNV\0"
   "glEvalCoord1d\0"
   "glEvalCoord1dv\0"
   "glEvalCoord1f\0"
   "glEvalCoord1fv\0"
   "glEvalCoord1xOES\0"
   "glEvalCoord1xvOES\0"
   "glEvalCoord2d\0"
   "glEvalCoord2dv\0"
   "glEvalCoord2f\0"
   "glEvalCoord2fv\0"
   "glEvalCoord2xOES\0"
   "glEvalCoord2xvOES\0"
   "glEvalMapsNV\0"
   "glEvalMesh1\0"
   "glEvalMesh2\0"
   "glEvalPoint1\0"
   "glEvalPoint2\0"
   "glExecuteProgramNV\0"
   "glExtGetBufferPointervQCOM\0"
   "glExtGetBuffersQCOM\0"
   "glExtGetFramebuffersQCOM\0"
   "glExtGetProgramBinarySourceQCOM\0"
   "glExtGetProgramsQCOM\0"
   "glExtGetRenderbuffersQCOM\0"
   "glExtGetShadersQCOM\0"
   "glExtGetTexLevelParameterivQCOM\0"
   "glExtGetTexSubImageQCOM\0"
   "glExtGetTexturesQCOM\0"
   "glExtIsProgramBinaryQCOM\0"
   "glExtTexObjectStateOverrideiQCOM\0"
   "glExtractComponentEXT\0"
   "glFeedbackBuffer\0"
   "glFeedbackBufferxOES\0"
   "glFenceSync\0"
   "glFenceSyncAPPLE\0"
   "glFinalCombinerInputNV\0"
   "glFinish\0"
   "glFinishAsyncSGIX\0"
   "glFinishFenceAPPLE\0"
   "glFinishFenceNV\0"
   "glFinishObjectAPPLE\0"
   "glFinishTextureSUNX\0"
   "glFlush\0"
   "glFlushMappedBufferRange\0"
   "glFlushMappedBufferRangeAPPLE\0"
   "glFlushMappedBufferRangeEXT\0"
   "glFlushMappedNamedBufferRange\0"
   "glFlushMappedNamedBufferRangeEXT\0"
   "glFlushPixelDataRangeNV\0"
   "glFlushRasterSGIX\0"
   "glFlushStaticDataIBM\0"
   "glFlushVertexArrayRangeAPPLE\0"
   "glFlushVertexArrayRangeNV\0"
   "glFogCoordFormatNV\0"
   "glFogCoordPointer\0"
   "glFogCoordPointerEXT\0"
   "glFogCoordPointerListIBM\0"
   "glFogCoordd\0"
   "glFogCoorddEXT\0"
   "glFogCoorddv\0"
   "glFogCoorddvEXT\0"
   "glFogCoordf\0"
   "glFogCoordfEXT\0"
   "glFogCoordfv\0"
   "glFogCoordfvEXT\0"
   "glFogCoordhNV\0"
   "glFogCoordhvNV\0"
   "glFogFuncSGIS\0"
   "glFogf\0"
   "glFogfv\0"
   "glFogi\0"
   "glFogiv\0"
   "glFogx\0"
   "glFogxOES\0"
   "glFogxv\0"
   "glFogxvOES\0"
   "glFragmentColorMaterialSGIX\0"
   "glFragmentCoverageColorNV\0"
   "glFragmentLightModelfSGIX\0"
   "glFragmentLightModelfvSGIX\0"
   "glFragmentLightModeliSGIX\0"
   "glFragmentLightModelivSGIX\0"
   "glFragmentLightfSGIX\0"
   "glFragmentLightfvSGIX\0"
   "glFragmentLightiSGIX\0"
   "glFragmentLightivSGIX\0"
   "glFragmentMaterialfSGIX\0"
   "glFragmentMaterialfvSGIX\0"
   "glFragmentMaterialiSGIX\0"
   "glFragmentMaterialivSGIX\0"
   "glFrameTerminatorGREMEDY\0"
   "glFrameZoomSGIX\0"
   "glFramebufferDrawBufferEXT\0"
   "glFramebufferDrawBuffersEXT\0"
   "glFramebufferParameteri\0"
   "glFramebufferReadBufferEXT\0"
   "glFramebufferRenderbuffer\0"
   "glFramebufferRenderbufferEXT\0"
   "glFramebufferRenderbufferOES\0"
   "glFramebufferSampleLocationsfvNV\0"
   "glFramebufferTexture\0"
   "glFramebufferTexture1D\0"
   "glFramebufferTexture1DEXT\0"
   "glFramebufferTexture2D\0"
   "glFramebufferTexture2DEXT\0"
   "glFramebufferTexture2DMultisampleEXT\0"
   "glFramebufferTexture2DMultisampleIMG\0"
   "glFramebufferTexture2DOES\0"
   "glFramebufferTexture3D\0"
   "glFramebufferTexture3DEXT\0"
   "glFramebufferTexture3DOES\0"
   "glFramebufferTextureARB\0"
   "glFramebufferTextureEXT\0"
   "glFramebufferTextureFaceARB\0"
   "glFramebufferTextureFaceEXT\0"
   "glFramebufferTextureLayer\0"
   "glFramebufferTextureLayerARB\0"
   "glFramebufferTextureLayerEXT\0"
   "glFramebufferTextureMultiviewOVR\0"
   "glFramebufferTextureOES\0"
   "glFreeObjectBufferATI\0"
   "glFrontFace\0"
   "glFrustum\0"
   "glFrustumf\0"
   "glFrustumfOES\0"
   "glFrustumx\0"
   "glFrustumxOES\0"
   "glGenAsyncMarkersSGIX\0"
   "glGenBuffers\0"
   "glGenBuffersARB\0"
   "glGenFencesAPPLE\0"
   "glGenFencesNV\0"
   "glGenFragmentShadersATI\0"
   "glGenFramebuffers\0"
   "glGenFramebuffersEXT\0"
   "glGenFramebuffersOES\0"
   "glGenLists\0"
   "glGenNamesAMD\0"
   "glGenOcclusionQueriesNV\0"
   "glGenPathsNV\0"
   "glGenPerfMonitorsAMD\0"
   "glGenProgramPipelines\0"
   "glGenProgramPipelinesEXT\0"
   "glGenProgramsARB\0"
   "glGenProgramsNV\0"
   "glGenQueries\0"
   "glGenQueriesARB\0"
   "glGenQueriesEXT\0"
   "glGenRenderbuffers\0"
   "glGenRenderbuffersEXT\0"
   "glGenRenderbuffersOES\0"
   "glGenSamplers\0"
   "glGenSymbolsEXT\0"
   "glGenTextures\0"
   "glGenTexturesEXT\0"
   "glGenTransformFeedbacks\0"
   "glGenTransformFeedbacksNV\0"
   "glGenVertexArrays\0"
   "glGenVertexArraysAPPLE\0"
   "glGenVertexArraysOES\0"
   "glGenVertexShadersEXT\0"
   "glGenerateMipmap\0"
   "glGenerateMipmapEXT\0"
   "glGenerateMipmapOES\0"
   "glGenerateMultiTexMipmapEXT\0"
   "glGenerateTextureMipmap\0"
   "glGenerateTextureMipmapEXT\0"
   "glGetActiveAtomicCounterBufferiv\0"
   "glGetActiveAttrib\0"
   "glGetActiveAttribARB\0"
   "glGetActiveSubroutineName\0"
   "glGetActiveSubroutineUniformName\0"
   "glGetActiveSubroutineUniformiv\0"
   "glGetActiveUniform\0"
   "glGetActiveUniformARB\0"
   "glGetActiveUniformBlockName\0"
   "glGetActiveUniformBlockiv\0"
   "glGetActiveUniformName\0"
   "glGetActiveUniformsiv\0"
   "glGetActiveVaryingNV\0"
   "glGetArrayObjectfvATI\0"
   "glGetArrayObjectivATI\0"
   "glGetAttachedObjectsARB\0"
   "glGetAttachedShaders\0"
   "glGetAttribLocation\0"
   "glGetAttribLocationARB\0"
   "glGetBooleanIndexedvEXT\0"
   "glGetBooleani_v\0"
   "glGetBooleanv\0"
   "glGetBufferParameteri64v\0"
   "glGetBufferParameteriv\0"
   "glGetBufferParameterivARB\0"
   "glGetBufferParameterui64vNV\0"
   "glGetBufferPointerv\0"
   "glGetBufferPointervARB\0"
   "glGetBufferPointervOES\0"
   "glGetBufferSubData\0"
   "glGetBufferSubDataARB\0"
   "glGetClipPlane\0"
   "glGetClipPlanef\0"
   "glGetClipPlanefOES\0"
   "glGetClipPlanex\0"
   "glGetClipPlanexOES\0"
   "glGetColorTable\0"
   "glGetColorTableEXT\0"
   "glGetColorTableParameterfv\0"
   "glGetColorTableParameterfvEXT\0"
   "glGetColorTableParameterfvSGI\0"
   "glGetColorTableParameteriv\0"
   "glGetColorTableParameterivEXT\0"
   "glGetColorTableParameterivSGI\0"
   "glGetColorTableSGI\0"
   "glGetCombinerInputParameterfvNV\0"
   "glGetCombinerInputParameterivNV\0"
   "glGetCombinerOutputParameterfvNV\0"
   "glGetCombinerOutputParameterivNV\0"
   "glGetCombinerStageParameterfvNV\0"
   "glGetCommandHeaderNV\0"
   "glGetCompressedMultiTexImageEXT\0"
   "glGetCompressedTexImage\0"
   "glGetCompressedTexImageARB\0"
   "glGetCompressedTextureImage\0"
   "glGetCompressedTextureImageEXT\0"
   "glGetCompressedTextureSubImage\0"
   "glGetConvolutionFilter\0"
   "glGetConvolutionFilterEXT\0"
   "glGetConvolutionParameterfv\0"
   "glGetConvolutionParameterfvEXT\0"
   "glGetConvolutionParameteriv\0"
   "glGetConvolutionParameterivEXT\0"
   "glGetConvolutionParameterxvOES\0"
   "glGetCoverageModulationTableNV\0"
   "glGetDebugMessageLog\0"
   "glGetDebugMessageLogAMD\0"
   "glGetDebugMessageLogARB\0"
   "glGetDebugMessageLogKHR\0"
   "glGetDetailTexFuncSGIS\0"
   "glGetDoubleIndexedvEXT\0"
   "glGetDoublei_v\0"
   "glGetDoublei_vEXT\0"
   "glGetDoublev\0"
   "glGetDriverControlStringQCOM\0"
   "glGetDriverControlsQCOM\0"
   "glGetError\0"
   "glGetFenceivNV\0"
   "glGetFinalCombinerInputParameterfvNV\0"
   "glGetFinalCombinerInputParameterivNV\0"
   "glGetFirstPerfQueryIdINTEL\0"
   "glGetFixedv\0"
   "glGetFixedvOES\0"
   "glGetFloatIndexedvEXT\0"
   "glGetFloati_v\0"
   "glGetFloati_vEXT\0"
   "glGetFloati_vNV\0"
   "glGetFloatv\0"
   "glGetFogFuncSGIS\0"
   "glGetFragDataIndex\0"
   "glGetFragDataLocation\0"
   "glGetFragDataLocationEXT\0"
   "glGetFragmentLightfvSGIX\0"
   "glGetFragmentLightivSGIX\0"
   "glGetFragmentMaterialfvSGIX\0"
   "glGetFragmentMaterialivSGIX\0"
   "glGetFramebufferAttachmentParameteriv\0"
   "glGetFramebufferAttachmentParameterivEXT\0"
   "glGetFramebufferAttachmentParameterivOES\0"
   "glGetFramebufferParameteriv\0"
   "glGetFramebufferParameterivEXT\0"
   "glGetGraphicsResetStatus\0"
   "glGetGraphicsResetStatusARB\0"
   "glGetGraphicsResetStatusEXT\0"
   "glGetGraphicsResetStatusKHR\0"
   "glGetHandleARB\0"
   "glGetHistogram\0"
   "glGetHistogramEXT\0"
   "glGetHistogramParameterfv\0"
   "glGetHistogramParameterfvEXT\0"
   "glGetHistogramParameteriv\0"
   "glGetHistogramParameterivEXT\0"
   "glGetHistogramParameterxvOES\0"
   "glGetImageHandleARB\0"
   "glGetImageHandleNV\0"
   "glGetImageTransformParameterfvHP\0"
   "glGetImageTransformParameterivHP\0"
   "glGetInfoLogARB\0"
   "glGetInstrumentsSGIX\0"
   "glGetInteger64i_v\0"
   "glGetInteger64v\0"
   "glGetInteger64vAPPLE\0"
   "glGetIntegerIndexedvEXT\0"
   "glGetIntegeri_v\0"
   "glGetIntegeri_vEXT\0"
   "glGetIntegerui64i_vNV\0"
   "glGetIntegerui64vNV\0"
   "glGetIntegerv\0"
   "glGetInternalformatSampleivNV\0"
   "glGetInternalformati64v\0"
   "glGetInternalformativ\0"
   "glGetInvariantBooleanvEXT\0"
   "glGetInvariantFloatvEXT\0"
   "glGetInvariantIntegervEXT\0"
   "glGetLightfv\0"
   "glGetLightiv\0"
   "glGetLightxOES\0"
   "glGetLightxv\0"
   "glGetLightxvOES\0"
   "glGetListParameterfvSGIX\0"
   "glGetListParameterivSGIX\0"
   "glGetLocalConstantBooleanvEXT\0"
   "glGetLocalConstantFloatvEXT\0"
   "glGetLocalConstantIntegervEXT\0"
   "glGetMapAttribParameterfvNV\0"
   "glGetMapAttribParameterivNV\0"
   "glGetMapControlPointsNV\0"
   "glGetMapParameterfvNV\0"
   "glGetMapParameterivNV\0"
   "glGetMapdv\0"
   "glGetMapfv\0"
   "glGetMapiv\0"
   "glGetMapxvOES\0"
   "glGetMaterialfv\0"
   "glGetMaterialiv\0"
   "glGetMaterialxOES\0"
   "glGetMaterialxv\0"
   "glGetMaterialxvOES\0"
   "glGetMinmax\0"
   "glGetMinmaxEXT\0"
   "glGetMinmaxParameterfv\0"
   "glGetMinmaxParameterfvEXT\0"
   "glGetMinmaxParameteriv\0"
   "glGetMinmaxParameterivEXT\0"
   "glGetMultiTexEnvfvEXT\0"
   "glGetMultiTexEnvivEXT\0"
   "glGetMultiTexGendvEXT\0"
   "glGetMultiTexGenfvEXT\0"
   "glGetMultiTexGenivEXT\0"
   "glGetMultiTexImageEXT\0"
   "glGetMultiTexLevelParameterfvEXT\0"
   "glGetMultiTexLevelParameterivEXT\0"
   "glGetMultiTexParameterIivEXT\0"
   "glGetMultiTexParameterIuivEXT\0"
   "glGetMultiTexParameterfvEXT\0"
   "glGetMultiTexParameterivEXT\0"
   "glGetMultisamplefv\0"
   "glGetMultisamplefvNV\0"
   "glGetNamedBufferParameteri64v\0"
   "glGetNamedBufferParameteriv\0"
   "glGetNamedBufferParameterivEXT\0"
   "glGetNamedBufferParameterui64vNV\0"
   "glGetNamedBufferPointerv\0"
   "glGetNamedBufferPointervEXT\0"
   "glGetNamedBufferSubData\0"
   "glGetNamedBufferSubDataEXT\0"
   "glGetNamedFramebufferAttachmentParameteriv\0"
   "glGetNamedFramebufferAttachmentParameterivEXT\0"
   "glGetNamedFramebufferParameteriv\0"
   "glGetNamedFramebufferParameterivEXT\0"
   "glGetNamedProgramLocalParameterIivEXT\0"
   "glGetNamedProgramLocalParameterIuivEXT\0"
   "glGetNamedProgramLocalParameterdvEXT\0"
   "glGetNamedProgramLocalParameterfvEXT\0"
   "glGetNamedProgramStringEXT\0"
   "glGetNamedProgramivEXT\0"
   "glGetNamedRenderbufferParameteriv\0"
   "glGetNamedRenderbufferParameterivEXT\0"
   "glGetNamedStringARB\0"
   "glGetNamedStringivARB\0"
   "glGetNextPerfQueryIdINTEL\0"
   "glGetObjectBufferfvATI\0"
   "glGetObjectBufferivATI\0"
   "glGetObjectLabel\0"
   "glGetObjectLabelEXT\0"
   "glGetObjectLabelKHR\0"
   "glGetObjectParameterfvARB\0"
   "glGetObjectParameterivAPPLE\0"
   "glGetObjectParameterivARB\0"
   "glGetObjectPtrLabel\0"
   "glGetObjectPtrLabelKHR\0"
   "glGetOcclusionQueryivNV\0"
   "glGetOcclusionQueryuivNV\0"
   "glGetPathColorGenfvNV\0"
   "glGetPathColorGenivNV\0"
   "glGetPathCommandsNV\0"
   "glGetPathCoordsNV\0"
   "glGetPathDashArrayNV\0"
   "glGetPathLengthNV\0"
   "glGetPathMetricRangeNV\0"
   "glGetPathMetricsNV\0"
   "glGetPathParameterfvNV\0"
   "glGetPathParameterivNV\0"
   "glGetPathSpacingNV\0"
   "glGetPathTexGenfvNV\0"
   "glGetPathTexGenivNV\0"
   "glGetPerfCounterInfoINTEL\0"
   "glGetPerfMonitorCounterDataAMD\0"
   "glGetPerfMonitorCounterInfoAMD\0"
   "glGetPerfMonitorCounterStringAMD\0"
   "glGetPerfMonitorCountersAMD\0"
   "glGetPerfMonitorGroupStringAMD\0"
   "glGetPerfMonitorGroupsAMD\0"
   "glGetPerfQueryDataINTEL\0"
   "glGetPerfQueryIdByNameINTEL\0"
   "glGetPerfQueryInfoINTEL\0"
   "glGetPixelMapfv\0"
   "glGetPixelMapuiv\0"
   "glGetPixelMapusv\0"
   "glGetPixelMapxv\0"
   "glGetPixelTexGenParameterfvSGIS\0"
   "glGetPixelTexGenParameterivSGIS\0"
   "glGetPixelTransformParameterfvEXT\0"
   "glGetPixelTransformParameterivEXT\0"
   "glGetPointerIndexedvEXT\0"
   "glGetPointeri_vEXT\0"
   "glGetPointerv\0"
   "glGetPointervEXT\0"
   "glGetPointervKHR\0"
   "glGetPolygonStipple\0"
   "glGetProgramBinary\0"
   "glGetProgramBinaryOES\0"
   "glGetProgramEnvParameterIivNV\0"
   "glGetProgramEnvParameterIuivNV\0"
   "glGetProgramEnvParameterdvARB\0"
   "glGetProgramEnvParameterfvARB\0"
   "glGetProgramInfoLog\0"
   "glGetProgramInterfaceiv\0"
   "glGetProgramLocalParameterIivNV\0"
   "glGetProgramLocalParameterIuivNV\0"
   "glGetProgramLocalParameterdvARB\0"
   "glGetProgramLocalParameterfvARB\0"
   "glGetProgramNamedParameterdvNV\0"
   "glGetProgramNamedParameterfvNV\0"
   "glGetProgramParameterdvNV\0"
   "glGetProgramParameterfvNV\0"
   "glGetProgramPipelineInfoLog\0"
   "glGetProgramPipelineInfoLogEXT\0"
   "glGetProgramPipelineiv\0"
   "glGetProgramPipelineivEXT\0"
   "glGetProgramResourceIndex\0"
   "glGetProgramResourceLocation\0"
   "glGetProgramResourceLocationIndex\0"
   "glGetProgramResourceName\0"
   "glGetProgramResourcefvNV\0"
   "glGetProgramResourceiv\0"
   "glGetProgramStageiv\0"
   "glGetProgramStringARB\0"
   "glGetProgramStringNV\0"
   "glGetProgramSubroutineParameteruivNV\0"
   "glGetProgramiv\0"
   "glGetProgramivARB\0"
   "glGetProgramivNV\0"
   "glGetQueryBufferObjecti64v\0"
   "glGetQueryBufferObjectiv\0"
   "glGetQueryBufferObjectui64v\0"
   "glGetQueryBufferObjectuiv\0"
   "glGetQueryIndexediv\0"
   "glGetQueryObjecti64v\0"
   "glGetQueryObjecti64vEXT\0"
   "glGetQueryObjectiv\0"
   "glGetQueryObjectivARB\0"
   "glGetQueryObjectivEXT\0"
   "glGetQueryObjectui64v\0"
   "glGetQueryObjectui64vEXT\0"
   "glGetQueryObjectuiv\0"
   "glGetQueryObjectuivARB\0"
   "glGetQueryObjectuivEXT\0"
   "glGetQueryiv\0"
   "glGetQueryivARB\0"
   "glGetQueryivEXT\0"
   "glGetRenderbufferParameteriv\0"
   "glGetRenderbufferParameterivEXT\0"
   "glGetRenderbufferParameterivOES\0"
   "glGetSamplerParameterIiv\0"
   "glGetSamplerParameterIivEXT\0"
   "glGetSamplerParameterIivOES\0"
   "glGetSamplerParameterIuiv\0"
   "glGetSamplerParameterIuivEXT\0"
   "glGetSamplerParameterIuivOES\0"
   "glGetSamplerParameterfv\0"
   "glGetSamplerParameteriv\0"
   "glGetSeparableFilter\0"
   "glGetSeparableFilterEXT\0"
   "glGetShaderInfoLog\0"
   "glGetShaderPrecisionFormat\0"
   "glGetShaderSource\0"
   "glGetShaderSourceARB\0"
   "glGetShaderiv\0"
   "glGetSharpenTexFuncSGIS\0"
   "glGetStageIndexNV\0"
   "glGetString\0"
   "glGetStringi\0"
   "glGetSubroutineIndex\0"
   "glGetSubroutineUniformLocation\0"
   "glGetSynciv\0"
   "glGetSyncivAPPLE\0"
   "glGetTexBumpParameterfvATI\0"
   "glGetTexBumpParameterivATI\0"
   "glGetTexEnvfv\0"
   "glGetTexEnviv\0"
   "glGetTexEnvxv\0"
   "glGetTexEnvxvOES\0"
   "glGetTexFilterFuncSGIS\0"
   "glGetTexGendv\0"
   "glGetTexGenfv\0"
   "glGetTexGenfvOES\0"
   "glGetTexGeniv\0"
   "glGetTexGenivOES\0"
   "glGetTexGenxvOES\0"
   "glGetTexImage\0"
   "glGetTexLevelParameterfv\0"
   "glGetTexLevelParameteriv\0"
   "glGetTexLevelParameterxvOES\0"
   "glGetTexParameterIiv\0"
   "glGetTexParameterIivEXT\0"
   "glGetTexParameterIivOES\0"
   "glGetTexParameterIuiv\0"
   "glGetTexParameterIuivEXT\0"
   "glGetTexParameterIuivOES\0"
   "glGetTexParameterPointervAPPLE\0"
   "glGetTexParameterfv\0"
   "glGetTexParameteriv\0"
   "glGetTexParameterxv\0"
   "glGetTexParameterxvOES\0"
   "glGetTextureHandleARB\0"
   "glGetTextureHandleNV\0"
   "glGetTextureImage\0"
   "glGetTextureImageEXT\0"
   "glGetTextureLevelParameterfv\0"
   "glGetTextureLevelParameterfvEXT\0"
   "glGetTextureLevelParameteriv\0"
   "glGetTextureLevelParameterivEXT\0"
   "glGetTextureParameterIiv\0"
   "glGetTextureParameterIivEXT\0"
   "glGetTextureParameterIuiv\0"
   "glGetTextureParameterIuivEXT\0"
   "glGetTextureParameterfv\0"
   "glGetTextureParameterfvEXT\0"
   "glGetTextureParameteriv\0"
   "glGetTextureParameterivEXT\0"
   "glGetTextureSamplerHandleARB\0"
   "glGetTextureSamplerHandleNV\0"
   "glGetTextureSubImage\0"
   "glGetTrackMatrixivNV\0"
   "glGetTransformFeedbackVarying\0"
   "glGetTransformFeedbackVaryingEXT\0"
   "glGetTransformFeedbackVaryingNV\0"
   "glGetTransformFeedbacki64_v\0"
   "glGetTransformFeedbacki_v\0"
   "glGetTransformFeedbackiv\0"
   "glGetTranslatedShaderSourceANGLE\0"
   "glGetUniformBlockIndex\0"
   "glGetUniformBufferSizeEXT\0"
   "glGetUniformIndices\0"
   "glGetUniformLocation\0"
   "glGetUniformLocationARB\0"
   "glGetUniformOffsetEXT\0"
   "glGetUniformSubroutineuiv\0"
   "glGetUniformdv\0"
   "glGetUniformfv\0"
   "glGetUniformfvARB\0"
   "glGetUniformi64vNV\0"
   "glGetUniformiv\0"
   "glGetUniformivARB\0"
   "glGetUniformui64vNV\0"
   "glGetUniformuiv\0"
   "glGetUniformuivEXT\0"
   "glGetVariantArrayObjectfvATI\0"
   "glGetVariantArrayObjectivATI\0"
   "glGetVariantBooleanvEXT\0"
   "glGetVariantFloatvEXT\0"
   "glGetVariantIntegervEXT\0"
   "glGetVariantPointervEXT\0"
   "glGetVaryingLocationNV\0"
   "glGetVertexArrayIndexed64iv\0"
   "glGetVertexArrayIndexediv\0"
   "glGetVertexArrayIntegeri_vEXT\0"
   "glGetVertexArrayIntegervEXT\0"
   "glGetVertexArrayPointeri_vEXT\0"
   "glGetVertexArrayPointervEXT\0"
   "glGetVertexArrayiv\0"
   "glGetVertexAttribArrayObjectfvATI\0"
   "glGetVertexAttribArrayObjectivATI\0"
   "glGetVertexAttribIiv\0"
   "glGetVertexAttribIivEXT\0"
   "glGetVertexAttribIuiv\0"
   "glGetVertexAttribIuivEXT\0"
   "glGetVertexAttribLdv\0"
   "glGetVertexAttribLdvEXT\0"
   "glGetVertexAttribLi64vNV\0"
   "glGetVertexAttribLui64vARB\0"
   "glGetVertexAttribLui64vNV\0"
   "glGetVertexAttribPointerv\0"
   "glGetVertexAttribPointervARB\0"
   "glGetVertexAttribPointervNV\0"
   "glGetVertexAttribdv\0"
   "glGetVertexAttribdvARB\0"
   "glGetVertexAttribdvNV\0"
   "glGetVertexAttribfv\0"
   "glGetVertexAttribfvARB\0"
   "glGetVertexAttribfvNV\0"
   "glGetVertexAttribiv\0"
   "glGetVertexAttribivARB\0"
   "glGetVertexAttribivNV\0"
   "glGetVideoCaptureStreamdvNV\0"
   "glGetVideoCaptureStreamfvNV\0"
   "glGetVideoCaptureStreamivNV\0"
   "glGetVideoCaptureivNV\0"
   "glGetVideoi64vNV\0"
   "glGetVideoivNV\0"
   "glGetVideoui64vNV\0"
   "glGetVideouivNV\0"
   "glGetnColorTable\0"
   "glGetnColorTableARB\0"
   "glGetnCompressedTexImage\0"
   "glGetnCompressedTexImageARB\0"
   "glGetnConvolutionFilter\0"
   "glGetnConvolutionFilterARB\0"
   "glGetnHistogram\0"
   "glGetnHistogramARB\0"
   "glGetnMapdv\0"
   "glGetnMapdvARB\0"
   "glGetnMapfv\0"
   "glGetnMapfvARB\0"
   "glGetnMapiv\0"
   "glGetnMapivARB\0"
   "glGetnMinmax\0"
   "glGetnMinmaxARB\0"
   "glGetnPixelMapfv\0"
   "glGetnPixelMapfvARB\0"
   "glGetnPixelMapuiv\0"
   "glGetnPixelMapuivARB\0"
   "glGetnPixelMapusv\0"
   "glGetnPixelMapusvARB\0"
   "glGetnPolygonStipple\0"
   "glGetnPolygonStippleARB\0"
   "glGetnSeparableFilter\0"
   "glGetnSeparableFilterARB\0"
   "glGetnTexImage\0"
   "glGetnTexImageARB\0"
   "glGetnUniformdv\0"
   "glGetnUniformdvARB\0"
   "glGetnUniformfv\0"
   "glGetnUniformfvARB\0"
   "glGetnUniformfvEXT\0"
   "glGetnUniformfvKHR\0"
   "glGetnUniformiv\0"
   "glGetnUniformivARB\0"
   "glGetnUniformivEXT\0"
   "glGetnUniformivKHR\0"
   "glGetnUniformuiv\0"
   "glGetnUniformuivARB\0"
   "glGetnUniformuivKHR\0"
   "glGlobalAlphaFactorbSUN\0"
   "glGlobalAlphaFactordSUN\0"
   "glGlobalAlphaFactorfSUN\0"
   "glGlobalAlphaFactoriSUN\0"
   "glGlobalAlphaFactorsSUN\0"
   "glGlobalAlphaFactorubSUN\0"
   "glGlobalAlphaFactoruiSUN\0"
   "glGlobalAlphaFactorusSUN\0"
   "glHint\0"
   "glHintPGI\0"
   "glHistogram\0"
   "glHistogramEXT\0"
   "glIglooInterfaceSGIX\0"
   "glImageTransformParameterfHP\0"
   "glImageTransformParameterfvHP\0"
   "glImageTransformParameteriHP\0"
   "glImageTransformParameterivHP\0"
   "glImportSyncEXT\0"
   "glIndexFormatNV\0"
   "glIndexFuncEXT\0"
   "glIndexMask\0"
   "glIndexMaterialEXT\0"
   "glIndexPointer\0"
   "glIndexPointerEXT\0"
   "glIndexPointerListIBM\0"
   "glIndexd\0"
   "glIndexdv\0"
   "glIndexf\0"
   "glIndexfv\0"
   "glIndexi\0"
   "glIndexiv\0"
   "glIndexs\0"
   "glIndexsv\0"
   "glIndexub\0"
   "glIndexubv\0"
   "glIndexxOES\0"
   "glIndexxvOES\0"
   "glInitNames\0"
   "glInsertComponentEXT\0"
   "glInsertEventMarkerEXT\0"
   "glInstrumentsBufferSGIX\0"
   "glInterleavedArrays\0"
   "glInterpolatePathsNV\0"
   "glInvalidateBufferData\0"
   "glInvalidateBufferSubData\0"
   "glInvalidateFramebuffer\0"
   "glInvalidateNamedFramebufferData\0"
   "glInvalidateNamedFramebufferSubData\0"
   "glInvalidateSubFramebuffer\0"
   "glInvalidateTexImage\0"
   "glInvalidateTexSubImage\0"
   "glIsAsyncMarkerSGIX\0"
   "glIsBuffer\0"
   "glIsBufferARB\0"
   "glIsBufferResidentNV\0"
   "glIsCommandListNV\0"
   "glIsEnabled\0"
   "glIsEnabledIndexedEXT\0"
   "glIsEnabledi\0"
   "glIsEnablediEXT\0"
   "glIsEnablediNV\0"
   "glIsEnablediOES\0"
   "glIsFenceAPPLE\0"
   "glIsFenceNV\0"
   "glIsFramebuffer\0"
   "glIsFramebufferEXT\0"
   "glIsFramebufferOES\0"
   "glIsImageHandleResidentARB\0"
   "glIsImageHandleResidentNV\0"
   "glIsList\0"
   "glIsNameAMD\0"
   "glIsNamedBufferResidentNV\0"
   "glIsNamedStringARB\0"
   "glIsObjectBufferATI\0"
   "glIsOcclusionQueryNV\0"
   "glIsPathNV\0"
   "glIsPointInFillPathNV\0"
   "glIsPointInStrokePathNV\0"
   "glIsProgram\0"
   "glIsProgramARB\0"
   "glIsProgramNV\0"
   "glIsProgramPipeline\0"
   "glIsProgramPipelineEXT\0"
   "glIsQuery\0"
   "glIsQueryARB\0"
   "glIsQueryEXT\0"
   "glIsRenderbuffer\0"
   "glIsRenderbufferEXT\0"
   "glIsRenderbufferOES\0"
   "glIsSampler\0"
   "glIsShader\0"
   "glIsStateNV\0"
   "glIsSync\0"
   "glIsSyncAPPLE\0"
   "glIsTexture\0"
   "glIsTextureEXT\0"
   "glIsTextureHandleResidentARB\0"
   "glIsTextureHandleResidentNV\0"
   "glIsTransformFeedback\0"
   "glIsTransformFeedbackNV\0"
   "glIsVariantEnabledEXT\0"
   "glIsVertexArray\0"
   "glIsVertexArrayAPPLE\0"
   "glIsVertexArrayOES\0"
   "glIsVertexAttribEnabledAPPLE\0"
   "glLabelObjectEXT\0"
   "glLightEnviSGIX\0"
   "glLightModelf\0"
   "glLightModelfv\0"
   "glLightModeli\0"
   "glLightModeliv\0"
   "glLightModelx\0"
   "glLightModelxOES\0"
   "glLightModelxv\0"
   "glLightModelxvOES\0"
   "glLightf\0"
   "glLightfv\0"
   "glLighti\0"
   "glLightiv\0"
   "glLightx\0"
   "glLightxOES\0"
   "glLightxv\0"
   "glLightxvOES\0"
   "glLineStipple\0"
   "glLineWidth\0"
   "glLineWidthx\0"
   "glLineWidthxOES\0"
   "glLinkProgram\0"
   "glLinkProgramARB\0"
   "glListBase\0"
   "glListDrawCommandsStatesClientNV\0"
   "glListParameterfSGIX\0"
   "glListParameterfvSGIX\0"
   "glListParameteriSGIX\0"
   "glListParameterivSGIX\0"
   "glLoadIdentity\0"
   "glLoadIdentityDeformationMapSGIX\0"
   "glLoadMatrixd\0"
   "glLoadMatrixf\0"
   "glLoadMatrixx\0"
   "glLoadMatrixxOES\0"
   "glLoadName\0"
   "glLoadPaletteFromModelViewMatrixOES\0"
   "glLoadProgramNV\0"
   "glLoadTransposeMatrixd\0"
   "glLoadTransposeMatrixdARB\0"
   "glLoadTransposeMatrixf\0"
   "glLoadTransposeMatrixfARB\0"
   "glLoadTransposeMatrixxOES\0"
   "glLockArraysEXT\0"
   "glLogicOp\0"
   "glMakeBufferNonResidentNV\0"
   "glMakeBufferResidentNV\0"
   "glMakeImageHandleNonResidentARB\0"
   "glMakeImageHandleNonResidentNV\0"
   "glMakeImageHandleResidentARB\0"
   "glMakeImageHandleResidentNV\0"
   "glMakeNamedBufferNonResidentNV\0"
   "glMakeNamedBufferResidentNV\0"
   "glMakeTextureHandleNonResidentARB\0"
   "glMakeTextureHandleNonResidentNV\0"
   "glMakeTextureHandleResidentARB\0"
   "glMakeTextureHandleResidentNV\0"
   "glMap1d\0"
   "glMap1f\0"
   "glMap1xOES\0"
   "glMap2d\0"
   "glMap2f\0"
   "glMap2xOES\0"
   "glMapBuffer\0"
   "glMapBufferARB\0"
   "glMapBufferOES\0"
   "glMapBufferRange\0"
   "glMapBufferRangeEXT\0"
   "glMapControlPointsNV\0"
   "glMapGrid1d\0"
   "glMapGrid1f\0"
   "glMapGrid1xOES\0"
   "glMapGrid2d\0"
   "glMapGrid2f\0"
   "glMapGrid2xOES\0"
   "glMapNamedBuffer\0"
   "glMapNamedBufferEXT\0"
   "glMapNamedBufferRange\0"
   "glMapNamedBufferRangeEXT\0"
   "glMapObjectBufferATI\0"
   "glMapParameterfvNV\0"
   "glMapParameterivNV\0"
   "glMapTexture2DINTEL\0"
   "glMapVertexAttrib1dAPPLE\0"
   "glMapVertexAttrib1fAPPLE\0"
   "glMapVertexAttrib2dAPPLE\0"
   "glMapVertexAttrib2fAPPLE\0"
   "glMaterialf\0"
   "glMaterialfv\0"
   "glMateriali\0"
   "glMaterialiv\0"
   "glMaterialx\0"
   "glMaterialxOES\0"
   "glMaterialxv\0"
   "glMaterialxvOES\0"
   "glMatrixFrustumEXT\0"
   "glMatrixIndexPointerARB\0"
   "glMatrixIndexPointerOES\0"
   "glMatrixIndexubvARB\0"
   "glMatrixIndexuivARB\0"
   "glMatrixIndexusvARB\0"
   "glMatrixLoad3x2fNV\0"
   "glMatrixLoad3x3fNV\0"
   "glMatrixLoadIdentityEXT\0"
   "glMatrixLoadTranspose3x3fNV\0"
   "glMatrixLoadTransposedEXT\0"
   "glMatrixLoadTransposefEXT\0"
   "glMatrixLoaddEXT\0"
   "glMatrixLoadfEXT\0"
   "glMatrixMode\0"
   "glMatrixMult3x2fNV\0"
   "glMatrixMult3x3fNV\0"
   "glMatrixMultTranspose3x3fNV\0"
   "glMatrixMultTransposedEXT\0"
   "glMatrixMultTransposefEXT\0"
   "glMatrixMultdEXT\0"
   "glMatrixMultfEXT\0"
   "glMatrixOrthoEXT\0"
   "glMatrixPopEXT\0"
   "glMatrixPushEXT\0"
   "glMatrixRotatedEXT\0"
   "glMatrixRotatefEXT\0"
   "glMatrixScaledEXT\0"
   "glMatrixScalefEXT\0"
   "glMatrixTranslatedEXT\0"
   "glMatrixTranslatefEXT\0"
   "glMemoryBarrier\0"
   "glMemoryBarrierByRegion\0"
   "glMemoryBarrierEXT\0"
   "glMinSampleShading\0"
   "glMinSampleShadingARB\0"
   "glMinSampleShadingOES\0"
   "glMinmax\0"
   "glMinmaxEXT\0"
   "glMultMatrixd\0"
   "glMultMatrixf\0"
   "glMultMatrixx\0"
   "glMultMatrixxOES\0"
   "glMultTransposeMatrixd\0"
   "glMultTransposeMatrixdARB\0"
   "glMultTransposeMatrixf\0"
   "glMultTransposeMatrixfARB\0"
   "glMultTransposeMatrixxOES\0"
   "glMultiDrawArrays\0"
   "glMultiDrawArraysEXT\0"
   "glMultiDrawArraysIndirect\0"
   "glMultiDrawArraysIndirectAMD\0"
   "glMultiDrawArraysIndirectBindlessCountNV\0"
   "glMultiDrawArraysIndirectBindlessNV\0"
   "glMultiDrawArraysIndirectCountARB\0"
   "glMultiDrawArraysIndirectEXT\0"
   "glMultiDrawElementArrayAPPLE\0"
   "glMultiDrawElements\0"
   "glMultiDrawElementsBaseVertex\0"
   "glMultiDrawElementsBaseVertexEXT\0"
   "glMultiDrawElementsBaseVertexOES\0"
   "glMultiDrawElementsEXT\0"
   "glMultiDrawElementsIndirect\0"
   "glMultiDrawElementsIndirectAMD\0"
   "glMultiDrawElementsIndirectBindlessCountNV\0"
   "glMultiDrawElementsIndirectBindlessNV\0"
   "glMultiDrawElementsIndirectCountARB\0"
   "glMultiDrawElementsIndirectEXT\0"
   "glMultiDrawRangeElementArrayAPPLE\0"
   "glMultiModeDrawArraysIBM\0"
   "glMultiModeDrawElementsIBM\0"
   "glMultiTexBufferEXT\0"
   "glMultiTexCoord1bOES\0"
   "glMultiTexCoord1bvOES\0"
   "glMultiTexCoord1d\0"
   "glMultiTexCoord1dARB\0"
   "glMultiTexCoord1dv\0"
   "glMultiTexCoord1dvARB\0"
   "glMultiTexCoord1f\0"
   "glMultiTexCoord1fARB\0"
   "glMultiTexCoord1fv\0"
   "glMultiTexCoord1fvARB\0"
   "glMultiTexCoord1hNV\0"
   "glMultiTexCoord1hvNV\0"
   "glMultiTexCoord1i\0"
   "glMultiTexCoord1iARB\0"
   "glMultiTexCoord1iv\0"
   "glMultiTexCoord1ivARB\0"
   "glMultiTexCoord1s\0"
   "glMultiTexCoord1sARB\0"
   "glMultiTexCoord1sv\0"
   "glMultiTexCoord1svARB\0"
   "glMultiTexCoord1xOES\0"
   "glMultiTexCoord1xvOES\0"
   "glMultiTexCoord2bOES\0"
   "glMultiTexCoord2bvOES\0"
   "glMultiTexCoord2d\0"
   "glMultiTexCoord2dARB\0"
   "glMultiTexCoord2dv\0"
   "glMultiTexCoord2dvARB\0"
   "glMultiTexCoord2f\0"
   "glMultiTexCoord2fARB\0"
   "glMultiTexCoord2fv\0"
   "glMultiTexCoord2fvARB\0"
   "glMultiTexCoord2hNV\0"
   "glMultiTexCoord2hvNV\0"
   "glMultiTexCoord2i\0"
   "glMultiTexCoord2iARB\0"
   "glMultiTexCoord2iv\0"
   "glMultiTexCoord2ivARB\0"
   "glMultiTexCoord2s\0"
   "glMultiTexCoord2sARB\0"
   "glMultiTexCoord2sv\0"
   "glMultiTexCoord2svARB\0"
   "glMultiTexCoord2xOES\0"
   "glMultiTexCoord2xvOES\0"
   "glMultiTexCoord3bOES\0"
   "glMultiTexCoord3bvOES\0"
   "glMultiTexCoord3d\0"
   "glMultiTexCoord3dARB\0"
   "glMultiTexCoord3dv\0"
   "glMultiTexCoord3dvARB\0"
   "glMultiTexCoord3f\0"
   "glMultiTexCoord3fARB\0"
   "glMultiTexCoord3fv\0"
   "glMultiTexCoord3fvARB\0"
   "glMultiTexCoord3hNV\0"
   "glMultiTexCoord3hvNV\0"
   "glMultiTexCoord3i\0"
   "glMultiTexCoord3iARB\0"
   "glMultiTexCoord3iv\0"
   "glMultiTexCoord3ivARB\0"
   "glMultiTexCoord3s\0"
   "glMultiTexCoord3sARB\0"
   "glMultiTexCoord3sv\0"
   "glMultiTexCoord3svARB\0"
   "glMultiTexCoord3xOES\0"
   "glMultiTexCoord3xvOES\0"
   "glMultiTexCoord4bOES\0"
   "glMultiTexCoord4bvOES\0"
   "glMultiTexCoord4d\0"
   "glMultiTexCoord4dARB\0"
   "glMultiTexCoord4dv\0"
   "glMultiTexCoord4dvARB\0"
   "glMultiTexCoord4f\0"
   "glMultiTexCoord4fARB\0"
   "glMultiTexCoord4fv\0"
   "glMultiTexCoord4fvARB\0"
   "glMultiTexCoord4hNV\0"
   "glMultiTexCoord4hvNV\0"
   "glMultiTexCoord4i\0"
   "glMultiTexCoord4iARB\0"
   "glMultiTexCoord4iv\0"
   "glMultiTexCoord4ivARB\0"
   "glMultiTexCoord4s\0"
   "glMultiTexCoord4sARB\0"
   "glMultiTexCoord4sv\0"
   "glMultiTexCoord4svARB\0"
   "glMultiTexCoord4x\0"
   "glMultiTexCoord4xOES\0"
   "glMultiTexCoord4xvOES\0"
   "glMultiTexCoordP1ui\0"
   "glMultiTexCoordP1uiv\0"
   "glMultiTexCoordP2ui\0"
   "glMultiTexCoordP2uiv\0"
   "glMultiTexCoordP3ui\0"
   "glMultiTexCoordP3uiv\0"
   "glMultiTexCoordP4ui\0"
   "glMultiTexCoordP4uiv\0"
   "glMultiTexCoordPointerEXT\0"
   "glMultiTexEnvfEXT\0"
   "glMultiTexEnvfvEXT\0"
   "glMultiTexEnviEXT\0"
   "glMultiTexEnvivEXT\0"
   "glMultiTexGendEXT\0"
   "glMultiTexGendvEXT\0"
   "glMultiTexGenfEXT\0"
   "glMultiTexGenfvEXT\0"
   "glMultiTexGeniEXT\0"
   "glMultiTexGenivEXT\0"
   "glMultiTexImage1DEXT\0"
   "glMultiTexImage2DEXT\0"
   "glMultiTexImage3DEXT\0"
   "glMultiTexParameterIivEXT\0"
   "glMultiTexParameterIuivEXT\0"
   "glMultiTexParameterfEXT\0"
   "glMultiTexParameterfvEXT\0"
   "glMultiTexParameteriEXT\0"
   "glMultiTexParameterivEXT\0"
   "glMultiTexRenderbufferEXT\0"
   "glMultiTexSubImage1DEXT\0"
   "glMultiTexSubImage2DEXT\0"
   "glMultiTexSubImage3DEXT\0"
   "glNamedBufferData\0"
   "glNamedBufferDataEXT\0"
   "glNamedBufferPageCommitmentARB\0"
   "glNamedBufferPageCommitmentEXT\0"
   "glNamedBufferStorage\0"
   "glNamedBufferStorageEXT\0"
   "glNamedBufferSubData\0"
   "glNamedBufferSubDataEXT\0"
   "glNamedCopyBufferSubDataEXT\0"
   "glNamedFramebufferDrawBuffer\0"
   "glNamedFramebufferDrawBuffers\0"
   "glNamedFramebufferParameteri\0"
   "glNamedFramebufferParameteriEXT\0"
   "glNamedFramebufferReadBuffer\0"
   "glNamedFramebufferRenderbuffer\0"
   "glNamedFramebufferRenderbufferEXT\0"
   "glNamedFramebufferSampleLocationsfvNV\0"
   "glNamedFramebufferTexture\0"
   "glNamedFramebufferTexture1DEXT\0"
   "glNamedFramebufferTexture2DEXT\0"
   "glNamedFramebufferTexture3DEXT\0"
   "glNamedFramebufferTextureEXT\0"
   "glNamedFramebufferTextureFaceEXT\0"
   "glNamedFramebufferTextureLayer\0"
   "glNamedFramebufferTextureLayerEXT\0"
   "glNamedProgramLocalParameter4dEXT\0"
   "glNamedProgramLocalParameter4dvEXT\0"
   "glNamedProgramLocalParameter4fEXT\0"
   "glNamedProgramLocalParameter4fvEXT\0"
   "glNamedProgramLocalParameterI4iEXT\0"
   "glNamedProgramLocalParameterI4ivEXT\0"
   "glNamedProgramLocalParameterI4uiEXT\0"
   "glNamedProgramLocalParameterI4uivEXT\0"
   "glNamedProgramLocalParameters4fvEXT\0"
   "glNamedProgramLocalParametersI4ivEXT\0"
   "glNamedProgramLocalParametersI4uivEXT\0"
   "glNamedProgramStringEXT\0"
   "glNamedRenderbufferStorage\0"
   "glNamedRenderbufferStorageEXT\0"
   "glNamedRenderbufferStorageMultisample\0"
   "glNamedRenderbufferStorageMultisampleCoverageEXT\0"
   "glNamedRenderbufferStorageMultisampleEXT\0"
   "glNamedStringARB\0"
   "glNewList\0"
   "glNewObjectBufferATI\0"
   "glNormal3b\0"
   "glNormal3bv\0"
   "glNormal3d\0"
   "glNormal3dv\0"
   "glNormal3f\0"
   "glNormal3fVertex3fSUN\0"
   "glNormal3fVertex3fvSUN\0"
   "glNormal3fv\0"
   "glNormal3hNV\0"
   "glNormal3hvNV\0"
   "glNormal3i\0"
   "glNormal3iv\0"
   "glNormal3s\0"
   "glNormal3sv\0"
   "glNormal3x\0"
   "glNormal3xOES\0"
   "glNormal3xvOES\0"
   "glNormalFormatNV\0"
   "glNormalP3ui\0"
   "glNormalP3uiv\0"
   "glNormalPointer\0"
   "glNormalPointerEXT\0"
   "glNormalPointerListIBM\0"
   "glNormalPointervINTEL\0"
   "glNormalStream3bATI\0"
   "glNormalStream3bvATI\0"
   "glNormalStream3dATI\0"
   "glNormalStream3dvATI\0"
   "glNormalStream3fATI\0"
   "glNormalStream3fvATI\0"
   "glNormalStream3iATI\0"
   "glNormalStream3ivATI\0"
   "glNormalStream3sATI\0"
   "glNormalStream3svATI\0"
   "glObjectLabel\0"
   "glObjectLabelKHR\0"
   "glObjectPtrLabel\0"
   "glObjectPtrLabelKHR\0"
   "glObjectPurgeableAPPLE\0"
   "glObjectUnpurgeableAPPLE\0"
   "glOrtho\0"
   "glOrthof\0"
   "glOrthofOES\0"
   "glOrthox\0"
   "glOrthoxOES\0"
   "glPNTrianglesfATI\0"
   "glPNTrianglesiATI\0"
   "glPassTexCoordATI\0"
   "glPassThrough\0"
   "glPassThroughxOES\0"
   "glPatchParameterfv\0"
   "glPatchParameteri\0"
   "glPatchParameteriEXT\0"
   "glPatchParameteriOES\0"
   "glPathColorGenNV\0"
   "glPathCommandsNV\0"
   "glPathCoordsNV\0"
   "glPathCoverDepthFuncNV\0"
   "glPathDashArrayNV\0"
   "glPathFogGenNV\0"
   "glPathGlyphIndexArrayNV\0"
   "glPathGlyphIndexRangeNV\0"
   "glPathGlyphRangeNV\0"
   "glPathGlyphsNV\0"
   "glPathMemoryGlyphIndexArrayNV\0"
   "glPathParameterfNV\0"
   "glPathParameterfvNV\0"
   "glPathParameteriNV\0"
   "glPathParameterivNV\0"
   "glPathStencilDepthOffsetNV\0"
   "glPathStencilFuncNV\0"
   "glPathStringNV\0"
   "glPathSubCommandsNV\0"
   "glPathSubCoordsNV\0"
   "glPathTexGenNV\0"
   "glPauseTransformFeedback\0"
   "glPauseTransformFeedbackNV\0"
   "glPixelDataRangeNV\0"
   "glPixelMapfv\0"
   "glPixelMapuiv\0"
   "glPixelMapusv\0"
   "glPixelMapx\0"
   "glPixelStoref\0"
   "glPixelStorei\0"
   "glPixelStorex\0"
   "glPixelTexGenParameterfSGIS\0"
   "glPixelTexGenParameterfvSGIS\0"
   "glPixelTexGenParameteriSGIS\0"
   "glPixelTexGenParameterivSGIS\0"
   "glPixelTexGenSGIX\0"
   "glPixelTransferf\0"
   "glPixelTransferi\0"
   "glPixelTransferxOES\0"
   "glPixelTransformParameterfEXT\0"
   "glPixelTransformParameterfvEXT\0"
   "glPixelTransformParameteriEXT\0"
   "glPixelTransformParameterivEXT\0"
   "glPixelZoom\0"
   "glPixelZoomxOES\0"
   "glPointAlongPathNV\0"
   "glPointParameterf\0"
   "glPointParameterfARB\0"
   "glPointParameterfEXT\0"
   "glPointParameterfSGIS\0"
   "glPointParameterfv\0"
   "glPointParameterfvARB\0"
   "glPointParameterfvEXT\0"
   "glPointParameterfvSGIS\0"
   "glPointParameteri\0"
   "glPointParameteriNV\0"
   "glPointParameteriv\0"
   "glPointParameterivNV\0"
   "glPointParameterx\0"
   "glPointParameterxOES\0"
   "glPointParameterxv\0"
   "glPointParameterxvOES\0"
   "glPointSize\0"
   "glPointSizePointerOES\0"
   "glPointSizex\0"
   "glPointSizexOES\0"
   "glPollAsyncSGIX\0"
   "glPollInstrumentsSGIX\0"
   "glPolygonMode\0"
   "glPolygonModeNV\0"
   "glPolygonOffset\0"
   "glPolygonOffsetClampEXT\0"
   "glPolygonOffsetEXT\0"
   "glPolygonOffsetx\0"
   "glPolygonOffsetxOES\0"
   "glPolygonStipple\0"
   "glPopAttrib\0"
   "glPopClientAttrib\0"
   "glPopDebugGroup\0"
   "glPopDebugGroupKHR\0"
   "glPopGroupMarkerEXT\0"
   "glPopMatrix\0"
   "glPopName\0"
   "glPresentFrameDualFillNV\0"
   "glPresentFrameKeyedNV\0"
   "glPrimitiveBoundingBoxEXT\0"
   "glPrimitiveBoundingBoxOES\0"
   "glPrimitiveRestartIndex\0"
   "glPrimitiveRestartIndexNV\0"
   "glPrimitiveRestartNV\0"
   "glPrioritizeTextures\0"
   "glPrioritizeTexturesEXT\0"
   "glPrioritizeTexturesxOES\0"
   "glProgramBinary\0"
   "glProgramBinaryOES\0"
   "glProgramBufferParametersIivNV\0"
   "glProgramBufferParametersIuivNV\0"
   "glProgramBufferParametersfvNV\0"
   "glProgramEnvParameter4dARB\0"
   "glProgramEnvParameter4dvARB\0"
   "glProgramEnvParameter4fARB\0"
   "glProgramEnvParameter4fvARB\0"
   "glProgramEnvParameterI4iNV\0"
   "glProgramEnvParameterI4ivNV\0"
   "glProgramEnvParameterI4uiNV\0"
   "glProgramEnvParameterI4uivNV\0"
   "glProgramEnvParameters4fvEXT\0"
   "glProgramEnvParametersI4ivNV\0"
   "glProgramEnvParametersI4uivNV\0"
   "glProgramLocalParameter4dARB\0"
   "glProgramLocalParameter4dvARB\0"
   "glProgramLocalParameter4fARB\0"
   "glProgramLocalParameter4fvARB\0"
   "glProgramLocalParameterI4iNV\0"
   "glProgramLocalParameterI4ivNV\0"
   "glProgramLocalParameterI4uiNV\0"
   "glProgramLocalParameterI4uivNV\0"
   "glProgramLocalParameters4fvEXT\0"
   "glProgramLocalParametersI4ivNV\0"
   "glProgramLocalParametersI4uivNV\0"
   "glProgramNamedParameter4dNV\0"
   "glProgramNamedParameter4dvNV\0"
   "glProgramNamedParameter4fNV\0"
   "glProgramNamedParameter4fvNV\0"
   "glProgramParameter4dNV\0"
   "glProgramParameter4dvNV\0"
   "glProgramParameter4fNV\0"
   "glProgramParameter4fvNV\0"
   "glProgramParameteri\0"
   "glProgramParameteriARB\0"
   "glProgramParameteriEXT\0"
   "glProgramParameters4dvNV\0"
   "glProgramParameters4fvNV\0"
   "glProgramPathFragmentInputGenNV\0"
   "glProgramStringARB\0"
   "glProgramSubroutineParametersuivNV\0"
   "glProgramUniform1d\0"
   "glProgramUniform1dEXT\0"
   "glProgramUniform1dv\0"
   "glProgramUniform1dvEXT\0"
   "glProgramUniform1f\0"
   "glProgramUniform1fEXT\0"
   "glProgramUniform1fv\0"
   "glProgramUniform1fvEXT\0"
   "glProgramUniform1i\0"
   "glProgramUniform1i64NV\0"
   "glProgramUniform1i64vNV\0"
   "glProgramUniform1iEXT\0"
   "glProgramUniform1iv\0"
   "glProgramUniform1ivEXT\0"
   "glProgramUniform1ui\0"
   "glProgramUniform1ui64NV\0"
   "glProgramUniform1ui64vNV\0"
   "glProgramUniform1uiEXT\0"
   "glProgramUniform1uiv\0"
   "glProgramUniform1uivEXT\0"
   "glProgramUniform2d\0"
   "glProgramUniform2dEXT\0"
   "glProgramUniform2dv\0"
   "glProgramUniform2dvEXT\0"
   "glProgramUniform2f\0"
   "glProgramUniform2fEXT\0"
   "glProgramUniform2fv\0"
   "glProgramUniform2fvEXT\0"
   "glProgramUniform2i\0"
   "glProgramUniform2i64NV\0"
   "glProgramUniform2i64vNV\0"
   "glProgramUniform2iEXT\0"
   "glProgramUniform2iv\0"
   "glProgramUniform2ivEXT\0"
   "glProgramUniform2ui\0"
   "glProgramUniform2ui64NV\0"
   "glProgramUniform2ui64vNV\0"
   "glProgramUniform2uiEXT\0"
   "glProgramUniform2uiv\0"
   "glProgramUniform2uivEXT\0"
   "glProgramUniform3d\0"
   "glProgramUniform3dEXT\0"
   "glProgramUniform3dv\0"
   "glProgramUniform3dvEXT\0"
   "glProgramUniform3f\0"
   "glProgramUniform3fEXT\0"
   "glProgramUniform3fv\0"
   "glProgramUniform3fvEXT\0"
   "glProgramUniform3i\0"
   "glProgramUniform3i64NV\0"
   "glProgramUniform3i64vNV\0"
   "glProgramUniform3iEXT\0"
   "glProgramUniform3iv\0"
   "glProgramUniform3ivEXT\0"
   "glProgramUniform3ui\0"
   "glProgramUniform3ui64NV\0"
   "glProgramUniform3ui64vNV\0"
   "glProgramUniform3uiEXT\0"
   "glProgramUniform3uiv\0"
   "glProgramUniform3uivEXT\0"
   "glProgramUniform4d\0"
   "glProgramUniform4dEXT\0"
   "glProgramUniform4dv\0"
   "glProgramUniform4dvEXT\0"
   "glProgramUniform4f\0"
   "glProgramUniform4fEXT\0"
   "glProgramUniform4fv\0"
   "glProgramUniform4fvEXT\0"
   "glProgramUniform4i\0"
   "glProgramUniform4i64NV\0"
   "glProgramUniform4i64vNV\0"
   "glProgramUniform4iEXT\0"
   "glProgramUniform4iv\0"
   "glProgramUniform4ivEXT\0"
   "glProgramUniform4ui\0"
   "glProgramUniform4ui64NV\0"
   "glProgramUniform4ui64vNV\0"
   "glProgramUniform4uiEXT\0"
   "glProgramUniform4uiv\0"
   "glProgramUniform4uivEXT\0"
   "glProgramUniformHandleui64ARB\0"
   "glProgramUniformHandleui64NV\0"
   "glProgramUniformHandleui64vARB\0"
   "glProgramUniformHandleui64vNV\0"
   "glProgramUniformMatrix2dv\0"
   "glProgramUniformMatrix2dvEXT\0"
   "glProgramUniformMatrix2fv\0"
   "glProgramUniformMatrix2fvEXT\0"
   "glProgramUniformMatrix2x3dv\0"
   "glProgramUniformMatrix2x3dvEXT\0"
   "glProgramUniformMatrix2x3fv\0"
   "glProgramUniformMatrix2x3fvEXT\0"
   "glProgramUniformMatrix2x4dv\0"
   "glProgramUniformMatrix2x4dvEXT\0"
   "glProgramUniformMatrix2x4fv\0"
   "glProgramUniformMatrix2x4fvEXT\0"
   "glProgramUniformMatrix3dv\0"
   "glProgramUniformMatrix3dvEXT\0"
   "glProgramUniformMatrix3fv\0"
   "glProgramUniformMatrix3fvEXT\0"
   "glProgramUniformMatrix3x2dv\0"
   "glProgramUniformMatrix3x2dvEXT\0"
   "glProgramUniformMatrix3x2fv\0"
   "glProgramUniformMatrix3x2fvEXT\0"
   "glProgramUniformMatrix3x4dv\0"
   "glProgramUniformMatrix3x4dvEXT\0"
   "glProgramUniformMatrix3x4fv\0"
   "glProgramUniformMatrix3x4fvEXT\0"
   "glProgramUniformMatrix4dv\0"
   "glProgramUniformMatrix4dvEXT\0"
   "glProgramUniformMatrix4fv\0"
   "glProgramUniformMatrix4fvEXT\0"
   "glProgramUniformMatrix4x2dv\0"
   "glProgramUniformMatrix4x2dvEXT\0"
   "glProgramUniformMatrix4x2fv\0"
   "glProgramUniformMatrix4x2fvEXT\0"
   "glProgramUniformMatrix4x3dv\0"
   "glProgramUniformMatrix4x3dvEXT\0"
   "glProgramUniformMatrix4x3fv\0"
   "glProgramUniformMatrix4x3fvEXT\0"
   "glProgramUniformui64NV\0"
   "glProgramUniformui64vNV\0"
   "glProgramVertexLimitNV\0"
   "glProvokingVertex\0"
   "glProvokingVertexEXT\0"
   "glPushAttrib\0"
   "glPushClientAttrib\0"
   "glPushClientAttribDefaultEXT\0"
   "glPushDebugGroup\0"
   "glPushDebugGroupKHR\0"
   "glPushGroupMarkerEXT\0"
   "glPushMatrix\0"
   "glPushName\0"
   "glQueryCounter\0"
   "glQueryCounterEXT\0"
   "glQueryMatrixxOES\0"
   "glQueryObjectParameteruiAMD\0"
   "glRasterPos2d\0"
   "glRasterPos2dv\0"
   "glRasterPos2f\0"
   "glRasterPos2fv\0"
   "glRasterPos2i\0"
   "glRasterPos2iv\0"
   "glRasterPos2s\0"
   "glRasterPos2sv\0"
   "glRasterPos2xOES\0"
   "glRasterPos2xvOES\0"
   "glRasterPos3d\0"
   "glRasterPos3dv\0"
   "glRasterPos3f\0"
   "glRasterPos3fv\0"
   "glRasterPos3i\0"
   "glRasterPos3iv\0"
   "glRasterPos3s\0"
   "glRasterPos3sv\0"
   "glRasterPos3xOES\0"
   "glRasterPos3xvOES\0"
   "glRasterPos4d\0"
   "glRasterPos4dv\0"
   "glRasterPos4f\0"
   "glRasterPos4fv\0"
   "glRasterPos4i\0"
   "glRasterPos4iv\0"
   "glRasterPos4s\0"
   "glRasterPos4sv\0"
   "glRasterPos4xOES\0"
   "glRasterPos4xvOES\0"
   "glRasterSamplesEXT\0"
   "glReadBuffer\0"
   "glReadBufferIndexedEXT\0"
   "glReadBufferNV\0"
   "glReadInstrumentsSGIX\0"
   "glReadPixels\0"
   "glReadnPixels\0"
   "glReadnPixelsARB\0"
   "glReadnPixelsEXT\0"
   "glReadnPixelsKHR\0"
   "glRectd\0"
   "glRectdv\0"
   "glRectf\0"
   "glRectfv\0"
   "glRecti\0"
   "glRectiv\0"
   "glRects\0"
   "glRectsv\0"
   "glRectxOES\0"
   "glRectxvOES\0"
   "glReferencePlaneSGIX\0"
   "glReleaseShaderCompiler\0"
   "glRenderMode\0"
   "glRenderbufferStorage\0"
   "glRenderbufferStorageEXT\0"
   "glRenderbufferStorageMultisample\0"
   "glRenderbufferStorageMultisampleANGLE\0"
   "glRenderbufferStorageMultisampleAPPLE\0"
   "glRenderbufferStorageMultisampleCoverageNV\0"
   "glRenderbufferStorageMultisampleEXT\0"
   "glRenderbufferStorageMultisampleIMG\0"
   "glRenderbufferStorageMultisampleNV\0"
   "glRenderbufferStorageOES\0"
   "glReplacementCodePointerSUN\0"
   "glReplacementCodeubSUN\0"
   "glReplacementCodeubvSUN\0"
   "glReplacementCodeuiColor3fVertex3fSUN\0"
   "glReplacementCodeuiColor3fVertex3fvSUN\0"
   "glReplacementCodeuiColor4fNormal3fVertex3fSUN\0"
   "glReplacementCodeuiColor4fNormal3fVertex3fvSUN\0"
   "glReplacementCodeuiColor4ubVertex3fSUN\0"
   "glReplacementCodeuiColor4ubVertex3fvSUN\0"
   "glReplacementCodeuiNormal3fVertex3fSUN\0"
   "glReplacementCodeuiNormal3fVertex3fvSUN\0"
   "glReplacementCodeuiSUN\0"
   "glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN\0"
   "glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN\0"
   "glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN\0"
   "glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN\0"
   "glReplacementCodeuiTexCoord2fVertex3fSUN\0"
   "glReplacementCodeuiTexCoord2fVertex3fvSUN\0"
   "glReplacementCodeuiVertex3fSUN\0"
   "glReplacementCodeuiVertex3fvSUN\0"
   "glReplacementCodeuivSUN\0"
   "glReplacementCodeusSUN\0"
   "glReplacementCodeusvSUN\0"
   "glRequestResidentProgramsNV\0"
   "glResetHistogram\0"
   "glResetHistogramEXT\0"
   "glResetMinmax\0"
   "glResetMinmaxEXT\0"
   "glResizeBuffersMESA\0"
   "glResolveDepthValuesNV\0"
   "glResolveMultisampleFramebufferAPPLE\0"
   "glResumeTransformFeedback\0"
   "glResumeTransformFeedbackNV\0"
   "glRotated\0"
   "glRotatef\0"
   "glRotatex\0"
   "glRotatexOES\0"
   "glSampleCoverage\0"
   "glSampleCoverageARB\0"
   "glSampleCoveragex\0"
   "glSampleCoveragexOES\0"
   "glSampleMapATI\0"
   "glSampleMaskEXT\0"
   "glSampleMaskIndexedNV\0"
   "glSampleMaskSGIS\0"
   "glSampleMaski\0"
   "glSamplePatternEXT\0"
   "glSamplePatternSGIS\0"
   "glSamplerParameterIiv\0"
   "glSamplerParameterIivEXT\0"
   "glSamplerParameterIivOES\0"
   "glSamplerParameterIuiv\0"
   "glSamplerParameterIuivEXT\0"
   "glSamplerParameterIuivOES\0"
   "glSamplerParameterf\0"
   "glSamplerParameterfv\0"
   "glSamplerParameteri\0"
   "glSamplerParameteriv\0"
   "glScaled\0"
   "glScalef\0"
   "glScalex\0"
   "glScalexOES\0"
   "glScissor\0"
   "glScissorArrayv\0"
   "glScissorArrayvNV\0"
   "glScissorIndexed\0"
   "glScissorIndexedNV\0"
   "glScissorIndexedv\0"
   "glScissorIndexedvNV\0"
   "glSecondaryColor3b\0"
   "glSecondaryColor3bEXT\0"
   "glSecondaryColor3bv\0"
   "glSecondaryColor3bvEXT\0"
   "glSecondaryColor3d\0"
   "glSecondaryColor3dEXT\0"
   "glSecondaryColor3dv\0"
   "glSecondaryColor3dvEXT\0"
   "glSecondaryColor3f\0"
   "glSecondaryColor3fEXT\0"
   "glSecondaryColor3fv\0"
   "glSecondaryColor3fvEXT\0"
   "glSecondaryColor3hNV\0"
   "glSecondaryColor3hvNV\0"
   "glSecondaryColor3i\0"
   "glSecondaryColor3iEXT\0"
   "glSecondaryColor3iv\0"
   "glSecondaryColor3ivEXT\0"
   "glSecondaryColor3s\0"
   "glSecondaryColor3sEXT\0"
   "glSecondaryColor3sv\0"
   "glSecondaryColor3svEXT\0"
   "glSecondaryColor3ub\0"
   "glSecondaryColor3ubEXT\0"
   "glSecondaryColor3ubv\0"
   "glSecondaryColor3ubvEXT\0"
   "glSecondaryColor3ui\0"
   "glSecondaryColor3uiEXT\0"
   "glSecondaryColor3uiv\0"
   "glSecondaryColor3uivEXT\0"
   "glSecondaryColor3us\0"
   "glSecondaryColor3usEXT\0"
   "glSecondaryColor3usv\0"
   "glSecondaryColor3usvEXT\0"
   "glSecondaryColorFormatNV\0"
   "glSecondaryColorP3ui\0"
   "glSecondaryColorP3uiv\0"
   "glSecondaryColorPointer\0"
   "glSecondaryColorPointerEXT\0"
   "glSecondaryColorPointerListIBM\0"
   "glSelectBuffer\0"
   "glSelectPerfMonitorCountersAMD\0"
   "glSeparableFilter2D\0"
   "glSeparableFilter2DEXT\0"
   "glSetFenceAPPLE\0"
   "glSetFenceNV\0"
   "glSetFragmentShaderConstantATI\0"
   "glSetInvariantEXT\0"
   "glSetLocalConstantEXT\0"
   "glSetMultisamplefvAMD\0"
   "glShadeModel\0"
   "glShaderBinary\0"
   "glShaderOp1EXT\0"
   "glShaderOp2EXT\0"
   "glShaderOp3EXT\0"
   "glShaderSource\0"
   "glShaderSourceARB\0"
   "glShaderStorageBlockBinding\0"
   "glSharpenTexFuncSGIS\0"
   "glSpriteParameterfSGIX\0"
   "glSpriteParameterfvSGIX\0"
   "glSpriteParameteriSGIX\0"
   "glSpriteParameterivSGIX\0"
   "glStartInstrumentsSGIX\0"
   "glStartTilingQCOM\0"
   "glStateCaptureNV\0"
   "glStencilClearTagEXT\0"
   "glStencilFillPathInstancedNV\0"
   "glStencilFillPathNV\0"
   "glStencilFunc\0"
   "glStencilFuncSeparate\0"
   "glStencilFuncSeparateATI\0"
   "glStencilMask\0"
   "glStencilMaskSeparate\0"
   "glStencilOp\0"
   "glStencilOpSeparate\0"
   "glStencilOpSeparateATI\0"
   "glStencilOpValueAMD\0"
   "glStencilStrokePathInstancedNV\0"
   "glStencilStrokePathNV\0"
   "glStencilThenCoverFillPathInstancedNV\0"
   "glStencilThenCoverFillPathNV\0"
   "glStencilThenCoverStrokePathInstancedNV\0"
   "glStencilThenCoverStrokePathNV\0"
   "glStopInstrumentsSGIX\0"
   "glStringMarkerGREMEDY\0"
   "glSubpixelPrecisionBiasNV\0"
   "glSwizzleEXT\0"
   "glSyncTextureINTEL\0"
   "glTagSampleBufferSGIX\0"
   "glTangent3bEXT\0"
   "glTangent3bvEXT\0"
   "glTangent3dEXT\0"
   "glTangent3dvEXT\0"
   "glTangent3fEXT\0"
   "glTangent3fvEXT\0"
   "glTangent3iEXT\0"
   "glTangent3ivEXT\0"
   "glTangent3sEXT\0"
   "glTangent3svEXT\0"
   "glTangentPointerEXT\0"
   "glTbufferMask3DFX\0"
   "glTessellationFactorAMD\0"
   "glTessellationModeAMD\0"
   "glTestFenceAPPLE\0"
   "glTestFenceNV\0"
   "glTestObjectAPPLE\0"
   "glTexBuffer\0"
   "glTexBufferARB\0"
   "glTexBufferEXT\0"
   "glTexBufferOES\0"
   "glTexBufferRange\0"
   "glTexBufferRangeEXT\0"
   "glTexBufferRangeOES\0"
   "glTexBumpParameterfvATI\0"
   "glTexBumpParameterivATI\0"
   "glTexCoord1bOES\0"
   "glTexCoord1bvOES\0"
   "glTexCoord1d\0"
   "glTexCoord1dv\0"
   "glTexCoord1f\0"
   "glTexCoord1fv\0"
   "glTexCoord1hNV\0"
   "glTexCoord1hvNV\0"
   "glTexCoord1i\0"
   "glTexCoord1iv\0"
   "glTexCoord1s\0"
   "glTexCoord1sv\0"
   "glTexCoord1xOES\0"
   "glTexCoord1xvOES\0"
   "glTexCoord2bOES\0"
   "glTexCoord2bvOES\0"
   "glTexCoord2d\0"
   "glTexCoord2dv\0"
   "glTexCoord2f\0"
   "glTexCoord2fColor3fVertex3fSUN\0"
   "glTexCoord2fColor3fVertex3fvSUN\0"
   "glTexCoord2fColor4fNormal3fVertex3fSUN\0"
   "glTexCoord2fColor4fNormal3fVertex3fvSUN\0"
   "glTexCoord2fColor4ubVertex3fSUN\0"
   "glTexCoord2fColor4ubVertex3fvSUN\0"
   "glTexCoord2fNormal3fVertex3fSUN\0"
   "glTexCoord2fNormal3fVertex3fvSUN\0"
   "glTexCoord2fVertex3fSUN\0"
   "glTexCoord2fVertex3fvSUN\0"
   "glTexCoord2fv\0"
   "glTexCoord2hNV\0"
   "glTexCoord2hvNV\0"
   "glTexCoord2i\0"
   "glTexCoord2iv\0"
   "glTexCoord2s\0"
   "glTexCoord2sv\0"
   "glTexCoord2xOES\0"
   "glTexCoord2xvOES\0"
   "glTexCoord3bOES\0"
   "glTexCoord3bvOES\0"
   "glTexCoord3d\0"
   "glTexCoord3dv\0"
   "glTexCoord3f\0"
   "glTexCoord3fv\0"
   "glTexCoord3hNV\0"
   "glTexCoord3hvNV\0"
   "glTexCoord3i\0"
   "glTexCoord3iv\0"
   "glTexCoord3s\0"
   "glTexCoord3sv\0"
   "glTexCoord3xOES\0"
   "glTexCoord3xvOES\0"
   "glTexCoord4bOES\0"
   "glTexCoord4bvOES\0"
   "glTexCoord4d\0"
   "glTexCoord4dv\0"
   "glTexCoord4f\0"
   "glTexCoord4fColor4fNormal3fVertex4fSUN\0"
   "glTexCoord4fColor4fNormal3fVertex4fvSUN\0"
   "glTexCoord4fVertex4fSUN\0"
   "glTexCoord4fVertex4fvSUN\0"
   "glTexCoord4fv\0"
   "glTexCoord4hNV\0"
   "glTexCoord4hvNV\0"
   "glTexCoord4i\0"
   "glTexCoord4iv\0"
   "glTexCoord4s\0"
   "glTexCoord4sv\0"
   "glTexCoord4xOES\0"
   "glTexCoord4xvOES\0"
   "glTexCoordFormatNV\0"
   "glTexCoordP1ui\0"
   "glTexCoordP1uiv\0"
   "glTexCoordP2ui\0"
   "glTexCoordP2uiv\0"
   "glTexCoordP3ui\0"
   "glTexCoordP3uiv\0"
   "glTexCoordP4ui\0"
   "glTexCoordP4uiv\0"
   "glTexCoordPointer\0"
   "glTexCoordPointerEXT\0"
   "glTexCoordPointerListIBM\0"
   "glTexCoordPointervINTEL\0"
   "glTexEnvf\0"
   "glTexEnvfv\0"
   "glTexEnvi\0"
   "glTexEnviv\0"
   "glTexEnvx\0"
   "glTexEnvxOES\0"
   "glTexEnvxv\0"
   "glTexEnvxvOES\0"
   "glTexFilterFuncSGIS\0"
   "glTexGend\0"
   "glTexGendv\0"
   "glTexGenf\0"
   "glTexGenfOES\0"
   "glTexGenfv\0"
   "glTexGenfvOES\0"
   "glTexGeni\0"
   "glTexGeniOES\0"
   "glTexGeniv\0"
   "glTexGenivOES\0"
   "glTexGenxOES\0"
   "glTexGenxvOES\0"
   "glTexImage1D\0"
   "glTexImage2D\0"
   "glTexImage2DMultisample\0"
   "glTexImage2DMultisampleCoverageNV\0"
   "glTexImage3D\0"
   "glTexImage3DEXT\0"
   "glTexImage3DMultisample\0"
   "glTexImage3DMultisampleCoverageNV\0"
   "glTexImage3DOES\0"
   "glTexImage4DSGIS\0"
   "glTexPageCommitmentARB\0"
   "glTexPageCommitmentEXT\0"
   "glTexParameterIiv\0"
   "glTexParameterIivEXT\0"
   "glTexParameterIivOES\0"
   "glTexParameterIuiv\0"
   "glTexParameterIuivEXT\0"
   "glTexParameterIuivOES\0"
   "glTexParameterf\0"
   "glTexParameterfv\0"
   "glTexParameteri\0"
   "glTexParameteriv\0"
   "glTexParameterx\0"
   "glTexParameterxOES\0"
   "glTexParameterxv\0"
   "glTexParameterxvOES\0"
   "glTexRenderbufferNV\0"
   "glTexStorage1D\0"
   "glTexStorage1DEXT\0"
   "glTexStorage2D\0"
   "glTexStorage2DEXT\0"
   "glTexStorage2DMultisample\0"
   "glTexStorage3D\0"
   "glTexStorage3DEXT\0"
   "glTexStorage3DMultisample\0"
   "glTexStorage3DMultisampleOES\0"
   "glTexStorageSparseAMD\0"
   "glTexSubImage1D\0"
   "glTexSubImage1DEXT\0"
   "glTexSubImage2D\0"
   "glTexSubImage2DEXT\0"
   "glTexSubImage3D\0"
   "glTexSubImage3DEXT\0"
   "glTexSubImage3DOES\0"
   "glTexSubImage4DSGIS\0"
   "glTextureBarrier\0"
   "glTextureBarrierNV\0"
   "glTextureBuffer\0"
   "glTextureBufferEXT\0"
   "glTextureBufferRange\0"
   "glTextureBufferRangeEXT\0"
   "glTextureColorMaskSGIS\0"
   "glTextureImage1DEXT\0"
   "glTextureImage2DEXT\0"
   "glTextureImage2DMultisampleCoverageNV\0"
   "glTextureImage2DMultisampleNV\0"
   "glTextureImage3DEXT\0"
   "glTextureImage3DMultisampleCoverageNV\0"
   "glTextureImage3DMultisampleNV\0"
   "glTextureLightEXT\0"
   "glTextureMaterialEXT\0"
   "glTextureNormalEXT\0"
   "glTexturePageCommitmentEXT\0"
   "glTextureParameterIiv\0"
   "glTextureParameterIivEXT\0"
   "glTextureParameterIuiv\0"
   "glTextureParameterIuivEXT\0"
   "glTextureParameterf\0"
   "glTextureParameterfEXT\0"
   "glTextureParameterfv\0"
   "glTextureParameterfvEXT\0"
   "glTextureParameteri\0"
   "glTextureParameteriEXT\0"
   "glTextureParameteriv\0"
   "glTextureParameterivEXT\0"
   "glTextureRangeAPPLE\0"
   "glTextureRenderbufferEXT\0"
   "glTextureStorage1D\0"
   "glTextureStorage1DEXT\0"
   "glTextureStorage2D\0"
   "glTextureStorage2DEXT\0"
   "glTextureStorage2DMultisample\0"
   "glTextureStorage2DMultisampleEXT\0"
   "glTextureStorage3D\0"
   "glTextureStorage3DEXT\0"
   "glTextureStorage3DMultisample\0"
   "glTextureStorage3DMultisampleEXT\0"
   "glTextureStorageSparseAMD\0"
   "glTextureSubImage1D\0"
   "glTextureSubImage1DEXT\0"
   "glTextureSubImage2D\0"
   "glTextureSubImage2DEXT\0"
   "glTextureSubImage3D\0"
   "glTextureSubImage3DEXT\0"
   "glTextureView\0"
   "glTextureViewEXT\0"
   "glTextureViewOES\0"
   "glTrackMatrixNV\0"
   "glTransformFeedbackAttribsNV\0"
   "glTransformFeedbackBufferBase\0"
   "glTransformFeedbackBufferRange\0"
   "glTransformFeedbackStreamAttribsNV\0"
   "glTransformFeedbackVaryings\0"
   "glTransformFeedbackVaryingsEXT\0"
   "glTransformFeedbackVaryingsNV\0"
   "glTransformPathNV\0"
   "glTranslated\0"
   "glTranslatef\0"
   "glTranslatex\0"
   "glTranslatexOES\0"
   "glUniform1d\0"
   "glUniform1dv\0"
   "glUniform1f\0"
   "glUniform1fARB\0"
   "glUniform1fv\0"
   "glUniform1fvARB\0"
   "glUniform1i\0"
   "glUniform1i64NV\0"
   "glUniform1i64vNV\0"
   "glUniform1iARB\0"
   "glUniform1iv\0"
   "glUniform1ivARB\0"
   "glUniform1ui\0"
   "glUniform1ui64NV\0"
   "glUniform1ui64vNV\0"
   "glUniform1uiEXT\0"
   "glUniform1uiv\0"
   "glUniform1uivEXT\0"
   "glUniform2d\0"
   "glUniform2dv\0"
   "glUniform2f\0"
   "glUniform2fARB\0"
   "glUniform2fv\0"
   "glUniform2fvARB\0"
   "glUniform2i\0"
   "glUniform2i64NV\0"
   "glUniform2i64vNV\0"
   "glUniform2iARB\0"
   "glUniform2iv\0"
   "glUniform2ivARB\0"
   "glUniform2ui\0"
   "glUniform2ui64NV\0"
   "glUniform2ui64vNV\0"
   "glUniform2uiEXT\0"
   "glUniform2uiv\0"
   "glUniform2uivEXT\0"
   "glUniform3d\0"
   "glUniform3dv\0"
   "glUniform3f\0"
   "glUniform3fARB\0"
   "glUniform3fv\0"
   "glUniform3fvARB\0"
   "glUniform3i\0"
   "glUniform3i64NV\0"
   "glUniform3i64vNV\0"
   "glUniform3iARB\0"
   "glUniform3iv\0"
   "glUniform3ivARB\0"
   "glUniform3ui\0"
   "glUniform3ui64NV\0"
   "glUniform3ui64vNV\0"
   "glUniform3uiEXT\0"
   "glUniform3uiv\0"
   "glUniform3uivEXT\0"
   "glUniform4d\0"
   "glUniform4dv\0"
   "glUniform4f\0"
   "glUniform4fARB\0"
   "glUniform4fv\0"
   "glUniform4fvARB\0"
   "glUniform4i\0"
   "glUniform4i64NV\0"
   "glUniform4i64vNV\0"
   "glUniform4iARB\0"
   "glUniform4iv\0"
   "glUniform4ivARB\0"
   "glUniform4ui\0"
   "glUniform4ui64NV\0"
   "glUniform4ui64vNV\0"
   "glUniform4uiEXT\0"
   "glUniform4uiv\0"
   "glUniform4uivEXT\0"
   "glUniformBlockBinding\0"
   "glUniformBufferEXT\0"
   "glUniformHandleui64ARB\0"
   "glUniformHandleui64NV\0"
   "glUniformHandleui64vARB\0"
   "glUniformHandleui64vNV\0"
   "glUniformMatrix2dv\0"
   "glUniformMatrix2fv\0"
   "glUniformMatrix2fvARB\0"
   "glUniformMatrix2x3dv\0"
   "glUniformMatrix2x3fv\0"
   "glUniformMatrix2x3fvNV\0"
   "glUniformMatrix2x4dv\0"
   "glUniformMatrix2x4fv\0"
   "glUniformMatrix2x4fvNV\0"
   "glUniformMatrix3dv\0"
   "glUniformMatrix3fv\0"
   "glUniformMatrix3fvARB\0"
   "glUniformMatrix3x2dv\0"
   "glUniformMatrix3x2fv\0"
   "glUniformMatrix3x2fvNV\0"
   "glUniformMatrix3x4dv\0"
   "glUniformMatrix3x4fv\0"
   "glUniformMatrix3x4fvNV\0"
   "glUniformMatrix4dv\0"
   "glUniformMatrix4fv\0"
   "glUniformMatrix4fvARB\0"
   "glUniformMatrix4x2dv\0"
   "glUniformMatrix4x2fv\0"
   "glUniformMatrix4x2fvNV\0"
   "glUniformMatrix4x3dv\0"
   "glUniformMatrix4x3fv\0"
   "glUniformMatrix4x3fvNV\0"
   "glUniformSubroutinesuiv\0"
   "glUniformui64NV\0"
   "glUniformui64vNV\0"
   "glUnlockArraysEXT\0"
   "glUnmapBuffer\0"
   "glUnmapBufferARB\0"
   "glUnmapBufferOES\0"
   "glUnmapNamedBuffer\0"
   "glUnmapNamedBufferEXT\0"
   "glUnmapObjectBufferATI\0"
   "glUnmapTexture2DINTEL\0"
   "glUpdateObjectBufferATI\0"
   "glUseProgram\0"
   "glUseProgramObjectARB\0"
   "glUseProgramStages\0"
   "glUseProgramStagesEXT\0"
   "glUseShaderProgramEXT\0"
   "glVDPAUFiniNV\0"
   "glVDPAUGetSurfaceivNV\0"
   "glVDPAUInitNV\0"
   "glVDPAUIsSurfaceNV\0"
   "glVDPAUMapSurfacesNV\0"
   "glVDPAURegisterOutputSurfaceNV\0"
   "glVDPAURegisterVideoSurfaceNV\0"
   "glVDPAUSurfaceAccessNV\0"
   "glVDPAUUnmapSurfacesNV\0"
   "glVDPAUUnregisterSurfaceNV\0"
   "glValidateProgram\0"
   "glValidateProgramARB\0"
   "glValidateProgramPipeline\0"
   "glValidateProgramPipelineEXT\0"
   "glVariantArrayObjectATI\0"
   "glVariantPointerEXT\0"
   "glVariantbvEXT\0"
   "glVariantdvEXT\0"
   "glVariantfvEXT\0"
   "glVariantivEXT\0"
   "glVariantsvEXT\0"
   "glVariantubvEXT\0"
   "glVariantuivEXT\0"
   "glVariantusvEXT\0"
   "glVertex2bOES\0"
   "glVertex2bvOES\0"
   "glVertex2d\0"
   "glVertex2dv\0"
   "glVertex2f\0"
   "glVertex2fv\0"
   "glVertex2hNV\0"
   "glVertex2hvNV\0"
   "glVertex2i\0"
   "glVertex2iv\0"
   "glVertex2s\0"
   "glVertex2sv\0"
   "glVertex2xOES\0"
   "glVertex2xvOES\0"
   "glVertex3bOES\0"
   "glVertex3bvOES\0"
   "glVertex3d\0"
   "glVertex3dv\0"
   "glVertex3f\0"
   "glVertex3fv\0"
   "glVertex3hNV\0"
   "glVertex3hvNV\0"
   "glVertex3i\0"
   "glVertex3iv\0"
   "glVertex3s\0"
   "glVertex3sv\0"
   "glVertex3xOES\0"
   "glVertex3xvOES\0"
   "glVertex4bOES\0"
   "glVertex4bvOES\0"
   "glVertex4d\0"
   "glVertex4dv\0"
   "glVertex4f\0"
   "glVertex4fv\0"
   "glVertex4hNV\0"
   "glVertex4hvNV\0"
   "glVertex4i\0"
   "glVertex4iv\0"
   "glVertex4s\0"
   "glVertex4sv\0"
   "glVertex4xOES\0"
   "glVertex4xvOES\0"
   "glVertexArrayAttribBinding\0"
   "glVertexArrayAttribFormat\0"
   "glVertexArrayAttribIFormat\0"
   "glVertexArrayAttribLFormat\0"
   "glVertexArrayBindVertexBufferEXT\0"
   "glVertexArrayBindingDivisor\0"
   "glVertexArrayColorOffsetEXT\0"
   "glVertexArrayEdgeFlagOffsetEXT\0"
   "glVertexArrayElementBuffer\0"
   "glVertexArrayFogCoordOffsetEXT\0"
   "glVertexArrayIndexOffsetEXT\0"
   "glVertexArrayMultiTexCoordOffsetEXT\0"
   "glVertexArrayNormalOffsetEXT\0"
   "glVertexArrayParameteriAPPLE\0"
   "glVertexArrayRangeAPPLE\0"
   "glVertexArrayRangeNV\0"
   "glVertexArraySecondaryColorOffsetEXT\0"
   "glVertexArrayTexCoordOffsetEXT\0"
   "glVertexArrayVertexAttribBindingEXT\0"
   "glVertexArrayVertexAttribDivisorEXT\0"
   "glVertexArrayVertexAttribFormatEXT\0"
   "glVertexArrayVertexAttribIFormatEXT\0"
   "glVertexArrayVertexAttribIOffsetEXT\0"
   "glVertexArrayVertexAttribLFormatEXT\0"
   "glVertexArrayVertexAttribLOffsetEXT\0"
   "glVertexArrayVertexAttribOffsetEXT\0"
   "glVertexArrayVertexBindingDivisorEXT\0"
   "glVertexArrayVertexBuffer\0"
   "glVertexArrayVertexBuffers\0"
   "glVertexArrayVertexOffsetEXT\0"
   "glVertexAttrib1d\0"
   "glVertexAttrib1dARB\0"
   "glVertexAttrib1dNV\0"
   "glVertexAttrib1dv\0"
   "glVertexAttrib1dvARB\0"
   "glVertexAttrib1dvNV\0"
   "glVertexAttrib1f\0"
   "glVertexAttrib1fARB\0"
   "glVertexAttrib1fNV\0"
   "glVertexAttrib1fv\0"
   "glVertexAttrib1fvARB\0"
   "glVertexAttrib1fvNV\0"
   "glVertexAttrib1hNV\0"
   "glVertexAttrib1hvNV\0"
   "glVertexAttrib1s\0"
   "glVertexAttrib1sARB\0"
   "glVertexAttrib1sNV\0"
   "glVertexAttrib1sv\0"
   "glVertexAttrib1svARB\0"
   "glVertexAttrib1svNV\0"
   "glVertexAttrib2d\0"
   "glVertexAttrib2dARB\0"
   "glVertexAttrib2dNV\0"
   "glVertexAttrib2dv\0"
   "glVertexAttrib2dvARB\0"
   "glVertexAttrib2dvNV\0"
   "glVertexAttrib2f\0"
   "glVertexAttrib2fARB\0"
   "glVertexAttrib2fNV\0"
   "glVertexAttrib2fv\0"
   "glVertexAttrib2fvARB\0"
   "glVertexAttrib2fvNV\0"
   "glVertexAttrib2hNV\0"
   "glVertexAttrib2hvNV\0"
   "glVertexAttrib2s\0"
   "glVertexAttrib2sARB\0"
   "glVertexAttrib2sNV\0"
   "glVertexAttrib2sv\0"
   "glVertexAttrib2svARB\0"
   "glVertexAttrib2svNV\0"
   "glVertexAttrib3d\0"
   "glVertexAttrib3dARB\0"
   "glVertexAttrib3dNV\0"
   "glVertexAttrib3dv\0"
   "glVertexAttrib3dvARB\0"
   "glVertexAttrib3dvNV\0"
   "glVertexAttrib3f\0"
   "glVertexAttrib3fARB\0"
   "glVertexAttrib3fNV\0"
   "glVertexAttrib3fv\0"
   "glVertexAttrib3fvARB\0"
   "glVertexAttrib3fvNV\0"
   "glVertexAttrib3hNV\0"
   "glVertexAttrib3hvNV\0"
   "glVertexAttrib3s\0"
   "glVertexAttrib3sARB\0"
   "glVertexAttrib3sNV\0"
   "glVertexAttrib3sv\0"
   "glVertexAttrib3svARB\0"
   "glVertexAttrib3svNV\0"
   "glVertexAttrib4Nbv\0"
   "glVertexAttrib4NbvARB\0"
   "glVertexAttrib4Niv\0"
   "glVertexAttrib4NivARB\0"
   "glVertexAttrib4Nsv\0"
   "glVertexAttrib4NsvARB\0"
   "glVertexAttrib4Nub\0"
   "glVertexAttrib4NubARB\0"
   "glVertexAttrib4Nubv\0"
   "glVertexAttrib4NubvARB\0"
   "glVertexAttrib4Nuiv\0"
   "glVertexAttrib4NuivARB\0"
   "glVertexAttrib4Nusv\0"
   "glVertexAttrib4NusvARB\0"
   "glVertexAttrib4bv\0"
   "glVertexAttrib4bvARB\0"
   "glVertexAttrib4d\0"
   "glVertexAttrib4dARB\0"
   "glVertexAttrib4dNV\0"
   "glVertexAttrib4dv\0"
   "glVertexAttrib4dvARB\0"
   "glVertexAttrib4dvNV\0"
   "glVertexAttrib4f\0"
   "glVertexAttrib4fARB\0"
   "glVertexAttrib4fNV\0"
   "glVertexAttrib4fv\0"
   "glVertexAttrib4fvARB\0"
   "glVertexAttrib4fvNV\0"
   "glVertexAttrib4hNV\0"
   "glVertexAttrib4hvNV\0"
   "glVertexAttrib4iv\0"
   "glVertexAttrib4ivARB\0"
   "glVertexAttrib4s\0"
   "glVertexAttrib4sARB\0"
   "glVertexAttrib4sNV\0"
   "glVertexAttrib4sv\0"
   "glVertexAttrib4svARB\0"
   "glVertexAttrib4svNV\0"
   "glVertexAttrib4ubNV\0"
   "glVertexAttrib4ubv\0"
   "glVertexAttrib4ubvARB\0"
   "glVertexAttrib4ubvNV\0"
   "glVertexAttrib4uiv\0"
   "glVertexAttrib4uivARB\0"
   "glVertexAttrib4usv\0"
   "glVertexAttrib4usvARB\0"
   "glVertexAttribArrayObjectATI\0"
   "glVertexAttribBinding\0"
   "glVertexAttribDivisor\0"
   "glVertexAttribDivisorANGLE\0"
   "glVertexAttribDivisorARB\0"
   "glVertexAttribDivisorEXT\0"
   "glVertexAttribDivisorNV\0"
   "glVertexAttribFormat\0"
   "glVertexAttribFormatNV\0"
   "glVertexAttribI1i\0"
   "glVertexAttribI1iEXT\0"
   "glVertexAttribI1iv\0"
   "glVertexAttribI1ivEXT\0"
   "glVertexAttribI1ui\0"
   "glVertexAttribI1uiEXT\0"
   "glVertexAttribI1uiv\0"
   "glVertexAttribI1uivEXT\0"
   "glVertexAttribI2i\0"
   "glVertexAttribI2iEXT\0"
   "glVertexAttribI2iv\0"
   "glVertexAttribI2ivEXT\0"
   "glVertexAttribI2ui\0"
   "glVertexAttribI2uiEXT\0"
   "glVertexAttribI2uiv\0"
   "glVertexAttribI2uivEXT\0"
   "glVertexAttribI3i\0"
   "glVertexAttribI3iEXT\0"
   "glVertexAttribI3iv\0"
   "glVertexAttribI3ivEXT\0"
   "glVertexAttribI3ui\0"
   "glVertexAttribI3uiEXT\0"
   "glVertexAttribI3uiv\0"
   "glVertexAttribI3uivEXT\0"
   "glVertexAttribI4bv\0"
   "glVertexAttribI4bvEXT\0"
   "glVertexAttribI4i\0"
   "glVertexAttribI4iEXT\0"
   "glVertexAttribI4iv\0"
   "glVertexAttribI4ivEXT\0"
   "glVertexAttribI4sv\0"
   "glVertexAttribI4svEXT\0"
   "glVertexAttribI4ubv\0"
   "glVertexAttribI4ubvEXT\0"
   "glVertexAttribI4ui\0"
   "glVertexAttribI4uiEXT\0"
   "glVertexAttribI4uiv\0"
   "glVertexAttribI4uivEXT\0"
   "glVertexAttribI4usv\0"
   "glVertexAttribI4usvEXT\0"
   "glVertexAttribIFormat\0"
   "glVertexAttribIFormatNV\0"
   "glVertexAttribIPointer\0"
   "glVertexAttribIPointerEXT\0"
   "glVertexAttribL1d\0"
   "glVertexAttribL1dEXT\0"
   "glVertexAttribL1dv\0"
   "glVertexAttribL1dvEXT\0"
   "glVertexAttribL1i64NV\0"
   "glVertexAttribL1i64vNV\0"
   "glVertexAttribL1ui64ARB\0"
   "glVertexAttribL1ui64NV\0"
   "glVertexAttribL1ui64vARB\0"
   "glVertexAttribL1ui64vNV\0"
   "glVertexAttribL2d\0"
   "glVertexAttribL2dEXT\0"
   "glVertexAttribL2dv\0"
   "glVertexAttribL2dvEXT\0"
   "glVertexAttribL2i64NV\0"
   "glVertexAttribL2i64vNV\0"
   "glVertexAttribL2ui64NV\0"
   "glVertexAttribL2ui64vNV\0"
   "glVertexAttribL3d\0"
   "glVertexAttribL3dEXT\0"
   "glVertexAttribL3dv\0"
   "glVertexAttribL3dvEXT\0"
   "glVertexAttribL3i64NV\0"
   "glVertexAttribL3i64vNV\0"
   "glVertexAttribL3ui64NV\0"
   "glVertexAttribL3ui64vNV\0"
   "glVertexAttribL4d\0"
   "glVertexAttribL4dEXT\0"
   "glVertexAttribL4dv\0"
   "glVertexAttribL4dvEXT\0"
   "glVertexAttribL4i64NV\0"
   "glVertexAttribL4i64vNV\0"
   "glVertexAttribL4ui64NV\0"
   "glVertexAttribL4ui64vNV\0"
   "glVertexAttribLFormat\0"
   "glVertexAttribLFormatNV\0"
   "glVertexAttribLPointer\0"
   "glVertexAttribLPointerEXT\0"
   "glVertexAttribP1ui\0"
   "glVertexAttribP1uiv\0"
   "glVertexAttribP2ui\0"
   "glVertexAttribP2uiv\0"
   "glVertexAttribP3ui\0"
   "glVertexAttribP3uiv\0"
   "glVertexAttribP4ui\0"
   "glVertexAttribP4uiv\0"
   "glVertexAttribParameteriAMD\0"
   "glVertexAttribPointer\0"
   "glVertexAttribPointerARB\0"
   "glVertexAttribPointerNV\0"
   "glVertexAttribs1dvNV\0"
   "glVertexAttribs1fvNV\0"
   "glVertexAttribs1hvNV\0"
   "glVertexAttribs1svNV\0"
   "glVertexAttribs2dvNV\0"
   "glVertexAttribs2fvNV\0"
   "glVertexAttribs2hvNV\0"
   "glVertexAttribs2svNV\0"
   "glVertexAttribs3dvNV\0"
   "glVertexAttribs3fvNV\0"
   "glVertexAttribs3hvNV\0"
   "glVertexAttribs3svNV\0"
   "glVertexAttribs4dvNV\0"
   "glVertexAttribs4fvNV\0"
   "glVertexAttribs4hvNV\0"
   "glVertexAttribs4svNV\0"
   "glVertexAttribs4ubvNV\0"
   "glVertexBindingDivisor\0"
   "glVertexBlendARB\0"
   "glVertexBlendEnvfATI\0"
   "glVertexBlendEnviATI\0"
   "glVertexFormatNV\0"
   "glVertexP2ui\0"
   "glVertexP2uiv\0"
   "glVertexP3ui\0"
   "glVertexP3uiv\0"
   "glVertexP4ui\0"
   "glVertexP4uiv\0"
   "glVertexPointer\0"
   "glVertexPointerEXT\0"
   "glVertexPointerListIBM\0"
   "glVertexPointervINTEL\0"
   "glVertexStream1dATI\0"
   "glVertexStream1dvATI\0"
   "glVertexStream1fATI\0"
   "glVertexStream1fvATI\0"
   "glVertexStream1iATI\0"
   "glVertexStream1ivATI\0"
   "glVertexStream1sATI\0"
   "glVertexStream1svATI\0"
   "glVertexStream2dATI\0"
   "glVertexStream2dvATI\0"
   "glVertexStream2fATI\0"
   "glVertexStream2fvATI\0"
   "glVertexStream2iATI\0"
   "glVertexStream2ivATI\0"
   "glVertexStream2sATI\0"
   "glVertexStream2svATI\0"
   "glVertexStream3dATI\0"
   "glVertexStream3dvATI\0"
   "glVertexStream3fATI\0"
   "glVertexStream3fvATI\0"
   "glVertexStream3iATI\0"
   "glVertexStream3ivATI\0"
   "glVertexStream3sATI\0"
   "glVertexStream3svATI\0"
   "glVertexStream4dATI\0"
   "glVertexStream4dvATI\0"
   "glVertexStream4fATI\0"
   "glVertexStream4fvATI\0"
   "glVertexStream4iATI\0"
   "glVertexStream4ivATI\0"
   "glVertexStream4sATI\0"
   "glVertexStream4svATI\0"
   "glVertexWeightPointerEXT\0"
   "glVertexWeightfEXT\0"
   "glVertexWeightfvEXT\0"
   "glVertexWeighthNV\0"
   "glVertexWeighthvNV\0"
   "glVideoCaptureNV\0"
   "glVideoCaptureStreamParameterdvNV\0"
   "glVideoCaptureStreamParameterfvNV\0"
   "glVideoCaptureStreamParameterivNV\0"
   "glViewport\0"
   "glViewportArrayv\0"
   "glViewportArrayvNV\0"
   "glViewportIndexedf\0"
   "glViewportIndexedfNV\0"
   "glViewportIndexedfv\0"
   "glViewportIndexedfvNV\0"
   "glWaitSync\0"
   "glWaitSyncAPPLE\0"
   "glWeightPathsNV\0"
   "glWeightPointerARB\0"
   "glWeightPointerOES\0"
   "glWeightbvARB\0"
   "glWeightdvARB\0"
   "glWeightfvARB\0"
   "glWeightivARB\0"
   "glWeightsvARB\0"
   "glWeightubvARB\0"
   "glWeightuivARB\0"
   "glWeightusvARB\0"
   "glWindowPos2d\0"
   "glWindowPos2dARB\0"
   "glWindowPos2dMESA\0"
   "glWindowPos2dv\0"
   "glWindowPos2dvARB\0"
   "glWindowPos2dvMESA\0"
   "glWindowPos2f\0"
   "glWindowPos2fARB\0"
   "glWindowPos2fMESA\0"
   "glWindowPos2fv\0"
   "glWindowPos2fvARB\0"
   "glWindowPos2fvMESA\0"
   "glWindowPos2i\0"
   "glWindowPos2iARB\0"
   "glWindowPos2iMESA\0"
   "glWindowPos2iv\0"
   "glWindowPos2ivARB\0"
   "glWindowPos2ivMESA\0"
   "glWindowPos2s\0"
   "glWindowPos2sARB\0"
   "glWindowPos2sMESA\0"
   "glWindowPos2sv\0"
   "glWindowPos2svARB\0"
   "glWindowPos2svMESA\0"
   "glWindowPos3d\0"
   "glWindowPos3dARB\0"
   "glWindowPos3dMESA\0"
   "glWindowPos3dv\0"
   "glWindowPos3dvARB\0"
   "glWindowPos3dvMESA\0"
   "glWindowPos3f\0"
   "glWindowPos3fARB\0"
   "glWindowPos3fMESA\0"
   "glWindowPos3fv\0"
   "glWindowPos3fvARB\0"
   "glWindowPos3fvMESA\0"
   "glWindowPos3i\0"
   "glWindowPos3iARB\0"
   "glWindowPos3iMESA\0"
   "glWindowPos3iv\0"
   "glWindowPos3ivARB\0"
   "glWindowPos3ivMESA\0"
   "glWindowPos3s\0"
   "glWindowPos3sARB\0"
   "glWindowPos3sMESA\0"
   "glWindowPos3sv\0"
   "glWindowPos3svARB\0"
   "glWindowPos3svMESA\0"
   "glWindowPos4dMESA\0"
   "glWindowPos4dvMESA\0"
   "glWindowPos4fMESA\0"
   "glWindowPos4fvMESA\0"
   "glWindowPos4iMESA\0"
   "glWindowPos4ivMESA\0"
   "glWindowPos4sMESA\0"
   "glWindowPos4svMESA\0"
   "glWriteMaskEXT\0"
    ;

static void *gl_provider_resolver(const char *name,
                                   const enum gl_provider *providers,
                                   const uint16_t *entrypoints)
{
    int i;
    for (i = 0; providers[i] != gl_provider_terminator; i++) {
        switch (providers[i]) {
        case Desktop_OpenGL_1_0:
            if (epoxy_is_desktop_gl())
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 10);
            break;
        case Desktop_OpenGL_1_1:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 11)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 11);
            break;
        case Desktop_OpenGL_1_2:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 12)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 12);
            break;
        case Desktop_OpenGL_1_3:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 13)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 13);
            break;
        case Desktop_OpenGL_1_4:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 14)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 14);
            break;
        case Desktop_OpenGL_1_5:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 15)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 15);
            break;
        case Desktop_OpenGL_2_0:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 20)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 20);
            break;
        case Desktop_OpenGL_2_1:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 21)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 21);
            break;
        case Desktop_OpenGL_3_0:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 30)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 30);
            break;
        case Desktop_OpenGL_3_1:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 31)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 31);
            break;
        case Desktop_OpenGL_3_2:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 32)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 32);
            break;
        case Desktop_OpenGL_3_3:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 33)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 33);
            break;
        case Desktop_OpenGL_4_0:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 40)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 40);
            break;
        case Desktop_OpenGL_4_1:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 41)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 41);
            break;
        case Desktop_OpenGL_4_2:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 42)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 42);
            break;
        case Desktop_OpenGL_4_3:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 43)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 43);
            break;
        case Desktop_OpenGL_4_4:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 44)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 44);
            break;
        case Desktop_OpenGL_4_5:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 45)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 45);
            break;
        case GL_extension_GL_3DFX_tbuffer:
            if (epoxy_conservative_has_gl_extension("GL_3DFX_tbuffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_debug_output:
            if (epoxy_conservative_has_gl_extension("GL_AMD_debug_output"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_draw_buffers_blend:
            if (epoxy_conservative_has_gl_extension("GL_AMD_draw_buffers_blend"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_gpu_shader_int64:
            if (epoxy_conservative_has_gl_extension("GL_AMD_gpu_shader_int64"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_interleaved_elements:
            if (epoxy_conservative_has_gl_extension("GL_AMD_interleaved_elements"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_multi_draw_indirect:
            if (epoxy_conservative_has_gl_extension("GL_AMD_multi_draw_indirect"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_name_gen_delete:
            if (epoxy_conservative_has_gl_extension("GL_AMD_name_gen_delete"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_occlusion_query_event:
            if (epoxy_conservative_has_gl_extension("GL_AMD_occlusion_query_event"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_performance_monitor:
            if (epoxy_conservative_has_gl_extension("GL_AMD_performance_monitor"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_sample_positions:
            if (epoxy_conservative_has_gl_extension("GL_AMD_sample_positions"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_sparse_texture:
            if (epoxy_conservative_has_gl_extension("GL_AMD_sparse_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_stencil_operation_extended:
            if (epoxy_conservative_has_gl_extension("GL_AMD_stencil_operation_extended"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_vertex_shader_tessellator:
            if (epoxy_conservative_has_gl_extension("GL_AMD_vertex_shader_tessellator"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ANGLE_framebuffer_blit:
            if (epoxy_conservative_has_gl_extension("GL_ANGLE_framebuffer_blit"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ANGLE_framebuffer_multisample:
            if (epoxy_conservative_has_gl_extension("GL_ANGLE_framebuffer_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ANGLE_instanced_arrays:
            if (epoxy_conservative_has_gl_extension("GL_ANGLE_instanced_arrays"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ANGLE_translated_shader_source:
            if (epoxy_conservative_has_gl_extension("GL_ANGLE_translated_shader_source"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_copy_texture_levels:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_copy_texture_levels"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_element_array:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_element_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_fence:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_fence"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_flush_buffer_range:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_flush_buffer_range"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_framebuffer_multisample:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_framebuffer_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_object_purgeable:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_object_purgeable"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_sync:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_sync"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_texture_range:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_texture_range"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_vertex_array_object:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_vertex_array_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_vertex_array_range:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_vertex_array_range"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_vertex_program_evaluators:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_vertex_program_evaluators"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_ES2_compatibility:
            if (epoxy_conservative_has_gl_extension("GL_ARB_ES2_compatibility"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_ES3_1_compatibility:
            if (epoxy_conservative_has_gl_extension("GL_ARB_ES3_1_compatibility"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_base_instance:
            if (epoxy_conservative_has_gl_extension("GL_ARB_base_instance"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_bindless_texture:
            if (epoxy_conservative_has_gl_extension("GL_ARB_bindless_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_blend_func_extended:
            if (epoxy_conservative_has_gl_extension("GL_ARB_blend_func_extended"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_buffer_storage:
            if (epoxy_conservative_has_gl_extension("GL_ARB_buffer_storage"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_cl_event:
            if (epoxy_conservative_has_gl_extension("GL_ARB_cl_event"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_clear_buffer_object:
            if (epoxy_conservative_has_gl_extension("GL_ARB_clear_buffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_clear_texture:
            if (epoxy_conservative_has_gl_extension("GL_ARB_clear_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_clip_control:
            if (epoxy_conservative_has_gl_extension("GL_ARB_clip_control"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_color_buffer_float:
            if (epoxy_conservative_has_gl_extension("GL_ARB_color_buffer_float"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_compute_shader:
            if (epoxy_conservative_has_gl_extension("GL_ARB_compute_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_compute_variable_group_size:
            if (epoxy_conservative_has_gl_extension("GL_ARB_compute_variable_group_size"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_copy_buffer:
            if (epoxy_conservative_has_gl_extension("GL_ARB_copy_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_copy_image:
            if (epoxy_conservative_has_gl_extension("GL_ARB_copy_image"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_debug_output:
            if (epoxy_conservative_has_gl_extension("GL_ARB_debug_output"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_direct_state_access:
            if (epoxy_conservative_has_gl_extension("GL_ARB_direct_state_access"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_draw_buffers:
            if (epoxy_conservative_has_gl_extension("GL_ARB_draw_buffers"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_draw_buffers_blend:
            if (epoxy_conservative_has_gl_extension("GL_ARB_draw_buffers_blend"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_draw_elements_base_vertex:
            if (epoxy_conservative_has_gl_extension("GL_ARB_draw_elements_base_vertex"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_draw_indirect:
            if (epoxy_conservative_has_gl_extension("GL_ARB_draw_indirect"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_draw_instanced:
            if (epoxy_conservative_has_gl_extension("GL_ARB_draw_instanced"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_fragment_program:
            if (epoxy_conservative_has_gl_extension("GL_ARB_fragment_program"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_framebuffer_no_attachments:
            if (epoxy_conservative_has_gl_extension("GL_ARB_framebuffer_no_attachments"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_framebuffer_object:
            if (epoxy_conservative_has_gl_extension("GL_ARB_framebuffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_geometry_shader4:
            if (epoxy_conservative_has_gl_extension("GL_ARB_geometry_shader4"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_get_program_binary:
            if (epoxy_conservative_has_gl_extension("GL_ARB_get_program_binary"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_get_texture_sub_image:
            if (epoxy_conservative_has_gl_extension("GL_ARB_get_texture_sub_image"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_gpu_shader_fp64:
            if (epoxy_conservative_has_gl_extension("GL_ARB_gpu_shader_fp64"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_imaging:
            if (epoxy_conservative_has_gl_extension("GL_ARB_imaging"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_indirect_parameters:
            if (epoxy_conservative_has_gl_extension("GL_ARB_indirect_parameters"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_instanced_arrays:
            if (epoxy_conservative_has_gl_extension("GL_ARB_instanced_arrays"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_internalformat_query2:
            if (epoxy_conservative_has_gl_extension("GL_ARB_internalformat_query2"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_internalformat_query:
            if (epoxy_conservative_has_gl_extension("GL_ARB_internalformat_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_invalidate_subdata:
            if (epoxy_conservative_has_gl_extension("GL_ARB_invalidate_subdata"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_map_buffer_range:
            if (epoxy_conservative_has_gl_extension("GL_ARB_map_buffer_range"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_matrix_palette:
            if (epoxy_conservative_has_gl_extension("GL_ARB_matrix_palette"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_multi_bind:
            if (epoxy_conservative_has_gl_extension("GL_ARB_multi_bind"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_multi_draw_indirect:
            if (epoxy_conservative_has_gl_extension("GL_ARB_multi_draw_indirect"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_multisample:
            if (epoxy_conservative_has_gl_extension("GL_ARB_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_multitexture:
            if (epoxy_conservative_has_gl_extension("GL_ARB_multitexture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_occlusion_query:
            if (epoxy_conservative_has_gl_extension("GL_ARB_occlusion_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_point_parameters:
            if (epoxy_conservative_has_gl_extension("GL_ARB_point_parameters"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_program_interface_query:
            if (epoxy_conservative_has_gl_extension("GL_ARB_program_interface_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_provoking_vertex:
            if (epoxy_conservative_has_gl_extension("GL_ARB_provoking_vertex"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_robustness:
            if (epoxy_conservative_has_gl_extension("GL_ARB_robustness"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_sample_shading:
            if (epoxy_conservative_has_gl_extension("GL_ARB_sample_shading"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_sampler_objects:
            if (epoxy_conservative_has_gl_extension("GL_ARB_sampler_objects"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_separate_shader_objects:
            if (epoxy_conservative_has_gl_extension("GL_ARB_separate_shader_objects"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_shader_atomic_counters:
            if (epoxy_conservative_has_gl_extension("GL_ARB_shader_atomic_counters"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_shader_image_load_store:
            if (epoxy_conservative_has_gl_extension("GL_ARB_shader_image_load_store"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_shader_objects:
            if (epoxy_conservative_has_gl_extension("GL_ARB_shader_objects"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_shader_storage_buffer_object:
            if (epoxy_conservative_has_gl_extension("GL_ARB_shader_storage_buffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_shader_subroutine:
            if (epoxy_conservative_has_gl_extension("GL_ARB_shader_subroutine"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_shading_language_include:
            if (epoxy_conservative_has_gl_extension("GL_ARB_shading_language_include"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_sparse_buffer:
            if (epoxy_conservative_has_gl_extension("GL_ARB_sparse_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_sparse_texture:
            if (epoxy_conservative_has_gl_extension("GL_ARB_sparse_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_sync:
            if (epoxy_conservative_has_gl_extension("GL_ARB_sync"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_tessellation_shader:
            if (epoxy_conservative_has_gl_extension("GL_ARB_tessellation_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_texture_barrier:
            if (epoxy_conservative_has_gl_extension("GL_ARB_texture_barrier"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_texture_buffer_object:
            if (epoxy_conservative_has_gl_extension("GL_ARB_texture_buffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_texture_buffer_range:
            if (epoxy_conservative_has_gl_extension("GL_ARB_texture_buffer_range"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_texture_compression:
            if (epoxy_conservative_has_gl_extension("GL_ARB_texture_compression"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_texture_multisample:
            if (epoxy_conservative_has_gl_extension("GL_ARB_texture_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_texture_storage:
            if (epoxy_conservative_has_gl_extension("GL_ARB_texture_storage"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_texture_storage_multisample:
            if (epoxy_conservative_has_gl_extension("GL_ARB_texture_storage_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_texture_view:
            if (epoxy_conservative_has_gl_extension("GL_ARB_texture_view"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_timer_query:
            if (epoxy_conservative_has_gl_extension("GL_ARB_timer_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_transform_feedback2:
            if (epoxy_conservative_has_gl_extension("GL_ARB_transform_feedback2"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_transform_feedback3:
            if (epoxy_conservative_has_gl_extension("GL_ARB_transform_feedback3"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_transform_feedback_instanced:
            if (epoxy_conservative_has_gl_extension("GL_ARB_transform_feedback_instanced"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_transpose_matrix:
            if (epoxy_conservative_has_gl_extension("GL_ARB_transpose_matrix"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_uniform_buffer_object:
            if (epoxy_conservative_has_gl_extension("GL_ARB_uniform_buffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_vertex_array_object:
            if (epoxy_conservative_has_gl_extension("GL_ARB_vertex_array_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_vertex_attrib_64bit:
            if (epoxy_conservative_has_gl_extension("GL_ARB_vertex_attrib_64bit"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_vertex_attrib_binding:
            if (epoxy_conservative_has_gl_extension("GL_ARB_vertex_attrib_binding"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_vertex_blend:
            if (epoxy_conservative_has_gl_extension("GL_ARB_vertex_blend"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_vertex_buffer_object:
            if (epoxy_conservative_has_gl_extension("GL_ARB_vertex_buffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_vertex_program:
            if (epoxy_conservative_has_gl_extension("GL_ARB_vertex_program"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_vertex_shader:
            if (epoxy_conservative_has_gl_extension("GL_ARB_vertex_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_vertex_type_2_10_10_10_rev:
            if (epoxy_conservative_has_gl_extension("GL_ARB_vertex_type_2_10_10_10_rev"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_viewport_array:
            if (epoxy_conservative_has_gl_extension("GL_ARB_viewport_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_window_pos:
            if (epoxy_conservative_has_gl_extension("GL_ARB_window_pos"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_draw_buffers:
            if (epoxy_conservative_has_gl_extension("GL_ATI_draw_buffers"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_element_array:
            if (epoxy_conservative_has_gl_extension("GL_ATI_element_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_envmap_bumpmap:
            if (epoxy_conservative_has_gl_extension("GL_ATI_envmap_bumpmap"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_fragment_shader:
            if (epoxy_conservative_has_gl_extension("GL_ATI_fragment_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_map_object_buffer:
            if (epoxy_conservative_has_gl_extension("GL_ATI_map_object_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_pn_triangles:
            if (epoxy_conservative_has_gl_extension("GL_ATI_pn_triangles"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_separate_stencil:
            if (epoxy_conservative_has_gl_extension("GL_ATI_separate_stencil"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_vertex_array_object:
            if (epoxy_conservative_has_gl_extension("GL_ATI_vertex_array_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_vertex_attrib_array_object:
            if (epoxy_conservative_has_gl_extension("GL_ATI_vertex_attrib_array_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_vertex_streams:
            if (epoxy_conservative_has_gl_extension("GL_ATI_vertex_streams"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_base_instance:
            if (epoxy_conservative_has_gl_extension("GL_EXT_base_instance"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_bindable_uniform:
            if (epoxy_conservative_has_gl_extension("GL_EXT_bindable_uniform"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_blend_color:
            if (epoxy_conservative_has_gl_extension("GL_EXT_blend_color"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_blend_equation_separate:
            if (epoxy_conservative_has_gl_extension("GL_EXT_blend_equation_separate"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_blend_func_separate:
            if (epoxy_conservative_has_gl_extension("GL_EXT_blend_func_separate"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_blend_minmax:
            if (epoxy_conservative_has_gl_extension("GL_EXT_blend_minmax"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_buffer_storage:
            if (epoxy_conservative_has_gl_extension("GL_EXT_buffer_storage"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_color_subtable:
            if (epoxy_conservative_has_gl_extension("GL_EXT_color_subtable"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_compiled_vertex_array:
            if (epoxy_conservative_has_gl_extension("GL_EXT_compiled_vertex_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_convolution:
            if (epoxy_conservative_has_gl_extension("GL_EXT_convolution"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_coordinate_frame:
            if (epoxy_conservative_has_gl_extension("GL_EXT_coordinate_frame"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_copy_image:
            if (epoxy_conservative_has_gl_extension("GL_EXT_copy_image"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_copy_texture:
            if (epoxy_conservative_has_gl_extension("GL_EXT_copy_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_cull_vertex:
            if (epoxy_conservative_has_gl_extension("GL_EXT_cull_vertex"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_debug_label:
            if (epoxy_conservative_has_gl_extension("GL_EXT_debug_label"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_debug_marker:
            if (epoxy_conservative_has_gl_extension("GL_EXT_debug_marker"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_depth_bounds_test:
            if (epoxy_conservative_has_gl_extension("GL_EXT_depth_bounds_test"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_direct_state_access:
            if (epoxy_conservative_has_gl_extension("GL_EXT_direct_state_access"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_discard_framebuffer:
            if (epoxy_conservative_has_gl_extension("GL_EXT_discard_framebuffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_disjoint_timer_query:
            if (epoxy_conservative_has_gl_extension("GL_EXT_disjoint_timer_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_draw_buffers2:
            if (epoxy_conservative_has_gl_extension("GL_EXT_draw_buffers2"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_draw_buffers:
            if (epoxy_conservative_has_gl_extension("GL_EXT_draw_buffers"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_draw_buffers_indexed:
            if (epoxy_conservative_has_gl_extension("GL_EXT_draw_buffers_indexed"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_draw_elements_base_vertex:
            if (epoxy_conservative_has_gl_extension("GL_EXT_draw_elements_base_vertex"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_draw_instanced:
            if (epoxy_conservative_has_gl_extension("GL_EXT_draw_instanced"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_draw_range_elements:
            if (epoxy_conservative_has_gl_extension("GL_EXT_draw_range_elements"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_fog_coord:
            if (epoxy_conservative_has_gl_extension("GL_EXT_fog_coord"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_framebuffer_blit:
            if (epoxy_conservative_has_gl_extension("GL_EXT_framebuffer_blit"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_framebuffer_multisample:
            if (epoxy_conservative_has_gl_extension("GL_EXT_framebuffer_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_framebuffer_object:
            if (epoxy_conservative_has_gl_extension("GL_EXT_framebuffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_geometry_shader4:
            if (epoxy_conservative_has_gl_extension("GL_EXT_geometry_shader4"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_geometry_shader:
            if (epoxy_conservative_has_gl_extension("GL_EXT_geometry_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_gpu_program_parameters:
            if (epoxy_conservative_has_gl_extension("GL_EXT_gpu_program_parameters"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_gpu_shader4:
            if (epoxy_conservative_has_gl_extension("GL_EXT_gpu_shader4"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_histogram:
            if (epoxy_conservative_has_gl_extension("GL_EXT_histogram"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_index_func:
            if (epoxy_conservative_has_gl_extension("GL_EXT_index_func"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_index_material:
            if (epoxy_conservative_has_gl_extension("GL_EXT_index_material"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_instanced_arrays:
            if (epoxy_conservative_has_gl_extension("GL_EXT_instanced_arrays"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_light_texture:
            if (epoxy_conservative_has_gl_extension("GL_EXT_light_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_map_buffer_range:
            if (epoxy_conservative_has_gl_extension("GL_EXT_map_buffer_range"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_multi_draw_arrays:
            if (epoxy_conservative_has_gl_extension("GL_EXT_multi_draw_arrays"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_multi_draw_indirect:
            if (epoxy_conservative_has_gl_extension("GL_EXT_multi_draw_indirect"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_multisample:
            if (epoxy_conservative_has_gl_extension("GL_EXT_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_multisampled_render_to_texture:
            if (epoxy_conservative_has_gl_extension("GL_EXT_multisampled_render_to_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_multiview_draw_buffers:
            if (epoxy_conservative_has_gl_extension("GL_EXT_multiview_draw_buffers"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_occlusion_query_boolean:
            if (epoxy_conservative_has_gl_extension("GL_EXT_occlusion_query_boolean"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_paletted_texture:
            if (epoxy_conservative_has_gl_extension("GL_EXT_paletted_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_pixel_transform:
            if (epoxy_conservative_has_gl_extension("GL_EXT_pixel_transform"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_point_parameters:
            if (epoxy_conservative_has_gl_extension("GL_EXT_point_parameters"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_polygon_offset:
            if (epoxy_conservative_has_gl_extension("GL_EXT_polygon_offset"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_polygon_offset_clamp:
            if (epoxy_conservative_has_gl_extension("GL_EXT_polygon_offset_clamp"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_primitive_bounding_box:
            if (epoxy_conservative_has_gl_extension("GL_EXT_primitive_bounding_box"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_provoking_vertex:
            if (epoxy_conservative_has_gl_extension("GL_EXT_provoking_vertex"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_raster_multisample:
            if (epoxy_conservative_has_gl_extension("GL_EXT_raster_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_robustness:
            if (epoxy_conservative_has_gl_extension("GL_EXT_robustness"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_secondary_color:
            if (epoxy_conservative_has_gl_extension("GL_EXT_secondary_color"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_separate_shader_objects:
            if (epoxy_conservative_has_gl_extension("GL_EXT_separate_shader_objects"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_shader_image_load_store:
            if (epoxy_conservative_has_gl_extension("GL_EXT_shader_image_load_store"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_sparse_texture:
            if (epoxy_conservative_has_gl_extension("GL_EXT_sparse_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_stencil_clear_tag:
            if (epoxy_conservative_has_gl_extension("GL_EXT_stencil_clear_tag"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_stencil_two_side:
            if (epoxy_conservative_has_gl_extension("GL_EXT_stencil_two_side"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_subtexture:
            if (epoxy_conservative_has_gl_extension("GL_EXT_subtexture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_tessellation_shader:
            if (epoxy_conservative_has_gl_extension("GL_EXT_tessellation_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture3D:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture3D"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_array:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_border_clamp:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_border_clamp"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_buffer:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_buffer_object:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_buffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_filter_minmax:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_filter_minmax"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_integer:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_integer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_object:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_perturb_normal:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_perturb_normal"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_storage:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_storage"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_view:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_view"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_timer_query:
            if (epoxy_conservative_has_gl_extension("GL_EXT_timer_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_transform_feedback:
            if (epoxy_conservative_has_gl_extension("GL_EXT_transform_feedback"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_vertex_array:
            if (epoxy_conservative_has_gl_extension("GL_EXT_vertex_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_vertex_attrib_64bit:
            if (epoxy_conservative_has_gl_extension("GL_EXT_vertex_attrib_64bit"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_vertex_shader:
            if (epoxy_conservative_has_gl_extension("GL_EXT_vertex_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_vertex_weighting:
            if (epoxy_conservative_has_gl_extension("GL_EXT_vertex_weighting"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_x11_sync_object:
            if (epoxy_conservative_has_gl_extension("GL_EXT_x11_sync_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_GREMEDY_frame_terminator:
            if (epoxy_conservative_has_gl_extension("GL_GREMEDY_frame_terminator"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_GREMEDY_string_marker:
            if (epoxy_conservative_has_gl_extension("GL_GREMEDY_string_marker"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_HP_image_transform:
            if (epoxy_conservative_has_gl_extension("GL_HP_image_transform"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_IBM_multimode_draw_arrays:
            if (epoxy_conservative_has_gl_extension("GL_IBM_multimode_draw_arrays"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_IBM_static_data:
            if (epoxy_conservative_has_gl_extension("GL_IBM_static_data"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_IBM_vertex_array_lists:
            if (epoxy_conservative_has_gl_extension("GL_IBM_vertex_array_lists"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_IMG_multisampled_render_to_texture:
            if (epoxy_conservative_has_gl_extension("GL_IMG_multisampled_render_to_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_IMG_user_clip_plane:
            if (epoxy_conservative_has_gl_extension("GL_IMG_user_clip_plane"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_INGR_blend_func_separate:
            if (epoxy_conservative_has_gl_extension("GL_INGR_blend_func_separate"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_INTEL_map_texture:
            if (epoxy_conservative_has_gl_extension("GL_INTEL_map_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_INTEL_parallel_arrays:
            if (epoxy_conservative_has_gl_extension("GL_INTEL_parallel_arrays"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_INTEL_performance_query:
            if (epoxy_conservative_has_gl_extension("GL_INTEL_performance_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_KHR_blend_equation_advanced:
            if (epoxy_conservative_has_gl_extension("GL_KHR_blend_equation_advanced"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_KHR_debug:
            if (epoxy_conservative_has_gl_extension("GL_KHR_debug"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_KHR_robustness:
            if (epoxy_conservative_has_gl_extension("GL_KHR_robustness"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_MESA_resize_buffers:
            if (epoxy_conservative_has_gl_extension("GL_MESA_resize_buffers"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_MESA_window_pos:
            if (epoxy_conservative_has_gl_extension("GL_MESA_window_pos"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NVX_conditional_render:
            if (epoxy_conservative_has_gl_extension("GL_NVX_conditional_render"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_bindless_multi_draw_indirect:
            if (epoxy_conservative_has_gl_extension("GL_NV_bindless_multi_draw_indirect"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_bindless_multi_draw_indirect_count:
            if (epoxy_conservative_has_gl_extension("GL_NV_bindless_multi_draw_indirect_count"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_bindless_texture:
            if (epoxy_conservative_has_gl_extension("GL_NV_bindless_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_blend_equation_advanced:
            if (epoxy_conservative_has_gl_extension("GL_NV_blend_equation_advanced"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_command_list:
            if (epoxy_conservative_has_gl_extension("GL_NV_command_list"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_conditional_render:
            if (epoxy_conservative_has_gl_extension("GL_NV_conditional_render"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_conservative_raster:
            if (epoxy_conservative_has_gl_extension("GL_NV_conservative_raster"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_copy_buffer:
            if (epoxy_conservative_has_gl_extension("GL_NV_copy_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_copy_image:
            if (epoxy_conservative_has_gl_extension("GL_NV_copy_image"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_coverage_sample:
            if (epoxy_conservative_has_gl_extension("GL_NV_coverage_sample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_depth_buffer_float:
            if (epoxy_conservative_has_gl_extension("GL_NV_depth_buffer_float"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_draw_buffers:
            if (epoxy_conservative_has_gl_extension("GL_NV_draw_buffers"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_draw_instanced:
            if (epoxy_conservative_has_gl_extension("GL_NV_draw_instanced"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_draw_texture:
            if (epoxy_conservative_has_gl_extension("GL_NV_draw_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_evaluators:
            if (epoxy_conservative_has_gl_extension("GL_NV_evaluators"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_explicit_multisample:
            if (epoxy_conservative_has_gl_extension("GL_NV_explicit_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_fence:
            if (epoxy_conservative_has_gl_extension("GL_NV_fence"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_fragment_coverage_to_color:
            if (epoxy_conservative_has_gl_extension("GL_NV_fragment_coverage_to_color"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_fragment_program:
            if (epoxy_conservative_has_gl_extension("GL_NV_fragment_program"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_framebuffer_blit:
            if (epoxy_conservative_has_gl_extension("GL_NV_framebuffer_blit"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_framebuffer_mixed_samples:
            if (epoxy_conservative_has_gl_extension("GL_NV_framebuffer_mixed_samples"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_framebuffer_multisample:
            if (epoxy_conservative_has_gl_extension("GL_NV_framebuffer_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_framebuffer_multisample_coverage:
            if (epoxy_conservative_has_gl_extension("GL_NV_framebuffer_multisample_coverage"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_geometry_program4:
            if (epoxy_conservative_has_gl_extension("GL_NV_geometry_program4"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_gpu_program4:
            if (epoxy_conservative_has_gl_extension("GL_NV_gpu_program4"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_gpu_program5:
            if (epoxy_conservative_has_gl_extension("GL_NV_gpu_program5"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_gpu_shader5:
            if (epoxy_conservative_has_gl_extension("GL_NV_gpu_shader5"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_half_float:
            if (epoxy_conservative_has_gl_extension("GL_NV_half_float"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_instanced_arrays:
            if (epoxy_conservative_has_gl_extension("GL_NV_instanced_arrays"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_internalformat_sample_query:
            if (epoxy_conservative_has_gl_extension("GL_NV_internalformat_sample_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_non_square_matrices:
            if (epoxy_conservative_has_gl_extension("GL_NV_non_square_matrices"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_occlusion_query:
            if (epoxy_conservative_has_gl_extension("GL_NV_occlusion_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_parameter_buffer_object:
            if (epoxy_conservative_has_gl_extension("GL_NV_parameter_buffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_path_rendering:
            if (epoxy_conservative_has_gl_extension("GL_NV_path_rendering"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_pixel_data_range:
            if (epoxy_conservative_has_gl_extension("GL_NV_pixel_data_range"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_point_sprite:
            if (epoxy_conservative_has_gl_extension("GL_NV_point_sprite"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_polygon_mode:
            if (epoxy_conservative_has_gl_extension("GL_NV_polygon_mode"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_present_video:
            if (epoxy_conservative_has_gl_extension("GL_NV_present_video"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_primitive_restart:
            if (epoxy_conservative_has_gl_extension("GL_NV_primitive_restart"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_read_buffer:
            if (epoxy_conservative_has_gl_extension("GL_NV_read_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_register_combiners2:
            if (epoxy_conservative_has_gl_extension("GL_NV_register_combiners2"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_register_combiners:
            if (epoxy_conservative_has_gl_extension("GL_NV_register_combiners"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_sample_locations:
            if (epoxy_conservative_has_gl_extension("GL_NV_sample_locations"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_shader_buffer_load:
            if (epoxy_conservative_has_gl_extension("GL_NV_shader_buffer_load"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_texture_barrier:
            if (epoxy_conservative_has_gl_extension("GL_NV_texture_barrier"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_texture_multisample:
            if (epoxy_conservative_has_gl_extension("GL_NV_texture_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_transform_feedback2:
            if (epoxy_conservative_has_gl_extension("GL_NV_transform_feedback2"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_transform_feedback:
            if (epoxy_conservative_has_gl_extension("GL_NV_transform_feedback"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_vdpau_interop:
            if (epoxy_conservative_has_gl_extension("GL_NV_vdpau_interop"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_vertex_array_range:
            if (epoxy_conservative_has_gl_extension("GL_NV_vertex_array_range"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_vertex_attrib_integer_64bit:
            if (epoxy_conservative_has_gl_extension("GL_NV_vertex_attrib_integer_64bit"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_vertex_buffer_unified_memory:
            if (epoxy_conservative_has_gl_extension("GL_NV_vertex_buffer_unified_memory"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_vertex_program4:
            if (epoxy_conservative_has_gl_extension("GL_NV_vertex_program4"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_vertex_program:
            if (epoxy_conservative_has_gl_extension("GL_NV_vertex_program"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_video_capture:
            if (epoxy_conservative_has_gl_extension("GL_NV_video_capture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_viewport_array:
            if (epoxy_conservative_has_gl_extension("GL_NV_viewport_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_EGL_image:
            if (epoxy_conservative_has_gl_extension("GL_OES_EGL_image"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_blend_equation_separate:
            if (epoxy_conservative_has_gl_extension("GL_OES_blend_equation_separate"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_blend_func_separate:
            if (epoxy_conservative_has_gl_extension("GL_OES_blend_func_separate"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_blend_subtract:
            if (epoxy_conservative_has_gl_extension("GL_OES_blend_subtract"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_byte_coordinates:
            if (epoxy_conservative_has_gl_extension("GL_OES_byte_coordinates"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_copy_image:
            if (epoxy_conservative_has_gl_extension("GL_OES_copy_image"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_draw_buffers_indexed:
            if (epoxy_conservative_has_gl_extension("GL_OES_draw_buffers_indexed"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_draw_elements_base_vertex:
            if (epoxy_conservative_has_gl_extension("GL_OES_draw_elements_base_vertex"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_draw_texture:
            if (epoxy_conservative_has_gl_extension("GL_OES_draw_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_fixed_point:
            if (epoxy_conservative_has_gl_extension("GL_OES_fixed_point"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_framebuffer_object:
            if (epoxy_conservative_has_gl_extension("GL_OES_framebuffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_geometry_shader:
            if (epoxy_conservative_has_gl_extension("GL_OES_geometry_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_get_program_binary:
            if (epoxy_conservative_has_gl_extension("GL_OES_get_program_binary"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_mapbuffer:
            if (epoxy_conservative_has_gl_extension("GL_OES_mapbuffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_matrix_palette:
            if (epoxy_conservative_has_gl_extension("GL_OES_matrix_palette"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_point_size_array:
            if (epoxy_conservative_has_gl_extension("GL_OES_point_size_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_primitive_bounding_box:
            if (epoxy_conservative_has_gl_extension("GL_OES_primitive_bounding_box"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_query_matrix:
            if (epoxy_conservative_has_gl_extension("GL_OES_query_matrix"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_sample_shading:
            if (epoxy_conservative_has_gl_extension("GL_OES_sample_shading"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_single_precision:
            if (epoxy_conservative_has_gl_extension("GL_OES_single_precision"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_tessellation_shader:
            if (epoxy_conservative_has_gl_extension("GL_OES_tessellation_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_texture_3D:
            if (epoxy_conservative_has_gl_extension("GL_OES_texture_3D"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_texture_border_clamp:
            if (epoxy_conservative_has_gl_extension("GL_OES_texture_border_clamp"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_texture_buffer:
            if (epoxy_conservative_has_gl_extension("GL_OES_texture_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_texture_cube_map:
            if (epoxy_conservative_has_gl_extension("GL_OES_texture_cube_map"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_texture_storage_multisample_2d_array:
            if (epoxy_conservative_has_gl_extension("GL_OES_texture_storage_multisample_2d_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_texture_view:
            if (epoxy_conservative_has_gl_extension("GL_OES_texture_view"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_vertex_array_object:
            if (epoxy_conservative_has_gl_extension("GL_OES_vertex_array_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OVR_multiview:
            if (epoxy_conservative_has_gl_extension("GL_OVR_multiview"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_PGI_misc_hints:
            if (epoxy_conservative_has_gl_extension("GL_PGI_misc_hints"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_QCOM_alpha_test:
            if (epoxy_conservative_has_gl_extension("GL_QCOM_alpha_test"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_QCOM_driver_control:
            if (epoxy_conservative_has_gl_extension("GL_QCOM_driver_control"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_QCOM_extended_get2:
            if (epoxy_conservative_has_gl_extension("GL_QCOM_extended_get2"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_QCOM_extended_get:
            if (epoxy_conservative_has_gl_extension("GL_QCOM_extended_get"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_QCOM_tiled_rendering:
            if (epoxy_conservative_has_gl_extension("GL_QCOM_tiled_rendering"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_detail_texture:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_detail_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_fog_function:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_fog_function"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_multisample:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_pixel_texture:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_pixel_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_point_parameters:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_point_parameters"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_sharpen_texture:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_sharpen_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_texture4D:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_texture4D"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_texture_color_mask:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_texture_color_mask"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_texture_filter4:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_texture_filter4"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_async:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_async"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_flush_raster:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_flush_raster"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_fragment_lighting:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_fragment_lighting"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_framezoom:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_framezoom"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_igloo_interface:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_igloo_interface"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_instruments:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_instruments"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_list_priority:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_list_priority"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_pixel_texture:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_pixel_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_polynomial_ffd:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_polynomial_ffd"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_reference_plane:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_reference_plane"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_sprite:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_sprite"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_tag_sample_buffer:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_tag_sample_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGI_color_table:
            if (epoxy_conservative_has_gl_extension("GL_SGI_color_table"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SUNX_constant_data:
            if (epoxy_conservative_has_gl_extension("GL_SUNX_constant_data"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SUN_global_alpha:
            if (epoxy_conservative_has_gl_extension("GL_SUN_global_alpha"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SUN_mesh_array:
            if (epoxy_conservative_has_gl_extension("GL_SUN_mesh_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SUN_triangle_list:
            if (epoxy_conservative_has_gl_extension("GL_SUN_triangle_list"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SUN_vertex:
            if (epoxy_conservative_has_gl_extension("GL_SUN_vertex"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case OpenGL_ES_1_0:
            if (!epoxy_is_desktop_gl() && epoxy_gl_version() >= 10 && epoxy_gl_version() < 20)
                return epoxy_gles1_dlsym(entrypoint_strings + entrypoints[i]);
            break;
        case OpenGL_ES_2_0:
            if (!epoxy_is_desktop_gl() && epoxy_gl_version() >= 20)
                return epoxy_gles2_dlsym(entrypoint_strings + entrypoints[i]);
            break;
        case OpenGL_ES_3_0:
            if (!epoxy_is_desktop_gl() && epoxy_gl_version() >= 30)
                return epoxy_gles3_dlsym(entrypoint_strings + entrypoints[i]);
            break;
        case OpenGL_ES_3_1:
            if (!epoxy_is_desktop_gl() && epoxy_gl_version() >= 31)
                return epoxy_gles3_dlsym(entrypoint_strings + entrypoints[i]);
            break;
        case always_present:
            if (true)
                return epoxy_get_bootstrap_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case gl_provider_terminator:
            abort(); /* Not reached */
        }
    }

    fprintf(stderr, "No provider of %s found.  Requires one of:\n", name);
    for (i = 0; providers[i] != gl_provider_terminator; i++) {
        fprintf(stderr, "    %s\n", enum_string + enum_string_offsets[providers[i]]);
    }
    if (providers[0] == gl_provider_terminator) {
        fprintf(stderr, "    No known providers.  This is likely a bug "
                        "in libepoxy code generation\n");
    }
    abort();
}

EPOXY_NOINLINE static void *
gl_single_resolver(enum gl_provider provider, uint16_t entrypoint_offset);

static void *
gl_single_resolver(enum gl_provider provider, uint16_t entrypoint_offset)
{
    enum gl_provider providers[] = {
        provider,
        gl_provider_terminator
    };
    return gl_provider_resolver(entrypoint_strings + entrypoint_offset,
                                providers, &entrypoint_offset);
}

static PFNGLACCUMPROC
epoxy_glAccum_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 0 /* glAccum */);
}

static PFNGLACCUMXOESPROC
epoxy_glAccumxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 8 /* glAccumxOES */);
}

static PFNGLACTIVEPROGRAMEXTPROC
epoxy_glActiveProgramEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_separate_shader_objects, 20 /* glActiveProgramEXT */);
}

static PFNGLACTIVESHADERPROGRAMPROC
epoxy_glActiveShaderProgram_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_separate_shader_objects,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        39 /* "glActiveShaderProgram" */,
        39 /* "glActiveShaderProgram" */,
        39 /* "glActiveShaderProgram" */,
    };
    return gl_provider_resolver(entrypoint_strings + 39 /* "glActiveShaderProgram" */,
                                providers, entrypoints);
}

static PFNGLACTIVESHADERPROGRAMEXTPROC
epoxy_glActiveShaderProgramEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_separate_shader_objects, 61 /* glActiveShaderProgramEXT */);
}

static PFNGLACTIVESTENCILFACEEXTPROC
epoxy_glActiveStencilFaceEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_stencil_two_side, 86 /* glActiveStencilFaceEXT */);
}

static PFNGLACTIVETEXTUREPROC
epoxy_glActiveTexture_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_3,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_multitexture,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        109 /* "glActiveTexture" */,
        109 /* "glActiveTexture" */,
        109 /* "glActiveTexture" */,
        125 /* "glActiveTextureARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 109 /* "glActiveTexture" */,
                                providers, entrypoints);
}

static PFNGLACTIVETEXTUREARBPROC
epoxy_glActiveTextureARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_multitexture,
        Desktop_OpenGL_1_3,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        125 /* "glActiveTextureARB" */,
        109 /* "glActiveTexture" */,
        109 /* "glActiveTexture" */,
        109 /* "glActiveTexture" */,
    };
    return gl_provider_resolver(entrypoint_strings + 125 /* "glActiveTextureARB" */,
                                providers, entrypoints);
}

static PFNGLACTIVEVARYINGNVPROC
epoxy_glActiveVaryingNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_transform_feedback, 144 /* glActiveVaryingNV */);
}

static PFNGLALPHAFRAGMENTOP1ATIPROC
epoxy_glAlphaFragmentOp1ATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_fragment_shader, 162 /* glAlphaFragmentOp1ATI */);
}

static PFNGLALPHAFRAGMENTOP2ATIPROC
epoxy_glAlphaFragmentOp2ATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_fragment_shader, 184 /* glAlphaFragmentOp2ATI */);
}

static PFNGLALPHAFRAGMENTOP3ATIPROC
epoxy_glAlphaFragmentOp3ATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_fragment_shader, 206 /* glAlphaFragmentOp3ATI */);
}

static PFNGLALPHAFUNCPROC
epoxy_glAlphaFunc_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        228 /* "glAlphaFunc" */,
        228 /* "glAlphaFunc" */,
    };
    return gl_provider_resolver(entrypoint_strings + 228 /* "glAlphaFunc" */,
                                providers, entrypoints);
}

static PFNGLALPHAFUNCQCOMPROC
epoxy_glAlphaFuncQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_alpha_test, 240 /* glAlphaFuncQCOM */);
}

static PFNGLALPHAFUNCXPROC
epoxy_glAlphaFuncx_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 256 /* glAlphaFuncx */);
}

static PFNGLALPHAFUNCXOESPROC
epoxy_glAlphaFuncxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 269 /* glAlphaFuncxOES */);
}

static PFNGLAPPLYTEXTUREEXTPROC
epoxy_glApplyTextureEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_light_texture, 285 /* glApplyTextureEXT */);
}

static PFNGLAREPROGRAMSRESIDENTNVPROC
epoxy_glAreProgramsResidentNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_program, 303 /* glAreProgramsResidentNV */);
}

static PFNGLARETEXTURESRESIDENTPROC
epoxy_glAreTexturesResident_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_1, 327 /* glAreTexturesResident */);
}

static PFNGLARETEXTURESRESIDENTEXTPROC
epoxy_glAreTexturesResidentEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_texture_object, 349 /* glAreTexturesResidentEXT */);
}

static PFNGLARRAYELEMENTPROC
epoxy_glArrayElement_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_1,
        GL_extension_GL_EXT_vertex_array,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        374 /* "glArrayElement" */,
        389 /* "glArrayElementEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 374 /* "glArrayElement" */,
                                providers, entrypoints);
}

static PFNGLARRAYELEMENTEXTPROC
epoxy_glArrayElementEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_vertex_array,
        Desktop_OpenGL_1_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        389 /* "glArrayElementEXT" */,
        374 /* "glArrayElement" */,
    };
    return gl_provider_resolver(entrypoint_strings + 389 /* "glArrayElementEXT" */,
                                providers, entrypoints);
}

static PFNGLARRAYOBJECTATIPROC
epoxy_glArrayObjectATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_vertex_array_object, 407 /* glArrayObjectATI */);
}

static PFNGLASYNCMARKERSGIXPROC
epoxy_glAsyncMarkerSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_async, 424 /* glAsyncMarkerSGIX */);
}

static PFNGLATTACHOBJECTARBPROC
epoxy_glAttachObjectARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_shader_objects,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        442 /* "glAttachObjectARB" */,
        460 /* "glAttachShader" */,
        460 /* "glAttachShader" */,
    };
    return gl_provider_resolver(entrypoint_strings + 442 /* "glAttachObjectARB" */,
                                providers, entrypoints);
}

static PFNGLATTACHSHADERPROC
epoxy_glAttachShader_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_shader_objects,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        460 /* "glAttachShader" */,
        460 /* "glAttachShader" */,
        442 /* "glAttachObjectARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 460 /* "glAttachShader" */,
                                providers, entrypoints);
}

static PFNGLBEGINPROC
epoxy_glBegin_unwrapped_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 475 /* glBegin */);
}

static PFNGLBEGINCONDITIONALRENDERPROC
epoxy_glBeginConditionalRender_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_NV_conditional_render,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        483 /* "glBeginConditionalRender" */,
        508 /* "glBeginConditionalRenderNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 483 /* "glBeginConditionalRender" */,
                                providers, entrypoints);
}

static PFNGLBEGINCONDITIONALRENDERNVPROC
epoxy_glBeginConditionalRenderNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_conditional_render,
        Desktop_OpenGL_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        508 /* "glBeginConditionalRenderNV" */,
        483 /* "glBeginConditionalRender" */,
    };
    return gl_provider_resolver(entrypoint_strings + 508 /* "glBeginConditionalRenderNV" */,
                                providers, entrypoints);
}

static PFNGLBEGINCONDITIONALRENDERNVXPROC
epoxy_glBeginConditionalRenderNVX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NVX_conditional_render, 535 /* glBeginConditionalRenderNVX */);
}

static PFNGLBEGINFRAGMENTSHADERATIPROC
epoxy_glBeginFragmentShaderATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_fragment_shader, 563 /* glBeginFragmentShaderATI */);
}

static PFNGLBEGINOCCLUSIONQUERYNVPROC
epoxy_glBeginOcclusionQueryNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_occlusion_query, 588 /* glBeginOcclusionQueryNV */);
}

static PFNGLBEGINPERFMONITORAMDPROC
epoxy_glBeginPerfMonitorAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_performance_monitor, 612 /* glBeginPerfMonitorAMD */);
}

static PFNGLBEGINPERFQUERYINTELPROC
epoxy_glBeginPerfQueryINTEL_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_INTEL_performance_query, 634 /* glBeginPerfQueryINTEL */);
}

static PFNGLBEGINQUERYPROC
epoxy_glBeginQuery_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_occlusion_query,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        656 /* "glBeginQuery" */,
        656 /* "glBeginQuery" */,
        669 /* "glBeginQueryARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 656 /* "glBeginQuery" */,
                                providers, entrypoints);
}

static PFNGLBEGINQUERYARBPROC
epoxy_glBeginQueryARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_occlusion_query,
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        669 /* "glBeginQueryARB" */,
        656 /* "glBeginQuery" */,
        656 /* "glBeginQuery" */,
    };
    return gl_provider_resolver(entrypoint_strings + 669 /* "glBeginQueryARB" */,
                                providers, entrypoints);
}

static PFNGLBEGINQUERYEXTPROC
epoxy_glBeginQueryEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_disjoint_timer_query,
        GL_extension_GL_EXT_occlusion_query_boolean,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        685 /* "glBeginQueryEXT" */,
        685 /* "glBeginQueryEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 685 /* "glBeginQueryEXT" */,
                                providers, entrypoints);
}

static PFNGLBEGINQUERYINDEXEDPROC
epoxy_glBeginQueryIndexed_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_transform_feedback3,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        701 /* "glBeginQueryIndexed" */,
        701 /* "glBeginQueryIndexed" */,
    };
    return gl_provider_resolver(entrypoint_strings + 701 /* "glBeginQueryIndexed" */,
                                providers, entrypoints);
}

static PFNGLBEGINTRANSFORMFEEDBACKPROC
epoxy_glBeginTransformFeedback_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_transform_feedback,
        GL_extension_GL_NV_transform_feedback,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        721 /* "glBeginTransformFeedback" */,
        721 /* "glBeginTransformFeedback" */,
        746 /* "glBeginTransformFeedbackEXT" */,
        774 /* "glBeginTransformFeedbackNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 721 /* "glBeginTransformFeedback" */,
                                providers, entrypoints);
}

static PFNGLBEGINTRANSFORMFEEDBACKEXTPROC
epoxy_glBeginTransformFeedbackEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_transform_feedback,
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        GL_extension_GL_NV_transform_feedback,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        746 /* "glBeginTransformFeedbackEXT" */,
        721 /* "glBeginTransformFeedback" */,
        721 /* "glBeginTransformFeedback" */,
        774 /* "glBeginTransformFeedbackNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 746 /* "glBeginTransformFeedbackEXT" */,
                                providers, entrypoints);
}

static PFNGLBEGINTRANSFORMFEEDBACKNVPROC
epoxy_glBeginTransformFeedbackNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_transform_feedback,
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_transform_feedback,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        774 /* "glBeginTransformFeedbackNV" */,
        721 /* "glBeginTransformFeedback" */,
        721 /* "glBeginTransformFeedback" */,
        746 /* "glBeginTransformFeedbackEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 774 /* "glBeginTransformFeedbackNV" */,
                                providers, entrypoints);
}

static PFNGLBEGINVERTEXSHADEREXTPROC
epoxy_glBeginVertexShaderEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 801 /* glBeginVertexShaderEXT */);
}

static PFNGLBEGINVIDEOCAPTURENVPROC
epoxy_glBeginVideoCaptureNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_video_capture, 824 /* glBeginVideoCaptureNV */);
}

static PFNGLBINDATTRIBLOCATIONPROC
epoxy_glBindAttribLocation_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_shader,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        846 /* "glBindAttribLocation" */,
        846 /* "glBindAttribLocation" */,
        867 /* "glBindAttribLocationARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 846 /* "glBindAttribLocation" */,
                                providers, entrypoints);
}

static PFNGLBINDATTRIBLOCATIONARBPROC
epoxy_glBindAttribLocationARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_shader,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        867 /* "glBindAttribLocationARB" */,
        846 /* "glBindAttribLocation" */,
        846 /* "glBindAttribLocation" */,
    };
    return gl_provider_resolver(entrypoint_strings + 867 /* "glBindAttribLocationARB" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERPROC
epoxy_glBindBuffer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_buffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        891 /* "glBindBuffer" */,
        891 /* "glBindBuffer" */,
        891 /* "glBindBuffer" */,
        904 /* "glBindBufferARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 891 /* "glBindBuffer" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERARBPROC
epoxy_glBindBufferARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_buffer_object,
        Desktop_OpenGL_1_5,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        904 /* "glBindBufferARB" */,
        891 /* "glBindBuffer" */,
        891 /* "glBindBuffer" */,
        891 /* "glBindBuffer" */,
    };
    return gl_provider_resolver(entrypoint_strings + 904 /* "glBindBufferARB" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERBASEPROC
epoxy_glBindBufferBase_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_transform_feedback,
        GL_extension_GL_NV_transform_feedback,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        920 /* "glBindBufferBase" */,
        920 /* "glBindBufferBase" */,
        920 /* "glBindBufferBase" */,
        920 /* "glBindBufferBase" */,
        937 /* "glBindBufferBaseEXT" */,
        957 /* "glBindBufferBaseNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 920 /* "glBindBufferBase" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERBASEEXTPROC
epoxy_glBindBufferBaseEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_transform_feedback,
        Desktop_OpenGL_3_0,
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_NV_transform_feedback,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        937 /* "glBindBufferBaseEXT" */,
        920 /* "glBindBufferBase" */,
        920 /* "glBindBufferBase" */,
        920 /* "glBindBufferBase" */,
        920 /* "glBindBufferBase" */,
        957 /* "glBindBufferBaseNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 937 /* "glBindBufferBaseEXT" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERBASENVPROC
epoxy_glBindBufferBaseNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_transform_feedback,
        Desktop_OpenGL_3_0,
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_transform_feedback,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        957 /* "glBindBufferBaseNV" */,
        920 /* "glBindBufferBase" */,
        920 /* "glBindBufferBase" */,
        920 /* "glBindBufferBase" */,
        920 /* "glBindBufferBase" */,
        937 /* "glBindBufferBaseEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 957 /* "glBindBufferBaseNV" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFEROFFSETEXTPROC
epoxy_glBindBufferOffsetEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_transform_feedback,
        GL_extension_GL_NV_transform_feedback,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        976 /* "glBindBufferOffsetEXT" */,
        998 /* "glBindBufferOffsetNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 976 /* "glBindBufferOffsetEXT" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFEROFFSETNVPROC
epoxy_glBindBufferOffsetNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_transform_feedback,
        GL_extension_GL_EXT_transform_feedback,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        998 /* "glBindBufferOffsetNV" */,
        976 /* "glBindBufferOffsetEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 998 /* "glBindBufferOffsetNV" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERRANGEPROC
epoxy_glBindBufferRange_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_transform_feedback,
        GL_extension_GL_NV_transform_feedback,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1019 /* "glBindBufferRange" */,
        1019 /* "glBindBufferRange" */,
        1019 /* "glBindBufferRange" */,
        1019 /* "glBindBufferRange" */,
        1037 /* "glBindBufferRangeEXT" */,
        1058 /* "glBindBufferRangeNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1019 /* "glBindBufferRange" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERRANGEEXTPROC
epoxy_glBindBufferRangeEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_transform_feedback,
        Desktop_OpenGL_3_0,
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_NV_transform_feedback,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1037 /* "glBindBufferRangeEXT" */,
        1019 /* "glBindBufferRange" */,
        1019 /* "glBindBufferRange" */,
        1019 /* "glBindBufferRange" */,
        1019 /* "glBindBufferRange" */,
        1058 /* "glBindBufferRangeNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1037 /* "glBindBufferRangeEXT" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERRANGENVPROC
epoxy_glBindBufferRangeNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_transform_feedback,
        Desktop_OpenGL_3_0,
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_transform_feedback,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1058 /* "glBindBufferRangeNV" */,
        1019 /* "glBindBufferRange" */,
        1019 /* "glBindBufferRange" */,
        1019 /* "glBindBufferRange" */,
        1019 /* "glBindBufferRange" */,
        1037 /* "glBindBufferRangeEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1058 /* "glBindBufferRangeNV" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERSBASEPROC
epoxy_glBindBuffersBase_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_4,
        GL_extension_GL_ARB_multi_bind,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1078 /* "glBindBuffersBase" */,
        1078 /* "glBindBuffersBase" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1078 /* "glBindBuffersBase" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERSRANGEPROC
epoxy_glBindBuffersRange_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_4,
        GL_extension_GL_ARB_multi_bind,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1096 /* "glBindBuffersRange" */,
        1096 /* "glBindBuffersRange" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1096 /* "glBindBuffersRange" */,
                                providers, entrypoints);
}

static PFNGLBINDFRAGDATALOCATIONPROC
epoxy_glBindFragDataLocation_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_gpu_shader4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1115 /* "glBindFragDataLocation" */,
        1138 /* "glBindFragDataLocationEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1115 /* "glBindFragDataLocation" */,
                                providers, entrypoints);
}

static PFNGLBINDFRAGDATALOCATIONEXTPROC
epoxy_glBindFragDataLocationEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_gpu_shader4,
        Desktop_OpenGL_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1138 /* "glBindFragDataLocationEXT" */,
        1115 /* "glBindFragDataLocation" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1138 /* "glBindFragDataLocationEXT" */,
                                providers, entrypoints);
}

static PFNGLBINDFRAGDATALOCATIONINDEXEDPROC
epoxy_glBindFragDataLocationIndexed_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_blend_func_extended,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1164 /* "glBindFragDataLocationIndexed" */,
        1164 /* "glBindFragDataLocationIndexed" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1164 /* "glBindFragDataLocationIndexed" */,
                                providers, entrypoints);
}

static PFNGLBINDFRAGMENTSHADERATIPROC
epoxy_glBindFragmentShaderATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_fragment_shader, 1194 /* glBindFragmentShaderATI */);
}

static PFNGLBINDFRAMEBUFFERPROC
epoxy_glBindFramebuffer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_framebuffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1218 /* "glBindFramebuffer" */,
        1218 /* "glBindFramebuffer" */,
        1218 /* "glBindFramebuffer" */,
        1236 /* "glBindFramebufferEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1218 /* "glBindFramebuffer" */,
                                providers, entrypoints);
}

static PFNGLBINDFRAMEBUFFEREXTPROC
epoxy_glBindFramebufferEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1236 /* "glBindFramebufferEXT" */,
        1218 /* "glBindFramebuffer" */,
        1218 /* "glBindFramebuffer" */,
        1218 /* "glBindFramebuffer" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1236 /* "glBindFramebufferEXT" */,
                                providers, entrypoints);
}

static PFNGLBINDFRAMEBUFFEROESPROC
epoxy_glBindFramebufferOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_framebuffer_object, 1257 /* glBindFramebufferOES */);
}

static PFNGLBINDIMAGETEXTUREPROC
epoxy_glBindImageTexture_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_2,
        GL_extension_GL_ARB_shader_image_load_store,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1278 /* "glBindImageTexture" */,
        1278 /* "glBindImageTexture" */,
        1278 /* "glBindImageTexture" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1278 /* "glBindImageTexture" */,
                                providers, entrypoints);
}

static PFNGLBINDIMAGETEXTUREEXTPROC
epoxy_glBindImageTextureEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_shader_image_load_store, 1297 /* glBindImageTextureEXT */);
}

static PFNGLBINDIMAGETEXTURESPROC
epoxy_glBindImageTextures_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_4,
        GL_extension_GL_ARB_multi_bind,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1319 /* "glBindImageTextures" */,
        1319 /* "glBindImageTextures" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1319 /* "glBindImageTextures" */,
                                providers, entrypoints);
}

static PFNGLBINDLIGHTPARAMETEREXTPROC
epoxy_glBindLightParameterEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 1339 /* glBindLightParameterEXT */);
}

static PFNGLBINDMATERIALPARAMETEREXTPROC
epoxy_glBindMaterialParameterEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 1363 /* glBindMaterialParameterEXT */);
}

static PFNGLBINDMULTITEXTUREEXTPROC
epoxy_glBindMultiTextureEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 1390 /* glBindMultiTextureEXT */);
}

static PFNGLBINDPARAMETEREXTPROC
epoxy_glBindParameterEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 1412 /* glBindParameterEXT */);
}

static PFNGLBINDPROGRAMARBPROC
epoxy_glBindProgramARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_fragment_program,
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_NV_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1431 /* "glBindProgramARB" */,
        1431 /* "glBindProgramARB" */,
        1448 /* "glBindProgramNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1431 /* "glBindProgramARB" */,
                                providers, entrypoints);
}

static PFNGLBINDPROGRAMNVPROC
epoxy_glBindProgramNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_vertex_program,
        GL_extension_GL_ARB_fragment_program,
        GL_extension_GL_ARB_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1448 /* "glBindProgramNV" */,
        1431 /* "glBindProgramARB" */,
        1431 /* "glBindProgramARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1448 /* "glBindProgramNV" */,
                                providers, entrypoints);
}

static PFNGLBINDPROGRAMPIPELINEPROC
epoxy_glBindProgramPipeline_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_separate_shader_objects,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1464 /* "glBindProgramPipeline" */,
        1464 /* "glBindProgramPipeline" */,
        1464 /* "glBindProgramPipeline" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1464 /* "glBindProgramPipeline" */,
                                providers, entrypoints);
}

static PFNGLBINDPROGRAMPIPELINEEXTPROC
epoxy_glBindProgramPipelineEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_separate_shader_objects, 1486 /* glBindProgramPipelineEXT */);
}

static PFNGLBINDRENDERBUFFERPROC
epoxy_glBindRenderbuffer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1511 /* "glBindRenderbuffer" */,
        1511 /* "glBindRenderbuffer" */,
        1511 /* "glBindRenderbuffer" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1511 /* "glBindRenderbuffer" */,
                                providers, entrypoints);
}

static PFNGLBINDRENDERBUFFEREXTPROC
epoxy_glBindRenderbufferEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_framebuffer_object, 1530 /* glBindRenderbufferEXT */);
}

static PFNGLBINDRENDERBUFFEROESPROC
epoxy_glBindRenderbufferOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_framebuffer_object, 1552 /* glBindRenderbufferOES */);
}

static PFNGLBINDSAMPLERPROC
epoxy_glBindSampler_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_sampler_objects,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1574 /* "glBindSampler" */,
        1574 /* "glBindSampler" */,
        1574 /* "glBindSampler" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1574 /* "glBindSampler" */,
                                providers, entrypoints);
}

static PFNGLBINDSAMPLERSPROC
epoxy_glBindSamplers_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_4,
        GL_extension_GL_ARB_multi_bind,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1588 /* "glBindSamplers" */,
        1588 /* "glBindSamplers" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1588 /* "glBindSamplers" */,
                                providers, entrypoints);
}

static PFNGLBINDTEXGENPARAMETEREXTPROC
epoxy_glBindTexGenParameterEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 1603 /* glBindTexGenParameterEXT */);
}

static PFNGLBINDTEXTUREPROC
epoxy_glBindTexture_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_1,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_texture_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1628 /* "glBindTexture" */,
        1628 /* "glBindTexture" */,
        1628 /* "glBindTexture" */,
        1642 /* "glBindTextureEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1628 /* "glBindTexture" */,
                                providers, entrypoints);
}

static PFNGLBINDTEXTUREEXTPROC
epoxy_glBindTextureEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_texture_object,
        Desktop_OpenGL_1_1,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1642 /* "glBindTextureEXT" */,
        1628 /* "glBindTexture" */,
        1628 /* "glBindTexture" */,
        1628 /* "glBindTexture" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1642 /* "glBindTextureEXT" */,
                                providers, entrypoints);
}

static PFNGLBINDTEXTUREUNITPROC
epoxy_glBindTextureUnit_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1659 /* "glBindTextureUnit" */,
        1659 /* "glBindTextureUnit" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1659 /* "glBindTextureUnit" */,
                                providers, entrypoints);
}

static PFNGLBINDTEXTUREUNITPARAMETEREXTPROC
epoxy_glBindTextureUnitParameterEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 1677 /* glBindTextureUnitParameterEXT */);
}

static PFNGLBINDTEXTURESPROC
epoxy_glBindTextures_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_4,
        GL_extension_GL_ARB_multi_bind,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1707 /* "glBindTextures" */,
        1707 /* "glBindTextures" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1707 /* "glBindTextures" */,
                                providers, entrypoints);
}

static PFNGLBINDTRANSFORMFEEDBACKPROC
epoxy_glBindTransformFeedback_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_transform_feedback2,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1722 /* "glBindTransformFeedback" */,
        1722 /* "glBindTransformFeedback" */,
        1722 /* "glBindTransformFeedback" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1722 /* "glBindTransformFeedback" */,
                                providers, entrypoints);
}

static PFNGLBINDTRANSFORMFEEDBACKNVPROC
epoxy_glBindTransformFeedbackNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_transform_feedback2, 1746 /* glBindTransformFeedbackNV */);
}

static PFNGLBINDVERTEXARRAYPROC
epoxy_glBindVertexArray_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_vertex_array_object,
        OpenGL_ES_3_0,
        GL_extension_GL_APPLE_vertex_array_object,
        GL_extension_GL_OES_vertex_array_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1772 /* "glBindVertexArray" */,
        1772 /* "glBindVertexArray" */,
        1772 /* "glBindVertexArray" */,
        1790 /* "glBindVertexArrayAPPLE" */,
        1813 /* "glBindVertexArrayOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1772 /* "glBindVertexArray" */,
                                providers, entrypoints);
}

static PFNGLBINDVERTEXARRAYAPPLEPROC
epoxy_glBindVertexArrayAPPLE_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_APPLE_vertex_array_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_vertex_array_object,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1790 /* "glBindVertexArrayAPPLE" */,
        1772 /* "glBindVertexArray" */,
        1772 /* "glBindVertexArray" */,
        1772 /* "glBindVertexArray" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1790 /* "glBindVertexArrayAPPLE" */,
                                providers, entrypoints);
}

static PFNGLBINDVERTEXARRAYOESPROC
epoxy_glBindVertexArrayOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_vertex_array_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_vertex_array_object,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1813 /* "glBindVertexArrayOES" */,
        1772 /* "glBindVertexArray" */,
        1772 /* "glBindVertexArray" */,
        1772 /* "glBindVertexArray" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1813 /* "glBindVertexArrayOES" */,
                                providers, entrypoints);
}

static PFNGLBINDVERTEXBUFFERPROC
epoxy_glBindVertexBuffer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_vertex_attrib_binding,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1834 /* "glBindVertexBuffer" */,
        1834 /* "glBindVertexBuffer" */,
        1834 /* "glBindVertexBuffer" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1834 /* "glBindVertexBuffer" */,
                                providers, entrypoints);
}

static PFNGLBINDVERTEXBUFFERSPROC
epoxy_glBindVertexBuffers_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_4,
        GL_extension_GL_ARB_multi_bind,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        1853 /* "glBindVertexBuffers" */,
        1853 /* "glBindVertexBuffers" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1853 /* "glBindVertexBuffers" */,
                                providers, entrypoints);
}

static PFNGLBINDVERTEXSHADEREXTPROC
epoxy_glBindVertexShaderEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 1873 /* glBindVertexShaderEXT */);
}

static PFNGLBINDVIDEOCAPTURESTREAMBUFFERNVPROC
epoxy_glBindVideoCaptureStreamBufferNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_video_capture, 1895 /* glBindVideoCaptureStreamBufferNV */);
}

static PFNGLBINDVIDEOCAPTURESTREAMTEXTURENVPROC
epoxy_glBindVideoCaptureStreamTextureNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_video_capture, 1928 /* glBindVideoCaptureStreamTextureNV */);
}

static PFNGLBINORMAL3BEXTPROC
epoxy_glBinormal3bEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_coordinate_frame, 1962 /* glBinormal3bEXT */);
}

static PFNGLBINORMAL3BVEXTPROC
epoxy_glBinormal3bvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_coordinate_frame, 1978 /* glBinormal3bvEXT */);
}

static PFNGLBINORMAL3DEXTPROC
epoxy_glBinormal3dEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_coordinate_frame, 1995 /* glBinormal3dEXT */);
}

static PFNGLBINORMAL3DVEXTPROC
epoxy_glBinormal3dvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_coordinate_frame, 2011 /* glBinormal3dvEXT */);
}

static PFNGLBINORMAL3FEXTPROC
epoxy_glBinormal3fEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_coordinate_frame, 2028 /* glBinormal3fEXT */);
}

static PFNGLBINORMAL3FVEXTPROC
epoxy_glBinormal3fvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_coordinate_frame, 2044 /* glBinormal3fvEXT */);
}

static PFNGLBINORMAL3IEXTPROC
epoxy_glBinormal3iEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_coordinate_frame, 2061 /* glBinormal3iEXT */);
}

static PFNGLBINORMAL3IVEXTPROC
epoxy_glBinormal3ivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_coordinate_frame, 2077 /* glBinormal3ivEXT */);
}

static PFNGLBINORMAL3SEXTPROC
epoxy_glBinormal3sEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_coordinate_frame, 2094 /* glBinormal3sEXT */);
}

static PFNGLBINORMAL3SVEXTPROC
epoxy_glBinormal3svEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_coordinate_frame, 2110 /* glBinormal3svEXT */);
}

static PFNGLBINORMALPOINTEREXTPROC
epoxy_glBinormalPointerEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_coordinate_frame, 2127 /* glBinormalPointerEXT */);
}

static PFNGLBITMAPPROC
epoxy_glBitmap_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 2148 /* glBitmap */);
}

static PFNGLBITMAPXOESPROC
epoxy_glBitmapxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 2157 /* glBitmapxOES */);
}

static PFNGLBLENDBARRIERKHRPROC
epoxy_glBlendBarrierKHR_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_KHR_blend_equation_advanced, 2170 /* glBlendBarrierKHR */);
}

static PFNGLBLENDBARRIERNVPROC
epoxy_glBlendBarrierNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_blend_equation_advanced, 2188 /* glBlendBarrierNV */);
}

static PFNGLBLENDCOLORPROC
epoxy_glBlendColor_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_4,
        GL_extension_GL_ARB_imaging,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_blend_color,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2205 /* "glBlendColor" */,
        2205 /* "glBlendColor" */,
        2205 /* "glBlendColor" */,
        2218 /* "glBlendColorEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2205 /* "glBlendColor" */,
                                providers, entrypoints);
}

static PFNGLBLENDCOLOREXTPROC
epoxy_glBlendColorEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_blend_color,
        Desktop_OpenGL_1_4,
        GL_extension_GL_ARB_imaging,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2218 /* "glBlendColorEXT" */,
        2205 /* "glBlendColor" */,
        2205 /* "glBlendColor" */,
        2205 /* "glBlendColor" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2218 /* "glBlendColorEXT" */,
                                providers, entrypoints);
}

static PFNGLBLENDCOLORXOESPROC
epoxy_glBlendColorxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 2234 /* glBlendColorxOES */);
}

static PFNGLBLENDEQUATIONPROC
epoxy_glBlendEquation_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_4,
        GL_extension_GL_ARB_imaging,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_blend_minmax,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2251 /* "glBlendEquation" */,
        2251 /* "glBlendEquation" */,
        2251 /* "glBlendEquation" */,
        2267 /* "glBlendEquationEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2251 /* "glBlendEquation" */,
                                providers, entrypoints);
}

static PFNGLBLENDEQUATIONEXTPROC
epoxy_glBlendEquationEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_blend_minmax,
        Desktop_OpenGL_1_4,
        GL_extension_GL_ARB_imaging,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2267 /* "glBlendEquationEXT" */,
        2251 /* "glBlendEquation" */,
        2251 /* "glBlendEquation" */,
        2251 /* "glBlendEquation" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2267 /* "glBlendEquationEXT" */,
                                providers, entrypoints);
}

static PFNGLBLENDEQUATIONINDEXEDAMDPROC
epoxy_glBlendEquationIndexedAMD_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_AMD_draw_buffers_blend,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2286 /* "glBlendEquationIndexedAMD" */,
        2552 /* "glBlendEquationi" */,
        2569 /* "glBlendEquationiARB" */,
        2589 /* "glBlendEquationiEXT" */,
        2609 /* "glBlendEquationiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2286 /* "glBlendEquationIndexedAMD" */,
                                providers, entrypoints);
}

static PFNGLBLENDEQUATIONOESPROC
epoxy_glBlendEquationOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_blend_subtract, 2312 /* glBlendEquationOES */);
}

static PFNGLBLENDEQUATIONSEPARATEPROC
epoxy_glBlendEquationSeparate_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_blend_equation_separate,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2331 /* "glBlendEquationSeparate" */,
        2331 /* "glBlendEquationSeparate" */,
        2355 /* "glBlendEquationSeparateEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2331 /* "glBlendEquationSeparate" */,
                                providers, entrypoints);
}

static PFNGLBLENDEQUATIONSEPARATEEXTPROC
epoxy_glBlendEquationSeparateEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_blend_equation_separate,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2355 /* "glBlendEquationSeparateEXT" */,
        2331 /* "glBlendEquationSeparate" */,
        2331 /* "glBlendEquationSeparate" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2355 /* "glBlendEquationSeparateEXT" */,
                                providers, entrypoints);
}

static PFNGLBLENDEQUATIONSEPARATEINDEXEDAMDPROC
epoxy_glBlendEquationSeparateIndexedAMD_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_AMD_draw_buffers_blend,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2382 /* "glBlendEquationSeparateIndexedAMD" */,
        2443 /* "glBlendEquationSeparatei" */,
        2468 /* "glBlendEquationSeparateiARB" */,
        2496 /* "glBlendEquationSeparateiEXT" */,
        2524 /* "glBlendEquationSeparateiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2382 /* "glBlendEquationSeparateIndexedAMD" */,
                                providers, entrypoints);
}

static PFNGLBLENDEQUATIONSEPARATEOESPROC
epoxy_glBlendEquationSeparateOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_blend_equation_separate, 2416 /* glBlendEquationSeparateOES */);
}

static PFNGLBLENDEQUATIONSEPARATEIPROC
epoxy_glBlendEquationSeparatei_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_AMD_draw_buffers_blend,
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2443 /* "glBlendEquationSeparatei" */,
        2382 /* "glBlendEquationSeparateIndexedAMD" */,
        2468 /* "glBlendEquationSeparateiARB" */,
        2496 /* "glBlendEquationSeparateiEXT" */,
        2524 /* "glBlendEquationSeparateiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2443 /* "glBlendEquationSeparatei" */,
                                providers, entrypoints);
}

static PFNGLBLENDEQUATIONSEPARATEIARBPROC
epoxy_glBlendEquationSeparateiARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_AMD_draw_buffers_blend,
        Desktop_OpenGL_4_0,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2468 /* "glBlendEquationSeparateiARB" */,
        2382 /* "glBlendEquationSeparateIndexedAMD" */,
        2443 /* "glBlendEquationSeparatei" */,
        2496 /* "glBlendEquationSeparateiEXT" */,
        2524 /* "glBlendEquationSeparateiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2468 /* "glBlendEquationSeparateiARB" */,
                                providers, entrypoints);
}

static PFNGLBLENDEQUATIONSEPARATEIEXTPROC
epoxy_glBlendEquationSeparateiEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_AMD_draw_buffers_blend,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2496 /* "glBlendEquationSeparateiEXT" */,
        2382 /* "glBlendEquationSeparateIndexedAMD" */,
        2443 /* "glBlendEquationSeparatei" */,
        2468 /* "glBlendEquationSeparateiARB" */,
        2524 /* "glBlendEquationSeparateiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2496 /* "glBlendEquationSeparateiEXT" */,
                                providers, entrypoints);
}

static PFNGLBLENDEQUATIONSEPARATEIOESPROC
epoxy_glBlendEquationSeparateiOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_draw_buffers_indexed,
        GL_extension_GL_AMD_draw_buffers_blend,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_EXT_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2524 /* "glBlendEquationSeparateiOES" */,
        2382 /* "glBlendEquationSeparateIndexedAMD" */,
        2443 /* "glBlendEquationSeparatei" */,
        2468 /* "glBlendEquationSeparateiARB" */,
        2496 /* "glBlendEquationSeparateiEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2524 /* "glBlendEquationSeparateiOES" */,
                                providers, entrypoints);
}

static PFNGLBLENDEQUATIONIPROC
epoxy_glBlendEquationi_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_AMD_draw_buffers_blend,
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2552 /* "glBlendEquationi" */,
        2286 /* "glBlendEquationIndexedAMD" */,
        2569 /* "glBlendEquationiARB" */,
        2589 /* "glBlendEquationiEXT" */,
        2609 /* "glBlendEquationiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2552 /* "glBlendEquationi" */,
                                providers, entrypoints);
}

static PFNGLBLENDEQUATIONIARBPROC
epoxy_glBlendEquationiARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_AMD_draw_buffers_blend,
        Desktop_OpenGL_4_0,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2569 /* "glBlendEquationiARB" */,
        2286 /* "glBlendEquationIndexedAMD" */,
        2552 /* "glBlendEquationi" */,
        2589 /* "glBlendEquationiEXT" */,
        2609 /* "glBlendEquationiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2569 /* "glBlendEquationiARB" */,
                                providers, entrypoints);
}

static PFNGLBLENDEQUATIONIEXTPROC
epoxy_glBlendEquationiEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_AMD_draw_buffers_blend,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2589 /* "glBlendEquationiEXT" */,
        2286 /* "glBlendEquationIndexedAMD" */,
        2552 /* "glBlendEquationi" */,
        2569 /* "glBlendEquationiARB" */,
        2609 /* "glBlendEquationiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2589 /* "glBlendEquationiEXT" */,
                                providers, entrypoints);
}

static PFNGLBLENDEQUATIONIOESPROC
epoxy_glBlendEquationiOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_draw_buffers_indexed,
        GL_extension_GL_AMD_draw_buffers_blend,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_EXT_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2609 /* "glBlendEquationiOES" */,
        2286 /* "glBlendEquationIndexedAMD" */,
        2552 /* "glBlendEquationi" */,
        2569 /* "glBlendEquationiARB" */,
        2589 /* "glBlendEquationiEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2609 /* "glBlendEquationiOES" */,
                                providers, entrypoints);
}

static PFNGLBLENDFUNCPROC
epoxy_glBlendFunc_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2629 /* "glBlendFunc" */,
        2629 /* "glBlendFunc" */,
        2629 /* "glBlendFunc" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2629 /* "glBlendFunc" */,
                                providers, entrypoints);
}

static PFNGLBLENDFUNCINDEXEDAMDPROC
epoxy_glBlendFuncIndexedAMD_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_AMD_draw_buffers_blend,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2641 /* "glBlendFuncIndexedAMD" */,
        2876 /* "glBlendFunci" */,
        2889 /* "glBlendFunciARB" */,
        2905 /* "glBlendFunciEXT" */,
        2921 /* "glBlendFunciOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2641 /* "glBlendFuncIndexedAMD" */,
                                providers, entrypoints);
}

static PFNGLBLENDFUNCSEPARATEPROC
epoxy_glBlendFuncSeparate_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_4,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_blend_func_separate,
        GL_extension_GL_INGR_blend_func_separate,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2663 /* "glBlendFuncSeparate" */,
        2663 /* "glBlendFuncSeparate" */,
        2683 /* "glBlendFuncSeparateEXT" */,
        2706 /* "glBlendFuncSeparateINGR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2663 /* "glBlendFuncSeparate" */,
                                providers, entrypoints);
}

static PFNGLBLENDFUNCSEPARATEEXTPROC
epoxy_glBlendFuncSeparateEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_blend_func_separate,
        Desktop_OpenGL_1_4,
        OpenGL_ES_2_0,
        GL_extension_GL_INGR_blend_func_separate,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2683 /* "glBlendFuncSeparateEXT" */,
        2663 /* "glBlendFuncSeparate" */,
        2663 /* "glBlendFuncSeparate" */,
        2706 /* "glBlendFuncSeparateINGR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2683 /* "glBlendFuncSeparateEXT" */,
                                providers, entrypoints);
}

static PFNGLBLENDFUNCSEPARATEINGRPROC
epoxy_glBlendFuncSeparateINGR_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_INGR_blend_func_separate,
        Desktop_OpenGL_1_4,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_blend_func_separate,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2706 /* "glBlendFuncSeparateINGR" */,
        2663 /* "glBlendFuncSeparate" */,
        2663 /* "glBlendFuncSeparate" */,
        2683 /* "glBlendFuncSeparateEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2706 /* "glBlendFuncSeparateINGR" */,
                                providers, entrypoints);
}

static PFNGLBLENDFUNCSEPARATEINDEXEDAMDPROC
epoxy_glBlendFuncSeparateIndexedAMD_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_AMD_draw_buffers_blend,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2730 /* "glBlendFuncSeparateIndexedAMD" */,
        2783 /* "glBlendFuncSeparatei" */,
        2804 /* "glBlendFuncSeparateiARB" */,
        2828 /* "glBlendFuncSeparateiEXT" */,
        2852 /* "glBlendFuncSeparateiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2730 /* "glBlendFuncSeparateIndexedAMD" */,
                                providers, entrypoints);
}

static PFNGLBLENDFUNCSEPARATEOESPROC
epoxy_glBlendFuncSeparateOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_blend_func_separate, 2760 /* glBlendFuncSeparateOES */);
}

static PFNGLBLENDFUNCSEPARATEIPROC
epoxy_glBlendFuncSeparatei_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_AMD_draw_buffers_blend,
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2783 /* "glBlendFuncSeparatei" */,
        2730 /* "glBlendFuncSeparateIndexedAMD" */,
        2804 /* "glBlendFuncSeparateiARB" */,
        2828 /* "glBlendFuncSeparateiEXT" */,
        2852 /* "glBlendFuncSeparateiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2783 /* "glBlendFuncSeparatei" */,
                                providers, entrypoints);
}

static PFNGLBLENDFUNCSEPARATEIARBPROC
epoxy_glBlendFuncSeparateiARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_AMD_draw_buffers_blend,
        Desktop_OpenGL_4_0,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2804 /* "glBlendFuncSeparateiARB" */,
        2730 /* "glBlendFuncSeparateIndexedAMD" */,
        2783 /* "glBlendFuncSeparatei" */,
        2828 /* "glBlendFuncSeparateiEXT" */,
        2852 /* "glBlendFuncSeparateiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2804 /* "glBlendFuncSeparateiARB" */,
                                providers, entrypoints);
}

static PFNGLBLENDFUNCSEPARATEIEXTPROC
epoxy_glBlendFuncSeparateiEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_AMD_draw_buffers_blend,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2828 /* "glBlendFuncSeparateiEXT" */,
        2730 /* "glBlendFuncSeparateIndexedAMD" */,
        2783 /* "glBlendFuncSeparatei" */,
        2804 /* "glBlendFuncSeparateiARB" */,
        2852 /* "glBlendFuncSeparateiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2828 /* "glBlendFuncSeparateiEXT" */,
                                providers, entrypoints);
}

static PFNGLBLENDFUNCSEPARATEIOESPROC
epoxy_glBlendFuncSeparateiOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_draw_buffers_indexed,
        GL_extension_GL_AMD_draw_buffers_blend,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_EXT_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2852 /* "glBlendFuncSeparateiOES" */,
        2730 /* "glBlendFuncSeparateIndexedAMD" */,
        2783 /* "glBlendFuncSeparatei" */,
        2804 /* "glBlendFuncSeparateiARB" */,
        2828 /* "glBlendFuncSeparateiEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2852 /* "glBlendFuncSeparateiOES" */,
                                providers, entrypoints);
}

static PFNGLBLENDFUNCIPROC
epoxy_glBlendFunci_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_AMD_draw_buffers_blend,
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2876 /* "glBlendFunci" */,
        2641 /* "glBlendFuncIndexedAMD" */,
        2889 /* "glBlendFunciARB" */,
        2905 /* "glBlendFunciEXT" */,
        2921 /* "glBlendFunciOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2876 /* "glBlendFunci" */,
                                providers, entrypoints);
}

static PFNGLBLENDFUNCIARBPROC
epoxy_glBlendFunciARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_AMD_draw_buffers_blend,
        Desktop_OpenGL_4_0,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2889 /* "glBlendFunciARB" */,
        2641 /* "glBlendFuncIndexedAMD" */,
        2876 /* "glBlendFunci" */,
        2905 /* "glBlendFunciEXT" */,
        2921 /* "glBlendFunciOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2889 /* "glBlendFunciARB" */,
                                providers, entrypoints);
}

static PFNGLBLENDFUNCIEXTPROC
epoxy_glBlendFunciEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_AMD_draw_buffers_blend,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2905 /* "glBlendFunciEXT" */,
        2641 /* "glBlendFuncIndexedAMD" */,
        2876 /* "glBlendFunci" */,
        2889 /* "glBlendFunciARB" */,
        2921 /* "glBlendFunciOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2905 /* "glBlendFunciEXT" */,
                                providers, entrypoints);
}

static PFNGLBLENDFUNCIOESPROC
epoxy_glBlendFunciOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_draw_buffers_indexed,
        GL_extension_GL_AMD_draw_buffers_blend,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_draw_buffers_blend,
        GL_extension_GL_EXT_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2921 /* "glBlendFunciOES" */,
        2641 /* "glBlendFuncIndexedAMD" */,
        2876 /* "glBlendFunci" */,
        2889 /* "glBlendFunciARB" */,
        2905 /* "glBlendFunciEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2921 /* "glBlendFunciOES" */,
                                providers, entrypoints);
}

static PFNGLBLENDPARAMETERINVPROC
epoxy_glBlendParameteriNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_blend_equation_advanced, 2937 /* glBlendParameteriNV */);
}

static PFNGLBLITFRAMEBUFFERPROC
epoxy_glBlitFramebuffer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_framebuffer_blit,
        GL_extension_GL_NV_framebuffer_blit,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2957 /* "glBlitFramebuffer" */,
        2957 /* "glBlitFramebuffer" */,
        2957 /* "glBlitFramebuffer" */,
        2998 /* "glBlitFramebufferEXT" */,
        3019 /* "glBlitFramebufferNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2957 /* "glBlitFramebuffer" */,
                                providers, entrypoints);
}

static PFNGLBLITFRAMEBUFFERANGLEPROC
epoxy_glBlitFramebufferANGLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ANGLE_framebuffer_blit, 2975 /* glBlitFramebufferANGLE */);
}

static PFNGLBLITFRAMEBUFFEREXTPROC
epoxy_glBlitFramebufferEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_blit,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_NV_framebuffer_blit,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        2998 /* "glBlitFramebufferEXT" */,
        2957 /* "glBlitFramebuffer" */,
        2957 /* "glBlitFramebuffer" */,
        2957 /* "glBlitFramebuffer" */,
        3019 /* "glBlitFramebufferNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 2998 /* "glBlitFramebufferEXT" */,
                                providers, entrypoints);
}

static PFNGLBLITFRAMEBUFFERNVPROC
epoxy_glBlitFramebufferNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_framebuffer_blit,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_framebuffer_blit,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3019 /* "glBlitFramebufferNV" */,
        2957 /* "glBlitFramebuffer" */,
        2957 /* "glBlitFramebuffer" */,
        2957 /* "glBlitFramebuffer" */,
        2998 /* "glBlitFramebufferEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3019 /* "glBlitFramebufferNV" */,
                                providers, entrypoints);
}

static PFNGLBLITNAMEDFRAMEBUFFERPROC
epoxy_glBlitNamedFramebuffer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3039 /* "glBlitNamedFramebuffer" */,
        3039 /* "glBlitNamedFramebuffer" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3039 /* "glBlitNamedFramebuffer" */,
                                providers, entrypoints);
}

static PFNGLBUFFERADDRESSRANGENVPROC
epoxy_glBufferAddressRangeNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_buffer_unified_memory, 3062 /* glBufferAddressRangeNV */);
}

static PFNGLBUFFERDATAPROC
epoxy_glBufferData_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_buffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3085 /* "glBufferData" */,
        3085 /* "glBufferData" */,
        3085 /* "glBufferData" */,
        3098 /* "glBufferDataARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3085 /* "glBufferData" */,
                                providers, entrypoints);
}

static PFNGLBUFFERDATAARBPROC
epoxy_glBufferDataARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_buffer_object,
        Desktop_OpenGL_1_5,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3098 /* "glBufferDataARB" */,
        3085 /* "glBufferData" */,
        3085 /* "glBufferData" */,
        3085 /* "glBufferData" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3098 /* "glBufferDataARB" */,
                                providers, entrypoints);
}

static PFNGLBUFFERPAGECOMMITMENTARBPROC
epoxy_glBufferPageCommitmentARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_sparse_buffer, 3114 /* glBufferPageCommitmentARB */);
}

static PFNGLBUFFERPARAMETERIAPPLEPROC
epoxy_glBufferParameteriAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_flush_buffer_range, 3140 /* glBufferParameteriAPPLE */);
}

static PFNGLBUFFERSTORAGEPROC
epoxy_glBufferStorage_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_4,
        GL_extension_GL_ARB_buffer_storage,
        GL_extension_GL_EXT_buffer_storage,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3164 /* "glBufferStorage" */,
        3164 /* "glBufferStorage" */,
        3180 /* "glBufferStorageEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3164 /* "glBufferStorage" */,
                                providers, entrypoints);
}

static PFNGLBUFFERSTORAGEEXTPROC
epoxy_glBufferStorageEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_buffer_storage,
        Desktop_OpenGL_4_4,
        GL_extension_GL_ARB_buffer_storage,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3180 /* "glBufferStorageEXT" */,
        3164 /* "glBufferStorage" */,
        3164 /* "glBufferStorage" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3180 /* "glBufferStorageEXT" */,
                                providers, entrypoints);
}

static PFNGLBUFFERSUBDATAPROC
epoxy_glBufferSubData_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_buffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3199 /* "glBufferSubData" */,
        3199 /* "glBufferSubData" */,
        3199 /* "glBufferSubData" */,
        3215 /* "glBufferSubDataARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3199 /* "glBufferSubData" */,
                                providers, entrypoints);
}

static PFNGLBUFFERSUBDATAARBPROC
epoxy_glBufferSubDataARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_buffer_object,
        Desktop_OpenGL_1_5,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3215 /* "glBufferSubDataARB" */,
        3199 /* "glBufferSubData" */,
        3199 /* "glBufferSubData" */,
        3199 /* "glBufferSubData" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3215 /* "glBufferSubDataARB" */,
                                providers, entrypoints);
}

static PFNGLCALLCOMMANDLISTNVPROC
epoxy_glCallCommandListNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_command_list, 3234 /* glCallCommandListNV */);
}

static PFNGLCALLLISTPROC
epoxy_glCallList_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 3254 /* glCallList */);
}

static PFNGLCALLLISTSPROC
epoxy_glCallLists_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 3265 /* glCallLists */);
}

static PFNGLCHECKFRAMEBUFFERSTATUSPROC
epoxy_glCheckFramebufferStatus_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_framebuffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3277 /* "glCheckFramebufferStatus" */,
        3277 /* "glCheckFramebufferStatus" */,
        3277 /* "glCheckFramebufferStatus" */,
        3302 /* "glCheckFramebufferStatusEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3277 /* "glCheckFramebufferStatus" */,
                                providers, entrypoints);
}

static PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC
epoxy_glCheckFramebufferStatusEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3302 /* "glCheckFramebufferStatusEXT" */,
        3277 /* "glCheckFramebufferStatus" */,
        3277 /* "glCheckFramebufferStatus" */,
        3277 /* "glCheckFramebufferStatus" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3302 /* "glCheckFramebufferStatusEXT" */,
                                providers, entrypoints);
}

static PFNGLCHECKFRAMEBUFFERSTATUSOESPROC
epoxy_glCheckFramebufferStatusOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_framebuffer_object, 3330 /* glCheckFramebufferStatusOES */);
}

static PFNGLCHECKNAMEDFRAMEBUFFERSTATUSPROC
epoxy_glCheckNamedFramebufferStatus_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3358 /* "glCheckNamedFramebufferStatus" */,
        3358 /* "glCheckNamedFramebufferStatus" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3358 /* "glCheckNamedFramebufferStatus" */,
                                providers, entrypoints);
}

static PFNGLCHECKNAMEDFRAMEBUFFERSTATUSEXTPROC
epoxy_glCheckNamedFramebufferStatusEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 3388 /* glCheckNamedFramebufferStatusEXT */);
}

static PFNGLCLAMPCOLORPROC
epoxy_glClampColor_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_color_buffer_float,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3421 /* "glClampColor" */,
        3434 /* "glClampColorARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3421 /* "glClampColor" */,
                                providers, entrypoints);
}

static PFNGLCLAMPCOLORARBPROC
epoxy_glClampColorARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_color_buffer_float,
        Desktop_OpenGL_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3434 /* "glClampColorARB" */,
        3421 /* "glClampColor" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3434 /* "glClampColorARB" */,
                                providers, entrypoints);
}

static PFNGLCLEARPROC
epoxy_glClear_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3450 /* "glClear" */,
        3450 /* "glClear" */,
        3450 /* "glClear" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3450 /* "glClear" */,
                                providers, entrypoints);
}

static PFNGLCLEARACCUMPROC
epoxy_glClearAccum_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 3458 /* glClearAccum */);
}

static PFNGLCLEARACCUMXOESPROC
epoxy_glClearAccumxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 3471 /* glClearAccumxOES */);
}

static PFNGLCLEARBUFFERDATAPROC
epoxy_glClearBufferData_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_clear_buffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3488 /* "glClearBufferData" */,
        3488 /* "glClearBufferData" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3488 /* "glClearBufferData" */,
                                providers, entrypoints);
}

static PFNGLCLEARBUFFERSUBDATAPROC
epoxy_glClearBufferSubData_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_clear_buffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3506 /* "glClearBufferSubData" */,
        3506 /* "glClearBufferSubData" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3506 /* "glClearBufferSubData" */,
                                providers, entrypoints);
}

static PFNGLCLEARBUFFERFIPROC
epoxy_glClearBufferfi_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3527 /* "glClearBufferfi" */,
        3527 /* "glClearBufferfi" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3527 /* "glClearBufferfi" */,
                                providers, entrypoints);
}

static PFNGLCLEARBUFFERFVPROC
epoxy_glClearBufferfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3543 /* "glClearBufferfv" */,
        3543 /* "glClearBufferfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3543 /* "glClearBufferfv" */,
                                providers, entrypoints);
}

static PFNGLCLEARBUFFERIVPROC
epoxy_glClearBufferiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3559 /* "glClearBufferiv" */,
        3559 /* "glClearBufferiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3559 /* "glClearBufferiv" */,
                                providers, entrypoints);
}

static PFNGLCLEARBUFFERUIVPROC
epoxy_glClearBufferuiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3575 /* "glClearBufferuiv" */,
        3575 /* "glClearBufferuiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3575 /* "glClearBufferuiv" */,
                                providers, entrypoints);
}

static PFNGLCLEARCOLORPROC
epoxy_glClearColor_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3592 /* "glClearColor" */,
        3592 /* "glClearColor" */,
        3592 /* "glClearColor" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3592 /* "glClearColor" */,
                                providers, entrypoints);
}

static PFNGLCLEARCOLORIIEXTPROC
epoxy_glClearColorIiEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_texture_integer, 3605 /* glClearColorIiEXT */);
}

static PFNGLCLEARCOLORIUIEXTPROC
epoxy_glClearColorIuiEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_texture_integer, 3623 /* glClearColorIuiEXT */);
}

static PFNGLCLEARCOLORXPROC
epoxy_glClearColorx_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 3642 /* glClearColorx */);
}

static PFNGLCLEARCOLORXOESPROC
epoxy_glClearColorxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 3656 /* glClearColorxOES */);
}

static PFNGLCLEARDEPTHPROC
epoxy_glClearDepth_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 3673 /* glClearDepth */);
}

static PFNGLCLEARDEPTHDNVPROC
epoxy_glClearDepthdNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_depth_buffer_float, 3686 /* glClearDepthdNV */);
}

static PFNGLCLEARDEPTHFPROC
epoxy_glClearDepthf_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_ES2_compatibility,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_OES_single_precision,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3702 /* "glClearDepthf" */,
        3702 /* "glClearDepthf" */,
        3702 /* "glClearDepthf" */,
        3702 /* "glClearDepthf" */,
        3716 /* "glClearDepthfOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3702 /* "glClearDepthf" */,
                                providers, entrypoints);
}

static PFNGLCLEARDEPTHFOESPROC
epoxy_glClearDepthfOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_single_precision,
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_ES2_compatibility,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3716 /* "glClearDepthfOES" */,
        3702 /* "glClearDepthf" */,
        3702 /* "glClearDepthf" */,
        3702 /* "glClearDepthf" */,
        3702 /* "glClearDepthf" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3716 /* "glClearDepthfOES" */,
                                providers, entrypoints);
}

static PFNGLCLEARDEPTHXPROC
epoxy_glClearDepthx_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 3733 /* glClearDepthx */);
}

static PFNGLCLEARDEPTHXOESPROC
epoxy_glClearDepthxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 3747 /* glClearDepthxOES */);
}

static PFNGLCLEARINDEXPROC
epoxy_glClearIndex_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 3764 /* glClearIndex */);
}

static PFNGLCLEARNAMEDBUFFERDATAPROC
epoxy_glClearNamedBufferData_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3777 /* "glClearNamedBufferData" */,
        3777 /* "glClearNamedBufferData" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3777 /* "glClearNamedBufferData" */,
                                providers, entrypoints);
}

static PFNGLCLEARNAMEDBUFFERDATAEXTPROC
epoxy_glClearNamedBufferDataEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 3800 /* glClearNamedBufferDataEXT */);
}

static PFNGLCLEARNAMEDBUFFERSUBDATAPROC
epoxy_glClearNamedBufferSubData_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3826 /* "glClearNamedBufferSubData" */,
        3826 /* "glClearNamedBufferSubData" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3826 /* "glClearNamedBufferSubData" */,
                                providers, entrypoints);
}

static PFNGLCLEARNAMEDBUFFERSUBDATAEXTPROC
epoxy_glClearNamedBufferSubDataEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 3852 /* glClearNamedBufferSubDataEXT */);
}

static PFNGLCLEARNAMEDFRAMEBUFFERFIPROC
epoxy_glClearNamedFramebufferfi_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3881 /* "glClearNamedFramebufferfi" */,
        3881 /* "glClearNamedFramebufferfi" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3881 /* "glClearNamedFramebufferfi" */,
                                providers, entrypoints);
}

static PFNGLCLEARNAMEDFRAMEBUFFERFVPROC
epoxy_glClearNamedFramebufferfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3907 /* "glClearNamedFramebufferfv" */,
        3907 /* "glClearNamedFramebufferfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3907 /* "glClearNamedFramebufferfv" */,
                                providers, entrypoints);
}

static PFNGLCLEARNAMEDFRAMEBUFFERIVPROC
epoxy_glClearNamedFramebufferiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3933 /* "glClearNamedFramebufferiv" */,
        3933 /* "glClearNamedFramebufferiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3933 /* "glClearNamedFramebufferiv" */,
                                providers, entrypoints);
}

static PFNGLCLEARNAMEDFRAMEBUFFERUIVPROC
epoxy_glClearNamedFramebufferuiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3959 /* "glClearNamedFramebufferuiv" */,
        3959 /* "glClearNamedFramebufferuiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3959 /* "glClearNamedFramebufferuiv" */,
                                providers, entrypoints);
}

static PFNGLCLEARSTENCILPROC
epoxy_glClearStencil_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        3986 /* "glClearStencil" */,
        3986 /* "glClearStencil" */,
        3986 /* "glClearStencil" */,
    };
    return gl_provider_resolver(entrypoint_strings + 3986 /* "glClearStencil" */,
                                providers, entrypoints);
}

static PFNGLCLEARTEXIMAGEPROC
epoxy_glClearTexImage_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_4,
        GL_extension_GL_ARB_clear_texture,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        4001 /* "glClearTexImage" */,
        4001 /* "glClearTexImage" */,
    };
    return gl_provider_resolver(entrypoint_strings + 4001 /* "glClearTexImage" */,
                                providers, entrypoints);
}

static PFNGLCLEARTEXSUBIMAGEPROC
epoxy_glClearTexSubImage_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_4,
        GL_extension_GL_ARB_clear_texture,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        4017 /* "glClearTexSubImage" */,
        4017 /* "glClearTexSubImage" */,
    };
    return gl_provider_resolver(entrypoint_strings + 4017 /* "glClearTexSubImage" */,
                                providers, entrypoints);
}

static PFNGLCLIENTACTIVETEXTUREPROC
epoxy_glClientActiveTexture_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_3,
        OpenGL_ES_1_0,
        GL_extension_GL_ARB_multitexture,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        4036 /* "glClientActiveTexture" */,
        4036 /* "glClientActiveTexture" */,
        4058 /* "glClientActiveTextureARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 4036 /* "glClientActiveTexture" */,
                                providers, entrypoints);
}

static PFNGLCLIENTACTIVETEXTUREARBPROC
epoxy_glClientActiveTextureARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_multitexture,
        Desktop_OpenGL_1_3,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        4058 /* "glClientActiveTextureARB" */,
        4036 /* "glClientActiveTexture" */,
        4036 /* "glClientActiveTexture" */,
    };
    return gl_provider_resolver(entrypoint_strings + 4058 /* "glClientActiveTextureARB" */,
                                providers, entrypoints);
}

static PFNGLCLIENTACTIVEVERTEXSTREAMATIPROC
epoxy_glClientActiveVertexStreamATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_vertex_streams, 4083 /* glClientActiveVertexStreamATI */);
}

static PFNGLCLIENTATTRIBDEFAULTEXTPROC
epoxy_glClientAttribDefaultEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 4113 /* glClientAttribDefaultEXT */);
}

static PFNGLCLIENTWAITSYNCPROC
epoxy_glClientWaitSync_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_sync,
        OpenGL_ES_3_0,
        GL_extension_GL_APPLE_sync,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        4138 /* "glClientWaitSync" */,
        4138 /* "glClientWaitSync" */,
        4138 /* "glClientWaitSync" */,
        4155 /* "glClientWaitSyncAPPLE" */,
    };
    return gl_provider_resolver(entrypoint_strings + 4138 /* "glClientWaitSync" */,
                                providers, entrypoints);
}

static PFNGLCLIENTWAITSYNCAPPLEPROC
epoxy_glClientWaitSyncAPPLE_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_APPLE_sync,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_sync,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        4155 /* "glClientWaitSyncAPPLE" */,
        4138 /* "glClientWaitSync" */,
        4138 /* "glClientWaitSync" */,
        4138 /* "glClientWaitSync" */,
    };
    return gl_provider_resolver(entrypoint_strings + 4155 /* "glClientWaitSyncAPPLE" */,
                                providers, entrypoints);
}

static PFNGLCLIPCONTROLPROC
epoxy_glClipControl_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_clip_control,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        4177 /* "glClipControl" */,
        4177 /* "glClipControl" */,
    };
    return gl_provider_resolver(entrypoint_strings + 4177 /* "glClipControl" */,
                                providers, entrypoints);
}

static PFNGLCLIPPLANEPROC
epoxy_glClipPlane_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4191 /* glClipPlane */);
}

static PFNGLCLIPPLANEFPROC
epoxy_glClipPlanef_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 4203 /* glClipPlanef */);
}

static PFNGLCLIPPLANEFIMGPROC
epoxy_glClipPlanefIMG_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_IMG_user_clip_plane, 4216 /* glClipPlanefIMG */);
}

static PFNGLCLIPPLANEFOESPROC
epoxy_glClipPlanefOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_single_precision, 4232 /* glClipPlanefOES */);
}

static PFNGLCLIPPLANEXPROC
epoxy_glClipPlanex_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 4248 /* glClipPlanex */);
}

static PFNGLCLIPPLANEXIMGPROC
epoxy_glClipPlanexIMG_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_IMG_user_clip_plane, 4261 /* glClipPlanexIMG */);
}

static PFNGLCLIPPLANEXOESPROC
epoxy_glClipPlanexOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 4277 /* glClipPlanexOES */);
}

static PFNGLCOLOR3BPROC
epoxy_glColor3b_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4293 /* glColor3b */);
}

static PFNGLCOLOR3BVPROC
epoxy_glColor3bv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4303 /* glColor3bv */);
}

static PFNGLCOLOR3DPROC
epoxy_glColor3d_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4314 /* glColor3d */);
}

static PFNGLCOLOR3DVPROC
epoxy_glColor3dv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4324 /* glColor3dv */);
}

static PFNGLCOLOR3FPROC
epoxy_glColor3f_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4335 /* glColor3f */);
}

static PFNGLCOLOR3FVERTEX3FSUNPROC
epoxy_glColor3fVertex3fSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_vertex, 4345 /* glColor3fVertex3fSUN */);
}

static PFNGLCOLOR3FVERTEX3FVSUNPROC
epoxy_glColor3fVertex3fvSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_vertex, 4366 /* glColor3fVertex3fvSUN */);
}

static PFNGLCOLOR3FVPROC
epoxy_glColor3fv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4388 /* glColor3fv */);
}

static PFNGLCOLOR3HNVPROC
epoxy_glColor3hNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_half_float, 4399 /* glColor3hNV */);
}

static PFNGLCOLOR3HVNVPROC
epoxy_glColor3hvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_half_float, 4411 /* glColor3hvNV */);
}

static PFNGLCOLOR3IPROC
epoxy_glColor3i_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4424 /* glColor3i */);
}

static PFNGLCOLOR3IVPROC
epoxy_glColor3iv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4434 /* glColor3iv */);
}

static PFNGLCOLOR3SPROC
epoxy_glColor3s_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4445 /* glColor3s */);
}

static PFNGLCOLOR3SVPROC
epoxy_glColor3sv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4455 /* glColor3sv */);
}

static PFNGLCOLOR3UBPROC
epoxy_glColor3ub_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4466 /* glColor3ub */);
}

static PFNGLCOLOR3UBVPROC
epoxy_glColor3ubv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4477 /* glColor3ubv */);
}

static PFNGLCOLOR3UIPROC
epoxy_glColor3ui_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4489 /* glColor3ui */);
}

static PFNGLCOLOR3UIVPROC
epoxy_glColor3uiv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4500 /* glColor3uiv */);
}

static PFNGLCOLOR3USPROC
epoxy_glColor3us_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4512 /* glColor3us */);
}

static PFNGLCOLOR3USVPROC
epoxy_glColor3usv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4523 /* glColor3usv */);
}

static PFNGLCOLOR3XOESPROC
epoxy_glColor3xOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 4535 /* glColor3xOES */);
}

static PFNGLCOLOR3XVOESPROC
epoxy_glColor3xvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 4548 /* glColor3xvOES */);
}

static PFNGLCOLOR4BPROC
epoxy_glColor4b_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4562 /* glColor4b */);
}

static PFNGLCOLOR4BVPROC
epoxy_glColor4bv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4572 /* glColor4bv */);
}

static PFNGLCOLOR4DPROC
epoxy_glColor4d_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4583 /* glColor4d */);
}

static PFNGLCOLOR4DVPROC
epoxy_glColor4dv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4593 /* glColor4dv */);
}

static PFNGLCOLOR4FPROC
epoxy_glColor4f_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        4604 /* "glColor4f" */,
        4604 /* "glColor4f" */,
    };
    return gl_provider_resolver(entrypoint_strings + 4604 /* "glColor4f" */,
                                providers, entrypoints);
}

static PFNGLCOLOR4FNORMAL3FVERTEX3FSUNPROC
epoxy_glColor4fNormal3fVertex3fSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_vertex, 4614 /* glColor4fNormal3fVertex3fSUN */);
}

static PFNGLCOLOR4FNORMAL3FVERTEX3FVSUNPROC
epoxy_glColor4fNormal3fVertex3fvSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_vertex, 4643 /* glColor4fNormal3fVertex3fvSUN */);
}

static PFNGLCOLOR4FVPROC
epoxy_glColor4fv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4673 /* glColor4fv */);
}

static PFNGLCOLOR4HNVPROC
epoxy_glColor4hNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_half_float, 4684 /* glColor4hNV */);
}

static PFNGLCOLOR4HVNVPROC
epoxy_glColor4hvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_half_float, 4696 /* glColor4hvNV */);
}

static PFNGLCOLOR4IPROC
epoxy_glColor4i_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4709 /* glColor4i */);
}

static PFNGLCOLOR4IVPROC
epoxy_glColor4iv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4719 /* glColor4iv */);
}

static PFNGLCOLOR4SPROC
epoxy_glColor4s_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4730 /* glColor4s */);
}

static PFNGLCOLOR4SVPROC
epoxy_glColor4sv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4740 /* glColor4sv */);
}

static PFNGLCOLOR4UBPROC
epoxy_glColor4ub_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        4751 /* "glColor4ub" */,
        4751 /* "glColor4ub" */,
    };
    return gl_provider_resolver(entrypoint_strings + 4751 /* "glColor4ub" */,
                                providers, entrypoints);
}

static PFNGLCOLOR4UBVERTEX2FSUNPROC
epoxy_glColor4ubVertex2fSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_vertex, 4762 /* glColor4ubVertex2fSUN */);
}

static PFNGLCOLOR4UBVERTEX2FVSUNPROC
epoxy_glColor4ubVertex2fvSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_vertex, 4784 /* glColor4ubVertex2fvSUN */);
}

static PFNGLCOLOR4UBVERTEX3FSUNPROC
epoxy_glColor4ubVertex3fSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_vertex, 4807 /* glColor4ubVertex3fSUN */);
}

static PFNGLCOLOR4UBVERTEX3FVSUNPROC
epoxy_glColor4ubVertex3fvSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_vertex, 4829 /* glColor4ubVertex3fvSUN */);
}

static PFNGLCOLOR4UBVPROC
epoxy_glColor4ubv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4852 /* glColor4ubv */);
}

static PFNGLCOLOR4UIPROC
epoxy_glColor4ui_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4864 /* glColor4ui */);
}

static PFNGLCOLOR4UIVPROC
epoxy_glColor4uiv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4875 /* glColor4uiv */);
}

static PFNGLCOLOR4USPROC
epoxy_glColor4us_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4887 /* glColor4us */);
}

static PFNGLCOLOR4USVPROC
epoxy_glColor4usv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 4898 /* glColor4usv */);
}

static PFNGLCOLOR4XPROC
epoxy_glColor4x_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 4910 /* glColor4x */);
}

static PFNGLCOLOR4XOESPROC
epoxy_glColor4xOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 4920 /* glColor4xOES */);
}

static PFNGLCOLOR4XVOESPROC
epoxy_glColor4xvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 4933 /* glColor4xvOES */);
}

static PFNGLCOLORFORMATNVPROC
epoxy_glColorFormatNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_buffer_unified_memory, 4947 /* glColorFormatNV */);
}

static PFNGLCOLORFRAGMENTOP1ATIPROC
epoxy_glColorFragmentOp1ATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_fragment_shader, 4963 /* glColorFragmentOp1ATI */);
}

static PFNGLCOLORFRAGMENTOP2ATIPROC
epoxy_glColorFragmentOp2ATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_fragment_shader, 4985 /* glColorFragmentOp2ATI */);
}

static PFNGLCOLORFRAGMENTOP3ATIPROC
epoxy_glColorFragmentOp3ATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_fragment_shader, 5007 /* glColorFragmentOp3ATI */);
}

static PFNGLCOLORMASKPROC
epoxy_glColorMask_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5029 /* "glColorMask" */,
        5029 /* "glColorMask" */,
        5029 /* "glColorMask" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5029 /* "glColorMask" */,
                                providers, entrypoints);
}

static PFNGLCOLORMASKINDEXEDEXTPROC
epoxy_glColorMaskIndexedEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5041 /* "glColorMaskIndexedEXT" */,
        5063 /* "glColorMaski" */,
        5076 /* "glColorMaskiEXT" */,
        5092 /* "glColorMaskiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5041 /* "glColorMaskIndexedEXT" */,
                                providers, entrypoints);
}

static PFNGLCOLORMASKIPROC
epoxy_glColorMaski_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_draw_buffers2,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5063 /* "glColorMaski" */,
        5041 /* "glColorMaskIndexedEXT" */,
        5076 /* "glColorMaskiEXT" */,
        5092 /* "glColorMaskiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5063 /* "glColorMaski" */,
                                providers, entrypoints);
}

static PFNGLCOLORMASKIEXTPROC
epoxy_glColorMaskiEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5076 /* "glColorMaskiEXT" */,
        5041 /* "glColorMaskIndexedEXT" */,
        5063 /* "glColorMaski" */,
        5092 /* "glColorMaskiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5076 /* "glColorMaskiEXT" */,
                                providers, entrypoints);
}

static PFNGLCOLORMASKIOESPROC
epoxy_glColorMaskiOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_draw_buffers_indexed,
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5092 /* "glColorMaskiOES" */,
        5041 /* "glColorMaskIndexedEXT" */,
        5063 /* "glColorMaski" */,
        5076 /* "glColorMaskiEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5092 /* "glColorMaskiOES" */,
                                providers, entrypoints);
}

static PFNGLCOLORMATERIALPROC
epoxy_glColorMaterial_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 5108 /* glColorMaterial */);
}

static PFNGLCOLORP3UIPROC
epoxy_glColorP3ui_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_vertex_type_2_10_10_10_rev,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5124 /* "glColorP3ui" */,
        5124 /* "glColorP3ui" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5124 /* "glColorP3ui" */,
                                providers, entrypoints);
}

static PFNGLCOLORP3UIVPROC
epoxy_glColorP3uiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_vertex_type_2_10_10_10_rev,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5136 /* "glColorP3uiv" */,
        5136 /* "glColorP3uiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5136 /* "glColorP3uiv" */,
                                providers, entrypoints);
}

static PFNGLCOLORP4UIPROC
epoxy_glColorP4ui_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_vertex_type_2_10_10_10_rev,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5149 /* "glColorP4ui" */,
        5149 /* "glColorP4ui" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5149 /* "glColorP4ui" */,
                                providers, entrypoints);
}

static PFNGLCOLORP4UIVPROC
epoxy_glColorP4uiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_vertex_type_2_10_10_10_rev,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5161 /* "glColorP4uiv" */,
        5161 /* "glColorP4uiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5161 /* "glColorP4uiv" */,
                                providers, entrypoints);
}

static PFNGLCOLORPOINTERPROC
epoxy_glColorPointer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_1,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5174 /* "glColorPointer" */,
        5174 /* "glColorPointer" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5174 /* "glColorPointer" */,
                                providers, entrypoints);
}

static PFNGLCOLORPOINTEREXTPROC
epoxy_glColorPointerEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_array, 5189 /* glColorPointerEXT */);
}

static PFNGLCOLORPOINTERLISTIBMPROC
epoxy_glColorPointerListIBM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_IBM_vertex_array_lists, 5207 /* glColorPointerListIBM */);
}

static PFNGLCOLORPOINTERVINTELPROC
epoxy_glColorPointervINTEL_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_INTEL_parallel_arrays, 5229 /* glColorPointervINTEL */);
}

static PFNGLCOLORSUBTABLEPROC
epoxy_glColorSubTable_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_color_subtable,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5250 /* "glColorSubTable" */,
        5266 /* "glColorSubTableEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5250 /* "glColorSubTable" */,
                                providers, entrypoints);
}

static PFNGLCOLORSUBTABLEEXTPROC
epoxy_glColorSubTableEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_color_subtable,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5266 /* "glColorSubTableEXT" */,
        5250 /* "glColorSubTable" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5266 /* "glColorSubTableEXT" */,
                                providers, entrypoints);
}

static PFNGLCOLORTABLEPROC
epoxy_glColorTable_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_paletted_texture,
        GL_extension_GL_SGI_color_table,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5285 /* "glColorTable" */,
        5298 /* "glColorTableEXT" */,
        5416 /* "glColorTableSGI" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5285 /* "glColorTable" */,
                                providers, entrypoints);
}

static PFNGLCOLORTABLEEXTPROC
epoxy_glColorTableEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_paletted_texture,
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_SGI_color_table,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5298 /* "glColorTableEXT" */,
        5285 /* "glColorTable" */,
        5416 /* "glColorTableSGI" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5298 /* "glColorTableEXT" */,
                                providers, entrypoints);
}

static PFNGLCOLORTABLEPARAMETERFVPROC
epoxy_glColorTableParameterfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_SGI_color_table,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5314 /* "glColorTableParameterfv" */,
        5338 /* "glColorTableParameterfvSGI" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5314 /* "glColorTableParameterfv" */,
                                providers, entrypoints);
}

static PFNGLCOLORTABLEPARAMETERFVSGIPROC
epoxy_glColorTableParameterfvSGI_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_SGI_color_table,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5338 /* "glColorTableParameterfvSGI" */,
        5314 /* "glColorTableParameterfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5338 /* "glColorTableParameterfvSGI" */,
                                providers, entrypoints);
}

static PFNGLCOLORTABLEPARAMETERIVPROC
epoxy_glColorTableParameteriv_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_SGI_color_table,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5365 /* "glColorTableParameteriv" */,
        5389 /* "glColorTableParameterivSGI" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5365 /* "glColorTableParameteriv" */,
                                providers, entrypoints);
}

static PFNGLCOLORTABLEPARAMETERIVSGIPROC
epoxy_glColorTableParameterivSGI_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_SGI_color_table,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5389 /* "glColorTableParameterivSGI" */,
        5365 /* "glColorTableParameteriv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5389 /* "glColorTableParameterivSGI" */,
                                providers, entrypoints);
}

static PFNGLCOLORTABLESGIPROC
epoxy_glColorTableSGI_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_SGI_color_table,
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_paletted_texture,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5416 /* "glColorTableSGI" */,
        5285 /* "glColorTable" */,
        5298 /* "glColorTableEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5416 /* "glColorTableSGI" */,
                                providers, entrypoints);
}

static PFNGLCOMBINERINPUTNVPROC
epoxy_glCombinerInputNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_register_combiners, 5432 /* glCombinerInputNV */);
}

static PFNGLCOMBINEROUTPUTNVPROC
epoxy_glCombinerOutputNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_register_combiners, 5450 /* glCombinerOutputNV */);
}

static PFNGLCOMBINERPARAMETERFNVPROC
epoxy_glCombinerParameterfNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_register_combiners, 5469 /* glCombinerParameterfNV */);
}

static PFNGLCOMBINERPARAMETERFVNVPROC
epoxy_glCombinerParameterfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_register_combiners, 5492 /* glCombinerParameterfvNV */);
}

static PFNGLCOMBINERPARAMETERINVPROC
epoxy_glCombinerParameteriNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_register_combiners, 5516 /* glCombinerParameteriNV */);
}

static PFNGLCOMBINERPARAMETERIVNVPROC
epoxy_glCombinerParameterivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_register_combiners, 5539 /* glCombinerParameterivNV */);
}

static PFNGLCOMBINERSTAGEPARAMETERFVNVPROC
epoxy_glCombinerStageParameterfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_register_combiners2, 5563 /* glCombinerStageParameterfvNV */);
}

static PFNGLCOMMANDLISTSEGMENTSNVPROC
epoxy_glCommandListSegmentsNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_command_list, 5592 /* glCommandListSegmentsNV */);
}

static PFNGLCOMPILECOMMANDLISTNVPROC
epoxy_glCompileCommandListNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_command_list, 5616 /* glCompileCommandListNV */);
}

static PFNGLCOMPILESHADERPROC
epoxy_glCompileShader_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_shader_objects,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5639 /* "glCompileShader" */,
        5639 /* "glCompileShader" */,
        5655 /* "glCompileShaderARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5639 /* "glCompileShader" */,
                                providers, entrypoints);
}

static PFNGLCOMPILESHADERARBPROC
epoxy_glCompileShaderARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_shader_objects,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5655 /* "glCompileShaderARB" */,
        5639 /* "glCompileShader" */,
        5639 /* "glCompileShader" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5655 /* "glCompileShaderARB" */,
                                providers, entrypoints);
}

static PFNGLCOMPILESHADERINCLUDEARBPROC
epoxy_glCompileShaderIncludeARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_shading_language_include, 5674 /* glCompileShaderIncludeARB */);
}

static PFNGLCOMPRESSEDMULTITEXIMAGE1DEXTPROC
epoxy_glCompressedMultiTexImage1DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 5700 /* glCompressedMultiTexImage1DEXT */);
}

static PFNGLCOMPRESSEDMULTITEXIMAGE2DEXTPROC
epoxy_glCompressedMultiTexImage2DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 5731 /* glCompressedMultiTexImage2DEXT */);
}

static PFNGLCOMPRESSEDMULTITEXIMAGE3DEXTPROC
epoxy_glCompressedMultiTexImage3DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 5762 /* glCompressedMultiTexImage3DEXT */);
}

static PFNGLCOMPRESSEDMULTITEXSUBIMAGE1DEXTPROC
epoxy_glCompressedMultiTexSubImage1DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 5793 /* glCompressedMultiTexSubImage1DEXT */);
}

static PFNGLCOMPRESSEDMULTITEXSUBIMAGE2DEXTPROC
epoxy_glCompressedMultiTexSubImage2DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 5827 /* glCompressedMultiTexSubImage2DEXT */);
}

static PFNGLCOMPRESSEDMULTITEXSUBIMAGE3DEXTPROC
epoxy_glCompressedMultiTexSubImage3DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 5861 /* glCompressedMultiTexSubImage3DEXT */);
}

static PFNGLCOMPRESSEDTEXIMAGE1DPROC
epoxy_glCompressedTexImage1D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_3,
        GL_extension_GL_ARB_texture_compression,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5895 /* "glCompressedTexImage1D" */,
        5918 /* "glCompressedTexImage1DARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5895 /* "glCompressedTexImage1D" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXIMAGE1DARBPROC
epoxy_glCompressedTexImage1DARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_texture_compression,
        Desktop_OpenGL_1_3,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5918 /* "glCompressedTexImage1DARB" */,
        5895 /* "glCompressedTexImage1D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5918 /* "glCompressedTexImage1DARB" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXIMAGE2DPROC
epoxy_glCompressedTexImage2D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_3,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_texture_compression,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5944 /* "glCompressedTexImage2D" */,
        5944 /* "glCompressedTexImage2D" */,
        5944 /* "glCompressedTexImage2D" */,
        5967 /* "glCompressedTexImage2DARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5944 /* "glCompressedTexImage2D" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXIMAGE2DARBPROC
epoxy_glCompressedTexImage2DARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_texture_compression,
        Desktop_OpenGL_1_3,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5967 /* "glCompressedTexImage2DARB" */,
        5944 /* "glCompressedTexImage2D" */,
        5944 /* "glCompressedTexImage2D" */,
        5944 /* "glCompressedTexImage2D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5967 /* "glCompressedTexImage2DARB" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXIMAGE3DPROC
epoxy_glCompressedTexImage3D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_3,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_texture_compression,
        GL_extension_GL_OES_texture_3D,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        5993 /* "glCompressedTexImage3D" */,
        5993 /* "glCompressedTexImage3D" */,
        6016 /* "glCompressedTexImage3DARB" */,
        6042 /* "glCompressedTexImage3DOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 5993 /* "glCompressedTexImage3D" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXIMAGE3DARBPROC
epoxy_glCompressedTexImage3DARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_texture_compression,
        Desktop_OpenGL_1_3,
        OpenGL_ES_3_0,
        GL_extension_GL_OES_texture_3D,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6016 /* "glCompressedTexImage3DARB" */,
        5993 /* "glCompressedTexImage3D" */,
        5993 /* "glCompressedTexImage3D" */,
        6042 /* "glCompressedTexImage3DOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6016 /* "glCompressedTexImage3DARB" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXIMAGE3DOESPROC
epoxy_glCompressedTexImage3DOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_texture_3D,
        Desktop_OpenGL_1_3,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_texture_compression,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6042 /* "glCompressedTexImage3DOES" */,
        5993 /* "glCompressedTexImage3D" */,
        5993 /* "glCompressedTexImage3D" */,
        6016 /* "glCompressedTexImage3DARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6042 /* "glCompressedTexImage3DOES" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC
epoxy_glCompressedTexSubImage1D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_3,
        GL_extension_GL_ARB_texture_compression,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6068 /* "glCompressedTexSubImage1D" */,
        6094 /* "glCompressedTexSubImage1DARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6068 /* "glCompressedTexSubImage1D" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC
epoxy_glCompressedTexSubImage1DARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_texture_compression,
        Desktop_OpenGL_1_3,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6094 /* "glCompressedTexSubImage1DARB" */,
        6068 /* "glCompressedTexSubImage1D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6094 /* "glCompressedTexSubImage1DARB" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC
epoxy_glCompressedTexSubImage2D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_3,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_texture_compression,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6123 /* "glCompressedTexSubImage2D" */,
        6123 /* "glCompressedTexSubImage2D" */,
        6123 /* "glCompressedTexSubImage2D" */,
        6149 /* "glCompressedTexSubImage2DARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6123 /* "glCompressedTexSubImage2D" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC
epoxy_glCompressedTexSubImage2DARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_texture_compression,
        Desktop_OpenGL_1_3,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6149 /* "glCompressedTexSubImage2DARB" */,
        6123 /* "glCompressedTexSubImage2D" */,
        6123 /* "glCompressedTexSubImage2D" */,
        6123 /* "glCompressedTexSubImage2D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6149 /* "glCompressedTexSubImage2DARB" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC
epoxy_glCompressedTexSubImage3D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_3,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_texture_compression,
        GL_extension_GL_OES_texture_3D,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6178 /* "glCompressedTexSubImage3D" */,
        6178 /* "glCompressedTexSubImage3D" */,
        6204 /* "glCompressedTexSubImage3DARB" */,
        6233 /* "glCompressedTexSubImage3DOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6178 /* "glCompressedTexSubImage3D" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC
epoxy_glCompressedTexSubImage3DARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_texture_compression,
        Desktop_OpenGL_1_3,
        OpenGL_ES_3_0,
        GL_extension_GL_OES_texture_3D,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6204 /* "glCompressedTexSubImage3DARB" */,
        6178 /* "glCompressedTexSubImage3D" */,
        6178 /* "glCompressedTexSubImage3D" */,
        6233 /* "glCompressedTexSubImage3DOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6204 /* "glCompressedTexSubImage3DARB" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXSUBIMAGE3DOESPROC
epoxy_glCompressedTexSubImage3DOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_texture_3D,
        Desktop_OpenGL_1_3,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_texture_compression,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6233 /* "glCompressedTexSubImage3DOES" */,
        6178 /* "glCompressedTexSubImage3D" */,
        6178 /* "glCompressedTexSubImage3D" */,
        6204 /* "glCompressedTexSubImage3DARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6233 /* "glCompressedTexSubImage3DOES" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXTUREIMAGE1DEXTPROC
epoxy_glCompressedTextureImage1DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 6262 /* glCompressedTextureImage1DEXT */);
}

static PFNGLCOMPRESSEDTEXTUREIMAGE2DEXTPROC
epoxy_glCompressedTextureImage2DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 6292 /* glCompressedTextureImage2DEXT */);
}

static PFNGLCOMPRESSEDTEXTUREIMAGE3DEXTPROC
epoxy_glCompressedTextureImage3DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 6322 /* glCompressedTextureImage3DEXT */);
}

static PFNGLCOMPRESSEDTEXTURESUBIMAGE1DPROC
epoxy_glCompressedTextureSubImage1D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6352 /* "glCompressedTextureSubImage1D" */,
        6352 /* "glCompressedTextureSubImage1D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6352 /* "glCompressedTextureSubImage1D" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXTURESUBIMAGE1DEXTPROC
epoxy_glCompressedTextureSubImage1DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 6382 /* glCompressedTextureSubImage1DEXT */);
}

static PFNGLCOMPRESSEDTEXTURESUBIMAGE2DPROC
epoxy_glCompressedTextureSubImage2D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6415 /* "glCompressedTextureSubImage2D" */,
        6415 /* "glCompressedTextureSubImage2D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6415 /* "glCompressedTextureSubImage2D" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXTURESUBIMAGE2DEXTPROC
epoxy_glCompressedTextureSubImage2DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 6445 /* glCompressedTextureSubImage2DEXT */);
}

static PFNGLCOMPRESSEDTEXTURESUBIMAGE3DPROC
epoxy_glCompressedTextureSubImage3D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6478 /* "glCompressedTextureSubImage3D" */,
        6478 /* "glCompressedTextureSubImage3D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6478 /* "glCompressedTextureSubImage3D" */,
                                providers, entrypoints);
}

static PFNGLCOMPRESSEDTEXTURESUBIMAGE3DEXTPROC
epoxy_glCompressedTextureSubImage3DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 6508 /* glCompressedTextureSubImage3DEXT */);
}

static PFNGLCONVOLUTIONFILTER1DPROC
epoxy_glConvolutionFilter1D_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_convolution,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6541 /* "glConvolutionFilter1D" */,
        6563 /* "glConvolutionFilter1DEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6541 /* "glConvolutionFilter1D" */,
                                providers, entrypoints);
}

static PFNGLCONVOLUTIONFILTER1DEXTPROC
epoxy_glConvolutionFilter1DEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_convolution,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6563 /* "glConvolutionFilter1DEXT" */,
        6541 /* "glConvolutionFilter1D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6563 /* "glConvolutionFilter1DEXT" */,
                                providers, entrypoints);
}

static PFNGLCONVOLUTIONFILTER2DPROC
epoxy_glConvolutionFilter2D_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_convolution,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6588 /* "glConvolutionFilter2D" */,
        6610 /* "glConvolutionFilter2DEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6588 /* "glConvolutionFilter2D" */,
                                providers, entrypoints);
}

static PFNGLCONVOLUTIONFILTER2DEXTPROC
epoxy_glConvolutionFilter2DEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_convolution,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6610 /* "glConvolutionFilter2DEXT" */,
        6588 /* "glConvolutionFilter2D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6610 /* "glConvolutionFilter2DEXT" */,
                                providers, entrypoints);
}

static PFNGLCONVOLUTIONPARAMETERFPROC
epoxy_glConvolutionParameterf_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_convolution,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6635 /* "glConvolutionParameterf" */,
        6659 /* "glConvolutionParameterfEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6635 /* "glConvolutionParameterf" */,
                                providers, entrypoints);
}

static PFNGLCONVOLUTIONPARAMETERFEXTPROC
epoxy_glConvolutionParameterfEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_convolution,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6659 /* "glConvolutionParameterfEXT" */,
        6635 /* "glConvolutionParameterf" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6659 /* "glConvolutionParameterfEXT" */,
                                providers, entrypoints);
}

static PFNGLCONVOLUTIONPARAMETERFVPROC
epoxy_glConvolutionParameterfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_convolution,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6686 /* "glConvolutionParameterfv" */,
        6711 /* "glConvolutionParameterfvEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6686 /* "glConvolutionParameterfv" */,
                                providers, entrypoints);
}

static PFNGLCONVOLUTIONPARAMETERFVEXTPROC
epoxy_glConvolutionParameterfvEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_convolution,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6711 /* "glConvolutionParameterfvEXT" */,
        6686 /* "glConvolutionParameterfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6711 /* "glConvolutionParameterfvEXT" */,
                                providers, entrypoints);
}

static PFNGLCONVOLUTIONPARAMETERIPROC
epoxy_glConvolutionParameteri_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_convolution,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6739 /* "glConvolutionParameteri" */,
        6763 /* "glConvolutionParameteriEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6739 /* "glConvolutionParameteri" */,
                                providers, entrypoints);
}

static PFNGLCONVOLUTIONPARAMETERIEXTPROC
epoxy_glConvolutionParameteriEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_convolution,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6763 /* "glConvolutionParameteriEXT" */,
        6739 /* "glConvolutionParameteri" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6763 /* "glConvolutionParameteriEXT" */,
                                providers, entrypoints);
}

static PFNGLCONVOLUTIONPARAMETERIVPROC
epoxy_glConvolutionParameteriv_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_convolution,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6790 /* "glConvolutionParameteriv" */,
        6815 /* "glConvolutionParameterivEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6790 /* "glConvolutionParameteriv" */,
                                providers, entrypoints);
}

static PFNGLCONVOLUTIONPARAMETERIVEXTPROC
epoxy_glConvolutionParameterivEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_convolution,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6815 /* "glConvolutionParameterivEXT" */,
        6790 /* "glConvolutionParameteriv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6815 /* "glConvolutionParameterivEXT" */,
                                providers, entrypoints);
}

static PFNGLCONVOLUTIONPARAMETERXOESPROC
epoxy_glConvolutionParameterxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 6843 /* glConvolutionParameterxOES */);
}

static PFNGLCONVOLUTIONPARAMETERXVOESPROC
epoxy_glConvolutionParameterxvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 6870 /* glConvolutionParameterxvOES */);
}

static PFNGLCOPYBUFFERSUBDATAPROC
epoxy_glCopyBufferSubData_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_copy_buffer,
        OpenGL_ES_3_0,
        GL_extension_GL_NV_copy_buffer,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6898 /* "glCopyBufferSubData" */,
        6898 /* "glCopyBufferSubData" */,
        6898 /* "glCopyBufferSubData" */,
        6918 /* "glCopyBufferSubDataNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6898 /* "glCopyBufferSubData" */,
                                providers, entrypoints);
}

static PFNGLCOPYBUFFERSUBDATANVPROC
epoxy_glCopyBufferSubDataNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_copy_buffer,
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_copy_buffer,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6918 /* "glCopyBufferSubDataNV" */,
        6898 /* "glCopyBufferSubData" */,
        6898 /* "glCopyBufferSubData" */,
        6898 /* "glCopyBufferSubData" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6918 /* "glCopyBufferSubDataNV" */,
                                providers, entrypoints);
}

static PFNGLCOPYCOLORSUBTABLEPROC
epoxy_glCopyColorSubTable_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_color_subtable,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6940 /* "glCopyColorSubTable" */,
        6960 /* "glCopyColorSubTableEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6940 /* "glCopyColorSubTable" */,
                                providers, entrypoints);
}

static PFNGLCOPYCOLORSUBTABLEEXTPROC
epoxy_glCopyColorSubTableEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_color_subtable,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6960 /* "glCopyColorSubTableEXT" */,
        6940 /* "glCopyColorSubTable" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6960 /* "glCopyColorSubTableEXT" */,
                                providers, entrypoints);
}

static PFNGLCOPYCOLORTABLEPROC
epoxy_glCopyColorTable_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_SGI_color_table,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        6983 /* "glCopyColorTable" */,
        7000 /* "glCopyColorTableSGI" */,
    };
    return gl_provider_resolver(entrypoint_strings + 6983 /* "glCopyColorTable" */,
                                providers, entrypoints);
}

static PFNGLCOPYCOLORTABLESGIPROC
epoxy_glCopyColorTableSGI_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_SGI_color_table,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7000 /* "glCopyColorTableSGI" */,
        6983 /* "glCopyColorTable" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7000 /* "glCopyColorTableSGI" */,
                                providers, entrypoints);
}

static PFNGLCOPYCONVOLUTIONFILTER1DPROC
epoxy_glCopyConvolutionFilter1D_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_convolution,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7020 /* "glCopyConvolutionFilter1D" */,
        7046 /* "glCopyConvolutionFilter1DEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7020 /* "glCopyConvolutionFilter1D" */,
                                providers, entrypoints);
}

static PFNGLCOPYCONVOLUTIONFILTER1DEXTPROC
epoxy_glCopyConvolutionFilter1DEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_convolution,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7046 /* "glCopyConvolutionFilter1DEXT" */,
        7020 /* "glCopyConvolutionFilter1D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7046 /* "glCopyConvolutionFilter1DEXT" */,
                                providers, entrypoints);
}

static PFNGLCOPYCONVOLUTIONFILTER2DPROC
epoxy_glCopyConvolutionFilter2D_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_convolution,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7075 /* "glCopyConvolutionFilter2D" */,
        7101 /* "glCopyConvolutionFilter2DEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7075 /* "glCopyConvolutionFilter2D" */,
                                providers, entrypoints);
}

static PFNGLCOPYCONVOLUTIONFILTER2DEXTPROC
epoxy_glCopyConvolutionFilter2DEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_convolution,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7101 /* "glCopyConvolutionFilter2DEXT" */,
        7075 /* "glCopyConvolutionFilter2D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7101 /* "glCopyConvolutionFilter2DEXT" */,
                                providers, entrypoints);
}

static PFNGLCOPYIMAGESUBDATAPROC
epoxy_glCopyImageSubData_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_copy_image,
        GL_extension_GL_EXT_copy_image,
        GL_extension_GL_OES_copy_image,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7130 /* "glCopyImageSubData" */,
        7130 /* "glCopyImageSubData" */,
        7149 /* "glCopyImageSubDataEXT" */,
        7192 /* "glCopyImageSubDataOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7130 /* "glCopyImageSubData" */,
                                providers, entrypoints);
}

static PFNGLCOPYIMAGESUBDATAEXTPROC
epoxy_glCopyImageSubDataEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_copy_image,
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_copy_image,
        GL_extension_GL_OES_copy_image,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7149 /* "glCopyImageSubDataEXT" */,
        7130 /* "glCopyImageSubData" */,
        7130 /* "glCopyImageSubData" */,
        7192 /* "glCopyImageSubDataOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7149 /* "glCopyImageSubDataEXT" */,
                                providers, entrypoints);
}

static PFNGLCOPYIMAGESUBDATANVPROC
epoxy_glCopyImageSubDataNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_copy_image, 7171 /* glCopyImageSubDataNV */);
}

static PFNGLCOPYIMAGESUBDATAOESPROC
epoxy_glCopyImageSubDataOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_copy_image,
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_copy_image,
        GL_extension_GL_EXT_copy_image,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7192 /* "glCopyImageSubDataOES" */,
        7130 /* "glCopyImageSubData" */,
        7130 /* "glCopyImageSubData" */,
        7149 /* "glCopyImageSubDataEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7192 /* "glCopyImageSubDataOES" */,
                                providers, entrypoints);
}

static PFNGLCOPYMULTITEXIMAGE1DEXTPROC
epoxy_glCopyMultiTexImage1DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 7214 /* glCopyMultiTexImage1DEXT */);
}

static PFNGLCOPYMULTITEXIMAGE2DEXTPROC
epoxy_glCopyMultiTexImage2DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 7239 /* glCopyMultiTexImage2DEXT */);
}

static PFNGLCOPYMULTITEXSUBIMAGE1DEXTPROC
epoxy_glCopyMultiTexSubImage1DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 7264 /* glCopyMultiTexSubImage1DEXT */);
}

static PFNGLCOPYMULTITEXSUBIMAGE2DEXTPROC
epoxy_glCopyMultiTexSubImage2DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 7292 /* glCopyMultiTexSubImage2DEXT */);
}

static PFNGLCOPYMULTITEXSUBIMAGE3DEXTPROC
epoxy_glCopyMultiTexSubImage3DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 7320 /* glCopyMultiTexSubImage3DEXT */);
}

static PFNGLCOPYNAMEDBUFFERSUBDATAPROC
epoxy_glCopyNamedBufferSubData_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7348 /* "glCopyNamedBufferSubData" */,
        7348 /* "glCopyNamedBufferSubData" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7348 /* "glCopyNamedBufferSubData" */,
                                providers, entrypoints);
}

static PFNGLCOPYPATHNVPROC
epoxy_glCopyPathNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 7373 /* glCopyPathNV */);
}

static PFNGLCOPYPIXELSPROC
epoxy_glCopyPixels_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 7386 /* glCopyPixels */);
}

static PFNGLCOPYTEXIMAGE1DPROC
epoxy_glCopyTexImage1D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_1,
        GL_extension_GL_EXT_copy_texture,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7399 /* "glCopyTexImage1D" */,
        7416 /* "glCopyTexImage1DEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7399 /* "glCopyTexImage1D" */,
                                providers, entrypoints);
}

static PFNGLCOPYTEXIMAGE1DEXTPROC
epoxy_glCopyTexImage1DEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_copy_texture,
        Desktop_OpenGL_1_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7416 /* "glCopyTexImage1DEXT" */,
        7399 /* "glCopyTexImage1D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7416 /* "glCopyTexImage1DEXT" */,
                                providers, entrypoints);
}

static PFNGLCOPYTEXIMAGE2DPROC
epoxy_glCopyTexImage2D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_1,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_copy_texture,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7436 /* "glCopyTexImage2D" */,
        7436 /* "glCopyTexImage2D" */,
        7436 /* "glCopyTexImage2D" */,
        7453 /* "glCopyTexImage2DEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7436 /* "glCopyTexImage2D" */,
                                providers, entrypoints);
}

static PFNGLCOPYTEXIMAGE2DEXTPROC
epoxy_glCopyTexImage2DEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_copy_texture,
        Desktop_OpenGL_1_1,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7453 /* "glCopyTexImage2DEXT" */,
        7436 /* "glCopyTexImage2D" */,
        7436 /* "glCopyTexImage2D" */,
        7436 /* "glCopyTexImage2D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7453 /* "glCopyTexImage2DEXT" */,
                                providers, entrypoints);
}

static PFNGLCOPYTEXSUBIMAGE1DPROC
epoxy_glCopyTexSubImage1D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_1,
        GL_extension_GL_EXT_copy_texture,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7473 /* "glCopyTexSubImage1D" */,
        7493 /* "glCopyTexSubImage1DEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7473 /* "glCopyTexSubImage1D" */,
                                providers, entrypoints);
}

static PFNGLCOPYTEXSUBIMAGE1DEXTPROC
epoxy_glCopyTexSubImage1DEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_copy_texture,
        Desktop_OpenGL_1_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7493 /* "glCopyTexSubImage1DEXT" */,
        7473 /* "glCopyTexSubImage1D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7493 /* "glCopyTexSubImage1DEXT" */,
                                providers, entrypoints);
}

static PFNGLCOPYTEXSUBIMAGE2DPROC
epoxy_glCopyTexSubImage2D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_1,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_copy_texture,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7516 /* "glCopyTexSubImage2D" */,
        7516 /* "glCopyTexSubImage2D" */,
        7516 /* "glCopyTexSubImage2D" */,
        7536 /* "glCopyTexSubImage2DEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7516 /* "glCopyTexSubImage2D" */,
                                providers, entrypoints);
}

static PFNGLCOPYTEXSUBIMAGE2DEXTPROC
epoxy_glCopyTexSubImage2DEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_copy_texture,
        Desktop_OpenGL_1_1,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7536 /* "glCopyTexSubImage2DEXT" */,
        7516 /* "glCopyTexSubImage2D" */,
        7516 /* "glCopyTexSubImage2D" */,
        7516 /* "glCopyTexSubImage2D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7536 /* "glCopyTexSubImage2DEXT" */,
                                providers, entrypoints);
}

static PFNGLCOPYTEXSUBIMAGE3DPROC
epoxy_glCopyTexSubImage3D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_2,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_copy_texture,
        GL_extension_GL_OES_texture_3D,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7559 /* "glCopyTexSubImage3D" */,
        7559 /* "glCopyTexSubImage3D" */,
        7579 /* "glCopyTexSubImage3DEXT" */,
        7602 /* "glCopyTexSubImage3DOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7559 /* "glCopyTexSubImage3D" */,
                                providers, entrypoints);
}

static PFNGLCOPYTEXSUBIMAGE3DEXTPROC
epoxy_glCopyTexSubImage3DEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_copy_texture,
        Desktop_OpenGL_1_2,
        OpenGL_ES_3_0,
        GL_extension_GL_OES_texture_3D,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7579 /* "glCopyTexSubImage3DEXT" */,
        7559 /* "glCopyTexSubImage3D" */,
        7559 /* "glCopyTexSubImage3D" */,
        7602 /* "glCopyTexSubImage3DOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7579 /* "glCopyTexSubImage3DEXT" */,
                                providers, entrypoints);
}

static PFNGLCOPYTEXSUBIMAGE3DOESPROC
epoxy_glCopyTexSubImage3DOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_texture_3D,
        Desktop_OpenGL_1_2,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_copy_texture,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7602 /* "glCopyTexSubImage3DOES" */,
        7559 /* "glCopyTexSubImage3D" */,
        7559 /* "glCopyTexSubImage3D" */,
        7579 /* "glCopyTexSubImage3DEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7602 /* "glCopyTexSubImage3DOES" */,
                                providers, entrypoints);
}

static PFNGLCOPYTEXTUREIMAGE1DEXTPROC
epoxy_glCopyTextureImage1DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 7625 /* glCopyTextureImage1DEXT */);
}

static PFNGLCOPYTEXTUREIMAGE2DEXTPROC
epoxy_glCopyTextureImage2DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 7649 /* glCopyTextureImage2DEXT */);
}

static PFNGLCOPYTEXTURELEVELSAPPLEPROC
epoxy_glCopyTextureLevelsAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_copy_texture_levels, 7673 /* glCopyTextureLevelsAPPLE */);
}

static PFNGLCOPYTEXTURESUBIMAGE1DPROC
epoxy_glCopyTextureSubImage1D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7698 /* "glCopyTextureSubImage1D" */,
        7698 /* "glCopyTextureSubImage1D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7698 /* "glCopyTextureSubImage1D" */,
                                providers, entrypoints);
}

static PFNGLCOPYTEXTURESUBIMAGE1DEXTPROC
epoxy_glCopyTextureSubImage1DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 7722 /* glCopyTextureSubImage1DEXT */);
}

static PFNGLCOPYTEXTURESUBIMAGE2DPROC
epoxy_glCopyTextureSubImage2D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7749 /* "glCopyTextureSubImage2D" */,
        7749 /* "glCopyTextureSubImage2D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7749 /* "glCopyTextureSubImage2D" */,
                                providers, entrypoints);
}

static PFNGLCOPYTEXTURESUBIMAGE2DEXTPROC
epoxy_glCopyTextureSubImage2DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 7773 /* glCopyTextureSubImage2DEXT */);
}

static PFNGLCOPYTEXTURESUBIMAGE3DPROC
epoxy_glCopyTextureSubImage3D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        7800 /* "glCopyTextureSubImage3D" */,
        7800 /* "glCopyTextureSubImage3D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 7800 /* "glCopyTextureSubImage3D" */,
                                providers, entrypoints);
}

static PFNGLCOPYTEXTURESUBIMAGE3DEXTPROC
epoxy_glCopyTextureSubImage3DEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 7824 /* glCopyTextureSubImage3DEXT */);
}

static PFNGLCOVERFILLPATHINSTANCEDNVPROC
epoxy_glCoverFillPathInstancedNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 7851 /* glCoverFillPathInstancedNV */);
}

static PFNGLCOVERFILLPATHNVPROC
epoxy_glCoverFillPathNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 7878 /* glCoverFillPathNV */);
}

static PFNGLCOVERSTROKEPATHINSTANCEDNVPROC
epoxy_glCoverStrokePathInstancedNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 7896 /* glCoverStrokePathInstancedNV */);
}

static PFNGLCOVERSTROKEPATHNVPROC
epoxy_glCoverStrokePathNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 7925 /* glCoverStrokePathNV */);
}

static PFNGLCOVERAGEMASKNVPROC
epoxy_glCoverageMaskNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_coverage_sample, 7945 /* glCoverageMaskNV */);
}

static PFNGLCOVERAGEMODULATIONNVPROC
epoxy_glCoverageModulationNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_framebuffer_mixed_samples, 7962 /* glCoverageModulationNV */);
}

static PFNGLCOVERAGEMODULATIONTABLENVPROC
epoxy_glCoverageModulationTableNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_framebuffer_mixed_samples, 7985 /* glCoverageModulationTableNV */);
}

static PFNGLCOVERAGEOPERATIONNVPROC
epoxy_glCoverageOperationNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_coverage_sample, 8013 /* glCoverageOperationNV */);
}

static PFNGLCREATEBUFFERSPROC
epoxy_glCreateBuffers_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8035 /* "glCreateBuffers" */,
        8035 /* "glCreateBuffers" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8035 /* "glCreateBuffers" */,
                                providers, entrypoints);
}

static PFNGLCREATECOMMANDLISTSNVPROC
epoxy_glCreateCommandListsNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_command_list, 8051 /* glCreateCommandListsNV */);
}

static PFNGLCREATEFRAMEBUFFERSPROC
epoxy_glCreateFramebuffers_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8074 /* "glCreateFramebuffers" */,
        8074 /* "glCreateFramebuffers" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8074 /* "glCreateFramebuffers" */,
                                providers, entrypoints);
}

static PFNGLCREATEPERFQUERYINTELPROC
epoxy_glCreatePerfQueryINTEL_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_INTEL_performance_query, 8095 /* glCreatePerfQueryINTEL */);
}

static PFNGLCREATEPROGRAMPROC
epoxy_glCreateProgram_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_shader_objects,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8118 /* "glCreateProgram" */,
        8118 /* "glCreateProgram" */,
        8134 /* "glCreateProgramObjectARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8118 /* "glCreateProgram" */,
                                providers, entrypoints);
}

static PFNGLCREATEPROGRAMOBJECTARBPROC
epoxy_glCreateProgramObjectARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_shader_objects,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8134 /* "glCreateProgramObjectARB" */,
        8118 /* "glCreateProgram" */,
        8118 /* "glCreateProgram" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8134 /* "glCreateProgramObjectARB" */,
                                providers, entrypoints);
}

static PFNGLCREATEPROGRAMPIPELINESPROC
epoxy_glCreateProgramPipelines_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8159 /* "glCreateProgramPipelines" */,
        8159 /* "glCreateProgramPipelines" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8159 /* "glCreateProgramPipelines" */,
                                providers, entrypoints);
}

static PFNGLCREATEQUERIESPROC
epoxy_glCreateQueries_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8184 /* "glCreateQueries" */,
        8184 /* "glCreateQueries" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8184 /* "glCreateQueries" */,
                                providers, entrypoints);
}

static PFNGLCREATERENDERBUFFERSPROC
epoxy_glCreateRenderbuffers_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8200 /* "glCreateRenderbuffers" */,
        8200 /* "glCreateRenderbuffers" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8200 /* "glCreateRenderbuffers" */,
                                providers, entrypoints);
}

static PFNGLCREATESAMPLERSPROC
epoxy_glCreateSamplers_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8222 /* "glCreateSamplers" */,
        8222 /* "glCreateSamplers" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8222 /* "glCreateSamplers" */,
                                providers, entrypoints);
}

static PFNGLCREATESHADERPROC
epoxy_glCreateShader_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_shader_objects,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8239 /* "glCreateShader" */,
        8239 /* "glCreateShader" */,
        8254 /* "glCreateShaderObjectARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8239 /* "glCreateShader" */,
                                providers, entrypoints);
}

static PFNGLCREATESHADEROBJECTARBPROC
epoxy_glCreateShaderObjectARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_shader_objects,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8254 /* "glCreateShaderObjectARB" */,
        8239 /* "glCreateShader" */,
        8239 /* "glCreateShader" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8254 /* "glCreateShaderObjectARB" */,
                                providers, entrypoints);
}

static PFNGLCREATESHADERPROGRAMEXTPROC
epoxy_glCreateShaderProgramEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_separate_shader_objects, 8278 /* glCreateShaderProgramEXT */);
}

static PFNGLCREATESHADERPROGRAMVPROC
epoxy_glCreateShaderProgramv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_separate_shader_objects,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8303 /* "glCreateShaderProgramv" */,
        8303 /* "glCreateShaderProgramv" */,
        8303 /* "glCreateShaderProgramv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8303 /* "glCreateShaderProgramv" */,
                                providers, entrypoints);
}

static PFNGLCREATESHADERPROGRAMVEXTPROC
epoxy_glCreateShaderProgramvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_separate_shader_objects, 8326 /* glCreateShaderProgramvEXT */);
}

static PFNGLCREATESTATESNVPROC
epoxy_glCreateStatesNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_command_list, 8352 /* glCreateStatesNV */);
}

static PFNGLCREATESYNCFROMCLEVENTARBPROC
epoxy_glCreateSyncFromCLeventARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_cl_event, 8369 /* glCreateSyncFromCLeventARB */);
}

static PFNGLCREATETEXTURESPROC
epoxy_glCreateTextures_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8396 /* "glCreateTextures" */,
        8396 /* "glCreateTextures" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8396 /* "glCreateTextures" */,
                                providers, entrypoints);
}

static PFNGLCREATETRANSFORMFEEDBACKSPROC
epoxy_glCreateTransformFeedbacks_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8413 /* "glCreateTransformFeedbacks" */,
        8413 /* "glCreateTransformFeedbacks" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8413 /* "glCreateTransformFeedbacks" */,
                                providers, entrypoints);
}

static PFNGLCREATEVERTEXARRAYSPROC
epoxy_glCreateVertexArrays_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8440 /* "glCreateVertexArrays" */,
        8440 /* "glCreateVertexArrays" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8440 /* "glCreateVertexArrays" */,
                                providers, entrypoints);
}

static PFNGLCULLFACEPROC
epoxy_glCullFace_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8461 /* "glCullFace" */,
        8461 /* "glCullFace" */,
        8461 /* "glCullFace" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8461 /* "glCullFace" */,
                                providers, entrypoints);
}

static PFNGLCULLPARAMETERDVEXTPROC
epoxy_glCullParameterdvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_cull_vertex, 8472 /* glCullParameterdvEXT */);
}

static PFNGLCULLPARAMETERFVEXTPROC
epoxy_glCullParameterfvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_cull_vertex, 8493 /* glCullParameterfvEXT */);
}

static PFNGLCURRENTPALETTEMATRIXARBPROC
epoxy_glCurrentPaletteMatrixARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_matrix_palette, 8514 /* glCurrentPaletteMatrixARB */);
}

static PFNGLCURRENTPALETTEMATRIXOESPROC
epoxy_glCurrentPaletteMatrixOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_matrix_palette, 8540 /* glCurrentPaletteMatrixOES */);
}

static PFNGLDEBUGMESSAGECALLBACKPROC
epoxy_glDebugMessageCallback_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        GL_extension_GL_ARB_debug_output,
        GL_extension_GL_KHR_debug,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8566 /* "glDebugMessageCallback" */,
        8566 /* "glDebugMessageCallback" */,
        8615 /* "glDebugMessageCallbackARB" */,
        8641 /* "glDebugMessageCallbackKHR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8566 /* "glDebugMessageCallback" */,
                                providers, entrypoints);
}

static PFNGLDEBUGMESSAGECALLBACKAMDPROC
epoxy_glDebugMessageCallbackAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_debug_output, 8589 /* glDebugMessageCallbackAMD */);
}

static PFNGLDEBUGMESSAGECALLBACKARBPROC
epoxy_glDebugMessageCallbackARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_debug_output,
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        GL_extension_GL_KHR_debug,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8615 /* "glDebugMessageCallbackARB" */,
        8566 /* "glDebugMessageCallback" */,
        8566 /* "glDebugMessageCallback" */,
        8641 /* "glDebugMessageCallbackKHR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8615 /* "glDebugMessageCallbackARB" */,
                                providers, entrypoints);
}

static PFNGLDEBUGMESSAGECALLBACKKHRPROC
epoxy_glDebugMessageCallbackKHR_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_KHR_debug,
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        GL_extension_GL_ARB_debug_output,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8641 /* "glDebugMessageCallbackKHR" */,
        8566 /* "glDebugMessageCallback" */,
        8566 /* "glDebugMessageCallback" */,
        8615 /* "glDebugMessageCallbackARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8641 /* "glDebugMessageCallbackKHR" */,
                                providers, entrypoints);
}

static PFNGLDEBUGMESSAGECONTROLPROC
epoxy_glDebugMessageControl_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        GL_extension_GL_ARB_debug_output,
        GL_extension_GL_KHR_debug,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8667 /* "glDebugMessageControl" */,
        8667 /* "glDebugMessageControl" */,
        8689 /* "glDebugMessageControlARB" */,
        8714 /* "glDebugMessageControlKHR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8667 /* "glDebugMessageControl" */,
                                providers, entrypoints);
}

static PFNGLDEBUGMESSAGECONTROLARBPROC
epoxy_glDebugMessageControlARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_debug_output,
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        GL_extension_GL_KHR_debug,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8689 /* "glDebugMessageControlARB" */,
        8667 /* "glDebugMessageControl" */,
        8667 /* "glDebugMessageControl" */,
        8714 /* "glDebugMessageControlKHR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8689 /* "glDebugMessageControlARB" */,
                                providers, entrypoints);
}

static PFNGLDEBUGMESSAGECONTROLKHRPROC
epoxy_glDebugMessageControlKHR_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_KHR_debug,
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        GL_extension_GL_ARB_debug_output,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8714 /* "glDebugMessageControlKHR" */,
        8667 /* "glDebugMessageControl" */,
        8667 /* "glDebugMessageControl" */,
        8689 /* "glDebugMessageControlARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8714 /* "glDebugMessageControlKHR" */,
                                providers, entrypoints);
}

static PFNGLDEBUGMESSAGEENABLEAMDPROC
epoxy_glDebugMessageEnableAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_debug_output, 8739 /* glDebugMessageEnableAMD */);
}

static PFNGLDEBUGMESSAGEINSERTPROC
epoxy_glDebugMessageInsert_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        GL_extension_GL_ARB_debug_output,
        GL_extension_GL_KHR_debug,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8763 /* "glDebugMessageInsert" */,
        8763 /* "glDebugMessageInsert" */,
        8808 /* "glDebugMessageInsertARB" */,
        8832 /* "glDebugMessageInsertKHR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8763 /* "glDebugMessageInsert" */,
                                providers, entrypoints);
}

static PFNGLDEBUGMESSAGEINSERTAMDPROC
epoxy_glDebugMessageInsertAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_debug_output, 8784 /* glDebugMessageInsertAMD */);
}

static PFNGLDEBUGMESSAGEINSERTARBPROC
epoxy_glDebugMessageInsertARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_debug_output,
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        GL_extension_GL_KHR_debug,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8808 /* "glDebugMessageInsertARB" */,
        8763 /* "glDebugMessageInsert" */,
        8763 /* "glDebugMessageInsert" */,
        8832 /* "glDebugMessageInsertKHR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8808 /* "glDebugMessageInsertARB" */,
                                providers, entrypoints);
}

static PFNGLDEBUGMESSAGEINSERTKHRPROC
epoxy_glDebugMessageInsertKHR_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_KHR_debug,
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        GL_extension_GL_ARB_debug_output,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8832 /* "glDebugMessageInsertKHR" */,
        8763 /* "glDebugMessageInsert" */,
        8763 /* "glDebugMessageInsert" */,
        8808 /* "glDebugMessageInsertARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8832 /* "glDebugMessageInsertKHR" */,
                                providers, entrypoints);
}

static PFNGLDEFORMSGIXPROC
epoxy_glDeformSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_polynomial_ffd, 8856 /* glDeformSGIX */);
}

static PFNGLDEFORMATIONMAP3DSGIXPROC
epoxy_glDeformationMap3dSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_polynomial_ffd, 8869 /* glDeformationMap3dSGIX */);
}

static PFNGLDEFORMATIONMAP3FSGIXPROC
epoxy_glDeformationMap3fSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_polynomial_ffd, 8892 /* glDeformationMap3fSGIX */);
}

static PFNGLDELETEASYNCMARKERSSGIXPROC
epoxy_glDeleteAsyncMarkersSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_async, 8915 /* glDeleteAsyncMarkersSGIX */);
}

static PFNGLDELETEBUFFERSPROC
epoxy_glDeleteBuffers_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_buffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8940 /* "glDeleteBuffers" */,
        8940 /* "glDeleteBuffers" */,
        8940 /* "glDeleteBuffers" */,
        8956 /* "glDeleteBuffersARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8940 /* "glDeleteBuffers" */,
                                providers, entrypoints);
}

static PFNGLDELETEBUFFERSARBPROC
epoxy_glDeleteBuffersARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_buffer_object,
        Desktop_OpenGL_1_5,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        8956 /* "glDeleteBuffersARB" */,
        8940 /* "glDeleteBuffers" */,
        8940 /* "glDeleteBuffers" */,
        8940 /* "glDeleteBuffers" */,
    };
    return gl_provider_resolver(entrypoint_strings + 8956 /* "glDeleteBuffersARB" */,
                                providers, entrypoints);
}

static PFNGLDELETECOMMANDLISTSNVPROC
epoxy_glDeleteCommandListsNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_command_list, 8975 /* glDeleteCommandListsNV */);
}

static PFNGLDELETEFENCESAPPLEPROC
epoxy_glDeleteFencesAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_fence, 8998 /* glDeleteFencesAPPLE */);
}

static PFNGLDELETEFENCESNVPROC
epoxy_glDeleteFencesNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_fence, 9018 /* glDeleteFencesNV */);
}

static PFNGLDELETEFRAGMENTSHADERATIPROC
epoxy_glDeleteFragmentShaderATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_fragment_shader, 9035 /* glDeleteFragmentShaderATI */);
}

static PFNGLDELETEFRAMEBUFFERSPROC
epoxy_glDeleteFramebuffers_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_framebuffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9061 /* "glDeleteFramebuffers" */,
        9061 /* "glDeleteFramebuffers" */,
        9061 /* "glDeleteFramebuffers" */,
        9082 /* "glDeleteFramebuffersEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9061 /* "glDeleteFramebuffers" */,
                                providers, entrypoints);
}

static PFNGLDELETEFRAMEBUFFERSEXTPROC
epoxy_glDeleteFramebuffersEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9082 /* "glDeleteFramebuffersEXT" */,
        9061 /* "glDeleteFramebuffers" */,
        9061 /* "glDeleteFramebuffers" */,
        9061 /* "glDeleteFramebuffers" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9082 /* "glDeleteFramebuffersEXT" */,
                                providers, entrypoints);
}

static PFNGLDELETEFRAMEBUFFERSOESPROC
epoxy_glDeleteFramebuffersOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_framebuffer_object, 9106 /* glDeleteFramebuffersOES */);
}

static PFNGLDELETELISTSPROC
epoxy_glDeleteLists_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 9130 /* glDeleteLists */);
}

static PFNGLDELETENAMEDSTRINGARBPROC
epoxy_glDeleteNamedStringARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_shading_language_include, 9144 /* glDeleteNamedStringARB */);
}

static PFNGLDELETENAMESAMDPROC
epoxy_glDeleteNamesAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_name_gen_delete, 9167 /* glDeleteNamesAMD */);
}

static PFNGLDELETEOBJECTARBPROC
epoxy_glDeleteObjectARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_shader_objects, 9184 /* glDeleteObjectARB */);
}

static PFNGLDELETEOCCLUSIONQUERIESNVPROC
epoxy_glDeleteOcclusionQueriesNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_occlusion_query, 9202 /* glDeleteOcclusionQueriesNV */);
}

static PFNGLDELETEPATHSNVPROC
epoxy_glDeletePathsNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 9229 /* glDeletePathsNV */);
}

static PFNGLDELETEPERFMONITORSAMDPROC
epoxy_glDeletePerfMonitorsAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_performance_monitor, 9245 /* glDeletePerfMonitorsAMD */);
}

static PFNGLDELETEPERFQUERYINTELPROC
epoxy_glDeletePerfQueryINTEL_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_INTEL_performance_query, 9269 /* glDeletePerfQueryINTEL */);
}

static PFNGLDELETEPROGRAMPROC
epoxy_glDeleteProgram_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9292 /* "glDeleteProgram" */,
        9292 /* "glDeleteProgram" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9292 /* "glDeleteProgram" */,
                                providers, entrypoints);
}

static PFNGLDELETEPROGRAMPIPELINESPROC
epoxy_glDeleteProgramPipelines_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_separate_shader_objects,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9308 /* "glDeleteProgramPipelines" */,
        9308 /* "glDeleteProgramPipelines" */,
        9308 /* "glDeleteProgramPipelines" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9308 /* "glDeleteProgramPipelines" */,
                                providers, entrypoints);
}

static PFNGLDELETEPROGRAMPIPELINESEXTPROC
epoxy_glDeleteProgramPipelinesEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_separate_shader_objects, 9333 /* glDeleteProgramPipelinesEXT */);
}

static PFNGLDELETEPROGRAMSARBPROC
epoxy_glDeleteProgramsARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_fragment_program,
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_NV_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9361 /* "glDeleteProgramsARB" */,
        9361 /* "glDeleteProgramsARB" */,
        9381 /* "glDeleteProgramsNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9361 /* "glDeleteProgramsARB" */,
                                providers, entrypoints);
}

static PFNGLDELETEPROGRAMSNVPROC
epoxy_glDeleteProgramsNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_vertex_program,
        GL_extension_GL_ARB_fragment_program,
        GL_extension_GL_ARB_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9381 /* "glDeleteProgramsNV" */,
        9361 /* "glDeleteProgramsARB" */,
        9361 /* "glDeleteProgramsARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9381 /* "glDeleteProgramsNV" */,
                                providers, entrypoints);
}

static PFNGLDELETEQUERIESPROC
epoxy_glDeleteQueries_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_occlusion_query,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9400 /* "glDeleteQueries" */,
        9400 /* "glDeleteQueries" */,
        9416 /* "glDeleteQueriesARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9400 /* "glDeleteQueries" */,
                                providers, entrypoints);
}

static PFNGLDELETEQUERIESARBPROC
epoxy_glDeleteQueriesARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_occlusion_query,
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9416 /* "glDeleteQueriesARB" */,
        9400 /* "glDeleteQueries" */,
        9400 /* "glDeleteQueries" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9416 /* "glDeleteQueriesARB" */,
                                providers, entrypoints);
}

static PFNGLDELETEQUERIESEXTPROC
epoxy_glDeleteQueriesEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_disjoint_timer_query,
        GL_extension_GL_EXT_occlusion_query_boolean,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9435 /* "glDeleteQueriesEXT" */,
        9435 /* "glDeleteQueriesEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9435 /* "glDeleteQueriesEXT" */,
                                providers, entrypoints);
}

static PFNGLDELETERENDERBUFFERSPROC
epoxy_glDeleteRenderbuffers_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_framebuffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9454 /* "glDeleteRenderbuffers" */,
        9454 /* "glDeleteRenderbuffers" */,
        9454 /* "glDeleteRenderbuffers" */,
        9476 /* "glDeleteRenderbuffersEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9454 /* "glDeleteRenderbuffers" */,
                                providers, entrypoints);
}

static PFNGLDELETERENDERBUFFERSEXTPROC
epoxy_glDeleteRenderbuffersEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9476 /* "glDeleteRenderbuffersEXT" */,
        9454 /* "glDeleteRenderbuffers" */,
        9454 /* "glDeleteRenderbuffers" */,
        9454 /* "glDeleteRenderbuffers" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9476 /* "glDeleteRenderbuffersEXT" */,
                                providers, entrypoints);
}

static PFNGLDELETERENDERBUFFERSOESPROC
epoxy_glDeleteRenderbuffersOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_framebuffer_object, 9501 /* glDeleteRenderbuffersOES */);
}

static PFNGLDELETESAMPLERSPROC
epoxy_glDeleteSamplers_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_sampler_objects,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9526 /* "glDeleteSamplers" */,
        9526 /* "glDeleteSamplers" */,
        9526 /* "glDeleteSamplers" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9526 /* "glDeleteSamplers" */,
                                providers, entrypoints);
}

static PFNGLDELETESHADERPROC
epoxy_glDeleteShader_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9543 /* "glDeleteShader" */,
        9543 /* "glDeleteShader" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9543 /* "glDeleteShader" */,
                                providers, entrypoints);
}

static PFNGLDELETESTATESNVPROC
epoxy_glDeleteStatesNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_command_list, 9558 /* glDeleteStatesNV */);
}

static PFNGLDELETESYNCPROC
epoxy_glDeleteSync_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_sync,
        OpenGL_ES_3_0,
        GL_extension_GL_APPLE_sync,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9575 /* "glDeleteSync" */,
        9575 /* "glDeleteSync" */,
        9575 /* "glDeleteSync" */,
        9588 /* "glDeleteSyncAPPLE" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9575 /* "glDeleteSync" */,
                                providers, entrypoints);
}

static PFNGLDELETESYNCAPPLEPROC
epoxy_glDeleteSyncAPPLE_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_APPLE_sync,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_sync,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9588 /* "glDeleteSyncAPPLE" */,
        9575 /* "glDeleteSync" */,
        9575 /* "glDeleteSync" */,
        9575 /* "glDeleteSync" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9588 /* "glDeleteSyncAPPLE" */,
                                providers, entrypoints);
}

static PFNGLDELETETEXTURESPROC
epoxy_glDeleteTextures_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_1,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9606 /* "glDeleteTextures" */,
        9606 /* "glDeleteTextures" */,
        9606 /* "glDeleteTextures" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9606 /* "glDeleteTextures" */,
                                providers, entrypoints);
}

static PFNGLDELETETEXTURESEXTPROC
epoxy_glDeleteTexturesEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_texture_object, 9623 /* glDeleteTexturesEXT */);
}

static PFNGLDELETETRANSFORMFEEDBACKSPROC
epoxy_glDeleteTransformFeedbacks_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_transform_feedback2,
        OpenGL_ES_3_0,
        GL_extension_GL_NV_transform_feedback2,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9643 /* "glDeleteTransformFeedbacks" */,
        9643 /* "glDeleteTransformFeedbacks" */,
        9643 /* "glDeleteTransformFeedbacks" */,
        9670 /* "glDeleteTransformFeedbacksNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9643 /* "glDeleteTransformFeedbacks" */,
                                providers, entrypoints);
}

static PFNGLDELETETRANSFORMFEEDBACKSNVPROC
epoxy_glDeleteTransformFeedbacksNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_transform_feedback2,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_transform_feedback2,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9670 /* "glDeleteTransformFeedbacksNV" */,
        9643 /* "glDeleteTransformFeedbacks" */,
        9643 /* "glDeleteTransformFeedbacks" */,
        9643 /* "glDeleteTransformFeedbacks" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9670 /* "glDeleteTransformFeedbacksNV" */,
                                providers, entrypoints);
}

static PFNGLDELETEVERTEXARRAYSPROC
epoxy_glDeleteVertexArrays_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_vertex_array_object,
        OpenGL_ES_3_0,
        GL_extension_GL_APPLE_vertex_array_object,
        GL_extension_GL_OES_vertex_array_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9699 /* "glDeleteVertexArrays" */,
        9699 /* "glDeleteVertexArrays" */,
        9699 /* "glDeleteVertexArrays" */,
        9720 /* "glDeleteVertexArraysAPPLE" */,
        9746 /* "glDeleteVertexArraysOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9699 /* "glDeleteVertexArrays" */,
                                providers, entrypoints);
}

static PFNGLDELETEVERTEXARRAYSAPPLEPROC
epoxy_glDeleteVertexArraysAPPLE_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_APPLE_vertex_array_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_vertex_array_object,
        OpenGL_ES_3_0,
        GL_extension_GL_OES_vertex_array_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9720 /* "glDeleteVertexArraysAPPLE" */,
        9699 /* "glDeleteVertexArrays" */,
        9699 /* "glDeleteVertexArrays" */,
        9699 /* "glDeleteVertexArrays" */,
        9746 /* "glDeleteVertexArraysOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9720 /* "glDeleteVertexArraysAPPLE" */,
                                providers, entrypoints);
}

static PFNGLDELETEVERTEXARRAYSOESPROC
epoxy_glDeleteVertexArraysOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_vertex_array_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_vertex_array_object,
        OpenGL_ES_3_0,
        GL_extension_GL_APPLE_vertex_array_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9746 /* "glDeleteVertexArraysOES" */,
        9699 /* "glDeleteVertexArrays" */,
        9699 /* "glDeleteVertexArrays" */,
        9699 /* "glDeleteVertexArrays" */,
        9720 /* "glDeleteVertexArraysAPPLE" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9746 /* "glDeleteVertexArraysOES" */,
                                providers, entrypoints);
}

static PFNGLDELETEVERTEXSHADEREXTPROC
epoxy_glDeleteVertexShaderEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 9770 /* glDeleteVertexShaderEXT */);
}

static PFNGLDEPTHBOUNDSEXTPROC
epoxy_glDepthBoundsEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_depth_bounds_test, 9794 /* glDepthBoundsEXT */);
}

static PFNGLDEPTHBOUNDSDNVPROC
epoxy_glDepthBoundsdNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_depth_buffer_float, 9811 /* glDepthBoundsdNV */);
}

static PFNGLDEPTHFUNCPROC
epoxy_glDepthFunc_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9828 /* "glDepthFunc" */,
        9828 /* "glDepthFunc" */,
        9828 /* "glDepthFunc" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9828 /* "glDepthFunc" */,
                                providers, entrypoints);
}

static PFNGLDEPTHMASKPROC
epoxy_glDepthMask_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9840 /* "glDepthMask" */,
        9840 /* "glDepthMask" */,
        9840 /* "glDepthMask" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9840 /* "glDepthMask" */,
                                providers, entrypoints);
}

static PFNGLDEPTHRANGEPROC
epoxy_glDepthRange_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 9852 /* glDepthRange */);
}

static PFNGLDEPTHRANGEARRAYFVNVPROC
epoxy_glDepthRangeArrayfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_viewport_array, 9865 /* glDepthRangeArrayfvNV */);
}

static PFNGLDEPTHRANGEARRAYVPROC
epoxy_glDepthRangeArrayv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_viewport_array,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9887 /* "glDepthRangeArrayv" */,
        9887 /* "glDepthRangeArrayv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9887 /* "glDepthRangeArrayv" */,
                                providers, entrypoints);
}

static PFNGLDEPTHRANGEINDEXEDPROC
epoxy_glDepthRangeIndexed_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_viewport_array,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9906 /* "glDepthRangeIndexed" */,
        9906 /* "glDepthRangeIndexed" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9906 /* "glDepthRangeIndexed" */,
                                providers, entrypoints);
}

static PFNGLDEPTHRANGEINDEXEDFNVPROC
epoxy_glDepthRangeIndexedfNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_viewport_array, 9926 /* glDepthRangeIndexedfNV */);
}

static PFNGLDEPTHRANGEDNVPROC
epoxy_glDepthRangedNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_depth_buffer_float, 9949 /* glDepthRangedNV */);
}

static PFNGLDEPTHRANGEFPROC
epoxy_glDepthRangef_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_ES2_compatibility,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_OES_single_precision,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9965 /* "glDepthRangef" */,
        9965 /* "glDepthRangef" */,
        9965 /* "glDepthRangef" */,
        9965 /* "glDepthRangef" */,
        9979 /* "glDepthRangefOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9965 /* "glDepthRangef" */,
                                providers, entrypoints);
}

static PFNGLDEPTHRANGEFOESPROC
epoxy_glDepthRangefOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_single_precision,
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_ES2_compatibility,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        9979 /* "glDepthRangefOES" */,
        9965 /* "glDepthRangef" */,
        9965 /* "glDepthRangef" */,
        9965 /* "glDepthRangef" */,
        9965 /* "glDepthRangef" */,
    };
    return gl_provider_resolver(entrypoint_strings + 9979 /* "glDepthRangefOES" */,
                                providers, entrypoints);
}

static PFNGLDEPTHRANGEXPROC
epoxy_glDepthRangex_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 9996 /* glDepthRangex */);
}

static PFNGLDEPTHRANGEXOESPROC
epoxy_glDepthRangexOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 10010 /* glDepthRangexOES */);
}

static PFNGLDETACHOBJECTARBPROC
epoxy_glDetachObjectARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_shader_objects,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10027 /* "glDetachObjectARB" */,
        10045 /* "glDetachShader" */,
        10045 /* "glDetachShader" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10027 /* "glDetachObjectARB" */,
                                providers, entrypoints);
}

static PFNGLDETACHSHADERPROC
epoxy_glDetachShader_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_shader_objects,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10045 /* "glDetachShader" */,
        10045 /* "glDetachShader" */,
        10027 /* "glDetachObjectARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10045 /* "glDetachShader" */,
                                providers, entrypoints);
}

static PFNGLDETAILTEXFUNCSGISPROC
epoxy_glDetailTexFuncSGIS_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIS_detail_texture, 10060 /* glDetailTexFuncSGIS */);
}

static PFNGLDISABLEPROC
epoxy_glDisable_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10080 /* "glDisable" */,
        10080 /* "glDisable" */,
        10080 /* "glDisable" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10080 /* "glDisable" */,
                                providers, entrypoints);
}

static PFNGLDISABLECLIENTSTATEPROC
epoxy_glDisableClientState_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_1,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10090 /* "glDisableClientState" */,
        10090 /* "glDisableClientState" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10090 /* "glDisableClientState" */,
                                providers, entrypoints);
}

static PFNGLDISABLECLIENTSTATEINDEXEDEXTPROC
epoxy_glDisableClientStateIndexedEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 10111 /* glDisableClientStateIndexedEXT */);
}

static PFNGLDISABLECLIENTSTATEIEXTPROC
epoxy_glDisableClientStateiEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 10142 /* glDisableClientStateiEXT */);
}

static PFNGLDISABLEDRIVERCONTROLQCOMPROC
epoxy_glDisableDriverControlQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_driver_control, 10167 /* glDisableDriverControlQCOM */);
}

static PFNGLDISABLEINDEXEDEXTPROC
epoxy_glDisableIndexedEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_NV_viewport_array,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10194 /* "glDisableIndexedEXT" */,
        10194 /* "glDisableIndexedEXT" */,
        10410 /* "glDisablei" */,
        10421 /* "glDisableiEXT" */,
        10435 /* "glDisableiNV" */,
        10448 /* "glDisableiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10194 /* "glDisableIndexedEXT" */,
                                providers, entrypoints);
}

static PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC
epoxy_glDisableVariantClientStateEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 10214 /* glDisableVariantClientStateEXT */);
}

static PFNGLDISABLEVERTEXARRAYATTRIBPROC
epoxy_glDisableVertexArrayAttrib_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10245 /* "glDisableVertexArrayAttrib" */,
        10245 /* "glDisableVertexArrayAttrib" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10245 /* "glDisableVertexArrayAttrib" */,
                                providers, entrypoints);
}

static PFNGLDISABLEVERTEXARRAYATTRIBEXTPROC
epoxy_glDisableVertexArrayAttribEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 10272 /* glDisableVertexArrayAttribEXT */);
}

static PFNGLDISABLEVERTEXARRAYEXTPROC
epoxy_glDisableVertexArrayEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 10302 /* glDisableVertexArrayEXT */);
}

static PFNGLDISABLEVERTEXATTRIBAPPLEPROC
epoxy_glDisableVertexAttribAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_vertex_program_evaluators, 10326 /* glDisableVertexAttribAPPLE */);
}

static PFNGLDISABLEVERTEXATTRIBARRAYPROC
epoxy_glDisableVertexAttribArray_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_ARB_vertex_shader,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10353 /* "glDisableVertexAttribArray" */,
        10353 /* "glDisableVertexAttribArray" */,
        10380 /* "glDisableVertexAttribArrayARB" */,
        10380 /* "glDisableVertexAttribArrayARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10353 /* "glDisableVertexAttribArray" */,
                                providers, entrypoints);
}

static PFNGLDISABLEVERTEXATTRIBARRAYARBPROC
epoxy_glDisableVertexAttribArrayARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_ARB_vertex_shader,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10380 /* "glDisableVertexAttribArrayARB" */,
        10380 /* "glDisableVertexAttribArrayARB" */,
        10353 /* "glDisableVertexAttribArray" */,
        10353 /* "glDisableVertexAttribArray" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10380 /* "glDisableVertexAttribArrayARB" */,
                                providers, entrypoints);
}

static PFNGLDISABLEIPROC
epoxy_glDisablei_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_NV_viewport_array,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10410 /* "glDisablei" */,
        10194 /* "glDisableIndexedEXT" */,
        10194 /* "glDisableIndexedEXT" */,
        10421 /* "glDisableiEXT" */,
        10435 /* "glDisableiNV" */,
        10448 /* "glDisableiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10410 /* "glDisablei" */,
                                providers, entrypoints);
}

static PFNGLDISABLEIEXTPROC
epoxy_glDisableiEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        GL_extension_GL_NV_viewport_array,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10421 /* "glDisableiEXT" */,
        10194 /* "glDisableIndexedEXT" */,
        10194 /* "glDisableIndexedEXT" */,
        10410 /* "glDisablei" */,
        10435 /* "glDisableiNV" */,
        10448 /* "glDisableiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10421 /* "glDisableiEXT" */,
                                providers, entrypoints);
}

static PFNGLDISABLEINVPROC
epoxy_glDisableiNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_viewport_array,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10435 /* "glDisableiNV" */,
        10194 /* "glDisableIndexedEXT" */,
        10194 /* "glDisableIndexedEXT" */,
        10410 /* "glDisablei" */,
        10421 /* "glDisableiEXT" */,
        10448 /* "glDisableiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10435 /* "glDisableiNV" */,
                                providers, entrypoints);
}

static PFNGLDISABLEIOESPROC
epoxy_glDisableiOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_draw_buffers_indexed,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_NV_viewport_array,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10448 /* "glDisableiOES" */,
        10194 /* "glDisableIndexedEXT" */,
        10194 /* "glDisableIndexedEXT" */,
        10410 /* "glDisablei" */,
        10421 /* "glDisableiEXT" */,
        10435 /* "glDisableiNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10448 /* "glDisableiOES" */,
                                providers, entrypoints);
}

static PFNGLDISCARDFRAMEBUFFEREXTPROC
epoxy_glDiscardFramebufferEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_discard_framebuffer, 10462 /* glDiscardFramebufferEXT */);
}

static PFNGLDISPATCHCOMPUTEPROC
epoxy_glDispatchCompute_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_compute_shader,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10486 /* "glDispatchCompute" */,
        10486 /* "glDispatchCompute" */,
        10486 /* "glDispatchCompute" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10486 /* "glDispatchCompute" */,
                                providers, entrypoints);
}

static PFNGLDISPATCHCOMPUTEGROUPSIZEARBPROC
epoxy_glDispatchComputeGroupSizeARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_compute_variable_group_size, 10504 /* glDispatchComputeGroupSizeARB */);
}

static PFNGLDISPATCHCOMPUTEINDIRECTPROC
epoxy_glDispatchComputeIndirect_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_compute_shader,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10534 /* "glDispatchComputeIndirect" */,
        10534 /* "glDispatchComputeIndirect" */,
        10534 /* "glDispatchComputeIndirect" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10534 /* "glDispatchComputeIndirect" */,
                                providers, entrypoints);
}

static PFNGLDRAWARRAYSPROC
epoxy_glDrawArrays_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_1,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_vertex_array,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10560 /* "glDrawArrays" */,
        10560 /* "glDrawArrays" */,
        10560 /* "glDrawArrays" */,
        10573 /* "glDrawArraysEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10560 /* "glDrawArrays" */,
                                providers, entrypoints);
}

static PFNGLDRAWARRAYSEXTPROC
epoxy_glDrawArraysEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_vertex_array,
        Desktop_OpenGL_1_1,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10573 /* "glDrawArraysEXT" */,
        10560 /* "glDrawArrays" */,
        10560 /* "glDrawArrays" */,
        10560 /* "glDrawArrays" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10573 /* "glDrawArraysEXT" */,
                                providers, entrypoints);
}

static PFNGLDRAWARRAYSINDIRECTPROC
epoxy_glDrawArraysIndirect_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_draw_indirect,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10589 /* "glDrawArraysIndirect" */,
        10589 /* "glDrawArraysIndirect" */,
        10589 /* "glDrawArraysIndirect" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10589 /* "glDrawArraysIndirect" */,
                                providers, entrypoints);
}

static PFNGLDRAWARRAYSINSTANCEDPROC
epoxy_glDrawArraysInstanced_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_1,
        OpenGL_ES_3_0,
        GL_extension_GL_ANGLE_instanced_arrays,
        GL_extension_GL_ARB_draw_instanced,
        GL_extension_GL_EXT_draw_instanced,
        GL_extension_GL_EXT_instanced_arrays,
        GL_extension_GL_NV_draw_instanced,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10610 /* "glDrawArraysInstanced" */,
        10610 /* "glDrawArraysInstanced" */,
        10632 /* "glDrawArraysInstancedANGLE" */,
        10659 /* "glDrawArraysInstancedARB" */,
        10755 /* "glDrawArraysInstancedEXT" */,
        10755 /* "glDrawArraysInstancedEXT" */,
        10780 /* "glDrawArraysInstancedNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10610 /* "glDrawArraysInstanced" */,
                                providers, entrypoints);
}

static PFNGLDRAWARRAYSINSTANCEDANGLEPROC
epoxy_glDrawArraysInstancedANGLE_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ANGLE_instanced_arrays,
        Desktop_OpenGL_3_1,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_draw_instanced,
        GL_extension_GL_EXT_draw_instanced,
        GL_extension_GL_EXT_instanced_arrays,
        GL_extension_GL_NV_draw_instanced,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10632 /* "glDrawArraysInstancedANGLE" */,
        10610 /* "glDrawArraysInstanced" */,
        10610 /* "glDrawArraysInstanced" */,
        10659 /* "glDrawArraysInstancedARB" */,
        10755 /* "glDrawArraysInstancedEXT" */,
        10755 /* "glDrawArraysInstancedEXT" */,
        10780 /* "glDrawArraysInstancedNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10632 /* "glDrawArraysInstancedANGLE" */,
                                providers, entrypoints);
}

static PFNGLDRAWARRAYSINSTANCEDARBPROC
epoxy_glDrawArraysInstancedARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_draw_instanced,
        Desktop_OpenGL_3_1,
        OpenGL_ES_3_0,
        GL_extension_GL_ANGLE_instanced_arrays,
        GL_extension_GL_EXT_draw_instanced,
        GL_extension_GL_EXT_instanced_arrays,
        GL_extension_GL_NV_draw_instanced,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10659 /* "glDrawArraysInstancedARB" */,
        10610 /* "glDrawArraysInstanced" */,
        10610 /* "glDrawArraysInstanced" */,
        10632 /* "glDrawArraysInstancedANGLE" */,
        10755 /* "glDrawArraysInstancedEXT" */,
        10755 /* "glDrawArraysInstancedEXT" */,
        10780 /* "glDrawArraysInstancedNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10659 /* "glDrawArraysInstancedARB" */,
                                providers, entrypoints);
}

static PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC
epoxy_glDrawArraysInstancedBaseInstance_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_2,
        GL_extension_GL_ARB_base_instance,
        GL_extension_GL_EXT_base_instance,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10684 /* "glDrawArraysInstancedBaseInstance" */,
        10684 /* "glDrawArraysInstancedBaseInstance" */,
        10718 /* "glDrawArraysInstancedBaseInstanceEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10684 /* "glDrawArraysInstancedBaseInstance" */,
                                providers, entrypoints);
}

static PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEEXTPROC
epoxy_glDrawArraysInstancedBaseInstanceEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_base_instance,
        Desktop_OpenGL_4_2,
        GL_extension_GL_ARB_base_instance,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10718 /* "glDrawArraysInstancedBaseInstanceEXT" */,
        10684 /* "glDrawArraysInstancedBaseInstance" */,
        10684 /* "glDrawArraysInstancedBaseInstance" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10718 /* "glDrawArraysInstancedBaseInstanceEXT" */,
                                providers, entrypoints);
}

static PFNGLDRAWARRAYSINSTANCEDEXTPROC
epoxy_glDrawArraysInstancedEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_instanced,
        GL_extension_GL_EXT_instanced_arrays,
        Desktop_OpenGL_3_1,
        OpenGL_ES_3_0,
        GL_extension_GL_ANGLE_instanced_arrays,
        GL_extension_GL_ARB_draw_instanced,
        GL_extension_GL_NV_draw_instanced,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10755 /* "glDrawArraysInstancedEXT" */,
        10755 /* "glDrawArraysInstancedEXT" */,
        10610 /* "glDrawArraysInstanced" */,
        10610 /* "glDrawArraysInstanced" */,
        10632 /* "glDrawArraysInstancedANGLE" */,
        10659 /* "glDrawArraysInstancedARB" */,
        10780 /* "glDrawArraysInstancedNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10755 /* "glDrawArraysInstancedEXT" */,
                                providers, entrypoints);
}

static PFNGLDRAWARRAYSINSTANCEDNVPROC
epoxy_glDrawArraysInstancedNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_draw_instanced,
        Desktop_OpenGL_3_1,
        OpenGL_ES_3_0,
        GL_extension_GL_ANGLE_instanced_arrays,
        GL_extension_GL_ARB_draw_instanced,
        GL_extension_GL_EXT_draw_instanced,
        GL_extension_GL_EXT_instanced_arrays,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10780 /* "glDrawArraysInstancedNV" */,
        10610 /* "glDrawArraysInstanced" */,
        10610 /* "glDrawArraysInstanced" */,
        10632 /* "glDrawArraysInstancedANGLE" */,
        10659 /* "glDrawArraysInstancedARB" */,
        10755 /* "glDrawArraysInstancedEXT" */,
        10755 /* "glDrawArraysInstancedEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10780 /* "glDrawArraysInstancedNV" */,
                                providers, entrypoints);
}

static PFNGLDRAWBUFFERPROC
epoxy_glDrawBuffer_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 10804 /* glDrawBuffer */);
}

static PFNGLDRAWBUFFERSPROC
epoxy_glDrawBuffers_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_draw_buffers,
        GL_extension_GL_ATI_draw_buffers,
        GL_extension_GL_EXT_draw_buffers,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10817 /* "glDrawBuffers" */,
        10817 /* "glDrawBuffers" */,
        10831 /* "glDrawBuffersARB" */,
        10848 /* "glDrawBuffersATI" */,
        10865 /* "glDrawBuffersEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10817 /* "glDrawBuffers" */,
                                providers, entrypoints);
}

static PFNGLDRAWBUFFERSARBPROC
epoxy_glDrawBuffersARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_draw_buffers,
        Desktop_OpenGL_2_0,
        OpenGL_ES_3_0,
        GL_extension_GL_ATI_draw_buffers,
        GL_extension_GL_EXT_draw_buffers,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10831 /* "glDrawBuffersARB" */,
        10817 /* "glDrawBuffers" */,
        10817 /* "glDrawBuffers" */,
        10848 /* "glDrawBuffersATI" */,
        10865 /* "glDrawBuffersEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10831 /* "glDrawBuffersARB" */,
                                providers, entrypoints);
}

static PFNGLDRAWBUFFERSATIPROC
epoxy_glDrawBuffersATI_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ATI_draw_buffers,
        Desktop_OpenGL_2_0,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_draw_buffers,
        GL_extension_GL_EXT_draw_buffers,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10848 /* "glDrawBuffersATI" */,
        10817 /* "glDrawBuffers" */,
        10817 /* "glDrawBuffers" */,
        10831 /* "glDrawBuffersARB" */,
        10865 /* "glDrawBuffersEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10848 /* "glDrawBuffersATI" */,
                                providers, entrypoints);
}

static PFNGLDRAWBUFFERSEXTPROC
epoxy_glDrawBuffersEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_buffers,
        Desktop_OpenGL_2_0,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_draw_buffers,
        GL_extension_GL_ATI_draw_buffers,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        10865 /* "glDrawBuffersEXT" */,
        10817 /* "glDrawBuffers" */,
        10817 /* "glDrawBuffers" */,
        10831 /* "glDrawBuffersARB" */,
        10848 /* "glDrawBuffersATI" */,
    };
    return gl_provider_resolver(entrypoint_strings + 10865 /* "glDrawBuffersEXT" */,
                                providers, entrypoints);
}

static PFNGLDRAWBUFFERSINDEXEDEXTPROC
epoxy_glDrawBuffersIndexedEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_multiview_draw_buffers, 10882 /* glDrawBuffersIndexedEXT */);
}

static PFNGLDRAWBUFFERSNVPROC
epoxy_glDrawBuffersNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_draw_buffers, 10906 /* glDrawBuffersNV */);
}

static PFNGLDRAWCOMMANDSADDRESSNVPROC
epoxy_glDrawCommandsAddressNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_command_list, 10922 /* glDrawCommandsAddressNV */);
}

static PFNGLDRAWCOMMANDSNVPROC
epoxy_glDrawCommandsNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_command_list, 10946 /* glDrawCommandsNV */);
}

static PFNGLDRAWCOMMANDSSTATESADDRESSNVPROC
epoxy_glDrawCommandsStatesAddressNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_command_list, 10963 /* glDrawCommandsStatesAddressNV */);
}

static PFNGLDRAWCOMMANDSSTATESNVPROC
epoxy_glDrawCommandsStatesNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_command_list, 10993 /* glDrawCommandsStatesNV */);
}

static PFNGLDRAWELEMENTARRAYAPPLEPROC
epoxy_glDrawElementArrayAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_element_array, 11016 /* glDrawElementArrayAPPLE */);
}

static PFNGLDRAWELEMENTARRAYATIPROC
epoxy_glDrawElementArrayATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_element_array, 11040 /* glDrawElementArrayATI */);
}

static PFNGLDRAWELEMENTSPROC
epoxy_glDrawElements_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_1,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11062 /* "glDrawElements" */,
        11062 /* "glDrawElements" */,
        11062 /* "glDrawElements" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11062 /* "glDrawElements" */,
                                providers, entrypoints);
}

static PFNGLDRAWELEMENTSBASEVERTEXPROC
epoxy_glDrawElementsBaseVertex_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_draw_elements_base_vertex,
        GL_extension_GL_EXT_draw_elements_base_vertex,
        GL_extension_GL_OES_draw_elements_base_vertex,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11077 /* "glDrawElementsBaseVertex" */,
        11077 /* "glDrawElementsBaseVertex" */,
        11102 /* "glDrawElementsBaseVertexEXT" */,
        11130 /* "glDrawElementsBaseVertexOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11077 /* "glDrawElementsBaseVertex" */,
                                providers, entrypoints);
}

static PFNGLDRAWELEMENTSBASEVERTEXEXTPROC
epoxy_glDrawElementsBaseVertexEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_elements_base_vertex,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_draw_elements_base_vertex,
        GL_extension_GL_OES_draw_elements_base_vertex,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11102 /* "glDrawElementsBaseVertexEXT" */,
        11077 /* "glDrawElementsBaseVertex" */,
        11077 /* "glDrawElementsBaseVertex" */,
        11130 /* "glDrawElementsBaseVertexOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11102 /* "glDrawElementsBaseVertexEXT" */,
                                providers, entrypoints);
}

static PFNGLDRAWELEMENTSBASEVERTEXOESPROC
epoxy_glDrawElementsBaseVertexOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_draw_elements_base_vertex,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_draw_elements_base_vertex,
        GL_extension_GL_EXT_draw_elements_base_vertex,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11130 /* "glDrawElementsBaseVertexOES" */,
        11077 /* "glDrawElementsBaseVertex" */,
        11077 /* "glDrawElementsBaseVertex" */,
        11102 /* "glDrawElementsBaseVertexEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11130 /* "glDrawElementsBaseVertexOES" */,
                                providers, entrypoints);
}

static PFNGLDRAWELEMENTSINDIRECTPROC
epoxy_glDrawElementsIndirect_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_draw_indirect,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11158 /* "glDrawElementsIndirect" */,
        11158 /* "glDrawElementsIndirect" */,
        11158 /* "glDrawElementsIndirect" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11158 /* "glDrawElementsIndirect" */,
                                providers, entrypoints);
}

static PFNGLDRAWELEMENTSINSTANCEDPROC
epoxy_glDrawElementsInstanced_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_1,
        OpenGL_ES_3_0,
        GL_extension_GL_ANGLE_instanced_arrays,
        GL_extension_GL_ARB_draw_instanced,
        GL_extension_GL_EXT_draw_instanced,
        GL_extension_GL_EXT_instanced_arrays,
        GL_extension_GL_NV_draw_instanced,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11181 /* "glDrawElementsInstanced" */,
        11181 /* "glDrawElementsInstanced" */,
        11205 /* "glDrawElementsInstancedANGLE" */,
        11234 /* "glDrawElementsInstancedARB" */,
        11539 /* "glDrawElementsInstancedEXT" */,
        11539 /* "glDrawElementsInstancedEXT" */,
        11566 /* "glDrawElementsInstancedNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11181 /* "glDrawElementsInstanced" */,
                                providers, entrypoints);
}

static PFNGLDRAWELEMENTSINSTANCEDANGLEPROC
epoxy_glDrawElementsInstancedANGLE_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ANGLE_instanced_arrays,
        Desktop_OpenGL_3_1,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_draw_instanced,
        GL_extension_GL_EXT_draw_instanced,
        GL_extension_GL_EXT_instanced_arrays,
        GL_extension_GL_NV_draw_instanced,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11205 /* "glDrawElementsInstancedANGLE" */,
        11181 /* "glDrawElementsInstanced" */,
        11181 /* "glDrawElementsInstanced" */,
        11234 /* "glDrawElementsInstancedARB" */,
        11539 /* "glDrawElementsInstancedEXT" */,
        11539 /* "glDrawElementsInstancedEXT" */,
        11566 /* "glDrawElementsInstancedNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11205 /* "glDrawElementsInstancedANGLE" */,
                                providers, entrypoints);
}

static PFNGLDRAWELEMENTSINSTANCEDARBPROC
epoxy_glDrawElementsInstancedARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_draw_instanced,
        Desktop_OpenGL_3_1,
        OpenGL_ES_3_0,
        GL_extension_GL_ANGLE_instanced_arrays,
        GL_extension_GL_EXT_draw_instanced,
        GL_extension_GL_EXT_instanced_arrays,
        GL_extension_GL_NV_draw_instanced,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11234 /* "glDrawElementsInstancedARB" */,
        11181 /* "glDrawElementsInstanced" */,
        11181 /* "glDrawElementsInstanced" */,
        11205 /* "glDrawElementsInstancedANGLE" */,
        11539 /* "glDrawElementsInstancedEXT" */,
        11539 /* "glDrawElementsInstancedEXT" */,
        11566 /* "glDrawElementsInstancedNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11234 /* "glDrawElementsInstancedARB" */,
                                providers, entrypoints);
}

static PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC
epoxy_glDrawElementsInstancedBaseInstance_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_2,
        GL_extension_GL_ARB_base_instance,
        GL_extension_GL_EXT_base_instance,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11261 /* "glDrawElementsInstancedBaseInstance" */,
        11261 /* "glDrawElementsInstancedBaseInstance" */,
        11297 /* "glDrawElementsInstancedBaseInstanceEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11261 /* "glDrawElementsInstancedBaseInstance" */,
                                providers, entrypoints);
}

static PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEEXTPROC
epoxy_glDrawElementsInstancedBaseInstanceEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_base_instance,
        Desktop_OpenGL_4_2,
        GL_extension_GL_ARB_base_instance,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11297 /* "glDrawElementsInstancedBaseInstanceEXT" */,
        11261 /* "glDrawElementsInstancedBaseInstance" */,
        11261 /* "glDrawElementsInstancedBaseInstance" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11297 /* "glDrawElementsInstancedBaseInstanceEXT" */,
                                providers, entrypoints);
}

static PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC
epoxy_glDrawElementsInstancedBaseVertex_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_draw_elements_base_vertex,
        GL_extension_GL_EXT_draw_elements_base_vertex,
        GL_extension_GL_OES_draw_elements_base_vertex,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11336 /* "glDrawElementsInstancedBaseVertex" */,
        11336 /* "glDrawElementsInstancedBaseVertex" */,
        11465 /* "glDrawElementsInstancedBaseVertexEXT" */,
        11502 /* "glDrawElementsInstancedBaseVertexOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11336 /* "glDrawElementsInstancedBaseVertex" */,
                                providers, entrypoints);
}

static PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC
epoxy_glDrawElementsInstancedBaseVertexBaseInstance_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_2,
        GL_extension_GL_ARB_base_instance,
        GL_extension_GL_EXT_base_instance,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11370 /* "glDrawElementsInstancedBaseVertexBaseInstance" */,
        11370 /* "glDrawElementsInstancedBaseVertexBaseInstance" */,
        11416 /* "glDrawElementsInstancedBaseVertexBaseInstanceEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11370 /* "glDrawElementsInstancedBaseVertexBaseInstance" */,
                                providers, entrypoints);
}

static PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEEXTPROC
epoxy_glDrawElementsInstancedBaseVertexBaseInstanceEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_base_instance,
        Desktop_OpenGL_4_2,
        GL_extension_GL_ARB_base_instance,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11416 /* "glDrawElementsInstancedBaseVertexBaseInstanceEXT" */,
        11370 /* "glDrawElementsInstancedBaseVertexBaseInstance" */,
        11370 /* "glDrawElementsInstancedBaseVertexBaseInstance" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11416 /* "glDrawElementsInstancedBaseVertexBaseInstanceEXT" */,
                                providers, entrypoints);
}

static PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXEXTPROC
epoxy_glDrawElementsInstancedBaseVertexEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_elements_base_vertex,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_draw_elements_base_vertex,
        GL_extension_GL_OES_draw_elements_base_vertex,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11465 /* "glDrawElementsInstancedBaseVertexEXT" */,
        11336 /* "glDrawElementsInstancedBaseVertex" */,
        11336 /* "glDrawElementsInstancedBaseVertex" */,
        11502 /* "glDrawElementsInstancedBaseVertexOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11465 /* "glDrawElementsInstancedBaseVertexEXT" */,
                                providers, entrypoints);
}

static PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXOESPROC
epoxy_glDrawElementsInstancedBaseVertexOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_draw_elements_base_vertex,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_draw_elements_base_vertex,
        GL_extension_GL_EXT_draw_elements_base_vertex,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11502 /* "glDrawElementsInstancedBaseVertexOES" */,
        11336 /* "glDrawElementsInstancedBaseVertex" */,
        11336 /* "glDrawElementsInstancedBaseVertex" */,
        11465 /* "glDrawElementsInstancedBaseVertexEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11502 /* "glDrawElementsInstancedBaseVertexOES" */,
                                providers, entrypoints);
}

static PFNGLDRAWELEMENTSINSTANCEDEXTPROC
epoxy_glDrawElementsInstancedEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_instanced,
        GL_extension_GL_EXT_instanced_arrays,
        Desktop_OpenGL_3_1,
        OpenGL_ES_3_0,
        GL_extension_GL_ANGLE_instanced_arrays,
        GL_extension_GL_ARB_draw_instanced,
        GL_extension_GL_NV_draw_instanced,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11539 /* "glDrawElementsInstancedEXT" */,
        11539 /* "glDrawElementsInstancedEXT" */,
        11181 /* "glDrawElementsInstanced" */,
        11181 /* "glDrawElementsInstanced" */,
        11205 /* "glDrawElementsInstancedANGLE" */,
        11234 /* "glDrawElementsInstancedARB" */,
        11566 /* "glDrawElementsInstancedNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11539 /* "glDrawElementsInstancedEXT" */,
                                providers, entrypoints);
}

static PFNGLDRAWELEMENTSINSTANCEDNVPROC
epoxy_glDrawElementsInstancedNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_draw_instanced,
        Desktop_OpenGL_3_1,
        OpenGL_ES_3_0,
        GL_extension_GL_ANGLE_instanced_arrays,
        GL_extension_GL_ARB_draw_instanced,
        GL_extension_GL_EXT_draw_instanced,
        GL_extension_GL_EXT_instanced_arrays,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11566 /* "glDrawElementsInstancedNV" */,
        11181 /* "glDrawElementsInstanced" */,
        11181 /* "glDrawElementsInstanced" */,
        11205 /* "glDrawElementsInstancedANGLE" */,
        11234 /* "glDrawElementsInstancedARB" */,
        11539 /* "glDrawElementsInstancedEXT" */,
        11539 /* "glDrawElementsInstancedEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11566 /* "glDrawElementsInstancedNV" */,
                                providers, entrypoints);
}

static PFNGLDRAWMESHARRAYSSUNPROC
epoxy_glDrawMeshArraysSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_mesh_array, 11592 /* glDrawMeshArraysSUN */);
}

static PFNGLDRAWPIXELSPROC
epoxy_glDrawPixels_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 11612 /* glDrawPixels */);
}

static PFNGLDRAWRANGEELEMENTARRAYAPPLEPROC
epoxy_glDrawRangeElementArrayAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_element_array, 11625 /* glDrawRangeElementArrayAPPLE */);
}

static PFNGLDRAWRANGEELEMENTARRAYATIPROC
epoxy_glDrawRangeElementArrayATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_element_array, 11654 /* glDrawRangeElementArrayATI */);
}

static PFNGLDRAWRANGEELEMENTSPROC
epoxy_glDrawRangeElements_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_2,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_draw_range_elements,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11681 /* "glDrawRangeElements" */,
        11681 /* "glDrawRangeElements" */,
        11797 /* "glDrawRangeElementsEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11681 /* "glDrawRangeElements" */,
                                providers, entrypoints);
}

static PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC
epoxy_glDrawRangeElementsBaseVertex_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_draw_elements_base_vertex,
        GL_extension_GL_EXT_draw_elements_base_vertex,
        GL_extension_GL_OES_draw_elements_base_vertex,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11701 /* "glDrawRangeElementsBaseVertex" */,
        11701 /* "glDrawRangeElementsBaseVertex" */,
        11731 /* "glDrawRangeElementsBaseVertexEXT" */,
        11764 /* "glDrawRangeElementsBaseVertexOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11701 /* "glDrawRangeElementsBaseVertex" */,
                                providers, entrypoints);
}

static PFNGLDRAWRANGEELEMENTSBASEVERTEXEXTPROC
epoxy_glDrawRangeElementsBaseVertexEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_elements_base_vertex,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_draw_elements_base_vertex,
        GL_extension_GL_OES_draw_elements_base_vertex,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11731 /* "glDrawRangeElementsBaseVertexEXT" */,
        11701 /* "glDrawRangeElementsBaseVertex" */,
        11701 /* "glDrawRangeElementsBaseVertex" */,
        11764 /* "glDrawRangeElementsBaseVertexOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11731 /* "glDrawRangeElementsBaseVertexEXT" */,
                                providers, entrypoints);
}

static PFNGLDRAWRANGEELEMENTSBASEVERTEXOESPROC
epoxy_glDrawRangeElementsBaseVertexOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_draw_elements_base_vertex,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_draw_elements_base_vertex,
        GL_extension_GL_EXT_draw_elements_base_vertex,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11764 /* "glDrawRangeElementsBaseVertexOES" */,
        11701 /* "glDrawRangeElementsBaseVertex" */,
        11701 /* "glDrawRangeElementsBaseVertex" */,
        11731 /* "glDrawRangeElementsBaseVertexEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11764 /* "glDrawRangeElementsBaseVertexOES" */,
                                providers, entrypoints);
}

static PFNGLDRAWRANGEELEMENTSEXTPROC
epoxy_glDrawRangeElementsEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_range_elements,
        Desktop_OpenGL_1_2,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11797 /* "glDrawRangeElementsEXT" */,
        11681 /* "glDrawRangeElements" */,
        11681 /* "glDrawRangeElements" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11797 /* "glDrawRangeElementsEXT" */,
                                providers, entrypoints);
}

static PFNGLDRAWTEXFOESPROC
epoxy_glDrawTexfOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_draw_texture, 11820 /* glDrawTexfOES */);
}

static PFNGLDRAWTEXFVOESPROC
epoxy_glDrawTexfvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_draw_texture, 11834 /* glDrawTexfvOES */);
}

static PFNGLDRAWTEXIOESPROC
epoxy_glDrawTexiOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_draw_texture, 11849 /* glDrawTexiOES */);
}

static PFNGLDRAWTEXIVOESPROC
epoxy_glDrawTexivOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_draw_texture, 11863 /* glDrawTexivOES */);
}

static PFNGLDRAWTEXSOESPROC
epoxy_glDrawTexsOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_draw_texture, 11878 /* glDrawTexsOES */);
}

static PFNGLDRAWTEXSVOESPROC
epoxy_glDrawTexsvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_draw_texture, 11892 /* glDrawTexsvOES */);
}

static PFNGLDRAWTEXTURENVPROC
epoxy_glDrawTextureNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_draw_texture, 11907 /* glDrawTextureNV */);
}

static PFNGLDRAWTEXXOESPROC
epoxy_glDrawTexxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_draw_texture, 11923 /* glDrawTexxOES */);
}

static PFNGLDRAWTEXXVOESPROC
epoxy_glDrawTexxvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_draw_texture, 11937 /* glDrawTexxvOES */);
}

static PFNGLDRAWTRANSFORMFEEDBACKPROC
epoxy_glDrawTransformFeedback_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_transform_feedback2,
        GL_extension_GL_NV_transform_feedback2,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11952 /* "glDrawTransformFeedback" */,
        11952 /* "glDrawTransformFeedback" */,
        12009 /* "glDrawTransformFeedbackNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11952 /* "glDrawTransformFeedback" */,
                                providers, entrypoints);
}

static PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC
epoxy_glDrawTransformFeedbackInstanced_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_2,
        GL_extension_GL_ARB_transform_feedback_instanced,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        11976 /* "glDrawTransformFeedbackInstanced" */,
        11976 /* "glDrawTransformFeedbackInstanced" */,
    };
    return gl_provider_resolver(entrypoint_strings + 11976 /* "glDrawTransformFeedbackInstanced" */,
                                providers, entrypoints);
}

static PFNGLDRAWTRANSFORMFEEDBACKNVPROC
epoxy_glDrawTransformFeedbackNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_transform_feedback2,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_transform_feedback2,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12009 /* "glDrawTransformFeedbackNV" */,
        11952 /* "glDrawTransformFeedback" */,
        11952 /* "glDrawTransformFeedback" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12009 /* "glDrawTransformFeedbackNV" */,
                                providers, entrypoints);
}

static PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC
epoxy_glDrawTransformFeedbackStream_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_transform_feedback3,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12035 /* "glDrawTransformFeedbackStream" */,
        12035 /* "glDrawTransformFeedbackStream" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12035 /* "glDrawTransformFeedbackStream" */,
                                providers, entrypoints);
}

static PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC
epoxy_glDrawTransformFeedbackStreamInstanced_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_2,
        GL_extension_GL_ARB_transform_feedback_instanced,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12065 /* "glDrawTransformFeedbackStreamInstanced" */,
        12065 /* "glDrawTransformFeedbackStreamInstanced" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12065 /* "glDrawTransformFeedbackStreamInstanced" */,
                                providers, entrypoints);
}

static PFNGLEGLIMAGETARGETRENDERBUFFERSTORAGEOESPROC
epoxy_glEGLImageTargetRenderbufferStorageOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_EGL_image, 12104 /* glEGLImageTargetRenderbufferStorageOES */);
}

static PFNGLEGLIMAGETARGETTEXTURE2DOESPROC
epoxy_glEGLImageTargetTexture2DOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_EGL_image, 12143 /* glEGLImageTargetTexture2DOES */);
}

static PFNGLEDGEFLAGPROC
epoxy_glEdgeFlag_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 12172 /* glEdgeFlag */);
}

static PFNGLEDGEFLAGFORMATNVPROC
epoxy_glEdgeFlagFormatNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_buffer_unified_memory, 12183 /* glEdgeFlagFormatNV */);
}

static PFNGLEDGEFLAGPOINTERPROC
epoxy_glEdgeFlagPointer_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_1, 12202 /* glEdgeFlagPointer */);
}

static PFNGLEDGEFLAGPOINTEREXTPROC
epoxy_glEdgeFlagPointerEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_array, 12220 /* glEdgeFlagPointerEXT */);
}

static PFNGLEDGEFLAGPOINTERLISTIBMPROC
epoxy_glEdgeFlagPointerListIBM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_IBM_vertex_array_lists, 12241 /* glEdgeFlagPointerListIBM */);
}

static PFNGLEDGEFLAGVPROC
epoxy_glEdgeFlagv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 12266 /* glEdgeFlagv */);
}

static PFNGLELEMENTPOINTERAPPLEPROC
epoxy_glElementPointerAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_element_array, 12278 /* glElementPointerAPPLE */);
}

static PFNGLELEMENTPOINTERATIPROC
epoxy_glElementPointerATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_element_array, 12300 /* glElementPointerATI */);
}

static PFNGLENABLEPROC
epoxy_glEnable_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12320 /* "glEnable" */,
        12320 /* "glEnable" */,
        12320 /* "glEnable" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12320 /* "glEnable" */,
                                providers, entrypoints);
}

static PFNGLENABLECLIENTSTATEPROC
epoxy_glEnableClientState_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_1,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12329 /* "glEnableClientState" */,
        12329 /* "glEnableClientState" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12329 /* "glEnableClientState" */,
                                providers, entrypoints);
}

static PFNGLENABLECLIENTSTATEINDEXEDEXTPROC
epoxy_glEnableClientStateIndexedEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 12349 /* glEnableClientStateIndexedEXT */);
}

static PFNGLENABLECLIENTSTATEIEXTPROC
epoxy_glEnableClientStateiEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 12379 /* glEnableClientStateiEXT */);
}

static PFNGLENABLEDRIVERCONTROLQCOMPROC
epoxy_glEnableDriverControlQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_driver_control, 12403 /* glEnableDriverControlQCOM */);
}

static PFNGLENABLEINDEXEDEXTPROC
epoxy_glEnableIndexedEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_NV_viewport_array,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12429 /* "glEnableIndexedEXT" */,
        12429 /* "glEnableIndexedEXT" */,
        12637 /* "glEnablei" */,
        12647 /* "glEnableiEXT" */,
        12660 /* "glEnableiNV" */,
        12672 /* "glEnableiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12429 /* "glEnableIndexedEXT" */,
                                providers, entrypoints);
}

static PFNGLENABLEVARIANTCLIENTSTATEEXTPROC
epoxy_glEnableVariantClientStateEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 12448 /* glEnableVariantClientStateEXT */);
}

static PFNGLENABLEVERTEXARRAYATTRIBPROC
epoxy_glEnableVertexArrayAttrib_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12478 /* "glEnableVertexArrayAttrib" */,
        12478 /* "glEnableVertexArrayAttrib" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12478 /* "glEnableVertexArrayAttrib" */,
                                providers, entrypoints);
}

static PFNGLENABLEVERTEXARRAYATTRIBEXTPROC
epoxy_glEnableVertexArrayAttribEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 12504 /* glEnableVertexArrayAttribEXT */);
}

static PFNGLENABLEVERTEXARRAYEXTPROC
epoxy_glEnableVertexArrayEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 12533 /* glEnableVertexArrayEXT */);
}

static PFNGLENABLEVERTEXATTRIBAPPLEPROC
epoxy_glEnableVertexAttribAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_vertex_program_evaluators, 12556 /* glEnableVertexAttribAPPLE */);
}

static PFNGLENABLEVERTEXATTRIBARRAYPROC
epoxy_glEnableVertexAttribArray_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_ARB_vertex_shader,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12582 /* "glEnableVertexAttribArray" */,
        12582 /* "glEnableVertexAttribArray" */,
        12608 /* "glEnableVertexAttribArrayARB" */,
        12608 /* "glEnableVertexAttribArrayARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12582 /* "glEnableVertexAttribArray" */,
                                providers, entrypoints);
}

static PFNGLENABLEVERTEXATTRIBARRAYARBPROC
epoxy_glEnableVertexAttribArrayARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_ARB_vertex_shader,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12608 /* "glEnableVertexAttribArrayARB" */,
        12608 /* "glEnableVertexAttribArrayARB" */,
        12582 /* "glEnableVertexAttribArray" */,
        12582 /* "glEnableVertexAttribArray" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12608 /* "glEnableVertexAttribArrayARB" */,
                                providers, entrypoints);
}

static PFNGLENABLEIPROC
epoxy_glEnablei_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_NV_viewport_array,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12637 /* "glEnablei" */,
        12429 /* "glEnableIndexedEXT" */,
        12429 /* "glEnableIndexedEXT" */,
        12647 /* "glEnableiEXT" */,
        12660 /* "glEnableiNV" */,
        12672 /* "glEnableiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12637 /* "glEnablei" */,
                                providers, entrypoints);
}

static PFNGLENABLEIEXTPROC
epoxy_glEnableiEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        GL_extension_GL_NV_viewport_array,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12647 /* "glEnableiEXT" */,
        12429 /* "glEnableIndexedEXT" */,
        12429 /* "glEnableIndexedEXT" */,
        12637 /* "glEnablei" */,
        12660 /* "glEnableiNV" */,
        12672 /* "glEnableiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12647 /* "glEnableiEXT" */,
                                providers, entrypoints);
}

static PFNGLENABLEINVPROC
epoxy_glEnableiNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_viewport_array,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12660 /* "glEnableiNV" */,
        12429 /* "glEnableIndexedEXT" */,
        12429 /* "glEnableIndexedEXT" */,
        12637 /* "glEnablei" */,
        12647 /* "glEnableiEXT" */,
        12672 /* "glEnableiOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12660 /* "glEnableiNV" */,
                                providers, entrypoints);
}

static PFNGLENABLEIOESPROC
epoxy_glEnableiOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_draw_buffers_indexed,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_NV_viewport_array,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12672 /* "glEnableiOES" */,
        12429 /* "glEnableIndexedEXT" */,
        12429 /* "glEnableIndexedEXT" */,
        12637 /* "glEnablei" */,
        12647 /* "glEnableiEXT" */,
        12660 /* "glEnableiNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12672 /* "glEnableiOES" */,
                                providers, entrypoints);
}

static PFNGLENDPROC
epoxy_glEnd_unwrapped_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 12685 /* glEnd */);
}

static PFNGLENDCONDITIONALRENDERPROC
epoxy_glEndConditionalRender_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_NV_conditional_render,
        GL_extension_GL_NVX_conditional_render,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12691 /* "glEndConditionalRender" */,
        12714 /* "glEndConditionalRenderNV" */,
        12739 /* "glEndConditionalRenderNVX" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12691 /* "glEndConditionalRender" */,
                                providers, entrypoints);
}

static PFNGLENDCONDITIONALRENDERNVPROC
epoxy_glEndConditionalRenderNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_conditional_render,
        Desktop_OpenGL_3_0,
        GL_extension_GL_NVX_conditional_render,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12714 /* "glEndConditionalRenderNV" */,
        12691 /* "glEndConditionalRender" */,
        12739 /* "glEndConditionalRenderNVX" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12714 /* "glEndConditionalRenderNV" */,
                                providers, entrypoints);
}

static PFNGLENDCONDITIONALRENDERNVXPROC
epoxy_glEndConditionalRenderNVX_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NVX_conditional_render,
        Desktop_OpenGL_3_0,
        GL_extension_GL_NV_conditional_render,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12739 /* "glEndConditionalRenderNVX" */,
        12691 /* "glEndConditionalRender" */,
        12714 /* "glEndConditionalRenderNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12739 /* "glEndConditionalRenderNVX" */,
                                providers, entrypoints);
}

static PFNGLENDFRAGMENTSHADERATIPROC
epoxy_glEndFragmentShaderATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_fragment_shader, 12765 /* glEndFragmentShaderATI */);
}

static PFNGLENDLISTPROC
epoxy_glEndList_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 12788 /* glEndList */);
}

static PFNGLENDOCCLUSIONQUERYNVPROC
epoxy_glEndOcclusionQueryNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_occlusion_query, 12798 /* glEndOcclusionQueryNV */);
}

static PFNGLENDPERFMONITORAMDPROC
epoxy_glEndPerfMonitorAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_performance_monitor, 12820 /* glEndPerfMonitorAMD */);
}

static PFNGLENDPERFQUERYINTELPROC
epoxy_glEndPerfQueryINTEL_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_INTEL_performance_query, 12840 /* glEndPerfQueryINTEL */);
}

static PFNGLENDQUERYPROC
epoxy_glEndQuery_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_occlusion_query,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12860 /* "glEndQuery" */,
        12860 /* "glEndQuery" */,
        12871 /* "glEndQueryARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12860 /* "glEndQuery" */,
                                providers, entrypoints);
}

static PFNGLENDQUERYARBPROC
epoxy_glEndQueryARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_occlusion_query,
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12871 /* "glEndQueryARB" */,
        12860 /* "glEndQuery" */,
        12860 /* "glEndQuery" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12871 /* "glEndQueryARB" */,
                                providers, entrypoints);
}

static PFNGLENDQUERYEXTPROC
epoxy_glEndQueryEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_disjoint_timer_query,
        GL_extension_GL_EXT_occlusion_query_boolean,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12885 /* "glEndQueryEXT" */,
        12885 /* "glEndQueryEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12885 /* "glEndQueryEXT" */,
                                providers, entrypoints);
}

static PFNGLENDQUERYINDEXEDPROC
epoxy_glEndQueryIndexed_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_transform_feedback3,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12899 /* "glEndQueryIndexed" */,
        12899 /* "glEndQueryIndexed" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12899 /* "glEndQueryIndexed" */,
                                providers, entrypoints);
}

static PFNGLENDTILINGQCOMPROC
epoxy_glEndTilingQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_tiled_rendering, 12917 /* glEndTilingQCOM */);
}

static PFNGLENDTRANSFORMFEEDBACKPROC
epoxy_glEndTransformFeedback_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_transform_feedback,
        GL_extension_GL_NV_transform_feedback,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12933 /* "glEndTransformFeedback" */,
        12933 /* "glEndTransformFeedback" */,
        12956 /* "glEndTransformFeedbackEXT" */,
        12982 /* "glEndTransformFeedbackNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12933 /* "glEndTransformFeedback" */,
                                providers, entrypoints);
}

static PFNGLENDTRANSFORMFEEDBACKEXTPROC
epoxy_glEndTransformFeedbackEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_transform_feedback,
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        GL_extension_GL_NV_transform_feedback,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12956 /* "glEndTransformFeedbackEXT" */,
        12933 /* "glEndTransformFeedback" */,
        12933 /* "glEndTransformFeedback" */,
        12982 /* "glEndTransformFeedbackNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12956 /* "glEndTransformFeedbackEXT" */,
                                providers, entrypoints);
}

static PFNGLENDTRANSFORMFEEDBACKNVPROC
epoxy_glEndTransformFeedbackNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_transform_feedback,
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_transform_feedback,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        12982 /* "glEndTransformFeedbackNV" */,
        12933 /* "glEndTransformFeedback" */,
        12933 /* "glEndTransformFeedback" */,
        12956 /* "glEndTransformFeedbackEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 12982 /* "glEndTransformFeedbackNV" */,
                                providers, entrypoints);
}

static PFNGLENDVERTEXSHADEREXTPROC
epoxy_glEndVertexShaderEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 13007 /* glEndVertexShaderEXT */);
}

static PFNGLENDVIDEOCAPTURENVPROC
epoxy_glEndVideoCaptureNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_video_capture, 13028 /* glEndVideoCaptureNV */);
}

static PFNGLEVALCOORD1DPROC
epoxy_glEvalCoord1d_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 13048 /* glEvalCoord1d */);
}

static PFNGLEVALCOORD1DVPROC
epoxy_glEvalCoord1dv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 13062 /* glEvalCoord1dv */);
}

static PFNGLEVALCOORD1FPROC
epoxy_glEvalCoord1f_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 13077 /* glEvalCoord1f */);
}

static PFNGLEVALCOORD1FVPROC
epoxy_glEvalCoord1fv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 13091 /* glEvalCoord1fv */);
}

static PFNGLEVALCOORD1XOESPROC
epoxy_glEvalCoord1xOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 13106 /* glEvalCoord1xOES */);
}

static PFNGLEVALCOORD1XVOESPROC
epoxy_glEvalCoord1xvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 13123 /* glEvalCoord1xvOES */);
}

static PFNGLEVALCOORD2DPROC
epoxy_glEvalCoord2d_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 13141 /* glEvalCoord2d */);
}

static PFNGLEVALCOORD2DVPROC
epoxy_glEvalCoord2dv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 13155 /* glEvalCoord2dv */);
}

static PFNGLEVALCOORD2FPROC
epoxy_glEvalCoord2f_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 13170 /* glEvalCoord2f */);
}

static PFNGLEVALCOORD2FVPROC
epoxy_glEvalCoord2fv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 13184 /* glEvalCoord2fv */);
}

static PFNGLEVALCOORD2XOESPROC
epoxy_glEvalCoord2xOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 13199 /* glEvalCoord2xOES */);
}

static PFNGLEVALCOORD2XVOESPROC
epoxy_glEvalCoord2xvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 13216 /* glEvalCoord2xvOES */);
}

static PFNGLEVALMAPSNVPROC
epoxy_glEvalMapsNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_evaluators, 13234 /* glEvalMapsNV */);
}

static PFNGLEVALMESH1PROC
epoxy_glEvalMesh1_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 13247 /* glEvalMesh1 */);
}

static PFNGLEVALMESH2PROC
epoxy_glEvalMesh2_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 13259 /* glEvalMesh2 */);
}

static PFNGLEVALPOINT1PROC
epoxy_glEvalPoint1_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 13271 /* glEvalPoint1 */);
}

static PFNGLEVALPOINT2PROC
epoxy_glEvalPoint2_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 13284 /* glEvalPoint2 */);
}

static PFNGLEXECUTEPROGRAMNVPROC
epoxy_glExecuteProgramNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_program, 13297 /* glExecuteProgramNV */);
}

static PFNGLEXTGETBUFFERPOINTERVQCOMPROC
epoxy_glExtGetBufferPointervQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_extended_get, 13316 /* glExtGetBufferPointervQCOM */);
}

static PFNGLEXTGETBUFFERSQCOMPROC
epoxy_glExtGetBuffersQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_extended_get, 13343 /* glExtGetBuffersQCOM */);
}

static PFNGLEXTGETFRAMEBUFFERSQCOMPROC
epoxy_glExtGetFramebuffersQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_extended_get, 13363 /* glExtGetFramebuffersQCOM */);
}

static PFNGLEXTGETPROGRAMBINARYSOURCEQCOMPROC
epoxy_glExtGetProgramBinarySourceQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_extended_get2, 13388 /* glExtGetProgramBinarySourceQCOM */);
}

static PFNGLEXTGETPROGRAMSQCOMPROC
epoxy_glExtGetProgramsQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_extended_get2, 13420 /* glExtGetProgramsQCOM */);
}

static PFNGLEXTGETRENDERBUFFERSQCOMPROC
epoxy_glExtGetRenderbuffersQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_extended_get, 13441 /* glExtGetRenderbuffersQCOM */);
}

static PFNGLEXTGETSHADERSQCOMPROC
epoxy_glExtGetShadersQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_extended_get2, 13467 /* glExtGetShadersQCOM */);
}

static PFNGLEXTGETTEXLEVELPARAMETERIVQCOMPROC
epoxy_glExtGetTexLevelParameterivQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_extended_get, 13487 /* glExtGetTexLevelParameterivQCOM */);
}

static PFNGLEXTGETTEXSUBIMAGEQCOMPROC
epoxy_glExtGetTexSubImageQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_extended_get, 13519 /* glExtGetTexSubImageQCOM */);
}

static PFNGLEXTGETTEXTURESQCOMPROC
epoxy_glExtGetTexturesQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_extended_get, 13543 /* glExtGetTexturesQCOM */);
}

static PFNGLEXTISPROGRAMBINARYQCOMPROC
epoxy_glExtIsProgramBinaryQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_extended_get2, 13564 /* glExtIsProgramBinaryQCOM */);
}

static PFNGLEXTTEXOBJECTSTATEOVERRIDEIQCOMPROC
epoxy_glExtTexObjectStateOverrideiQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_extended_get, 13589 /* glExtTexObjectStateOverrideiQCOM */);
}

static PFNGLEXTRACTCOMPONENTEXTPROC
epoxy_glExtractComponentEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 13622 /* glExtractComponentEXT */);
}

static PFNGLFEEDBACKBUFFERPROC
epoxy_glFeedbackBuffer_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 13644 /* glFeedbackBuffer */);
}

static PFNGLFEEDBACKBUFFERXOESPROC
epoxy_glFeedbackBufferxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 13661 /* glFeedbackBufferxOES */);
}

static PFNGLFENCESYNCPROC
epoxy_glFenceSync_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_sync,
        OpenGL_ES_3_0,
        GL_extension_GL_APPLE_sync,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        13682 /* "glFenceSync" */,
        13682 /* "glFenceSync" */,
        13682 /* "glFenceSync" */,
        13694 /* "glFenceSyncAPPLE" */,
    };
    return gl_provider_resolver(entrypoint_strings + 13682 /* "glFenceSync" */,
                                providers, entrypoints);
}

static PFNGLFENCESYNCAPPLEPROC
epoxy_glFenceSyncAPPLE_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_APPLE_sync,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_sync,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        13694 /* "glFenceSyncAPPLE" */,
        13682 /* "glFenceSync" */,
        13682 /* "glFenceSync" */,
        13682 /* "glFenceSync" */,
    };
    return gl_provider_resolver(entrypoint_strings + 13694 /* "glFenceSyncAPPLE" */,
                                providers, entrypoints);
}

static PFNGLFINALCOMBINERINPUTNVPROC
epoxy_glFinalCombinerInputNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_register_combiners, 13711 /* glFinalCombinerInputNV */);
}

static PFNGLFINISHPROC
epoxy_glFinish_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        13734 /* "glFinish" */,
        13734 /* "glFinish" */,
        13734 /* "glFinish" */,
    };
    return gl_provider_resolver(entrypoint_strings + 13734 /* "glFinish" */,
                                providers, entrypoints);
}

static PFNGLFINISHASYNCSGIXPROC
epoxy_glFinishAsyncSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_async, 13743 /* glFinishAsyncSGIX */);
}

static PFNGLFINISHFENCEAPPLEPROC
epoxy_glFinishFenceAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_fence, 13761 /* glFinishFenceAPPLE */);
}

static PFNGLFINISHFENCENVPROC
epoxy_glFinishFenceNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_fence, 13780 /* glFinishFenceNV */);
}

static PFNGLFINISHOBJECTAPPLEPROC
epoxy_glFinishObjectAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_fence, 13796 /* glFinishObjectAPPLE */);
}

static PFNGLFINISHTEXTURESUNXPROC
epoxy_glFinishTextureSUNX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUNX_constant_data, 13816 /* glFinishTextureSUNX */);
}

static PFNGLFLUSHPROC
epoxy_glFlush_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        13836 /* "glFlush" */,
        13836 /* "glFlush" */,
        13836 /* "glFlush" */,
    };
    return gl_provider_resolver(entrypoint_strings + 13836 /* "glFlush" */,
                                providers, entrypoints);
}

static PFNGLFLUSHMAPPEDBUFFERRANGEPROC
epoxy_glFlushMappedBufferRange_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_map_buffer_range,
        OpenGL_ES_3_0,
        GL_extension_GL_APPLE_flush_buffer_range,
        GL_extension_GL_EXT_map_buffer_range,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        13844 /* "glFlushMappedBufferRange" */,
        13844 /* "glFlushMappedBufferRange" */,
        13844 /* "glFlushMappedBufferRange" */,
        13869 /* "glFlushMappedBufferRangeAPPLE" */,
        13899 /* "glFlushMappedBufferRangeEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 13844 /* "glFlushMappedBufferRange" */,
                                providers, entrypoints);
}

static PFNGLFLUSHMAPPEDBUFFERRANGEAPPLEPROC
epoxy_glFlushMappedBufferRangeAPPLE_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_APPLE_flush_buffer_range,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_map_buffer_range,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_map_buffer_range,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        13869 /* "glFlushMappedBufferRangeAPPLE" */,
        13844 /* "glFlushMappedBufferRange" */,
        13844 /* "glFlushMappedBufferRange" */,
        13844 /* "glFlushMappedBufferRange" */,
        13899 /* "glFlushMappedBufferRangeEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 13869 /* "glFlushMappedBufferRangeAPPLE" */,
                                providers, entrypoints);
}

static PFNGLFLUSHMAPPEDBUFFERRANGEEXTPROC
epoxy_glFlushMappedBufferRangeEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_map_buffer_range,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_map_buffer_range,
        OpenGL_ES_3_0,
        GL_extension_GL_APPLE_flush_buffer_range,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        13899 /* "glFlushMappedBufferRangeEXT" */,
        13844 /* "glFlushMappedBufferRange" */,
        13844 /* "glFlushMappedBufferRange" */,
        13844 /* "glFlushMappedBufferRange" */,
        13869 /* "glFlushMappedBufferRangeAPPLE" */,
    };
    return gl_provider_resolver(entrypoint_strings + 13899 /* "glFlushMappedBufferRangeEXT" */,
                                providers, entrypoints);
}

static PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEPROC
epoxy_glFlushMappedNamedBufferRange_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        13927 /* "glFlushMappedNamedBufferRange" */,
        13927 /* "glFlushMappedNamedBufferRange" */,
    };
    return gl_provider_resolver(entrypoint_strings + 13927 /* "glFlushMappedNamedBufferRange" */,
                                providers, entrypoints);
}

static PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEEXTPROC
epoxy_glFlushMappedNamedBufferRangeEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 13957 /* glFlushMappedNamedBufferRangeEXT */);
}

static PFNGLFLUSHPIXELDATARANGENVPROC
epoxy_glFlushPixelDataRangeNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_pixel_data_range, 13990 /* glFlushPixelDataRangeNV */);
}

static PFNGLFLUSHRASTERSGIXPROC
epoxy_glFlushRasterSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_flush_raster, 14014 /* glFlushRasterSGIX */);
}

static PFNGLFLUSHSTATICDATAIBMPROC
epoxy_glFlushStaticDataIBM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_IBM_static_data, 14032 /* glFlushStaticDataIBM */);
}

static PFNGLFLUSHVERTEXARRAYRANGEAPPLEPROC
epoxy_glFlushVertexArrayRangeAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_vertex_array_range, 14053 /* glFlushVertexArrayRangeAPPLE */);
}

static PFNGLFLUSHVERTEXARRAYRANGENVPROC
epoxy_glFlushVertexArrayRangeNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_array_range, 14082 /* glFlushVertexArrayRangeNV */);
}

static PFNGLFOGCOORDFORMATNVPROC
epoxy_glFogCoordFormatNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_buffer_unified_memory, 14108 /* glFogCoordFormatNV */);
}

static PFNGLFOGCOORDPOINTERPROC
epoxy_glFogCoordPointer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_4,
        GL_extension_GL_EXT_fog_coord,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        14127 /* "glFogCoordPointer" */,
        14145 /* "glFogCoordPointerEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 14127 /* "glFogCoordPointer" */,
                                providers, entrypoints);
}

static PFNGLFOGCOORDPOINTEREXTPROC
epoxy_glFogCoordPointerEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_fog_coord,
        Desktop_OpenGL_1_4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        14145 /* "glFogCoordPointerEXT" */,
        14127 /* "glFogCoordPointer" */,
    };
    return gl_provider_resolver(entrypoint_strings + 14145 /* "glFogCoordPointerEXT" */,
                                providers, entrypoints);
}

static PFNGLFOGCOORDPOINTERLISTIBMPROC
epoxy_glFogCoordPointerListIBM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_IBM_vertex_array_lists, 14166 /* glFogCoordPointerListIBM */);
}

static PFNGLFOGCOORDDPROC
epoxy_glFogCoordd_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_4,
        GL_extension_GL_EXT_fog_coord,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        14191 /* "glFogCoordd" */,
        14203 /* "glFogCoorddEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 14191 /* "glFogCoordd" */,
                                providers, entrypoints);
}

static PFNGLFOGCOORDDEXTPROC
epoxy_glFogCoorddEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_fog_coord,
        Desktop_OpenGL_1_4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        14203 /* "glFogCoorddEXT" */,
        14191 /* "glFogCoordd" */,
    };
    return gl_provider_resolver(entrypoint_strings + 14203 /* "glFogCoorddEXT" */,
                                providers, entrypoints);
}

static PFNGLFOGCOORDDVPROC
epoxy_glFogCoorddv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_4,
        GL_extension_GL_EXT_fog_coord,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        14218 /* "glFogCoorddv" */,
        14231 /* "glFogCoorddvEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 14218 /* "glFogCoorddv" */,
                                providers, entrypoints);
}

static PFNGLFOGCOORDDVEXTPROC
epoxy_glFogCoorddvEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_fog_coord,
        Desktop_OpenGL_1_4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        14231 /* "glFogCoorddvEXT" */,
        14218 /* "glFogCoorddv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 14231 /* "glFogCoorddvEXT" */,
                                providers, entrypoints);
}

static PFNGLFOGCOORDFPROC
epoxy_glFogCoordf_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_4,
        GL_extension_GL_EXT_fog_coord,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        14247 /* "glFogCoordf" */,
        14259 /* "glFogCoordfEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 14247 /* "glFogCoordf" */,
                                providers, entrypoints);
}

static PFNGLFOGCOORDFEXTPROC
epoxy_glFogCoordfEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_fog_coord,
        Desktop_OpenGL_1_4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        14259 /* "glFogCoordfEXT" */,
        14247 /* "glFogCoordf" */,
    };
    return gl_provider_resolver(entrypoint_strings + 14259 /* "glFogCoordfEXT" */,
                                providers, entrypoints);
}

static PFNGLFOGCOORDFVPROC
epoxy_glFogCoordfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_4,
        GL_extension_GL_EXT_fog_coord,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        14274 /* "glFogCoordfv" */,
        14287 /* "glFogCoordfvEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 14274 /* "glFogCoordfv" */,
                                providers, entrypoints);
}

static PFNGLFOGCOORDFVEXTPROC
epoxy_glFogCoordfvEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_fog_coord,
        Desktop_OpenGL_1_4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        14287 /* "glFogCoordfvEXT" */,
        14274 /* "glFogCoordfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 14287 /* "glFogCoordfvEXT" */,
                                providers, entrypoints);
}

static PFNGLFOGCOORDHNVPROC
epoxy_glFogCoordhNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_half_float, 14303 /* glFogCoordhNV */);
}

static PFNGLFOGCOORDHVNVPROC
epoxy_glFogCoordhvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_half_float, 14317 /* glFogCoordhvNV */);
}

static PFNGLFOGFUNCSGISPROC
epoxy_glFogFuncSGIS_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIS_fog_function, 14332 /* glFogFuncSGIS */);
}

static PFNGLFOGFPROC
epoxy_glFogf_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        14346 /* "glFogf" */,
        14346 /* "glFogf" */,
    };
    return gl_provider_resolver(entrypoint_strings + 14346 /* "glFogf" */,
                                providers, entrypoints);
}

static PFNGLFOGFVPROC
epoxy_glFogfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        14353 /* "glFogfv" */,
        14353 /* "glFogfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 14353 /* "glFogfv" */,
                                providers, entrypoints);
}

static PFNGLFOGIPROC
epoxy_glFogi_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 14361 /* glFogi */);
}

static PFNGLFOGIVPROC
epoxy_glFogiv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 14368 /* glFogiv */);
}

static PFNGLFOGXPROC
epoxy_glFogx_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 14376 /* glFogx */);
}

static PFNGLFOGXOESPROC
epoxy_glFogxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 14383 /* glFogxOES */);
}

static PFNGLFOGXVPROC
epoxy_glFogxv_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 14393 /* glFogxv */);
}

static PFNGLFOGXVOESPROC
epoxy_glFogxvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 14401 /* glFogxvOES */);
}

static PFNGLFRAGMENTCOLORMATERIALSGIXPROC
epoxy_glFragmentColorMaterialSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 14412 /* glFragmentColorMaterialSGIX */);
}

static PFNGLFRAGMENTCOVERAGECOLORNVPROC
epoxy_glFragmentCoverageColorNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_fragment_coverage_to_color, 14440 /* glFragmentCoverageColorNV */);
}

static PFNGLFRAGMENTLIGHTMODELFSGIXPROC
epoxy_glFragmentLightModelfSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 14466 /* glFragmentLightModelfSGIX */);
}

static PFNGLFRAGMENTLIGHTMODELFVSGIXPROC
epoxy_glFragmentLightModelfvSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 14492 /* glFragmentLightModelfvSGIX */);
}

static PFNGLFRAGMENTLIGHTMODELISGIXPROC
epoxy_glFragmentLightModeliSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 14519 /* glFragmentLightModeliSGIX */);
}

static PFNGLFRAGMENTLIGHTMODELIVSGIXPROC
epoxy_glFragmentLightModelivSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 14545 /* glFragmentLightModelivSGIX */);
}

static PFNGLFRAGMENTLIGHTFSGIXPROC
epoxy_glFragmentLightfSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 14572 /* glFragmentLightfSGIX */);
}

static PFNGLFRAGMENTLIGHTFVSGIXPROC
epoxy_glFragmentLightfvSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 14593 /* glFragmentLightfvSGIX */);
}

static PFNGLFRAGMENTLIGHTISGIXPROC
epoxy_glFragmentLightiSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 14615 /* glFragmentLightiSGIX */);
}

static PFNGLFRAGMENTLIGHTIVSGIXPROC
epoxy_glFragmentLightivSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 14636 /* glFragmentLightivSGIX */);
}

static PFNGLFRAGMENTMATERIALFSGIXPROC
epoxy_glFragmentMaterialfSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 14658 /* glFragmentMaterialfSGIX */);
}

static PFNGLFRAGMENTMATERIALFVSGIXPROC
epoxy_glFragmentMaterialfvSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 14682 /* glFragmentMaterialfvSGIX */);
}

static PFNGLFRAGMENTMATERIALISGIXPROC
epoxy_glFragmentMaterialiSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 14707 /* glFragmentMaterialiSGIX */);
}

static PFNGLFRAGMENTMATERIALIVSGIXPROC
epoxy_glFragmentMaterialivSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 14731 /* glFragmentMaterialivSGIX */);
}

static PFNGLFRAMETERMINATORGREMEDYPROC
epoxy_glFrameTerminatorGREMEDY_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_GREMEDY_frame_terminator, 14756 /* glFrameTerminatorGREMEDY */);
}

static PFNGLFRAMEZOOMSGIXPROC
epoxy_glFrameZoomSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_framezoom, 14781 /* glFrameZoomSGIX */);
}

static PFNGLFRAMEBUFFERDRAWBUFFEREXTPROC
epoxy_glFramebufferDrawBufferEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 14797 /* glFramebufferDrawBufferEXT */);
}

static PFNGLFRAMEBUFFERDRAWBUFFERSEXTPROC
epoxy_glFramebufferDrawBuffersEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 14824 /* glFramebufferDrawBuffersEXT */);
}

static PFNGLFRAMEBUFFERPARAMETERIPROC
epoxy_glFramebufferParameteri_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_framebuffer_no_attachments,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        14852 /* "glFramebufferParameteri" */,
        14852 /* "glFramebufferParameteri" */,
        14852 /* "glFramebufferParameteri" */,
    };
    return gl_provider_resolver(entrypoint_strings + 14852 /* "glFramebufferParameteri" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERREADBUFFEREXTPROC
epoxy_glFramebufferReadBufferEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 14876 /* glFramebufferReadBufferEXT */);
}

static PFNGLFRAMEBUFFERRENDERBUFFERPROC
epoxy_glFramebufferRenderbuffer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_framebuffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        14903 /* "glFramebufferRenderbuffer" */,
        14903 /* "glFramebufferRenderbuffer" */,
        14903 /* "glFramebufferRenderbuffer" */,
        14929 /* "glFramebufferRenderbufferEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 14903 /* "glFramebufferRenderbuffer" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC
epoxy_glFramebufferRenderbufferEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        14929 /* "glFramebufferRenderbufferEXT" */,
        14903 /* "glFramebufferRenderbuffer" */,
        14903 /* "glFramebufferRenderbuffer" */,
        14903 /* "glFramebufferRenderbuffer" */,
    };
    return gl_provider_resolver(entrypoint_strings + 14929 /* "glFramebufferRenderbufferEXT" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERRENDERBUFFEROESPROC
epoxy_glFramebufferRenderbufferOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_framebuffer_object, 14958 /* glFramebufferRenderbufferOES */);
}

static PFNGLFRAMEBUFFERSAMPLELOCATIONSFVNVPROC
epoxy_glFramebufferSampleLocationsfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_sample_locations, 14987 /* glFramebufferSampleLocationsfvNV */);
}

static PFNGLFRAMEBUFFERTEXTUREPROC
epoxy_glFramebufferTexture_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_geometry_shader4,
        GL_extension_GL_EXT_geometry_shader,
        GL_extension_GL_NV_geometry_program4,
        GL_extension_GL_OES_geometry_shader,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15020 /* "glFramebufferTexture" */,
        15314 /* "glFramebufferTextureARB" */,
        15338 /* "glFramebufferTextureEXT" */,
        15338 /* "glFramebufferTextureEXT" */,
        15535 /* "glFramebufferTextureOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15020 /* "glFramebufferTexture" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERTEXTURE1DPROC
epoxy_glFramebufferTexture1D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        GL_extension_GL_EXT_framebuffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15041 /* "glFramebufferTexture1D" */,
        15041 /* "glFramebufferTexture1D" */,
        15064 /* "glFramebufferTexture1DEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15041 /* "glFramebufferTexture1D" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERTEXTURE1DEXTPROC
epoxy_glFramebufferTexture1DEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15064 /* "glFramebufferTexture1DEXT" */,
        15041 /* "glFramebufferTexture1D" */,
        15041 /* "glFramebufferTexture1D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15064 /* "glFramebufferTexture1DEXT" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERTEXTURE2DPROC
epoxy_glFramebufferTexture2D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_framebuffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15090 /* "glFramebufferTexture2D" */,
        15090 /* "glFramebufferTexture2D" */,
        15090 /* "glFramebufferTexture2D" */,
        15113 /* "glFramebufferTexture2DEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15090 /* "glFramebufferTexture2D" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERTEXTURE2DEXTPROC
epoxy_glFramebufferTexture2DEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15113 /* "glFramebufferTexture2DEXT" */,
        15090 /* "glFramebufferTexture2D" */,
        15090 /* "glFramebufferTexture2D" */,
        15090 /* "glFramebufferTexture2D" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15113 /* "glFramebufferTexture2DEXT" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERTEXTURE2DMULTISAMPLEEXTPROC
epoxy_glFramebufferTexture2DMultisampleEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_multisampled_render_to_texture, 15139 /* glFramebufferTexture2DMultisampleEXT */);
}

static PFNGLFRAMEBUFFERTEXTURE2DMULTISAMPLEIMGPROC
epoxy_glFramebufferTexture2DMultisampleIMG_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_IMG_multisampled_render_to_texture, 15176 /* glFramebufferTexture2DMultisampleIMG */);
}

static PFNGLFRAMEBUFFERTEXTURE2DOESPROC
epoxy_glFramebufferTexture2DOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_framebuffer_object, 15213 /* glFramebufferTexture2DOES */);
}

static PFNGLFRAMEBUFFERTEXTURE3DPROC
epoxy_glFramebufferTexture3D_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        GL_extension_GL_EXT_framebuffer_object,
        GL_extension_GL_OES_texture_3D,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15239 /* "glFramebufferTexture3D" */,
        15239 /* "glFramebufferTexture3D" */,
        15262 /* "glFramebufferTexture3DEXT" */,
        15288 /* "glFramebufferTexture3DOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15239 /* "glFramebufferTexture3D" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERTEXTURE3DEXTPROC
epoxy_glFramebufferTexture3DEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        GL_extension_GL_OES_texture_3D,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15262 /* "glFramebufferTexture3DEXT" */,
        15239 /* "glFramebufferTexture3D" */,
        15239 /* "glFramebufferTexture3D" */,
        15288 /* "glFramebufferTexture3DOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15262 /* "glFramebufferTexture3DEXT" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERTEXTURE3DOESPROC
epoxy_glFramebufferTexture3DOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_texture_3D,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        GL_extension_GL_EXT_framebuffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15288 /* "glFramebufferTexture3DOES" */,
        15239 /* "glFramebufferTexture3D" */,
        15239 /* "glFramebufferTexture3D" */,
        15262 /* "glFramebufferTexture3DEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15288 /* "glFramebufferTexture3DOES" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERTEXTUREARBPROC
epoxy_glFramebufferTextureARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_geometry_shader4,
        Desktop_OpenGL_3_2,
        GL_extension_GL_EXT_geometry_shader,
        GL_extension_GL_NV_geometry_program4,
        GL_extension_GL_OES_geometry_shader,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15314 /* "glFramebufferTextureARB" */,
        15020 /* "glFramebufferTexture" */,
        15338 /* "glFramebufferTextureEXT" */,
        15338 /* "glFramebufferTextureEXT" */,
        15535 /* "glFramebufferTextureOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15314 /* "glFramebufferTextureARB" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERTEXTUREEXTPROC
epoxy_glFramebufferTextureEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_geometry_shader,
        GL_extension_GL_NV_geometry_program4,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_geometry_shader4,
        GL_extension_GL_OES_geometry_shader,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15338 /* "glFramebufferTextureEXT" */,
        15338 /* "glFramebufferTextureEXT" */,
        15020 /* "glFramebufferTexture" */,
        15314 /* "glFramebufferTextureARB" */,
        15535 /* "glFramebufferTextureOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15338 /* "glFramebufferTextureEXT" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERTEXTUREFACEARBPROC
epoxy_glFramebufferTextureFaceARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_geometry_shader4,
        GL_extension_GL_NV_geometry_program4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15362 /* "glFramebufferTextureFaceARB" */,
        15390 /* "glFramebufferTextureFaceEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15362 /* "glFramebufferTextureFaceARB" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERTEXTUREFACEEXTPROC
epoxy_glFramebufferTextureFaceEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_geometry_program4,
        GL_extension_GL_ARB_geometry_shader4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15390 /* "glFramebufferTextureFaceEXT" */,
        15362 /* "glFramebufferTextureFaceARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15390 /* "glFramebufferTextureFaceEXT" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERTEXTURELAYERPROC
epoxy_glFramebufferTextureLayer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_geometry_shader4,
        GL_extension_GL_EXT_texture_array,
        GL_extension_GL_NV_geometry_program4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15418 /* "glFramebufferTextureLayer" */,
        15418 /* "glFramebufferTextureLayer" */,
        15418 /* "glFramebufferTextureLayer" */,
        15444 /* "glFramebufferTextureLayerARB" */,
        15473 /* "glFramebufferTextureLayerEXT" */,
        15473 /* "glFramebufferTextureLayerEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15418 /* "glFramebufferTextureLayer" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERTEXTURELAYERARBPROC
epoxy_glFramebufferTextureLayerARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_geometry_shader4,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_texture_array,
        GL_extension_GL_NV_geometry_program4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15444 /* "glFramebufferTextureLayerARB" */,
        15418 /* "glFramebufferTextureLayer" */,
        15418 /* "glFramebufferTextureLayer" */,
        15418 /* "glFramebufferTextureLayer" */,
        15473 /* "glFramebufferTextureLayerEXT" */,
        15473 /* "glFramebufferTextureLayerEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15444 /* "glFramebufferTextureLayerARB" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERTEXTURELAYEREXTPROC
epoxy_glFramebufferTextureLayerEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_texture_array,
        GL_extension_GL_NV_geometry_program4,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_geometry_shader4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15473 /* "glFramebufferTextureLayerEXT" */,
        15473 /* "glFramebufferTextureLayerEXT" */,
        15418 /* "glFramebufferTextureLayer" */,
        15418 /* "glFramebufferTextureLayer" */,
        15418 /* "glFramebufferTextureLayer" */,
        15444 /* "glFramebufferTextureLayerARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15473 /* "glFramebufferTextureLayerEXT" */,
                                providers, entrypoints);
}

static PFNGLFRAMEBUFFERTEXTUREMULTIVIEWOVRPROC
epoxy_glFramebufferTextureMultiviewOVR_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OVR_multiview, 15502 /* glFramebufferTextureMultiviewOVR */);
}

static PFNGLFRAMEBUFFERTEXTUREOESPROC
epoxy_glFramebufferTextureOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_geometry_shader,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_geometry_shader4,
        GL_extension_GL_EXT_geometry_shader,
        GL_extension_GL_NV_geometry_program4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15535 /* "glFramebufferTextureOES" */,
        15020 /* "glFramebufferTexture" */,
        15314 /* "glFramebufferTextureARB" */,
        15338 /* "glFramebufferTextureEXT" */,
        15338 /* "glFramebufferTextureEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15535 /* "glFramebufferTextureOES" */,
                                providers, entrypoints);
}

static PFNGLFREEOBJECTBUFFERATIPROC
epoxy_glFreeObjectBufferATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_vertex_array_object, 15559 /* glFreeObjectBufferATI */);
}

static PFNGLFRONTFACEPROC
epoxy_glFrontFace_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15581 /* "glFrontFace" */,
        15581 /* "glFrontFace" */,
        15581 /* "glFrontFace" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15581 /* "glFrontFace" */,
                                providers, entrypoints);
}

static PFNGLFRUSTUMPROC
epoxy_glFrustum_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 15593 /* glFrustum */);
}

static PFNGLFRUSTUMFPROC
epoxy_glFrustumf_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 15603 /* glFrustumf */);
}

static PFNGLFRUSTUMFOESPROC
epoxy_glFrustumfOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_single_precision, 15614 /* glFrustumfOES */);
}

static PFNGLFRUSTUMXPROC
epoxy_glFrustumx_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 15628 /* glFrustumx */);
}

static PFNGLFRUSTUMXOESPROC
epoxy_glFrustumxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 15639 /* glFrustumxOES */);
}

static PFNGLGENASYNCMARKERSSGIXPROC
epoxy_glGenAsyncMarkersSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_async, 15653 /* glGenAsyncMarkersSGIX */);
}

static PFNGLGENBUFFERSPROC
epoxy_glGenBuffers_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_buffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15675 /* "glGenBuffers" */,
        15675 /* "glGenBuffers" */,
        15675 /* "glGenBuffers" */,
        15688 /* "glGenBuffersARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15675 /* "glGenBuffers" */,
                                providers, entrypoints);
}

static PFNGLGENBUFFERSARBPROC
epoxy_glGenBuffersARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_buffer_object,
        Desktop_OpenGL_1_5,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15688 /* "glGenBuffersARB" */,
        15675 /* "glGenBuffers" */,
        15675 /* "glGenBuffers" */,
        15675 /* "glGenBuffers" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15688 /* "glGenBuffersARB" */,
                                providers, entrypoints);
}

static PFNGLGENFENCESAPPLEPROC
epoxy_glGenFencesAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_fence, 15704 /* glGenFencesAPPLE */);
}

static PFNGLGENFENCESNVPROC
epoxy_glGenFencesNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_fence, 15721 /* glGenFencesNV */);
}

static PFNGLGENFRAGMENTSHADERSATIPROC
epoxy_glGenFragmentShadersATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_fragment_shader, 15735 /* glGenFragmentShadersATI */);
}

static PFNGLGENFRAMEBUFFERSPROC
epoxy_glGenFramebuffers_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_framebuffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15759 /* "glGenFramebuffers" */,
        15759 /* "glGenFramebuffers" */,
        15759 /* "glGenFramebuffers" */,
        15777 /* "glGenFramebuffersEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15759 /* "glGenFramebuffers" */,
                                providers, entrypoints);
}

static PFNGLGENFRAMEBUFFERSEXTPROC
epoxy_glGenFramebuffersEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15777 /* "glGenFramebuffersEXT" */,
        15759 /* "glGenFramebuffers" */,
        15759 /* "glGenFramebuffers" */,
        15759 /* "glGenFramebuffers" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15777 /* "glGenFramebuffersEXT" */,
                                providers, entrypoints);
}

static PFNGLGENFRAMEBUFFERSOESPROC
epoxy_glGenFramebuffersOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_framebuffer_object, 15798 /* glGenFramebuffersOES */);
}

static PFNGLGENLISTSPROC
epoxy_glGenLists_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 15819 /* glGenLists */);
}

static PFNGLGENNAMESAMDPROC
epoxy_glGenNamesAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_name_gen_delete, 15830 /* glGenNamesAMD */);
}

static PFNGLGENOCCLUSIONQUERIESNVPROC
epoxy_glGenOcclusionQueriesNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_occlusion_query, 15844 /* glGenOcclusionQueriesNV */);
}

static PFNGLGENPATHSNVPROC
epoxy_glGenPathsNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 15868 /* glGenPathsNV */);
}

static PFNGLGENPERFMONITORSAMDPROC
epoxy_glGenPerfMonitorsAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_performance_monitor, 15881 /* glGenPerfMonitorsAMD */);
}

static PFNGLGENPROGRAMPIPELINESPROC
epoxy_glGenProgramPipelines_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_separate_shader_objects,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15902 /* "glGenProgramPipelines" */,
        15902 /* "glGenProgramPipelines" */,
        15902 /* "glGenProgramPipelines" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15902 /* "glGenProgramPipelines" */,
                                providers, entrypoints);
}

static PFNGLGENPROGRAMPIPELINESEXTPROC
epoxy_glGenProgramPipelinesEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_separate_shader_objects, 15924 /* glGenProgramPipelinesEXT */);
}

static PFNGLGENPROGRAMSARBPROC
epoxy_glGenProgramsARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_fragment_program,
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_NV_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15949 /* "glGenProgramsARB" */,
        15949 /* "glGenProgramsARB" */,
        15966 /* "glGenProgramsNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15949 /* "glGenProgramsARB" */,
                                providers, entrypoints);
}

static PFNGLGENPROGRAMSNVPROC
epoxy_glGenProgramsNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_vertex_program,
        GL_extension_GL_ARB_fragment_program,
        GL_extension_GL_ARB_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15966 /* "glGenProgramsNV" */,
        15949 /* "glGenProgramsARB" */,
        15949 /* "glGenProgramsARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15966 /* "glGenProgramsNV" */,
                                providers, entrypoints);
}

static PFNGLGENQUERIESPROC
epoxy_glGenQueries_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_occlusion_query,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15982 /* "glGenQueries" */,
        15982 /* "glGenQueries" */,
        15995 /* "glGenQueriesARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15982 /* "glGenQueries" */,
                                providers, entrypoints);
}

static PFNGLGENQUERIESARBPROC
epoxy_glGenQueriesARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_occlusion_query,
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        15995 /* "glGenQueriesARB" */,
        15982 /* "glGenQueries" */,
        15982 /* "glGenQueries" */,
    };
    return gl_provider_resolver(entrypoint_strings + 15995 /* "glGenQueriesARB" */,
                                providers, entrypoints);
}

static PFNGLGENQUERIESEXTPROC
epoxy_glGenQueriesEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_disjoint_timer_query,
        GL_extension_GL_EXT_occlusion_query_boolean,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16011 /* "glGenQueriesEXT" */,
        16011 /* "glGenQueriesEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16011 /* "glGenQueriesEXT" */,
                                providers, entrypoints);
}

static PFNGLGENRENDERBUFFERSPROC
epoxy_glGenRenderbuffers_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_framebuffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16027 /* "glGenRenderbuffers" */,
        16027 /* "glGenRenderbuffers" */,
        16027 /* "glGenRenderbuffers" */,
        16046 /* "glGenRenderbuffersEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16027 /* "glGenRenderbuffers" */,
                                providers, entrypoints);
}

static PFNGLGENRENDERBUFFERSEXTPROC
epoxy_glGenRenderbuffersEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16046 /* "glGenRenderbuffersEXT" */,
        16027 /* "glGenRenderbuffers" */,
        16027 /* "glGenRenderbuffers" */,
        16027 /* "glGenRenderbuffers" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16046 /* "glGenRenderbuffersEXT" */,
                                providers, entrypoints);
}

static PFNGLGENRENDERBUFFERSOESPROC
epoxy_glGenRenderbuffersOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_framebuffer_object, 16068 /* glGenRenderbuffersOES */);
}

static PFNGLGENSAMPLERSPROC
epoxy_glGenSamplers_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_sampler_objects,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16090 /* "glGenSamplers" */,
        16090 /* "glGenSamplers" */,
        16090 /* "glGenSamplers" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16090 /* "glGenSamplers" */,
                                providers, entrypoints);
}

static PFNGLGENSYMBOLSEXTPROC
epoxy_glGenSymbolsEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 16104 /* glGenSymbolsEXT */);
}

static PFNGLGENTEXTURESPROC
epoxy_glGenTextures_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_1,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16120 /* "glGenTextures" */,
        16120 /* "glGenTextures" */,
        16120 /* "glGenTextures" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16120 /* "glGenTextures" */,
                                providers, entrypoints);
}

static PFNGLGENTEXTURESEXTPROC
epoxy_glGenTexturesEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_texture_object, 16134 /* glGenTexturesEXT */);
}

static PFNGLGENTRANSFORMFEEDBACKSPROC
epoxy_glGenTransformFeedbacks_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_transform_feedback2,
        OpenGL_ES_3_0,
        GL_extension_GL_NV_transform_feedback2,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16151 /* "glGenTransformFeedbacks" */,
        16151 /* "glGenTransformFeedbacks" */,
        16151 /* "glGenTransformFeedbacks" */,
        16175 /* "glGenTransformFeedbacksNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16151 /* "glGenTransformFeedbacks" */,
                                providers, entrypoints);
}

static PFNGLGENTRANSFORMFEEDBACKSNVPROC
epoxy_glGenTransformFeedbacksNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_transform_feedback2,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_transform_feedback2,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16175 /* "glGenTransformFeedbacksNV" */,
        16151 /* "glGenTransformFeedbacks" */,
        16151 /* "glGenTransformFeedbacks" */,
        16151 /* "glGenTransformFeedbacks" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16175 /* "glGenTransformFeedbacksNV" */,
                                providers, entrypoints);
}

static PFNGLGENVERTEXARRAYSPROC
epoxy_glGenVertexArrays_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_vertex_array_object,
        OpenGL_ES_3_0,
        GL_extension_GL_APPLE_vertex_array_object,
        GL_extension_GL_OES_vertex_array_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16201 /* "glGenVertexArrays" */,
        16201 /* "glGenVertexArrays" */,
        16201 /* "glGenVertexArrays" */,
        16219 /* "glGenVertexArraysAPPLE" */,
        16242 /* "glGenVertexArraysOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16201 /* "glGenVertexArrays" */,
                                providers, entrypoints);
}

static PFNGLGENVERTEXARRAYSAPPLEPROC
epoxy_glGenVertexArraysAPPLE_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_APPLE_vertex_array_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_vertex_array_object,
        OpenGL_ES_3_0,
        GL_extension_GL_OES_vertex_array_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16219 /* "glGenVertexArraysAPPLE" */,
        16201 /* "glGenVertexArrays" */,
        16201 /* "glGenVertexArrays" */,
        16201 /* "glGenVertexArrays" */,
        16242 /* "glGenVertexArraysOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16219 /* "glGenVertexArraysAPPLE" */,
                                providers, entrypoints);
}

static PFNGLGENVERTEXARRAYSOESPROC
epoxy_glGenVertexArraysOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_vertex_array_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_vertex_array_object,
        OpenGL_ES_3_0,
        GL_extension_GL_APPLE_vertex_array_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16242 /* "glGenVertexArraysOES" */,
        16201 /* "glGenVertexArrays" */,
        16201 /* "glGenVertexArrays" */,
        16201 /* "glGenVertexArrays" */,
        16219 /* "glGenVertexArraysAPPLE" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16242 /* "glGenVertexArraysOES" */,
                                providers, entrypoints);
}

static PFNGLGENVERTEXSHADERSEXTPROC
epoxy_glGenVertexShadersEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 16263 /* glGenVertexShadersEXT */);
}

static PFNGLGENERATEMIPMAPPROC
epoxy_glGenerateMipmap_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_framebuffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16285 /* "glGenerateMipmap" */,
        16285 /* "glGenerateMipmap" */,
        16285 /* "glGenerateMipmap" */,
        16302 /* "glGenerateMipmapEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16285 /* "glGenerateMipmap" */,
                                providers, entrypoints);
}

static PFNGLGENERATEMIPMAPEXTPROC
epoxy_glGenerateMipmapEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16302 /* "glGenerateMipmapEXT" */,
        16285 /* "glGenerateMipmap" */,
        16285 /* "glGenerateMipmap" */,
        16285 /* "glGenerateMipmap" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16302 /* "glGenerateMipmapEXT" */,
                                providers, entrypoints);
}

static PFNGLGENERATEMIPMAPOESPROC
epoxy_glGenerateMipmapOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_framebuffer_object, 16322 /* glGenerateMipmapOES */);
}

static PFNGLGENERATEMULTITEXMIPMAPEXTPROC
epoxy_glGenerateMultiTexMipmapEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 16342 /* glGenerateMultiTexMipmapEXT */);
}

static PFNGLGENERATETEXTUREMIPMAPPROC
epoxy_glGenerateTextureMipmap_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16370 /* "glGenerateTextureMipmap" */,
        16370 /* "glGenerateTextureMipmap" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16370 /* "glGenerateTextureMipmap" */,
                                providers, entrypoints);
}

static PFNGLGENERATETEXTUREMIPMAPEXTPROC
epoxy_glGenerateTextureMipmapEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 16394 /* glGenerateTextureMipmapEXT */);
}

static PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC
epoxy_glGetActiveAtomicCounterBufferiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_2,
        GL_extension_GL_ARB_shader_atomic_counters,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16421 /* "glGetActiveAtomicCounterBufferiv" */,
        16421 /* "glGetActiveAtomicCounterBufferiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16421 /* "glGetActiveAtomicCounterBufferiv" */,
                                providers, entrypoints);
}

static PFNGLGETACTIVEATTRIBPROC
epoxy_glGetActiveAttrib_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_shader,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16454 /* "glGetActiveAttrib" */,
        16454 /* "glGetActiveAttrib" */,
        16472 /* "glGetActiveAttribARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16454 /* "glGetActiveAttrib" */,
                                providers, entrypoints);
}

static PFNGLGETACTIVEATTRIBARBPROC
epoxy_glGetActiveAttribARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_shader,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16472 /* "glGetActiveAttribARB" */,
        16454 /* "glGetActiveAttrib" */,
        16454 /* "glGetActiveAttrib" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16472 /* "glGetActiveAttribARB" */,
                                providers, entrypoints);
}

static PFNGLGETACTIVESUBROUTINENAMEPROC
epoxy_glGetActiveSubroutineName_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_shader_subroutine,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16493 /* "glGetActiveSubroutineName" */,
        16493 /* "glGetActiveSubroutineName" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16493 /* "glGetActiveSubroutineName" */,
                                providers, entrypoints);
}

static PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC
epoxy_glGetActiveSubroutineUniformName_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_shader_subroutine,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16519 /* "glGetActiveSubroutineUniformName" */,
        16519 /* "glGetActiveSubroutineUniformName" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16519 /* "glGetActiveSubroutineUniformName" */,
                                providers, entrypoints);
}

static PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC
epoxy_glGetActiveSubroutineUniformiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_shader_subroutine,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16552 /* "glGetActiveSubroutineUniformiv" */,
        16552 /* "glGetActiveSubroutineUniformiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16552 /* "glGetActiveSubroutineUniformiv" */,
                                providers, entrypoints);
}

static PFNGLGETACTIVEUNIFORMPROC
epoxy_glGetActiveUniform_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_shader_objects,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16583 /* "glGetActiveUniform" */,
        16583 /* "glGetActiveUniform" */,
        16602 /* "glGetActiveUniformARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16583 /* "glGetActiveUniform" */,
                                providers, entrypoints);
}

static PFNGLGETACTIVEUNIFORMARBPROC
epoxy_glGetActiveUniformARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_shader_objects,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16602 /* "glGetActiveUniformARB" */,
        16583 /* "glGetActiveUniform" */,
        16583 /* "glGetActiveUniform" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16602 /* "glGetActiveUniformARB" */,
                                providers, entrypoints);
}

static PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC
epoxy_glGetActiveUniformBlockName_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16624 /* "glGetActiveUniformBlockName" */,
        16624 /* "glGetActiveUniformBlockName" */,
        16624 /* "glGetActiveUniformBlockName" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16624 /* "glGetActiveUniformBlockName" */,
                                providers, entrypoints);
}

static PFNGLGETACTIVEUNIFORMBLOCKIVPROC
epoxy_glGetActiveUniformBlockiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16652 /* "glGetActiveUniformBlockiv" */,
        16652 /* "glGetActiveUniformBlockiv" */,
        16652 /* "glGetActiveUniformBlockiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16652 /* "glGetActiveUniformBlockiv" */,
                                providers, entrypoints);
}

static PFNGLGETACTIVEUNIFORMNAMEPROC
epoxy_glGetActiveUniformName_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16678 /* "glGetActiveUniformName" */,
        16678 /* "glGetActiveUniformName" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16678 /* "glGetActiveUniformName" */,
                                providers, entrypoints);
}

static PFNGLGETACTIVEUNIFORMSIVPROC
epoxy_glGetActiveUniformsiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16701 /* "glGetActiveUniformsiv" */,
        16701 /* "glGetActiveUniformsiv" */,
        16701 /* "glGetActiveUniformsiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16701 /* "glGetActiveUniformsiv" */,
                                providers, entrypoints);
}

static PFNGLGETACTIVEVARYINGNVPROC
epoxy_glGetActiveVaryingNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_transform_feedback, 16723 /* glGetActiveVaryingNV */);
}

static PFNGLGETARRAYOBJECTFVATIPROC
epoxy_glGetArrayObjectfvATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_vertex_array_object, 16744 /* glGetArrayObjectfvATI */);
}

static PFNGLGETARRAYOBJECTIVATIPROC
epoxy_glGetArrayObjectivATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_vertex_array_object, 16766 /* glGetArrayObjectivATI */);
}

static PFNGLGETATTACHEDOBJECTSARBPROC
epoxy_glGetAttachedObjectsARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_shader_objects, 16788 /* glGetAttachedObjectsARB */);
}

static PFNGLGETATTACHEDSHADERSPROC
epoxy_glGetAttachedShaders_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16812 /* "glGetAttachedShaders" */,
        16812 /* "glGetAttachedShaders" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16812 /* "glGetAttachedShaders" */,
                                providers, entrypoints);
}

static PFNGLGETATTRIBLOCATIONPROC
epoxy_glGetAttribLocation_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_shader,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16833 /* "glGetAttribLocation" */,
        16833 /* "glGetAttribLocation" */,
        16853 /* "glGetAttribLocationARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16833 /* "glGetAttribLocation" */,
                                providers, entrypoints);
}

static PFNGLGETATTRIBLOCATIONARBPROC
epoxy_glGetAttribLocationARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_shader,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16853 /* "glGetAttribLocationARB" */,
        16833 /* "glGetAttribLocation" */,
        16833 /* "glGetAttribLocation" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16853 /* "glGetAttribLocationARB" */,
                                providers, entrypoints);
}

static PFNGLGETBOOLEANINDEXEDVEXTPROC
epoxy_glGetBooleanIndexedvEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16876 /* "glGetBooleanIndexedvEXT" */,
        16876 /* "glGetBooleanIndexedvEXT" */,
        16900 /* "glGetBooleani_v" */,
        16900 /* "glGetBooleani_v" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16876 /* "glGetBooleanIndexedvEXT" */,
                                providers, entrypoints);
}

static PFNGLGETBOOLEANI_VPROC
epoxy_glGetBooleani_v_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_1,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16900 /* "glGetBooleani_v" */,
        16900 /* "glGetBooleani_v" */,
        16876 /* "glGetBooleanIndexedvEXT" */,
        16876 /* "glGetBooleanIndexedvEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16900 /* "glGetBooleani_v" */,
                                providers, entrypoints);
}

static PFNGLGETBOOLEANVPROC
epoxy_glGetBooleanv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16916 /* "glGetBooleanv" */,
        16916 /* "glGetBooleanv" */,
        16916 /* "glGetBooleanv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16916 /* "glGetBooleanv" */,
                                providers, entrypoints);
}

static PFNGLGETBUFFERPARAMETERI64VPROC
epoxy_glGetBufferParameteri64v_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_2,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16930 /* "glGetBufferParameteri64v" */,
        16930 /* "glGetBufferParameteri64v" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16930 /* "glGetBufferParameteri64v" */,
                                providers, entrypoints);
}

static PFNGLGETBUFFERPARAMETERIVPROC
epoxy_glGetBufferParameteriv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_buffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16955 /* "glGetBufferParameteriv" */,
        16955 /* "glGetBufferParameteriv" */,
        16955 /* "glGetBufferParameteriv" */,
        16978 /* "glGetBufferParameterivARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16955 /* "glGetBufferParameteriv" */,
                                providers, entrypoints);
}

static PFNGLGETBUFFERPARAMETERIVARBPROC
epoxy_glGetBufferParameterivARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_buffer_object,
        Desktop_OpenGL_1_5,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        16978 /* "glGetBufferParameterivARB" */,
        16955 /* "glGetBufferParameteriv" */,
        16955 /* "glGetBufferParameteriv" */,
        16955 /* "glGetBufferParameteriv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 16978 /* "glGetBufferParameterivARB" */,
                                providers, entrypoints);
}

static PFNGLGETBUFFERPARAMETERUI64VNVPROC
epoxy_glGetBufferParameterui64vNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_shader_buffer_load, 17004 /* glGetBufferParameterui64vNV */);
}

static PFNGLGETBUFFERPOINTERVPROC
epoxy_glGetBufferPointerv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_vertex_buffer_object,
        GL_extension_GL_OES_mapbuffer,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        17032 /* "glGetBufferPointerv" */,
        17032 /* "glGetBufferPointerv" */,
        17052 /* "glGetBufferPointervARB" */,
        17075 /* "glGetBufferPointervOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 17032 /* "glGetBufferPointerv" */,
                                providers, entrypoints);
}

static PFNGLGETBUFFERPOINTERVARBPROC
epoxy_glGetBufferPointervARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_buffer_object,
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        GL_extension_GL_OES_mapbuffer,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        17052 /* "glGetBufferPointervARB" */,
        17032 /* "glGetBufferPointerv" */,
        17032 /* "glGetBufferPointerv" */,
        17075 /* "glGetBufferPointervOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 17052 /* "glGetBufferPointervARB" */,
                                providers, entrypoints);
}

static PFNGLGETBUFFERPOINTERVOESPROC
epoxy_glGetBufferPointervOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_mapbuffer,
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_vertex_buffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        17075 /* "glGetBufferPointervOES" */,
        17032 /* "glGetBufferPointerv" */,
        17032 /* "glGetBufferPointerv" */,
        17052 /* "glGetBufferPointervARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 17075 /* "glGetBufferPointervOES" */,
                                providers, entrypoints);
}

static PFNGLGETBUFFERSUBDATAPROC
epoxy_glGetBufferSubData_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        GL_extension_GL_ARB_vertex_buffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        17098 /* "glGetBufferSubData" */,
        17117 /* "glGetBufferSubDataARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 17098 /* "glGetBufferSubData" */,
                                providers, entrypoints);
}

static PFNGLGETBUFFERSUBDATAARBPROC
epoxy_glGetBufferSubDataARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_buffer_object,
        Desktop_OpenGL_1_5,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        17117 /* "glGetBufferSubDataARB" */,
        17098 /* "glGetBufferSubData" */,
    };
    return gl_provider_resolver(entrypoint_strings + 17117 /* "glGetBufferSubDataARB" */,
                                providers, entrypoints);
}

static PFNGLGETCLIPPLANEPROC
epoxy_glGetClipPlane_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 17139 /* glGetClipPlane */);
}

static PFNGLGETCLIPPLANEFPROC
epoxy_glGetClipPlanef_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 17154 /* glGetClipPlanef */);
}

static PFNGLGETCLIPPLANEFOESPROC
epoxy_glGetClipPlanefOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_single_precision, 17170 /* glGetClipPlanefOES */);
}

static PFNGLGETCLIPPLANEXPROC
epoxy_glGetClipPlanex_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 17189 /* glGetClipPlanex */);
}

static PFNGLGETCLIPPLANEXOESPROC
epoxy_glGetClipPlanexOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 17205 /* glGetClipPlanexOES */);
}

static PFNGLGETCOLORTABLEPROC
epoxy_glGetColorTable_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_paletted_texture,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        17224 /* "glGetColorTable" */,
        17240 /* "glGetColorTableEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 17224 /* "glGetColorTable" */,
                                providers, entrypoints);
}

static PFNGLGETCOLORTABLEEXTPROC
epoxy_glGetColorTableEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_paletted_texture,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        17240 /* "glGetColorTableEXT" */,
        17224 /* "glGetColorTable" */,
    };
    return gl_provider_resolver(entrypoint_strings + 17240 /* "glGetColorTableEXT" */,
                                providers, entrypoints);
}

static PFNGLGETCOLORTABLEPARAMETERFVPROC
epoxy_glGetColorTableParameterfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_paletted_texture,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        17259 /* "glGetColorTableParameterfv" */,
        17286 /* "glGetColorTableParameterfvEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 17259 /* "glGetColorTableParameterfv" */,
                                providers, entrypoints);
}

static PFNGLGETCOLORTABLEPARAMETERFVEXTPROC
epoxy_glGetColorTableParameterfvEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_paletted_texture,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        17286 /* "glGetColorTableParameterfvEXT" */,
        17259 /* "glGetColorTableParameterfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 17286 /* "glGetColorTableParameterfvEXT" */,
                                providers, entrypoints);
}

static PFNGLGETCOLORTABLEPARAMETERFVSGIPROC
epoxy_glGetColorTableParameterfvSGI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGI_color_table, 17316 /* glGetColorTableParameterfvSGI */);
}

static PFNGLGETCOLORTABLEPARAMETERIVPROC
epoxy_glGetColorTableParameteriv_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_paletted_texture,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        17346 /* "glGetColorTableParameteriv" */,
        17373 /* "glGetColorTableParameterivEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 17346 /* "glGetColorTableParameteriv" */,
                                providers, entrypoints);
}

static PFNGLGETCOLORTABLEPARAMETERIVEXTPROC
epoxy_glGetColorTableParameterivEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_paletted_texture,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        17373 /* "glGetColorTableParameterivEXT" */,
        17346 /* "glGetColorTableParameteriv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 17373 /* "glGetColorTableParameterivEXT" */,
                                providers, entrypoints);
}

static PFNGLGETCOLORTABLEPARAMETERIVSGIPROC
epoxy_glGetColorTableParameterivSGI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGI_color_table, 17403 /* glGetColorTableParameterivSGI */);
}

static PFNGLGETCOLORTABLESGIPROC
epoxy_glGetColorTableSGI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGI_color_table, 17433 /* glGetColorTableSGI */);
}

static PFNGLGETCOMBINERINPUTPARAMETERFVNVPROC
epoxy_glGetCombinerInputParameterfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_register_combiners, 17452 /* glGetCombinerInputParameterfvNV */);
}

static PFNGLGETCOMBINERINPUTPARAMETERIVNVPROC
epoxy_glGetCombinerInputParameterivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_register_combiners, 17484 /* glGetCombinerInputParameterivNV */);
}

static PFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC
epoxy_glGetCombinerOutputParameterfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_register_combiners, 17516 /* glGetCombinerOutputParameterfvNV */);
}

static PFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC
epoxy_glGetCombinerOutputParameterivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_register_combiners, 17549 /* glGetCombinerOutputParameterivNV */);
}

static PFNGLGETCOMBINERSTAGEPARAMETERFVNVPROC
epoxy_glGetCombinerStageParameterfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_register_combiners2, 17582 /* glGetCombinerStageParameterfvNV */);
}

static PFNGLGETCOMMANDHEADERNVPROC
epoxy_glGetCommandHeaderNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_command_list, 17614 /* glGetCommandHeaderNV */);
}

static PFNGLGETCOMPRESSEDMULTITEXIMAGEEXTPROC
epoxy_glGetCompressedMultiTexImageEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 17635 /* glGetCompressedMultiTexImageEXT */);
}

static PFNGLGETCOMPRESSEDTEXIMAGEPROC
epoxy_glGetCompressedTexImage_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_3,
        GL_extension_GL_ARB_texture_compression,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        17667 /* "glGetCompressedTexImage" */,
        17691 /* "glGetCompressedTexImageARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 17667 /* "glGetCompressedTexImage" */,
                                providers, entrypoints);
}

static PFNGLGETCOMPRESSEDTEXIMAGEARBPROC
epoxy_glGetCompressedTexImageARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_texture_compression,
        Desktop_OpenGL_1_3,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        17691 /* "glGetCompressedTexImageARB" */,
        17667 /* "glGetCompressedTexImage" */,
    };
    return gl_provider_resolver(entrypoint_strings + 17691 /* "glGetCompressedTexImageARB" */,
                                providers, entrypoints);
}

static PFNGLGETCOMPRESSEDTEXTUREIMAGEPROC
epoxy_glGetCompressedTextureImage_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        17718 /* "glGetCompressedTextureImage" */,
        17718 /* "glGetCompressedTextureImage" */,
    };
    return gl_provider_resolver(entrypoint_strings + 17718 /* "glGetCompressedTextureImage" */,
                                providers, entrypoints);
}

static PFNGLGETCOMPRESSEDTEXTUREIMAGEEXTPROC
epoxy_glGetCompressedTextureImageEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 17746 /* glGetCompressedTextureImageEXT */);
}

static PFNGLGETCOMPRESSEDTEXTURESUBIMAGEPROC
epoxy_glGetCompressedTextureSubImage_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_get_texture_sub_image,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        17777 /* "glGetCompressedTextureSubImage" */,
        17777 /* "glGetCompressedTextureSubImage" */,
    };
    return gl_provider_resolver(entrypoint_strings + 17777 /* "glGetCompressedTextureSubImage" */,
                                providers, entrypoints);
}

static PFNGLGETCONVOLUTIONFILTERPROC
epoxy_glGetConvolutionFilter_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_imaging, 17808 /* glGetConvolutionFilter */);
}

static PFNGLGETCONVOLUTIONFILTEREXTPROC
epoxy_glGetConvolutionFilterEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_convolution, 17831 /* glGetConvolutionFilterEXT */);
}

static PFNGLGETCONVOLUTIONPARAMETERFVPROC
epoxy_glGetConvolutionParameterfv_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_imaging, 17857 /* glGetConvolutionParameterfv */);
}

static PFNGLGETCONVOLUTIONPARAMETERFVEXTPROC
epoxy_glGetConvolutionParameterfvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_convolution, 17885 /* glGetConvolutionParameterfvEXT */);
}

static PFNGLGETCONVOLUTIONPARAMETERIVPROC
epoxy_glGetConvolutionParameteriv_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_imaging, 17916 /* glGetConvolutionParameteriv */);
}

static PFNGLGETCONVOLUTIONPARAMETERIVEXTPROC
epoxy_glGetConvolutionParameterivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_convolution, 17944 /* glGetConvolutionParameterivEXT */);
}

static PFNGLGETCONVOLUTIONPARAMETERXVOESPROC
epoxy_glGetConvolutionParameterxvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 17975 /* glGetConvolutionParameterxvOES */);
}

static PFNGLGETCOVERAGEMODULATIONTABLENVPROC
epoxy_glGetCoverageModulationTableNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_framebuffer_mixed_samples, 18006 /* glGetCoverageModulationTableNV */);
}

static PFNGLGETDEBUGMESSAGELOGPROC
epoxy_glGetDebugMessageLog_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        GL_extension_GL_ARB_debug_output,
        GL_extension_GL_KHR_debug,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18037 /* "glGetDebugMessageLog" */,
        18037 /* "glGetDebugMessageLog" */,
        18082 /* "glGetDebugMessageLogARB" */,
        18106 /* "glGetDebugMessageLogKHR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18037 /* "glGetDebugMessageLog" */,
                                providers, entrypoints);
}

static PFNGLGETDEBUGMESSAGELOGAMDPROC
epoxy_glGetDebugMessageLogAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_debug_output, 18058 /* glGetDebugMessageLogAMD */);
}

static PFNGLGETDEBUGMESSAGELOGARBPROC
epoxy_glGetDebugMessageLogARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_debug_output,
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        GL_extension_GL_KHR_debug,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18082 /* "glGetDebugMessageLogARB" */,
        18037 /* "glGetDebugMessageLog" */,
        18037 /* "glGetDebugMessageLog" */,
        18106 /* "glGetDebugMessageLogKHR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18082 /* "glGetDebugMessageLogARB" */,
                                providers, entrypoints);
}

static PFNGLGETDEBUGMESSAGELOGKHRPROC
epoxy_glGetDebugMessageLogKHR_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_KHR_debug,
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        GL_extension_GL_ARB_debug_output,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18106 /* "glGetDebugMessageLogKHR" */,
        18037 /* "glGetDebugMessageLog" */,
        18037 /* "glGetDebugMessageLog" */,
        18082 /* "glGetDebugMessageLogARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18106 /* "glGetDebugMessageLogKHR" */,
                                providers, entrypoints);
}

static PFNGLGETDETAILTEXFUNCSGISPROC
epoxy_glGetDetailTexFuncSGIS_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIS_detail_texture, 18130 /* glGetDetailTexFuncSGIS */);
}

static PFNGLGETDOUBLEINDEXEDVEXTPROC
epoxy_glGetDoubleIndexedvEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_direct_state_access,
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_viewport_array,
        GL_extension_GL_EXT_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18153 /* "glGetDoubleIndexedvEXT" */,
        18176 /* "glGetDoublei_v" */,
        18176 /* "glGetDoublei_v" */,
        18191 /* "glGetDoublei_vEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18153 /* "glGetDoubleIndexedvEXT" */,
                                providers, entrypoints);
}

static PFNGLGETDOUBLEI_VPROC
epoxy_glGetDoublei_v_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_viewport_array,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18176 /* "glGetDoublei_v" */,
        18176 /* "glGetDoublei_v" */,
        18153 /* "glGetDoubleIndexedvEXT" */,
        18191 /* "glGetDoublei_vEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18176 /* "glGetDoublei_v" */,
                                providers, entrypoints);
}

static PFNGLGETDOUBLEI_VEXTPROC
epoxy_glGetDoublei_vEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_direct_state_access,
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_viewport_array,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18191 /* "glGetDoublei_vEXT" */,
        18153 /* "glGetDoubleIndexedvEXT" */,
        18176 /* "glGetDoublei_v" */,
        18176 /* "glGetDoublei_v" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18191 /* "glGetDoublei_vEXT" */,
                                providers, entrypoints);
}

static PFNGLGETDOUBLEVPROC
epoxy_glGetDoublev_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 18209 /* glGetDoublev */);
}

static PFNGLGETDRIVERCONTROLSTRINGQCOMPROC
epoxy_glGetDriverControlStringQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_driver_control, 18222 /* glGetDriverControlStringQCOM */);
}

static PFNGLGETDRIVERCONTROLSQCOMPROC
epoxy_glGetDriverControlsQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_driver_control, 18251 /* glGetDriverControlsQCOM */);
}

static PFNGLGETERRORPROC
epoxy_glGetError_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18275 /* "glGetError" */,
        18275 /* "glGetError" */,
        18275 /* "glGetError" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18275 /* "glGetError" */,
                                providers, entrypoints);
}

static PFNGLGETFENCEIVNVPROC
epoxy_glGetFenceivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_fence, 18286 /* glGetFenceivNV */);
}

static PFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC
epoxy_glGetFinalCombinerInputParameterfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_register_combiners, 18301 /* glGetFinalCombinerInputParameterfvNV */);
}

static PFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC
epoxy_glGetFinalCombinerInputParameterivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_register_combiners, 18338 /* glGetFinalCombinerInputParameterivNV */);
}

static PFNGLGETFIRSTPERFQUERYIDINTELPROC
epoxy_glGetFirstPerfQueryIdINTEL_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_INTEL_performance_query, 18375 /* glGetFirstPerfQueryIdINTEL */);
}

static PFNGLGETFIXEDVPROC
epoxy_glGetFixedv_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 18402 /* glGetFixedv */);
}

static PFNGLGETFIXEDVOESPROC
epoxy_glGetFixedvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 18414 /* glGetFixedvOES */);
}

static PFNGLGETFLOATINDEXEDVEXTPROC
epoxy_glGetFloatIndexedvEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_direct_state_access,
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_viewport_array,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_NV_viewport_array,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18429 /* "glGetFloatIndexedvEXT" */,
        18451 /* "glGetFloati_v" */,
        18451 /* "glGetFloati_v" */,
        18465 /* "glGetFloati_vEXT" */,
        18482 /* "glGetFloati_vNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18429 /* "glGetFloatIndexedvEXT" */,
                                providers, entrypoints);
}

static PFNGLGETFLOATI_VPROC
epoxy_glGetFloati_v_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_viewport_array,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_NV_viewport_array,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18451 /* "glGetFloati_v" */,
        18451 /* "glGetFloati_v" */,
        18429 /* "glGetFloatIndexedvEXT" */,
        18465 /* "glGetFloati_vEXT" */,
        18482 /* "glGetFloati_vNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18451 /* "glGetFloati_v" */,
                                providers, entrypoints);
}

static PFNGLGETFLOATI_VEXTPROC
epoxy_glGetFloati_vEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_direct_state_access,
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_viewport_array,
        GL_extension_GL_NV_viewport_array,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18465 /* "glGetFloati_vEXT" */,
        18429 /* "glGetFloatIndexedvEXT" */,
        18451 /* "glGetFloati_v" */,
        18451 /* "glGetFloati_v" */,
        18482 /* "glGetFloati_vNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18465 /* "glGetFloati_vEXT" */,
                                providers, entrypoints);
}

static PFNGLGETFLOATI_VNVPROC
epoxy_glGetFloati_vNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_viewport_array,
        GL_extension_GL_EXT_direct_state_access,
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_viewport_array,
        GL_extension_GL_EXT_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18482 /* "glGetFloati_vNV" */,
        18429 /* "glGetFloatIndexedvEXT" */,
        18451 /* "glGetFloati_v" */,
        18451 /* "glGetFloati_v" */,
        18465 /* "glGetFloati_vEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18482 /* "glGetFloati_vNV" */,
                                providers, entrypoints);
}

static PFNGLGETFLOATVPROC
epoxy_glGetFloatv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18498 /* "glGetFloatv" */,
        18498 /* "glGetFloatv" */,
        18498 /* "glGetFloatv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18498 /* "glGetFloatv" */,
                                providers, entrypoints);
}

static PFNGLGETFOGFUNCSGISPROC
epoxy_glGetFogFuncSGIS_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIS_fog_function, 18510 /* glGetFogFuncSGIS */);
}

static PFNGLGETFRAGDATAINDEXPROC
epoxy_glGetFragDataIndex_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_blend_func_extended,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18527 /* "glGetFragDataIndex" */,
        18527 /* "glGetFragDataIndex" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18527 /* "glGetFragDataIndex" */,
                                providers, entrypoints);
}

static PFNGLGETFRAGDATALOCATIONPROC
epoxy_glGetFragDataLocation_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_gpu_shader4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18546 /* "glGetFragDataLocation" */,
        18546 /* "glGetFragDataLocation" */,
        18568 /* "glGetFragDataLocationEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18546 /* "glGetFragDataLocation" */,
                                providers, entrypoints);
}

static PFNGLGETFRAGDATALOCATIONEXTPROC
epoxy_glGetFragDataLocationEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_gpu_shader4,
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18568 /* "glGetFragDataLocationEXT" */,
        18546 /* "glGetFragDataLocation" */,
        18546 /* "glGetFragDataLocation" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18568 /* "glGetFragDataLocationEXT" */,
                                providers, entrypoints);
}

static PFNGLGETFRAGMENTLIGHTFVSGIXPROC
epoxy_glGetFragmentLightfvSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 18593 /* glGetFragmentLightfvSGIX */);
}

static PFNGLGETFRAGMENTLIGHTIVSGIXPROC
epoxy_glGetFragmentLightivSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 18618 /* glGetFragmentLightivSGIX */);
}

static PFNGLGETFRAGMENTMATERIALFVSGIXPROC
epoxy_glGetFragmentMaterialfvSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 18643 /* glGetFragmentMaterialfvSGIX */);
}

static PFNGLGETFRAGMENTMATERIALIVSGIXPROC
epoxy_glGetFragmentMaterialivSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 18671 /* glGetFragmentMaterialivSGIX */);
}

static PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC
epoxy_glGetFramebufferAttachmentParameteriv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_framebuffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18699 /* "glGetFramebufferAttachmentParameteriv" */,
        18699 /* "glGetFramebufferAttachmentParameteriv" */,
        18699 /* "glGetFramebufferAttachmentParameteriv" */,
        18737 /* "glGetFramebufferAttachmentParameterivEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18699 /* "glGetFramebufferAttachmentParameteriv" */,
                                providers, entrypoints);
}

static PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC
epoxy_glGetFramebufferAttachmentParameterivEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18737 /* "glGetFramebufferAttachmentParameterivEXT" */,
        18699 /* "glGetFramebufferAttachmentParameteriv" */,
        18699 /* "glGetFramebufferAttachmentParameteriv" */,
        18699 /* "glGetFramebufferAttachmentParameteriv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18737 /* "glGetFramebufferAttachmentParameterivEXT" */,
                                providers, entrypoints);
}

static PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVOESPROC
epoxy_glGetFramebufferAttachmentParameterivOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_framebuffer_object, 18778 /* glGetFramebufferAttachmentParameterivOES */);
}

static PFNGLGETFRAMEBUFFERPARAMETERIVPROC
epoxy_glGetFramebufferParameteriv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_framebuffer_no_attachments,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18819 /* "glGetFramebufferParameteriv" */,
        18819 /* "glGetFramebufferParameteriv" */,
        18819 /* "glGetFramebufferParameteriv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18819 /* "glGetFramebufferParameteriv" */,
                                providers, entrypoints);
}

static PFNGLGETFRAMEBUFFERPARAMETERIVEXTPROC
epoxy_glGetFramebufferParameterivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 18847 /* glGetFramebufferParameterivEXT */);
}

static PFNGLGETGRAPHICSRESETSTATUSPROC
epoxy_glGetGraphicsResetStatus_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_KHR_robustness,
        GL_extension_GL_KHR_robustness,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18878 /* "glGetGraphicsResetStatus" */,
        18878 /* "glGetGraphicsResetStatus" */,
        18959 /* "glGetGraphicsResetStatusKHR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18878 /* "glGetGraphicsResetStatus" */,
                                providers, entrypoints);
}

static PFNGLGETGRAPHICSRESETSTATUSARBPROC
epoxy_glGetGraphicsResetStatusARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 18903 /* glGetGraphicsResetStatusARB */);
}

static PFNGLGETGRAPHICSRESETSTATUSEXTPROC
epoxy_glGetGraphicsResetStatusEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_robustness, 18931 /* glGetGraphicsResetStatusEXT */);
}

static PFNGLGETGRAPHICSRESETSTATUSKHRPROC
epoxy_glGetGraphicsResetStatusKHR_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_KHR_robustness,
        Desktop_OpenGL_4_5,
        GL_extension_GL_KHR_robustness,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        18959 /* "glGetGraphicsResetStatusKHR" */,
        18878 /* "glGetGraphicsResetStatus" */,
        18878 /* "glGetGraphicsResetStatus" */,
    };
    return gl_provider_resolver(entrypoint_strings + 18959 /* "glGetGraphicsResetStatusKHR" */,
                                providers, entrypoints);
}

static PFNGLGETHANDLEARBPROC
epoxy_glGetHandleARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_shader_objects, 18987 /* glGetHandleARB */);
}

static PFNGLGETHISTOGRAMPROC
epoxy_glGetHistogram_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_imaging, 19002 /* glGetHistogram */);
}

static PFNGLGETHISTOGRAMEXTPROC
epoxy_glGetHistogramEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_histogram, 19017 /* glGetHistogramEXT */);
}

static PFNGLGETHISTOGRAMPARAMETERFVPROC
epoxy_glGetHistogramParameterfv_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_imaging, 19035 /* glGetHistogramParameterfv */);
}

static PFNGLGETHISTOGRAMPARAMETERFVEXTPROC
epoxy_glGetHistogramParameterfvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_histogram, 19061 /* glGetHistogramParameterfvEXT */);
}

static PFNGLGETHISTOGRAMPARAMETERIVPROC
epoxy_glGetHistogramParameteriv_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_imaging, 19090 /* glGetHistogramParameteriv */);
}

static PFNGLGETHISTOGRAMPARAMETERIVEXTPROC
epoxy_glGetHistogramParameterivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_histogram, 19116 /* glGetHistogramParameterivEXT */);
}

static PFNGLGETHISTOGRAMPARAMETERXVOESPROC
epoxy_glGetHistogramParameterxvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 19145 /* glGetHistogramParameterxvOES */);
}

static PFNGLGETIMAGEHANDLEARBPROC
epoxy_glGetImageHandleARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_bindless_texture, 19174 /* glGetImageHandleARB */);
}

static PFNGLGETIMAGEHANDLENVPROC
epoxy_glGetImageHandleNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_bindless_texture, 19194 /* glGetImageHandleNV */);
}

static PFNGLGETIMAGETRANSFORMPARAMETERFVHPPROC
epoxy_glGetImageTransformParameterfvHP_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_HP_image_transform, 19213 /* glGetImageTransformParameterfvHP */);
}

static PFNGLGETIMAGETRANSFORMPARAMETERIVHPPROC
epoxy_glGetImageTransformParameterivHP_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_HP_image_transform, 19246 /* glGetImageTransformParameterivHP */);
}

static PFNGLGETINFOLOGARBPROC
epoxy_glGetInfoLogARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_shader_objects, 19279 /* glGetInfoLogARB */);
}

static PFNGLGETINSTRUMENTSSGIXPROC
epoxy_glGetInstrumentsSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_instruments, 19295 /* glGetInstrumentsSGIX */);
}

static PFNGLGETINTEGER64I_VPROC
epoxy_glGetInteger64i_v_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_2,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        19316 /* "glGetInteger64i_v" */,
        19316 /* "glGetInteger64i_v" */,
    };
    return gl_provider_resolver(entrypoint_strings + 19316 /* "glGetInteger64i_v" */,
                                providers, entrypoints);
}

static PFNGLGETINTEGER64VPROC
epoxy_glGetInteger64v_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_sync,
        OpenGL_ES_3_0,
        GL_extension_GL_APPLE_sync,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        19334 /* "glGetInteger64v" */,
        19334 /* "glGetInteger64v" */,
        19334 /* "glGetInteger64v" */,
        19350 /* "glGetInteger64vAPPLE" */,
    };
    return gl_provider_resolver(entrypoint_strings + 19334 /* "glGetInteger64v" */,
                                providers, entrypoints);
}

static PFNGLGETINTEGER64VAPPLEPROC
epoxy_glGetInteger64vAPPLE_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_APPLE_sync,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_sync,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        19350 /* "glGetInteger64vAPPLE" */,
        19334 /* "glGetInteger64v" */,
        19334 /* "glGetInteger64v" */,
        19334 /* "glGetInteger64v" */,
    };
    return gl_provider_resolver(entrypoint_strings + 19350 /* "glGetInteger64vAPPLE" */,
                                providers, entrypoints);
}

static PFNGLGETINTEGERINDEXEDVEXTPROC
epoxy_glGetIntegerIndexedvEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        19371 /* "glGetIntegerIndexedvEXT" */,
        19371 /* "glGetIntegerIndexedvEXT" */,
        19395 /* "glGetIntegeri_v" */,
        19395 /* "glGetIntegeri_v" */,
        19395 /* "glGetIntegeri_v" */,
        19395 /* "glGetIntegeri_v" */,
    };
    return gl_provider_resolver(entrypoint_strings + 19371 /* "glGetIntegerIndexedvEXT" */,
                                providers, entrypoints);
}

static PFNGLGETINTEGERI_VPROC
epoxy_glGetIntegeri_v_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        19395 /* "glGetIntegeri_v" */,
        19395 /* "glGetIntegeri_v" */,
        19395 /* "glGetIntegeri_v" */,
        19395 /* "glGetIntegeri_v" */,
        19371 /* "glGetIntegerIndexedvEXT" */,
        19371 /* "glGetIntegerIndexedvEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 19395 /* "glGetIntegeri_v" */,
                                providers, entrypoints);
}

static PFNGLGETINTEGERI_VEXTPROC
epoxy_glGetIntegeri_vEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_multiview_draw_buffers, 19411 /* glGetIntegeri_vEXT */);
}

static PFNGLGETINTEGERUI64I_VNVPROC
epoxy_glGetIntegerui64i_vNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_buffer_unified_memory, 19430 /* glGetIntegerui64i_vNV */);
}

static PFNGLGETINTEGERUI64VNVPROC
epoxy_glGetIntegerui64vNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_shader_buffer_load, 19452 /* glGetIntegerui64vNV */);
}

static PFNGLGETINTEGERVPROC
epoxy_glGetIntegerv_resolver(void)
{
    return gl_single_resolver(always_present, 19472 /* glGetIntegerv */);
}

static PFNGLGETINTERNALFORMATSAMPLEIVNVPROC
epoxy_glGetInternalformatSampleivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_internalformat_sample_query, 19486 /* glGetInternalformatSampleivNV */);
}

static PFNGLGETINTERNALFORMATI64VPROC
epoxy_glGetInternalformati64v_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_internalformat_query2,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        19516 /* "glGetInternalformati64v" */,
        19516 /* "glGetInternalformati64v" */,
    };
    return gl_provider_resolver(entrypoint_strings + 19516 /* "glGetInternalformati64v" */,
                                providers, entrypoints);
}

static PFNGLGETINTERNALFORMATIVPROC
epoxy_glGetInternalformativ_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_2,
        GL_extension_GL_ARB_internalformat_query,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        19540 /* "glGetInternalformativ" */,
        19540 /* "glGetInternalformativ" */,
        19540 /* "glGetInternalformativ" */,
    };
    return gl_provider_resolver(entrypoint_strings + 19540 /* "glGetInternalformativ" */,
                                providers, entrypoints);
}

static PFNGLGETINVARIANTBOOLEANVEXTPROC
epoxy_glGetInvariantBooleanvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 19562 /* glGetInvariantBooleanvEXT */);
}

static PFNGLGETINVARIANTFLOATVEXTPROC
epoxy_glGetInvariantFloatvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 19588 /* glGetInvariantFloatvEXT */);
}

static PFNGLGETINVARIANTINTEGERVEXTPROC
epoxy_glGetInvariantIntegervEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 19612 /* glGetInvariantIntegervEXT */);
}

static PFNGLGETLIGHTFVPROC
epoxy_glGetLightfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        19638 /* "glGetLightfv" */,
        19638 /* "glGetLightfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 19638 /* "glGetLightfv" */,
                                providers, entrypoints);
}

static PFNGLGETLIGHTIVPROC
epoxy_glGetLightiv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 19651 /* glGetLightiv */);
}

static PFNGLGETLIGHTXOESPROC
epoxy_glGetLightxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 19664 /* glGetLightxOES */);
}

static PFNGLGETLIGHTXVPROC
epoxy_glGetLightxv_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 19679 /* glGetLightxv */);
}

static PFNGLGETLIGHTXVOESPROC
epoxy_glGetLightxvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 19692 /* glGetLightxvOES */);
}

static PFNGLGETLISTPARAMETERFVSGIXPROC
epoxy_glGetListParameterfvSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_list_priority, 19708 /* glGetListParameterfvSGIX */);
}

static PFNGLGETLISTPARAMETERIVSGIXPROC
epoxy_glGetListParameterivSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_list_priority, 19733 /* glGetListParameterivSGIX */);
}

static PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC
epoxy_glGetLocalConstantBooleanvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 19758 /* glGetLocalConstantBooleanvEXT */);
}

static PFNGLGETLOCALCONSTANTFLOATVEXTPROC
epoxy_glGetLocalConstantFloatvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 19788 /* glGetLocalConstantFloatvEXT */);
}

static PFNGLGETLOCALCONSTANTINTEGERVEXTPROC
epoxy_glGetLocalConstantIntegervEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 19816 /* glGetLocalConstantIntegervEXT */);
}

static PFNGLGETMAPATTRIBPARAMETERFVNVPROC
epoxy_glGetMapAttribParameterfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_evaluators, 19846 /* glGetMapAttribParameterfvNV */);
}

static PFNGLGETMAPATTRIBPARAMETERIVNVPROC
epoxy_glGetMapAttribParameterivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_evaluators, 19874 /* glGetMapAttribParameterivNV */);
}

static PFNGLGETMAPCONTROLPOINTSNVPROC
epoxy_glGetMapControlPointsNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_evaluators, 19902 /* glGetMapControlPointsNV */);
}

static PFNGLGETMAPPARAMETERFVNVPROC
epoxy_glGetMapParameterfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_evaluators, 19926 /* glGetMapParameterfvNV */);
}

static PFNGLGETMAPPARAMETERIVNVPROC
epoxy_glGetMapParameterivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_evaluators, 19948 /* glGetMapParameterivNV */);
}

static PFNGLGETMAPDVPROC
epoxy_glGetMapdv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 19970 /* glGetMapdv */);
}

static PFNGLGETMAPFVPROC
epoxy_glGetMapfv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 19981 /* glGetMapfv */);
}

static PFNGLGETMAPIVPROC
epoxy_glGetMapiv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 19992 /* glGetMapiv */);
}

static PFNGLGETMAPXVOESPROC
epoxy_glGetMapxvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 20003 /* glGetMapxvOES */);
}

static PFNGLGETMATERIALFVPROC
epoxy_glGetMaterialfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        20017 /* "glGetMaterialfv" */,
        20017 /* "glGetMaterialfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 20017 /* "glGetMaterialfv" */,
                                providers, entrypoints);
}

static PFNGLGETMATERIALIVPROC
epoxy_glGetMaterialiv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 20033 /* glGetMaterialiv */);
}

static PFNGLGETMATERIALXOESPROC
epoxy_glGetMaterialxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 20049 /* glGetMaterialxOES */);
}

static PFNGLGETMATERIALXVPROC
epoxy_glGetMaterialxv_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 20067 /* glGetMaterialxv */);
}

static PFNGLGETMATERIALXVOESPROC
epoxy_glGetMaterialxvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 20083 /* glGetMaterialxvOES */);
}

static PFNGLGETMINMAXPROC
epoxy_glGetMinmax_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_imaging, 20102 /* glGetMinmax */);
}

static PFNGLGETMINMAXEXTPROC
epoxy_glGetMinmaxEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_histogram, 20114 /* glGetMinmaxEXT */);
}

static PFNGLGETMINMAXPARAMETERFVPROC
epoxy_glGetMinmaxParameterfv_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_imaging, 20129 /* glGetMinmaxParameterfv */);
}

static PFNGLGETMINMAXPARAMETERFVEXTPROC
epoxy_glGetMinmaxParameterfvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_histogram, 20152 /* glGetMinmaxParameterfvEXT */);
}

static PFNGLGETMINMAXPARAMETERIVPROC
epoxy_glGetMinmaxParameteriv_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_imaging, 20178 /* glGetMinmaxParameteriv */);
}

static PFNGLGETMINMAXPARAMETERIVEXTPROC
epoxy_glGetMinmaxParameterivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_histogram, 20201 /* glGetMinmaxParameterivEXT */);
}

static PFNGLGETMULTITEXENVFVEXTPROC
epoxy_glGetMultiTexEnvfvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20227 /* glGetMultiTexEnvfvEXT */);
}

static PFNGLGETMULTITEXENVIVEXTPROC
epoxy_glGetMultiTexEnvivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20249 /* glGetMultiTexEnvivEXT */);
}

static PFNGLGETMULTITEXGENDVEXTPROC
epoxy_glGetMultiTexGendvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20271 /* glGetMultiTexGendvEXT */);
}

static PFNGLGETMULTITEXGENFVEXTPROC
epoxy_glGetMultiTexGenfvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20293 /* glGetMultiTexGenfvEXT */);
}

static PFNGLGETMULTITEXGENIVEXTPROC
epoxy_glGetMultiTexGenivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20315 /* glGetMultiTexGenivEXT */);
}

static PFNGLGETMULTITEXIMAGEEXTPROC
epoxy_glGetMultiTexImageEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20337 /* glGetMultiTexImageEXT */);
}

static PFNGLGETMULTITEXLEVELPARAMETERFVEXTPROC
epoxy_glGetMultiTexLevelParameterfvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20359 /* glGetMultiTexLevelParameterfvEXT */);
}

static PFNGLGETMULTITEXLEVELPARAMETERIVEXTPROC
epoxy_glGetMultiTexLevelParameterivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20392 /* glGetMultiTexLevelParameterivEXT */);
}

static PFNGLGETMULTITEXPARAMETERIIVEXTPROC
epoxy_glGetMultiTexParameterIivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20425 /* glGetMultiTexParameterIivEXT */);
}

static PFNGLGETMULTITEXPARAMETERIUIVEXTPROC
epoxy_glGetMultiTexParameterIuivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20454 /* glGetMultiTexParameterIuivEXT */);
}

static PFNGLGETMULTITEXPARAMETERFVEXTPROC
epoxy_glGetMultiTexParameterfvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20484 /* glGetMultiTexParameterfvEXT */);
}

static PFNGLGETMULTITEXPARAMETERIVEXTPROC
epoxy_glGetMultiTexParameterivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20512 /* glGetMultiTexParameterivEXT */);
}

static PFNGLGETMULTISAMPLEFVPROC
epoxy_glGetMultisamplefv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_texture_multisample,
        OpenGL_ES_3_1,
        GL_extension_GL_NV_explicit_multisample,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        20540 /* "glGetMultisamplefv" */,
        20540 /* "glGetMultisamplefv" */,
        20540 /* "glGetMultisamplefv" */,
        20559 /* "glGetMultisamplefvNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 20540 /* "glGetMultisamplefv" */,
                                providers, entrypoints);
}

static PFNGLGETMULTISAMPLEFVNVPROC
epoxy_glGetMultisamplefvNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_explicit_multisample,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_texture_multisample,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        20559 /* "glGetMultisamplefvNV" */,
        20540 /* "glGetMultisamplefv" */,
        20540 /* "glGetMultisamplefv" */,
        20540 /* "glGetMultisamplefv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 20559 /* "glGetMultisamplefvNV" */,
                                providers, entrypoints);
}

static PFNGLGETNAMEDBUFFERPARAMETERI64VPROC
epoxy_glGetNamedBufferParameteri64v_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        20580 /* "glGetNamedBufferParameteri64v" */,
        20580 /* "glGetNamedBufferParameteri64v" */,
    };
    return gl_provider_resolver(entrypoint_strings + 20580 /* "glGetNamedBufferParameteri64v" */,
                                providers, entrypoints);
}

static PFNGLGETNAMEDBUFFERPARAMETERIVPROC
epoxy_glGetNamedBufferParameteriv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        20610 /* "glGetNamedBufferParameteriv" */,
        20610 /* "glGetNamedBufferParameteriv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 20610 /* "glGetNamedBufferParameteriv" */,
                                providers, entrypoints);
}

static PFNGLGETNAMEDBUFFERPARAMETERIVEXTPROC
epoxy_glGetNamedBufferParameterivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20638 /* glGetNamedBufferParameterivEXT */);
}

static PFNGLGETNAMEDBUFFERPARAMETERUI64VNVPROC
epoxy_glGetNamedBufferParameterui64vNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_shader_buffer_load, 20669 /* glGetNamedBufferParameterui64vNV */);
}

static PFNGLGETNAMEDBUFFERPOINTERVPROC
epoxy_glGetNamedBufferPointerv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        20702 /* "glGetNamedBufferPointerv" */,
        20702 /* "glGetNamedBufferPointerv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 20702 /* "glGetNamedBufferPointerv" */,
                                providers, entrypoints);
}

static PFNGLGETNAMEDBUFFERPOINTERVEXTPROC
epoxy_glGetNamedBufferPointervEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20727 /* glGetNamedBufferPointervEXT */);
}

static PFNGLGETNAMEDBUFFERSUBDATAPROC
epoxy_glGetNamedBufferSubData_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        20755 /* "glGetNamedBufferSubData" */,
        20755 /* "glGetNamedBufferSubData" */,
    };
    return gl_provider_resolver(entrypoint_strings + 20755 /* "glGetNamedBufferSubData" */,
                                providers, entrypoints);
}

static PFNGLGETNAMEDBUFFERSUBDATAEXTPROC
epoxy_glGetNamedBufferSubDataEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20779 /* glGetNamedBufferSubDataEXT */);
}

static PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVPROC
epoxy_glGetNamedFramebufferAttachmentParameteriv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        20806 /* "glGetNamedFramebufferAttachmentParameteriv" */,
        20806 /* "glGetNamedFramebufferAttachmentParameteriv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 20806 /* "glGetNamedFramebufferAttachmentParameteriv" */,
                                providers, entrypoints);
}

static PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC
epoxy_glGetNamedFramebufferAttachmentParameterivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20849 /* glGetNamedFramebufferAttachmentParameterivEXT */);
}

static PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVPROC
epoxy_glGetNamedFramebufferParameteriv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        20895 /* "glGetNamedFramebufferParameteriv" */,
        20895 /* "glGetNamedFramebufferParameteriv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 20895 /* "glGetNamedFramebufferParameteriv" */,
                                providers, entrypoints);
}

static PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVEXTPROC
epoxy_glGetNamedFramebufferParameterivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20928 /* glGetNamedFramebufferParameterivEXT */);
}

static PFNGLGETNAMEDPROGRAMLOCALPARAMETERIIVEXTPROC
epoxy_glGetNamedProgramLocalParameterIivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 20964 /* glGetNamedProgramLocalParameterIivEXT */);
}

static PFNGLGETNAMEDPROGRAMLOCALPARAMETERIUIVEXTPROC
epoxy_glGetNamedProgramLocalParameterIuivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 21002 /* glGetNamedProgramLocalParameterIuivEXT */);
}

static PFNGLGETNAMEDPROGRAMLOCALPARAMETERDVEXTPROC
epoxy_glGetNamedProgramLocalParameterdvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 21041 /* glGetNamedProgramLocalParameterdvEXT */);
}

static PFNGLGETNAMEDPROGRAMLOCALPARAMETERFVEXTPROC
epoxy_glGetNamedProgramLocalParameterfvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 21078 /* glGetNamedProgramLocalParameterfvEXT */);
}

static PFNGLGETNAMEDPROGRAMSTRINGEXTPROC
epoxy_glGetNamedProgramStringEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 21115 /* glGetNamedProgramStringEXT */);
}

static PFNGLGETNAMEDPROGRAMIVEXTPROC
epoxy_glGetNamedProgramivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 21142 /* glGetNamedProgramivEXT */);
}

static PFNGLGETNAMEDRENDERBUFFERPARAMETERIVPROC
epoxy_glGetNamedRenderbufferParameteriv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        21165 /* "glGetNamedRenderbufferParameteriv" */,
        21165 /* "glGetNamedRenderbufferParameteriv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 21165 /* "glGetNamedRenderbufferParameteriv" */,
                                providers, entrypoints);
}

static PFNGLGETNAMEDRENDERBUFFERPARAMETERIVEXTPROC
epoxy_glGetNamedRenderbufferParameterivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 21199 /* glGetNamedRenderbufferParameterivEXT */);
}

static PFNGLGETNAMEDSTRINGARBPROC
epoxy_glGetNamedStringARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_shading_language_include, 21236 /* glGetNamedStringARB */);
}

static PFNGLGETNAMEDSTRINGIVARBPROC
epoxy_glGetNamedStringivARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_shading_language_include, 21256 /* glGetNamedStringivARB */);
}

static PFNGLGETNEXTPERFQUERYIDINTELPROC
epoxy_glGetNextPerfQueryIdINTEL_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_INTEL_performance_query, 21278 /* glGetNextPerfQueryIdINTEL */);
}

static PFNGLGETOBJECTBUFFERFVATIPROC
epoxy_glGetObjectBufferfvATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_vertex_array_object, 21304 /* glGetObjectBufferfvATI */);
}

static PFNGLGETOBJECTBUFFERIVATIPROC
epoxy_glGetObjectBufferivATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_vertex_array_object, 21327 /* glGetObjectBufferivATI */);
}

static PFNGLGETOBJECTLABELPROC
epoxy_glGetObjectLabel_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        GL_extension_GL_KHR_debug,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        21350 /* "glGetObjectLabel" */,
        21350 /* "glGetObjectLabel" */,
        21387 /* "glGetObjectLabelKHR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 21350 /* "glGetObjectLabel" */,
                                providers, entrypoints);
}

static PFNGLGETOBJECTLABELEXTPROC
epoxy_glGetObjectLabelEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_debug_label, 21367 /* glGetObjectLabelEXT */);
}

static PFNGLGETOBJECTLABELKHRPROC
epoxy_glGetObjectLabelKHR_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_KHR_debug,
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        21387 /* "glGetObjectLabelKHR" */,
        21350 /* "glGetObjectLabel" */,
        21350 /* "glGetObjectLabel" */,
    };
    return gl_provider_resolver(entrypoint_strings + 21387 /* "glGetObjectLabelKHR" */,
                                providers, entrypoints);
}

static PFNGLGETOBJECTPARAMETERFVARBPROC
epoxy_glGetObjectParameterfvARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_shader_objects, 21407 /* glGetObjectParameterfvARB */);
}

static PFNGLGETOBJECTPARAMETERIVAPPLEPROC
epoxy_glGetObjectParameterivAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_object_purgeable, 21433 /* glGetObjectParameterivAPPLE */);
}

static PFNGLGETOBJECTPARAMETERIVARBPROC
epoxy_glGetObjectParameterivARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_shader_objects, 21461 /* glGetObjectParameterivARB */);
}

static PFNGLGETOBJECTPTRLABELPROC
epoxy_glGetObjectPtrLabel_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        GL_extension_GL_KHR_debug,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        21487 /* "glGetObjectPtrLabel" */,
        21487 /* "glGetObjectPtrLabel" */,
        21507 /* "glGetObjectPtrLabelKHR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 21487 /* "glGetObjectPtrLabel" */,
                                providers, entrypoints);
}

static PFNGLGETOBJECTPTRLABELKHRPROC
epoxy_glGetObjectPtrLabelKHR_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_KHR_debug,
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        21507 /* "glGetObjectPtrLabelKHR" */,
        21487 /* "glGetObjectPtrLabel" */,
        21487 /* "glGetObjectPtrLabel" */,
    };
    return gl_provider_resolver(entrypoint_strings + 21507 /* "glGetObjectPtrLabelKHR" */,
                                providers, entrypoints);
}

static PFNGLGETOCCLUSIONQUERYIVNVPROC
epoxy_glGetOcclusionQueryivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_occlusion_query, 21530 /* glGetOcclusionQueryivNV */);
}

static PFNGLGETOCCLUSIONQUERYUIVNVPROC
epoxy_glGetOcclusionQueryuivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_occlusion_query, 21554 /* glGetOcclusionQueryuivNV */);
}

static PFNGLGETPATHCOLORGENFVNVPROC
epoxy_glGetPathColorGenfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 21579 /* glGetPathColorGenfvNV */);
}

static PFNGLGETPATHCOLORGENIVNVPROC
epoxy_glGetPathColorGenivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 21601 /* glGetPathColorGenivNV */);
}

static PFNGLGETPATHCOMMANDSNVPROC
epoxy_glGetPathCommandsNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 21623 /* glGetPathCommandsNV */);
}

static PFNGLGETPATHCOORDSNVPROC
epoxy_glGetPathCoordsNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 21643 /* glGetPathCoordsNV */);
}

static PFNGLGETPATHDASHARRAYNVPROC
epoxy_glGetPathDashArrayNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 21661 /* glGetPathDashArrayNV */);
}

static PFNGLGETPATHLENGTHNVPROC
epoxy_glGetPathLengthNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 21682 /* glGetPathLengthNV */);
}

static PFNGLGETPATHMETRICRANGENVPROC
epoxy_glGetPathMetricRangeNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 21700 /* glGetPathMetricRangeNV */);
}

static PFNGLGETPATHMETRICSNVPROC
epoxy_glGetPathMetricsNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 21723 /* glGetPathMetricsNV */);
}

static PFNGLGETPATHPARAMETERFVNVPROC
epoxy_glGetPathParameterfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 21742 /* glGetPathParameterfvNV */);
}

static PFNGLGETPATHPARAMETERIVNVPROC
epoxy_glGetPathParameterivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 21765 /* glGetPathParameterivNV */);
}

static PFNGLGETPATHSPACINGNVPROC
epoxy_glGetPathSpacingNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 21788 /* glGetPathSpacingNV */);
}

static PFNGLGETPATHTEXGENFVNVPROC
epoxy_glGetPathTexGenfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 21807 /* glGetPathTexGenfvNV */);
}

static PFNGLGETPATHTEXGENIVNVPROC
epoxy_glGetPathTexGenivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 21827 /* glGetPathTexGenivNV */);
}

static PFNGLGETPERFCOUNTERINFOINTELPROC
epoxy_glGetPerfCounterInfoINTEL_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_INTEL_performance_query, 21847 /* glGetPerfCounterInfoINTEL */);
}

static PFNGLGETPERFMONITORCOUNTERDATAAMDPROC
epoxy_glGetPerfMonitorCounterDataAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_performance_monitor, 21873 /* glGetPerfMonitorCounterDataAMD */);
}

static PFNGLGETPERFMONITORCOUNTERINFOAMDPROC
epoxy_glGetPerfMonitorCounterInfoAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_performance_monitor, 21904 /* glGetPerfMonitorCounterInfoAMD */);
}

static PFNGLGETPERFMONITORCOUNTERSTRINGAMDPROC
epoxy_glGetPerfMonitorCounterStringAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_performance_monitor, 21935 /* glGetPerfMonitorCounterStringAMD */);
}

static PFNGLGETPERFMONITORCOUNTERSAMDPROC
epoxy_glGetPerfMonitorCountersAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_performance_monitor, 21968 /* glGetPerfMonitorCountersAMD */);
}

static PFNGLGETPERFMONITORGROUPSTRINGAMDPROC
epoxy_glGetPerfMonitorGroupStringAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_performance_monitor, 21996 /* glGetPerfMonitorGroupStringAMD */);
}

static PFNGLGETPERFMONITORGROUPSAMDPROC
epoxy_glGetPerfMonitorGroupsAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_performance_monitor, 22027 /* glGetPerfMonitorGroupsAMD */);
}

static PFNGLGETPERFQUERYDATAINTELPROC
epoxy_glGetPerfQueryDataINTEL_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_INTEL_performance_query, 22053 /* glGetPerfQueryDataINTEL */);
}

static PFNGLGETPERFQUERYIDBYNAMEINTELPROC
epoxy_glGetPerfQueryIdByNameINTEL_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_INTEL_performance_query, 22077 /* glGetPerfQueryIdByNameINTEL */);
}

static PFNGLGETPERFQUERYINFOINTELPROC
epoxy_glGetPerfQueryInfoINTEL_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_INTEL_performance_query, 22105 /* glGetPerfQueryInfoINTEL */);
}

static PFNGLGETPIXELMAPFVPROC
epoxy_glGetPixelMapfv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 22129 /* glGetPixelMapfv */);
}

static PFNGLGETPIXELMAPUIVPROC
epoxy_glGetPixelMapuiv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 22145 /* glGetPixelMapuiv */);
}

static PFNGLGETPIXELMAPUSVPROC
epoxy_glGetPixelMapusv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 22162 /* glGetPixelMapusv */);
}

static PFNGLGETPIXELMAPXVPROC
epoxy_glGetPixelMapxv_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 22179 /* glGetPixelMapxv */);
}

static PFNGLGETPIXELTEXGENPARAMETERFVSGISPROC
epoxy_glGetPixelTexGenParameterfvSGIS_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIS_pixel_texture, 22195 /* glGetPixelTexGenParameterfvSGIS */);
}

static PFNGLGETPIXELTEXGENPARAMETERIVSGISPROC
epoxy_glGetPixelTexGenParameterivSGIS_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIS_pixel_texture, 22227 /* glGetPixelTexGenParameterivSGIS */);
}

static PFNGLGETPIXELTRANSFORMPARAMETERFVEXTPROC
epoxy_glGetPixelTransformParameterfvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_pixel_transform, 22259 /* glGetPixelTransformParameterfvEXT */);
}

static PFNGLGETPIXELTRANSFORMPARAMETERIVEXTPROC
epoxy_glGetPixelTransformParameterivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_pixel_transform, 22293 /* glGetPixelTransformParameterivEXT */);
}

static PFNGLGETPOINTERINDEXEDVEXTPROC
epoxy_glGetPointerIndexedvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 22327 /* glGetPointerIndexedvEXT */);
}

static PFNGLGETPOINTERI_VEXTPROC
epoxy_glGetPointeri_vEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 22351 /* glGetPointeri_vEXT */);
}

static PFNGLGETPOINTERVPROC
epoxy_glGetPointerv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_1,
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        OpenGL_ES_1_0,
        GL_extension_GL_EXT_vertex_array,
        GL_extension_GL_KHR_debug,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        22370 /* "glGetPointerv" */,
        22370 /* "glGetPointerv" */,
        22370 /* "glGetPointerv" */,
        22370 /* "glGetPointerv" */,
        22384 /* "glGetPointervEXT" */,
        22401 /* "glGetPointervKHR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 22370 /* "glGetPointerv" */,
                                providers, entrypoints);
}

static PFNGLGETPOINTERVEXTPROC
epoxy_glGetPointervEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_vertex_array,
        Desktop_OpenGL_1_1,
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        OpenGL_ES_1_0,
        GL_extension_GL_KHR_debug,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        22384 /* "glGetPointervEXT" */,
        22370 /* "glGetPointerv" */,
        22370 /* "glGetPointerv" */,
        22370 /* "glGetPointerv" */,
        22370 /* "glGetPointerv" */,
        22401 /* "glGetPointervKHR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 22384 /* "glGetPointervEXT" */,
                                providers, entrypoints);
}

static PFNGLGETPOINTERVKHRPROC
epoxy_glGetPointervKHR_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_KHR_debug,
        Desktop_OpenGL_1_1,
        Desktop_OpenGL_4_3,
        GL_extension_GL_KHR_debug,
        OpenGL_ES_1_0,
        GL_extension_GL_EXT_vertex_array,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        22401 /* "glGetPointervKHR" */,
        22370 /* "glGetPointerv" */,
        22370 /* "glGetPointerv" */,
        22370 /* "glGetPointerv" */,
        22370 /* "glGetPointerv" */,
        22384 /* "glGetPointervEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 22401 /* "glGetPointervKHR" */,
                                providers, entrypoints);
}

static PFNGLGETPOLYGONSTIPPLEPROC
epoxy_glGetPolygonStipple_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 22418 /* glGetPolygonStipple */);
}

static PFNGLGETPROGRAMBINARYPROC
epoxy_glGetProgramBinary_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_get_program_binary,
        OpenGL_ES_3_0,
        GL_extension_GL_OES_get_program_binary,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        22438 /* "glGetProgramBinary" */,
        22438 /* "glGetProgramBinary" */,
        22438 /* "glGetProgramBinary" */,
        22457 /* "glGetProgramBinaryOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 22438 /* "glGetProgramBinary" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMBINARYOESPROC
epoxy_glGetProgramBinaryOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_get_program_binary,
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_get_program_binary,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        22457 /* "glGetProgramBinaryOES" */,
        22438 /* "glGetProgramBinary" */,
        22438 /* "glGetProgramBinary" */,
        22438 /* "glGetProgramBinary" */,
    };
    return gl_provider_resolver(entrypoint_strings + 22457 /* "glGetProgramBinaryOES" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMENVPARAMETERIIVNVPROC
epoxy_glGetProgramEnvParameterIivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_gpu_program4, 22479 /* glGetProgramEnvParameterIivNV */);
}

static PFNGLGETPROGRAMENVPARAMETERIUIVNVPROC
epoxy_glGetProgramEnvParameterIuivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_gpu_program4, 22509 /* glGetProgramEnvParameterIuivNV */);
}

static PFNGLGETPROGRAMENVPARAMETERDVARBPROC
epoxy_glGetProgramEnvParameterdvARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_fragment_program,
        GL_extension_GL_ARB_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        22540 /* "glGetProgramEnvParameterdvARB" */,
        22540 /* "glGetProgramEnvParameterdvARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 22540 /* "glGetProgramEnvParameterdvARB" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMENVPARAMETERFVARBPROC
epoxy_glGetProgramEnvParameterfvARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_fragment_program,
        GL_extension_GL_ARB_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        22570 /* "glGetProgramEnvParameterfvARB" */,
        22570 /* "glGetProgramEnvParameterfvARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 22570 /* "glGetProgramEnvParameterfvARB" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMINFOLOGPROC
epoxy_glGetProgramInfoLog_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        22600 /* "glGetProgramInfoLog" */,
        22600 /* "glGetProgramInfoLog" */,
    };
    return gl_provider_resolver(entrypoint_strings + 22600 /* "glGetProgramInfoLog" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMINTERFACEIVPROC
epoxy_glGetProgramInterfaceiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_program_interface_query,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        22620 /* "glGetProgramInterfaceiv" */,
        22620 /* "glGetProgramInterfaceiv" */,
        22620 /* "glGetProgramInterfaceiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 22620 /* "glGetProgramInterfaceiv" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMLOCALPARAMETERIIVNVPROC
epoxy_glGetProgramLocalParameterIivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_gpu_program4, 22644 /* glGetProgramLocalParameterIivNV */);
}

static PFNGLGETPROGRAMLOCALPARAMETERIUIVNVPROC
epoxy_glGetProgramLocalParameterIuivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_gpu_program4, 22676 /* glGetProgramLocalParameterIuivNV */);
}

static PFNGLGETPROGRAMLOCALPARAMETERDVARBPROC
epoxy_glGetProgramLocalParameterdvARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_fragment_program,
        GL_extension_GL_ARB_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        22709 /* "glGetProgramLocalParameterdvARB" */,
        22709 /* "glGetProgramLocalParameterdvARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 22709 /* "glGetProgramLocalParameterdvARB" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMLOCALPARAMETERFVARBPROC
epoxy_glGetProgramLocalParameterfvARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_fragment_program,
        GL_extension_GL_ARB_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        22741 /* "glGetProgramLocalParameterfvARB" */,
        22741 /* "glGetProgramLocalParameterfvARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 22741 /* "glGetProgramLocalParameterfvARB" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMNAMEDPARAMETERDVNVPROC
epoxy_glGetProgramNamedParameterdvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_fragment_program, 22773 /* glGetProgramNamedParameterdvNV */);
}

static PFNGLGETPROGRAMNAMEDPARAMETERFVNVPROC
epoxy_glGetProgramNamedParameterfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_fragment_program, 22804 /* glGetProgramNamedParameterfvNV */);
}

static PFNGLGETPROGRAMPARAMETERDVNVPROC
epoxy_glGetProgramParameterdvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_program, 22835 /* glGetProgramParameterdvNV */);
}

static PFNGLGETPROGRAMPARAMETERFVNVPROC
epoxy_glGetProgramParameterfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_program, 22861 /* glGetProgramParameterfvNV */);
}

static PFNGLGETPROGRAMPIPELINEINFOLOGPROC
epoxy_glGetProgramPipelineInfoLog_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_separate_shader_objects,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        22887 /* "glGetProgramPipelineInfoLog" */,
        22887 /* "glGetProgramPipelineInfoLog" */,
        22887 /* "glGetProgramPipelineInfoLog" */,
    };
    return gl_provider_resolver(entrypoint_strings + 22887 /* "glGetProgramPipelineInfoLog" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMPIPELINEINFOLOGEXTPROC
epoxy_glGetProgramPipelineInfoLogEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_separate_shader_objects, 22915 /* glGetProgramPipelineInfoLogEXT */);
}

static PFNGLGETPROGRAMPIPELINEIVPROC
epoxy_glGetProgramPipelineiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_separate_shader_objects,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        22946 /* "glGetProgramPipelineiv" */,
        22946 /* "glGetProgramPipelineiv" */,
        22946 /* "glGetProgramPipelineiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 22946 /* "glGetProgramPipelineiv" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMPIPELINEIVEXTPROC
epoxy_glGetProgramPipelineivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_separate_shader_objects, 22969 /* glGetProgramPipelineivEXT */);
}

static PFNGLGETPROGRAMRESOURCEINDEXPROC
epoxy_glGetProgramResourceIndex_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_program_interface_query,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        22995 /* "glGetProgramResourceIndex" */,
        22995 /* "glGetProgramResourceIndex" */,
        22995 /* "glGetProgramResourceIndex" */,
    };
    return gl_provider_resolver(entrypoint_strings + 22995 /* "glGetProgramResourceIndex" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMRESOURCELOCATIONPROC
epoxy_glGetProgramResourceLocation_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_program_interface_query,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23021 /* "glGetProgramResourceLocation" */,
        23021 /* "glGetProgramResourceLocation" */,
        23021 /* "glGetProgramResourceLocation" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23021 /* "glGetProgramResourceLocation" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC
epoxy_glGetProgramResourceLocationIndex_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_program_interface_query,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23050 /* "glGetProgramResourceLocationIndex" */,
        23050 /* "glGetProgramResourceLocationIndex" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23050 /* "glGetProgramResourceLocationIndex" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMRESOURCENAMEPROC
epoxy_glGetProgramResourceName_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_program_interface_query,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23084 /* "glGetProgramResourceName" */,
        23084 /* "glGetProgramResourceName" */,
        23084 /* "glGetProgramResourceName" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23084 /* "glGetProgramResourceName" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMRESOURCEFVNVPROC
epoxy_glGetProgramResourcefvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 23109 /* glGetProgramResourcefvNV */);
}

static PFNGLGETPROGRAMRESOURCEIVPROC
epoxy_glGetProgramResourceiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_program_interface_query,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23134 /* "glGetProgramResourceiv" */,
        23134 /* "glGetProgramResourceiv" */,
        23134 /* "glGetProgramResourceiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23134 /* "glGetProgramResourceiv" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMSTAGEIVPROC
epoxy_glGetProgramStageiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_shader_subroutine,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23157 /* "glGetProgramStageiv" */,
        23157 /* "glGetProgramStageiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23157 /* "glGetProgramStageiv" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMSTRINGARBPROC
epoxy_glGetProgramStringARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_fragment_program,
        GL_extension_GL_ARB_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23177 /* "glGetProgramStringARB" */,
        23177 /* "glGetProgramStringARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23177 /* "glGetProgramStringARB" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMSTRINGNVPROC
epoxy_glGetProgramStringNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_program, 23199 /* glGetProgramStringNV */);
}

static PFNGLGETPROGRAMSUBROUTINEPARAMETERUIVNVPROC
epoxy_glGetProgramSubroutineParameteruivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_gpu_program5, 23220 /* glGetProgramSubroutineParameteruivNV */);
}

static PFNGLGETPROGRAMIVPROC
epoxy_glGetProgramiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23257 /* "glGetProgramiv" */,
        23257 /* "glGetProgramiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23257 /* "glGetProgramiv" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMIVARBPROC
epoxy_glGetProgramivARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_fragment_program,
        GL_extension_GL_ARB_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23272 /* "glGetProgramivARB" */,
        23272 /* "glGetProgramivARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23272 /* "glGetProgramivARB" */,
                                providers, entrypoints);
}

static PFNGLGETPROGRAMIVNVPROC
epoxy_glGetProgramivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_program, 23290 /* glGetProgramivNV */);
}

static PFNGLGETQUERYBUFFEROBJECTI64VPROC
epoxy_glGetQueryBufferObjecti64v_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23307 /* "glGetQueryBufferObjecti64v" */,
        23307 /* "glGetQueryBufferObjecti64v" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23307 /* "glGetQueryBufferObjecti64v" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYBUFFEROBJECTIVPROC
epoxy_glGetQueryBufferObjectiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23334 /* "glGetQueryBufferObjectiv" */,
        23334 /* "glGetQueryBufferObjectiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23334 /* "glGetQueryBufferObjectiv" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYBUFFEROBJECTUI64VPROC
epoxy_glGetQueryBufferObjectui64v_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23359 /* "glGetQueryBufferObjectui64v" */,
        23359 /* "glGetQueryBufferObjectui64v" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23359 /* "glGetQueryBufferObjectui64v" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYBUFFEROBJECTUIVPROC
epoxy_glGetQueryBufferObjectuiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23387 /* "glGetQueryBufferObjectuiv" */,
        23387 /* "glGetQueryBufferObjectuiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23387 /* "glGetQueryBufferObjectuiv" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYINDEXEDIVPROC
epoxy_glGetQueryIndexediv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_transform_feedback3,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23413 /* "glGetQueryIndexediv" */,
        23413 /* "glGetQueryIndexediv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23413 /* "glGetQueryIndexediv" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYOBJECTI64VPROC
epoxy_glGetQueryObjecti64v_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_timer_query,
        GL_extension_GL_EXT_disjoint_timer_query,
        GL_extension_GL_EXT_timer_query,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23433 /* "glGetQueryObjecti64v" */,
        23433 /* "glGetQueryObjecti64v" */,
        23454 /* "glGetQueryObjecti64vEXT" */,
        23454 /* "glGetQueryObjecti64vEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23433 /* "glGetQueryObjecti64v" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYOBJECTI64VEXTPROC
epoxy_glGetQueryObjecti64vEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_disjoint_timer_query,
        GL_extension_GL_EXT_timer_query,
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_timer_query,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23454 /* "glGetQueryObjecti64vEXT" */,
        23454 /* "glGetQueryObjecti64vEXT" */,
        23433 /* "glGetQueryObjecti64v" */,
        23433 /* "glGetQueryObjecti64v" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23454 /* "glGetQueryObjecti64vEXT" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYOBJECTIVPROC
epoxy_glGetQueryObjectiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        GL_extension_GL_ARB_occlusion_query,
        GL_extension_GL_EXT_disjoint_timer_query,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23478 /* "glGetQueryObjectiv" */,
        23497 /* "glGetQueryObjectivARB" */,
        23519 /* "glGetQueryObjectivEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23478 /* "glGetQueryObjectiv" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYOBJECTIVARBPROC
epoxy_glGetQueryObjectivARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_occlusion_query,
        Desktop_OpenGL_1_5,
        GL_extension_GL_EXT_disjoint_timer_query,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23497 /* "glGetQueryObjectivARB" */,
        23478 /* "glGetQueryObjectiv" */,
        23519 /* "glGetQueryObjectivEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23497 /* "glGetQueryObjectivARB" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYOBJECTIVEXTPROC
epoxy_glGetQueryObjectivEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_disjoint_timer_query,
        Desktop_OpenGL_1_5,
        GL_extension_GL_ARB_occlusion_query,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23519 /* "glGetQueryObjectivEXT" */,
        23478 /* "glGetQueryObjectiv" */,
        23497 /* "glGetQueryObjectivARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23519 /* "glGetQueryObjectivEXT" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYOBJECTUI64VPROC
epoxy_glGetQueryObjectui64v_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_timer_query,
        GL_extension_GL_EXT_disjoint_timer_query,
        GL_extension_GL_EXT_timer_query,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23541 /* "glGetQueryObjectui64v" */,
        23541 /* "glGetQueryObjectui64v" */,
        23563 /* "glGetQueryObjectui64vEXT" */,
        23563 /* "glGetQueryObjectui64vEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23541 /* "glGetQueryObjectui64v" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYOBJECTUI64VEXTPROC
epoxy_glGetQueryObjectui64vEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_disjoint_timer_query,
        GL_extension_GL_EXT_timer_query,
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_timer_query,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23563 /* "glGetQueryObjectui64vEXT" */,
        23563 /* "glGetQueryObjectui64vEXT" */,
        23541 /* "glGetQueryObjectui64v" */,
        23541 /* "glGetQueryObjectui64v" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23563 /* "glGetQueryObjectui64vEXT" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYOBJECTUIVPROC
epoxy_glGetQueryObjectuiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_occlusion_query,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23588 /* "glGetQueryObjectuiv" */,
        23588 /* "glGetQueryObjectuiv" */,
        23608 /* "glGetQueryObjectuivARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23588 /* "glGetQueryObjectuiv" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYOBJECTUIVARBPROC
epoxy_glGetQueryObjectuivARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_occlusion_query,
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23608 /* "glGetQueryObjectuivARB" */,
        23588 /* "glGetQueryObjectuiv" */,
        23588 /* "glGetQueryObjectuiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23608 /* "glGetQueryObjectuivARB" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYOBJECTUIVEXTPROC
epoxy_glGetQueryObjectuivEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_disjoint_timer_query,
        GL_extension_GL_EXT_occlusion_query_boolean,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23631 /* "glGetQueryObjectuivEXT" */,
        23631 /* "glGetQueryObjectuivEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23631 /* "glGetQueryObjectuivEXT" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYIVPROC
epoxy_glGetQueryiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_occlusion_query,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23654 /* "glGetQueryiv" */,
        23654 /* "glGetQueryiv" */,
        23667 /* "glGetQueryivARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23654 /* "glGetQueryiv" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYIVARBPROC
epoxy_glGetQueryivARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_occlusion_query,
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23667 /* "glGetQueryivARB" */,
        23654 /* "glGetQueryiv" */,
        23654 /* "glGetQueryiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23667 /* "glGetQueryivARB" */,
                                providers, entrypoints);
}

static PFNGLGETQUERYIVEXTPROC
epoxy_glGetQueryivEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_disjoint_timer_query,
        GL_extension_GL_EXT_occlusion_query_boolean,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23683 /* "glGetQueryivEXT" */,
        23683 /* "glGetQueryivEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23683 /* "glGetQueryivEXT" */,
                                providers, entrypoints);
}

static PFNGLGETRENDERBUFFERPARAMETERIVPROC
epoxy_glGetRenderbufferParameteriv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_framebuffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23699 /* "glGetRenderbufferParameteriv" */,
        23699 /* "glGetRenderbufferParameteriv" */,
        23699 /* "glGetRenderbufferParameteriv" */,
        23728 /* "glGetRenderbufferParameterivEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23699 /* "glGetRenderbufferParameteriv" */,
                                providers, entrypoints);
}

static PFNGLGETRENDERBUFFERPARAMETERIVEXTPROC
epoxy_glGetRenderbufferParameterivEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23728 /* "glGetRenderbufferParameterivEXT" */,
        23699 /* "glGetRenderbufferParameteriv" */,
        23699 /* "glGetRenderbufferParameteriv" */,
        23699 /* "glGetRenderbufferParameteriv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23728 /* "glGetRenderbufferParameterivEXT" */,
                                providers, entrypoints);
}

static PFNGLGETRENDERBUFFERPARAMETERIVOESPROC
epoxy_glGetRenderbufferParameterivOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_framebuffer_object, 23760 /* glGetRenderbufferParameterivOES */);
}

static PFNGLGETSAMPLERPARAMETERIIVPROC
epoxy_glGetSamplerParameterIiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_sampler_objects,
        GL_extension_GL_EXT_texture_border_clamp,
        GL_extension_GL_OES_texture_border_clamp,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23792 /* "glGetSamplerParameterIiv" */,
        23792 /* "glGetSamplerParameterIiv" */,
        23817 /* "glGetSamplerParameterIivEXT" */,
        23845 /* "glGetSamplerParameterIivOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23792 /* "glGetSamplerParameterIiv" */,
                                providers, entrypoints);
}

static PFNGLGETSAMPLERPARAMETERIIVEXTPROC
epoxy_glGetSamplerParameterIivEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_texture_border_clamp,
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_sampler_objects,
        GL_extension_GL_OES_texture_border_clamp,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23817 /* "glGetSamplerParameterIivEXT" */,
        23792 /* "glGetSamplerParameterIiv" */,
        23792 /* "glGetSamplerParameterIiv" */,
        23845 /* "glGetSamplerParameterIivOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23817 /* "glGetSamplerParameterIivEXT" */,
                                providers, entrypoints);
}

static PFNGLGETSAMPLERPARAMETERIIVOESPROC
epoxy_glGetSamplerParameterIivOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_texture_border_clamp,
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_sampler_objects,
        GL_extension_GL_EXT_texture_border_clamp,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23845 /* "glGetSamplerParameterIivOES" */,
        23792 /* "glGetSamplerParameterIiv" */,
        23792 /* "glGetSamplerParameterIiv" */,
        23817 /* "glGetSamplerParameterIivEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23845 /* "glGetSamplerParameterIivOES" */,
                                providers, entrypoints);
}

static PFNGLGETSAMPLERPARAMETERIUIVPROC
epoxy_glGetSamplerParameterIuiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_sampler_objects,
        GL_extension_GL_EXT_texture_border_clamp,
        GL_extension_GL_OES_texture_border_clamp,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23873 /* "glGetSamplerParameterIuiv" */,
        23873 /* "glGetSamplerParameterIuiv" */,
        23899 /* "glGetSamplerParameterIuivEXT" */,
        23928 /* "glGetSamplerParameterIuivOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23873 /* "glGetSamplerParameterIuiv" */,
                                providers, entrypoints);
}

static PFNGLGETSAMPLERPARAMETERIUIVEXTPROC
epoxy_glGetSamplerParameterIuivEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_texture_border_clamp,
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_sampler_objects,
        GL_extension_GL_OES_texture_border_clamp,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23899 /* "glGetSamplerParameterIuivEXT" */,
        23873 /* "glGetSamplerParameterIuiv" */,
        23873 /* "glGetSamplerParameterIuiv" */,
        23928 /* "glGetSamplerParameterIuivOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23899 /* "glGetSamplerParameterIuivEXT" */,
                                providers, entrypoints);
}

static PFNGLGETSAMPLERPARAMETERIUIVOESPROC
epoxy_glGetSamplerParameterIuivOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_texture_border_clamp,
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_sampler_objects,
        GL_extension_GL_EXT_texture_border_clamp,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23928 /* "glGetSamplerParameterIuivOES" */,
        23873 /* "glGetSamplerParameterIuiv" */,
        23873 /* "glGetSamplerParameterIuiv" */,
        23899 /* "glGetSamplerParameterIuivEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23928 /* "glGetSamplerParameterIuivOES" */,
                                providers, entrypoints);
}

static PFNGLGETSAMPLERPARAMETERFVPROC
epoxy_glGetSamplerParameterfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_sampler_objects,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23957 /* "glGetSamplerParameterfv" */,
        23957 /* "glGetSamplerParameterfv" */,
        23957 /* "glGetSamplerParameterfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23957 /* "glGetSamplerParameterfv" */,
                                providers, entrypoints);
}

static PFNGLGETSAMPLERPARAMETERIVPROC
epoxy_glGetSamplerParameteriv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_sampler_objects,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        23981 /* "glGetSamplerParameteriv" */,
        23981 /* "glGetSamplerParameteriv" */,
        23981 /* "glGetSamplerParameteriv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 23981 /* "glGetSamplerParameteriv" */,
                                providers, entrypoints);
}

static PFNGLGETSEPARABLEFILTERPROC
epoxy_glGetSeparableFilter_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_imaging, 24005 /* glGetSeparableFilter */);
}

static PFNGLGETSEPARABLEFILTEREXTPROC
epoxy_glGetSeparableFilterEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_convolution, 24026 /* glGetSeparableFilterEXT */);
}

static PFNGLGETSHADERINFOLOGPROC
epoxy_glGetShaderInfoLog_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24050 /* "glGetShaderInfoLog" */,
        24050 /* "glGetShaderInfoLog" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24050 /* "glGetShaderInfoLog" */,
                                providers, entrypoints);
}

static PFNGLGETSHADERPRECISIONFORMATPROC
epoxy_glGetShaderPrecisionFormat_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_ES2_compatibility,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24069 /* "glGetShaderPrecisionFormat" */,
        24069 /* "glGetShaderPrecisionFormat" */,
        24069 /* "glGetShaderPrecisionFormat" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24069 /* "glGetShaderPrecisionFormat" */,
                                providers, entrypoints);
}

static PFNGLGETSHADERSOURCEPROC
epoxy_glGetShaderSource_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_shader_objects,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24096 /* "glGetShaderSource" */,
        24096 /* "glGetShaderSource" */,
        24114 /* "glGetShaderSourceARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24096 /* "glGetShaderSource" */,
                                providers, entrypoints);
}

static PFNGLGETSHADERSOURCEARBPROC
epoxy_glGetShaderSourceARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_shader_objects,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24114 /* "glGetShaderSourceARB" */,
        24096 /* "glGetShaderSource" */,
        24096 /* "glGetShaderSource" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24114 /* "glGetShaderSourceARB" */,
                                providers, entrypoints);
}

static PFNGLGETSHADERIVPROC
epoxy_glGetShaderiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24135 /* "glGetShaderiv" */,
        24135 /* "glGetShaderiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24135 /* "glGetShaderiv" */,
                                providers, entrypoints);
}

static PFNGLGETSHARPENTEXFUNCSGISPROC
epoxy_glGetSharpenTexFuncSGIS_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIS_sharpen_texture, 24149 /* glGetSharpenTexFuncSGIS */);
}

static PFNGLGETSTAGEINDEXNVPROC
epoxy_glGetStageIndexNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_command_list, 24173 /* glGetStageIndexNV */);
}

static PFNGLGETSTRINGPROC
epoxy_glGetString_resolver(void)
{
    return gl_single_resolver(always_present, 24191 /* glGetString */);
}

static PFNGLGETSTRINGIPROC
epoxy_glGetStringi_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24203 /* "glGetStringi" */,
        24203 /* "glGetStringi" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24203 /* "glGetStringi" */,
                                providers, entrypoints);
}

static PFNGLGETSUBROUTINEINDEXPROC
epoxy_glGetSubroutineIndex_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_shader_subroutine,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24216 /* "glGetSubroutineIndex" */,
        24216 /* "glGetSubroutineIndex" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24216 /* "glGetSubroutineIndex" */,
                                providers, entrypoints);
}

static PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC
epoxy_glGetSubroutineUniformLocation_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_shader_subroutine,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24237 /* "glGetSubroutineUniformLocation" */,
        24237 /* "glGetSubroutineUniformLocation" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24237 /* "glGetSubroutineUniformLocation" */,
                                providers, entrypoints);
}

static PFNGLGETSYNCIVPROC
epoxy_glGetSynciv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_sync,
        OpenGL_ES_3_0,
        GL_extension_GL_APPLE_sync,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24268 /* "glGetSynciv" */,
        24268 /* "glGetSynciv" */,
        24268 /* "glGetSynciv" */,
        24280 /* "glGetSyncivAPPLE" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24268 /* "glGetSynciv" */,
                                providers, entrypoints);
}

static PFNGLGETSYNCIVAPPLEPROC
epoxy_glGetSyncivAPPLE_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_APPLE_sync,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_sync,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24280 /* "glGetSyncivAPPLE" */,
        24268 /* "glGetSynciv" */,
        24268 /* "glGetSynciv" */,
        24268 /* "glGetSynciv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24280 /* "glGetSyncivAPPLE" */,
                                providers, entrypoints);
}

static PFNGLGETTEXBUMPPARAMETERFVATIPROC
epoxy_glGetTexBumpParameterfvATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_envmap_bumpmap, 24297 /* glGetTexBumpParameterfvATI */);
}

static PFNGLGETTEXBUMPPARAMETERIVATIPROC
epoxy_glGetTexBumpParameterivATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_envmap_bumpmap, 24324 /* glGetTexBumpParameterivATI */);
}

static PFNGLGETTEXENVFVPROC
epoxy_glGetTexEnvfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24351 /* "glGetTexEnvfv" */,
        24351 /* "glGetTexEnvfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24351 /* "glGetTexEnvfv" */,
                                providers, entrypoints);
}

static PFNGLGETTEXENVIVPROC
epoxy_glGetTexEnviv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24365 /* "glGetTexEnviv" */,
        24365 /* "glGetTexEnviv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24365 /* "glGetTexEnviv" */,
                                providers, entrypoints);
}

static PFNGLGETTEXENVXVPROC
epoxy_glGetTexEnvxv_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 24379 /* glGetTexEnvxv */);
}

static PFNGLGETTEXENVXVOESPROC
epoxy_glGetTexEnvxvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 24393 /* glGetTexEnvxvOES */);
}

static PFNGLGETTEXFILTERFUNCSGISPROC
epoxy_glGetTexFilterFuncSGIS_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIS_texture_filter4, 24410 /* glGetTexFilterFuncSGIS */);
}

static PFNGLGETTEXGENDVPROC
epoxy_glGetTexGendv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 24433 /* glGetTexGendv */);
}

static PFNGLGETTEXGENFVPROC
epoxy_glGetTexGenfv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 24447 /* glGetTexGenfv */);
}

static PFNGLGETTEXGENFVOESPROC
epoxy_glGetTexGenfvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_texture_cube_map, 24461 /* glGetTexGenfvOES */);
}

static PFNGLGETTEXGENIVPROC
epoxy_glGetTexGeniv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 24478 /* glGetTexGeniv */);
}

static PFNGLGETTEXGENIVOESPROC
epoxy_glGetTexGenivOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_texture_cube_map, 24492 /* glGetTexGenivOES */);
}

static PFNGLGETTEXGENXVOESPROC
epoxy_glGetTexGenxvOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_fixed_point,
        GL_extension_GL_OES_texture_cube_map,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24509 /* "glGetTexGenxvOES" */,
        24509 /* "glGetTexGenxvOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24509 /* "glGetTexGenxvOES" */,
                                providers, entrypoints);
}

static PFNGLGETTEXIMAGEPROC
epoxy_glGetTexImage_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 24526 /* glGetTexImage */);
}

static PFNGLGETTEXLEVELPARAMETERFVPROC
epoxy_glGetTexLevelParameterfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24540 /* "glGetTexLevelParameterfv" */,
        24540 /* "glGetTexLevelParameterfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24540 /* "glGetTexLevelParameterfv" */,
                                providers, entrypoints);
}

static PFNGLGETTEXLEVELPARAMETERIVPROC
epoxy_glGetTexLevelParameteriv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24565 /* "glGetTexLevelParameteriv" */,
        24565 /* "glGetTexLevelParameteriv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24565 /* "glGetTexLevelParameteriv" */,
                                providers, entrypoints);
}

static PFNGLGETTEXLEVELPARAMETERXVOESPROC
epoxy_glGetTexLevelParameterxvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 24590 /* glGetTexLevelParameterxvOES */);
}

static PFNGLGETTEXPARAMETERIIVPROC
epoxy_glGetTexParameterIiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_texture_border_clamp,
        GL_extension_GL_EXT_texture_integer,
        GL_extension_GL_OES_texture_border_clamp,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24618 /* "glGetTexParameterIiv" */,
        24639 /* "glGetTexParameterIivEXT" */,
        24639 /* "glGetTexParameterIivEXT" */,
        24663 /* "glGetTexParameterIivOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24618 /* "glGetTexParameterIiv" */,
                                providers, entrypoints);
}

static PFNGLGETTEXPARAMETERIIVEXTPROC
epoxy_glGetTexParameterIivEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_texture_border_clamp,
        GL_extension_GL_EXT_texture_integer,
        Desktop_OpenGL_3_0,
        GL_extension_GL_OES_texture_border_clamp,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24639 /* "glGetTexParameterIivEXT" */,
        24639 /* "glGetTexParameterIivEXT" */,
        24618 /* "glGetTexParameterIiv" */,
        24663 /* "glGetTexParameterIivOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24639 /* "glGetTexParameterIivEXT" */,
                                providers, entrypoints);
}

static PFNGLGETTEXPARAMETERIIVOESPROC
epoxy_glGetTexParameterIivOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_texture_border_clamp,
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_texture_border_clamp,
        GL_extension_GL_EXT_texture_integer,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24663 /* "glGetTexParameterIivOES" */,
        24618 /* "glGetTexParameterIiv" */,
        24639 /* "glGetTexParameterIivEXT" */,
        24639 /* "glGetTexParameterIivEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24663 /* "glGetTexParameterIivOES" */,
                                providers, entrypoints);
}

static PFNGLGETTEXPARAMETERIUIVPROC
epoxy_glGetTexParameterIuiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_texture_border_clamp,
        GL_extension_GL_EXT_texture_integer,
        GL_extension_GL_OES_texture_border_clamp,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24687 /* "glGetTexParameterIuiv" */,
        24709 /* "glGetTexParameterIuivEXT" */,
        24709 /* "glGetTexParameterIuivEXT" */,
        24734 /* "glGetTexParameterIuivOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24687 /* "glGetTexParameterIuiv" */,
                                providers, entrypoints);
}

static PFNGLGETTEXPARAMETERIUIVEXTPROC
epoxy_glGetTexParameterIuivEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_texture_border_clamp,
        GL_extension_GL_EXT_texture_integer,
        Desktop_OpenGL_3_0,
        GL_extension_GL_OES_texture_border_clamp,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24709 /* "glGetTexParameterIuivEXT" */,
        24709 /* "glGetTexParameterIuivEXT" */,
        24687 /* "glGetTexParameterIuiv" */,
        24734 /* "glGetTexParameterIuivOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24709 /* "glGetTexParameterIuivEXT" */,
                                providers, entrypoints);
}

static PFNGLGETTEXPARAMETERIUIVOESPROC
epoxy_glGetTexParameterIuivOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_texture_border_clamp,
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_texture_border_clamp,
        GL_extension_GL_EXT_texture_integer,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24734 /* "glGetTexParameterIuivOES" */,
        24687 /* "glGetTexParameterIuiv" */,
        24709 /* "glGetTexParameterIuivEXT" */,
        24709 /* "glGetTexParameterIuivEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24734 /* "glGetTexParameterIuivOES" */,
                                providers, entrypoints);
}

static PFNGLGETTEXPARAMETERPOINTERVAPPLEPROC
epoxy_glGetTexParameterPointervAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_texture_range, 24759 /* glGetTexParameterPointervAPPLE */);
}

static PFNGLGETTEXPARAMETERFVPROC
epoxy_glGetTexParameterfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24790 /* "glGetTexParameterfv" */,
        24790 /* "glGetTexParameterfv" */,
        24790 /* "glGetTexParameterfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24790 /* "glGetTexParameterfv" */,
                                providers, entrypoints);
}

static PFNGLGETTEXPARAMETERIVPROC
epoxy_glGetTexParameteriv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24810 /* "glGetTexParameteriv" */,
        24810 /* "glGetTexParameteriv" */,
        24810 /* "glGetTexParameteriv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24810 /* "glGetTexParameteriv" */,
                                providers, entrypoints);
}

static PFNGLGETTEXPARAMETERXVPROC
epoxy_glGetTexParameterxv_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 24830 /* glGetTexParameterxv */);
}

static PFNGLGETTEXPARAMETERXVOESPROC
epoxy_glGetTexParameterxvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 24850 /* glGetTexParameterxvOES */);
}

static PFNGLGETTEXTUREHANDLEARBPROC
epoxy_glGetTextureHandleARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_bindless_texture, 24873 /* glGetTextureHandleARB */);
}

static PFNGLGETTEXTUREHANDLENVPROC
epoxy_glGetTextureHandleNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_bindless_texture, 24895 /* glGetTextureHandleNV */);
}

static PFNGLGETTEXTUREIMAGEPROC
epoxy_glGetTextureImage_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24916 /* "glGetTextureImage" */,
        24916 /* "glGetTextureImage" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24916 /* "glGetTextureImage" */,
                                providers, entrypoints);
}

static PFNGLGETTEXTUREIMAGEEXTPROC
epoxy_glGetTextureImageEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 24934 /* glGetTextureImageEXT */);
}

static PFNGLGETTEXTURELEVELPARAMETERFVPROC
epoxy_glGetTextureLevelParameterfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        24955 /* "glGetTextureLevelParameterfv" */,
        24955 /* "glGetTextureLevelParameterfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 24955 /* "glGetTextureLevelParameterfv" */,
                                providers, entrypoints);
}

static PFNGLGETTEXTURELEVELPARAMETERFVEXTPROC
epoxy_glGetTextureLevelParameterfvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 24984 /* glGetTextureLevelParameterfvEXT */);
}

static PFNGLGETTEXTURELEVELPARAMETERIVPROC
epoxy_glGetTextureLevelParameteriv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25016 /* "glGetTextureLevelParameteriv" */,
        25016 /* "glGetTextureLevelParameteriv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25016 /* "glGetTextureLevelParameteriv" */,
                                providers, entrypoints);
}

static PFNGLGETTEXTURELEVELPARAMETERIVEXTPROC
epoxy_glGetTextureLevelParameterivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 25045 /* glGetTextureLevelParameterivEXT */);
}

static PFNGLGETTEXTUREPARAMETERIIVPROC
epoxy_glGetTextureParameterIiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25077 /* "glGetTextureParameterIiv" */,
        25077 /* "glGetTextureParameterIiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25077 /* "glGetTextureParameterIiv" */,
                                providers, entrypoints);
}

static PFNGLGETTEXTUREPARAMETERIIVEXTPROC
epoxy_glGetTextureParameterIivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 25102 /* glGetTextureParameterIivEXT */);
}

static PFNGLGETTEXTUREPARAMETERIUIVPROC
epoxy_glGetTextureParameterIuiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25130 /* "glGetTextureParameterIuiv" */,
        25130 /* "glGetTextureParameterIuiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25130 /* "glGetTextureParameterIuiv" */,
                                providers, entrypoints);
}

static PFNGLGETTEXTUREPARAMETERIUIVEXTPROC
epoxy_glGetTextureParameterIuivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 25156 /* glGetTextureParameterIuivEXT */);
}

static PFNGLGETTEXTUREPARAMETERFVPROC
epoxy_glGetTextureParameterfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25185 /* "glGetTextureParameterfv" */,
        25185 /* "glGetTextureParameterfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25185 /* "glGetTextureParameterfv" */,
                                providers, entrypoints);
}

static PFNGLGETTEXTUREPARAMETERFVEXTPROC
epoxy_glGetTextureParameterfvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 25209 /* glGetTextureParameterfvEXT */);
}

static PFNGLGETTEXTUREPARAMETERIVPROC
epoxy_glGetTextureParameteriv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25236 /* "glGetTextureParameteriv" */,
        25236 /* "glGetTextureParameteriv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25236 /* "glGetTextureParameteriv" */,
                                providers, entrypoints);
}

static PFNGLGETTEXTUREPARAMETERIVEXTPROC
epoxy_glGetTextureParameterivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 25260 /* glGetTextureParameterivEXT */);
}

static PFNGLGETTEXTURESAMPLERHANDLEARBPROC
epoxy_glGetTextureSamplerHandleARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_bindless_texture, 25287 /* glGetTextureSamplerHandleARB */);
}

static PFNGLGETTEXTURESAMPLERHANDLENVPROC
epoxy_glGetTextureSamplerHandleNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_bindless_texture, 25316 /* glGetTextureSamplerHandleNV */);
}

static PFNGLGETTEXTURESUBIMAGEPROC
epoxy_glGetTextureSubImage_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_get_texture_sub_image,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25344 /* "glGetTextureSubImage" */,
        25344 /* "glGetTextureSubImage" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25344 /* "glGetTextureSubImage" */,
                                providers, entrypoints);
}

static PFNGLGETTRACKMATRIXIVNVPROC
epoxy_glGetTrackMatrixivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_program, 25365 /* glGetTrackMatrixivNV */);
}

static PFNGLGETTRANSFORMFEEDBACKVARYINGPROC
epoxy_glGetTransformFeedbackVarying_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_transform_feedback,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25386 /* "glGetTransformFeedbackVarying" */,
        25386 /* "glGetTransformFeedbackVarying" */,
        25416 /* "glGetTransformFeedbackVaryingEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25386 /* "glGetTransformFeedbackVarying" */,
                                providers, entrypoints);
}

static PFNGLGETTRANSFORMFEEDBACKVARYINGEXTPROC
epoxy_glGetTransformFeedbackVaryingEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_transform_feedback,
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25416 /* "glGetTransformFeedbackVaryingEXT" */,
        25386 /* "glGetTransformFeedbackVarying" */,
        25386 /* "glGetTransformFeedbackVarying" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25416 /* "glGetTransformFeedbackVaryingEXT" */,
                                providers, entrypoints);
}

static PFNGLGETTRANSFORMFEEDBACKVARYINGNVPROC
epoxy_glGetTransformFeedbackVaryingNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_transform_feedback, 25449 /* glGetTransformFeedbackVaryingNV */);
}

static PFNGLGETTRANSFORMFEEDBACKI64_VPROC
epoxy_glGetTransformFeedbacki64_v_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25481 /* "glGetTransformFeedbacki64_v" */,
        25481 /* "glGetTransformFeedbacki64_v" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25481 /* "glGetTransformFeedbacki64_v" */,
                                providers, entrypoints);
}

static PFNGLGETTRANSFORMFEEDBACKI_VPROC
epoxy_glGetTransformFeedbacki_v_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25509 /* "glGetTransformFeedbacki_v" */,
        25509 /* "glGetTransformFeedbacki_v" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25509 /* "glGetTransformFeedbacki_v" */,
                                providers, entrypoints);
}

static PFNGLGETTRANSFORMFEEDBACKIVPROC
epoxy_glGetTransformFeedbackiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25535 /* "glGetTransformFeedbackiv" */,
        25535 /* "glGetTransformFeedbackiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25535 /* "glGetTransformFeedbackiv" */,
                                providers, entrypoints);
}

static PFNGLGETTRANSLATEDSHADERSOURCEANGLEPROC
epoxy_glGetTranslatedShaderSourceANGLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ANGLE_translated_shader_source, 25560 /* glGetTranslatedShaderSourceANGLE */);
}

static PFNGLGETUNIFORMBLOCKINDEXPROC
epoxy_glGetUniformBlockIndex_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25593 /* "glGetUniformBlockIndex" */,
        25593 /* "glGetUniformBlockIndex" */,
        25593 /* "glGetUniformBlockIndex" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25593 /* "glGetUniformBlockIndex" */,
                                providers, entrypoints);
}

static PFNGLGETUNIFORMBUFFERSIZEEXTPROC
epoxy_glGetUniformBufferSizeEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_bindable_uniform, 25616 /* glGetUniformBufferSizeEXT */);
}

static PFNGLGETUNIFORMINDICESPROC
epoxy_glGetUniformIndices_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25642 /* "glGetUniformIndices" */,
        25642 /* "glGetUniformIndices" */,
        25642 /* "glGetUniformIndices" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25642 /* "glGetUniformIndices" */,
                                providers, entrypoints);
}

static PFNGLGETUNIFORMLOCATIONPROC
epoxy_glGetUniformLocation_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_shader_objects,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25662 /* "glGetUniformLocation" */,
        25662 /* "glGetUniformLocation" */,
        25683 /* "glGetUniformLocationARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25662 /* "glGetUniformLocation" */,
                                providers, entrypoints);
}

static PFNGLGETUNIFORMLOCATIONARBPROC
epoxy_glGetUniformLocationARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_shader_objects,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25683 /* "glGetUniformLocationARB" */,
        25662 /* "glGetUniformLocation" */,
        25662 /* "glGetUniformLocation" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25683 /* "glGetUniformLocationARB" */,
                                providers, entrypoints);
}

static PFNGLGETUNIFORMOFFSETEXTPROC
epoxy_glGetUniformOffsetEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_bindable_uniform, 25707 /* glGetUniformOffsetEXT */);
}

static PFNGLGETUNIFORMSUBROUTINEUIVPROC
epoxy_glGetUniformSubroutineuiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_shader_subroutine,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25729 /* "glGetUniformSubroutineuiv" */,
        25729 /* "glGetUniformSubroutineuiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25729 /* "glGetUniformSubroutineuiv" */,
                                providers, entrypoints);
}

static PFNGLGETUNIFORMDVPROC
epoxy_glGetUniformdv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_gpu_shader_fp64,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25755 /* "glGetUniformdv" */,
        25755 /* "glGetUniformdv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25755 /* "glGetUniformdv" */,
                                providers, entrypoints);
}

static PFNGLGETUNIFORMFVPROC
epoxy_glGetUniformfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_shader_objects,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25770 /* "glGetUniformfv" */,
        25770 /* "glGetUniformfv" */,
        25785 /* "glGetUniformfvARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25770 /* "glGetUniformfv" */,
                                providers, entrypoints);
}

static PFNGLGETUNIFORMFVARBPROC
epoxy_glGetUniformfvARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_shader_objects,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25785 /* "glGetUniformfvARB" */,
        25770 /* "glGetUniformfv" */,
        25770 /* "glGetUniformfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25785 /* "glGetUniformfvARB" */,
                                providers, entrypoints);
}

static PFNGLGETUNIFORMI64VNVPROC
epoxy_glGetUniformi64vNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_AMD_gpu_shader_int64,
        GL_extension_GL_NV_gpu_shader5,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25803 /* "glGetUniformi64vNV" */,
        25803 /* "glGetUniformi64vNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25803 /* "glGetUniformi64vNV" */,
                                providers, entrypoints);
}

static PFNGLGETUNIFORMIVPROC
epoxy_glGetUniformiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_shader_objects,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25822 /* "glGetUniformiv" */,
        25822 /* "glGetUniformiv" */,
        25837 /* "glGetUniformivARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25822 /* "glGetUniformiv" */,
                                providers, entrypoints);
}

static PFNGLGETUNIFORMIVARBPROC
epoxy_glGetUniformivARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_shader_objects,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25837 /* "glGetUniformivARB" */,
        25822 /* "glGetUniformiv" */,
        25822 /* "glGetUniformiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25837 /* "glGetUniformivARB" */,
                                providers, entrypoints);
}

static PFNGLGETUNIFORMUI64VNVPROC
epoxy_glGetUniformui64vNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_AMD_gpu_shader_int64,
        GL_extension_GL_NV_shader_buffer_load,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25855 /* "glGetUniformui64vNV" */,
        25855 /* "glGetUniformui64vNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25855 /* "glGetUniformui64vNV" */,
                                providers, entrypoints);
}

static PFNGLGETUNIFORMUIVPROC
epoxy_glGetUniformuiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_gpu_shader4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25875 /* "glGetUniformuiv" */,
        25875 /* "glGetUniformuiv" */,
        25891 /* "glGetUniformuivEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25875 /* "glGetUniformuiv" */,
                                providers, entrypoints);
}

static PFNGLGETUNIFORMUIVEXTPROC
epoxy_glGetUniformuivEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_gpu_shader4,
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        25891 /* "glGetUniformuivEXT" */,
        25875 /* "glGetUniformuiv" */,
        25875 /* "glGetUniformuiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 25891 /* "glGetUniformuivEXT" */,
                                providers, entrypoints);
}

static PFNGLGETVARIANTARRAYOBJECTFVATIPROC
epoxy_glGetVariantArrayObjectfvATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_vertex_array_object, 25910 /* glGetVariantArrayObjectfvATI */);
}

static PFNGLGETVARIANTARRAYOBJECTIVATIPROC
epoxy_glGetVariantArrayObjectivATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_vertex_array_object, 25939 /* glGetVariantArrayObjectivATI */);
}

static PFNGLGETVARIANTBOOLEANVEXTPROC
epoxy_glGetVariantBooleanvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 25968 /* glGetVariantBooleanvEXT */);
}

static PFNGLGETVARIANTFLOATVEXTPROC
epoxy_glGetVariantFloatvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 25992 /* glGetVariantFloatvEXT */);
}

static PFNGLGETVARIANTINTEGERVEXTPROC
epoxy_glGetVariantIntegervEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 26014 /* glGetVariantIntegervEXT */);
}

static PFNGLGETVARIANTPOINTERVEXTPROC
epoxy_glGetVariantPointervEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 26038 /* glGetVariantPointervEXT */);
}

static PFNGLGETVARYINGLOCATIONNVPROC
epoxy_glGetVaryingLocationNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_transform_feedback, 26062 /* glGetVaryingLocationNV */);
}

static PFNGLGETVERTEXARRAYINDEXED64IVPROC
epoxy_glGetVertexArrayIndexed64iv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26085 /* "glGetVertexArrayIndexed64iv" */,
        26085 /* "glGetVertexArrayIndexed64iv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26085 /* "glGetVertexArrayIndexed64iv" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXARRAYINDEXEDIVPROC
epoxy_glGetVertexArrayIndexediv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26113 /* "glGetVertexArrayIndexediv" */,
        26113 /* "glGetVertexArrayIndexediv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26113 /* "glGetVertexArrayIndexediv" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXARRAYINTEGERI_VEXTPROC
epoxy_glGetVertexArrayIntegeri_vEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 26139 /* glGetVertexArrayIntegeri_vEXT */);
}

static PFNGLGETVERTEXARRAYINTEGERVEXTPROC
epoxy_glGetVertexArrayIntegervEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 26169 /* glGetVertexArrayIntegervEXT */);
}

static PFNGLGETVERTEXARRAYPOINTERI_VEXTPROC
epoxy_glGetVertexArrayPointeri_vEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 26197 /* glGetVertexArrayPointeri_vEXT */);
}

static PFNGLGETVERTEXARRAYPOINTERVEXTPROC
epoxy_glGetVertexArrayPointervEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 26227 /* glGetVertexArrayPointervEXT */);
}

static PFNGLGETVERTEXARRAYIVPROC
epoxy_glGetVertexArrayiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26255 /* "glGetVertexArrayiv" */,
        26255 /* "glGetVertexArrayiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26255 /* "glGetVertexArrayiv" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBARRAYOBJECTFVATIPROC
epoxy_glGetVertexAttribArrayObjectfvATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_vertex_attrib_array_object, 26274 /* glGetVertexAttribArrayObjectfvATI */);
}

static PFNGLGETVERTEXATTRIBARRAYOBJECTIVATIPROC
epoxy_glGetVertexAttribArrayObjectivATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_vertex_attrib_array_object, 26308 /* glGetVertexAttribArrayObjectivATI */);
}

static PFNGLGETVERTEXATTRIBIIVPROC
epoxy_glGetVertexAttribIiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        GL_extension_GL_NV_vertex_program4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26342 /* "glGetVertexAttribIiv" */,
        26342 /* "glGetVertexAttribIiv" */,
        26363 /* "glGetVertexAttribIivEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26342 /* "glGetVertexAttribIiv" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBIIVEXTPROC
epoxy_glGetVertexAttribIivEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_vertex_program4,
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26363 /* "glGetVertexAttribIivEXT" */,
        26342 /* "glGetVertexAttribIiv" */,
        26342 /* "glGetVertexAttribIiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26363 /* "glGetVertexAttribIivEXT" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBIUIVPROC
epoxy_glGetVertexAttribIuiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        GL_extension_GL_NV_vertex_program4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26387 /* "glGetVertexAttribIuiv" */,
        26387 /* "glGetVertexAttribIuiv" */,
        26409 /* "glGetVertexAttribIuivEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26387 /* "glGetVertexAttribIuiv" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBIUIVEXTPROC
epoxy_glGetVertexAttribIuivEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_vertex_program4,
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26409 /* "glGetVertexAttribIuivEXT" */,
        26387 /* "glGetVertexAttribIuiv" */,
        26387 /* "glGetVertexAttribIuiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26409 /* "glGetVertexAttribIuivEXT" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBLDVPROC
epoxy_glGetVertexAttribLdv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_vertex_attrib_64bit,
        GL_extension_GL_EXT_vertex_attrib_64bit,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26434 /* "glGetVertexAttribLdv" */,
        26434 /* "glGetVertexAttribLdv" */,
        26455 /* "glGetVertexAttribLdvEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26434 /* "glGetVertexAttribLdv" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBLDVEXTPROC
epoxy_glGetVertexAttribLdvEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_vertex_attrib_64bit,
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_vertex_attrib_64bit,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26455 /* "glGetVertexAttribLdvEXT" */,
        26434 /* "glGetVertexAttribLdv" */,
        26434 /* "glGetVertexAttribLdv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26455 /* "glGetVertexAttribLdvEXT" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBLI64VNVPROC
epoxy_glGetVertexAttribLi64vNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_attrib_integer_64bit, 26479 /* glGetVertexAttribLi64vNV */);
}

static PFNGLGETVERTEXATTRIBLUI64VARBPROC
epoxy_glGetVertexAttribLui64vARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_bindless_texture, 26504 /* glGetVertexAttribLui64vARB */);
}

static PFNGLGETVERTEXATTRIBLUI64VNVPROC
epoxy_glGetVertexAttribLui64vNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_attrib_integer_64bit, 26531 /* glGetVertexAttribLui64vNV */);
}

static PFNGLGETVERTEXATTRIBPOINTERVPROC
epoxy_glGetVertexAttribPointerv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_ARB_vertex_shader,
        GL_extension_GL_NV_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26557 /* "glGetVertexAttribPointerv" */,
        26557 /* "glGetVertexAttribPointerv" */,
        26583 /* "glGetVertexAttribPointervARB" */,
        26583 /* "glGetVertexAttribPointervARB" */,
        26612 /* "glGetVertexAttribPointervNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26557 /* "glGetVertexAttribPointerv" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBPOINTERVARBPROC
epoxy_glGetVertexAttribPointervARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_ARB_vertex_shader,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_NV_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26583 /* "glGetVertexAttribPointervARB" */,
        26583 /* "glGetVertexAttribPointervARB" */,
        26557 /* "glGetVertexAttribPointerv" */,
        26557 /* "glGetVertexAttribPointerv" */,
        26612 /* "glGetVertexAttribPointervNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26583 /* "glGetVertexAttribPointervARB" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBPOINTERVNVPROC
epoxy_glGetVertexAttribPointervNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_vertex_program,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_ARB_vertex_shader,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26612 /* "glGetVertexAttribPointervNV" */,
        26557 /* "glGetVertexAttribPointerv" */,
        26557 /* "glGetVertexAttribPointerv" */,
        26583 /* "glGetVertexAttribPointervARB" */,
        26583 /* "glGetVertexAttribPointervARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26612 /* "glGetVertexAttribPointervNV" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBDVPROC
epoxy_glGetVertexAttribdv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_ARB_vertex_shader,
        GL_extension_GL_NV_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26640 /* "glGetVertexAttribdv" */,
        26660 /* "glGetVertexAttribdvARB" */,
        26660 /* "glGetVertexAttribdvARB" */,
        26683 /* "glGetVertexAttribdvNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26640 /* "glGetVertexAttribdv" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBDVARBPROC
epoxy_glGetVertexAttribdvARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_ARB_vertex_shader,
        Desktop_OpenGL_2_0,
        GL_extension_GL_NV_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26660 /* "glGetVertexAttribdvARB" */,
        26660 /* "glGetVertexAttribdvARB" */,
        26640 /* "glGetVertexAttribdv" */,
        26683 /* "glGetVertexAttribdvNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26660 /* "glGetVertexAttribdvARB" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBDVNVPROC
epoxy_glGetVertexAttribdvNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_vertex_program,
        Desktop_OpenGL_2_0,
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_ARB_vertex_shader,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26683 /* "glGetVertexAttribdvNV" */,
        26640 /* "glGetVertexAttribdv" */,
        26660 /* "glGetVertexAttribdvARB" */,
        26660 /* "glGetVertexAttribdvARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26683 /* "glGetVertexAttribdvNV" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBFVPROC
epoxy_glGetVertexAttribfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_ARB_vertex_shader,
        GL_extension_GL_NV_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26705 /* "glGetVertexAttribfv" */,
        26705 /* "glGetVertexAttribfv" */,
        26725 /* "glGetVertexAttribfvARB" */,
        26725 /* "glGetVertexAttribfvARB" */,
        26748 /* "glGetVertexAttribfvNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26705 /* "glGetVertexAttribfv" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBFVARBPROC
epoxy_glGetVertexAttribfvARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_ARB_vertex_shader,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_NV_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26725 /* "glGetVertexAttribfvARB" */,
        26725 /* "glGetVertexAttribfvARB" */,
        26705 /* "glGetVertexAttribfv" */,
        26705 /* "glGetVertexAttribfv" */,
        26748 /* "glGetVertexAttribfvNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26725 /* "glGetVertexAttribfvARB" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBFVNVPROC
epoxy_glGetVertexAttribfvNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_vertex_program,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_ARB_vertex_shader,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26748 /* "glGetVertexAttribfvNV" */,
        26705 /* "glGetVertexAttribfv" */,
        26705 /* "glGetVertexAttribfv" */,
        26725 /* "glGetVertexAttribfvARB" */,
        26725 /* "glGetVertexAttribfvARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26748 /* "glGetVertexAttribfvNV" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBIVPROC
epoxy_glGetVertexAttribiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_ARB_vertex_shader,
        GL_extension_GL_NV_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26770 /* "glGetVertexAttribiv" */,
        26770 /* "glGetVertexAttribiv" */,
        26790 /* "glGetVertexAttribivARB" */,
        26790 /* "glGetVertexAttribivARB" */,
        26813 /* "glGetVertexAttribivNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26770 /* "glGetVertexAttribiv" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBIVARBPROC
epoxy_glGetVertexAttribivARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_ARB_vertex_shader,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_NV_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26790 /* "glGetVertexAttribivARB" */,
        26790 /* "glGetVertexAttribivARB" */,
        26770 /* "glGetVertexAttribiv" */,
        26770 /* "glGetVertexAttribiv" */,
        26813 /* "glGetVertexAttribivNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26790 /* "glGetVertexAttribivARB" */,
                                providers, entrypoints);
}

static PFNGLGETVERTEXATTRIBIVNVPROC
epoxy_glGetVertexAttribivNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_vertex_program,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_ARB_vertex_shader,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        26813 /* "glGetVertexAttribivNV" */,
        26770 /* "glGetVertexAttribiv" */,
        26770 /* "glGetVertexAttribiv" */,
        26790 /* "glGetVertexAttribivARB" */,
        26790 /* "glGetVertexAttribivARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 26813 /* "glGetVertexAttribivNV" */,
                                providers, entrypoints);
}

static PFNGLGETVIDEOCAPTURESTREAMDVNVPROC
epoxy_glGetVideoCaptureStreamdvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_video_capture, 26835 /* glGetVideoCaptureStreamdvNV */);
}

static PFNGLGETVIDEOCAPTURESTREAMFVNVPROC
epoxy_glGetVideoCaptureStreamfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_video_capture, 26863 /* glGetVideoCaptureStreamfvNV */);
}

static PFNGLGETVIDEOCAPTURESTREAMIVNVPROC
epoxy_glGetVideoCaptureStreamivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_video_capture, 26891 /* glGetVideoCaptureStreamivNV */);
}

static PFNGLGETVIDEOCAPTUREIVNVPROC
epoxy_glGetVideoCaptureivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_video_capture, 26919 /* glGetVideoCaptureivNV */);
}

static PFNGLGETVIDEOI64VNVPROC
epoxy_glGetVideoi64vNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_present_video, 26941 /* glGetVideoi64vNV */);
}

static PFNGLGETVIDEOIVNVPROC
epoxy_glGetVideoivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_present_video, 26958 /* glGetVideoivNV */);
}

static PFNGLGETVIDEOUI64VNVPROC
epoxy_glGetVideoui64vNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_present_video, 26973 /* glGetVideoui64vNV */);
}

static PFNGLGETVIDEOUIVNVPROC
epoxy_glGetVideouivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_present_video, 26991 /* glGetVideouivNV */);
}

static PFNGLGETNCOLORTABLEPROC
epoxy_glGetnColorTable_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_4_5, 27007 /* glGetnColorTable */);
}

static PFNGLGETNCOLORTABLEARBPROC
epoxy_glGetnColorTableARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27024 /* glGetnColorTableARB */);
}

static PFNGLGETNCOMPRESSEDTEXIMAGEPROC
epoxy_glGetnCompressedTexImage_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_4_5, 27044 /* glGetnCompressedTexImage */);
}

static PFNGLGETNCOMPRESSEDTEXIMAGEARBPROC
epoxy_glGetnCompressedTexImageARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27069 /* glGetnCompressedTexImageARB */);
}

static PFNGLGETNCONVOLUTIONFILTERPROC
epoxy_glGetnConvolutionFilter_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_4_5, 27097 /* glGetnConvolutionFilter */);
}

static PFNGLGETNCONVOLUTIONFILTERARBPROC
epoxy_glGetnConvolutionFilterARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27121 /* glGetnConvolutionFilterARB */);
}

static PFNGLGETNHISTOGRAMPROC
epoxy_glGetnHistogram_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_4_5, 27148 /* glGetnHistogram */);
}

static PFNGLGETNHISTOGRAMARBPROC
epoxy_glGetnHistogramARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27164 /* glGetnHistogramARB */);
}

static PFNGLGETNMAPDVPROC
epoxy_glGetnMapdv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_4_5, 27183 /* glGetnMapdv */);
}

static PFNGLGETNMAPDVARBPROC
epoxy_glGetnMapdvARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27195 /* glGetnMapdvARB */);
}

static PFNGLGETNMAPFVPROC
epoxy_glGetnMapfv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_4_5, 27210 /* glGetnMapfv */);
}

static PFNGLGETNMAPFVARBPROC
epoxy_glGetnMapfvARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27222 /* glGetnMapfvARB */);
}

static PFNGLGETNMAPIVPROC
epoxy_glGetnMapiv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_4_5, 27237 /* glGetnMapiv */);
}

static PFNGLGETNMAPIVARBPROC
epoxy_glGetnMapivARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27249 /* glGetnMapivARB */);
}

static PFNGLGETNMINMAXPROC
epoxy_glGetnMinmax_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_4_5, 27264 /* glGetnMinmax */);
}

static PFNGLGETNMINMAXARBPROC
epoxy_glGetnMinmaxARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27277 /* glGetnMinmaxARB */);
}

static PFNGLGETNPIXELMAPFVPROC
epoxy_glGetnPixelMapfv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_4_5, 27293 /* glGetnPixelMapfv */);
}

static PFNGLGETNPIXELMAPFVARBPROC
epoxy_glGetnPixelMapfvARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27310 /* glGetnPixelMapfvARB */);
}

static PFNGLGETNPIXELMAPUIVPROC
epoxy_glGetnPixelMapuiv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_4_5, 27330 /* glGetnPixelMapuiv */);
}

static PFNGLGETNPIXELMAPUIVARBPROC
epoxy_glGetnPixelMapuivARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27348 /* glGetnPixelMapuivARB */);
}

static PFNGLGETNPIXELMAPUSVPROC
epoxy_glGetnPixelMapusv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_4_5, 27369 /* glGetnPixelMapusv */);
}

static PFNGLGETNPIXELMAPUSVARBPROC
epoxy_glGetnPixelMapusvARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27387 /* glGetnPixelMapusvARB */);
}

static PFNGLGETNPOLYGONSTIPPLEPROC
epoxy_glGetnPolygonStipple_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_4_5, 27408 /* glGetnPolygonStipple */);
}

static PFNGLGETNPOLYGONSTIPPLEARBPROC
epoxy_glGetnPolygonStippleARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27429 /* glGetnPolygonStippleARB */);
}

static PFNGLGETNSEPARABLEFILTERPROC
epoxy_glGetnSeparableFilter_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_4_5, 27453 /* glGetnSeparableFilter */);
}

static PFNGLGETNSEPARABLEFILTERARBPROC
epoxy_glGetnSeparableFilterARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27475 /* glGetnSeparableFilterARB */);
}

static PFNGLGETNTEXIMAGEPROC
epoxy_glGetnTexImage_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_4_5, 27500 /* glGetnTexImage */);
}

static PFNGLGETNTEXIMAGEARBPROC
epoxy_glGetnTexImageARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27515 /* glGetnTexImageARB */);
}

static PFNGLGETNUNIFORMDVPROC
epoxy_glGetnUniformdv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_4_5, 27533 /* glGetnUniformdv */);
}

static PFNGLGETNUNIFORMDVARBPROC
epoxy_glGetnUniformdvARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27549 /* glGetnUniformdvARB */);
}

static PFNGLGETNUNIFORMFVPROC
epoxy_glGetnUniformfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_KHR_robustness,
        GL_extension_GL_KHR_robustness,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        27568 /* "glGetnUniformfv" */,
        27568 /* "glGetnUniformfv" */,
        27622 /* "glGetnUniformfvKHR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 27568 /* "glGetnUniformfv" */,
                                providers, entrypoints);
}

static PFNGLGETNUNIFORMFVARBPROC
epoxy_glGetnUniformfvARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27584 /* glGetnUniformfvARB */);
}

static PFNGLGETNUNIFORMFVEXTPROC
epoxy_glGetnUniformfvEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_robustness, 27603 /* glGetnUniformfvEXT */);
}

static PFNGLGETNUNIFORMFVKHRPROC
epoxy_glGetnUniformfvKHR_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_KHR_robustness,
        Desktop_OpenGL_4_5,
        GL_extension_GL_KHR_robustness,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        27622 /* "glGetnUniformfvKHR" */,
        27568 /* "glGetnUniformfv" */,
        27568 /* "glGetnUniformfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 27622 /* "glGetnUniformfvKHR" */,
                                providers, entrypoints);
}

static PFNGLGETNUNIFORMIVPROC
epoxy_glGetnUniformiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_KHR_robustness,
        GL_extension_GL_KHR_robustness,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        27641 /* "glGetnUniformiv" */,
        27641 /* "glGetnUniformiv" */,
        27695 /* "glGetnUniformivKHR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 27641 /* "glGetnUniformiv" */,
                                providers, entrypoints);
}

static PFNGLGETNUNIFORMIVARBPROC
epoxy_glGetnUniformivARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27657 /* glGetnUniformivARB */);
}

static PFNGLGETNUNIFORMIVEXTPROC
epoxy_glGetnUniformivEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_robustness, 27676 /* glGetnUniformivEXT */);
}

static PFNGLGETNUNIFORMIVKHRPROC
epoxy_glGetnUniformivKHR_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_KHR_robustness,
        Desktop_OpenGL_4_5,
        GL_extension_GL_KHR_robustness,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        27695 /* "glGetnUniformivKHR" */,
        27641 /* "glGetnUniformiv" */,
        27641 /* "glGetnUniformiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 27695 /* "glGetnUniformivKHR" */,
                                providers, entrypoints);
}

static PFNGLGETNUNIFORMUIVPROC
epoxy_glGetnUniformuiv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_KHR_robustness,
        GL_extension_GL_KHR_robustness,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        27714 /* "glGetnUniformuiv" */,
        27714 /* "glGetnUniformuiv" */,
        27751 /* "glGetnUniformuivKHR" */,
    };
    return gl_provider_resolver(entrypoint_strings + 27714 /* "glGetnUniformuiv" */,
                                providers, entrypoints);
}

static PFNGLGETNUNIFORMUIVARBPROC
epoxy_glGetnUniformuivARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_robustness, 27731 /* glGetnUniformuivARB */);
}

static PFNGLGETNUNIFORMUIVKHRPROC
epoxy_glGetnUniformuivKHR_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_KHR_robustness,
        Desktop_OpenGL_4_5,
        GL_extension_GL_KHR_robustness,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        27751 /* "glGetnUniformuivKHR" */,
        27714 /* "glGetnUniformuiv" */,
        27714 /* "glGetnUniformuiv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 27751 /* "glGetnUniformuivKHR" */,
                                providers, entrypoints);
}

static PFNGLGLOBALALPHAFACTORBSUNPROC
epoxy_glGlobalAlphaFactorbSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_global_alpha, 27771 /* glGlobalAlphaFactorbSUN */);
}

static PFNGLGLOBALALPHAFACTORDSUNPROC
epoxy_glGlobalAlphaFactordSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_global_alpha, 27795 /* glGlobalAlphaFactordSUN */);
}

static PFNGLGLOBALALPHAFACTORFSUNPROC
epoxy_glGlobalAlphaFactorfSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_global_alpha, 27819 /* glGlobalAlphaFactorfSUN */);
}

static PFNGLGLOBALALPHAFACTORISUNPROC
epoxy_glGlobalAlphaFactoriSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_global_alpha, 27843 /* glGlobalAlphaFactoriSUN */);
}

static PFNGLGLOBALALPHAFACTORSSUNPROC
epoxy_glGlobalAlphaFactorsSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_global_alpha, 27867 /* glGlobalAlphaFactorsSUN */);
}

static PFNGLGLOBALALPHAFACTORUBSUNPROC
epoxy_glGlobalAlphaFactorubSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_global_alpha, 27891 /* glGlobalAlphaFactorubSUN */);
}

static PFNGLGLOBALALPHAFACTORUISUNPROC
epoxy_glGlobalAlphaFactoruiSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_global_alpha, 27916 /* glGlobalAlphaFactoruiSUN */);
}

static PFNGLGLOBALALPHAFACTORUSSUNPROC
epoxy_glGlobalAlphaFactorusSUN_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SUN_global_alpha, 27941 /* glGlobalAlphaFactorusSUN */);
}

static PFNGLHINTPROC
epoxy_glHint_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        27966 /* "glHint" */,
        27966 /* "glHint" */,
        27966 /* "glHint" */,
    };
    return gl_provider_resolver(entrypoint_strings + 27966 /* "glHint" */,
                                providers, entrypoints);
}

static PFNGLHINTPGIPROC
epoxy_glHintPGI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_PGI_misc_hints, 27973 /* glHintPGI */);
}

static PFNGLHISTOGRAMPROC
epoxy_glHistogram_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_histogram,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        27983 /* "glHistogram" */,
        27995 /* "glHistogramEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 27983 /* "glHistogram" */,
                                providers, entrypoints);
}

static PFNGLHISTOGRAMEXTPROC
epoxy_glHistogramEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_histogram,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        27995 /* "glHistogramEXT" */,
        27983 /* "glHistogram" */,
    };
    return gl_provider_resolver(entrypoint_strings + 27995 /* "glHistogramEXT" */,
                                providers, entrypoints);
}

static PFNGLIGLOOINTERFACESGIXPROC
epoxy_glIglooInterfaceSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_igloo_interface, 28010 /* glIglooInterfaceSGIX */);
}

static PFNGLIMAGETRANSFORMPARAMETERFHPPROC
epoxy_glImageTransformParameterfHP_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_HP_image_transform, 28031 /* glImageTransformParameterfHP */);
}

static PFNGLIMAGETRANSFORMPARAMETERFVHPPROC
epoxy_glImageTransformParameterfvHP_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_HP_image_transform, 28060 /* glImageTransformParameterfvHP */);
}

static PFNGLIMAGETRANSFORMPARAMETERIHPPROC
epoxy_glImageTransformParameteriHP_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_HP_image_transform, 28090 /* glImageTransformParameteriHP */);
}

static PFNGLIMAGETRANSFORMPARAMETERIVHPPROC
epoxy_glImageTransformParameterivHP_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_HP_image_transform, 28119 /* glImageTransformParameterivHP */);
}

static PFNGLIMPORTSYNCEXTPROC
epoxy_glImportSyncEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_x11_sync_object, 28149 /* glImportSyncEXT */);
}

static PFNGLINDEXFORMATNVPROC
epoxy_glIndexFormatNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_buffer_unified_memory, 28165 /* glIndexFormatNV */);
}

static PFNGLINDEXFUNCEXTPROC
epoxy_glIndexFuncEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_index_func, 28181 /* glIndexFuncEXT */);
}

static PFNGLINDEXMASKPROC
epoxy_glIndexMask_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 28196 /* glIndexMask */);
}

static PFNGLINDEXMATERIALEXTPROC
epoxy_glIndexMaterialEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_index_material, 28208 /* glIndexMaterialEXT */);
}

static PFNGLINDEXPOINTERPROC
epoxy_glIndexPointer_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_1, 28227 /* glIndexPointer */);
}

static PFNGLINDEXPOINTEREXTPROC
epoxy_glIndexPointerEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_array, 28242 /* glIndexPointerEXT */);
}

static PFNGLINDEXPOINTERLISTIBMPROC
epoxy_glIndexPointerListIBM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_IBM_vertex_array_lists, 28260 /* glIndexPointerListIBM */);
}

static PFNGLINDEXDPROC
epoxy_glIndexd_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 28282 /* glIndexd */);
}

static PFNGLINDEXDVPROC
epoxy_glIndexdv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 28291 /* glIndexdv */);
}

static PFNGLINDEXFPROC
epoxy_glIndexf_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 28301 /* glIndexf */);
}

static PFNGLINDEXFVPROC
epoxy_glIndexfv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 28310 /* glIndexfv */);
}

static PFNGLINDEXIPROC
epoxy_glIndexi_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 28320 /* glIndexi */);
}

static PFNGLINDEXIVPROC
epoxy_glIndexiv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 28329 /* glIndexiv */);
}

static PFNGLINDEXSPROC
epoxy_glIndexs_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 28339 /* glIndexs */);
}

static PFNGLINDEXSVPROC
epoxy_glIndexsv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 28348 /* glIndexsv */);
}

static PFNGLINDEXUBPROC
epoxy_glIndexub_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_1, 28358 /* glIndexub */);
}

static PFNGLINDEXUBVPROC
epoxy_glIndexubv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_1, 28368 /* glIndexubv */);
}

static PFNGLINDEXXOESPROC
epoxy_glIndexxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 28379 /* glIndexxOES */);
}

static PFNGLINDEXXVOESPROC
epoxy_glIndexxvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 28391 /* glIndexxvOES */);
}

static PFNGLINITNAMESPROC
epoxy_glInitNames_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 28404 /* glInitNames */);
}

static PFNGLINSERTCOMPONENTEXTPROC
epoxy_glInsertComponentEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 28416 /* glInsertComponentEXT */);
}

static PFNGLINSERTEVENTMARKEREXTPROC
epoxy_glInsertEventMarkerEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_debug_marker, 28437 /* glInsertEventMarkerEXT */);
}

static PFNGLINSTRUMENTSBUFFERSGIXPROC
epoxy_glInstrumentsBufferSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_instruments, 28460 /* glInstrumentsBufferSGIX */);
}

static PFNGLINTERLEAVEDARRAYSPROC
epoxy_glInterleavedArrays_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_1, 28484 /* glInterleavedArrays */);
}

static PFNGLINTERPOLATEPATHSNVPROC
epoxy_glInterpolatePathsNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 28504 /* glInterpolatePathsNV */);
}

static PFNGLINVALIDATEBUFFERDATAPROC
epoxy_glInvalidateBufferData_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_invalidate_subdata,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28525 /* "glInvalidateBufferData" */,
        28525 /* "glInvalidateBufferData" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28525 /* "glInvalidateBufferData" */,
                                providers, entrypoints);
}

static PFNGLINVALIDATEBUFFERSUBDATAPROC
epoxy_glInvalidateBufferSubData_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_invalidate_subdata,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28548 /* "glInvalidateBufferSubData" */,
        28548 /* "glInvalidateBufferSubData" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28548 /* "glInvalidateBufferSubData" */,
                                providers, entrypoints);
}

static PFNGLINVALIDATEFRAMEBUFFERPROC
epoxy_glInvalidateFramebuffer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_invalidate_subdata,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28574 /* "glInvalidateFramebuffer" */,
        28574 /* "glInvalidateFramebuffer" */,
        28574 /* "glInvalidateFramebuffer" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28574 /* "glInvalidateFramebuffer" */,
                                providers, entrypoints);
}

static PFNGLINVALIDATENAMEDFRAMEBUFFERDATAPROC
epoxy_glInvalidateNamedFramebufferData_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28598 /* "glInvalidateNamedFramebufferData" */,
        28598 /* "glInvalidateNamedFramebufferData" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28598 /* "glInvalidateNamedFramebufferData" */,
                                providers, entrypoints);
}

static PFNGLINVALIDATENAMEDFRAMEBUFFERSUBDATAPROC
epoxy_glInvalidateNamedFramebufferSubData_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28631 /* "glInvalidateNamedFramebufferSubData" */,
        28631 /* "glInvalidateNamedFramebufferSubData" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28631 /* "glInvalidateNamedFramebufferSubData" */,
                                providers, entrypoints);
}

static PFNGLINVALIDATESUBFRAMEBUFFERPROC
epoxy_glInvalidateSubFramebuffer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_invalidate_subdata,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28667 /* "glInvalidateSubFramebuffer" */,
        28667 /* "glInvalidateSubFramebuffer" */,
        28667 /* "glInvalidateSubFramebuffer" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28667 /* "glInvalidateSubFramebuffer" */,
                                providers, entrypoints);
}

static PFNGLINVALIDATETEXIMAGEPROC
epoxy_glInvalidateTexImage_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_invalidate_subdata,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28694 /* "glInvalidateTexImage" */,
        28694 /* "glInvalidateTexImage" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28694 /* "glInvalidateTexImage" */,
                                providers, entrypoints);
}

static PFNGLINVALIDATETEXSUBIMAGEPROC
epoxy_glInvalidateTexSubImage_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_invalidate_subdata,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28715 /* "glInvalidateTexSubImage" */,
        28715 /* "glInvalidateTexSubImage" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28715 /* "glInvalidateTexSubImage" */,
                                providers, entrypoints);
}

static PFNGLISASYNCMARKERSGIXPROC
epoxy_glIsAsyncMarkerSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_async, 28739 /* glIsAsyncMarkerSGIX */);
}

static PFNGLISBUFFERPROC
epoxy_glIsBuffer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_buffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28759 /* "glIsBuffer" */,
        28759 /* "glIsBuffer" */,
        28759 /* "glIsBuffer" */,
        28770 /* "glIsBufferARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28759 /* "glIsBuffer" */,
                                providers, entrypoints);
}

static PFNGLISBUFFERARBPROC
epoxy_glIsBufferARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_buffer_object,
        Desktop_OpenGL_1_5,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28770 /* "glIsBufferARB" */,
        28759 /* "glIsBuffer" */,
        28759 /* "glIsBuffer" */,
        28759 /* "glIsBuffer" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28770 /* "glIsBufferARB" */,
                                providers, entrypoints);
}

static PFNGLISBUFFERRESIDENTNVPROC
epoxy_glIsBufferResidentNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_shader_buffer_load, 28784 /* glIsBufferResidentNV */);
}

static PFNGLISCOMMANDLISTNVPROC
epoxy_glIsCommandListNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_command_list, 28805 /* glIsCommandListNV */);
}

static PFNGLISENABLEDPROC
epoxy_glIsEnabled_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28823 /* "glIsEnabled" */,
        28823 /* "glIsEnabled" */,
        28823 /* "glIsEnabled" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28823 /* "glIsEnabled" */,
                                providers, entrypoints);
}

static PFNGLISENABLEDINDEXEDEXTPROC
epoxy_glIsEnabledIndexedEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_NV_viewport_array,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28835 /* "glIsEnabledIndexedEXT" */,
        28835 /* "glIsEnabledIndexedEXT" */,
        28857 /* "glIsEnabledi" */,
        28870 /* "glIsEnablediEXT" */,
        28886 /* "glIsEnablediNV" */,
        28901 /* "glIsEnablediOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28835 /* "glIsEnabledIndexedEXT" */,
                                providers, entrypoints);
}

static PFNGLISENABLEDIPROC
epoxy_glIsEnabledi_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_NV_viewport_array,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28857 /* "glIsEnabledi" */,
        28835 /* "glIsEnabledIndexedEXT" */,
        28835 /* "glIsEnabledIndexedEXT" */,
        28870 /* "glIsEnablediEXT" */,
        28886 /* "glIsEnablediNV" */,
        28901 /* "glIsEnablediOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28857 /* "glIsEnabledi" */,
                                providers, entrypoints);
}

static PFNGLISENABLEDIEXTPROC
epoxy_glIsEnablediEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        GL_extension_GL_NV_viewport_array,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28870 /* "glIsEnablediEXT" */,
        28835 /* "glIsEnabledIndexedEXT" */,
        28835 /* "glIsEnabledIndexedEXT" */,
        28857 /* "glIsEnabledi" */,
        28886 /* "glIsEnablediNV" */,
        28901 /* "glIsEnablediOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28870 /* "glIsEnablediEXT" */,
                                providers, entrypoints);
}

static PFNGLISENABLEDINVPROC
epoxy_glIsEnablediNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_viewport_array,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_OES_draw_buffers_indexed,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28886 /* "glIsEnablediNV" */,
        28835 /* "glIsEnabledIndexedEXT" */,
        28835 /* "glIsEnabledIndexedEXT" */,
        28857 /* "glIsEnabledi" */,
        28870 /* "glIsEnablediEXT" */,
        28901 /* "glIsEnablediOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28886 /* "glIsEnablediNV" */,
                                providers, entrypoints);
}

static PFNGLISENABLEDIOESPROC
epoxy_glIsEnablediOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_draw_buffers_indexed,
        GL_extension_GL_EXT_direct_state_access,
        GL_extension_GL_EXT_draw_buffers2,
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_draw_buffers_indexed,
        GL_extension_GL_NV_viewport_array,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28901 /* "glIsEnablediOES" */,
        28835 /* "glIsEnabledIndexedEXT" */,
        28835 /* "glIsEnabledIndexedEXT" */,
        28857 /* "glIsEnabledi" */,
        28870 /* "glIsEnablediEXT" */,
        28886 /* "glIsEnablediNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28901 /* "glIsEnablediOES" */,
                                providers, entrypoints);
}

static PFNGLISFENCEAPPLEPROC
epoxy_glIsFenceAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_fence, 28917 /* glIsFenceAPPLE */);
}

static PFNGLISFENCENVPROC
epoxy_glIsFenceNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_fence, 28932 /* glIsFenceNV */);
}

static PFNGLISFRAMEBUFFERPROC
epoxy_glIsFramebuffer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_framebuffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28944 /* "glIsFramebuffer" */,
        28944 /* "glIsFramebuffer" */,
        28944 /* "glIsFramebuffer" */,
        28960 /* "glIsFramebufferEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28944 /* "glIsFramebuffer" */,
                                providers, entrypoints);
}

static PFNGLISFRAMEBUFFEREXTPROC
epoxy_glIsFramebufferEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        28960 /* "glIsFramebufferEXT" */,
        28944 /* "glIsFramebuffer" */,
        28944 /* "glIsFramebuffer" */,
        28944 /* "glIsFramebuffer" */,
    };
    return gl_provider_resolver(entrypoint_strings + 28960 /* "glIsFramebufferEXT" */,
                                providers, entrypoints);
}

static PFNGLISFRAMEBUFFEROESPROC
epoxy_glIsFramebufferOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_framebuffer_object, 28979 /* glIsFramebufferOES */);
}

static PFNGLISIMAGEHANDLERESIDENTARBPROC
epoxy_glIsImageHandleResidentARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_bindless_texture, 28998 /* glIsImageHandleResidentARB */);
}

static PFNGLISIMAGEHANDLERESIDENTNVPROC
epoxy_glIsImageHandleResidentNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_bindless_texture, 29025 /* glIsImageHandleResidentNV */);
}

static PFNGLISLISTPROC
epoxy_glIsList_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 29051 /* glIsList */);
}

static PFNGLISNAMEAMDPROC
epoxy_glIsNameAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_name_gen_delete, 29060 /* glIsNameAMD */);
}

static PFNGLISNAMEDBUFFERRESIDENTNVPROC
epoxy_glIsNamedBufferResidentNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_shader_buffer_load, 29072 /* glIsNamedBufferResidentNV */);
}

static PFNGLISNAMEDSTRINGARBPROC
epoxy_glIsNamedStringARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_shading_language_include, 29098 /* glIsNamedStringARB */);
}

static PFNGLISOBJECTBUFFERATIPROC
epoxy_glIsObjectBufferATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_vertex_array_object, 29117 /* glIsObjectBufferATI */);
}

static PFNGLISOCCLUSIONQUERYNVPROC
epoxy_glIsOcclusionQueryNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_occlusion_query, 29137 /* glIsOcclusionQueryNV */);
}

static PFNGLISPATHNVPROC
epoxy_glIsPathNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 29158 /* glIsPathNV */);
}

static PFNGLISPOINTINFILLPATHNVPROC
epoxy_glIsPointInFillPathNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 29169 /* glIsPointInFillPathNV */);
}

static PFNGLISPOINTINSTROKEPATHNVPROC
epoxy_glIsPointInStrokePathNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 29191 /* glIsPointInStrokePathNV */);
}

static PFNGLISPROGRAMPROC
epoxy_glIsProgram_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29215 /* "glIsProgram" */,
        29215 /* "glIsProgram" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29215 /* "glIsProgram" */,
                                providers, entrypoints);
}

static PFNGLISPROGRAMARBPROC
epoxy_glIsProgramARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_fragment_program,
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_NV_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29227 /* "glIsProgramARB" */,
        29227 /* "glIsProgramARB" */,
        29242 /* "glIsProgramNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29227 /* "glIsProgramARB" */,
                                providers, entrypoints);
}

static PFNGLISPROGRAMNVPROC
epoxy_glIsProgramNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_vertex_program,
        GL_extension_GL_ARB_fragment_program,
        GL_extension_GL_ARB_vertex_program,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29242 /* "glIsProgramNV" */,
        29227 /* "glIsProgramARB" */,
        29227 /* "glIsProgramARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29242 /* "glIsProgramNV" */,
                                providers, entrypoints);
}

static PFNGLISPROGRAMPIPELINEPROC
epoxy_glIsProgramPipeline_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_separate_shader_objects,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29256 /* "glIsProgramPipeline" */,
        29256 /* "glIsProgramPipeline" */,
        29256 /* "glIsProgramPipeline" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29256 /* "glIsProgramPipeline" */,
                                providers, entrypoints);
}

static PFNGLISPROGRAMPIPELINEEXTPROC
epoxy_glIsProgramPipelineEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_separate_shader_objects, 29276 /* glIsProgramPipelineEXT */);
}

static PFNGLISQUERYPROC
epoxy_glIsQuery_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_occlusion_query,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29299 /* "glIsQuery" */,
        29299 /* "glIsQuery" */,
        29309 /* "glIsQueryARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29299 /* "glIsQuery" */,
                                providers, entrypoints);
}

static PFNGLISQUERYARBPROC
epoxy_glIsQueryARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_occlusion_query,
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29309 /* "glIsQueryARB" */,
        29299 /* "glIsQuery" */,
        29299 /* "glIsQuery" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29309 /* "glIsQueryARB" */,
                                providers, entrypoints);
}

static PFNGLISQUERYEXTPROC
epoxy_glIsQueryEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_disjoint_timer_query,
        GL_extension_GL_EXT_occlusion_query_boolean,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29322 /* "glIsQueryEXT" */,
        29322 /* "glIsQueryEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29322 /* "glIsQueryEXT" */,
                                providers, entrypoints);
}

static PFNGLISRENDERBUFFERPROC
epoxy_glIsRenderbuffer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_framebuffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29335 /* "glIsRenderbuffer" */,
        29335 /* "glIsRenderbuffer" */,
        29335 /* "glIsRenderbuffer" */,
        29352 /* "glIsRenderbufferEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29335 /* "glIsRenderbuffer" */,
                                providers, entrypoints);
}

static PFNGLISRENDERBUFFEREXTPROC
epoxy_glIsRenderbufferEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29352 /* "glIsRenderbufferEXT" */,
        29335 /* "glIsRenderbuffer" */,
        29335 /* "glIsRenderbuffer" */,
        29335 /* "glIsRenderbuffer" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29352 /* "glIsRenderbufferEXT" */,
                                providers, entrypoints);
}

static PFNGLISRENDERBUFFEROESPROC
epoxy_glIsRenderbufferOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_framebuffer_object, 29372 /* glIsRenderbufferOES */);
}

static PFNGLISSAMPLERPROC
epoxy_glIsSampler_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_sampler_objects,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29392 /* "glIsSampler" */,
        29392 /* "glIsSampler" */,
        29392 /* "glIsSampler" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29392 /* "glIsSampler" */,
                                providers, entrypoints);
}

static PFNGLISSHADERPROC
epoxy_glIsShader_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29404 /* "glIsShader" */,
        29404 /* "glIsShader" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29404 /* "glIsShader" */,
                                providers, entrypoints);
}

static PFNGLISSTATENVPROC
epoxy_glIsStateNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_command_list, 29415 /* glIsStateNV */);
}

static PFNGLISSYNCPROC
epoxy_glIsSync_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_sync,
        OpenGL_ES_3_0,
        GL_extension_GL_APPLE_sync,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29427 /* "glIsSync" */,
        29427 /* "glIsSync" */,
        29427 /* "glIsSync" */,
        29436 /* "glIsSyncAPPLE" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29427 /* "glIsSync" */,
                                providers, entrypoints);
}

static PFNGLISSYNCAPPLEPROC
epoxy_glIsSyncAPPLE_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_APPLE_sync,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_sync,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29436 /* "glIsSyncAPPLE" */,
        29427 /* "glIsSync" */,
        29427 /* "glIsSync" */,
        29427 /* "glIsSync" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29436 /* "glIsSyncAPPLE" */,
                                providers, entrypoints);
}

static PFNGLISTEXTUREPROC
epoxy_glIsTexture_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_1,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29450 /* "glIsTexture" */,
        29450 /* "glIsTexture" */,
        29450 /* "glIsTexture" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29450 /* "glIsTexture" */,
                                providers, entrypoints);
}

static PFNGLISTEXTUREEXTPROC
epoxy_glIsTextureEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_texture_object, 29462 /* glIsTextureEXT */);
}

static PFNGLISTEXTUREHANDLERESIDENTARBPROC
epoxy_glIsTextureHandleResidentARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_bindless_texture, 29477 /* glIsTextureHandleResidentARB */);
}

static PFNGLISTEXTUREHANDLERESIDENTNVPROC
epoxy_glIsTextureHandleResidentNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_bindless_texture, 29506 /* glIsTextureHandleResidentNV */);
}

static PFNGLISTRANSFORMFEEDBACKPROC
epoxy_glIsTransformFeedback_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_transform_feedback2,
        OpenGL_ES_3_0,
        GL_extension_GL_NV_transform_feedback2,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29534 /* "glIsTransformFeedback" */,
        29534 /* "glIsTransformFeedback" */,
        29534 /* "glIsTransformFeedback" */,
        29556 /* "glIsTransformFeedbackNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29534 /* "glIsTransformFeedback" */,
                                providers, entrypoints);
}

static PFNGLISTRANSFORMFEEDBACKNVPROC
epoxy_glIsTransformFeedbackNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_transform_feedback2,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_transform_feedback2,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29556 /* "glIsTransformFeedbackNV" */,
        29534 /* "glIsTransformFeedback" */,
        29534 /* "glIsTransformFeedback" */,
        29534 /* "glIsTransformFeedback" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29556 /* "glIsTransformFeedbackNV" */,
                                providers, entrypoints);
}

static PFNGLISVARIANTENABLEDEXTPROC
epoxy_glIsVariantEnabledEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 29580 /* glIsVariantEnabledEXT */);
}

static PFNGLISVERTEXARRAYPROC
epoxy_glIsVertexArray_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_vertex_array_object,
        OpenGL_ES_3_0,
        GL_extension_GL_APPLE_vertex_array_object,
        GL_extension_GL_OES_vertex_array_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29602 /* "glIsVertexArray" */,
        29602 /* "glIsVertexArray" */,
        29602 /* "glIsVertexArray" */,
        29618 /* "glIsVertexArrayAPPLE" */,
        29639 /* "glIsVertexArrayOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29602 /* "glIsVertexArray" */,
                                providers, entrypoints);
}

static PFNGLISVERTEXARRAYAPPLEPROC
epoxy_glIsVertexArrayAPPLE_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_APPLE_vertex_array_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_vertex_array_object,
        OpenGL_ES_3_0,
        GL_extension_GL_OES_vertex_array_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29618 /* "glIsVertexArrayAPPLE" */,
        29602 /* "glIsVertexArray" */,
        29602 /* "glIsVertexArray" */,
        29602 /* "glIsVertexArray" */,
        29639 /* "glIsVertexArrayOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29618 /* "glIsVertexArrayAPPLE" */,
                                providers, entrypoints);
}

static PFNGLISVERTEXARRAYOESPROC
epoxy_glIsVertexArrayOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_vertex_array_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_vertex_array_object,
        OpenGL_ES_3_0,
        GL_extension_GL_APPLE_vertex_array_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29639 /* "glIsVertexArrayOES" */,
        29602 /* "glIsVertexArray" */,
        29602 /* "glIsVertexArray" */,
        29602 /* "glIsVertexArray" */,
        29618 /* "glIsVertexArrayAPPLE" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29639 /* "glIsVertexArrayOES" */,
                                providers, entrypoints);
}

static PFNGLISVERTEXATTRIBENABLEDAPPLEPROC
epoxy_glIsVertexAttribEnabledAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_vertex_program_evaluators, 29658 /* glIsVertexAttribEnabledAPPLE */);
}

static PFNGLLABELOBJECTEXTPROC
epoxy_glLabelObjectEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_debug_label, 29687 /* glLabelObjectEXT */);
}

static PFNGLLIGHTENVISGIXPROC
epoxy_glLightEnviSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_fragment_lighting, 29704 /* glLightEnviSGIX */);
}

static PFNGLLIGHTMODELFPROC
epoxy_glLightModelf_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29720 /* "glLightModelf" */,
        29720 /* "glLightModelf" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29720 /* "glLightModelf" */,
                                providers, entrypoints);
}

static PFNGLLIGHTMODELFVPROC
epoxy_glLightModelfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29734 /* "glLightModelfv" */,
        29734 /* "glLightModelfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29734 /* "glLightModelfv" */,
                                providers, entrypoints);
}

static PFNGLLIGHTMODELIPROC
epoxy_glLightModeli_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 29749 /* glLightModeli */);
}

static PFNGLLIGHTMODELIVPROC
epoxy_glLightModeliv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 29763 /* glLightModeliv */);
}

static PFNGLLIGHTMODELXPROC
epoxy_glLightModelx_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 29778 /* glLightModelx */);
}

static PFNGLLIGHTMODELXOESPROC
epoxy_glLightModelxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 29792 /* glLightModelxOES */);
}

static PFNGLLIGHTMODELXVPROC
epoxy_glLightModelxv_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 29809 /* glLightModelxv */);
}

static PFNGLLIGHTMODELXVOESPROC
epoxy_glLightModelxvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 29824 /* glLightModelxvOES */);
}

static PFNGLLIGHTFPROC
epoxy_glLightf_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29842 /* "glLightf" */,
        29842 /* "glLightf" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29842 /* "glLightf" */,
                                providers, entrypoints);
}

static PFNGLLIGHTFVPROC
epoxy_glLightfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29851 /* "glLightfv" */,
        29851 /* "glLightfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29851 /* "glLightfv" */,
                                providers, entrypoints);
}

static PFNGLLIGHTIPROC
epoxy_glLighti_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 29861 /* glLighti */);
}

static PFNGLLIGHTIVPROC
epoxy_glLightiv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 29870 /* glLightiv */);
}

static PFNGLLIGHTXPROC
epoxy_glLightx_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 29880 /* glLightx */);
}

static PFNGLLIGHTXOESPROC
epoxy_glLightxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 29889 /* glLightxOES */);
}

static PFNGLLIGHTXVPROC
epoxy_glLightxv_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 29901 /* glLightxv */);
}

static PFNGLLIGHTXVOESPROC
epoxy_glLightxvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 29911 /* glLightxvOES */);
}

static PFNGLLINESTIPPLEPROC
epoxy_glLineStipple_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 29924 /* glLineStipple */);
}

static PFNGLLINEWIDTHPROC
epoxy_glLineWidth_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29938 /* "glLineWidth" */,
        29938 /* "glLineWidth" */,
        29938 /* "glLineWidth" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29938 /* "glLineWidth" */,
                                providers, entrypoints);
}

static PFNGLLINEWIDTHXPROC
epoxy_glLineWidthx_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 29950 /* glLineWidthx */);
}

static PFNGLLINEWIDTHXOESPROC
epoxy_glLineWidthxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 29963 /* glLineWidthxOES */);
}

static PFNGLLINKPROGRAMPROC
epoxy_glLinkProgram_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_shader_objects,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29979 /* "glLinkProgram" */,
        29979 /* "glLinkProgram" */,
        29993 /* "glLinkProgramARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29979 /* "glLinkProgram" */,
                                providers, entrypoints);
}

static PFNGLLINKPROGRAMARBPROC
epoxy_glLinkProgramARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_shader_objects,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        29993 /* "glLinkProgramARB" */,
        29979 /* "glLinkProgram" */,
        29979 /* "glLinkProgram" */,
    };
    return gl_provider_resolver(entrypoint_strings + 29993 /* "glLinkProgramARB" */,
                                providers, entrypoints);
}

static PFNGLLISTBASEPROC
epoxy_glListBase_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 30010 /* glListBase */);
}

static PFNGLLISTDRAWCOMMANDSSTATESCLIENTNVPROC
epoxy_glListDrawCommandsStatesClientNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_command_list, 30021 /* glListDrawCommandsStatesClientNV */);
}

static PFNGLLISTPARAMETERFSGIXPROC
epoxy_glListParameterfSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_list_priority, 30054 /* glListParameterfSGIX */);
}

static PFNGLLISTPARAMETERFVSGIXPROC
epoxy_glListParameterfvSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_list_priority, 30075 /* glListParameterfvSGIX */);
}

static PFNGLLISTPARAMETERISGIXPROC
epoxy_glListParameteriSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_list_priority, 30097 /* glListParameteriSGIX */);
}

static PFNGLLISTPARAMETERIVSGIXPROC
epoxy_glListParameterivSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_list_priority, 30118 /* glListParameterivSGIX */);
}

static PFNGLLOADIDENTITYPROC
epoxy_glLoadIdentity_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        30140 /* "glLoadIdentity" */,
        30140 /* "glLoadIdentity" */,
    };
    return gl_provider_resolver(entrypoint_strings + 30140 /* "glLoadIdentity" */,
                                providers, entrypoints);
}

static PFNGLLOADIDENTITYDEFORMATIONMAPSGIXPROC
epoxy_glLoadIdentityDeformationMapSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_polynomial_ffd, 30155 /* glLoadIdentityDeformationMapSGIX */);
}

static PFNGLLOADMATRIXDPROC
epoxy_glLoadMatrixd_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 30188 /* glLoadMatrixd */);
}

static PFNGLLOADMATRIXFPROC
epoxy_glLoadMatrixf_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        30202 /* "glLoadMatrixf" */,
        30202 /* "glLoadMatrixf" */,
    };
    return gl_provider_resolver(entrypoint_strings + 30202 /* "glLoadMatrixf" */,
                                providers, entrypoints);
}

static PFNGLLOADMATRIXXPROC
epoxy_glLoadMatrixx_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 30216 /* glLoadMatrixx */);
}

static PFNGLLOADMATRIXXOESPROC
epoxy_glLoadMatrixxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 30230 /* glLoadMatrixxOES */);
}

static PFNGLLOADNAMEPROC
epoxy_glLoadName_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 30247 /* glLoadName */);
}

static PFNGLLOADPALETTEFROMMODELVIEWMATRIXOESPROC
epoxy_glLoadPaletteFromModelViewMatrixOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_matrix_palette, 30258 /* glLoadPaletteFromModelViewMatrixOES */);
}

static PFNGLLOADPROGRAMNVPROC
epoxy_glLoadProgramNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_program, 30294 /* glLoadProgramNV */);
}

static PFNGLLOADTRANSPOSEMATRIXDPROC
epoxy_glLoadTransposeMatrixd_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_3,
        GL_extension_GL_ARB_transpose_matrix,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        30310 /* "glLoadTransposeMatrixd" */,
        30333 /* "glLoadTransposeMatrixdARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 30310 /* "glLoadTransposeMatrixd" */,
                                providers, entrypoints);
}

static PFNGLLOADTRANSPOSEMATRIXDARBPROC
epoxy_glLoadTransposeMatrixdARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_transpose_matrix,
        Desktop_OpenGL_1_3,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        30333 /* "glLoadTransposeMatrixdARB" */,
        30310 /* "glLoadTransposeMatrixd" */,
    };
    return gl_provider_resolver(entrypoint_strings + 30333 /* "glLoadTransposeMatrixdARB" */,
                                providers, entrypoints);
}

static PFNGLLOADTRANSPOSEMATRIXFPROC
epoxy_glLoadTransposeMatrixf_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_3,
        GL_extension_GL_ARB_transpose_matrix,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        30359 /* "glLoadTransposeMatrixf" */,
        30382 /* "glLoadTransposeMatrixfARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 30359 /* "glLoadTransposeMatrixf" */,
                                providers, entrypoints);
}

static PFNGLLOADTRANSPOSEMATRIXFARBPROC
epoxy_glLoadTransposeMatrixfARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_transpose_matrix,
        Desktop_OpenGL_1_3,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        30382 /* "glLoadTransposeMatrixfARB" */,
        30359 /* "glLoadTransposeMatrixf" */,
    };
    return gl_provider_resolver(entrypoint_strings + 30382 /* "glLoadTransposeMatrixfARB" */,
                                providers, entrypoints);
}

static PFNGLLOADTRANSPOSEMATRIXXOESPROC
epoxy_glLoadTransposeMatrixxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 30408 /* glLoadTransposeMatrixxOES */);
}

static PFNGLLOCKARRAYSEXTPROC
epoxy_glLockArraysEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_compiled_vertex_array, 30434 /* glLockArraysEXT */);
}

static PFNGLLOGICOPPROC
epoxy_glLogicOp_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        30450 /* "glLogicOp" */,
        30450 /* "glLogicOp" */,
    };
    return gl_provider_resolver(entrypoint_strings + 30450 /* "glLogicOp" */,
                                providers, entrypoints);
}

static PFNGLMAKEBUFFERNONRESIDENTNVPROC
epoxy_glMakeBufferNonResidentNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_shader_buffer_load, 30460 /* glMakeBufferNonResidentNV */);
}

static PFNGLMAKEBUFFERRESIDENTNVPROC
epoxy_glMakeBufferResidentNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_shader_buffer_load, 30486 /* glMakeBufferResidentNV */);
}

static PFNGLMAKEIMAGEHANDLENONRESIDENTARBPROC
epoxy_glMakeImageHandleNonResidentARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_bindless_texture, 30509 /* glMakeImageHandleNonResidentARB */);
}

static PFNGLMAKEIMAGEHANDLENONRESIDENTNVPROC
epoxy_glMakeImageHandleNonResidentNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_bindless_texture, 30541 /* glMakeImageHandleNonResidentNV */);
}

static PFNGLMAKEIMAGEHANDLERESIDENTARBPROC
epoxy_glMakeImageHandleResidentARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_bindless_texture, 30572 /* glMakeImageHandleResidentARB */);
}

static PFNGLMAKEIMAGEHANDLERESIDENTNVPROC
epoxy_glMakeImageHandleResidentNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_bindless_texture, 30601 /* glMakeImageHandleResidentNV */);
}

static PFNGLMAKENAMEDBUFFERNONRESIDENTNVPROC
epoxy_glMakeNamedBufferNonResidentNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_shader_buffer_load, 30629 /* glMakeNamedBufferNonResidentNV */);
}

static PFNGLMAKENAMEDBUFFERRESIDENTNVPROC
epoxy_glMakeNamedBufferResidentNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_shader_buffer_load, 30660 /* glMakeNamedBufferResidentNV */);
}

static PFNGLMAKETEXTUREHANDLENONRESIDENTARBPROC
epoxy_glMakeTextureHandleNonResidentARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_bindless_texture, 30688 /* glMakeTextureHandleNonResidentARB */);
}

static PFNGLMAKETEXTUREHANDLENONRESIDENTNVPROC
epoxy_glMakeTextureHandleNonResidentNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_bindless_texture, 30722 /* glMakeTextureHandleNonResidentNV */);
}

static PFNGLMAKETEXTUREHANDLERESIDENTARBPROC
epoxy_glMakeTextureHandleResidentARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_bindless_texture, 30755 /* glMakeTextureHandleResidentARB */);
}

static PFNGLMAKETEXTUREHANDLERESIDENTNVPROC
epoxy_glMakeTextureHandleResidentNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_bindless_texture, 30786 /* glMakeTextureHandleResidentNV */);
}

static PFNGLMAP1DPROC
epoxy_glMap1d_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 30816 /* glMap1d */);
}

static PFNGLMAP1FPROC
epoxy_glMap1f_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 30824 /* glMap1f */);
}

static PFNGLMAP1XOESPROC
epoxy_glMap1xOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 30832 /* glMap1xOES */);
}

static PFNGLMAP2DPROC
epoxy_glMap2d_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 30843 /* glMap2d */);
}

static PFNGLMAP2FPROC
epoxy_glMap2f_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 30851 /* glMap2f */);
}

static PFNGLMAP2XOESPROC
epoxy_glMap2xOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 30859 /* glMap2xOES */);
}

static PFNGLMAPBUFFERPROC
epoxy_glMapBuffer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        GL_extension_GL_ARB_vertex_buffer_object,
        GL_extension_GL_OES_mapbuffer,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        30870 /* "glMapBuffer" */,
        30882 /* "glMapBufferARB" */,
        30897 /* "glMapBufferOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 30870 /* "glMapBuffer" */,
                                providers, entrypoints);
}

static PFNGLMAPBUFFERARBPROC
epoxy_glMapBufferARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_buffer_object,
        Desktop_OpenGL_1_5,
        GL_extension_GL_OES_mapbuffer,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        30882 /* "glMapBufferARB" */,
        30870 /* "glMapBuffer" */,
        30897 /* "glMapBufferOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 30882 /* "glMapBufferARB" */,
                                providers, entrypoints);
}

static PFNGLMAPBUFFEROESPROC
epoxy_glMapBufferOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_mapbuffer,
        Desktop_OpenGL_1_5,
        GL_extension_GL_ARB_vertex_buffer_object,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        30897 /* "glMapBufferOES" */,
        30870 /* "glMapBuffer" */,
        30882 /* "glMapBufferARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 30897 /* "glMapBufferOES" */,
                                providers, entrypoints);
}

static PFNGLMAPBUFFERRANGEPROC
epoxy_glMapBufferRange_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_map_buffer_range,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_map_buffer_range,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        30912 /* "glMapBufferRange" */,
        30912 /* "glMapBufferRange" */,
        30912 /* "glMapBufferRange" */,
        30929 /* "glMapBufferRangeEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 30912 /* "glMapBufferRange" */,
                                providers, entrypoints);
}

static PFNGLMAPBUFFERRANGEEXTPROC
epoxy_glMapBufferRangeEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_map_buffer_range,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_map_buffer_range,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        30929 /* "glMapBufferRangeEXT" */,
        30912 /* "glMapBufferRange" */,
        30912 /* "glMapBufferRange" */,
        30912 /* "glMapBufferRange" */,
    };
    return gl_provider_resolver(entrypoint_strings + 30929 /* "glMapBufferRangeEXT" */,
                                providers, entrypoints);
}

static PFNGLMAPCONTROLPOINTSNVPROC
epoxy_glMapControlPointsNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_evaluators, 30949 /* glMapControlPointsNV */);
}

static PFNGLMAPGRID1DPROC
epoxy_glMapGrid1d_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 30970 /* glMapGrid1d */);
}

static PFNGLMAPGRID1FPROC
epoxy_glMapGrid1f_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 30982 /* glMapGrid1f */);
}

static PFNGLMAPGRID1XOESPROC
epoxy_glMapGrid1xOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 30994 /* glMapGrid1xOES */);
}

static PFNGLMAPGRID2DPROC
epoxy_glMapGrid2d_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 31009 /* glMapGrid2d */);
}

static PFNGLMAPGRID2FPROC
epoxy_glMapGrid2f_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 31021 /* glMapGrid2f */);
}

static PFNGLMAPGRID2XOESPROC
epoxy_glMapGrid2xOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 31033 /* glMapGrid2xOES */);
}

static PFNGLMAPNAMEDBUFFERPROC
epoxy_glMapNamedBuffer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        31048 /* "glMapNamedBuffer" */,
        31048 /* "glMapNamedBuffer" */,
    };
    return gl_provider_resolver(entrypoint_strings + 31048 /* "glMapNamedBuffer" */,
                                providers, entrypoints);
}

static PFNGLMAPNAMEDBUFFEREXTPROC
epoxy_glMapNamedBufferEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31065 /* glMapNamedBufferEXT */);
}

static PFNGLMAPNAMEDBUFFERRANGEPROC
epoxy_glMapNamedBufferRange_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_direct_state_access,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        31085 /* "glMapNamedBufferRange" */,
        31085 /* "glMapNamedBufferRange" */,
    };
    return gl_provider_resolver(entrypoint_strings + 31085 /* "glMapNamedBufferRange" */,
                                providers, entrypoints);
}

static PFNGLMAPNAMEDBUFFERRANGEEXTPROC
epoxy_glMapNamedBufferRangeEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31107 /* glMapNamedBufferRangeEXT */);
}

static PFNGLMAPOBJECTBUFFERATIPROC
epoxy_glMapObjectBufferATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_map_object_buffer, 31132 /* glMapObjectBufferATI */);
}

static PFNGLMAPPARAMETERFVNVPROC
epoxy_glMapParameterfvNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_evaluators, 31153 /* glMapParameterfvNV */);
}

static PFNGLMAPPARAMETERIVNVPROC
epoxy_glMapParameterivNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_evaluators, 31172 /* glMapParameterivNV */);
}

static PFNGLMAPTEXTURE2DINTELPROC
epoxy_glMapTexture2DINTEL_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_INTEL_map_texture, 31191 /* glMapTexture2DINTEL */);
}

static PFNGLMAPVERTEXATTRIB1DAPPLEPROC
epoxy_glMapVertexAttrib1dAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_vertex_program_evaluators, 31211 /* glMapVertexAttrib1dAPPLE */);
}

static PFNGLMAPVERTEXATTRIB1FAPPLEPROC
epoxy_glMapVertexAttrib1fAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_vertex_program_evaluators, 31236 /* glMapVertexAttrib1fAPPLE */);
}

static PFNGLMAPVERTEXATTRIB2DAPPLEPROC
epoxy_glMapVertexAttrib2dAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_vertex_program_evaluators, 31261 /* glMapVertexAttrib2dAPPLE */);
}

static PFNGLMAPVERTEXATTRIB2FAPPLEPROC
epoxy_glMapVertexAttrib2fAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_vertex_program_evaluators, 31286 /* glMapVertexAttrib2fAPPLE */);
}

static PFNGLMATERIALFPROC
epoxy_glMaterialf_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        31311 /* "glMaterialf" */,
        31311 /* "glMaterialf" */,
    };
    return gl_provider_resolver(entrypoint_strings + 31311 /* "glMaterialf" */,
                                providers, entrypoints);
}

static PFNGLMATERIALFVPROC
epoxy_glMaterialfv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        31323 /* "glMaterialfv" */,
        31323 /* "glMaterialfv" */,
    };
    return gl_provider_resolver(entrypoint_strings + 31323 /* "glMaterialfv" */,
                                providers, entrypoints);
}

static PFNGLMATERIALIPROC
epoxy_glMateriali_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 31336 /* glMateriali */);
}

static PFNGLMATERIALIVPROC
epoxy_glMaterialiv_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 31348 /* glMaterialiv */);
}

static PFNGLMATERIALXPROC
epoxy_glMaterialx_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 31361 /* glMaterialx */);
}

static PFNGLMATERIALXOESPROC
epoxy_glMaterialxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 31373 /* glMaterialxOES */);
}

static PFNGLMATERIALXVPROC
epoxy_glMaterialxv_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 31388 /* glMaterialxv */);
}

static PFNGLMATERIALXVOESPROC
epoxy_glMaterialxvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 31401 /* glMaterialxvOES */);
}

static PFNGLMATRIXFRUSTUMEXTPROC
epoxy_glMatrixFrustumEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31417 /* glMatrixFrustumEXT */);
}

static PFNGLMATRIXINDEXPOINTERARBPROC
epoxy_glMatrixIndexPointerARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_matrix_palette, 31436 /* glMatrixIndexPointerARB */);
}

static PFNGLMATRIXINDEXPOINTEROESPROC
epoxy_glMatrixIndexPointerOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_matrix_palette, 31460 /* glMatrixIndexPointerOES */);
}

static PFNGLMATRIXINDEXUBVARBPROC
epoxy_glMatrixIndexubvARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_matrix_palette, 31484 /* glMatrixIndexubvARB */);
}

static PFNGLMATRIXINDEXUIVARBPROC
epoxy_glMatrixIndexuivARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_matrix_palette, 31504 /* glMatrixIndexuivARB */);
}

static PFNGLMATRIXINDEXUSVARBPROC
epoxy_glMatrixIndexusvARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_matrix_palette, 31524 /* glMatrixIndexusvARB */);
}

static PFNGLMATRIXLOAD3X2FNVPROC
epoxy_glMatrixLoad3x2fNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 31544 /* glMatrixLoad3x2fNV */);
}

static PFNGLMATRIXLOAD3X3FNVPROC
epoxy_glMatrixLoad3x3fNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 31563 /* glMatrixLoad3x3fNV */);
}

static PFNGLMATRIXLOADIDENTITYEXTPROC
epoxy_glMatrixLoadIdentityEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31582 /* glMatrixLoadIdentityEXT */);
}

static PFNGLMATRIXLOADTRANSPOSE3X3FNVPROC
epoxy_glMatrixLoadTranspose3x3fNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 31606 /* glMatrixLoadTranspose3x3fNV */);
}

static PFNGLMATRIXLOADTRANSPOSEDEXTPROC
epoxy_glMatrixLoadTransposedEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31634 /* glMatrixLoadTransposedEXT */);
}

static PFNGLMATRIXLOADTRANSPOSEFEXTPROC
epoxy_glMatrixLoadTransposefEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31660 /* glMatrixLoadTransposefEXT */);
}

static PFNGLMATRIXLOADDEXTPROC
epoxy_glMatrixLoaddEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31686 /* glMatrixLoaddEXT */);
}

static PFNGLMATRIXLOADFEXTPROC
epoxy_glMatrixLoadfEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31703 /* glMatrixLoadfEXT */);
}

static PFNGLMATRIXMODEPROC
epoxy_glMatrixMode_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        31720 /* "glMatrixMode" */,
        31720 /* "glMatrixMode" */,
    };
    return gl_provider_resolver(entrypoint_strings + 31720 /* "glMatrixMode" */,
                                providers, entrypoints);
}

static PFNGLMATRIXMULT3X2FNVPROC
epoxy_glMatrixMult3x2fNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 31733 /* glMatrixMult3x2fNV */);
}

static PFNGLMATRIXMULT3X3FNVPROC
epoxy_glMatrixMult3x3fNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 31752 /* glMatrixMult3x3fNV */);
}

static PFNGLMATRIXMULTTRANSPOSE3X3FNVPROC
epoxy_glMatrixMultTranspose3x3fNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_path_rendering, 31771 /* glMatrixMultTranspose3x3fNV */);
}

static PFNGLMATRIXMULTTRANSPOSEDEXTPROC
epoxy_glMatrixMultTransposedEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31799 /* glMatrixMultTransposedEXT */);
}

static PFNGLMATRIXMULTTRANSPOSEFEXTPROC
epoxy_glMatrixMultTransposefEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31825 /* glMatrixMultTransposefEXT */);
}

static PFNGLMATRIXMULTDEXTPROC
epoxy_glMatrixMultdEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31851 /* glMatrixMultdEXT */);
}

static PFNGLMATRIXMULTFEXTPROC
epoxy_glMatrixMultfEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31868 /* glMatrixMultfEXT */);
}

static PFNGLMATRIXORTHOEXTPROC
epoxy_glMatrixOrthoEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31885 /* glMatrixOrthoEXT */);
}

static PFNGLMATRIXPOPEXTPROC
epoxy_glMatrixPopEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31902 /* glMatrixPopEXT */);
}

static PFNGLMATRIXPUSHEXTPROC
epoxy_glMatrixPushEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31917 /* glMatrixPushEXT */);
}

static PFNGLMATRIXROTATEDEXTPROC
epoxy_glMatrixRotatedEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31933 /* glMatrixRotatedEXT */);
}

static PFNGLMATRIXROTATEFEXTPROC
epoxy_glMatrixRotatefEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31952 /* glMatrixRotatefEXT */);
}

static PFNGLMATRIXSCALEDEXTPROC
epoxy_glMatrixScaledEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31971 /* glMatrixScaledEXT */);
}

static PFNGLMATRIXSCALEFEXTPROC
epoxy_glMatrixScalefEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 31989 /* glMatrixScalefEXT */);
}

static PFNGLMATRIXTRANSLATEDEXTPROC
epoxy_glMatrixTranslatedEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 32007 /* glMatrixTranslatedEXT */);
}

static PFNGLMATRIXTRANSLATEFEXTPROC
epoxy_glMatrixTranslatefEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 32029 /* glMatrixTranslatefEXT */);
}

static PFNGLMEMORYBARRIERPROC
epoxy_glMemoryBarrier_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_2,
        GL_extension_GL_ARB_shader_image_load_store,
        OpenGL_ES_3_1,
        GL_extension_GL_EXT_shader_image_load_store,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32051 /* "glMemoryBarrier" */,
        32051 /* "glMemoryBarrier" */,
        32051 /* "glMemoryBarrier" */,
        32091 /* "glMemoryBarrierEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32051 /* "glMemoryBarrier" */,
                                providers, entrypoints);
}

static PFNGLMEMORYBARRIERBYREGIONPROC
epoxy_glMemoryBarrierByRegion_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_5,
        GL_extension_GL_ARB_ES3_1_compatibility,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32067 /* "glMemoryBarrierByRegion" */,
        32067 /* "glMemoryBarrierByRegion" */,
        32067 /* "glMemoryBarrierByRegion" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32067 /* "glMemoryBarrierByRegion" */,
                                providers, entrypoints);
}

static PFNGLMEMORYBARRIEREXTPROC
epoxy_glMemoryBarrierEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_shader_image_load_store,
        Desktop_OpenGL_4_2,
        GL_extension_GL_ARB_shader_image_load_store,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32091 /* "glMemoryBarrierEXT" */,
        32051 /* "glMemoryBarrier" */,
        32051 /* "glMemoryBarrier" */,
        32051 /* "glMemoryBarrier" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32091 /* "glMemoryBarrierEXT" */,
                                providers, entrypoints);
}

static PFNGLMINSAMPLESHADINGPROC
epoxy_glMinSampleShading_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_sample_shading,
        GL_extension_GL_OES_sample_shading,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32110 /* "glMinSampleShading" */,
        32129 /* "glMinSampleShadingARB" */,
        32151 /* "glMinSampleShadingOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32110 /* "glMinSampleShading" */,
                                providers, entrypoints);
}

static PFNGLMINSAMPLESHADINGARBPROC
epoxy_glMinSampleShadingARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_sample_shading,
        Desktop_OpenGL_4_0,
        GL_extension_GL_OES_sample_shading,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32129 /* "glMinSampleShadingARB" */,
        32110 /* "glMinSampleShading" */,
        32151 /* "glMinSampleShadingOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32129 /* "glMinSampleShadingARB" */,
                                providers, entrypoints);
}

static PFNGLMINSAMPLESHADINGOESPROC
epoxy_glMinSampleShadingOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_sample_shading,
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_sample_shading,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32151 /* "glMinSampleShadingOES" */,
        32110 /* "glMinSampleShading" */,
        32129 /* "glMinSampleShadingARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32151 /* "glMinSampleShadingOES" */,
                                providers, entrypoints);
}

static PFNGLMINMAXPROC
epoxy_glMinmax_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_imaging,
        GL_extension_GL_EXT_histogram,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32173 /* "glMinmax" */,
        32182 /* "glMinmaxEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32173 /* "glMinmax" */,
                                providers, entrypoints);
}

static PFNGLMINMAXEXTPROC
epoxy_glMinmaxEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_histogram,
        GL_extension_GL_ARB_imaging,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32182 /* "glMinmaxEXT" */,
        32173 /* "glMinmax" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32182 /* "glMinmaxEXT" */,
                                providers, entrypoints);
}

static PFNGLMULTMATRIXDPROC
epoxy_glMultMatrixd_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 32194 /* glMultMatrixd */);
}

static PFNGLMULTMATRIXFPROC
epoxy_glMultMatrixf_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32208 /* "glMultMatrixf" */,
        32208 /* "glMultMatrixf" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32208 /* "glMultMatrixf" */,
                                providers, entrypoints);
}

static PFNGLMULTMATRIXXPROC
epoxy_glMultMatrixx_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 32222 /* glMultMatrixx */);
}

static PFNGLMULTMATRIXXOESPROC
epoxy_glMultMatrixxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 32236 /* glMultMatrixxOES */);
}

static PFNGLMULTTRANSPOSEMATRIXDPROC
epoxy_glMultTransposeMatrixd_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_3,
        GL_extension_GL_ARB_transpose_matrix,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32253 /* "glMultTransposeMatrixd" */,
        32276 /* "glMultTransposeMatrixdARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32253 /* "glMultTransposeMatrixd" */,
                                providers, entrypoints);
}

static PFNGLMULTTRANSPOSEMATRIXDARBPROC
epoxy_glMultTransposeMatrixdARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_transpose_matrix,
        Desktop_OpenGL_1_3,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32276 /* "glMultTransposeMatrixdARB" */,
        32253 /* "glMultTransposeMatrixd" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32276 /* "glMultTransposeMatrixdARB" */,
                                providers, entrypoints);
}

static PFNGLMULTTRANSPOSEMATRIXFPROC
epoxy_glMultTransposeMatrixf_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_3,
        GL_extension_GL_ARB_transpose_matrix,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32302 /* "glMultTransposeMatrixf" */,
        32325 /* "glMultTransposeMatrixfARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32302 /* "glMultTransposeMatrixf" */,
                                providers, entrypoints);
}

static PFNGLMULTTRANSPOSEMATRIXFARBPROC
epoxy_glMultTransposeMatrixfARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_transpose_matrix,
        Desktop_OpenGL_1_3,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32325 /* "glMultTransposeMatrixfARB" */,
        32302 /* "glMultTransposeMatrixf" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32325 /* "glMultTransposeMatrixfARB" */,
                                providers, entrypoints);
}

static PFNGLMULTTRANSPOSEMATRIXXOESPROC
epoxy_glMultTransposeMatrixxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 32351 /* glMultTransposeMatrixxOES */);
}

static PFNGLMULTIDRAWARRAYSPROC
epoxy_glMultiDrawArrays_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_4,
        GL_extension_GL_EXT_multi_draw_arrays,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32377 /* "glMultiDrawArrays" */,
        32395 /* "glMultiDrawArraysEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32377 /* "glMultiDrawArrays" */,
                                providers, entrypoints);
}

static PFNGLMULTIDRAWARRAYSEXTPROC
epoxy_glMultiDrawArraysEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_multi_draw_arrays,
        Desktop_OpenGL_1_4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32395 /* "glMultiDrawArraysEXT" */,
        32377 /* "glMultiDrawArrays" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32395 /* "glMultiDrawArraysEXT" */,
                                providers, entrypoints);
}

static PFNGLMULTIDRAWARRAYSINDIRECTPROC
epoxy_glMultiDrawArraysIndirect_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_multi_draw_indirect,
        GL_extension_GL_AMD_multi_draw_indirect,
        GL_extension_GL_EXT_multi_draw_indirect,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32416 /* "glMultiDrawArraysIndirect" */,
        32416 /* "glMultiDrawArraysIndirect" */,
        32442 /* "glMultiDrawArraysIndirectAMD" */,
        32582 /* "glMultiDrawArraysIndirectEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32416 /* "glMultiDrawArraysIndirect" */,
                                providers, entrypoints);
}

static PFNGLMULTIDRAWARRAYSINDIRECTAMDPROC
epoxy_glMultiDrawArraysIndirectAMD_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_AMD_multi_draw_indirect,
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_multi_draw_indirect,
        GL_extension_GL_EXT_multi_draw_indirect,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32442 /* "glMultiDrawArraysIndirectAMD" */,
        32416 /* "glMultiDrawArraysIndirect" */,
        32416 /* "glMultiDrawArraysIndirect" */,
        32582 /* "glMultiDrawArraysIndirectEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32442 /* "glMultiDrawArraysIndirectAMD" */,
                                providers, entrypoints);
}

static PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSCOUNTNVPROC
epoxy_glMultiDrawArraysIndirectBindlessCountNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_bindless_multi_draw_indirect_count, 32471 /* glMultiDrawArraysIndirectBindlessCountNV */);
}

static PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSNVPROC
epoxy_glMultiDrawArraysIndirectBindlessNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_bindless_multi_draw_indirect, 32512 /* glMultiDrawArraysIndirectBindlessNV */);
}

static PFNGLMULTIDRAWARRAYSINDIRECTCOUNTARBPROC
epoxy_glMultiDrawArraysIndirectCountARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_indirect_parameters, 32548 /* glMultiDrawArraysIndirectCountARB */);
}

static PFNGLMULTIDRAWARRAYSINDIRECTEXTPROC
epoxy_glMultiDrawArraysIndirectEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_multi_draw_indirect,
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_multi_draw_indirect,
        GL_extension_GL_AMD_multi_draw_indirect,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32582 /* "glMultiDrawArraysIndirectEXT" */,
        32416 /* "glMultiDrawArraysIndirect" */,
        32416 /* "glMultiDrawArraysIndirect" */,
        32442 /* "glMultiDrawArraysIndirectAMD" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32582 /* "glMultiDrawArraysIndirectEXT" */,
                                providers, entrypoints);
}

static PFNGLMULTIDRAWELEMENTARRAYAPPLEPROC
epoxy_glMultiDrawElementArrayAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_element_array, 32611 /* glMultiDrawElementArrayAPPLE */);
}

static PFNGLMULTIDRAWELEMENTSPROC
epoxy_glMultiDrawElements_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_4,
        GL_extension_GL_EXT_multi_draw_arrays,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32640 /* "glMultiDrawElements" */,
        32756 /* "glMultiDrawElementsEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32640 /* "glMultiDrawElements" */,
                                providers, entrypoints);
}

static PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC
epoxy_glMultiDrawElementsBaseVertex_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_draw_elements_base_vertex,
        GL_extension_GL_EXT_draw_elements_base_vertex,
        GL_extension_GL_OES_draw_elements_base_vertex,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32660 /* "glMultiDrawElementsBaseVertex" */,
        32660 /* "glMultiDrawElementsBaseVertex" */,
        32690 /* "glMultiDrawElementsBaseVertexEXT" */,
        32723 /* "glMultiDrawElementsBaseVertexOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32660 /* "glMultiDrawElementsBaseVertex" */,
                                providers, entrypoints);
}

static PFNGLMULTIDRAWELEMENTSBASEVERTEXEXTPROC
epoxy_glMultiDrawElementsBaseVertexEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_draw_elements_base_vertex,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_draw_elements_base_vertex,
        GL_extension_GL_OES_draw_elements_base_vertex,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32690 /* "glMultiDrawElementsBaseVertexEXT" */,
        32660 /* "glMultiDrawElementsBaseVertex" */,
        32660 /* "glMultiDrawElementsBaseVertex" */,
        32723 /* "glMultiDrawElementsBaseVertexOES" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32690 /* "glMultiDrawElementsBaseVertexEXT" */,
                                providers, entrypoints);
}

static PFNGLMULTIDRAWELEMENTSBASEVERTEXOESPROC
epoxy_glMultiDrawElementsBaseVertexOES_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_OES_draw_elements_base_vertex,
        Desktop_OpenGL_3_2,
        GL_extension_GL_ARB_draw_elements_base_vertex,
        GL_extension_GL_EXT_draw_elements_base_vertex,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32723 /* "glMultiDrawElementsBaseVertexOES" */,
        32660 /* "glMultiDrawElementsBaseVertex" */,
        32660 /* "glMultiDrawElementsBaseVertex" */,
        32690 /* "glMultiDrawElementsBaseVertexEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32723 /* "glMultiDrawElementsBaseVertexOES" */,
                                providers, entrypoints);
}

static PFNGLMULTIDRAWELEMENTSEXTPROC
epoxy_glMultiDrawElementsEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_multi_draw_arrays,
        Desktop_OpenGL_1_4,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32756 /* "glMultiDrawElementsEXT" */,
        32640 /* "glMultiDrawElements" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32756 /* "glMultiDrawElementsEXT" */,
                                providers, entrypoints);
}

static PFNGLMULTIDRAWELEMENTSINDIRECTPROC
epoxy_glMultiDrawElementsIndirect_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_multi_draw_indirect,
        GL_extension_GL_AMD_multi_draw_indirect,
        GL_extension_GL_EXT_multi_draw_indirect,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32779 /* "glMultiDrawElementsIndirect" */,
        32779 /* "glMultiDrawElementsIndirect" */,
        32807 /* "glMultiDrawElementsIndirectAMD" */,
        32955 /* "glMultiDrawElementsIndirectEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32779 /* "glMultiDrawElementsIndirect" */,
                                providers, entrypoints);
}

static PFNGLMULTIDRAWELEMENTSINDIRECTAMDPROC
epoxy_glMultiDrawElementsIndirectAMD_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_AMD_multi_draw_indirect,
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_multi_draw_indirect,
        GL_extension_GL_EXT_multi_draw_indirect,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32807 /* "glMultiDrawElementsIndirectAMD" */,
        32779 /* "glMultiDrawElementsIndirect" */,
        32779 /* "glMultiDrawElementsIndirect" */,
        32955 /* "glMultiDrawElementsIndirectEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32807 /* "glMultiDrawElementsIndirectAMD" */,
                                providers, entrypoints);
}

static PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSCOUNTNVPROC
epoxy_glMultiDrawElementsIndirectBindlessCountNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_bindless_multi_draw_indirect_count, 32838 /* glMultiDrawElementsIndirectBindlessCountNV */);
}

static PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSNVPROC
epoxy_glMultiDrawElementsIndirectBindlessNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_bindless_multi_draw_indirect, 32881 /* glMultiDrawElementsIndirectBindlessNV */);
}

static PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTARBPROC
epoxy_glMultiDrawElementsIndirectCountARB_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ARB_indirect_parameters, 32919 /* glMultiDrawElementsIndirectCountARB */);
}

static PFNGLMULTIDRAWELEMENTSINDIRECTEXTPROC
epoxy_glMultiDrawElementsIndirectEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_multi_draw_indirect,
        Desktop_OpenGL_4_3,
        GL_extension_GL_ARB_multi_draw_indirect,
        GL_extension_GL_AMD_multi_draw_indirect,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        32955 /* "glMultiDrawElementsIndirectEXT" */,
        32779 /* "glMultiDrawElementsIndirect" */,
        32779 /* "glMultiDrawElementsIndirect" */,
        32807 /* "glMultiDrawElementsIndirectAMD" */,
    };
    return gl_provider_resolver(entrypoint_strings + 32955 /* "glMultiDrawElementsIndirectEXT" */,
                                providers, entrypoints);
}

static PFNGLMULTIDRAWRANGEELEMENTARRAYAPPLEPROC
epoxy_glMultiDrawRangeElementArrayAPPLE_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_APPLE_element_array, 32986 /* glMultiDrawRangeElementArrayAPPLE */);
}

static PFNGLMULTIMODEDRAWARRAYSIBMPROC
epoxy_glMultiModeDrawArraysIBM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_IBM_multimode_draw_arrays, 33020 /* glMultiModeDrawArraysIBM */);
}

static PFNGLMULTIMODEDRAWELEMENTSIBMPROC
epoxy_glMultiModeDrawElementsIBM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_IBM_multimode_draw_arrays, 33045 /* glMultiModeDrawElementsIBM */);
}

static PFNGLMULTITEXBUFFEREXTPROC
epoxy_glMultiTexBufferEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 33072 /* glMultiTexBufferEXT */);
}

static PFNGLMULTITEXCOORD1BOESPROC
epoxy_glMultiTexCoord1bOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_byte_coordinates, 33092 /* glMultiTexCoord1bOES */);
}

static PFNGLMULTITEXCOORD1BVOESPROC
epoxy_glMultiTexCoord1bvOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_byte_coordinates, 33113 /* glMultiTexCoord1bvOES */);
}

static PFNGLMULTITEXCOORD1DPROC
epoxy_glMultiTexCoord1d_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_3,
        GL_extension_GL_ARB_multitexture,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        33135 /* "glMultiTexCoord1d" */,
        33153 /* "glMultiTexCoord1dARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 33135 /* "glMultiTexCoord1d" */,
                                providers, entrypoints);
}

static PFNGLMULTITEXCOORD1DARBPROC
epoxy_glMultiTexCoord1dARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_multitexture,
        Desktop_OpenGL_1_3,
        gl_provider_terminator
    };
    static const uint16_t entrypoints[] = {
        33153 /* "glMultiTexCoord1dARB" */,
        33135 /* "glMultiTexCoord1d" */,
    };
    return gl_provider_resolver(entrypoint_strings + 33153 /* "glMultiTexCoord1dARB" */,
                                providers, entrypoints);
}

static PFNGLMULTITEXCOORD1DVPROC
epoxy_glMultiTexCoord1dv_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_3,
        GL_extension_GL_ARB_multitexture,
     