<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_mime - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_mime</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_mime.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_mime.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_mime.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Associe les extensions des fichiers demands avec l'action
dclenche par ces fichiers et avec leur contenu (type MIME, langue,
jeu de caractre et codage)</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>mime_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_mime.c</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module permet d'assigner des mtadonnes aux contenus
    slectionns pour une rponse HTTP, en associant des modles d'URI
    ou de noms de fichiers aux valeurs des mtadonnes. Par exemple, les
    extensions de noms de fichiers dfinissent souvent le type de mdium
    Internet, la langue, le jeu de caractres et le codage du contenu.
    Ces informations sont relayes par les messages HTTP vhiculant ces
    contenus, et utilises au cours de la ngociation de contenu lors de
    la slection des diffrentes possibilits, de manire  ce que les
    prfrences des utilisateurs soient respectes lors du choix d'un
    contenu  servir parmi plusieurs autres contenus. Voir
    <code class="module"><a href="../mod/mod_negotiation.html">mod_negotiation</a></code> pour plus d'informations  propos
    de la <a href="../content-negotiation.html">ngociation de
    contenu</a>.</p>

    <p>Les directives <code class="directive"><a href="#addcharset">AddCharset</a></code>, <code class="directive"><a href="#addencoding">AddEncoding</a></code>, <code class="directive"><a href="#addlanguage">AddLanguage</a></code> et <code class="directive"><a href="#addtype">AddType</a></code> permettent d'associer des
    extensions de fichiers aux mtadonnes de ces fichiers. Elles
    dfinissent respectivement le jeu de caractres, le codage du
    contenu, la langue du contenu et le <a class="glossarylink" href="../glossary.html#type de&#10;    mdium" title="voir glossaire">type de
    mdium</a> (content-type) des documents. La directive
    <code class="directive"><a href="#typesconfig">TypesConfig</a></code> permet de
    spcifier un fichier qui contient lui-mme des associations entre
    extensions et types de media.</p>

    <p>De plus, <code class="module"><a href="../mod/mod_mime.html">mod_mime</a></code> peut dfinir le <a href="../handler.html">gestionnaire</a> et les <a href="../filter.html">filtres</a> qui sont  l'origine du contenu et
    le traitent. Les directives <code class="directive"><a href="#addhandler">AddHandler</a></code>, <code class="directive"><a href="#addoutputfilter">AddOutputFilter</a></code>, et <code class="directive"><a href="#addinputfilter">AddInputFilter</a></code> permettent de contrler
    les modules ou les scripts qui vont servir le document. La directive
    <code class="directive"><a href="#multiviewsmatch">MultiviewsMatch</a></code> permet 
    <code class="module"><a href="../mod/mod_negotiation.html">mod_negotiation</a></code> de dterminer les extensions de
    fichiers  inclure lors des tests de correspondances multivues.</p>

    <p>Alors que <code class="module"><a href="../mod/mod_mime.html">mod_mime</a></code> associe des mtadonnes avec
    des extensions de fichiers, le serveur de base <code class="module"><a href="../mod/core.html">core</a></code>
    fournit des directives permettant d'associer tous les fichiers d'un
    conteneur donn (par exemple <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code>, <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code>, ou <code class="directive"><a href="../mod/core.html#files">&lt;Files&gt;</a></code>) avec des mtadonnes particulires.
    Parmi ces directives, on trouve <code class="directive"><a href="../mod/core.html#forcetype">ForceType</a></code>, <code class="directive"><a href="../mod/core.html#sethandler">SetHandler</a></code>, <code class="directive"><a href="../mod/core.html#setinputfilter">SetInputFilter</a></code>, et <code class="directive"><a href="../mod/core.html#setoutputfilter">SetOutputFilter</a></code>. Les directives du serveur
    de base l'emportent sur toute directive d'association d'extensions
    de noms de fichiers dfinie par <code class="module"><a href="../mod/mod_mime.html">mod_mime</a></code>.</p>

    <p>Notez que la modification des mtadonnes d'un fichier ne modifie
    pas la valeur de l'en-tte <code>Last-Modified</code>. Ainsi,
    certaines copies de documents pralablement mises en cache peuvent
    encore tre utilises par un client ou un mandataire avec les
    anciens en-ttes. Si vous modifiez les mtadonnes (langue, type de
    contenu, jeu de caractre ou codage), vous devez donc enregistrer
    une modification du fichier concern (afin de mettre  jour sa date
    de dernire modification), pour tre sr que tous les visiteurs
    recevront le documents avec les en-ttes corrects. </p>
</div>
<div id="quickview"><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#multipleext">Fichiers avec extensions
multiples</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#contentencoding">Codage du contenu</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#charset-lang">Jeux de caractres et langues</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#addcharset">AddCharset</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#addencoding">AddEncoding</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#addhandler">AddHandler</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#addinputfilter">AddInputFilter</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#addlanguage">AddLanguage</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#addoutputfilter">AddOutputFilter</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#addtype">AddType</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#defaultlanguage">DefaultLanguage</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#modmimeusepathinfo">ModMimeUsePathInfo</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#multiviewsmatch">MultiviewsMatch</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#removecharset">RemoveCharset</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#removeencoding">RemoveEncoding</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#removehandler">RemoveHandler</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#removeinputfilter">RemoveInputFilter</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#removelanguage">RemoveLanguage</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#removeoutputfilter">RemoveOutputFilter</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#removetype">RemoveType</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#typesconfig">TypesConfig</a></li>
</ul>
<h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="directive"><a href="../mod/mod_mime_magic.html#mimemagicfile">MimeMagicFile</a></code></li>
<li><code class="directive"><a href="../mod/core.html#adddefaultcharset">AddDefaultCharset</a></code></li>
<li><code class="directive"><a href="../mod/core.html#forcetype">ForceType</a></code></li>
<li><code class="directive"><a href="../mod/core.html#sethandler">SetHandler</a></code></li>
<li><code class="directive"><a href="../mod/core.html#setinputfilter">SetInputFilter</a></code></li>
<li><code class="directive"><a href="../mod/core.html#setoutputfilter">SetOutputFilter</a></code></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="multipleext" id="multipleext">Fichiers avec extensions
multiples</a></h2>
    <p>Les fichiers peuvent possder plusieurs extensions dont l'ordre
    est <em>normalement</em> sans importance. Par exemple, si
    le fichier <code>welcome.html.fr</code> est associ au type de
    contenu <code>text/html</code> et  la langue franaise, le fichier
    <code>welcome.fr.html</code> possdera exactement les mme
    mtadonnes. Si le fichier possde plusieurs extensions associes
    au mme type de mtadonne, c'est celle de ces extensions la plus 
    droite qui sera utilise, except pour ce qui concerne les langues
    et les codages de contenu. Par exemple, si <code>.gif</code> est
    associ au <a class="glossarylink" href="../glossary.html#type de mdium" title="voir glossaire">type de mdium</a>
    <code>image/gif</code>, et <code>.html</code> au type de mdium
    <code>text/html</code>, le fichier <code>welcome.gif.html</code>
    sera associ au type de mdium <code>text/html</code>.</p>

    <p>Les <a href="#charset-lang">Languages</a> et les <a href="#contentencoding">codages de contenu</a> sont traits de
    manire cumulative, car il est possible d'assigner plusieurs
    langues ou codages  une ressource particulire. Par exemple, le
    fichier <code>welcome.html.en.de</code> sera servi avec les en-ttes
    <code>Content-Language: en, de</code> et <code>Content-Type:
    text/html</code>.</p>

    <p>Des prcautions doivent tre prises lorsqu'un fichier avec
    extensions multiples est associ  la fois  un <a class="glossarylink" href="../glossary.html#type de&#10;    mdium" title="voir glossaire">type de
    mdium</a> et  un gestionnaire. En gnral, cela impliquera
    la gestion de la requte par le module associ au gestionnaire. Par
    exemple, si l'extension <code>.imap</code> est associe au
    gestionnaire <code>imap-file</code> (du module
    <code class="module"><a href="../mod/mod_imagemap.html">mod_imagemap</a></code>), et si l'extension <code>.html</code>
    est associe au type de mdium <code>text/html</code>, le fichier
    <code>world.imap.html</code> sera  la fois associ au gestionnaire
    <code>imap-file</code> et au type de mdium <code>text/html</code>.
    Pour son traitement, c'est le gestionnaire <code>imap-file</code>
    qui sera utilis, et il sera donc trait en tant que fichier
    imagemap.</p>

    <p>Si vous prfrez que seule la dernire partie d'un nom de fichier
    spare du reste du nom par un point soit associe  une mtadonne
    particulire, n'utilisez pas les directives <code>Add*</code>. Par
    exemple, si vous souhaitez que le fichier <code>foo.html.cgi</code>
    soit trait en tant que script CGI, mais pas le fichier
    <code>bar.cgi.html</code>, alors, au lieu d'utiliser
    <code>AddHandler cgi-script .cgi</code>, utilisez plutt :</p>

    <div class="example"><h3>Configuration du gestionnaire en se basant seulement
    sur la dernire extension</h3><pre class="prettyprint lang-config">&lt;FilesMatch "[^.]+\.cgi$"&gt;
  SetHandler cgi-script
&lt;/FilesMatch&gt;</pre>
</div>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="contentencoding" id="contentencoding">Codage du contenu</a></h2>
    <p>Un fichier d'un <a class="glossarylink" href="../glossary.html#type de mdium" title="voir glossaire">type de mdium</a> particulier
    peut tre galement cod d'une certaine manire pour simplifier sa
    transmission sur Internet. Alors que cela concerne en gnral la
    compression, comme <code>gzip</code>, il peut aussi s'agir de
    chiffrement, comme <code>pgp</code> ou d'un codage comme UUencoding,
    qui est conu pour transmettre un fichier binaire sous un format
    ASCII (texte).</p>

    <p>La <a href="http://www.ietf.org/rfc/rfc2616.txt">RFC
    HTTP/1.1</a>, section 14.11 stipule  ce titre :</p>

    <blockquote cite="http://www.ietf.org/rfc/rfc2616.txt">
      <p>Le champ d'en-tte Content-Encoding de l'entit est utilis en
      tant que modificateur du type de mdium. Lorsqu'il est prsent, sa
      valeur indique quels codages de contenu additionnels ont t
      appliqus au corps de l'entit, et ainsi quels mcanismes de
      dcodage doivent tre appliqus afin de retrouver le type de
      mdium rfrenc par le champ d'en-tte Content-Type. Le codage de
      contenu est principalement utilis pour permettre la compression
      d'un document sans perdre l'information concernant le type de
      mdium sous-jacent.</p>
    </blockquote>

    <p>En utilisant plusieurs extensions (voir la <a href="#multipleext">section ci-dessus  propos des extensions de
    fichiers multiples</a>), vous pouvez indiquer qu'un fichier est d'un
    <em>type</em>, particulier, et possde aussi un <em>codage</em>
    particulier.</p>

    <p>Considrons par exemple un fichier contenant un document
    Microsoft Word et compress par pkzip pour rduire sa taille. Si
    l'extension <code>.doc</code> est associe au type de fichier
    Microsoft Word, et si l'extension <code>.zip</code> est associe au
    codage de fichier pkzip, alors le fichier
    <code>Resume.doc.zip</code> sera identifi comme document Word
    compress par pkzip.</p>

    <p>Apache joint un en-tte <code>Content-encoding</code>  la
    ressource afin d'informer le navigateur client  propos de la
    mthode de codage.</p>

    <pre class="prettyprint lang-config">Content-encoding: pkzip</pre>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="charset-lang" id="charset-lang">Jeux de caractres et langues</a></h2>
    <p>En plus du type de fichier et du codage, un autre lment
    important d'information est la langue dans laquelle le document est
    crit, et avec quel jeu de caractres le contenu du fichier doit
    tre affich. Par exemple, un document peut tre crit en alphabet
    vietnamien ou cyrillique, et doit tre affich en consquence. Cette
    information est galement transmise via des en-ttes HTTP.</p>

    <p>Les jeu de caractres, langue, codage et type MIME sont tous
    utiliss au cours du processus de ngociation de contenu (voir
    <code class="module"><a href="../mod/mod_negotiation.html">mod_negotiation</a></code>) afin de dterminer quel document
    servir au client, lorsque plusieurs choix sont possibles en fonction
    du jeu de caractres, de la langue, du codage ou du type MIME. Toutes
    les associations d'extensions de noms de fichiers cres via les
    directives <code class="directive"><a href="#addcharset">AddCharset</a></code>,
    <code class="directive"><a href="#addencoding">AddEncoding</a></code>, <code class="directive"><a href="#addlanguage">AddLanguage</a></code> et <code class="directive"><a href="#addtype">AddType</a></code> (ainsi que les associations
    d'extensions listes dans le fichier dfini par la directive
    <code class="directive"><a href="../mod/mod_mime_magic.html#mimemagicfile">MimeMagicFile</a></code>),
    participent  ce processus de slection. Les extensions de noms de
    fichiers qui n'ont t associs que par des directives <code class="directive"><a href="#addhandler">AddHandler</a></code>, <code class="directive"><a href="#addinputfilter">AddInputFilter</a></code> ou <code class="directive"><a href="#addoutputfilter">AddOutputFilter</a></code>, peuvent tre incluses
    ou exclues du processus de slection en utilisant la directive
    <code class="directive"><a href="#multiviewsmatch">MultiviewsMatch</a></code>.</p>

    <h3><a name="charset" id="charset">Jeu de caractres</a></h3>
      <p>Pour transmettre cette information supplmentaire, Apache peut
      ajouter un en-tte <code>Content-Language</code>, afin de
      spcifier la langue dans laquelle le document est crit, et peut
      ajouter des informations additionnelles  l'en-tte
      <code>Content-Type</code> pour indiquer le jeu de caractres
      particulier qui doit tre utilis pour restituer correctement le
      document.</p>

      <div class="example"><p><code>
        Content-Language: en, fr
Content-Type: text/plain; charset=ISO-8859-1
      </code></p></div>

      <p>La langue est spcifie via son abrviation en deux lettres. Le
      <code>jeu de caractres</code> est le nom du jeu de caractres
      particulier qui doit tre utilis.</p>
    
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="addcharset" id="addcharset">Directive</a> <a name="AddCharset" id="AddCharset">AddCharset</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Associe les extensions de noms de fichiers spcifies au
jeu de caractres spcifi</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddCharset <var>jeu-car</var> <var>extension</var>
[<var>extension</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">AddCharset</code> permet d'associer
    les extensions de noms de fichiers spcifies au jeu de caractres
    spcifi (le nom enregistr sur l'Internet d'un codage de caractres
    donn). <var>jeu-car</var> est le <a href="http://www.iana.org/assignments/character-sets">paramtre jeu
    de caractres du type de mdium</a> pour les ressources dont le nom
    de fichier contient <var>extension</var>. Cette association est
    ajoute  toutes les autres dj en vigueur, et crase toute
    association prexistante pour la mme <var>extension</var>.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">AddLanguage ja .ja
AddCharset EUC-JP .euc
AddCharset ISO-2022-JP .jis
AddCharset SHIFT_JIS .sjis</pre>
</div>

    <p>Avec cet exemple, le document <code>xxxx.ja.jis</code> sera
    trait en tant que document japonais dont le jeu de caractre est
    <code>ISO-2022-JP</code> (idem pour le document
    <code>xxxx.jis.ja</code>). La directive
    <code class="directive">AddCharset</code> sert  la fois  informer le
    client sur le codage des caractres du document afin que ce dernier
    puisse tre interprt et affich correctement, et  la <a href="../content-negotiation.html">ngociation de contenu</a>, au
    cours de laquelle le serveur dcide lequel parmi plusieurs
    documents possibles il renvoie au client en fonction des prfrences
    de ce dernier en matire de jeu de caractres.</p>

    <p>L'argument <var>extension</var> est insensible  la casse et peut
    tre spcifi avec ou sans le point initial. Les noms de fichiers
    peuvent possder <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera compar  chacune d'entre
    elles.</p>


<h3>Voir aussi</h3>
<ul>
<li><code class="module"><a href="../mod/mod_negotiation.html">mod_negotiation</a></code></li>
<li><code class="directive"><a href="../mod/core.html#adddefaultcharset">AddDefaultCharset</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="addencoding" id="addencoding">Directive</a> <a name="AddEncoding" id="AddEncoding">AddEncoding</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Associe les extensions de noms de fichiers donnes au type
de codage spcifi</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddEncoding <var>codage</var> <var>extension</var>
[<var>extension</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">AddEncoding</code> permet d'associer
    les extensions de noms de fichiers donnes au codage de contenu HTTP
    spcifi. <var>codage</var> est le codage de contenu HTTP  ajouter
     la valeur du champ d'en-tte Content-Encoding pour les documents
    possdant l'<var>extension</var> spcifie. Cette association est
    ajoute  toutes les autres dj en vigueur, et crase toute
    association prexistante pour la mme <var>extension</var>.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">AddEncoding x-gzip .gz
AddEncoding x-compress .Z</pre>
</div>

    <p>Avec cet exemple, les noms de fichiers possdant l'extension
    <code>.gz</code> seront marqus comme cods  l'aide du codage
    <code>x-gzip</code>, et les noms de fichiers possdant l'extension
    <code>.Z</code> comme cods avec <code>x-compress</code>.</p>

    <p>Les clients anciens n'acceptent que <code>x-gzip</code> et
    <code>x-compress</code>, bien que les standards stipulent qu'ils
    sont respectivement quivalents  <code>gzip</code> et
    <code>compress</code>. Apache effectue ses comparaisons de codages
    de contenu en ignorant tout prfixe <code>x-</code>. Lorsqu'il
    rpond avec un codage, Apache utilise l'une ou l'autre forme (c'est
     dire <code>x-foo</code> ou <code>foo</code>) selon les besoins du
    client. Si le client n'a pas besoin d'une forme particulire, Apache
    utilisera la forme employe par la directive
    <code>AddEncoding</code>. Pour rsumer, vous devez toujours utiliser
    <code>x-gzip</code> et <code>x-compress</code> pour ces deux
    codages spcifiques. Certains codages plus rcents, comme
    <code>deflate</code>, doivent tre spcifis sans le prfixe
    <code>x-</code>.</p>

    <p>L'argument <var>extension</var> est insensible  la casse et peut
    tre spcifi avec ou sans le point initial. Les noms de fichiers
    peuvent possder <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera compar  chacune d'entre
    elles.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="addhandler" id="addhandler">Directive</a> <a name="AddHandler" id="AddHandler">AddHandler</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Associe les extensions de noms de fichiers donnes au
gestionnaire spcifi</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddHandler <var>nom-gestionnaire</var> <var>extension</var>
[<var>extension</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>Les fichiers dont le nom a pour extension <var>extension</var>
    seront servis par le <var><a href="../handler.html">nom-gestionnaire</a></var> spcifi. Cette
    association est ajoute  toutes les autres dj en vigueur, et
    crase toute association prexistante pour la mme
    <var>extension</var>. Par exemple, pour associer les scripts CGI
    avec l'extension de fichier <code>.cgi</code>, vous pouvez utiliser
    :</p>

    <pre class="prettyprint lang-config">AddHandler cgi-script .cgi</pre>


    <p>Une fois cette ligne insre dans votre fichier httpd.conf, tout
    fichier possdant l'extension <code>.cgi</code> sera trait en tant
    que programme CGI.</p>

    <p>L'argument <var>extension</var> est insensible  la casse et peut
    tre spcifi avec ou sans le point initial. Les noms de fichiers
    peuvent possder <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera compar  chacune d'entre
    elles.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/core.html#sethandler">SetHandler</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="addinputfilter" id="addinputfilter">Directive</a> <a name="AddInputFilter" id="AddInputFilter">AddInputFilter</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Associe les extensions de noms de fichiers aux
filtres spcifis qui traiteront les requtes clients</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddInputFilter <var>filtre</var>[;<var>filtre</var>...]
<var>extension</var> [<var>extension</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">AddInputFilter</code> permet
    d'associer l'extension de nom de fichier <var>extension</var> aux <a href="../filter.html">filtres</a> spcifis qui traiteront les
    requtes clients et les entres POST  leur rception par le
    serveur. Ceci s'ajoute  toute dfinition de filtre prexistante, y
    compris la directive <code class="directive"><a href="../mod/core.html#setinputfilter">SetInputFilter</a></code>. Cette
    association est ajoute  toutes les autres dj en vigueur, et
    crase toute association prexistante pour la mme
    <var>extension</var>.</p>

    <p>Si plusieurs <var>filtres</var> sont spcifis, ils doivent tre
    spars par des points-virgules et inscrits dans l'ordre selon
    lequel ils devront traiter le contenu. L'argument <var>filtre</var>
    est insensible  la casse.</p>

    <p>L'argument <var>extension</var> est insensible  la casse et peut
    tre spcifi avec ou sans le point initial. Les noms de fichiers
    peuvent possder <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera compar  chacune d'entre
    elles.</p>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#removeinputfilter">RemoveInputFilter</a></code></li>
<li><code class="directive"><a href="../mod/core.html#setinputfilter">SetInputFilter</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="addlanguage" id="addlanguage">Directive</a> <a name="AddLanguage" id="AddLanguage">AddLanguage</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Associe l'extension de nom de fichier donne  la langue
spcifi</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddLanguage <var>symbole-langue</var> <var>extension</var>
[<var>extension</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">AddLanguage</code> permet d'associer
    l'extension de nom de fichier donne  la langue spcifie. Les
    fichiers dont l'extension correspond  la valeur
    de l'argument <var>extension</var> se voient attribuer la valeur de
    l'argument <var>symbole-langue</var> comme en-tte HTTP
    Content-Language en accord avec les identifiants de langues dfinis
    par la RFC 3066. Cette directive l'emporte sur toute association
    prexistante pour la mme <var>extension</var>.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">AddEncoding x-compress .Z
AddLanguage en .en
AddLanguage fr .fr</pre>
</div>

    <p>Avec cet exemple, le document <code>xxxx.en.Z</code> sera trait
    en tant que document compress de langue anglaise (idem pour le
    document <code>xxxx.Z.en</code>). Bien que la langue soit fournie au
    client, le navigateur n'utilise habituellement pas cette
    information. La directive <code class="directive">AddLanguage</code> est
    principalement utilise au cours de la <a href="../content-negotiation.html">ngociation de contenu</a>, o le
    serveur choisit d'envoyer un document parmi plusieurs documents
    possibles en fonction de la prfrence du client en matire de
    langue.</p>

    <p>Si une extension fait l'objet de plusieurs associations de
    langues, c'est la dernire qui sera utilise. Ainsi, dans le cas
    suivant,</p>

    <pre class="prettyprint lang-config">AddLanguage en .en
AddLanguage en-gb .en
AddLanguage en-us .en</pre>


    <p>les documents possdant l'extension <code>.en</code> seront
    traits en tant que documents de langue <code>en-us</code>.</p>

    <p>L'argument <var>extension</var> est insensible  la casse et peut
    tre spcifi avec ou sans le point initial. Les noms de fichiers
    peuvent possder <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera compar  chacune d'entre
    elles.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="module"><a href="../mod/mod_negotiation.html">mod_negotiation</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="addoutputfilter" id="addoutputfilter">Directive</a> <a name="AddOutputFilter" id="AddOutputFilter">AddOutputFilter</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Associe les extensions de noms de fichiers aux
filtres spcifis qui traiteront les rponses en provenance du
serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddOutputFilter <var>filtre</var>[;<var>filtre</var>...]
<var>extension</var> [<var>extension</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">AddOutputFilter</code> permet
    d'associer l'extension de nom de fichier dfinie par l'argument
    <var>extension</var> aux <a href="../filter.html">filtres</a> qui traiteront les rponses en
    provenance du serveur avant de les envoyer au client. Ces filtres
    s'ajoutent  tout filtre dfini par d'autres directives comme
    <code class="directive"><a href="../mod/core.html#setoutputfilter">SetOutputFilter</a></code> et <code class="directive"><a href="../mod/mod_filter.html#addoutputfilterbytype">AddOutputFilterByType</a></code>. Cette association
    est fusionne avec toute autre association en vigueur, et l'emporte
    sur toute association prexistante pour la mme
    <var>extension</var>.</p>

    <p>Avec l'exemple suivant, tous les fichiers <code>.shtml</code>
    seront traits en tant qu'inclusions ct serveur (SSI), et la
    sortie sera compresse  l'aide du module
    <code class="module"><a href="../mod/mod_deflate.html">mod_deflate</a></code>.</p>

    <pre class="prettyprint lang-config">AddOutputFilter INCLUDES;DEFLATE shtml</pre>


    <p>Si plusieurs <var>filtres</var> sont spcifis, ils doivent tre
    spars par des points-virgules et inscrits dans l'ordre selon
    lequel il devront traiter le contenu. L'argument <var>filtre</var>
    est insensible  la casse.</p>

    <p>L'argument <var>extension</var> est insensible  la casse et peut
    tre spcifi avec ou sans le point initial. Les noms de fichiers
    peuvent possder <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera compar  chacune d'entre
    elles.</p>

    <p>Notez que toute dfinition de filtres via la directive <code class="directive"><a href="#addoutputfilter">AddOutputFilter</a></code> remplace toutes les
    dfinitions prcdentes effectues via cette mme directive.</p>

    <pre class="prettyprint lang-config"># Filtre spcifi "DEFLATE"
AddOutputFilter DEFLATE shtml
&lt;Location "/foo"&gt;
  # Filtre spcifi "INCLUDES", remplace "DEFLATE"
  AddOutputFilter INCLUDES shtml
&lt;/Location&gt;
&lt;Location "/bar"&gt;
  # Filtre spcifi "INCLUDES;DEFLATE", remplace "DEFLATE"
  AddOutputFilter INCLUDES;DEFLATE shtml
&lt;/Location&gt;
&lt;Location "/bar/baz"&gt;
  # Filtre spcifi "BUFFER", remplace "INCLUDES;DEFLATE"
  AddOutputFilter BUFFER shtml
&lt;/Location&gt;
&lt;Location "/bar/baz/buz"&gt;
  # Pas de filtre spcifi, suppression de "BUFFER"
  RemoveOutputFilter shtml
&lt;/Location&gt;</pre>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#removeoutputfilter">RemoveOutputFilter</a></code></li>
<li><code class="directive"><a href="../mod/core.html#setoutputfilter">SetOutputFilter</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="addtype" id="addtype">Directive</a> <a name="AddType" id="AddType">AddType</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Associe les extensions de noms de fichiers au type de
contenu spcifi</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddType <var>type-mdium</var> <var>extension</var>
[<var>extension</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">AddType</code> permet d'associer les
    extensions de noms de fichiers donnes au type de contenu spcifi.
    <var>type-mdium</var> est le <a class="glossarylink" href="../glossary.html#media-type" title="voir glossaire">Type
    MIME</a>  utiliser pour les fichiers dont le nom possde
    l'extension <var>extension</var>. Cette association s'ajoute  toute
    autre association en vigueur, et l'emporte sur toute association
    prexistante pour la mme <var>extension</var>.</p>

    <div class="note">
      Plutt que d'diter directement le fichier <code class="directive"><a href="#typesconfig">TypesConfig</a></code>, il est recommand
      d'utiliser la directive <code class="directive">AddType</code> pour
      ajouter de nouveaux types de mdias.
    </div>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">AddType image/gif .gif</pre>
</div>

    <p>Ou, pour spcifier plusieurs extensions dans une seule directive
    :</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">AddType image/jpeg jpeg jpg jpe</pre>
</div>

    <p>L'argument <var>extension</var> est insensible  la casse et peut
    tre spcifi avec ou sans le point initial. Les noms de fichiers
    peuvent possder <a href="#multipleext">plusieurs extensions</a>, et
    l'argument <var>extension</var> sera compar  chacune d'entre
    elles.</p>

    <p>Il est possible d'obtenir un effet similaire  celui de la
    directive <code class="directive"><a href="../mod/mod_negotiation.html#languagepriority">LanguagePriority</a></code> du module
    <code class="module"><a href="../mod/mod_negotiation.html">mod_negotiation</a></code> en qualifiant un <var>type de
    mdia</var> avec <code>qs</code> :</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">AddType application/rss+xml;qs=0.8 .xml</pre>
</div>

    <p>Ceci peut s'avrer utile dans certaines situations, par exemple
    lorsqu'un client qui a ajout un en-tte <code>Accept: */*</code> 
    sa requte n'est pas en mesure de traiter le contenu renvoy par le
    serveur.</p>

    <p> la base, cette directive configure le type de contenu gnr
    pour les fichiers statiques servis  partir du systme de fichiers.
    Dans le cas des ressources autres que les fichiers statiques pour
    lesquelles le gnrateur de la rponse spcifie en gnral un
    Content-Type, cette directive n'a aucun effet.</p>

    <div class="note"><h3>Note</h3>
    <p>Si aucun gestionnaire n'est explicitement dfini pour une
    requte, le type de contenu spcifi sera aussi utilis comme nom du
    gestionnaire.</p>

    <p>Lorsqu'aucune directive comme <code class="directive"><a href="../mod/core.html#sethandler">SetHandler</a></code> ou
    <code class="directive">module="mod_mime"&gt;AddHandler</code> ne s'applique 
    une requte, le nom de gestionnaire interne normalement dfini
    par une de ces directives est en fait dfini par le type de contenu
    spcifi par la prsente directive.</p>
    <p>
    Pour des raisons historiques, certains modules tiers comme mod_php
    peuvent adopter ce type de comportement pour prendre en compte la
    requte concerne.
    </p>
    <p>Il est conseill d'viter les configurations qui reposent sur de
    tels types "synthtiques". En outre, les configurations qui
    limitent l'accs aux directives <code class="directive"><a href="../mod/core.html#sethandler">SetHandler</a></code> ou <code class="directive"><a href="#addhandler">AddHandler</a></code> doivent aussi limiter
    l'accs  la directive AddType.</p>
    </div>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/core.html#forcetype">ForceType</a></code></li>
<li><code class="module"><a href="../mod/mod_negotiation.html">mod_negotiation</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="defaultlanguage" id="defaultlanguage">Directive</a> <a name="DefaultLanguage" id="DefaultLanguage">DefaultLanguage</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit un symbole de langue par dfaut  affecter au champ
d'en-tte Content-Language pour toutes les ressources dans le contexte
courant auxquelles aucun symbole de langue n'a t
associ.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DefaultLanguage <var>symbole-langue</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">DefaultLanguage</code> permet
    d'indiquer  Apache que toutes les ressources du contexte courant
    (par exemple, toutes les ressources concernes par le conteneur
    <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code>
    courant) qui ne possdent pas d'extension de langue explicite
    (comme <code>.fr</code> ou <code>.de</code> tel que dfini par la
    directive <code class="directive"><a href="#addlanguage">AddLanguage</a></code>),
    verront leur en-tte HTTP Content-Language affect de la langue
    <var>symbole-langue</var>. Ceci permet de marquer des arborescences
    de rpertoires entires comme contenant des documents en franais,
    par exemple, sans avoir  renommer chaque fichier. Notez qu' la
    diffrence de l'utilisation des extensions pour spcifier des
    langues, <code class="directive">DefaultLanguage</code> ne permet de
    spcifier qu'une seule langue.</p>

    <p>Si aucune directive <code class="directive">DefaultLanguage</code> n'est
    en vigueur, et si un fichier ne possde pas d'extension configure
    par la directive <code class="directive"><a href="#addlanguage">AddLanguage</a></code>, aucun champ d'en-tte
    Content-Language ne sera gnr.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">DefaultLanguage en</pre>
</div>

<h3>Voir aussi</h3>
<ul>
<li><code class="module"><a href="../mod/mod_negotiation.html">mod_negotiation</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="modmimeusepathinfo" id="modmimeusepathinfo">Directive</a> <a name="ModMimeUsePathInfo" id="ModMimeUsePathInfo">ModMimeUsePathInfo</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Indique  <code class="module"><a href="../mod/mod_mime.html">mod_mime</a></code> de traiter les lments
de <code>path_info</code> en tant que parties du nom de
fichier</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ModMimeUsePathInfo On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ModMimeUsePathInfo Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">ModMimeUsePathInfo</code> permet de
    combiner le nom de fichier avec la partie <code>path_info</code> de
    l'URL pour appliquer les directives <code class="module"><a href="../mod/mod_mime.html">mod_mime</a></code>  la
    requte. La valeur par dfaut est <code>Off</code> - situation dans
    laquelle l'lment <code>path_info</code> est ignor.</p>

    <p>L'utilisation de cette directive est conseille si vous utilisez
    un systme de fichiers virtuel.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">ModMimeUsePathInfo On</pre>
</div>

    <p>Considrons une requte pour <code>/index.php/foo.shtml</code>,
    <code class="module"><a href="../mod/mod_mime.html">mod_mime</a></code> ne traitera pas la requte entrante comme
    <code>/index.php/foo.shtml</code> et les directives comme
    <code>AddOutputFilter INCLUDES .shtml</code> ajouteront le filtre
    <code>INCLUDES</code>  la requte. Si la directive
    <code class="directive">ModMimeUsePathInfo</code> n'est pas dfinie, le
    filtre <code>INCLUDES</code> ne sera pas ajout. Le fonctionnement
    sera identique dans le cas des chemins virtuels, tels que ceux
    dfinis par la directive <code class="directive">&lt;Location&gt;</code></p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/core.html#acceptpathinfo">AcceptPathInfo</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="multiviewsmatch" id="multiviewsmatch">Directive</a> <a name="MultiviewsMatch" id="MultiviewsMatch">MultiviewsMatch</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Les types de fichiers qui seront inclus lors d'une
recherche de correspondance de fichier avec les vues multiples
(MultiViews)</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MultiviewsMatch Any|NegotiatedOnly|Filters|Handlers
[Handlers|Filters]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>MultiviewsMatch NegotiatedOnly</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">MultiviewsMatch</code> permet trois
    comportements diffrents pour la fonctionnalit Multiviews du module
    <a href="mod_negotiation.html">mod_negotiation</a>. Les vues
    multiples permettent d'associer une requte pour un fichier, par
    exemple <code>index.html</code>,  toute extension ngocie
    s'ajoutant  la requte de base, par exemple
    <code>index.html.en</code>, <code>index.html.fr</code>, ou
    <code>index.html.gz</code>.</p>

    <p>L'option <code>NegotiatedOnly</code> implique que toute extension
    s'ajoutant au nom de base doit correspondre  une extension de
    <code class="module"><a href="../mod/mod_mime.html">mod_mime</a></code> reconnue pour la ngociation de contenu,
    par exemple Charset, Content-Type, Language, ou Encoding. C'est la
    valeur d'option par dfaut, et la contrainte la plus stricte
    dont les effets de bord inattendus sont les moins nombreux.</p>

    <p>Pour inclure des extensions associes avec des gestionnaires
    et/ou des filtres, dfinissez la directive
    <code class="directive">MultiviewsMatch</code> avec les mots-cls
    <code>Handlers</code>, <code>Filters</code>, ou les deux. Si tous
    les autres facteurs sont gaux, c'est le fichier de plus petite
    taille qui sera servi ; par exemple, si le choix doit s'oprer entre
    <code>index.html.cgi</code> de 500 octets et
    <code>index.html.pl</code> de 1000 octets, c'est le fichier
    <code>.cgi</code> qui l'emportera dans cet exemple. Les utilisateurs
    de fichiers <code>.asis</code> auront avantage  utiliser l'option
    Handler, si les fichiers <code>.asis</code> sont associs au
    gestionnaire <code>asis-handler</code>.</p>

    <p>Vous pouvez enfin autoriser l'association de toute extension avec
    l'option <code>Any</code>, mme si <code class="module"><a href="../mod/mod_mime.html">mod_mime</a></code> ne
    reconnat pas l'extension. Ceci
    peut conduire  des rsultats imprvisibles, comme l'envoi de
    fichiers .old ou .bak contrairement aux souhaits du webmaster.</p>

    <p>Par exemple, la configuration suivante va permettre l'inclusion
    des extensions associes aux gestionnaires et aux filtres dans les
    vues multiples, tout en excluant les fichiers de type inconnu :</p>

    <pre class="prettyprint lang-config">MultiviewsMatch Handlers Filters</pre>


    <p>L'utilisation de la directive
    <code class="directive">MultiviewsMatch</code> dans une section <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code> ou <code class="directive"><a href="../mod/core.html#locationmatch">&lt;LocationMatch&gt;</a></code> n'est pas
    permise.</p>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/core.html#options">Options</a></code></li>
<li><code class="module"><a href="../mod/mod_negotiation.html">mod_negotiation</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="removecharset" id="removecharset">Directive</a> <a name="RemoveCharset" id="RemoveCharset">RemoveCharset</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Supprime toute association de jeu de caractres pour un
ensemble d'extensions de noms de fichiers</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RemoveCharset <var>extension</var> [<var>extension</var>]
...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">RemoveCharset</code> permet de
    supprimer toute association de jeu de caractres pour les fichiers
    dont les noms possdent les extensions spcifies. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association hrite du rpertoire parent ou de la configuration du
    serveur pour un rpertoire particulier.</p>

    <p>L'argument <var>extension</var> est insensible  la casse et peut
    tre spcifi avec ou sans le point initial.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">RemoveCharset .html .shtml</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="removeencoding" id="removeencoding">Directive</a> <a name="RemoveEncoding" id="RemoveEncoding">RemoveEncoding</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Supprime toute association de codage de contenu pour un
ensemble d'extensions de noms de fichiers</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RemoveEncoding <var>extension</var> [<var>extension</var>]
...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">RemoveEncoding</code> permet de
    supprimer toute association de codage pour les fichiers dont les
    noms possdent les extensions spcifies. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association hrite du rpertoire parent ou de la configuration du
    serveur pour un rpertoire particulier. Voici un exemple
    d'utilisation de cette directive :</p>

    <div class="example"><h3>/foo/.htaccess:</h3><pre class="prettyprint lang-config">AddEncoding x-gzip .gz
AddType text/plain .asc
&lt;Files "*.gz.asc"&gt;
    RemoveEncoding .gz
&lt;/Files&gt;</pre>
</div>

    <p>Avec cette configuration, le fichier <code>foo.gz</code> sera
    marqu comme cod avec gzip, mais <code>foo.gz.asc</code> sera
    marqu comme fichier texte non cod.</p>

    <div class="note"><h3>Note</h3>
      <p>Les directives <code class="directive">RemoveEncoding</code> tant
      traites <em>aprs</em> toute directive <code class="directive"><a href="#addencoding">AddEncoding</a></code>, il est possible
      qu'elles annulent les effets de ces dernires si les deux
      apparaissent dans la configuration du mme rpertoire.</p>
    </div>

    <p>L'argument <var>extension</var> est insensible  la casse et peut
    tre spcifi avec ou sans le point initial.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="removehandler" id="removehandler">Directive</a> <a name="RemoveHandler" id="RemoveHandler">RemoveHandler</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Supprime toute association de gestionnaire  un ensemble
d'extensions de noms de fichiers</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RemoveHandler <var>extension</var> [<var>extension</var>]
...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">RemoveHandler</code> permet de
    supprimer toute association de gestionnaire  des fichiers dont le
    nom possde l'extension donne. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association hrite du rpertoire parent ou de la configuration du
    serveur pour un rpertoire particulier. Voici un exemple
    d'utilisation de cette directive :</p>

    <div class="example"><h3>/foo/.htaccess:</h3><pre class="prettyprint lang-config">AddHandler server-parsed .html</pre>
</div>

    <div class="example"><h3>/foo/bar/.htaccess:</h3><pre class="prettyprint lang-config">RemoveHandler .html</pre>
</div>

    <p>Avec cette dernire ligne, les fichiers <code>.html</code> du
    rpertoire <code>/foo/bar</code> seront traits en tant que fichiers
    normaux, au lieu d'tre traits en tant que candidats 
    l'interprtation (voir le module <code class="module"><a href="../mod/mod_include.html">mod_include</a></code>
    module).</p>

    <p>L'argument <var>extension</var> est insensible  la casse et peut
    tre spcifi avec ou sans le point initial.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="removeinputfilter" id="removeinputfilter">Directive</a> <a name="RemoveInputFilter" id="RemoveInputFilter">RemoveInputFilter</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Supprime toute association de filtre en entre  un
ensemble d'extensions de noms de fichiers</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RemoveInputFilter <var>extension</var> [<var>extension</var>]
...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">RemoveInputFilter</code> permet de
    supprimer toute association de <a href="../filter.html">filtre</a>
    en entre  des fichiers dont le nom possde l'extension donne.
    Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association hrite du rpertoire parent ou de la configuration du
    serveur pour un rpertoire particulier.</p>

    <p>L'argument <var>extension</var> est insensible  la casse et peut
    tre spcifi avec ou sans le point initial.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#addinputfilter">AddInputFilter</a></code></li>
<li><code class="directive"><a href="../mod/core.html#setinputfilter">SetInputFilter</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="removelanguage" id="removelanguage">Directive</a> <a name="RemoveLanguage" id="RemoveLanguage">RemoveLanguage</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Supprime toute association de langue  un ensemble
d'extensions de noms de fichiers</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RemoveLanguage <var>extension</var> [<var>extension</var>]
...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">RemoveLanguage</code> permet de
    supprimer toute association de langue  des fichiers dont le nom
    possde l'extension donne. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association hrite du rpertoire parent ou de la configuration du
    serveur pour un rpertoire particulier.</p>

    <p>L'argument <var>extension</var> est insensible  la casse et peut
    tre spcifi avec ou sans le point initial.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="removeoutputfilter" id="removeoutputfilter">Directive</a> <a name="RemoveOutputFilter" id="RemoveOutputFilter">RemoveOutputFilter</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Supprime toute association de filtre en sortie  un
ensemble d'extensions de noms de fichiers</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RemoveOutputFilter <var>extension</var> [<var>extension</var>]
...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">RemoveOutputFilter</code> permet de
    supprimer toute association de <a href="../filter.html">filtre</a>
    en sortie  des fichiers dont le nom possde l'extension donne. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association hrite du rpertoire parent ou de la configuration du
    serveur pour un rpertoire particulier.</p>

    <p>L'argument <var>extension</var> est insensible  la casse et peut
    tre spcifi avec ou sans le point initial.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">RemoveOutputFilter shtml</pre>
</div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#addoutputfilter">AddOutputFilter</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="removetype" id="removetype">Directive</a> <a name="RemoveType" id="RemoveType">RemoveType</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Supprime toute association de type de contenu  un ensemble
d'extensions de noms de fichiers</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RemoveType <var>extension</var> [<var>extension</var>]
...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">RemoveType</code> permet de
    supprimer toute association de <a class="glossarylink" href="../glossary.html#media-type" title="voir glossaire">type de
    mdium</a>  des fichiers dont le nom possde l'extension
    donne. Ceci permet, au
    sein des fichiers <code>.htaccess</code>, d'annuler toute
    association hrite du rpertoire parent ou de la configuration du
    serveur pour un rpertoire particulier. Voici un exemple
    d'utilisation de cette directive :</p>

    <div class="example"><h3>/foo/.htaccess:</h3><pre class="prettyprint lang-config">RemoveType .cgi</pre>
</div>

    <p>Cette ligne aura pour effet de supprimer tout traitement
    spcifique des fichiers <code>.cgi</code> dans le rpertoire
    <code>/foo/</code> et ses sous-rpertoires, et les rponses
    contenant ce type de fichier ne possderont pas de champ d'en-tte
    HTTP Content-Type.</p>

    <div class="note"><h3>Note</h3>
      <p>Les directives <code class="directive">RemoveType</code> sont traites
      <em>aprs</em> toutes les directives <code class="directive"><a href="#addtype">AddType</a></code>, et il est possible que les
      effets de ces dernires soient annuls si les deux types de
      directives sont prsents au sein de la configuration du mme
      rpertoire.</p>
    </div>

    <p>L'argument <var>extension</var> est insensible  la casse et peut
    tre spcifi avec ou sans le point initial.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="typesconfig" id="typesconfig">Directive</a> <a name="TypesConfig" id="TypesConfig">TypesConfig</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le chemin du fichier <code>mime.types</code></td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>TypesConfig <var>chemin-fichier</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>TypesConfig conf/mime.types</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_mime</td></tr>
</table>
    <p>La directive <code class="directive">TypesConfig</code> permet de dfinir
    le chemin du fichier de configuration des <a class="glossarylink" href="../glossary.html#media-type" title="voir glossaire">types de mdia</a>. L'argument
    <var>chemin-fichier</var> est un chemin relatif au rpertoire dfini
    par la directive <code class="directive"><a href="../mod/core.html#serverroot">ServerRoot</a></code>. Ce
    fichier contient la liste des associations par dfaut des extensions
    de noms de fichiers aux types de contenus. La plupart des
    administrateurs utilisent le fichier <code>mime.types</code> fourni
    par leur systme d'exploitation,
    qui associe les extensions de noms de fichiers courantes  la liste
    officielle des types de mdia enregistrs par l'IANA et maintenue 
    <a href="http://www.iana.org/assignments/media-types/index.html">http://www.iana.org/assignments/media-types/index.html</a>, ainsi
    qu'un grand nombre de types non officiels. Ce fichier permet de
    simplifier le fichier <code>httpd.conf</code> en fournissant la
    majorit des dfinitions de types de mdia, et ses dfinitions
    peuvent tre crases par des directives <code class="directive"><a href="#addtype">AddType</a></code>, selon les besoins. Il est
    dconseill de modifier le contenu du fichier
    <code>mime.types</code> car il peut tre remplac lors d'une mise 
    jour du serveur.</p>

    <p>Le fichier contient des lignes dont le format est identique 
    celui des arguments d'une directive <code class="directive"><a href="#addtype">AddType</a></code> :</p>

    <div class="example"><p><code>
      <var>type-mdium</var> [<var>extension</var>] ...
    </code></p></div>

    <p>Les extensions sont insensibles  la casse. Les lignes vides et
    les lignes commenant par un dise (<code>#</code>) sont
    ignores. Les lignes vides servent  complter le fichier
    mime.types. Apache httpd peut encore dterminer ces types via le
    module <code class="module"><a href="../mod/mod_mime_magic.html">mod_mime_magic</a></code>.</p>

    <div class="note">
      Merci de <strong>ne pas</strong> soumettre de requtes au Projet
      de Serveur HTTP Apache pour ajouter une entre dans le fichier
      <code>mime.types</code> fourni, sauf si :
      1) le type de mdium est dj enregistr  l'IANA
      2) et si l'extension est largement accepte et ne provoque pas de
      conflits d'extensions entre les diffrentes plate-formes. Les
      requtes du type <code>catgorie/x-sous-type</code> seront
      systmatiquement rejetes, ainsi que toute nouvelle extension de
      deux lettres, car elle ont de fortes chances d'entrer en conflit
      par la suite avec les inombrables langues prexistantes et les
      espaces de nommage des jeux de caractres.
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="module"><a href="../mod/mod_mime_magic.html">mod_mime_magic</a></code></li>
</ul>
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_mime.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_mime.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_mime.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_mime.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2016 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>