/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include <cairo.h>

#include <gegl.h>

#include "libgimpbase/gimpbase.h"
#include "libgimpcolor/gimpcolor.h"

#include "pdb-types.h"

#include "core/gimpcontext.h"
#include "core/gimpimage.h"
#include "core/gimplayer.h"
#include "core/gimpparamspecs.h"
#include "text/gimptext.h"
#include "text/gimptextlayer.h"

#include "gimppdb.h"
#include "gimppdberror.h"
#include "gimppdb-utils.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GValueArray *
text_layer_new_invoker (GimpProcedure      *procedure,
                        Gimp               *gimp,
                        GimpContext        *context,
                        GimpProgress       *progress,
                        const GValueArray  *args,
                        GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpImage *image;
  const gchar *text;
  const gchar *fontname;
  gdouble size;
  GimpUnit unit;
  GimpLayer *layer = NULL;

  image = gimp_value_get_image (&args->values[0], gimp);
  text = g_value_get_string (&args->values[1]);
  fontname = g_value_get_string (&args->values[2]);
  size = g_value_get_double (&args->values[3]);
  unit = g_value_get_int (&args->values[4]);

  if (success)
    {
      GimpText *gimp_text;
      GimpRGB   color;

      gimp_context_get_foreground (context, &color);

      gimp_text = g_object_new (GIMP_TYPE_TEXT,
                                "text",           text,
                                "font",           fontname,
                                "font-size",      size,
                                "font-size-unit", unit,
                                "color",          &color,
                                NULL);

      layer = gimp_text_layer_new (image, gimp_text);
      g_object_unref (gimp_text);

      if (! layer)
        {
          g_set_error (error, GIMP_PDB_ERROR, GIMP_PDB_ERROR_INVALID_ARGUMENT,
                       _("Failed to create text layer"));

          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    gimp_value_set_layer (&return_vals->values[1], layer);

  return return_vals;
}

static GValueArray *
text_layer_get_text_invoker (GimpProcedure      *procedure,
                             Gimp               *gimp,
                             GimpContext        *context,
                             GimpProgress       *progress,
                             const GValueArray  *args,
                             GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gchar *text = NULL;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, FALSE, error))
        {
          g_object_get (gimp_text_layer_get_text (GIMP_TEXT_LAYER (layer)),
                        "text", &text,
                        NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (&return_vals->values[1], text);

  return return_vals;
}

static GValueArray *
text_layer_set_text_invoker (GimpProcedure      *procedure,
                             Gimp               *gimp,
                             GimpContext        *context,
                             GimpProgress       *progress,
                             const GValueArray  *args,
                             GError            **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  const gchar *text;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  text = g_value_get_string (&args->values[1]);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, TRUE, error))
        {
          gimp_text_layer_set (GIMP_TEXT_LAYER (layer),
                               _("Set text layer attribute"),
                               "text", text,
                               NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
text_layer_get_markup_invoker (GimpProcedure      *procedure,
                               Gimp               *gimp,
                               GimpContext        *context,
                               GimpProgress       *progress,
                               const GValueArray  *args,
                               GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gchar *markup = NULL;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, FALSE, error))
        {
          g_object_get (gimp_text_layer_get_text (GIMP_TEXT_LAYER (layer)),
                        "markup", &markup,
                        NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (&return_vals->values[1], markup);

  return return_vals;
}

static GValueArray *
text_layer_get_font_invoker (GimpProcedure      *procedure,
                             Gimp               *gimp,
                             GimpContext        *context,
                             GimpProgress       *progress,
                             const GValueArray  *args,
                             GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gchar *font = NULL;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, FALSE, error))
        {
          g_object_get (gimp_text_layer_get_text (GIMP_TEXT_LAYER (layer)),
                        "font", &font,
                        NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (&return_vals->values[1], font);

  return return_vals;
}

static GValueArray *
text_layer_set_font_invoker (GimpProcedure      *procedure,
                             Gimp               *gimp,
                             GimpContext        *context,
                             GimpProgress       *progress,
                             const GValueArray  *args,
                             GError            **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  const gchar *font;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  font = g_value_get_string (&args->values[1]);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, TRUE, error))
        {
          gimp_text_layer_set (GIMP_TEXT_LAYER (layer),
                               _("Set text layer attribute"),
                               "font", font,
                               NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
text_layer_get_font_size_invoker (GimpProcedure      *procedure,
                                  Gimp               *gimp,
                                  GimpContext        *context,
                                  GimpProgress       *progress,
                                  const GValueArray  *args,
                                  GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gdouble font_size = 0.0;
  GimpUnit unit = 0;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, FALSE, error))
        {
          g_object_get (gimp_text_layer_get_text (GIMP_TEXT_LAYER (layer)),
                        "font-size",      &font_size,
                        "font-size-unit", &unit,
                        NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_double (&return_vals->values[1], font_size);
      g_value_set_int (&return_vals->values[2], unit);
    }

  return return_vals;
}

static GValueArray *
text_layer_set_font_size_invoker (GimpProcedure      *procedure,
                                  Gimp               *gimp,
                                  GimpContext        *context,
                                  GimpProgress       *progress,
                                  const GValueArray  *args,
                                  GError            **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gdouble font_size;
  GimpUnit unit;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  font_size = g_value_get_double (&args->values[1]);
  unit = g_value_get_int (&args->values[2]);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, TRUE, error))
        {
          gimp_text_layer_set (GIMP_TEXT_LAYER (layer),
                               _("Set text layer attribute"),
                               "font-size-unit", unit,
                               "font-size",      font_size,
                               NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
text_layer_get_antialias_invoker (GimpProcedure      *procedure,
                                  Gimp               *gimp,
                                  GimpContext        *context,
                                  GimpProgress       *progress,
                                  const GValueArray  *args,
                                  GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gboolean antialias = FALSE;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, FALSE, error))
        {
          g_object_get (gimp_text_layer_get_text (GIMP_TEXT_LAYER (layer)),
                        "antialias", &antialias,
                        NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (&return_vals->values[1], antialias);

  return return_vals;
}

static GValueArray *
text_layer_set_antialias_invoker (GimpProcedure      *procedure,
                                  Gimp               *gimp,
                                  GimpContext        *context,
                                  GimpProgress       *progress,
                                  const GValueArray  *args,
                                  GError            **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gboolean antialias;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  antialias = g_value_get_boolean (&args->values[1]);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, TRUE, error))
        {
          gimp_text_layer_set (GIMP_TEXT_LAYER (layer),
                               _("Set text layer attribute"),
                               "antialias", antialias,
                               NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
text_layer_get_hint_style_invoker (GimpProcedure      *procedure,
                                   Gimp               *gimp,
                                   GimpContext        *context,
                                   GimpProgress       *progress,
                                   const GValueArray  *args,
                                   GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gint32 style = 0;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, FALSE, error))
        {
          g_object_get (gimp_text_layer_get_text (GIMP_TEXT_LAYER (layer)),
                        "hint-style", &style,
                        NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_enum (&return_vals->values[1], style);

  return return_vals;
}

static GValueArray *
text_layer_set_hint_style_invoker (GimpProcedure      *procedure,
                                   Gimp               *gimp,
                                   GimpContext        *context,
                                   GimpProgress       *progress,
                                   const GValueArray  *args,
                                   GError            **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gint32 style;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  style = g_value_get_enum (&args->values[1]);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, TRUE, error))
        {
          gimp_text_layer_set (GIMP_TEXT_LAYER (layer),
                               _("Set text layer attribute"),
                               "hint-style", style,
                               NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
text_layer_get_kerning_invoker (GimpProcedure      *procedure,
                                Gimp               *gimp,
                                GimpContext        *context,
                                GimpProgress       *progress,
                                const GValueArray  *args,
                                GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gboolean kerning = FALSE;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, FALSE, error))
        {
          g_object_get (gimp_text_layer_get_text (GIMP_TEXT_LAYER (layer)),
                        "kerning", &kerning,
                        NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (&return_vals->values[1], kerning);

  return return_vals;
}

static GValueArray *
text_layer_set_kerning_invoker (GimpProcedure      *procedure,
                                Gimp               *gimp,
                                GimpContext        *context,
                                GimpProgress       *progress,
                                const GValueArray  *args,
                                GError            **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gboolean kerning;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  kerning = g_value_get_boolean (&args->values[1]);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, TRUE, error))
        {
          gimp_text_layer_set (GIMP_TEXT_LAYER (layer),
                               _("Set text layer attribute"),
                               "kerning", kerning,
                               NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
text_layer_get_language_invoker (GimpProcedure      *procedure,
                                 Gimp               *gimp,
                                 GimpContext        *context,
                                 GimpProgress       *progress,
                                 const GValueArray  *args,
                                 GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gchar *language = NULL;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, FALSE, error))
        {
          g_object_get (gimp_text_layer_get_text (GIMP_TEXT_LAYER (layer)),
                        "language", &language,
                        NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (&return_vals->values[1], language);

  return return_vals;
}

static GValueArray *
text_layer_set_language_invoker (GimpProcedure      *procedure,
                                 Gimp               *gimp,
                                 GimpContext        *context,
                                 GimpProgress       *progress,
                                 const GValueArray  *args,
                                 GError            **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  const gchar *language;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  language = g_value_get_string (&args->values[1]);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, TRUE, error))
        {
          gimp_text_layer_set (GIMP_TEXT_LAYER (layer),
                               _("Set text layer attribute"),
                               "language", language,
                               NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
text_layer_get_base_direction_invoker (GimpProcedure      *procedure,
                                       Gimp               *gimp,
                                       GimpContext        *context,
                                       GimpProgress       *progress,
                                       const GValueArray  *args,
                                       GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gint32 direction = 0;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, FALSE, error))
        {
          g_object_get (gimp_text_layer_get_text (GIMP_TEXT_LAYER (layer)),
                        "base-direction", &direction,
                        NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_enum (&return_vals->values[1], direction);

  return return_vals;
}

static GValueArray *
text_layer_set_base_direction_invoker (GimpProcedure      *procedure,
                                       Gimp               *gimp,
                                       GimpContext        *context,
                                       GimpProgress       *progress,
                                       const GValueArray  *args,
                                       GError            **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gint32 direction;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  direction = g_value_get_enum (&args->values[1]);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, TRUE, error))
        {
          gimp_text_layer_set (GIMP_TEXT_LAYER (layer),
                               _("Set text layer attribute"),
                               "base-direction", direction,
                               NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
text_layer_get_justification_invoker (GimpProcedure      *procedure,
                                      Gimp               *gimp,
                                      GimpContext        *context,
                                      GimpProgress       *progress,
                                      const GValueArray  *args,
                                      GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gint32 justify = 0;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, FALSE, error))
        {
          g_object_get (gimp_text_layer_get_text (GIMP_TEXT_LAYER (layer)),
                        "justify", &justify,
                        NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_enum (&return_vals->values[1], justify);

  return return_vals;
}

static GValueArray *
text_layer_set_justification_invoker (GimpProcedure      *procedure,
                                      Gimp               *gimp,
                                      GimpContext        *context,
                                      GimpProgress       *progress,
                                      const GValueArray  *args,
                                      GError            **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gint32 justify;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  justify = g_value_get_enum (&args->values[1]);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, TRUE, error))
        {
          gimp_text_layer_set (GIMP_TEXT_LAYER (layer),
                               _("Set text layer attribute"),
                               "justify", justify,
                               NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
text_layer_get_color_invoker (GimpProcedure      *procedure,
                              Gimp               *gimp,
                              GimpContext        *context,
                              GimpProgress       *progress,
                              const GValueArray  *args,
                              GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  GimpRGB color = { 0.0, 0.0, 0.0, 1.0 };

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, FALSE, error))
        {
          color = gimp_text_layer_get_text (GIMP_TEXT_LAYER (layer))->color;
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    gimp_value_set_rgb (&return_vals->values[1], &color);

  return return_vals;
}

static GValueArray *
text_layer_set_color_invoker (GimpProcedure      *procedure,
                              Gimp               *gimp,
                              GimpContext        *context,
                              GimpProgress       *progress,
                              const GValueArray  *args,
                              GError            **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  GimpRGB color;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  gimp_value_get_rgb (&args->values[1], &color);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, TRUE, error))
        {
          gimp_text_layer_set (GIMP_TEXT_LAYER (layer),
                               _("Set text layer attribute"),
                               "color", &color,
                               NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
text_layer_get_indent_invoker (GimpProcedure      *procedure,
                               Gimp               *gimp,
                               GimpContext        *context,
                               GimpProgress       *progress,
                               const GValueArray  *args,
                               GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gdouble indent = 0.0;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, FALSE, error))
        {
          g_object_get (gimp_text_layer_get_text (GIMP_TEXT_LAYER (layer)),
                        "indent", &indent,
                        NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (&return_vals->values[1], indent);

  return return_vals;
}

static GValueArray *
text_layer_set_indent_invoker (GimpProcedure      *procedure,
                               Gimp               *gimp,
                               GimpContext        *context,
                               GimpProgress       *progress,
                               const GValueArray  *args,
                               GError            **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gdouble indent;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  indent = g_value_get_double (&args->values[1]);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, TRUE, error))
        {
          gimp_text_layer_set (GIMP_TEXT_LAYER (layer),
                               _("Set text layer attribute"),
                               "indent", indent,
                               NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
text_layer_get_line_spacing_invoker (GimpProcedure      *procedure,
                                     Gimp               *gimp,
                                     GimpContext        *context,
                                     GimpProgress       *progress,
                                     const GValueArray  *args,
                                     GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gdouble line_spacing = 0.0;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, FALSE, error))
        {
          g_object_get (gimp_text_layer_get_text (GIMP_TEXT_LAYER (layer)),
                        "line-spacing", &line_spacing,
                        NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (&return_vals->values[1], line_spacing);

  return return_vals;
}

static GValueArray *
text_layer_set_line_spacing_invoker (GimpProcedure      *procedure,
                                     Gimp               *gimp,
                                     GimpContext        *context,
                                     GimpProgress       *progress,
                                     const GValueArray  *args,
                                     GError            **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gdouble line_spacing;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  line_spacing = g_value_get_double (&args->values[1]);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, TRUE, error))
        {
          gimp_text_layer_set (GIMP_TEXT_LAYER (layer),
                               _("Set text layer attribute"),
                               "line-spacing", line_spacing,
                               NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
text_layer_get_letter_spacing_invoker (GimpProcedure      *procedure,
                                       Gimp               *gimp,
                                       GimpContext        *context,
                                       GimpProgress       *progress,
                                       const GValueArray  *args,
                                       GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gdouble letter_spacing = 0.0;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, FALSE, error))
        {
          g_object_get (gimp_text_layer_get_text (GIMP_TEXT_LAYER (layer)),
                        "letter-spacing", &letter_spacing,
                        NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (&return_vals->values[1], letter_spacing);

  return return_vals;
}

static GValueArray *
text_layer_set_letter_spacing_invoker (GimpProcedure      *procedure,
                                       Gimp               *gimp,
                                       GimpContext        *context,
                                       GimpProgress       *progress,
                                       const GValueArray  *args,
                                       GError            **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gdouble letter_spacing;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  letter_spacing = g_value_get_double (&args->values[1]);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, TRUE, error))
        {
          gimp_text_layer_set (GIMP_TEXT_LAYER (layer),
                               _("Set text layer attribute"),
                               "letter-spacing", letter_spacing,
                               NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
text_layer_resize_invoker (GimpProcedure      *procedure,
                           Gimp               *gimp,
                           GimpContext        *context,
                           GimpProgress       *progress,
                           const GValueArray  *args,
                           GError            **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gdouble width;
  gdouble height;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  width = g_value_get_double (&args->values[1]);
  height = g_value_get_double (&args->values[2]);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, TRUE, error))
        {
          GimpText *text = gimp_text_layer_get_text (GIMP_TEXT_LAYER (layer));
          gdouble   xres, yres;

          gimp_image_get_resolution (gimp_item_get_image (GIMP_ITEM (layer)),
                                     &xres, &yres);

          gimp_text_layer_set (GIMP_TEXT_LAYER (layer),
                               _("Set text layer attribute"),
                               "box-mode",   GIMP_TEXT_BOX_FIXED,
                               "box-width",  gimp_pixels_to_units (width,
                                                                   text->box_unit,
                                                                   xres),
                               "box-height", gimp_pixels_to_units (height,
                                                                   text->box_unit,
                                                                   yres),
                               NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
text_layer_get_hinting_invoker (GimpProcedure      *procedure,
                                Gimp               *gimp,
                                GimpContext        *context,
                                GimpProgress       *progress,
                                const GValueArray  *args,
                                GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gboolean hinting = FALSE;
  gboolean autohint = FALSE;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, FALSE, error))
        {
          g_object_get (gimp_text_layer_get_text (GIMP_TEXT_LAYER (layer)),
                        "hinting", &hinting,
                        NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_boolean (&return_vals->values[1], hinting);
      g_value_set_boolean (&return_vals->values[2], autohint);
    }

  return return_vals;
}

static GValueArray *
text_layer_set_hinting_invoker (GimpProcedure      *procedure,
                                Gimp               *gimp,
                                GimpContext        *context,
                                GimpProgress       *progress,
                                const GValueArray  *args,
                                GError            **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gboolean hinting;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  hinting = g_value_get_boolean (&args->values[1]);

  if (success)
    {
      if (gimp_pdb_layer_is_text_layer (layer, TRUE, error))
        {
          gimp_text_layer_set (GIMP_TEXT_LAYER (layer),
                               _("Set text layer attribute"),
                               "hinting", hinting,
                               NULL);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_text_layer_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-text-layer-new
   */
  procedure = gimp_procedure_new (text_layer_new_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-new");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-new",
                                     "Creates a new text layer.",
                                     "This procedure creates a new text layer. The arguments are kept as simple as necessary for the normal case. All text attributes, however, can be modified with the appropriate gimp_text_layer_set_*() procedures. The new layer still needs to be added to the image, as this is not automatic. Add the new layer using 'gimp-image-insert-layer'.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("text",
                                                       "text",
                                                       "The text to generate (in UTF-8 encoding)",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("fontname",
                                                       "fontname",
                                                       "The name of the font",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("size",
                                                    "size",
                                                    "The size of text in either pixels or points",
                                                    0.0, 8192.0, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_unit ("unit",
                                                     "unit",
                                                     "The units of specified size",
                                                     TRUE,
                                                     FALSE,
                                                     GIMP_UNIT_PIXEL,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_layer_id ("layer",
                                                             "layer",
                                                             "The new text layer.",
                                                             pdb->gimp, FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-text
   */
  procedure = gimp_procedure_new (text_layer_get_text_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-text");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-get-text",
                                     "Get the text from a text layer as string.",
                                     "This procedure returns the text from a text layer as a string.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("text",
                                                           "text",
                                                           "The text from the specified text layer.",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-text
   */
  procedure = gimp_procedure_new (text_layer_set_text_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-text");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-set-text",
                                     "Set the text of a text layer.",
                                     "This procedure changes the text of a text layer.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("text",
                                                       "text",
                                                       "The new text to set",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-markup
   */
  procedure = gimp_procedure_new (text_layer_get_markup_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-markup");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-get-markup",
                                     "Get the markup from a text layer as string.",
                                     "This procedure returns the markup of the styles from a text layer. The markup will be in the form of Pango's markup - See http://www.pango.org/ for more information about Pango and its markup. Note: Setting the markup of a text layer using Pango's markup is not supported for now.",
                                     "Barak Itkin <lightningismyname@gmail.com>",
                                     "Barak Itkin",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("markup",
                                                           "markup",
                                                           "The markup which represents the style of the specified text layer.",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-font
   */
  procedure = gimp_procedure_new (text_layer_get_font_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-font");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-get-font",
                                     "Get the font from a text layer as string.",
                                     "This procedure returns the name of the font from a text layer.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("font",
                                                           "font",
                                                           "The font which is used in the specified text layer.",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-font
   */
  procedure = gimp_procedure_new (text_layer_set_font_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-font");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-set-font",
                                     "Set the font of a text layer.",
                                     "This procedure modifies the font used in the specified text layer.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("font",
                                                       "font",
                                                       "The new font to use",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-font-size
   */
  procedure = gimp_procedure_new (text_layer_get_font_size_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-font-size");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-get-font-size",
                                     "Get the font size from a text layer.",
                                     "This procedure returns the size of the font which is used in a text layer. You will receive the size as a float 'font-size' in 'unit' units.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("font-size",
                                                        "font size",
                                                        "The font size",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_unit ("unit",
                                                         "unit",
                                                         "The unit used for the font size",
                                                         TRUE,
                                                         FALSE,
                                                         GIMP_UNIT_PIXEL,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-font-size
   */
  procedure = gimp_procedure_new (text_layer_set_font_size_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-font-size");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-set-font-size",
                                     "Set the font size.",
                                     "This procedure changes the font size of a text layer. The size of your font will be a double 'font-size' of 'unit' units.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("font-size",
                                                    "font size",
                                                    "The font size",
                                                    0.0, 8192.0, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_unit ("unit",
                                                     "unit",
                                                     "The unit to use for the font size",
                                                     TRUE,
                                                     FALSE,
                                                     GIMP_UNIT_PIXEL,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-antialias
   */
  procedure = gimp_procedure_new (text_layer_get_antialias_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-antialias");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-get-antialias",
                                     "Check if antialiasing is used in the text layer.",
                                     "This procedure checks if antialiasing is enabled in the specified text layer.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("antialias",
                                                         "antialias",
                                                         "A flag which is true if antialiasing is used for rendering the font in the text layer.",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-antialias
   */
  procedure = gimp_procedure_new (text_layer_set_antialias_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-antialias");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-set-antialias",
                                     "Enable/disable anti-aliasing in a text layer.",
                                     "This procedure enables or disables anti-aliasing of the text in a text layer.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("antialias",
                                                     "antialias",
                                                     "Enable/disable antialiasing of the text",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-hint-style
   */
  procedure = gimp_procedure_new (text_layer_get_hint_style_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-hint-style");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-get-hint-style",
                                     "Get information about hinting in the specified text layer.",
                                     "This procedure provides information about the hinting that is being used in a text layer. Hinting can be optimized for fidelity or contrast or it can be turned entirely off.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("style",
                                                      "style",
                                                      "The hint style used for font outlines",
                                                      GIMP_TYPE_TEXT_HINT_STYLE,
                                                      GIMP_TEXT_HINT_STYLE_NONE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-hint-style
   */
  procedure = gimp_procedure_new (text_layer_set_hint_style_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-hint-style");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-set-hint-style",
                                     "Control how font outlines are hinted in a text layer.",
                                     "This procedure sets the hint style for font outlines in a text layer. This controls whether to fit font outlines to the pixel grid, and if so, whether to optimize for fidelity or contrast.",
                                     "Sven Neumann <sven@gimp.org>",
                                     "Sven Neumann",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("style",
                                                  "style",
                                                  "The new hint style",
                                                  GIMP_TYPE_TEXT_HINT_STYLE,
                                                  GIMP_TEXT_HINT_STYLE_NONE,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-kerning
   */
  procedure = gimp_procedure_new (text_layer_get_kerning_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-kerning");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-get-kerning",
                                     "Check if kerning is used in the text layer.",
                                     "This procedure checks if kerning is enabled in the specified text layer.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("kerning",
                                                         "kerning",
                                                         "A flag which is true if kerning is used in the text layer.",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-kerning
   */
  procedure = gimp_procedure_new (text_layer_set_kerning_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-kerning");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-set-kerning",
                                     "Enable/disable kerning in a text layer.",
                                     "This procedure enables or disables kerning in a text layer.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("kerning",
                                                     "kerning",
                                                     "Enable/disable kerning in the text",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-language
   */
  procedure = gimp_procedure_new (text_layer_get_language_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-language");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-get-language",
                                     "Get the language used in the text layer.",
                                     "This procedure returns the language string which is set for the text in the text layer.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer.",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("language",
                                                           "language",
                                                           "The language used in the text layer.",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-language
   */
  procedure = gimp_procedure_new (text_layer_set_language_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-language");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-set-language",
                                     "Set the language of the text layer.",
                                     "This procedure sets the language of the text in text layer. For some scripts the language has an influence of how the text is rendered.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("language",
                                                       "language",
                                                       "The new language to use for the text layer",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-base-direction
   */
  procedure = gimp_procedure_new (text_layer_get_base_direction_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-base-direction");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-get-base-direction",
                                     "Get the base direction used for rendering the text layer.",
                                     "This procedure returns the base direction used for rendering the text in the text layer",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer.",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("direction",
                                                      "direction",
                                                      "The based direction used for the text layer.",
                                                      GIMP_TYPE_TEXT_DIRECTION,
                                                      GIMP_TEXT_DIRECTION_LTR,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-base-direction
   */
  procedure = gimp_procedure_new (text_layer_set_base_direction_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-base-direction");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-set-base-direction",
                                     "Set the base direction in the text layer.",
                                     "This procedure sets the base direction used in applying the Unicode bidirectional algorithm when rendering the text.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("direction",
                                                  "direction",
                                                  "The base direction of the text.",
                                                  GIMP_TYPE_TEXT_DIRECTION,
                                                  GIMP_TEXT_DIRECTION_LTR,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-justification
   */
  procedure = gimp_procedure_new (text_layer_get_justification_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-justification");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-get-justification",
                                     "Get the text justification information of the text layer.",
                                     "This procedure returns the alignment of the lines in the text layer relative to each other.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer.",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("justify",
                                                      "justify",
                                                      "The justification used in the text layer.",
                                                      GIMP_TYPE_TEXT_JUSTIFICATION,
                                                      GIMP_TEXT_JUSTIFY_LEFT,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-justification
   */
  procedure = gimp_procedure_new (text_layer_set_justification_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-justification");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-set-justification",
                                     "Set the justification of the text in a text layer.",
                                     "This procedure sets the alignment of the lines in the text layer relative to each other.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("justify",
                                                  "justify",
                                                  "The justification for your text.",
                                                  GIMP_TYPE_TEXT_JUSTIFICATION,
                                                  GIMP_TEXT_JUSTIFY_LEFT,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-color
   */
  procedure = gimp_procedure_new (text_layer_get_color_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-color");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-get-color",
                                     "Get the color of the text in a text layer.",
                                     "This procedure returns the color of the text in a text layer.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer.",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_rgb ("color",
                                                        "color",
                                                        "The color of the text.",
                                                        FALSE,
                                                        NULL,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-color
   */
  procedure = gimp_procedure_new (text_layer_set_color_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-color");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-set-color",
                                     "Set the color of the text in the text layer.",
                                     "This procedure sets the text color in the text layer 'layer'.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_rgb ("color",
                                                    "color",
                                                    "The color to use for the text",
                                                    FALSE,
                                                    NULL,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-indent
   */
  procedure = gimp_procedure_new (text_layer_get_indent_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-indent");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-get-indent",
                                     "Get the line indentation of text layer.",
                                     "This procedure returns the indentation of the first line in a text layer.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer.",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("indent",
                                                        "indent",
                                                        "The indentation value of the first line.",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-indent
   */
  procedure = gimp_procedure_new (text_layer_set_indent_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-indent");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-set-indent",
                                     "Set the indentation of the first line in a text layer.",
                                     "This procedure sets the indentation of the first line in the text layer.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("indent",
                                                    "indent",
                                                    "The indentation for the first line.",
                                                    -8192.0, 8192.0, -8192.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-line-spacing
   */
  procedure = gimp_procedure_new (text_layer_get_line_spacing_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-line-spacing");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-get-line-spacing",
                                     "Get the spacing between lines of text.",
                                     "This procedure returns the line-spacing between lines of text in a text layer.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer.",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("line-spacing",
                                                        "line spacing",
                                                        "The line-spacing value.",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-line-spacing
   */
  procedure = gimp_procedure_new (text_layer_set_line_spacing_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-line-spacing");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-set-line-spacing",
                                     "Adjust the line spacing in a text layer.",
                                     "This procedure sets the additional spacing used between lines a text layer.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("line-spacing",
                                                    "line spacing",
                                                    "The additional line spacing to use.",
                                                    -8192.0, 8192.0, -8192.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-letter-spacing
   */
  procedure = gimp_procedure_new (text_layer_get_letter_spacing_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-letter-spacing");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-get-letter-spacing",
                                     "Get the letter spacing used in a text layer.",
                                     "This procedure returns the additional spacing between the single glyps in a text layer.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer.",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("letter-spacing",
                                                        "letter spacing",
                                                        "The letter-spacing value.",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-letter-spacing
   */
  procedure = gimp_procedure_new (text_layer_set_letter_spacing_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-letter-spacing");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-set-letter-spacing",
                                     "Adjust the letter spacing in a text layer.",
                                     "This procedure sets the additional spacing between the single glyphs in a text layer.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("letter-spacing",
                                                    "letter spacing",
                                                    "The additional letter spacing to use.",
                                                    -8192.0, 8192.0, -8192.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-resize
   */
  procedure = gimp_procedure_new (text_layer_resize_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-resize");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-resize",
                                     "Resize the box of a text layer.",
                                     "This procedure changes the width and height of a text layer while keeping it as a text layer and not converting it to a bitmap like 'gimp-layer-resize' would do.",
                                     "Barak Itkin <lightningismyname@gmail.com>",
                                     "Barak Itkin",
                                     "2009",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("width",
                                                    "width",
                                                    "The new box width in pixels",
                                                    0.0, GIMP_MAX_IMAGE_SIZE, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("height",
                                                    "height",
                                                    "The new box height in pixels",
                                                    0.0, GIMP_MAX_IMAGE_SIZE, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-hinting
   */
  procedure = gimp_procedure_new (text_layer_get_hinting_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-hinting");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-get-hinting",
                                     "Deprecated: Use 'gimp-text-layer-get-hint-style' instead.",
                                     "Deprecated: Use 'gimp-text-layer-get-hint-style' instead.",
                                     "",
                                     "",
                                     "",
                                     "gimp-text-layer-get-hint-style");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("hinting",
                                                         "hinting",
                                                         "A flag which is true if hinting is used on the font.",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("autohint",
                                                         "autohint",
                                                         "A flag which is true if the text layer is forced to use the autohinter from FreeType.",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-hinting
   */
  procedure = gimp_procedure_new (text_layer_set_hinting_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-hinting");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-text-layer-set-hinting",
                                     "Enable/disable the use of hinting in a text layer.",
                                     "This procedure enables or disables hinting on the text of a text layer. If you enable 'auto-hint', FreeType\'s automatic hinter will be used and hinting information from the font will be ignored.",
                                     "Marcus Heese <heese@cip.ifi.lmu.de>",
                                     "Marcus Heese",
                                     "2008",
                                     "gimp-text-layer-set-hint-style");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The text layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("hinting",
                                                     "hinting",
                                                     "Enable/disable the use of hinting on the text",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("autohint",
                                                     "autohint",
                                                     "Force the use of the autohinter provided through FreeType",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
