/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Instrumentation;
import android.view.View;
import android.widget.EditText;
import com.jayway.android.robotium.solo.Clicker;
import junit.framework.Assert;

class TextEnterer {
    private final Instrumentation inst;
    private final Clicker clicker;

    public TextEnterer(Instrumentation inst, Clicker clicker) {
        this.inst = inst;
        this.clicker = clicker;
    }

    public void setEditText(final EditText editText, final String text) {
        if (editText != null) {
            final String previousText = editText.getText().toString();
            if (!editText.isEnabled()) {
                Assert.assertTrue((String)"Edit text is not enabled!", (boolean)false);
            }
            this.inst.runOnMainSync(new Runnable(){

                public void run() {
                    editText.setInputType(0);
                    editText.performClick();
                    if (text.equals("")) {
                        editText.setText((CharSequence)text);
                    } else {
                        editText.setText((CharSequence)(previousText + text));
                        editText.setCursorVisible(false);
                    }
                }
            });
        }
    }

    public void typeText(final EditText editText, String text) {
        if (editText != null) {
            this.inst.runOnMainSync(new Runnable(){

                public void run() {
                    editText.setInputType(0);
                }
            });
            this.clicker.clickOnScreen((View)editText, false, 0);
            this.inst.sendStringSync(text);
        }
    }
}

