.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH xsetwacom __appmansuffix__ __vendorversion__
.SH NAME
.LP
xsetwacom \- commandline utility to query and modify __drivername__ driver settings.
.SH "SYNOPSIS"
.LP
xsetwacom [options] command [device_name] [parameter] [value]

.SH "DESCRIPTION"
.LP
This program queries or changes properties on the devices loaded by the
__drivername__ driver. The modification of properties happens at runtime
and is not persistent through X server restarts.
.SH "GENERAL OPTIONS"
.TP
\fB-d, --display\fR display_name
Connect to the X server specified in display_name; see X(__miscmansuffix__).
.TP
\fB-h, --help\fR
Prints a short help.
.TP
\fB-v, --verbose\fR
Enable verbose output, useful for debugging.
.TP
\fB-V, --version\fR
Display version number and exit.

.SH "COMMANDS"
.LP
Allowed commands are
.B list,
.B get,
and
.B set.
The command may be specified with our without one or two preceding
dashes, i.e.
.B --list
is equivalent to
.B -list
and
.B list.

.SS "LIST COMMANDS"
.TP
\fBlist\fR devices
List known devices. Only input devices managed by the __drivername__
driver are listed.
.TP
\fBlist\fR parameters
List known parameters. List all parameters suitable for the
.B get
or the
.B set
command. Note that not all parameters are available on all device types.
.TP
\fBlist\fR modifiers
List the available list of modifiers to be used when setting key or button
actions.

.SS "GET COMMANDS"
.TP
\fBget\fR device_name parameter
Get the current settings for the parameter on the given device. Note that
not all parameters are available on all device types. The special parameter
name "all" may be provided to display all current settings on the device.
.TP
By default, options are printed on the commandline in the respective format. The output format may be altered with one of the following options:
.TP
\fB-s, --shell\fR
Display the output in shell format, i.e. as shell commands to xsetwacom to
reproduce the same parameter.
.TP
\fB-x, --xconf\fR
Display the output in xorg.conf format, i.e. as option lines that may be
added to the InputDevice section in the xorg.conf.

.SS "SET COMMANDS"
.TP
\fBset\fR device_name parameter value
Set the parameter value on the given device to the value provided. Note that
not all parameters are writable, some are read-only and result in an error
when trying to be modified.

.SH "PARAMETERS"
.TP
\fBArea\fR x1 y1 x2 y2
Specify the tablet input area in device coordinates in the form top left
x/y and bottom right x/y. Top left and bottom right are defined in the
device's native orientation, regardless of the actual rotation currently
applied. Input outside of these coordinates will be clipped
to the edges of the area defined.
.TP
\fBButton\fR button-number [mapping]
Get or set the specified button. The mapping may be a button number to map
the physical button to. e.g. a mapping of button 1 to 3 means
a button 1 press will be interpreted as right click. Alternatively, a
mapping in the form of "key +a +shift b -shift -a" converts the button into a series
of keystrokes, in this example "press a, press shift, press and release b,
release shift, release a". Such key mappings need to be reapplied whenever
the keyboard layout changes.
.TP
\fBMapToOutput\fR output
Map the tablet's input area to the given output (e.g. "VGA1"). The output
must specify one of those available through the XRandR extension. A list of
outputs may be obtained with the xrandr tool. The output mapping
configuration is a once-off setting and does not track output
reconfigurations; the command needs to be re-run whenever the output
configuration changes. When used with tablet rotation, the tablet must be
rotated before it is mapped to the new screen.
This parameter is write-only and cannot be queried.
.TP
\fBTabletDebugLevel\fR level
Set the debug level for this tablet to the given level. This only affects
code paths that are shared between several tools on the same physical
tablet. A higher level means more fine-grained debug messages, a level of 0
turns debugging off for this tool. Requires the driver to be built with
debugging enabled. See also ToolDebugLevel.
.TP
\fBToolDebugLevel\fR level
Set the debug level for this tool to the given level. This only affects code
paths that are specific to a given tool. A higher level means
more fine-grained debug messages, a level of 0 turns debugging off for this
tool. Requires the driver to be built with debugging enabled. See also
TabletDebugLevel.


.SH "AUTHORS"
Peter Hutterer <peter.hutterer@redhat.com>

.SH "SEE ALSO"
__xservername__(__appmansuffix__), wacom(__drivermansuffix__),
xorg.conf(__filemansuffix__),
X(__miscmansuffix__)
