/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.app.Instrumentation;
import android.view.View;
import android.widget.AbsListView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CheckedTextView;
import android.widget.CompoundButton;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.ScrollView;
import android.widget.SlidingDrawer;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.ToggleButton;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.Asserter;
import com.jayway.android.robotium.solo.Checker;
import com.jayway.android.robotium.solo.Clicker;
import com.jayway.android.robotium.solo.DialogUtils;
import com.jayway.android.robotium.solo.Getter;
import com.jayway.android.robotium.solo.Presser;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Scroller;
import com.jayway.android.robotium.solo.Searcher;
import com.jayway.android.robotium.solo.Setter;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.TextEnterer;
import com.jayway.android.robotium.solo.ViewFetcher;
import com.jayway.android.robotium.solo.Waiter;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solo {
    protected final Asserter asserter;
    protected final ViewFetcher viewFetcher;
    protected final Checker checker;
    protected final Clicker clicker;
    protected final Presser presser;
    protected final Searcher searcher;
    protected final ActivityUtils activityUtils;
    protected final DialogUtils dialogUtils;
    protected final TextEnterer textEnterer;
    protected final Scroller scroller;
    protected final RobotiumUtils robotiumUtils;
    protected final Sleeper sleeper = new Sleeper();
    protected final Waiter waiter;
    protected final Setter setter;
    protected final Getter getter;
    protected final int TIMEOUT = 20000;
    protected final int SMALLTIMEOUT = 10000;
    public static final int LANDSCAPE = 0;
    public static final int PORTRAIT = 1;
    public static final int RIGHT = 22;
    public static final int LEFT = 21;
    public static final int UP = 19;
    public static final int DOWN = 20;
    public static final int ENTER = 66;
    public static final int MENU = 82;
    public static final int DELETE = 67;
    public static final int CLOSED = 0;
    public static final int OPENED = 1;

    public Solo(Instrumentation instrumentation, Activity activity) {
        this.activityUtils = new ActivityUtils(instrumentation, activity, this.sleeper);
        this.viewFetcher = new ViewFetcher(this.activityUtils);
        this.dialogUtils = new DialogUtils(this.viewFetcher, this.sleeper);
        this.scroller = new Scroller(instrumentation, this.activityUtils, this.viewFetcher, this.sleeper);
        this.searcher = new Searcher(this.viewFetcher, this.scroller, this.sleeper);
        this.waiter = new Waiter(this.activityUtils, this.viewFetcher, this.searcher, this.scroller, this.sleeper);
        this.setter = new Setter(this.activityUtils);
        this.getter = new Getter(this.activityUtils, this.viewFetcher, this.waiter);
        this.asserter = new Asserter(this.activityUtils, this.waiter);
        this.checker = new Checker(this.viewFetcher, this.waiter);
        this.robotiumUtils = new RobotiumUtils(instrumentation, this.activityUtils, this.sleeper);
        this.clicker = new Clicker(this.activityUtils, this.viewFetcher, this.scroller, this.robotiumUtils, instrumentation, this.sleeper, this.waiter);
        this.presser = new Presser(this.clicker, instrumentation, this.sleeper, this.waiter);
        this.textEnterer = new TextEnterer(instrumentation, this.activityUtils, this.clicker);
    }

    public Solo(Instrumentation instrumentation) {
        this(instrumentation, null);
    }

    public Instrumentation.ActivityMonitor getActivityMonitor() {
        return this.activityUtils.getActivityMonitor();
    }

    public ArrayList<View> getViews() {
        try {
            return this.viewFetcher.getViews(null, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<View> getViews(View parent) {
        try {
            return this.viewFetcher.getViews(parent, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public View getTopParent(View view) {
        View topParent = this.viewFetcher.getTopParent(view);
        return topParent;
    }

    public boolean waitForText(String text) {
        return this.waiter.waitForText(text);
    }

    public boolean waitForText(String text, int minimumNumberOfMatches, long timeout) {
        return this.waiter.waitForText(text, minimumNumberOfMatches, timeout);
    }

    public boolean waitForText(String text, int minimumNumberOfMatches, long timeout, boolean scroll) {
        return this.waiter.waitForText(text, minimumNumberOfMatches, timeout, scroll);
    }

    public boolean waitForText(String text, int minimumNumberOfMatches, long timeout, boolean scroll, boolean onlyVisible) {
        return this.waiter.waitForText(text, minimumNumberOfMatches, timeout, scroll, onlyVisible);
    }

    public <T extends View> boolean waitForView(Class<T> viewClass) {
        return this.waiter.waitForView(viewClass, 0, 20000, true);
    }

    public <T extends View> boolean waitForView(View view) {
        return this.waiter.waitForView(view);
    }

    public <T extends View> boolean waitForView(View view, int timeout, boolean scroll) {
        return this.waiter.waitForView(view, timeout, scroll);
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int minimumNumberOfMatches, int timeout) {
        int index = minimumNumberOfMatches - 1;
        if (index < 1) {
            index = 0;
        }
        return this.waiter.waitForView(viewClass, index, timeout, true);
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int minimumNumberOfMatches, int timeout, boolean scroll) {
        int index = minimumNumberOfMatches - 1;
        if (index < 1) {
            index = 0;
        }
        return this.waiter.waitForView(viewClass, index, timeout, scroll);
    }

    public boolean searchEditText(String text) {
        return this.searcher.searchWithTimeoutFor(EditText.class, text, 1, true, false);
    }

    public boolean searchButton(String text) {
        return this.searcher.searchWithTimeoutFor(Button.class, text, 0, true, false);
    }

    public boolean searchButton(String text, boolean onlyVisible) {
        return this.searcher.searchWithTimeoutFor(Button.class, text, 0, true, onlyVisible);
    }

    public boolean searchToggleButton(String text) {
        return this.searcher.searchWithTimeoutFor(ToggleButton.class, text, 0, true, false);
    }

    public boolean searchButton(String text, int minimumNumberOfMatches) {
        return this.searcher.searchWithTimeoutFor(Button.class, text, minimumNumberOfMatches, true, false);
    }

    public boolean searchButton(String text, int minimumNumberOfMatches, boolean onlyVisible) {
        return this.searcher.searchWithTimeoutFor(Button.class, text, minimumNumberOfMatches, true, onlyVisible);
    }

    public boolean searchToggleButton(String text, int minimumNumberOfMatches) {
        return this.searcher.searchWithTimeoutFor(ToggleButton.class, text, minimumNumberOfMatches, true, false);
    }

    public boolean searchText(String text) {
        return this.searcher.searchWithTimeoutFor(TextView.class, text, 0, true, false);
    }

    public boolean searchText(String text, boolean onlyVisible) {
        return this.searcher.searchWithTimeoutFor(TextView.class, text, 0, true, onlyVisible);
    }

    public boolean searchText(String text, int minimumNumberOfMatches) {
        return this.searcher.searchWithTimeoutFor(TextView.class, text, minimumNumberOfMatches, true, false);
    }

    public boolean searchText(String text, int minimumNumberOfMatches, boolean scroll) {
        return this.searcher.searchWithTimeoutFor(TextView.class, text, minimumNumberOfMatches, scroll, false);
    }

    public boolean searchText(String text, int minimumNumberOfMatches, boolean scroll, boolean onlyVisible) {
        return this.searcher.searchWithTimeoutFor(TextView.class, text, minimumNumberOfMatches, scroll, onlyVisible);
    }

    public void setActivityOrientation(int orientation) {
        this.activityUtils.setActivityOrientation(orientation);
    }

    public ArrayList<Activity> getAllOpenedActivities() {
        return this.activityUtils.getAllOpenedActivities();
    }

    public Activity getCurrentActivity() {
        return this.activityUtils.getCurrentActivity();
    }

    public void assertCurrentActivity(String message, String name) {
        this.asserter.assertCurrentActivity(message, name);
    }

    public void assertCurrentActivity(String message, Class expectedClass) {
        this.asserter.assertCurrentActivity(message, expectedClass);
    }

    public void assertCurrentActivity(String message, String name, boolean isNewInstance) {
        this.asserter.assertCurrentActivity(message, name, isNewInstance);
    }

    public void assertCurrentActivity(String message, Class expectedClass, boolean isNewInstance) {
        this.asserter.assertCurrentActivity(message, expectedClass, isNewInstance);
    }

    public void assertMemoryNotLow() {
        this.asserter.assertMemoryNotLow();
    }

    public boolean waitForDialogToClose(long timeout) {
        return this.dialogUtils.waitForDialogToClose(timeout);
    }

    public void goBack() {
        this.robotiumUtils.goBack();
    }

    public void clickOnScreen(float x, float y) {
        this.sleeper.sleep();
        this.clicker.clickOnScreen(x, y);
    }

    public void clickLongOnScreen(float x, float y) {
        this.clicker.clickLongOnScreen(x, y, 0);
    }

    public void clickLongOnScreen(float x, float y, int time) {
        this.clicker.clickLongOnScreen(x, y, time);
    }

    public void clickOnButton(String name) {
        this.clicker.clickOn(Button.class, name);
    }

    public void clickOnImageButton(int index) {
        this.clicker.clickOn(ImageButton.class, index);
    }

    public void clickOnToggleButton(String name) {
        this.clicker.clickOn(ToggleButton.class, name);
    }

    public void clickOnMenuItem(String text) {
        this.clicker.clickOnMenuItem(text);
    }

    public void clickOnMenuItem(String text, boolean subMenu) {
        this.clicker.clickOnMenuItem(text, subMenu);
    }

    public void pressMenuItem(int index) {
        this.presser.pressMenuItem(index);
    }

    public void pressMenuItem(int index, int itemsPerRow) {
        this.presser.pressMenuItem(index, itemsPerRow);
    }

    public void pressSpinnerItem(int spinnerIndex, int itemIndex) {
        this.presser.pressSpinnerItem(spinnerIndex, itemIndex);
    }

    public void clickOnView(View view) {
        this.waiter.waitForView(view, 10000);
        this.clicker.clickOnScreen(view);
    }

    public void clickLongOnView(View view) {
        this.clicker.clickOnScreen(view, true, 0);
    }

    public void clickLongOnView(View view, int time) {
        this.clicker.clickOnScreen(view, true, time);
    }

    public void clickOnText(String text) {
        this.clicker.clickOnText(text, false, 1, true, 0);
    }

    public void clickOnText(String text, int match) {
        this.clicker.clickOnText(text, false, match, true, 0);
    }

    public void clickOnText(String text, int match, boolean scroll) {
        this.clicker.clickOnText(text, false, match, scroll, 0);
    }

    public void clickLongOnText(String text) {
        this.clicker.clickOnText(text, true, 1, true, 0);
    }

    public void clickLongOnText(String text, int match) {
        this.clicker.clickOnText(text, true, match, true, 0);
    }

    public void clickLongOnText(String text, int match, boolean scroll) {
        this.clicker.clickOnText(text, true, match, scroll, 0);
    }

    public void clickLongOnText(String text, int match, int time) {
        this.clicker.clickOnText(text, true, match, true, time);
    }

    public void clickLongOnTextAndPress(String text, int index) {
        this.clicker.clickLongOnTextAndPress(text, index);
    }

    public void clickOnButton(int index) {
        this.clicker.clickOn(Button.class, index);
    }

    public void clickOnRadioButton(int index) {
        this.clicker.clickOn(RadioButton.class, index);
    }

    public void clickOnCheckBox(int index) {
        this.clicker.clickOn(CheckBox.class, index);
    }

    public void clickOnEditText(int index) {
        this.clicker.clickOn(EditText.class, index);
    }

    public ArrayList<TextView> clickInList(int line) {
        return this.clicker.clickInList(line);
    }

    public ArrayList<TextView> clickInList(int line, int index) {
        return this.clicker.clickInList(line, index, false, 0);
    }

    public ArrayList<TextView> clickLongInList(int line) {
        return this.clicker.clickInList(line, 0, true, 0);
    }

    public ArrayList<TextView> clickLongInList(int line, int index) {
        return this.clicker.clickInList(line, index, true, 0);
    }

    public ArrayList<TextView> clickLongInList(int line, int index, int time) {
        return this.clicker.clickInList(line, index, true, time);
    }

    public void clickOnActionBarItem(int resourceId) {
        this.clicker.clickOnActionBarItem(resourceId);
    }

    public void drag(float fromX, float toX, float fromY, float toY, int stepCount) {
        this.scroller.drag(fromX, toX, fromY, toY, stepCount);
    }

    public boolean scrollDown() {
        this.waiter.waitForViews(AbsListView.class, ScrollView.class);
        return this.scroller.scroll(0);
    }

    public boolean scrollUp() {
        this.waiter.waitForViews(AbsListView.class, ScrollView.class);
        return this.scroller.scroll(1);
    }

    public boolean scrollDownList(int index) {
        return this.scroller.scrollList((AbsListView)this.waiter.waitForAndGetView(index, ListView.class), 0);
    }

    public boolean scrollUpList(int index) {
        return this.scroller.scrollList((AbsListView)this.waiter.waitForAndGetView(index, ListView.class), 1);
    }

    public void scrollToSide(int side) {
        switch (side) {
            case 22: {
                this.scroller.scrollToSide(Scroller.Side.RIGHT);
                break;
            }
            case 21: {
                this.scroller.scrollToSide(Scroller.Side.LEFT);
            }
        }
    }

    public void setDatePicker(int index, int year, int monthOfYear, int dayOfMonth) {
        this.setDatePicker(this.waiter.waitForAndGetView(index, DatePicker.class), year, monthOfYear, dayOfMonth);
    }

    public void setDatePicker(DatePicker datePicker, int year, int monthOfYear, int dayOfMonth) {
        this.waiter.waitForView((View)datePicker, 10000);
        this.setter.setDatePicker(datePicker, year, monthOfYear, dayOfMonth);
    }

    public void setTimePicker(int index, int hour, int minute) {
        this.setTimePicker(this.waiter.waitForAndGetView(index, TimePicker.class), hour, minute);
    }

    public void setTimePicker(TimePicker timePicker, int hour, int minute) {
        this.waiter.waitForView((View)timePicker, 10000);
        this.setter.setTimePicker(timePicker, hour, minute);
    }

    public void setProgressBar(int index, int progress) {
        this.setProgressBar(this.waiter.waitForAndGetView(index, ProgressBar.class), progress);
    }

    public void setProgressBar(ProgressBar progressBar, int progress) {
        this.waiter.waitForView((View)progressBar, 10000);
        this.setter.setProgressBar(progressBar, progress);
    }

    public void setSlidingDrawer(int index, int status) {
        this.setSlidingDrawer(this.waiter.waitForAndGetView(index, SlidingDrawer.class), status);
    }

    public void setSlidingDrawer(SlidingDrawer slidingDrawer, int status) {
        this.waiter.waitForView((View)slidingDrawer, 10000);
        this.setter.setSlidingDrawer(slidingDrawer, status);
    }

    public void enterText(int index, String text) {
        this.textEnterer.setEditText(this.waiter.waitForAndGetView(index, EditText.class), text);
    }

    public void enterText(EditText editText, String text) {
        this.waiter.waitForView((View)editText, 10000);
        this.textEnterer.setEditText(editText, text);
    }

    public void typeText(int index, String text) {
        this.textEnterer.typeText(this.waiter.waitForAndGetView(index, EditText.class), text);
    }

    public void typeText(EditText editText, String text) {
        this.waiter.waitForView((View)editText, 10000);
        this.textEnterer.typeText(editText, text);
    }

    public void clearEditText(int index) {
        this.textEnterer.setEditText(this.waiter.waitForAndGetView(index, EditText.class), "");
    }

    public void clearEditText(EditText editText) {
        this.waiter.waitForView((View)editText, 10000);
        this.textEnterer.setEditText(editText, "");
    }

    public void clickOnImage(int index) {
        this.clicker.clickOn(ImageView.class, index);
    }

    public EditText getEditText(int index) {
        return this.getter.getView(EditText.class, index);
    }

    public Button getButton(int index) {
        return this.getter.getView(Button.class, index);
    }

    public TextView getText(int index) {
        return this.getter.getView(TextView.class, index);
    }

    public ImageView getImage(int index) {
        return this.getter.getView(ImageView.class, index);
    }

    public ImageButton getImageButton(int index) {
        return this.getter.getView(ImageButton.class, index);
    }

    public TextView getText(String text) {
        return this.getter.getView(TextView.class, text, false);
    }

    public TextView getText(String text, boolean onlyVisible) {
        return this.getter.getView(TextView.class, text, onlyVisible);
    }

    public Button getButton(String text) {
        return this.getter.getView(Button.class, text, false);
    }

    public Button getButton(String text, boolean onlyVisible) {
        return this.getter.getView(Button.class, text, onlyVisible);
    }

    public EditText getEditText(String text) {
        return this.getter.getView(EditText.class, text, false);
    }

    public EditText getEditText(String text, boolean onlyVisible) {
        return this.getter.getView(EditText.class, text, onlyVisible);
    }

    public View getView(int id) {
        return this.getter.getView(id);
    }

    public <T extends View> View getView(Class<T> viewClass, int index) {
        return this.waiter.waitForAndGetView(index, viewClass);
    }

    public ArrayList<View> getCurrentViews() {
        return this.viewFetcher.getViews(null, true);
    }

    public ArrayList<ImageView> getCurrentImageViews() {
        return this.viewFetcher.getCurrentViews(ImageView.class);
    }

    public ArrayList<ImageView> getCurrentImageViews(View parent) {
        return this.viewFetcher.getCurrentViews(ImageView.class, parent);
    }

    public ArrayList<EditText> getCurrentEditTexts() {
        return this.viewFetcher.getCurrentViews(EditText.class);
    }

    public ArrayList<ListView> getCurrentListViews() {
        return this.viewFetcher.getCurrentViews(ListView.class);
    }

    public ArrayList<ScrollView> getCurrentScrollViews() {
        return this.viewFetcher.getCurrentViews(ScrollView.class);
    }

    public ArrayList<Spinner> getCurrentSpinners() {
        return this.viewFetcher.getCurrentViews(Spinner.class);
    }

    public ArrayList<TextView> getCurrentTextViews(View parent) {
        return this.viewFetcher.getCurrentViews(TextView.class, parent);
    }

    public ArrayList<GridView> getCurrentGridViews() {
        return this.viewFetcher.getCurrentViews(GridView.class);
    }

    public ArrayList<Button> getCurrentButtons() {
        return this.viewFetcher.getCurrentViews(Button.class);
    }

    public ArrayList<ToggleButton> getCurrentToggleButtons() {
        return this.viewFetcher.getCurrentViews(ToggleButton.class);
    }

    public ArrayList<RadioButton> getCurrentRadioButtons() {
        return this.viewFetcher.getCurrentViews(RadioButton.class);
    }

    public ArrayList<CheckBox> getCurrentCheckBoxes() {
        return this.viewFetcher.getCurrentViews(CheckBox.class);
    }

    public ArrayList<ImageButton> getCurrentImageButtons() {
        return this.viewFetcher.getCurrentViews(ImageButton.class);
    }

    public ArrayList<DatePicker> getCurrentDatePickers() {
        return this.viewFetcher.getCurrentViews(DatePicker.class);
    }

    public ArrayList<TimePicker> getCurrentTimePickers() {
        return this.viewFetcher.getCurrentViews(TimePicker.class);
    }

    public ArrayList<SlidingDrawer> getCurrentSlidingDrawers() {
        return this.viewFetcher.getCurrentViews(SlidingDrawer.class);
    }

    public ArrayList<ProgressBar> getCurrentProgressBars() {
        return this.viewFetcher.getCurrentViews(ProgressBar.class);
    }

    public boolean isRadioButtonChecked(int index) {
        return this.checker.isButtonChecked(RadioButton.class, index);
    }

    public boolean isRadioButtonChecked(String text) {
        return this.checker.isButtonChecked(RadioButton.class, text);
    }

    public boolean isCheckBoxChecked(int index) {
        return this.checker.isButtonChecked(CheckBox.class, index);
    }

    public boolean isToggleButtonChecked(String text) {
        return this.checker.isButtonChecked(ToggleButton.class, text);
    }

    public boolean isToggleButtonChecked(int index) {
        return this.checker.isButtonChecked(ToggleButton.class, index);
    }

    public boolean isCheckBoxChecked(String text) {
        return this.checker.isButtonChecked(CheckBox.class, text);
    }

    public boolean isTextChecked(String text) {
        this.waiter.waitForViews(CheckedTextView.class, CompoundButton.class);
        if (this.viewFetcher.getCurrentViews(CheckedTextView.class).size() > 0 && this.checker.isCheckedTextChecked(text)) {
            return true;
        }
        return this.viewFetcher.getCurrentViews(CompoundButton.class).size() > 0 && this.checker.isButtonChecked(CompoundButton.class, text);
    }

    public boolean isSpinnerTextSelected(String text) {
        return this.checker.isSpinnerTextSelected(text);
    }

    public boolean isSpinnerTextSelected(int index, String text) {
        return this.checker.isSpinnerTextSelected(index, text);
    }

    public void sendKey(int key) {
        switch (key) {
            case 22: {
                this.robotiumUtils.sendKeyCode(22);
                break;
            }
            case 21: {
                this.robotiumUtils.sendKeyCode(21);
                break;
            }
            case 19: {
                this.robotiumUtils.sendKeyCode(19);
                break;
            }
            case 20: {
                this.robotiumUtils.sendKeyCode(20);
                break;
            }
            case 66: {
                this.robotiumUtils.sendKeyCode(66);
                break;
            }
            case 82: {
                this.robotiumUtils.sendKeyCode(82);
                break;
            }
            case 67: {
                this.robotiumUtils.sendKeyCode(67);
                break;
            }
            default: {
                this.robotiumUtils.sendKeyCode(key);
            }
        }
    }

    public void goBackToActivity(String name) {
        this.activityUtils.goBackToActivity(name);
    }

    public boolean waitForActivity(String name) {
        return this.waiter.waitForActivity(name, 20000);
    }

    public boolean waitForActivity(String name, int timeout) {
        return this.waiter.waitForActivity(name, timeout);
    }

    public String getString(int resId) {
        return this.activityUtils.getString(resId);
    }

    public void sleep(int time) {
        this.sleeper.sleep(time);
    }

    public void finalize() throws Throwable {
        this.activityUtils.finalize();
    }

    public void finishInactiveActivities() {
        this.activityUtils.finishInactiveActivities();
    }

    public void finishOpenedActivities() {
        this.activityUtils.finishOpenedActivities();
    }

    public void takeScreenshot() {
        View decorView = this.viewFetcher.getRecentDecorView(this.viewFetcher.getWindowDecorViews());
        this.robotiumUtils.takeScreenshot(decorView);
    }
}

