.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbSetNamedIndicator __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbSetNamedIndicator \- Names an indicator if it is not already named; toggles 
the state of the indicator; sets the indicator to a specified state and sets the 
indicator map for the indicator
.SH SYNOPSIS
.B Bool XkbSetNamedIndicator
(
.I dpy,
.I device_spec,
.I name,
.I change_state,
.I state,
.I create_new,
.I map
)
.br
      Display *\fI dpy \fP\^;
.br
      unsigned int \fI device_spec \fP\^;
.br
      Atom \fI name \fP\^;
.br
      Bool \fI change_state \fP\^;
.br
      Bool \fI state \fP\^;
.br
      Bool \fI create_new \fP\^;
.br
      XkbIndicatorMapPtr \fI map \fP\^;                  
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to the X server
.TP
.I \- device_spec
device ID, or XkbUseCoreKbd
.TP
.I \- name
name of the indicator to change
.TP
.I \- change_state
whether to change the indicator state or not
.TP
.I \- state
desired new state for the indicator
.TP
.I \- create_new
whether a new indicator with the specified name should be created when necessary
.TP
.I \- map
new map for the indicator
.SH DESCRIPTION
.LP
If a compatible version of the Xkb extension is not available in the server, 
.I XkbSetNamedIndicator 
returns False. Otherwise, it sends a request to the X server to change the 
indicator specified by 
.I name 
and returns True.
 
If 
.I change_state 
is True, and the optional parameter, 
.I state, 
is not NULL, 
.I XkbSetNamedIndicator 
tells the server to change the state of the named indicator to the value 
specified by 
.I state. 

If an indicator with the name specified by 
.I name 
does not already exist, the 
.I create_new 
parameter tells the server whether it should create a new named indicator. If 
.I create_new 
is True, the server finds the first indicator that doesn't have a name and gives 
it the name specified by 
.I name. 
If the optional parameter, 
.I map, is not NULL, 
.I XkbSetNamedIndicator 
tells the server to change the indicator's map to the values specified in 
.I map.

In addition, it can also generate XkbIndicatorStateNotify, 
XkbIndicatorMapNotify, and XkbNamesNotify events.
.SH "RETURN VALUES"
.TP 15
True
The 
.I XkbSetNamedIndicator 
function returns True if a compatible version of the Xkb extension is available in the server.
.TP 15
False
The 
.I XkbSetNamedIndicator 
function returns False if a compatible version of the Xkb extension is not available in the server.
.SH DIAGNOSTICS
.TP 15
.B BadAtom
A name is neither a valid Atom or None
.TP 15
.B BadImplementation
Invalid reply from server
.SH "SEE ALSO"
.BR XkbIndicatorMapNotify (__libmansuffix__),
.BR XkbIndicatorStateNotify (__libmansuffix__),
.BR XkbNamesNotify (__libmansuffix__)

