.TH sane-hs2p 5 "01 Nov 2007" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane-hs2p
.SH NAME
sane-hs2p \- SANE backend for Ricoh SCSI flatbed/ADF scanners
.SH DESCRIPTION
The
.B sane-hs2p
library implements a SANE (Scanner Access Now Easy) backend that provides
access to the Ricoh IS450 family of scanners. Should also work with the IS420,
IS410, and IS430 scanners, but these are untested.
Please contact the maintainer or the sane-devel mailing list if you own such a scanner.
.PP
This backend is alpha-quality. It may have bugs and some scanners haven't been
tested at all. Be careful and pull the plug if the scanner causes unusual
noise.

.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.I special
.RE
.PP
Where
.I special
is either the path-name for the special device that corresponds to a SCSI
scanner. The program
.I sane-find-scanner 
helps to find out the correct device. Under Linux, such a device name could be
.I /dev/sg0
or
.IR /dev/sga ,
for example.  See 
.BR sane-scsi (5)
for details.

.SH CONFIGURATION
The contents of the
.I hs2p.conf
file is a list of device names that correspond to SCSI
scanners.  Empty lines and lines starting with a hash mark (#) are
ignored.  See 
.BR sane-scsi (5)
on details of what constitutes a valid device name.

.SH FILES
.TP
.I @CONFIGDIR@/hs2p.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @LIBDIR@/libsane-hs2p.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-hs2p.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).
.TP
.B SANE_DEBUG_HS2P
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.
A value of 255 prints all debug output.  Smaller values reduce verbosity.

.SH CURRENT STATUS
The hs2p backend is now in version 1.00. All major scanning-related features
are supported, except for those features requiring the optional IPU. Scanning
from the flatbed or ADF (either simplex or duplex) is supported. Lineart,
halftone, 4-bit gray, and 8-bit gray are supported. Pre-set gamma tables and
halftone patterns are supported, as well as brightness, threshold, contrast.
Also supported is scan wait mode, binary and gray filtering, negative scanning,
and absolute or relative white setting. Printing with the optional endorser 
also is supported.

.SH PLANNED FUNCTIONALITY
This scanner can scan from the ADF in continuous simplex mode. 
Surprisingly, many scanners scan an entire document from the ADF
into memory before ejecting the sheet. Thus if the document is too
long, the scanner cannot hold the entire image data in memory. 
But if the scanner would send its image data when its memory got full, 
and then read the next buffer's worth of data, continuous scanning 
could be achieved.  

.SH MISSING FUNCTIONALITY
The SCSI commands for uploading (2AH) or downloading (28H)
custom halftone patterns (02H) and gamma vectors (03H) should work, 
but require implementing the SANE Option-Value code to allow the 
user to create the tables to be uploaded to the scanner. No support 
for Maintenance Data (80H) is planned as this functionality is more 
suited to a stand-alone utility to be used by a technician when 
replacing the lamp or ADF unit. Nor is support for reading or changing 
IPU (93H) paramters and adjustments planned, since my IS450 lacks
such a unit. The 31-byte Auto Photo/Letter struct and 21-byte Dynamic 
threshold struct are documented in the hs2p-scsi.h file should someone 
wish to use their IPU for image data processing.

.SH "SEE ALSO"
.BR sane (7),
.BR sane-find-scanner (1),
.BR sane-scsi (5),

.SH AUTHOR
jeremy <jeremy@acjlaw.net>
.br
Maintained by Jeremy Johnson <jeremy@acjlaw.net>
