/*
    This file is part of Akregator.

    Copyright (C) 2005 Frank Osterfeld <frank.osterfeld at kdemail.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

#include "utils.h"
#include <qregexp.h>
#include <qstring.h>

namespace Akregator {

QString Utils::stripTags(const QString& str)
{
    return QString(str).replace(QRegExp("<[^>]*>"), "");
}

uint Utils::calcHash(const QString& str)
{
    if (str.isNull()) // handle null string as "", prevents crash
        return calcHash("");
    const char* s = str.ascii();
    uint hash = 5381;
    int c;
    while ( ( c = *s++ ) ) hash = ((hash << 5) + hash) + c; // hash*33 + c
    return hash;
}

QString Utils::fileNameForUrl(const QString& url_p)
{
    QString url2(url_p);
    
    url2 = url2.replace("/", "_").replace(":", "_");
    
    if (url2.length() > 255)
        url2 = url2.left(200) + QString::number(Akregator::Utils::calcHash(url2), 16);
    
    return url2;
}

}
