/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

public abstract class Calendar
implements Serializable,
Cloneable {
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int FIELD_COUNT = 17;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    protected int[] fields;
    protected boolean[] isSet;
    protected long time;
    protected boolean isTimeSet;
    protected boolean areFieldsSet;
    private TimeZone zone;
    private boolean lenient;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;
    private int serialVersionOnStream;
    static final long serialVersionUID = -1807547505821590642L;
    private static final String bundleName = "gnu.java.locale.Calendar";
    private static final String[] fieldNames;

    private /* synthetic */ void finit$() {
        this.fields = new int[17];
        this.isSet = new boolean[17];
        this.serialVersionOnStream = 1;
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle(bundleName, locale);
    }

    protected Calendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    protected Calendar(TimeZone zone, Locale locale) {
        this.finit$();
        this.zone = zone;
        this.lenient = true;
        ResourceBundle rb = Calendar.getBundle(locale);
        this.firstDayOfWeek = (Integer)rb.getObject("firstDayOfWeek");
        this.minimalDaysInFirstWeek = (Integer)rb.getObject("minimalDaysInFirstWeek");
    }

    public static synchronized Calendar getInstance() {
        return Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
    }

    public static synchronized Calendar getInstance(TimeZone zone) {
        return Calendar.getInstance(zone, Locale.getDefault());
    }

    public static synchronized Calendar getInstance(Locale locale) {
        return Calendar.getInstance(TimeZone.getDefault(), locale);
    }

    public static synchronized Calendar getInstance(TimeZone zone, Locale locale) {
        String calendarClassName = null;
        ResourceBundle rb = Calendar.getBundle(locale);
        calendarClassName = rb.getString("calendarClass");
        if (calendarClassName != null) {
            try {
                Class calendarClass = Class.forName(calendarClassName);
                if (Calendar.class$("java.util.Calendar").isAssignableFrom(calendarClass)) {
                    return (Calendar)calendarClass.getConstructor(new Class[]{Calendar.class$("java.util.TimeZone"), Calendar.class$("java.util.Locale")}).newInstance(new Object[]{zone, locale});
                }
            }
            catch (ClassNotFoundException ex) {
            }
            catch (IllegalAccessException ex) {
            }
            catch (NoSuchMethodException ex) {
            }
            catch (InstantiationException ex) {
            }
            catch (InvocationTargetException ex) {
                // empty catch block
            }
        }
        return new GregorianCalendar(zone, locale);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public static synchronized Locale[] getAvailableLocales() {
        ResourceBundle rb = Calendar.getBundle(new Locale("", ""));
        return (Locale[])rb.getObject("availableLocales");
    }

    protected abstract void computeTime();

    protected abstract void computeFields();

    public final Date getTime() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        return new Date(this.time);
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    public long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        return this.time;
    }

    public void setTimeInMillis(long time) {
        this.time = time;
        this.isTimeSet = true;
        this.computeFields();
    }

    public int get(int field) {
        if (!this.isSet[field]) {
            this.areFieldsSet = false;
        }
        this.complete();
        return this.fields[field];
    }

    protected final int internalGet(int field) {
        return this.fields[field];
    }

    public void set(int field, int value) {
        this.isTimeSet = false;
        this.fields[field] = value;
        this.isSet[field] = true;
        switch (field) {
            case 1: 
            case 2: 
            case 5: {
                this.isSet[3] = false;
                this.isSet[6] = false;
                this.isSet[4] = false;
                this.isSet[7] = false;
                this.isSet[8] = false;
                break;
            }
            case 9: {
                this.isSet[11] = false;
                break;
            }
            case 11: {
                this.isSet[9] = false;
                this.isSet[10] = false;
                break;
            }
            case 10: {
                this.isSet[11] = false;
            }
        }
    }

    public final void set(int year, int month, int date) {
        this.isTimeSet = false;
        this.fields[1] = year;
        this.fields[2] = month;
        this.fields[5] = date;
        this.isSet[5] = true;
        this.isSet[2] = true;
        this.isSet[1] = true;
        this.isSet[3] = false;
        this.isSet[6] = false;
        this.isSet[4] = false;
        this.isSet[7] = false;
        this.isSet[8] = false;
    }

    public final void set(int year, int month, int date, int hour, int minute) {
        this.set(year, month, date);
        this.fields[11] = hour;
        this.fields[12] = minute;
        this.isSet[12] = true;
        this.isSet[11] = true;
        this.isSet[9] = false;
        this.isSet[10] = false;
    }

    public final void set(int year, int month, int date, int hour, int minute, int second) {
        this.set(year, month, date, hour, minute);
        this.fields[13] = second;
        this.isSet[13] = true;
    }

    public final void clear() {
        this.isTimeSet = false;
        this.areFieldsSet = false;
        for (int i = 0; i < 17; ++i) {
            this.isSet[i] = false;
            this.fields[i] = 0;
        }
    }

    public final void clear(int field) {
        this.isTimeSet = false;
        this.areFieldsSet = false;
        this.isSet[field] = false;
        this.fields[field] = 0;
    }

    public final boolean isSet(int field) {
        return this.isSet[field];
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        if (!this.areFieldsSet) {
            this.computeFields();
        }
    }

    public boolean equals(Object o) {
        return o instanceof Calendar && this.getTimeInMillis() == ((Calendar)o).getTimeInMillis();
    }

    public int hashCode() {
        long time = this.getTimeInMillis();
        return (int)time & 0xFFFFFFFF ^ (int)(time >> 32);
    }

    public boolean before(Object o) {
        return this.getTimeInMillis() < ((Calendar)o).getTimeInMillis();
    }

    public boolean after(Object o) {
        return this.getTimeInMillis() > ((Calendar)o).getTimeInMillis();
    }

    public abstract void add(int var1, int var2);

    public abstract void roll(int var1, boolean var2);

    public void roll(int field, int amount) {
        while (amount > 0) {
            this.roll(field, true);
            --amount;
        }
        while (amount < 0) {
            this.roll(field, false);
            ++amount;
        }
    }

    public void setTimeZone(TimeZone zone) {
        this.zone = zone;
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setFirstDayOfWeek(int value) {
        this.firstDayOfWeek = value;
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setMinimalDaysInFirstWeek(int value) {
        this.minimalDaysInFirstWeek = value;
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public abstract int getMinimum(int var1);

    public abstract int getMaximum(int var1);

    public abstract int getGreatestMinimum(int var1);

    public abstract int getLeastMaximum(int var1);

    public abstract int getActualMinimum(int var1);

    public abstract int getActualMaximum(int var1);

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void ex;
            Calendar cal = (Calendar)super.clone();
            cal.fields = (int[])this.fields.clone();
            cal.isSet = (boolean[])this.isSet.clone();
            return ex;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append('[');
        sb.append("time=");
        if (this.isTimeSet) {
            sb.append(this.time);
        } else {
            sb.append("?");
        }
        sb.append(",zone=" + this.zone);
        sb.append(",areFieldsSet=" + this.areFieldsSet);
        for (int i = 0; i < 17; ++i) {
            sb.append(fieldNames[i]);
            if (this.isSet[i]) {
                sb.append(this.fields[i]);
                continue;
            }
            sb.append("?");
        }
        sb.append(",lenient=").append(this.lenient);
        sb.append(",firstDayOfWeek=").append(this.firstDayOfWeek);
        sb.append(",minimalDaysInFirstWeek=").append(this.minimalDaysInFirstWeek);
        sb.append("]");
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (!this.isTimeSet) {
            this.computeTime();
        }
        if (this.serialVersionOnStream > 1) {
            this.fields = new int[17];
            this.isSet = new boolean[17];
            this.areFieldsSet = false;
        }
    }

    static {
        bundleName = bundleName;
        fieldNames = new String[]{",ERA=", ",YEAR=", ",MONTH=", ",WEEK_OF_YEAR=", ",WEEK_OF_MONTH=", ",DAY_OF_MONTH=", ",DAY_OF_YEAR=", ",DAY_OF_WEEK=", ",DAY_OF_WEEK_IN_MONTH=", ",AM_PM=", ",HOUR=", ",HOUR_OF_DAY=", ",MINUTE=", ",SECOND=", ",MILLISECOND=", ",ZONE_OFFSET=", ",DST_OFFSET="};
    }
}

