/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Currency;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class NumberFormat
extends Format
implements Cloneable {
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;
    boolean groupingUsed;
    int maximumFractionDigits;
    private byte maxFractionDigits;
    int maximumIntegerDigits;
    private byte maxIntegerDigits;
    int minimumFractionDigits;
    private byte minFractionDigits;
    int minimumIntegerDigits;
    private byte minIntegerDigits;
    boolean parseIntegerOnly;
    private int serialVersionOnStream;
    private static final long serialVersionUID = -2308460125733713944L;

    public final String format(long number) {
        StringBuffer sbuf = new StringBuffer(50);
        this.format(number, sbuf, (FieldPosition)null);
        return sbuf.toString();
    }

    public final StringBuffer format(Object obj, StringBuffer sbuf, FieldPosition pos) {
        if (obj instanceof Number) {
            return this.format(((Number)obj).doubleValue(), sbuf, pos);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    public abstract StringBuffer format(double var1, StringBuffer var3, FieldPosition var4);

    public abstract StringBuffer format(long var1, StringBuffer var3, FieldPosition var4);

    public boolean equals(Object obj) {
        if (!(obj instanceof NumberFormat)) {
            return false;
        }
        NumberFormat nf = (NumberFormat)obj;
        return this.groupingUsed == nf.groupingUsed && this.maximumFractionDigits == nf.maximumFractionDigits && this.maximumIntegerDigits == nf.maximumIntegerDigits && this.minimumFractionDigits == nf.minimumFractionDigits && this.minimumIntegerDigits == nf.minimumIntegerDigits && this.parseIntegerOnly == nf.parseIntegerOnly;
    }

    public static Locale[] getAvailableLocales() {
        Locale[] list = new Locale[]{Locale.US};
        return list;
    }

    private static final NumberFormat computeInstance(Locale loc, String resource, String def) {
        String fmt;
        ResourceBundle res;
        try {
            res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", loc);
        }
        catch (MissingResourceException x) {
            res = null;
        }
        try {
            fmt = res == null ? def : res.getString(resource);
        }
        catch (MissingResourceException x) {
            fmt = def;
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(loc);
        return new DecimalFormat(fmt, dfs);
    }

    public static final NumberFormat getCurrencyInstance() {
        return NumberFormat.getCurrencyInstance(Locale.getDefault());
    }

    public static NumberFormat getCurrencyInstance(Locale loc) {
        return NumberFormat.computeInstance(loc, "currencyFormat", "$#,##0.00;($#,##0.00)");
    }

    public static final NumberFormat getInstance() {
        return NumberFormat.getInstance(Locale.getDefault());
    }

    public static NumberFormat getInstance(Locale loc) {
        return NumberFormat.getNumberInstance(loc);
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    public static final NumberFormat getNumberInstance() {
        return NumberFormat.getNumberInstance(Locale.getDefault());
    }

    public static NumberFormat getNumberInstance(Locale loc) {
        return NumberFormat.computeInstance(loc, "numberFormat", "#,##0.###");
    }

    public static final NumberFormat getIntegerInstance() {
        return NumberFormat.getIntegerInstance(Locale.getDefault());
    }

    public static NumberFormat getIntegerInstance(Locale locale) {
        NumberFormat format = NumberFormat.computeInstance(locale, "numberFormat", "#,##0");
        format.setParseIntegerOnly(true);
        return format;
    }

    public static final NumberFormat getPercentInstance() {
        return NumberFormat.getPercentInstance(Locale.getDefault());
    }

    public static NumberFormat getPercentInstance(Locale loc) {
        return NumberFormat.computeInstance(loc, "percentFormat", "#,##0%");
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash ^= this.maximumFractionDigits + this.maximumIntegerDigits + this.minimumFractionDigits + this.minimumIntegerDigits;
        if (this.groupingUsed) {
            hash ^= 0xF0F0;
        }
        if (this.parseIntegerOnly) {
            hash ^= 0xF0F;
        }
        return hash;
    }

    public boolean isGroupingUsed() {
        return this.groupingUsed;
    }

    public boolean isParseIntegerOnly() {
        return this.parseIntegerOnly;
    }

    public abstract Number parse(String var1, ParsePosition var2);

    public Number parse(String sourceStr) throws ParseException {
        ParsePosition pp = new ParsePosition(0);
        Number r = this.parse(sourceStr, pp);
        if (r == null) {
            int index = pp.getErrorIndex();
            if (index < 0) {
                index = pp.getIndex();
            }
            throw new ParseException("couldn't parse number", index);
        }
        return r;
    }

    public final Object parseObject(String sourceStr, ParsePosition pos) {
        return this.parse(sourceStr, pos);
    }

    public void setGroupingUsed(boolean newValue) {
        this.groupingUsed = newValue;
    }

    public void setMaximumFractionDigits(int newValue) {
        this.maximumFractionDigits = newValue;
        if (this.getMinimumFractionDigits() > this.maximumFractionDigits) {
            this.setMinimumFractionDigits(this.maximumFractionDigits);
        }
    }

    public void setMaximumIntegerDigits(int newValue) {
        this.maximumIntegerDigits = newValue;
        if (this.getMinimumIntegerDigits() > this.maximumIntegerDigits) {
            this.setMinimumIntegerDigits(this.maximumIntegerDigits);
        }
    }

    public void setMinimumFractionDigits(int newValue) {
        this.minimumFractionDigits = newValue;
        if (this.getMaximumFractionDigits() < this.minimumFractionDigits) {
            this.setMaximumFractionDigits(this.minimumFractionDigits);
        }
    }

    public void setMinimumIntegerDigits(int newValue) {
        this.minimumIntegerDigits = newValue;
        if (this.getMaximumIntegerDigits() < this.minimumIntegerDigits) {
            this.setMaximumIntegerDigits(this.minimumIntegerDigits);
        }
    }

    public void setParseIntegerOnly(boolean value) {
        this.parseIntegerOnly = value;
    }

    public final String format(double number) {
        StringBuffer sbuf = new StringBuffer(50);
        this.format(number, sbuf, (FieldPosition)null);
        return sbuf.toString();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.maximumFractionDigits = this.maxFractionDigits;
            this.maximumIntegerDigits = this.maxIntegerDigits;
            this.minimumFractionDigits = this.minFractionDigits;
            this.minimumIntegerDigits = this.minIntegerDigits;
            this.serialVersionOnStream = 1;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.maxFractionDigits = (byte)(this.maximumFractionDigits < 127 ? (int)this.maximumFractionDigits : 127);
        this.maxIntegerDigits = (byte)(this.maximumIntegerDigits < 127 ? (int)this.maximumIntegerDigits : 127);
        this.minFractionDigits = (byte)(this.minimumFractionDigits < 127 ? (int)this.minimumFractionDigits : 127);
        this.minIntegerDigits = (byte)(this.minimumIntegerDigits < 127 ? (int)this.minimumIntegerDigits : 127);
        this.serialVersionOnStream = 1;
        stream.defaultWriteObject();
    }

    public Currency getCurrency() {
        throw new UnsupportedOperationException();
    }

    public void setCurreny(Currency currency) {
        if (currency == null) {
            throw new NullPointerException("currency may not be null");
        }
        throw new UnsupportedOperationException();
    }

    public static class Field
    extends Format.Field {
        static final long serialVersionUID = 7494728892700160890L;
        public static final Field INTEGER = new Field("integer");
        public static final Field FRACTION = new Field("fraction");
        public static final Field EXPONENT = new Field("exponent");
        public static final Field DECIMAL_SEPARATOR = new Field("decimal separator");
        public static final Field SIGN = new Field("sign");
        public static final Field GROUPING_SEPARATOR = new Field("grouping separator");
        public static final Field EXPONENT_SYMBOL = new Field("exponent symbol");
        public static final Field PERCENT = new Field("percent");
        public static final Field PERMILLE = new Field("permille");
        public static final Field CURRENCY = new Field("currency");
        public static final Field EXPONENT_SIGN = new Field("exponent sign");
        private static final Field[] allFields = new Field[]{INTEGER, FRACTION, EXPONENT, DECIMAL_SEPARATOR, SIGN, GROUPING_SEPARATOR, EXPONENT_SYMBOL, PERCENT, PERMILLE, CURRENCY, EXPONENT_SIGN};

        private Field() {
            super("");
        }

        protected Field(String field_name) {
            super(field_name);
        }

        protected Object readResolve() throws InvalidObjectException {
            String s = this.getName();
            for (int i = 0; i < allFields.length; ++i) {
                if (!s.equals(allFields[i].getName())) continue;
                return allFields[i];
            }
            throw new InvalidObjectException("no such NumberFormat field called " + s);
        }
    }
}

