/*
 * Tlf - contest logging program for amateur radio operators
 * Copyright (C) 2001-2002-2003 Rein Couperus <pa0rct@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
	/* ------------------------------------------------------------
 	*        Search log for calls / bands  /  countries
 	*
 	*--------------------------------------------------------------*/

#include "searchlog.h"
#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

static char searchresult[MAX_CALLS][82];
static char result[MAX_CALLS][82];

 	int searchlog(char *searchstring)

 	{
	extern int use_rxvt;
	extern int isdupe; 			// LZ3NY auto-b4 patch
	extern char hiscall[];
 	extern int searchflg;
 	extern int dupe;
 	extern char band[9][4];
 	extern int bandinx;
	extern int partials;
 	extern int cqww;
 	extern int pacc_pa_flg;
 	extern int pacc_qsos[10][10];
 	extern char datalines[MAX_DATALINES][81];
 	extern int countrynr;
	extern int contest;
 	extern int wpx;
	extern int arrlss;
 	extern int  zones[41];
 	extern char pxstr[];
 	extern int w_cty;
 	extern int ve_cty;
 	extern int ja_cty;
 	extern int zl_cty;
 	extern int vk_cty;
 	extern int ua9_cty;
 	extern int lu_cty;
 	extern int py_cty;
 	extern int ce_cty;
 	extern int countries[MAX_DATALINES];
 	extern int use_part;
	extern int block_part;
	extern int bigpartlist;
	extern int mixedmode;
	extern int qso_once;
	extern int trxmode;
	extern int max_callmastercalls;
	extern char callmasterarray[28000][9];
	extern char qsos[MAX_QSOS][82];
	extern char hiscall[];
	extern char zone_export[];
	extern char zone_fix[];
	extern int show_time;
    extern int wazmult;
    extern int itumult;


//char searchresult[MAX_CALLS][82];
int srch_index=0;
//char result[MAX_CALLS][82];
int r_index=0;
char s_inputbuffer[82] =  "";
char s_inputbuffercpy[82] =  "";
static char zonebuffer[3] = "";
static int z, z1;
static int i, j, k, l, m;
static int pxnr;
static int qso_index = 0;

char *tmpstr;

char callmaster_location[80];

#if 0
		if (strlen(s_inputbuffer)>=83)
	{
		printf ("WARNING: Input buffer is longer than 82 characters! exiting...");
		exit(1);
	}
#endif
	strcpy(callmaster_location, PACKAGE_DATA_DIR) ;
	strcat(callmaster_location, "/callmaster ") ;

	l=0;
	z = 0;
	s_inputbuffer[0] = '\0';
	zonebuffer[0] = '\0';
 	
 	if (strlen(hiscall) > 1 && searchflg  == SEARCHWINDOW)
	{

 	    if (strlen(hiscall) == 2)
 	    	z1 = 0;

		qso_index=0;

		for (srch_index = 0;  srch_index < MAX_CALLS ; srch_index++)
			searchresult[srch_index][0]= '\0';

		srch_index=0;

		for (r_index = 0;  r_index < MAX_CALLS ; r_index++)
			result[r_index][0]= '\0';

		r_index=0;

//

		while (strlen(qsos[qso_index]) > 2)
		{

			strncpy(s_inputbuffer, qsos[qso_index], 81);

			qso_index++;

			if (strstr(s_inputbuffer, hiscall) != 0)
			{
				strcpy(searchresult[srch_index],s_inputbuffer);
				searchresult[srch_index][80]='\0';

				if (srch_index++ > MAX_CALLS-1) break;

				s_inputbuffer[0] = '\0';
			}
			else
				s_inputbuffer[0] = '\0';
		}
 		s_inputbuffer[0] = '\0';
 //
 		for (r_index = 0; r_index < srch_index; r_index++){

		 	strncpy (result[r_index], searchresult[r_index], 7);
			result[r_index][6]='\0';
			
			if (show_time == 1)	// show qso time
				strncat (result[r_index], searchresult[r_index]+17, 5);
			else	// show qso number
				strncat (result[r_index], searchresult[r_index]+22, 5);
			
			strncat (result[r_index], searchresult[r_index]+28, 12);
			strncat (result[r_index], searchresult[r_index]+52, 16);
		}


 	 	dupe = NODUPE;
		isdupe=0;				// LZ3NY auto-b4 patch
 	 	nicebox(1, 41, 6,  37, "Worked");
 	 	refresh();

		attron(COLOR_PAIR(7) | A_STANDOUT);

		for (j =  2;  j <= 7; j++)
		{
			mvprintw(j, 42, "                                     ");
		}
			mvprintw(2, 42, " 10");
			mvprintw(3, 42, " 15");
			mvprintw(4, 42, " 20");
			mvprintw(5, 42, " 40");
			mvprintw(6, 42, " 80");
			mvprintw(7, 42, "160");

			attron(COLOR_PAIR(COLOR_CYAN) | A_STANDOUT);

	    	s_inputbuffer[0] = '\0';


		k = 0;

		for (r_index = 0; r_index < srch_index; r_index++)
		{
			strcpy(s_inputbuffer, result[r_index]);
			s_inputbuffer[37] = '\0';

			if((hiscall[0] == s_inputbuffer[12]) &&
				(strlen(hiscall) >= 3 &&
				(s_inputbuffer[12+strlen(hiscall)] == ' ')))
				{
				if ((strncmp(band[bandinx],  s_inputbuffer,  3) == 0) || (qso_once == 1))
				{
					if (mixedmode == 0)
					{
						attron(COLOR_PAIR(DUPECOLOR) | A_STANDOUT);
						dupe  = ISDUPE;
						beep();
					} else
					{
						if (((s_inputbuffer[3]=='C') &&
							(trxmode == CWMODE)) ||
							((s_inputbuffer[3]== 'S') && (trxmode == SSBMODE)))
						{
							attron(COLOR_PAIR(DUPECOLOR) | A_STANDOUT);
							dupe  = ISDUPE;
							beep();
						}

					}
				}
			}
							if (s_inputbuffer[1] == '1')
							    j = 2;
							if (s_inputbuffer[1] == '1'  &&  s_inputbuffer[2] == '5')
							    j = 3;
							if (s_inputbuffer[1] == '2')
							    j = 4;
							if (s_inputbuffer[1] == '4')
							    j = 5;
							if (s_inputbuffer[1] == '8')
							    j = 6;
							if (s_inputbuffer[1] == '6')
							    j = 7;

							if (j != 8)
							{
								mvprintw(j ,42, "%s", s_inputbuffer);
							}

							if ((cqww == 1)||(wazmult==1)||(itumult==1))
							{
								z = 0;
								if (strlen(s_inputbuffer) >= 24)
								{
                                    strncpy(zonebuffer, s_inputbuffer + 25, 2);
									zonebuffer[2] = '\0';
									z1 = zone_nr(zonebuffer);
							    } else
									z = zone_nr(zone_export);

								if (z1 != 0) z = z1;
							 }

              					attron(COLOR_PAIR(COLOR_CYAN) | A_STANDOUT);

							if((partials == 1) &&  (strlen(hiscall) >= 2))
							{
								if(strlen(s_inputbuffer) != 0)
									strncpy(s_inputbuffercpy,  s_inputbuffer+12,6);
								if(s_inputbuffercpy[5] == ' ')
										s_inputbuffercpy[5] = '\0';
								if(s_inputbuffercpy[4] == ' ')
										s_inputbuffercpy[4] = '\0';
							}

							s_inputbuffer[0] = '\0';
		}




		attroff(A_STANDOUT);
        		strncpy(s_inputbuffer,datalines[countrynr], 28);

		for (i=0 ;  i <= 27 ; i++)
		{

			if (s_inputbuffer[i] ==  ':')
			{
        				s_inputbuffer[i] =  ' ';
        				break;
        	}
        }


        if ((cqww == 1)||(wazmult==1)||(itumult==1)){

			if (z == 0){
				if (strlen(zone_fix) > 1) {
					strncpy(zonebuffer, zone_fix,2);
				} else
					strncpy(zonebuffer, zone_export,2);

				zonebuffer[2] = '\0';
         			z = zone_nr(zonebuffer);
      }
        }

        s_inputbuffer[28]='\0';

        attron(COLOR_PAIR(COLOR_YELLOW));

	mvprintw(8, 47, s_inputbuffer);
	mvhline(8,  47 +  i, ACS_HLINE, 26 - i);
if (itumult!=1)
   mvprintw(8, 73, "%s",zonebuffer);
else
  mvprintw(8, 69, "ITU:%s",zonebuffer);

        s_inputbuffer[0] = '\0';

        if (wpx == 1){
        		mvprintw(8, 47+i+5, pxstr);
	}
 	attron(COLOR_PAIR(COLOR_GREEN) | A_STANDOUT);

	if (cqww== 1 || contest == 0 || pacc_pa_flg == 1) {
		attron(COLOR_PAIR(COLOR_GREEN) | A_STANDOUT);
							
		if ((countries[countrynr] & BAND10) !=  0){
			mvprintw(2, 77, "C");
			mvprintw(2, 42, " 10");
			}
		if ((countries[countrynr] & BAND15) !=  0){
			mvprintw(3, 77, "C");
			mvprintw(3, 42, " 15");
			}
		if ((countries[countrynr] & BAND20) !=  0){
			mvprintw(4, 77, "C");
			mvprintw(4, 42, " 20");
			}
		if ((countries[countrynr] & BAND40) !=  0){
			mvprintw(5, 77, "C");
			mvprintw(5, 42, " 40");
			}
		if ((countries[countrynr] & BAND80) !=  0){
			mvprintw(6, 77, "C");
			mvprintw(6, 42, " 80");
			}
		if ((countries[countrynr] & BAND160) !=  0){
			mvprintw(7, 42, "160");
			mvprintw(7, 77, "C");
			}
	}
	if((cqww == 1)||(wazmult==1)||(itumult==1)){
		if ((zones[z] & BAND10 ) != 0){
			mvprintw(2, 78, "Z");
			}
		if ((zones[z] & BAND15) != 0){
			mvprintw(3,78, "Z");
			}
		if ((zones[z] & BAND20 ) != 0){
			mvprintw(4, 78, "Z");
			}
		if ((zones[z] & BAND40 ) != 0){
			mvprintw(5, 78, "Z");
			}
		if ((zones[z] & BAND80 ) != 0){
			mvprintw(6, 78, "Z");
			}
		if ((zones[z] & BAND160 ) != 0){
			mvprintw(7, 78, "Z");
			}
	}

	if (pacc_pa_flg == 1)
	{
		
		getpx(hiscall);
		
		pxnr = pxstr[strlen(pxstr)-1] - 48;
	 		
		if(countrynr == w_cty){
	 	 	if ( (pacc_qsos[0][pxnr] & BAND160 ) == BAND160)
	 	 		mvprintw(7, 78, "M");	
	 	
		
	 	 	if ( (pacc_qsos[0][pxnr] & BAND80 ) == BAND80)
	 	 		mvprintw(6, 78, "M");	
	 	
	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND40 ) == BAND40)
	 	 		mvprintw(5, 78, "M");	
	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND20 ) == BAND20)
	 	 		mvprintw(4, 78, "M");	
	 	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND15 ) == BAND15)
	 	 		mvprintw(3, 78, "M");	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND10 ) == BAND10)
	 	 		mvprintw(2, 78, "M");	
	 	}
		if(countrynr == ve_cty){
	 	 	if ( (pacc_qsos[0][pxnr] & BAND160 ) == BAND160)
	 	 		mvprintw(7, 78, "M");	
	 	
		
	 	 	if ( (pacc_qsos[0][pxnr] & BAND80 ) == BAND80)
	 	 		mvprintw(6, 78, "M");	
	 	
	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND40 ) == BAND40)
	 	 		mvprintw(5, 78, "M");	
	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND20 ) == BAND20)
	 	 		mvprintw(4, 78, "M");	
	 	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND15 ) == BAND15)
	 	 		mvprintw(3, 78, "M");	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND10 ) == BAND10)
	 	 		mvprintw(2, 78, "M");	
	 	}
		if(countrynr == ja_cty){
	 	 	if ( (pacc_qsos[0][pxnr] & BAND160 ) == BAND160)
	 	 		mvprintw(7, 78, "M");	
	 	
		
	 	 	if ( (pacc_qsos[0][pxnr] & BAND80 ) == BAND80)
	 	 		mvprintw(6, 78, "M");	
	 	
	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND40 ) == BAND40)
	 	 		mvprintw(5, 78, "M");	
	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND20 ) == BAND20)
	 	 		mvprintw(4, 78, "M");	
	 	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND15 ) == BAND15)
	 	 		mvprintw(3, 78, "M");	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND10 ) == BAND10)
	 	 		mvprintw(2, 78, "M");	
	 	}
		if(countrynr == py_cty){
	 	 	if ( (pacc_qsos[0][pxnr] & BAND160 ) == BAND160)
	 	 		mvprintw(7, 78, "M");	
	 	
		
	 	 	if ( (pacc_qsos[0][pxnr] & BAND80 ) == BAND80)
	 	 		mvprintw(6, 78, "M");	
	 	
	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND40 ) == BAND40)
	 	 		mvprintw(5, 78, "M");	
	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND20 ) == BAND20)
	 	 		mvprintw(4, 78, "M");	
	 	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND15 ) == BAND15)
	 	 		mvprintw(3, 78, "M");	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND10 ) == BAND10)
	 	 		mvprintw(2, 78, "M");	
	 	}
		if(countrynr == lu_cty){
	 	 	if ( (pacc_qsos[0][pxnr] & BAND160 ) == BAND160)
	 	 		mvprintw(7, 78, "M");	
	 	
		
	 	 	if ( (pacc_qsos[0][pxnr] & BAND80 ) == BAND80)
	 	 		mvprintw(6, 78, "M");	
	 	
	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND40 ) == BAND40)
	 	 		mvprintw(5, 78, "M");	
	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND20 ) == BAND20)
	 	 		mvprintw(4, 78, "M");	
	 	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND15 ) == BAND15)
	 	 		mvprintw(3, 78, "M");	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND10 ) == BAND10)
	 	 		mvprintw(2, 78, "M");	
	 	}
		if(countrynr == ua9_cty){
	 	 	if ( (pacc_qsos[0][pxnr] & BAND160 ) == BAND160)
	 	 		mvprintw(7, 78, "M");	
	 	
		
	 	 	if ( (pacc_qsos[0][pxnr] & BAND80 ) == BAND80)
	 	 		mvprintw(6, 78, "M");	
	 	
	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND40 ) == BAND40)
	 	 		mvprintw(5, 78, "M");	
	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND20 ) == BAND20)
	 	 		mvprintw(4, 78, "M");	
	 	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND15 ) == BAND15)
	 	 		mvprintw(3, 78, "M");	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND10 ) == BAND10)
	 	 		mvprintw(2, 78, "M");	
	 	}
		if(countrynr == zl_cty){
	 	 	if ( (pacc_qsos[0][pxnr] & BAND160 ) == BAND160)
	 	 		mvprintw(7, 78, "M");	
	 	
		
	 	 	if ( (pacc_qsos[0][pxnr] & BAND80 ) == BAND80)
	 	 		mvprintw(6, 78, "M");	
	 	
	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND40 ) == BAND40)
	 	 		mvprintw(5, 78, "M");	
	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND20 ) == BAND20)
	 	 		mvprintw(4, 78, "M");	
	 	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND15 ) == BAND15)
	 	 		mvprintw(3, 78, "M");	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND10 ) == BAND10)
	 	 		mvprintw(2, 78, "M");	
	 	}
		if(countrynr == lu_cty){
	 	 	if ( (pacc_qsos[0][pxnr] & BAND160 ) == BAND160)
	 	 		mvprintw(7, 78, "M");	
	 	
		
	 	 	if ( (pacc_qsos[0][pxnr] & BAND80 ) == BAND80)
	 	 		mvprintw(6, 78, "M");	
	 	
	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND40 ) == BAND40)
	 	 		mvprintw(5, 78, "M");	
	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND20 ) == BAND20)
	 	 		mvprintw(4, 78, "M");	
	 	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND15 ) == BAND15)
	 	 		mvprintw(3, 78, "M");	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND10 ) == BAND10)
	 	 		mvprintw(2, 78, "M");	
	 	}
		if(countrynr == ce_cty){
	 	 	if ( (pacc_qsos[0][pxnr] & BAND160 ) == BAND160)
	 	 		mvprintw(7, 78, "M");	
	 	
		
	 	 	if ( (pacc_qsos[0][pxnr] & BAND80 ) == BAND80)
	 	 		mvprintw(6, 78, "M");	
	 	
	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND40 ) == BAND40)
	 	 		mvprintw(5, 78, "M");	
	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND20 ) == BAND20)
	 	 		mvprintw(4, 78, "M");	
	 	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND15 ) == BAND15)
	 	 		mvprintw(3, 78, "M");	

	 	 	if ( (pacc_qsos[0][pxnr] & BAND10 ) == BAND10)
	 	 		mvprintw(2, 78, "M");	
	 	}
		if(countrynr == vk_cty){
	 	 	if ( (pacc_qsos[0][pxnr] & BAND160 ) == BAND160)
	 	 		mvprintw(7, 78, "M");	
	 	
		
	 	 	if ( (pacc_qsos[0][pxnr] & BAND80 ) == BAND80)
	 	 		mvprintw(6, 78, "M");	


	 	 	if ( (pacc_qsos[0][pxnr] & BAND40 ) == BAND40)
	 	 		mvprintw(5, 78, "M");	


	 	 	if ( (pacc_qsos[0][pxnr] & BAND20 ) == BAND20)
	 	 		mvprintw(4, 78, "M");	
	 	
	 	 	if ( (pacc_qsos[0][pxnr] & BAND15 ) == BAND15)
	 	 		mvprintw(3, 78, "M");

	 	 	if ( (pacc_qsos[0][pxnr] & BAND10 ) == BAND10)
	 	 		mvprintw(2, 78, "M");
	 	}



	}

//  master.dta code

	if(partials==1)
	{

		if(bigpartlist == 0)
		{

			j=0;

			if (use_rxvt == 0) attron(COLOR_PAIR(COLOR_WHITE | A_BOLD | A_STANDOUT));
			else attron(COLOR_PAIR(COLOR_WHITE | A_STANDOUT));

			mvprintw(13,0,"                                                                ");

			mvprintw(13,0, " ??");

			for (m =0; m < max_callmastercalls;  m++)
			{

			   	if(strlen(callmasterarray[m]) >=2)
				{

					tmpstr = strstr(callmasterarray[m],hiscall);

					if (tmpstr != NULL)
					{
						if (use_rxvt == 0)
							attron(COLOR_PAIR(COLOR_WHITE
								| A_BOLD
								|A_STANDOUT));

						else
							attron(COLOR_PAIR(COLOR_WHITE | A_STANDOUT));

						mvprintw(13,j, "%s  ",callmasterarray[m]);

						if(strlen(s_inputbuffercpy) == 0)
							strcpy(s_inputbuffercpy, callmasterarray[m]);


						j=j+7;


				         	if(j>=60)         break;

					}
			   	 }


			}
		}   else
		{
			l = 0;
			j = 0;

			if (use_rxvt == 0)
				attron(COLOR_PAIR(COLOR_WHITE | A_BOLD | A_STANDOUT));
			else
				attron(COLOR_PAIR(COLOR_WHITE  | A_STANDOUT));

			for(j = 0; j < 9; j++)
			{
				mvprintw(15+j, 38, "                                         ");
				refresh();
			}

			j = 0;

			for (m =0; m < max_callmastercalls;  m++)
			{

			   	if(strlen(callmasterarray[m]) >=2)
				{

					tmpstr = strstr(callmasterarray[m],hiscall);

					if (tmpstr != NULL)
					{
						if (use_rxvt == 0)
							attron(COLOR_PAIR(COLOR_WHITE | A_BOLD | A_STANDOUT));
						else
							attron(COLOR_PAIR(COLOR_WHITE | A_STANDOUT));
						mvprintw(15+l,38+j, "%s  ",callmasterarray[m]);

						if(strlen(s_inputbuffercpy) == 0)
							strcpy(s_inputbuffercpy, callmasterarray[m]);


						j=j+7;

						if(j>=42)
						{
							l ++;
							j = 0;

						}
						if(l > 8)
							break;

					}
			   	 }


			}


		}

			if ((j <= 13)&& (l == 0)&& (use_part == 1)&&(block_part == 0))
			{
					if (use_rxvt == 0) attron(COLOR_PAIR(COLOR_GREEN | A_BOLD | A_STANDOUT));
					else attron(COLOR_PAIR(COLOR_GREEN | A_STANDOUT));

					mvprintw(13,0, s_inputbuffercpy);
			}

			if((block_part == 0) && (use_part == 1) && (j <= 13)&& (l == 0)&&
				(strlen(s_inputbuffercpy) > strlen(hiscall)) )
			{

					strcpy(hiscall, s_inputbuffercpy);
					beep();

			}
			refresh();

	}

	if (dupe == NODUPE && arrlss == 1)
		r_multiplierinfo();

	if (dupe == ISDUPE)
	{
	    		isdupe=1;		// LZ3NY auto-b4 patch
				attron(COLOR_PAIR(DUPECOLOR) | A_STANDOUT);
				mvprintw(12, 29, hiscall);
				refresh();
				usleep(100000);
	}
	else
		printcall();

	}


 	 return(0);
}

// --------------------------------------------load callmaster ------------------
 int load_callmaster(void) {

 extern char callmasterarray[28000][9];
 extern int arrlss;

 FILE *cfp ;
 char callmaster_location[80];
 char s_inputbuffer[186] =  "";
 int count = 0;
 int file_ok = 0;

		strcpy(callmaster_location, "callmaster");
		if ( (cfp = fopen(callmaster_location,"r"))  == NULL)
		{
			callmaster_location[0]='\0';
			strcpy(callmaster_location, PACKAGE_DATA_DIR) ;
			strcat(callmaster_location, "/callmaster") ;


			if  ( (cfp = fopen(callmaster_location,"r"))  == NULL)
			{
				mvprintw(24,0,  "Error opening callmaster file.\n");
				refresh();
				sleep(2);
			}
			else file_ok = 1;
		}
			else file_ok = 1;

			if (file_ok == 1)
			{

				count = 0;

				while  (!feof(cfp) )
				{
					s_inputbuffer[0]='\0';
					fgets (s_inputbuffer, 85,  cfp);

					if (arrlss == 1)
					{

						if((s_inputbuffer[0] == 'A') || (s_inputbuffer[0] == 'K')
								|| (s_inputbuffer[0] == 'W') || (s_inputbuffer[0] == 'V')
								|| (s_inputbuffer[0] == 'C') || (s_inputbuffer[0] == 'N'))
								{
							s_inputbuffer[strlen(s_inputbuffer)-1]='\0';

							s_inputbuffer[9]='\0';
							strcpy(callmasterarray[count], s_inputbuffer) ;
							count++;
						}

					} else
					{

						if(strlen(s_inputbuffer)>0)
							s_inputbuffer[strlen(s_inputbuffer)-1]='\0';

						s_inputbuffer[9]='\0';
						strcpy(callmasterarray[count], s_inputbuffer) ;
						count++;

					}


				}

				fclose(cfp);
			}


  return(count);
}
// -------------------------------------------------------------------------------
char multsfile[120] = "";		// global... (to be fixed)
// ----------------------------------------------load mults ------------------------
int load_multipliers(void) {

extern char mults_possible[MAX_MULTS][12];
extern char multiplierlist[];

 FILE *cfp ;
 char s_inputbuffer[186] =  "";
 int count = 0, i;


			for (i = 0; i < MAX_MULTS; i++) {
				mults_possible[i][0] = '\0';
			}

			if (strlen(multiplierlist) != 0)
				strncpy(multsfile , multiplierlist, strlen(multiplierlist)-1);
			else {
				mvprintw(9,0,  "No multiplier file specified, exiting.. !!\n");
				refresh();
				sleep(5);
				exit(1);
			}

			if  ( (cfp = fopen(multsfile , "r"))  == NULL){
				mvprintw(9,0,  "Error opening multiplier file %s.\n", multsfile);
				refresh();
				sleep(2);
			}  else {

				count = 0;

				while  (!feof(cfp) ) {
					s_inputbuffer[0]='\0';
					fgets (s_inputbuffer, 85,  cfp);
					if(strlen(s_inputbuffer)>0)
						s_inputbuffer[strlen(s_inputbuffer)-1]='\0';
					s_inputbuffer[9]='\0';
					strcpy(mults_possible[count], s_inputbuffer) ;

					count++;

				}

				fclose(cfp);
			}

  return(count);
}
