/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class HashSet
extends AbstractSet
implements Set,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5024744406713321676L;
    private transient HashMap map;

    public HashSet() {
        this(11, 0.75f);
    }

    public HashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashSet(int initialCapacity, float loadFactor) {
        this.map = this.init(initialCapacity, loadFactor);
    }

    public HashSet(Collection c) {
        this(Math.max(2 * c.size(), 11));
        this.addAll(c);
    }

    public boolean add(Object o) {
        return this.map.put(o, "") == null;
    }

    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        HashSet copy = null;
        try {
            copy = (HashSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        copy.map = (HashMap)this.map.clone();
        return copy;
    }

    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    public boolean isEmpty() {
        return this.map.size == 0;
    }

    public Iterator iterator() {
        return this.map.iterator(0);
    }

    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    public int size() {
        return this.map.size;
    }

    HashMap init(int capacity, float load) {
        return new HashMap(capacity, load);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Iterator it = this.map.iterator(0);
        s.writeInt(this.map.buckets.length);
        s.writeFloat(this.map.loadFactor);
        s.writeInt(this.map.size);
        while (it.hasNext()) {
            s.writeObject(it.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.map = this.init(s.readInt(), s.readFloat());
        for (int size = s.readInt(); size > 0; --size) {
            this.map.put(s.readObject(), "");
        }
    }
}

