/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;

public final class NetworkInterface {
    private String name;
    private Vector inetAddresses;

    private NetworkInterface(String name, InetAddress address) {
        this.name = name;
        this.inetAddresses = new Vector(1, 1);
        this.inetAddresses.add(address);
    }

    private static native Vector getRealNetworkInterfaces() throws SocketException;

    public String getName() {
        return this.name;
    }

    public Enumeration getInetAddresses() {
        SecurityManager s = System.getSecurityManager();
        if (s == null) {
            return this.inetAddresses.elements();
        }
        Vector tmpInetAddresses = new Vector(1, 1);
        Enumeration addresses = this.inetAddresses.elements();
        while (addresses.hasMoreElements()) {
            InetAddress addr = (InetAddress)addresses.nextElement();
            try {
                s.checkConnect(addr.getHostAddress(), 58000);
                tmpInetAddresses.add(addr);
            }
            catch (SecurityException e) {}
        }
        return tmpInetAddresses.elements();
    }

    public String getDisplayName() {
        return this.name;
    }

    public static NetworkInterface getByName(String name) throws SocketException {
        Vector networkInterfaces = NetworkInterface.getRealNetworkInterfaces();
        Enumeration e = networkInterfaces.elements();
        while (e.hasMoreElements()) {
            NetworkInterface tmp = (NetworkInterface)e.nextElement();
            if (!name.equals(tmp.getName())) continue;
            return tmp;
        }
        return null;
    }

    public static NetworkInterface getByInetAddress(InetAddress addr) throws SocketException {
        Vector networkInterfaces = NetworkInterface.getRealNetworkInterfaces();
        Enumeration interfaces = networkInterfaces.elements();
        while (interfaces.hasMoreElements()) {
            NetworkInterface tmp = (NetworkInterface)interfaces.nextElement();
            Enumeration addresses = tmp.inetAddresses.elements();
            while (addresses.hasMoreElements()) {
                if (!addr.equals((InetAddress)addresses.nextElement())) continue;
                return tmp;
            }
        }
        throw new SocketException("no network interface is bound to such an IP address");
    }

    public static Enumeration getNetworkInterfaces() throws SocketException {
        Vector networkInterfaces = NetworkInterface.getRealNetworkInterfaces();
        if (networkInterfaces.isEmpty()) {
            return null;
        }
        return networkInterfaces.elements();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface tmp = (NetworkInterface)obj;
        return this.name.equals(tmp.name) && this.inetAddresses.equals(tmp.inetAddresses);
    }

    public int hashCode() {
        return this.name.hashCode() + this.inetAddresses.hashCode();
    }

    public String toString() {
        String separator = System.getProperty("line.separator");
        String result = "name: " + this.getDisplayName() + " (" + this.getName() + ") addresses:" + separator;
        Enumeration e = this.inetAddresses.elements();
        while (e.hasMoreElements()) {
            InetAddress address = (InetAddress)e.nextElement();
            result = result + new StringBuffer().append(address.toString()).append(";").append(separator);
        }
        return result;
    }
}

