.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutSpaceballMotionFunc 3GLUT "3.7" "GLUT" "GLUT"
.SH NAME
glutSpaceballMotionFunc - sets the Spaceball motion callback for the current window. 
.SH SYNTAX
.nf
.LP
void glutSpaceballMotionFunc(void (*func)(int x, int y, int z));
.fi
.SH ARGUMENTS
.IP \fIfunc\fP 1i
The new entry callback function. 
.SH DESCRIPTION
glutSpaceballMotionFunc sets the Spaceball motion callback for
the current window. The Spaceball motion callback for a window is
called when the window has Spaceball input focus (normally, when the
mouse is in the window) and the user generates Spaceball translations.
The x, y, and z callback parameters indicate the translations along the X,
Y, and Z axes. The callback parameters are normalized to be within the
range of -1000 to 1000 inclusive. 

Registering a Spaceball motion callback when a Spaceball device is not
available has no effect and is not an error. In this case, no Spaceball
motion callbacks will be generated. 

Passing NULL to glutSpaceballMotionFunc disables the generation
of Spaceball motion callbacks. When a new window is created, no
Spaceball motion callback is initially registered. 
.SH SEE ALSO
glutSpaceballRotateFunc, glutSpaceballButtonFunc, glutMotionFunc, glutTabletMotionFunc, glutJoystickFunc, glutDeviceGet
.SH AUTHOR
Mark J. Kilgard (mjk@nvidia.com)
