Name: docbook-style-dsssl
Version: 1.64
Release: 3
Group: Applications/Text

Summary: Norman Walsh's modular stylesheets for DocBook.

License: Distributable
URL: http://www.nwalsh.com/docbook/dsssl/

Requires: openjade = 1.3
PreReq: docbook-dtd-sgml
PreReq: sgml-common >= 0.5
PreReq: openjade >= 1.3-12

BuildRoot: %{_tmppath}/%{name}-%{version}

BuildArch: noarch
Source0: http://www.nwalsh.com/docbook/dsssl/db164.zip
Source1: %{name}-%{version}.Makefile


%description
These DSSSL stylesheets allow to convert any DocBook document to another
printed (for example, RTF or PostScript) or online (for example, HTML) format.
They are highly customizable.

%prep
%setup -c -T
unzip %{SOURCE0}
if [ `id -u` -eq 0 ]; then
  chown -R root.root .
  chmod -R a+rX,g-w,o-w .
fi
cp %{SOURCE1} docbook/Makefile


%build


%install
DESTDIR=$RPM_BUILD_ROOT
rm -rf $DESTDIR
cd docbook
make install BINDIR=$DESTDIR/usr/bin DESTDIR=$DESTDIR/usr/share/sgml/docbook/dsssl-stylesheets-%{version}
cd ..
ln -s dsssl-stylesheets-%{version} $DESTDIR/usr/share/sgml/docbook/dsssl-stylesheets


%clean
DESTDIR=$RPM_BUILD_ROOT
rm -rf $DESTDIR


%files
%defattr (-,root,root)
%doc docbook/BUGS docbook/TODO docbook/README docbook/ChangeLog docbook/WhatsNew
/usr/bin/collateindex.pl
/usr/share/sgml/docbook/dsssl-stylesheets-%{version}
/usr/share/sgml/docbook/dsssl-stylesheets


%post
for centralized in /etc/sgml/*-docbook-*.cat
do   /usr/bin/install-catalog --add $centralized /usr/share/sgml/openjade-1.3/catalog > /dev/null
     /usr/bin/install-catalog --remove $centralized /usr/share/sgml/docbook/dsssl-stylesheets-*/catalog >/dev/null 2>/dev/null
     /usr/bin/install-catalog --add $centralized /usr/share/sgml/docbook/dsssl-stylesheets-%{version}/catalog > /dev/null
done


%preun
if [ "$1" = "0" ]; then
  for centralized in /etc/sgml/*-docbook-*.cat
  do   /usr/bin/install-catalog --remove $centralized /usr/share/sgml/openjade-1.3/catalog > /dev/null
    /usr/bin/install-catalog --remove $centralized /usr/share/sgml/docbook/dsssl-stylesheets-%{version}/catalog > /dev/null
  done
fi

%changelog
* Wed Jul 25 2001 Bill Nottingham <notting@redhat.com> 1.64-3
- bump release 

* Thu May  9 2001 Tim Waugh <twaugh@redhat.com> 1.64-2
- Make an unversioned dsssl-stylesheets symbolic link.

* Wed May  2 2001 Tim Waugh <twaugh@redhat.com> 1.64-1
- 1.64 (fixes #38095).
- Fix up post/preun scripts so that we don't get duplicate entries with
  different versions on upgrade.

* Sun Mar 25 2001 Tim Waugh <twaugh@redhat.com> 1.59-10
- Fix up Makefile (patch from SATO Satoru).
- Change postun to preun.
- Make preun conditional on remove rather than upgrade.

* Tue Mar  6 2001 Tim Waugh <twaugh@redhat.com>
- PreReq docbook-dtd-sgml (it was a requirement before), so that the
  scripts work right.

* Tue Feb 20 2001 Tim Waugh <twaugh@redhat.com>
- Change Requires(...) to PreReq at Preston's request.
- PreReq at least openjade-1.3-12, so that its catalogs get installed.

* Wed Jan 24 2001 Tim Waugh <twaugh@redhat.com>
- Make scripts quieter.

* Tue Jan 23 2001 Tim Waugh <twaugh@redhat.com>
- Last fix was wrong; corrected (require openjade 1.3).

* Fri Jan 19 2001 Tim Waugh <twaugh@redhat.com>
- Require jade not openjade (bug #24306).

* Mon Jan 15 2001 Tim Waugh <twaugh@redhat.com>
- Don't play so many macro games.
- Change requirement on /usr/bin/install-catalog to sgml-common.
- Be sure to own dsssl-stylesheets-1.59 directory.

* Mon Jan 08 2001 Tim Waugh <twaugh@redhat.com>
- Change group.
- openjade not jade.
- %%{_tmppath}.
- rm before install.
- Change Copyright: to License:.
- Remove Packager: line.

* Mon Jan 08 2001 Tim Waugh <twaugh@redhat.com>
- Based on Eric Bischoff's new-trials packages.
