/*
	xcdroast.h
*/

#include "config.h"

#define XCDROAST_VERSION VERSION 
#define MAXLINE 1024
#define CDDAFRAME 2352
#define DATASECTORSIZE 2048
#define SUNDATASECTORSIZE 512
#define XCDRLOGO "icons/xcdrlogo.gif"
#define CDDBLOGO "icons/cddblogo.gif"
#define BURNPROOFLOGO "icons/burnproof.gif"
#define IMG_EXTENSIONS { ".iso", ".raw", ".img", ".wav", ".toc", NULL }
#define CDR_TYPES_MIN {20,21,23,27,30,34,50,63,74,-80,89,99,0} /* negative value is default */
#define DVD_TYPES_MB { 2600, 3950, 4700, 5200, 9400, 0 }

#define TMP_XCDR_DIR "/tmp"
#define XCDROAST_INFO_EXT ".xinf"
#define CDDA2WAV_INFO_EXT ".inf"

/* which is base of all filetree-selectors? Set to "$HOME" to have
   this automatically be the home-directory of the current user */
#define FILETREEBASE "/"
/* #define FILETREEBASE "$HOME" */

/* texts to write/blank modes */
#define WRITE_MODES { \
	N_("Disk-At-Once (DAO)"), \
	N_("Track-At-Once (TAO)"), \
	N_("TAO with zero pregap"), \
	N_("RAW writing (raw96r)"), \
	N_("RAW writing (raw96p)"), \
	N_("RAW writing (raw16)"), \
	NULL }

#define HELP_WRITE_MODES { \
	N_("Write CD in Disk-At-Once mode. This will create an exact copy without any pauses between tracks. Currently doesn't work with all supported writers."), \
	N_("Write CD in Track-At-Once mode. Generates a 2 second pause between each track, but is supported on all writers."), \
	N_("Write CD in Track-At-Once mode, but eliminates the 2 second pause. So this looks very much like a DAO-CD, but only works for some TEAC/Traxdata-writers."), \
	N_("Write CD in RAW writing mode. It will write with 2352 byte sectors plus 96 bytes of raw P-W subchannel data resulting in a sector size of 2448 bytes. This is the preferred raw writing mode as it gives best control over the CD writing process. (For expert usage only!)"), \
	N_("Write CD in RAW writing mode. It will write with 2352 byte sectors plus 96 bytes of packed P-W subchannel data resulting in a sector size of 2448 bytes. This is the less preferred raw writing mode as only a few recordes support it. (For expert usage only!)"), \
	N_("Write CD in RAW writing mode. It will write with 2352 byte sectors plus 16 bytes of P-Q subchannel data resulting in a sector size of 2368 bytes. If a recorder does not support raw96r, this is the preferred raw writing mode. It does not allow to write CD-Text but it is the only raw writing mode in cheap CD writers. As these cheap writers in most cases do not support DAO mode. (For expert usage only!)"), \
	NULL }

#define BLANK_MODES { \
	N_("blank the entire disk"), \
	N_("minimally blank the entire disk (PMA, TOC, pregap)"), \
	N_("blank a track"), \
	N_("unreserve a track"), \
	N_("blank a track tail"), \
	N_("unclose last session"), \
	N_("blank last session"), \
	NULL }

#define VIEW_MODES { \
	N_("Small"), \
	N_("Normal"), \
	N_("Extended"), \
	NULL }

#define CONTEXT_MSTRMENU { \
	N_("Select all"), \
	N_("Unselect all"), \
	N_("Load list"), \
	N_("Save list"), \
	N_("Clear list"), \
	NULL }

/* icons for dialogs (borrowed from gnome) */
#define ICO_ERROR "icons/dialog_error.png"
#define ICO_INFO "icons/dialog_information.png"
#define ICO_WARN "icons/dialog_warning.png"
#define ICO_QUEST "icons/dialog_question.png"
#define ICO_DEF "icons/dialog_default.png"

/* external called programms */
#ifndef hpux
# define DF "/bin/df -k" 
# define DF2 "/usr/bin/df -k" 
#else
# define DF "/bin/df -b" 
# define DF2 "/usr/bin/df -b" 
#endif
#define UNAME "/bin/uname -a"
#define UNAME2 "/usr/bin/uname -a"

#define CHOWNGRPMOD_PATH "/bin:/usr/bin:/sbin:/usr/sbin"
#define CHOWN "chown"
#define CHGRP "chgrp"
#define CHMOD "chmod"

#define SUDO "/usr/bin/sudo"

/* HISTORIC - no longer used 
#if defined(__FreeBSD__)
# define GROUPADD "/usr/sbin/pw"
#else
# define GROUPADD "/usr/sbin/groupadd"
#endif
*/

#define WAVPLAY "bin/wavplay"
#define RMTOOL "bin/rmtool"
#define VRFYTOOL "bin/vrfytool"
#define CDDBTOOL "bin/cddbtool"
#define WRAPPER "bin/xcdrwrap"

/* this paths can be specified relative to lib-dir or absolute */
/* xcdroast will look for these first in $LIBDIR/ and if not found
   then in $PREFIX (e.g. /usr/bin/cdrecord instead of 
   /usr/local/lib/xcdroast-0.98/bin/cdrecord) */

#define CDRECORD "bin/cdrecord" 
#define CDRECORDPRODVD "bin/cdrecord.prodvd" 
#define CDDA2WAV "bin/cdda2wav"
#define READCD "bin/readcd"
#define MKISOFS "bin/mkisofs"

/* MINIMUM required versions. Greater versions are now silently
   accepted. 
   Distribution-Vendors: DO NOT TOUCH THESE!
   IT WONT WORK WITH LOWER VERSIONS, EVEN WHEN YOU THINK IT DOES! */
 
#define CDRECORD_VERSION "1.11a34"
#define CDRECORD_PRODVD_VERSION "2.01a11"
#define CDRECORD_VERSION_WITH_ONTHFLYAUDIO "2.01a13"
#define MKISOFS_VERSION "1.15a17"
#define CDDA2WAV_VERSION "1.11a34"
#define READCD_VERSION "1.11a34"

/* group to use for non-root-mode */
/* #define NONROOTMODEGROUP "xcdwrite"  - HISTORIC */

/* demo sound */
#define DSPTESTSOUND "sound/test.wav"

/* max scanned scsi devices */
#define MAXDEVICES 128

/* max support for cdrecord-drivers (as in cdrecord driver=help) */ 
#define MAXDRIVERS 64 

/* max support for blank-modes (as in cdrecord blank=help) */
#define MAXBLANKMODES 16

/* max support for joliet charsets */
#define MAXCHARSETS 64

/* max tracks a CD can have */
#define MAXTRACKS 100

/* max CDDB matches */
#define MAXCDDB 100

/* max args for pipes */
#define MAXPIPEARGS 1024 

/* timeout in seconds for CDDB queries over network */
#define NETIOTIMEOUT 10;

/* default image-file-prefix */
#define IMGFILEPREFIX "track"

/* default filenames for process-output-savefiles */
#define SAVEOUTCDRECORD "cdrecord.out"
#define SAVEREADTRACKS "readtracks.out"
#define SAVEVERIFYTRACKS "verifytracks.out"
#define SAVEMASTERTRACK "mkisofs.out"
#define SAVEMASTERCALC "mkisofscalc.out"
#define SAVEMASTERLIST "xcdrmaster.lst"

/* default paths/configfile */
#define PREFIX "/usr/local"
#define LIBDIR "lib/xcdroast-0.98"
#define CONFIGDIR "~/.xcdroast"
#define CONFFILE "xcdr098.cfg"
#define LOGFILE "xcdr098.log"
#define ISOOPTFILE "isoopt.cfg"
#define ISOHEADERFILE "isoheader.cfg"
#define WRITEOPTFILE "writeopt.cfg"
#define NONROOTBAK "nonrootflags.cfg"
/* rootconfig is stored in $sysconfdir (/usr/local/etc by default) */
#define ROOTCONFIG "xcdroast.conf"

/* font definitions */
#define NORMFONT "-*-helvetica-medium-r-normal-*-*-120-*-*-p-*-*,-default-*-medium-r-*--14-*-*-*-*-*-*-*,*-medium-r-*,*"
#define BOLDFONT "-*-helvetica-bold-r-normal-*-*-120-*-*-p-*-*,-default-*-bold-r-*--16-*-*-*-*-*-*-*,*-bold-r-*,*"
#define BIGFONT "-*-helvetica-bold-r-normal-*-*-240-*-*-p-*-*,-default-*-bold-r-*--24-*-*-*-*-*-*-*,*-bold-r-*,*"
#define SLANTFONT "-*-helvetica-medium-o-normal-*-*-100-*-*-*-*-*-*,-default-*-medium-i-*--12-*-*-*-*-*-*-*,*-medium-i-*,*"
#define FIXEDFONT "-*-fixed-medium-r-normal-*-*-120-*-*-*-*-*-*,*"

/* default window sizes - usage autodetected */
/* 75dpi fonts */
#define XCDR_TOPLEVEL_X0 790
#define XCDR_TOPLEVEL_Y0 540
/* 100dpi fonts */
#define XCDR_TOPLEVEL_X1 980
#define XCDR_TOPLEVEL_Y1 670

/* color definitions
   - may not be used at all because they interfere with themes */
#define TOOLTIPCOL "light yellow"
#define GTKLISTCOL "gray95"
#define SELECTEDCLISTCOL "gray70"
#define ENABLEDCOLOR "black"
#define DISABLEDCOLOR "gray40"

/* text shortcuts */
#define T_XCDROAST "X-CD-Roast"
#define T_YES _("Yes") 
#define T_NO _("No") 
#define T_CANCEL _("Cancel") 
#define T_OK _("Ok") 
#define T_CLOSE _("Close") 
#define T_ANYWAY _("Continue anyway")

/* predefined master iso-opitions */
/* there must be the same number of TYPES as TEXTS (minus the NULL element) */
#define MASTER_TEXTS { \
	N_("Rock Ridge + Joliet"), \
	N_("Rock Ridge only"), \
	N_("MS-DOS"), \
	NULL }
#define MASTER_TYPES { 	{ 1,1,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 }, \
			{ 1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 }, \
			{ 0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } }

#define DEF_BOOT_CATALOG "boot.catalog"

/* some defines for drag&drop */

#define DRAG_TAR_NAME_0         "text/plain"
#define DRAG_TAR_INFO_0         0
#define DRAG_TAR_NAME_1         "text/uri-list"
#define DRAG_TAR_INFO_1         1
#define DRAG_TAR_NAME_2         "STRING"
#define DRAG_TAR_INFO_2         2

/* long long format */
#if __x86_64 || __ppc64 || __sparc64
#  define LL_FORMAT "ld"
#else
#  define LL_FORMAT "lld"
#endif
