/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.DummyKeyPairGenerator;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;

public abstract class KeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final String KEY_PAIR_GENERATOR = "KeyPairGenerator";
    Provider provider;
    private String algorithm;

    protected KeyPairGenerator(String algorithm) {
        this.algorithm = algorithm;
        this.provider = null;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static KeyPairGenerator getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        for (int i = 0; i < p.length; ++i) {
            try {
                return KeyPairGenerator.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static KeyPairGenerator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return KeyPairGenerator.getInstance(algorithm, p);
    }

    public static KeyPairGenerator getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("Illegal provider");
        }
        Object o = null;
        try {
            o = Engine.getInstance(KEY_PAIR_GENERATOR, algorithm, provider);
        }
        catch (InvocationTargetException ite) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        KeyPairGenerator result = null;
        if (o instanceof KeyPairGeneratorSpi) {
            result = new DummyKeyPairGenerator((KeyPairGeneratorSpi)o, algorithm);
        } else if (o instanceof KeyPairGenerator) {
            result = (KeyPairGenerator)o;
            result.algorithm = algorithm;
        }
        result.provider = provider;
        return result;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void initialize(int keysize) {
        this.initialize(keysize, new SecureRandom());
    }

    public void initialize(int keysize, SecureRandom random) {
        this.initialize(keysize, random);
    }

    public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.initialize(params, new SecureRandom());
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        super.initialize(params, random);
    }

    public final KeyPair genKeyPair() {
        try {
            return KeyPairGenerator.getInstance("DSA", "GNU").generateKeyPair();
        }
        catch (Exception e) {
            System.err.println("genKeyPair failed: " + e);
            e.printStackTrace();
            return null;
        }
    }

    public KeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

