.\" $XFree86: xc/programs/Xserver/hw/xfree86/input/mutouch/mutouch.man,v 1.1 2001/01/24 00:06:37 dawes Exp $
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH UR98 __drivermansuffix__ __vendorversion__
.SH NAME
UR-98 \- UR98 (TR88L803) head tracker driver
.SH SYNOPSIS
.B "Section \*qInputDevice\*q"
.br
.BI "  Identifier \*q" idevname \*q
.br
.B  "  Driver \*qUR-98\*q"
.br
.BI "  Option \*qDevice\*q   \*q" devpath \*q
.br
\ \ ...
.br
.B EndSection
.SH DESCRIPTION
.B UR-98
is an __xservername__ input driver for the Union Reality UR-F98 headtracker.
.PP
The
.B UR-98
driver functions as a pointer input device, and can be used either as an
additional input device or as the X server's core pointer. The driver
provides support for the three axes, throttle and four buttons of the
controller. If mapped as the core pointer the headtracker provides
headtracking to try and place the mouse cursor where you look. As a
secondary input device the unit can be used for gaming, for example to
provide the look up/down and the turn in quake, and with the Z axis bound 
to ack/forward to provide movement control.
.PP
The default mapping maps left-right movement to X, up-down movement to Y and
near/far movement to the Z axis. The throttle is mapped as the fourth axis
by default but can also be mapped as button 5.
.PP
For use in "head only" mode the Z axis can be mapped as a button. This
allows the user to select objects with head/neck movement alone but takes some
practice to use well.
.PP
.SH SUPPORTED HARDWARE
Union Reality UR-98. While this is a joystick driver the behaviour is
absolute so this driver is not useful for true joystick interfaces.
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details and for options that can be used with all input drivers.  This
section only covers configuration details specific to this driver.
.PP
The following driver
.B options
are supported
.TP
.BI "Option \*qMinX\*q \*q" integer \*q
Set the left hand X value from the headgear, for calibration.
.TP
.BI "Option \*qMaxX\*q \*q" integer \*q
Set the right hand X value from the headgear, for calibration.
.TP
.BI "Option \*qMinY\*q \*q" integer \*q
Set the top Y value from the headgear, for calibration.
.TP
.BI "Option \*qMaxY\*q \*q" integer \*q
Set the bottom Y value from the headgear, for calibration.
.TP
.BI "Option \*qMinZ\*q \*q" integer \*q
Set the nearest Z value from the headgear, for calibration.
.TP
.BI "Option \*qMaxZ\*q \*q" integer \*q
Set the furthest Z value from the headgear, for calibration.
.TP
.BI "Option \*qMinT\*q \*q" integer \*q
Set the low throttle value from the headgear, for calibration.
.TP
.BI "Option \*qMaxT\*q \*q" integer \*q
Set the high throttle value from the headgear, for calibration.
.TP
.BI "Option \*qScreen\*q \*q" integer \*q
The screen to attach to the headgear when running with multiple screens. 
The default is screen 0.
.TP
.BI "Option \*qDevice\*q \*q" string \*q
The joystick port that is attached to the headgear interface. This is
usually /dev/input/js0. The digital port is not supported due to lack of
documentation.
.TP
.BI "Option \*qDeviceName\*q \*q" string \*q
Set the X11 device name for the headgear. This defaults to HEAD.
.TP
.BI "Option \*qPortraitMode\*q \*q" string \*q
Set the display orientation. The default is "landscape" but you can rotate
the screen clockwise ("portrait") or anticlockwise ("portraitCCW").
.TP
.BI "Option \*qSwapXY\*q \*q" boolean \*q
Swap the X and Y values on the display. The default is false.
.TP
.BI "Option \*qButton5\*q \*q" boolean \*q
Map the throttle as a button instead of axis 4. For some gaming applications
this can be more useful. The default is to map the throttle as axis 4.
.TP
.BI "Option \*qHeadButton\*q \*q" boolean \*q
Map the Z axis as button 1. This defaults to false.
.TP
.BI "Option \*qHeadThresh\*q \*q" boolean \*q
Set the distance that is held to be mouse down.
.TP
.BI "Option \*qHeadLock\*q \*q" boolean \*q
Set the range of depth around the mouse down point where mouse x and y
movement is locked out. Set to zero to disable.
.SH "BUGS"
The "HeadButton" option is currently not implemented.
.PP
The hardware or kernel driver has some idiosyncracies. Notably on
kernel initialization the interface occasionally gets into a state where the 
readings rapidly cycle left-right-left-right or top-bottom-top-bottom.
In those cases it seems to be neccessary to unload the driver, unplug,
replug and reload the joystick drivers. Once it initializes sanely it 
remains sane.
.PP
If the device refuses to work check the gray/black cables are plugged into
the right ports on the unit. Be careful about this as crossing the cables
can lead to the device failing with a nasty burning electronics smell. The
author writes from direct experience.
.PP
This driver is currently Linux specific.
.PP
.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), xorgconfig(__appmansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__).
.SH AUTHORS
Authors include...
 Alan Cox
