/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2002 by Stanislav Visnovsky
                            <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#ifndef GETTEXTIMPORTPLUGIN_H
#define GETTEXTIMPORTPLUGIN_H

#include <catalogfileplugin.h>

#include <qstringlist.h>

class KURL;
class QFile;
class QTextCodec;

/* ****************************************************************************
  The class for importing GNU gettext PO files. As an extra information,
  it stores the list of all obsolete entries.
**************************************************************************** */

class GettextImportPlugin: public KBabel::CatalogImportPlugin
{
public:
    GettextImportPlugin(QObject* parent, const char* name, const QStringList &);
    virtual KBabel::ConversionStatus load(const QString& file, const QString& mimetype);
    virtual const QString id() { return "GNU gettext"; }

private:
    QTextCodec* codecForFile(QFile& file, bool* hadCodec);
    KBabel::ConversionStatus readHeader(QTextStream& stream);
    KBabel::ConversionStatus readEntry(QTextStream& stream);
    
    // description of the last read entry
    QStringList _msgid;
    QStringList _msgstr;
    QString _comment;
    bool _gettextPluralForm;
    bool _obsolete;
};

#endif
