
  

#include <qcstring.h>
#include <qimage.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <qcanvas.h>
#include "qcanvassprite_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

QCanvasSpriteImp::QCanvasSpriteImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

QCanvasSpriteImp::~QCanvasSpriteImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void QCanvasSpriteImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasSpriteImp *meth = new QCanvasSpriteImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


    //
    // Define the enum constants
    //
    struct EnumValue {
	const char *id;
	int val;
    };

    EnumValue enums[] = {

        // enum FrameAnimationType
        { "Cycle", QCanvasSprite::Cycle },
        { "Oscillate", QCanvasSprite::Oscillate },
	{ 0, 0 }
    };

    int enumidx = 0;
    while( enums[enumidx].id ) {
        object.put( exec, enums[enumidx].id, KJS::Number(enums[enumidx].val), KJS::ReadOnly );
        ++enumidx;
    }

}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void QCanvasSpriteImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_setSequence_2, "setSequence" },
        { Method_move_4, "move" },
        { Method_move_5, "move" },
        { Method_setFrame_6, "setFrame" },
        { Method_setFrameAnimation_7, "setFrameAnimation" },
        { Method_frame_8, "frame" },
        { Method_frameCount_9, "frameCount" },
        { Method_rtti_10, "rtti" },
        { Method_collidesWith_11, "collidesWith" },
        { Method_boundingRect_12, "boundingRect" },
        { Method_width_13, "width" },
        { Method_height_14, "height" },
        { Method_leftEdge_15, "leftEdge" },
        { Method_topEdge_16, "topEdge" },
        { Method_rightEdge_17, "rightEdge" },
        { Method_bottomEdge_18, "bottomEdge" },
        { Method_leftEdge_19, "leftEdge" },
        { Method_topEdge_20, "topEdge" },
        { Method_rightEdge_21, "rightEdge" },
        { Method_bottomEdge_22, "bottomEdge" },
        { Method_image_23, "image" },
        { Method_imageAdvanced_24, "imageAdvanced" },
        { Method_image_25, "image" },
        { Method_advance_26, "advance" },
        { Method_draw_27, "draw" },
	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasSpriteImp *meth = new QCanvasSpriteImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a QCanvasSprite pointer from an Object.
 */
QCanvasSprite *QCanvasSpriteImp::toQCanvasSprite( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        QObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<QCanvasSprite *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "QCanvasSprite" )
        return 0;

    return (QCanvasSprite *)( op->toVoidStar() );
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object QCanvasSpriteImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvasSprite_1:
             return QCanvasSprite_1( exec, args );
             break;
    
         default:
             break;
    }

    QString msg = i18n("QCanvasSpriteCons has no constructor with id '%1'.").arg(id);
    KJS::Object err = KJS::Error::create( exec, KJS::ReferenceError, msg.utf8() );
    exec->setException( err );
    return err;
}


KJS::Object QCanvasSpriteImp::QCanvasSprite_1( KJS::ExecState *exec, const KJS::List &args )
{
    
    // Unsupported parameter QCanvasPixmapArray *
    return KJS::Object();
    
    QCanvasPixmapArray * arg0; // Dummy
        
    // Unsupported parameter QCanvas *
    return KJS::Object();
    
    QCanvas * arg1; // Dummy
        

    // We should now create an instance of the QCanvasSprite object

    QCanvasSprite *ret = new QCanvasSprite(
       
          arg0,
          arg1 );

    
}
    
KJS::Value QCanvasSpriteImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = QCanvasSpriteImp::toQCanvasSprite( self );

    switch( id ) {

    case Method_setSequence_2:
        return setSequence_2( exec, self, args );
        break;
    
    case Method_move_4:
        return move_4( exec, self, args );
        break;
    
    case Method_move_5:
        return move_5( exec, self, args );
        break;
    
    case Method_setFrame_6:
        return setFrame_6( exec, self, args );
        break;
    
    case Method_setFrameAnimation_7:
        return setFrameAnimation_7( exec, self, args );
        break;
    
    case Method_frame_8:
        return frame_8( exec, self, args );
        break;
    
    case Method_frameCount_9:
        return frameCount_9( exec, self, args );
        break;
    
    case Method_rtti_10:
        return rtti_10( exec, self, args );
        break;
    
    case Method_collidesWith_11:
        return collidesWith_11( exec, self, args );
        break;
    
    case Method_boundingRect_12:
        return boundingRect_12( exec, self, args );
        break;
    
    case Method_width_13:
        return width_13( exec, self, args );
        break;
    
    case Method_height_14:
        return height_14( exec, self, args );
        break;
    
    case Method_leftEdge_15:
        return leftEdge_15( exec, self, args );
        break;
    
    case Method_topEdge_16:
        return topEdge_16( exec, self, args );
        break;
    
    case Method_rightEdge_17:
        return rightEdge_17( exec, self, args );
        break;
    
    case Method_bottomEdge_18:
        return bottomEdge_18( exec, self, args );
        break;
    
    case Method_leftEdge_19:
        return leftEdge_19( exec, self, args );
        break;
    
    case Method_topEdge_20:
        return topEdge_20( exec, self, args );
        break;
    
    case Method_rightEdge_21:
        return rightEdge_21( exec, self, args );
        break;
    
    case Method_bottomEdge_22:
        return bottomEdge_22( exec, self, args );
        break;
    
    case Method_image_23:
        return image_23( exec, self, args );
        break;
    
    case Method_imageAdvanced_24:
        return imageAdvanced_24( exec, self, args );
        break;
    
    case Method_image_25:
        return image_25( exec, self, args );
        break;
    
    case Method_advance_26:
        return advance_26( exec, self, args );
        break;
    
    case Method_draw_27:
        return draw_27( exec, self, args );
        break;
    
    default:
        break;
    }

    QString msg = i18n( "QCanvasSpriteImp has no method with id '%1'." ).arg( id );
    KJS::Object err = KJS::Error::create( exec, KJS::ReferenceError, msg.utf8() );
    exec->setException( err );
    return err;
}


KJS::Value QCanvasSpriteImp::setSequence_2( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    // Unsupported parameter QCanvasPixmapArray *
    return KJS::Value();
    
    QCanvasPixmapArray * arg0; // Dummy
        
      instance->setSequence( 
       arg0 );
      return KJS::Value(); // Returns void
      
}
    
KJS::Value QCanvasSpriteImp::move_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    double arg0 = extractDouble(exec, args, 0);
        
    double arg1 = extractDouble(exec, args, 1);
        
      instance->move( 
       arg0,
       arg1 );
      return KJS::Value(); // Returns void
      
}
    
KJS::Value QCanvasSpriteImp::move_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    double arg0 = extractDouble(exec, args, 0);
        
    double arg1 = extractDouble(exec, args, 1);
        
    int arg2 = extractInt(exec, args, 2);
        
      instance->move( 
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void
      
}
    
KJS::Value QCanvasSpriteImp::setFrame_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    int arg0 = extractInt(exec, args, 0);
        
      instance->setFrame( 
       arg0 );
      return KJS::Value(); // Returns void
      
}
    
KJS::Value QCanvasSpriteImp::setFrameAnimation_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    QCanvasSprite::FrameAnimationType arg0; // TODO (hack for QCanvasSprite)
        
    int arg1 = extractInt(exec, args, 1);
        
    int arg2 = extractInt(exec, args, 2);
        
      instance->setFrameAnimation( 
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void
      
}
    
KJS::Value QCanvasSpriteImp::frame_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      int ret;
      ret = instance->frame(  );
      return KJS::Number( ret );
      
}
    
KJS::Value QCanvasSpriteImp::frameCount_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      int ret;
      ret = instance->frameCount(  );
      return KJS::Number( ret );
      
}
    
KJS::Value QCanvasSpriteImp::rtti_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      int ret;
      ret = instance->rtti(  );
      return KJS::Number( ret );
      
}
    
KJS::Value QCanvasSpriteImp::collidesWith_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    // Unsupported parameter const QCanvasItem *
    return KJS::Value();
    
    const QCanvasItem * arg0; // Dummy
        
      bool ret;
      ret = instance->collidesWith( 
       arg0 );
      return KJS::Boolean( ret );
      
}
    
KJS::Value QCanvasSpriteImp::boundingRect_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    QRect ret;
      ret = instance->boundingRect(  );

       return convertToValue( exec, ret );
      
}
    
KJS::Value QCanvasSpriteImp::width_13( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      int ret;
      ret = instance->width(  );
      return KJS::Number( ret );
      
}
    
KJS::Value QCanvasSpriteImp::height_14( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      int ret;
      ret = instance->height(  );
      return KJS::Number( ret );
      
}
    
KJS::Value QCanvasSpriteImp::leftEdge_15( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      int ret;
      ret = instance->leftEdge(  );
      return KJS::Number( ret );
      
}
    
KJS::Value QCanvasSpriteImp::topEdge_16( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      int ret;
      ret = instance->topEdge(  );
      return KJS::Number( ret );
      
}
    
KJS::Value QCanvasSpriteImp::rightEdge_17( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      int ret;
      ret = instance->rightEdge(  );
      return KJS::Number( ret );
      
}
    
KJS::Value QCanvasSpriteImp::bottomEdge_18( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      int ret;
      ret = instance->bottomEdge(  );
      return KJS::Number( ret );
      
}
    
KJS::Value QCanvasSpriteImp::leftEdge_19( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    int arg0 = extractInt(exec, args, 0);
        
      int ret;
      ret = instance->leftEdge( 
       arg0 );
      return KJS::Number( ret );
      
}
    
KJS::Value QCanvasSpriteImp::topEdge_20( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    int arg0 = extractInt(exec, args, 0);
        
      int ret;
      ret = instance->topEdge( 
       arg0 );
      return KJS::Number( ret );
      
}
    
KJS::Value QCanvasSpriteImp::rightEdge_21( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    int arg0 = extractInt(exec, args, 0);
        
      int ret;
      ret = instance->rightEdge( 
       arg0 );
      return KJS::Number( ret );
      
}
    
KJS::Value QCanvasSpriteImp::bottomEdge_22( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    int arg0 = extractInt(exec, args, 0);
        
      int ret;
      ret = instance->bottomEdge( 
       arg0 );
      return KJS::Number( ret );
      
}
    
KJS::Value QCanvasSpriteImp::image_23( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      instance->image(  );
      return KJS::Value(); // Returns 'QCanvasPixmap *'
      
}
    
KJS::Value QCanvasSpriteImp::imageAdvanced_24( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      instance->imageAdvanced(  );
      return KJS::Value(); // Returns 'QCanvasPixmap *'
      
}
    
KJS::Value QCanvasSpriteImp::image_25( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    int arg0 = extractInt(exec, args, 0);
        
      instance->image( 
       arg0 );
      return KJS::Value(); // Returns 'QCanvasPixmap *'
      
}
    
KJS::Value QCanvasSpriteImp::advance_26( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    int arg0 = extractInt(exec, args, 0);
        
      instance->advance( 
       arg0 );
      return KJS::Value(); // Returns void
      
}
    
KJS::Value QCanvasSpriteImp::draw_27( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    QPainter arg0; // TODO (hack for qcanvas)
        
      instance->draw( 
       arg0 );
      return KJS::Value(); // Returns void
      
}
    

} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:


