.\" Copyright (c) 1980 The Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)me.7	6.4 (Berkeley) 4/13/90
.\"
.\" Modified for groff by jjc@jclark.com
.hc %
.TH GROFF_ME @MAN7EXT@ "@MDATE@" "Groff Version @VERSION@"
.UC 3
.SH NAME
groff_me \- troff macros for formatting papers
.SH SYNOPSIS
.B "groff \-me"
[ options ]
file ...
.br
.B "groff \-m\ me"
[ options ]
file ...
.SH DESCRIPTION
This manual page describes the GNU version of the \-me macros,
which is part of the groff document formatting system.
This version can be used with both GNU troff and Unix troff.
This package of
.I troff
macro definitions provides a canned formatting
facility for tech%nical papers in various formats.
.PP
The macro requests are defined below.
Many
.I troff
requests are unsafe in conjunction with
this package, however, these requests may be used with
impunity after the first .pp:
.nf
.IP
.ta \w'.sz +n  'u
\&.bp	begin new page
\&.br	break output line here
\&.sp n	insert n spacing lines
\&.ls n	(line spacing) n=1 single, n=2 double space
\&.na	no alignment of right margin
\&.ce n	center next n lines
\&.ul n	underline next n lines
.fi
.PP
Output of the
.I pic,
.I eqn,
.I refer,
and
.I tbl
preprocessors
is acceptable as input.
.SH FILES
@MACRODIR@/me.tmac (a wrapper file for e.tmac)
.br
@MACRODIR@/e.tmac
.SH "SEE ALSO"
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@)
.br
\-me Reference Manual, Eric P. Allman
.br
Writing Papers with Groff Using \-me
.tr &.
.SH REQUESTS
This list is incomplete;
see
.I "The \-me Reference Manual"
for interesting details.
.PP
.ta \w'.eh \'x\'y\'z\'  'u +\w'Initial 'u +\w'Cause 'u
.br
.di x
			\ka
.br
.di
.na
.in \nau
.ti 0
Request	Initial	Cause	Explanation
.ti 0
	Value	Break
.br
.in \nau
.ti 0
\&.(c	-	yes	Begin centered block
.ti 0
\&.(d	-	no	Begin delayed text
.ti 0
\&.(f	-	no	Begin footnote
.ti 0
\&.(l	-	yes	Begin list
.ti 0
\&.(q	-	yes	Begin major quote
.ti 0
\&.(x \fIx\fR	-	no	Begin indexed item in index
.I x
.ti 0
\&.(z	-	no	Begin floating keep
.ti 0
\&.)c	-	yes	End centered block
.ti 0
\&.)d	-	yes	End delayed text
.ti 0
\&.)f	-	yes	End footnote
.ti 0
\&.)l	-	yes	End list
.ti 0
\&.)q	-	yes	End major quote
.ti 0
\&.)x	-	yes	End index item
.ti 0
\&.)z	-	yes	End floating keep
.ti 0
\&.++ \fIm H\fR	-	no	Define paper section.
.I m
defines the part of the paper, and can be
.B C
(chapter),
.B A
(appendix),
.B P
(preliminary, e.g., abstract, table of contents, etc.),
.B B
(bibliography),
.B RC
(chapters renumbered from page one each chapter),
or
.B RA
(appendix renumbered from page one).
.ti 0
\&.+c \fIT\fR	-	yes	Begin chapter (or appendix, etc., as
set by .++).
.I T
is the chapter title.
.ti 0
\&.1c	1	yes	One column format on a new page.
.ti 0
\&.2c	1	yes	Two column format.
.ti 0
\&.EN	-	yes	Space after equation
produced by
.I eqn
or
.IR neqn .
.ti 0
\&.EQ \fIx y\fR	-	yes	Precede equation; break out and
add space.
Equation number is
.IR y .
The optional argument \fIx\fR
may be
.I I
to indent equation (default),
.I L
to left-adjust the equation, or
.I C
to center the equation.
.ti 0
\&.GE	-	yes	End \fIgremlin\fP picture.
.ti 0
\&.GS	-	yes	Begin \fIgremlin\fP picture.
.ti 0
\&.PE	-	yes	End \fIpic\fP picture.
.ti 0
\&.PS	-	yes	Begin \fIpic\fP picture.
.ti 0
\&.TE	-	yes	End table.
.ti 0
\&.TH	-	yes	End heading section of table.
.ti 0
\&.TS \fIx\fR	-	yes	Begin table; if \fIx\fR is
.I H
table has repeated heading.
.ti 0
\&.b \fIx\fR	no	no	Print
.I x
in boldface; if no argument switch to boldface.
.ti 0
\&.ba \fI+n\fR	0	yes	Augments the base indent by
.I n.
This indent is used to set the indent on regular text
(like paragraphs).
.ti 0
\&.bc	no	yes	Begin new column
.ti 0
\&.bi \fIx\fR	no	no	Print
.I x
in bold italics (nofill only)
.ti 0
\&.bu	-	yes	Begin bulleted paragraph
.ti 0
\&.bx \fIx\fR	no	no	Print \fIx\fR in a box (nofill only).
.ti 0
\&.ef \fI\'x\'y\'z\'\fR	\'\'\'\'	no	Set even footer to x  y  z
.ti 0
\&.eh \fI\'x\'y\'z\'\fR	\'\'\'\'	no	Set even header to x  y  z
.ti 0
\&.fo \fI\'x\'y\'z\'\fR	\'\'\'\'	no	Set footer to x  y  z
.ti 0
\&.hx	-	no	Suppress headers and footers on next page.
.ti 0
\&.he \fI\'x\'y\'z\'\fR	\'\'\'\'	no	Set header to x  y  z
.ti 0
\&.hl	-	yes	Draw a horizontal line
.ti 0
\&.i \fIx\fR	no	no	Italicize
.I x;
if
.I x
missing, italic text follows.
.ti 0
\&.ip \fIx y\fR	no	yes	Start indented paragraph,
with hanging tag
.IR x .
Indentation is
.I y
ens (default 5).
.ti 0
\&.lp	yes	yes	Start left-blocked paragraph.
.ti 0
\&.np	1	yes	Start numbered paragraph.
.ti 0
\&.of \fI\'x\'y\'z\'\fR	\'\'\'\'	no	Set odd footer to x  y  z
.ti 0
\&.oh \fI\'x\'y\'z\'\fR	\'\'\'\'	no	Set odd header to x  y  z
.ti 0
\&.pd	-	yes	Print delayed text.
.ti 0
\&.pp	no	yes	Begin paragraph.
First line indented.
.ti 0
\&.r	yes	no	Roman text follows.
.ti 0
\&.re	-	no	Reset tabs to default values.
.ti 0
\&.sh \fIn x\fR	-	yes	Section head follows,
font automatically bold.
.I n
is level of section,
.I x
is title of section.
.ti 0
\&.sk	no	no	Leave the next page blank.
Only one page is remembered ahead.
.ti 0
\&.sm \fIx\fR	-	no	Set
.I x
in a smaller pointsize.
.ti 0
\&.sz \fI+n\fR	10p	no	Augment the point size by
.I n
points.
.ti 0
\&.tp	no	yes	Begin title page.
.ti 0
\&.u \fIx\fR	-	no	Underline argument (even in \fItroff\fR).
(Nofill only).
.ti 0
\&.uh	-	yes	Like .sh but unnumbered.
.ti 0
\&.xp \fIx\fR	-	no	Print index
.I x.
.ad
.
.\" Local Variables:
.\" mode: nroff
.\" End:
