/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * callbacks_mainwindow.c - callbacks for the main window
 *
 * these are callbacks not part of the menu, qsoframe, toolbar or list.
 */

#include <gtk/gtk.h>

#include "callbacks_mainwindow.h"
#include "gui_savedialog.h"
#include "support.h"
#include "types.h"
#include "utils.h"
#include "types.h"
#include "log.h"
#if WANT_HAMLIB
#	include <hamlib/rig.h>
#	include "hamlib-utils.h"
#endif

extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern preferencestype preferences;
extern statetype state;
extern GList *logwindowlist;

/* capture the delete event and display a warning in case the log
 * has not been saved */
gboolean
on_mainwindow_delete_event (GtkWidget * widget, GdkEvent * event,
					gpointer user_data)
{
	GtkWidget *savedialog;
	gint i;
	logtype *logwindow;
	gboolean logchanged = FALSE;

	for (i = 0; i < g_list_length (logwindowlist); i++)
		{
			logwindow = g_list_nth_data (logwindowlist, i);
			if (logwindow->logchanged) logchanged = TRUE;
		}

	if (logchanged)
		{
			savedialog = create_savedialog ();
			gtk_widget_set_sensitive (mainwindow, 0);
			gtk_widget_show (savedialog);
			return (TRUE);
		}
	else
		{
			save_windowsize_and_cleanup ();
			gtk_main_quit ();
			return (FALSE);
		}
}

void
on_mainnotebook_switch_page (GtkNotebook * notebook, GtkNotebookPage * page,
					 gint page_num, gpointer user_data)
{
	logtype *logwindow = NULL;

	while (page_num >= 0)
		{
			logwindow = g_list_nth_data (logwindowlist, page_num);
			if (logwindow) break;
			page_num--;
		}
	if (logwindow) set_qsoframe (logwindow);
}
