/*
 * Dfinition du menu de fond pour WindowMaker
 * 
 * La syntaxe est:
 *
 * <Titre> [SHORTCUT <Raccourci>] <Commande> <Paramtres>
 *
 * <Titre> est une chaine de charactres qui reprsente un titre. Il doit
 *         tre entre guillemets si il y a des espaces.
 *
 * SHORTCUT spcifie un raccourci pour une entre dans le menu. <Raccourci>
 * a la mme syntaxe que les options pour les raccourcis clavier dans le
 * fichier $HOME/GNUstep/Defaults/WindowMaker, comme par example RootMenuKey ou
 * encore MiniaturizeKey.
 *
 * Il n'est pas possible de spcifier un raccourci pour une entre MENU
 * ou OPEN_MENU.
 *
 * <Commande> une des commandes valides:
 *
 *	MENU			    Commence une dfinition de (sous)menu
 *
 *	END			    Fin d'une dfinition de (sous)menu
 *
 *	OPEN_MENU		    Ouvre un menu depuis un fichier, un "pipe"
 *				    ou le contenu d'un ou plusieurs rpertoires
 *				    et eventuellement peut etre prcd d'une
 *				    commande.
 *
 *	WORKSPACE_MENU		    Ajoute un sous menu pour les oprations
 *				    sur les bureaux. Il ne peut y
 *				    avoir qu'un seul WORKSPACE_MENU.
 *
 *	EXEC			    Execute un programme externe
 *
 *	EXIT			    Quitte le gestionnaire de fentres
 *
 *	RESTART	[<window manager>]  Redmarre WindowMaker ou dmarre un
 *				    autre gestionnaire de fentres
 *
 *	REFRESH			    Retrace l'cran
 *
 *	ARRANGE_ICONS		    Arrange les icnes sur le bureau
 *
 *	SHUTDOWN		    Tue tout les clients ( et termine la
 *				    session X Window)
 *
 *	SHOW_ALL		    Montre toutes les fentres sur le bureau
 *
 *	HIDE_OTHERS		    Cache toutes les fentres sur le 
 *				    bureau qui sont en arrire plan
 *
 *	SAVE_SESSION		    Sauve la l'tat courant du bureau, cela
 *				    inclus toute les applications en marche,
 *				    tout leur indices (geometrie, position
 *				    sur l'cran, le bureau sur
 *				    lequel elle sont, si elles ont ete lances
 *				    par le "dock" ou le "clip", si elles
 *				    etaient minimises, ombres ou caches).
 *				    De plus, le bureau actuel
 *				    sera aussi sauv. Tout sera remis dans
 *				    cet tat a chaque dmarrage de
 *				    WindowMaker jusqu'au prochain usage de
 *				    SAVE_SESSION ou CLEAR_SESSION. Si
 *				    "SaveSessionOnExit" est gal  "Yes"
 *				    dans le fichier de domaine de
 *				    WindowMaker, alors la sauvegarde est
 *				    automatiquement faite a chaque fin de
 *				    session, abandonnant toute SAVE_SESSION
 *				    ou CLEAR_SESSION antrieure (Voir plus
 *				    bas).
 *
 *	CLEAR_SESSION		    Efface la sauvegarde de toute session
 *				    antrieure. Ceci n'aura aucun effet si
 *				    "SaveSessionOnExit" est gal  "Yes".
 *
 *	INFO_PANEL		    Affiche le panneau d'informations sur 
 *				    WindowMaker.
 *
 *	LEGAL_PANEL		    Affiche le panneau d'informations sur
 *				    le statut legal de WindowMaker.
 *
 * Syntaxe d'OPEN_MENU:
 *
 * 1. Utilisation d'un fichier de menu.
 * 	/ Ouvre "fichier.menu" (celui-ci doit contenir un fichier de menu
 *	/ valide) et l'insre  la position courante.
 *
 *   OPEN_MENU fichier.menu
 *
 * 2. Utilisation de "pipes".
 *	/ Ouvre une commande et utilise sa sortie standard pour construire
 *	/ un menu (la sortie standard de la commande doit tre une
 *	/ description de menu valide). L'espace entre '|' est optionel.
 *
 *   OPEN_MENU | commande
 *
 * 3. Utilisation de rpertoires.
 *	/ Ouvre un ou plusieurs rpertoires et construit un menu avec tout
 *	/ les sous rpertoires et les fichiers xcutables a l'intrieur et
 *	/ les classe dans l'ordre alphabtique.
 *
 *   OPEN_MENU /un/rpertoire [/un/autre/reprtoire ...]
 *
 * 4. Utilisation de rpertoires avec une commande.
 *	/ Ouvre un ou plusieurs rpertoires et construit un menu avec tout
 *	/ les sous rpertoires et les fichiers lisibles a l'intrieur et
 *	/ les classe dans l'ordre alphabtique, prcdant chacun d'eux
 *	/ d'une commande.
 *
 *   OPEN_MENU /un/rpertoire [/un/autre/rpertoire ...] WITH commande -option
 *
 *   Options:
 *           -noext   retirer tout ce qui se trouve aprs le dernier point
 *                    dans le nom de fichier.
 *
 * <Parametre> est le programme a xcuter.
 *
 * ** Options pour la ligne de commande aprs EXEC:
 *
 * %s		        substituer avec la slection courante
 * %a(titre[,message])	ouvre une boite de dialogue avec un message et fait la
 *		        substitution avec ce que vous avez tap
 * %w		        substituer par la "XID" de la fentre en avant plan
 *                      courante
 *
 * Vous pouvez outrepasser des charactres spciaux (comme % et ") avec le
 * charactre \
 *
 * ex: xterm -T "\"Hello World\""
 *
 * Vous pouvez aussi utiliser des squences "escape", comme \n
 *
 * Chaque dclaration de MENU doit avoir sa dclaration END  la fin.
 *
 * Exemple:
 *
 * "Test" MENU
 *	"XTerm" EXEC xterm
 *		/ Cre un sous menu avec le contenu de /usr/openwin/bin
 *	"Applications XView" OPEN_MENU "/usr/openwin/bin"
 *		/ Quelques applications X11 dans diffrents rpertoires
 *	"Applications X11" OPEN_MENU /usr/X11/bin $HOME/bin/X11
 *		/ Dfinir quelques images de fond
 *	"Fond d'cran" OPEN_MENU $HOME/images /usr/share/images WITH wmsetbg -u -t
 *		/ Insre le fichier "style.menu" dans cette entre
 *	"Style" OPEN_MENU style.menu
 * "Test" END
 */

#include "wmmacros"

"Applications" MENU
	"Informations" MENU
		"Panneau d'informations" INFO_PANEL
		"Panneau d'informations lgales" LEGAL_PANEL
		"Console systme" EXEC xconsole
		"Charge systme" SHEXEC xosview || xload
		"Liste des processus" EXEC xterm -e top
		"Butineur d'aide" EXEC xman
	"Informations" END
	"Dmarrer..." SHEXEC %a(Dmarrer,Tapez une commande  dmarrer:)
	"Terminal X" EXEC xterm -sb
	"Rxvt" EXEC rxvt -bg black -fg white -fn fixed
	"Bureaux" WORKSPACE_MENU
	"Applications" MENU
		"Graphismes" MENU
			"Gimp" SHEXEC gimp >/dev/null
			"XV" EXEC xv
			"XPaint" EXEC xpaint
			"XFig" EXEC xfig
		"Graphismes" END
		"Xfm" EXEC xfm
		"OffiX Files" EXEC files
		"LyX" EXEC lyx
		"Netscape" EXEC netscape
		"Ghostview" EXEC ghostview %a(Entrez un fichier)
		"Acrobat" EXEC /usr/local/Acrobat3/bin/acroread %a(Acrobat,Entrez un fichier PDF)
		"TkDesk" EXEC tkdesk
	"Applications" END
	"Editeurs" MENU
		"XFte" EXEC xfte
		"XEmacs" SHEXEC xemacs || emacs
		"XJed" EXEC xjed
		"NEdit" EXEC nedit
		"Xedit" EXEC xedit
		"VI" EXEC xterm -e vi
	"Editeurs" END
	"Divers" MENU
		"Xmcd" SHEXEC xmcd 2> /dev/null
		"Xplaycd" EXEC xplaycd
		"Xmixer" EXEC xmixer
	"Divers" END
	"Utilitaires" MENU
		"Calculatrice" EXEC xcalc
		"Proprits de la fentre" SHEXEC xprop | xmessage -center -title 'xprop' -file -
		"Slecteur de polices" EXEC xfontsel
		"Emulateur de terminal" EXEC xminicom
		"Loupe" EXEC xmag
		"Carte des couleurs" EXEC xcmap
		"XKill" EXEC xkill
		"Slections" EXEC xclipboard
	"Utilitaires" END
	
	"Slection" MENU
		"Copier" SHEXEC echo '%s' | wxcopy
		"Envoyer " EXEC xterm -name mail -T "Pine" -e pine %s
		"Naviguer" EXEC netscape %s
		"Rechercher dans le manuel" SHEXEC MANUAL_SEARCH(%s)
	"Slection" END
	
	"Bureau" MENU
		"Cacher les autres fentres" HIDE_OTHERS
		"Montrer toutes les fentres" SHOW_ALL
		"Arranger les icnes" ARRANGE_ICONS
		"Retracer l'cran" REFRESH
		"Vrrouiller" EXEC xlock -allowroot -usefirst
		"Sauver la session" SAVE_SESSION
		"Effacer la session" CLEAR_SESSION
	"Bureaux" END

	"Apparence" MENU
		"Thmes" OPEN_MENU -noext THEMES_DIR $HOME/GNUstep/Library/WindowMaker/Themes WITH setstyle
		"Styles" OPEN_MENU -noext STYLES_DIR $HOME/GNUstep/Library/WindowMaker/Styles WITH setstyle
		"Jeu d'icnes" OPEN_MENU -noext ICON_SETS_DIR $HOME/GNUstep/Library/WindowMaker/IconSets WITH seticons
		"Fond d'cran" MENU
			"Unifi" MENU
				"Noir" WS_BACK '(solid, black)'
				"Bleu" WS_BACK '(solid, "#505075")'
				"Indigo" WS_BACK '(solid, "#243e6c")'
				"Bleu fonc" WS_BACK '(solid, "#224477")'
				"Violet" WS_BACK '(solid, "#554466")'
				"Blanc crme" WS_BACK '(solid, "wheat4")'
				"Gris fonc" WS_BACK '(solid, "#333340")'
				"Bordeaux" WS_BACK '(solid, "#400020")'
			"Unifi" END
			"Degrad" MENU
				"Coucher de Soleil" WS_BACK '(mvgradient, deepskyblue4, black, deepskyblue4, tomato4)'
				"Ciel" WS_BACK '(vgradient, blue4, white)'
                                "Dgrads de Bleu" WS_BACK '(vgradient, "#7080a5", "#101020")'
				"Dgrads d'Indigo" WS_BACK '(vgradient, "#746ebc", "#242e4c")'
				"Dgrads de Violet" WS_BACK '(vgradient, "#654c66", "#151426")'
				"Dgrads de Beige" WS_BACK '(vgradient, "#a09060", "#302010")'
				"Dgrads de Gris" WS_BACK '(vgradient, "#636380", "#131318")'
				"Dgrads de Bordeau" WS_BACK '(vgradient, "#600040", "#180010")'
			"Degrad" END
			"Images" OPEN_MENU -noext BACKGROUNDS_DIR $HOME/GNUstep/Library/WindowMaker/Backgrounds WITH wmsetbg -u -t
		"Fond d'cran" END
		"Sauver le thme" SHEXEC getstyle -t $HOME/GNUstep/Library/WindowMaker/Themes/"%a(Nom du thme,Entrez un nom de fichier:)"
		"Sauver le jeu d'icnes" SHEXEC geticonset $HOME/GNUstep/Library/WindowMaker/IconSets/"%a(Nom du jeu d'icnes,Entrez un nom de fichier:)"
	"Apparence" END

	"Quitter" MENU
		"Redmarrer" RESTART
		"Dmarrer AfterStep" RESTART afterstep
		"Quitter..." EXIT
		"Tuer la session..." SHUTDOWN
	"Quitter" END
"Applications" END
