#!/bin/sh
# finish up the installation
# this script should be executed using the sudo command
# this file is copied to SDL_image.post_install and SDL_image.post_upgrade
# inside the .pkg bundle
echo "Running post-install script"
umask 022

# change LIBNAME for the different SDL libraries
# the name cannot have spaces in it
LIBNAME=SDL_image

ROOT=/Developer/Documentation/SDL
USER=`basename ~`

echo "User is \"$USER\""

echo "Moving $LIBNAME.framework to ~/Library/Frameworks"
# move SDL to its proper home, so the target stationary works
sudo -u $USER mkdir -p ~/Library/Frameworks
sudo -u $USER /Developer/Tools/CpMac -r $ROOT/$LIBNAME.framework ~/Library/Frameworks
rm -rf $ROOT/LIBNAME.framework

echo "Precompiling Header"
# precompile header for speedier compiles
/usr/bin/cc -I $HOME/Library/Frameworks/SDL.framework/Headers -precomp ~/Library/Frameworks/$LIBNAME.framework/Headers/$LIBNAME.h -o ~/Library/Frameworks/$LIBNAME.framework/Headers/$LIBNAME.p
