/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2003 by Andreas Zehender
    email                : zehender@kde.org
    copyright            : (C) 2003 by Luis Carvalho
    email                : lpassos@oninetspeed.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#include "pmobjectlibrarysettings.h"

#include "pmlibrarymanager.h"
#include "pmlibraryhandle.h"
#include "pmlibraryhandleedit.h"
#include "pmdebug.h"

#include <qlayout.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <kstandarddirs.h>

PMObjectLibrarySettings::PMObjectLibrarySettings( QWidget* parent, const char* name )
      : PMSettingsDialogPage( parent, name )
{
   QVBoxLayout* vlayout = new QVBoxLayout( this, 0, KDialog::spacingHint( ) );

   QGroupBox* gb = new QGroupBox( i18n( "Libraries" ), this );
   vlayout->addWidget( gb );

   QHBoxLayout* hlayout = new QHBoxLayout( gb, KDialog::marginHint( ) + 5, KDialog::spacingHint( ) );
   m_pObjectLibraries = new QListBox( gb );
   connect( m_pObjectLibraries, SIGNAL( selectionChanged( ) ), SLOT( slotObjectLibraryChanged( ) ) );
   hlayout->addWidget( m_pObjectLibraries );
   QVBoxLayout* gvl = new QVBoxLayout( hlayout );
   m_pCreateObjectLibrary = new QPushButton( i18n( "Create" ), gb );
   connect( m_pCreateObjectLibrary, SIGNAL( clicked( ) ), SLOT( slotCreateObjectLibrary( ) ) );
   gvl->addWidget( m_pCreateObjectLibrary );
   m_pModifyObjectLibrary = new QPushButton( i18n( "Modify" ), gb );
   connect( m_pModifyObjectLibrary, SIGNAL( clicked( ) ), SLOT( slotModifyObjectLibrary( ) ) );
   gvl->addWidget( m_pModifyObjectLibrary );
   m_pRemoveObjectLibrary = new QPushButton( i18n( "Remove" ), gb );
   connect( m_pRemoveObjectLibrary, SIGNAL( clicked( ) ), SLOT( slotRemoveObjectLibrary( ) ) );
   gvl->addWidget( m_pRemoveObjectLibrary );
   gvl->addStretch( 1 );

   gb = new QGroupBox( i18n( "Library Details" ), this );
   QGridLayout* grid = new QGridLayout( gb, 3, 2, KDialog::marginHint( ) + 5, KDialog::spacingHint( ) );
   QLabel* lbl = new QLabel( i18n( "Path" ), gb );
   grid->addWidget( lbl, 0, 0 );
   lbl = new QLabel( i18n( "Author" ), gb );
   grid->addWidget( lbl, 1, 0 );
   lbl = new QLabel( i18n( "Description" ), gb );
   grid->addWidget( lbl, 2, 0 );
   m_pLibraryPath = new QLabel( "", gb );
   m_pLibraryAuthor = new QLabel( "", gb );
   m_pLibraryDescription = new QLabel( "", gb );
   grid->addWidget( m_pLibraryPath, 0, 1 );
   grid->addWidget( m_pLibraryAuthor, 1, 1 );
   grid->addWidget( m_pLibraryDescription, 2, 1 );
   grid->setColStretch( 1, 1 );
   vlayout->addWidget( gb );

   vlayout->addStretch( 1 );
}

void PMObjectLibrarySettings::displaySettings( )
{
   m_pObjectLibraries->clear( );
   m_pObjectLibraries->insertStringList( PMLibraryManager::theManager( )->availableLibraries( ) );
}

void PMObjectLibrarySettings::applySettings( )
{
}

bool PMObjectLibrarySettings::validateData( )
{
   return true;
}

void PMObjectLibrarySettings::displayDefaults( )
{
}

void PMObjectLibrarySettings::slotModifyObjectLibrary( )
{
   QString newDir = KFileDialog::getExistingDirectory( QString::null, this );
   if( !newDir.isEmpty( ) )
   {
      QListBoxItem* item = m_pObjectLibraries->findItem( newDir, ExactMatch );
      if( !item )
      {
         m_pObjectLibraries->insertItem( newDir, m_selectionIndex + 1 );
         m_pObjectLibraries->setCurrentItem( m_selectionIndex + 1 );
      }
      else
         KMessageBox::error( this, i18n( "The list of object libraries already contains this library." ) );
   }
}

void PMObjectLibrarySettings::slotRemoveObjectLibrary( )
{
   m_pObjectLibraries->removeItem( m_pObjectLibraries->currentItem( ) );
}

void PMObjectLibrarySettings::slotCreateObjectLibrary( )
{
   PMLibraryHandle h;
   PMLibraryHandleEdit h_dlg( &h, this );
   QString libfilename;
   
   if( h_dlg.exec( ) == QDialog::Accepted )
   {
      libfilename = h.name( );
      h.setPath( locateLocal( "appdata", "library/" ) + libfilename.stripWhiteSpace( ) + "/" );
      // Create the new library
      switch( h.createLibrary( ) )
      {
         case PMLibraryHandle::Ok:
            break;
         case PMLibraryHandle::ExistingDir:
            KMessageBox::error( this, i18n( "The folder already exists." ) );
            break;
         case PMLibraryHandle::CouldNotCreateDir:
            KMessageBox::error( this, i18n( "Could not create the folder." ) );
            break;
         default:
            kdError( PMArea ) << "Unexpected error in slotCreateObjectLibrary." << endl;
      }
   }
}

void PMObjectLibrarySettings::slotObjectLibraryChanged( )
{
   PMLibraryHandle* h = PMLibraryManager::theManager( )->getLibraryHandle( m_pObjectLibraries->currentText( ) );
   if( h )
   {
      m_pLibraryPath->setText( h->path( ) );
      m_pLibraryAuthor->setText( h->author( ) );
      m_pLibraryDescription->setText( h->description( ) );
   }
}
   
#include "pmobjectlibrarysettings.moc"
