/***************************************************************************
                            SimpleJob.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef SIMPLEJOB_H
#define SIMPLEJOB_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/Job.h>

/**

 A simple job (one url and one command).
 This is the base class for all jobs that are scheduled.
 Other jobs are high-level jobs (CopyJob, DeleteJob, FileCopyJob...)
 that manage subjobs but aren't scheduled directly.
     
 @short 
 A simple job (one url and one command).
*/
@class KURL;
@class Slave;

@interface SimpleJob : Job
- initWithURL: (KURL*)url command: (int)command packedArgs: (QByteArray*)packedArgs showProgressInfo: (BOOL)showProgressInfo;
- (void) dealloc;
- (KURL*) url;

/** 
 Abort job.
 This kills all subjobs and deletes the job.

*/
- kill: (BOOL)quietly;
- kill;

/** 
 Abort job.
 Suspends slave to be reused by another job for the same request.
         
*/
- putOnHold;

/** 

 Called by the scheduler when a slave gets to
 work on this job.

*/
- start: (Slave*)slave;

/** 

 Called to detach a slave from a job.

*/
- slaveDone;

/** 

 Slave in use by this job.
         
*/
- (Slave*) slave;

/** 

         
*/
- (int) command;

/** 

 Called on a slave's error.
 Made public for the scheduler.
         
*/
- slotError: (int)arg1 string: (NSString *)arg2;

/** 
 Discard suspended slave.
         
*/
+ removeOnHold;

/** 
 Called when the slave marks the job
 as finished.
         
*/
- slotFinished;

/** 

 Called on a slave's warning.
         
*/
- slotWarning: (NSString *)arg1;

/** 
 Called on a slave's info message.
         
*/
- slotInfoMessage: (NSString *)arg1;

/** 
 Called on a slave's connected signal.
         
*/
- slotConnected;

/** 
 Forward signal from the slave
         
*/
- slotTotalSize: (unsigned long)data_size;

/** 
 Forward signal from the slave
         
*/
- slotProcessedSize: (unsigned long)data_size;

/** 
 Forward signal from the slave
         
*/
- slotSpeed: (unsigned long)bytes_per_second;

/** 
 MetaData from the slave is received.
         
*/
//- slotMetaData: (MetaData*)_metaData;

/** 

         
*/
- slotNeedProgressId;
@end

/** Override these methods in subclasses of SimpleJob to customise event handling behaviour */
@protocol SimpleJobEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
