/***************************************************************************
                            kde_MediaList.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_MEDIALIST
#define KDE_MEDIALIST

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The <code> MediaList </code> interface provides the abstraction of
 an ordered collection of media, without defining or constraining
 how this collection is implemented. All media are lowercase
 strings.

 
 @short *
 The <code> MediaList </code> interface provides the abstraction of
 an ordered collection of media, without defining or constraining
 how this collection is implemented.
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_MediaList * kde_new_MediaList();
kde_MediaList * kde_new_MediaList1(kde_MediaList* other);
void kde_del_MediaList( kde_MediaList* p );

/** *
 The parsable textual representation of the media list. This is a
 comma-separated list of media.

 NO_MODIFICATION_ALLOWED_ERR: Raised if this media list is readonly.
     
*/
kde_DOMString* kde_MediaList_mediaText(kde_MediaList* instPointer);

/** *
 see @ref mediaText
     
*/
void kde_MediaList_setMediaText(kde_MediaList* instPointer,kde_DOMString* value);

/** *
 The number of media in the list. The range of valid media is 0 to length-1 inclusive.
     
*/
unsigned long kde_MediaList_length(kde_MediaList* instPointer);

/** *
 Returns the indexth in the list. If index is greater than or equal to
 the number of media in the list, this returns null.

*/
kde_DOMString* kde_MediaList_item(kde_MediaList* instPointer,unsigned long index);

/** *
 Deletes the medium indicated by oldMedium from the list.

 NOT_FOUND_ERR: Raised if oldMedium is not in the list.
     
*/
void kde_MediaList_deleteMedium(kde_MediaList* instPointer,kde_DOMString* oldMedium);

/** *
 Adds the medium newMedium to the end of the list. If the newMedium is
 already used, it is first removed.

 NO_MODIFICATION_ALLOWED_ERR: Raised if this list is readonly.
     
*/
void kde_MediaList_appendMedium(kde_MediaList* instPointer,kde_DOMString* newMedium);

/** *

     
*/
int kde_MediaList_isNull(kde_MediaList* instPointer);

#ifdef __cplusplus
}
#endif
#endif
