/***************************************************************************
                            kde_KImageEffect.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KIMAGEEFFECT
#define KDE_KIMAGEEFFECT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This class includes various @ref QImage based graphical effects.

 Everything is
 static, so there is no need to create an instance of this class. You can
 just call the static methods. They are encapsulated here merely to provide
 a common namespace.
 
 @short *
 This class includes various @ref QImage based graphical effects.
*/
#define KIMAGEEFFECT_VerticalGradient	0
#define KIMAGEEFFECT_HorizontalGradient	1
#define KIMAGEEFFECT_DiagonalGradient	2
#define KIMAGEEFFECT_CrossDiagonalGradient	3
#define KIMAGEEFFECT_PyramidGradient	4
#define KIMAGEEFFECT_RectangleGradient	5
#define KIMAGEEFFECT_PipeCrossGradient	6
#define KIMAGEEFFECT_EllipticGradient	7
#define KIMAGEEFFECT_Red	0
#define KIMAGEEFFECT_Green	1
#define KIMAGEEFFECT_Blue	2
#define KIMAGEEFFECT_Gray	3
#define KIMAGEEFFECT_All	4
#define KIMAGEEFFECT_NorthLite	0
#define KIMAGEEFFECT_NWLite	1
#define KIMAGEEFFECT_WestLite	2
#define KIMAGEEFFECT_SWLite	3
#define KIMAGEEFFECT_SouthLite	4
#define KIMAGEEFFECT_SELite	5
#define KIMAGEEFFECT_EastLite	6
#define KIMAGEEFFECT_NELite	7
#define KIMAGEEFFECT_Intensity	0
#define KIMAGEEFFECT_Saturation	1
#define KIMAGEEFFECT_HueShift	2
#define KIMAGEEFFECT_Contrast	3
#define KIMAGEEFFECT_UniformNoise	0
#define KIMAGEEFFECT_GaussianNoise	0
#define KIMAGEEFFECT_MultiplicativeGaussianNoise	1
#define KIMAGEEFFECT_ImpulseNoise	2
#define KIMAGEEFFECT_LaplacianNoise	3
#define KIMAGEEFFECT_PoissonNoise	4
#define KIMAGEEFFECT_Rotate90	0
#define KIMAGEEFFECT_Rotate180	1
#define KIMAGEEFFECT_Rotate270	2

/** *
 Create a gradient from color a to color b of the specified type.

*/
#ifdef __cplusplus
extern   "C" {
#endif
qt_QImage * kde_KImageEffect_gradient( qt_QSize * size, qt_QColor * ca, qt_QColor * cb, int type, int ncols);

/** *
 Create an unbalanced gradient.

 An unbalanced gradient is a gradient where the transition from
 color a to color b is not linear, but in this case, exponential.

*/
qt_QImage * kde_KImageEffect_unbalancedGradient( qt_QSize * size, qt_QColor * ca, qt_QColor * cb, int type, int xfactor, int yfactor, int ncols);

/** *
 Blends a color into the destination image, using an opacity
 value for blending one into another. Very fast direct pixel
 manipulation is used.

*/
qt_QImage * kde_KImageEffect_blend( qt_QColor * clr, qt_QImage * dst, float opacity);

/** *
 Blend the src image into the destination image, using an opacity
 value for blending one into another. Very fast direct pixel
 manipulation is used.

*/
qt_QImage * kde_KImageEffect_blend1( qt_QImage * src, qt_QImage * dst, float opacity);

/** *
 Blend the provided image into a background of the indicated color.

*/
qt_QImage * kde_KImageEffect_blend2( qt_QImage * image, float initial_intensity, qt_QColor * bgnd, int eff, int anti_dir);

/** *
 Blend an image into another one, using a gradient type
 for blending from one to another.

*/
qt_QImage * kde_KImageEffect_blend3( qt_QImage * image1, qt_QImage * image2, int gt, int xf, int yf);

/** *
 Blend an image into another one, using a color channel of a
 third image for the decision of blending from one to another.

*/
qt_QImage * kde_KImageEffect_blend4( qt_QImage * image1, qt_QImage * image2, qt_QImage * blendImage, int channel);

/** *
 Blend an image into another one, using alpha in the expected way.

*/
int kde_KImageEffect_blend5( qt_QImage * upper, qt_QImage * lower, qt_QImage * output);

/** *
 Blend an image into another one, using alpha in the expected way and
 over coordinates @p x and @p y with respect to the lower image.
 The output is a QImage which is the @p upper image already blended
 with the @p lower one, so its size will be (in general) the same than
 @p upper instead of the same size than @p lower like the method above.
 In fact, the size of @p output is like upper's one only when it can be
 painted on lower, if there has to be some clipping, output's size will
 be the clipped area and x and y will be set to the correct up-left corner
 where the clipped rectangle begins.
     
*/
int kde_KImageEffect_blend6( int x, int y, qt_QImage * upper, qt_QImage * lower, qt_QImage * output);

/** *
 Blend an image into another one, using alpha in the expected way and
 over coordinates @p x and @p y with respect to the lower image.
 The output is painted in the own @p lower image. This is an optimization
 of the blend method above provided by convenience.
     
*/
int kde_KImageEffect_blendOnLower( int x, int y, qt_QImage * upper, qt_QImage * lower);

/** *
 Modifies the intensity of a pixmap's RGB channel component.

*/
qt_QImage * kde_KImageEffect_channelIntensity( qt_QImage * image, float percent, int channel);

/** *
 Fade an image to a certain background color.

 The number of colors will not be changed.

*/
qt_QImage * kde_KImageEffect_fade( qt_QImage * img, float val, qt_QColor * color);

/** *
 This recolors a pixmap. The most dark color will become color a,
 the most bright one color b, and in between.

*/
qt_QImage * kde_KImageEffect_flatten( qt_QImage * image, qt_QColor * ca, qt_QColor * cb, int ncols);

/** *
 Build a hash on any given @ref QImage

*/
qt_QImage * kde_KImageEffect_hash( qt_QImage * image, int lite, unsigned int spacing);

/** *
 Either brighten or dim the image by a specified percent.
 For example, .50 will modify the colors by 50%.

*/
qt_QImage * kde_KImageEffect_intensity( qt_QImage * image, float percent);

/** *
 Modulate the image with a color channel of another image.

*/
qt_QImage * kde_KImageEffect_modulate( qt_QImage * image, qt_QImage * modImage, int reverse, int type, int factor, int channel);

/** *
 Convert an image to grayscale.

*/
qt_QImage * kde_KImageEffect_toGray( qt_QImage * image, int fast);

/** *
 Desaturate an image evenly.

*/
qt_QImage * kde_KImageEffect_desaturate( qt_QImage * image, float desat);

/** *
 Fast, but low quality contrast of an image. Also see contrastHSV.

*/
qt_QImage * kde_KImageEffect_contrast( qt_QImage * image, int c);

/** *
 Dither an image using Floyd-Steinberg dithering for low-color
 situations.

*/
qt_QImage * kde_KImageEffect_dither( qt_QImage * img, qt_QColor* palette, int size);

/** *
 Calculate the image for a selected image, for instance a selected icon
 on the desktop.

*/
qt_QImage * kde_KImageEffect_selectedImage( qt_QImage * img, qt_QColor * col);

/** *
 High quality, expensive HSV contrast. You can do a faster one by just
 taking a intensity threshold (ie: 128) and incrementing RGB color
 channels above it and decrementing those below it, but this gives much
 better results.

*/
void kde_KImageEffect_contrastHSV( qt_QImage * img, int sharpen);

/** *
 Normalizes the pixel values to span the full range of color values.
 This is a contrast enhancement technique.

*/
void kde_KImageEffect_normalize( qt_QImage * img);

/** *
 Performs histogram equalization on the reference
 image.

*/
void kde_KImageEffect_equalize( qt_QImage * img);

/** *
 Thresholds the reference image. You can also threshold images by using
 ThresholdDither in the various QPixmap/QImage convert methods, but this
 lets you specify a threshold value.

*/
void kde_KImageEffect_threshold( qt_QImage * img, unsigned int value);

/** *
 Produces a 'solarization' effect seen when exposing a photographic
 film to light during the development process.

*/
void kde_KImageEffect_solarize( qt_QImage * img, double factor);

/** *
 Embosses the source image. This involves highlighting the edges
 and applying various other enhancements in order to get a metal
 effect.

*/
qt_QImage * kde_KImageEffect_emboss( qt_QImage * src);

/** *
 Minimizes speckle noise in the source image using the 8 hull
 algorithm.

*/
qt_QImage * kde_KImageEffect_despeckle( qt_QImage * src);

/** *
 Produces a neat little "charcoal" effect.

*/
qt_QImage * kde_KImageEffect_charcoal( qt_QImage * src, double factor);

/** *
 Rotates the image by the specified amount

*/
qt_QImage * kde_KImageEffect_rotate( qt_QImage * src, int r);

/** *
 Scales an image using simple pixel sampling. This does not produce
 nearly as nice a result as QImage::smoothScale(), but has the
 advantage of being much faster - only a few milliseconds.

*/
qt_QImage * kde_KImageEffect_sample( qt_QImage * src, int w, int h);

/** *
 Adds noise to an image.

*/
qt_QImage * kde_KImageEffect_addNoise( qt_QImage * src, int type);

/** *
 Blurs an image by convolving pixel neighborhoods.

*/
qt_QImage * kde_KImageEffect_blur( qt_QImage * src, double factor);

/** *
 Detects edges in an image using pixel neighborhoods and an edge
 detection mask.

*/
qt_QImage * kde_KImageEffect_edge( qt_QImage * src, double factor);

/** *
 Implodes an image by a specified percent.

*/
qt_QImage * kde_KImageEffect_implode( qt_QImage * src, double factor, unsigned int background);

/** *
 Produces an oil painting effect.

*/
qt_QImage * kde_KImageEffect_oilPaint( qt_QImage * src, int radius);

/** *
 Sharpens the pixels in the image using pixel neighborhoods.

*/
qt_QImage * kde_KImageEffect_sharpen( qt_QImage * src, double factor);

/** *
 Randomly displaces pixels.

*/
qt_QImage * kde_KImageEffect_spread( qt_QImage * src, unsigned int amount);

/** *
 Shades the image using a distance light source.

*/
qt_QImage * kde_KImageEffect_shade( qt_QImage * src, int color_shading, double azimuth, double elevation);

/** *
 Swirls the image by a specified amount

*/
qt_QImage * kde_KImageEffect_swirl( qt_QImage * src, double degrees, unsigned int background);

/** *
 Modifies the pixels along a sine wave.

*/
qt_QImage * kde_KImageEffect_wave( qt_QImage * src, double amplitude, double frequency, unsigned int background);

#ifdef __cplusplus
}
#endif
#endif
