// -*- c++ -*-
// $Id: manager.h,v 1.11 2003/01/12 05:03:20 nhasan Exp $

#ifndef MANAGER_H
#define MANAGER_H

#include <qptrlist.h>
#include <qobject.h>
#include <qpen.h>
#include <qbrush.h>
#include <qwidget.h>
#include "ktoolbar.h"
#include "canvas.h"
#include "properties.h"
#include "tool.h"

typedef QPtrList<Tool> ToolList;
class KStatusBar;
class KColorButton;

/**
 * @short Manager Class
 * This class holds all the tools that can operate on a canvas, it
 * ensures that one tool is always active, and responds to signals
 * from the tool palette which control which tool is selected. A
 * tool manager is associated with a single canvas.
 */
class Manager : public QObject
{
  Q_OBJECT
public:
  Manager(Canvas *c);

  inline int currentToolID();
  inline const Tool &currentTool();
  inline const ToolList &toolList();
  void showPropertiesDialog();

  inline void setStatusBar(KStatusBar *);
  inline const QColor &lmbColour();
  inline const QColor &rmbColour();
  void setLMColorButton(KColorButton *cb);
  void setRMColorButton(KColorButton *cb);

public slots:
  void setCurrentTool(int);
  void updateProperties();
  void setLMBcolour(const QColor &);
  void setRMBcolour(const QColor &);

signals:
  void toolChanged(int);
  void modified();

protected:
  void createTools();

private:
  ToolList list;
  Canvas *canvas;
  propertiesDialog *props;
  int toolID;

  QPen p;
  QBrush b;
  QColor lmbCol;
  QColor rmbCol;
  KStatusBar *statusBar;
  KColorButton * lmColorButton;
  KColorButton * rmColorButton;
};


const QColor &
Manager::lmbColour()
{
  return lmbCol;
}

const QColor &
Manager::rmbColour()
{
  return rmbCol;
}

int 
Manager::currentToolID()
{
  return toolID;
}

const Tool & 
Manager::currentTool()
{
  return *list.at(toolID);
}

const ToolList & 
Manager::toolList()
{
  return list;
}

void 
Manager::setStatusBar(KStatusBar *sb)
{
  statusBar = sb;
}

#endif // MANAGER_H
