/* GNU POP3 - a small, fast, and efficient POP3 daemon
   Copyright (C) 1999 Jakob 'sparky' Kaivo <jkaivo@nodomainname.net>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "gnu-pop3d.h"

/* Enters the UPDATE phase and deletes marked messages */

int
pop3_quit (const char *arg)
{
  int i = 0, size = 0, write = 0;
  char buf[80];
  fpos_t *readpos = NULL, *writepos = NULL;

  if (strlen (arg) != 0)
    return ERR_BAD_ARGS;

  if (state == TRANSACTION)
    {
      readpos = malloc (sizeof (fpos_t));
      writepos = malloc (sizeof (fpos_t));
      if (readpos == NULL || writepos == NULL)
	pop3_abquit (ERR_NO_MEM);
      mbox = freopen (mailbox, "r+", mbox);
      if (mbox == NULL)
	return ERR_FILE;
      fgetpos (mbox, writepos);

      if (num_messages == cursor)
	ftruncate (fileno (mbox), size);
      else if (cursor > 0)
	{
	  while (fgets (buf, 80, mbox))
	    {
	      if (!strncmp (buf, "From ", 5))
		{
		  if (pop3_mesg_exist (i) == OK)
		    write = 1;
		  else
		    write = 0;
		  i++;
		}
	      if (write)
		{
		  fgetpos (mbox, readpos);
		  fsetpos (mbox, writepos);
		  fprintf (mbox, "%s", buf);
		  size += strlen (buf);
		  fgetpos (mbox, writepos);
		  fsetpos (mbox, readpos);
		}
	    }
	  ftruncate (fileno (mbox), size);
	}

      pop3_unlock ();
      fclose (mbox);
      free (messages);
      free (readpos);
      free (writepos);
      syslog (LOG_INFO, "Session ended for user: %s", username);
    }
  else
    syslog (LOG_INFO, "Session ended for no user");

  state = UPDATE;
  free (username);
  free (mailbox);
  free (md5shared);

  fprintf (ofile, "+OK\r\n");
  return OK;
}
