//start of PreLh1Decoder.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * PreLh1Decoder.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.InputStream;
import java.lang.Math;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.io.BitInputStream;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;
import jp.gr.java_conf.dangan.util.lha.DynamicHuffman;

//import exceptions
import java.io.IOException;
import java.io.EOFException;
import java.lang.NullPointerException;
import jp.gr.java_conf.dangan.io.NotEnoughBitsException;
import jp.gr.java_conf.dangan.io.BitDataBrokenException;
import jp.gr.java_conf.dangan.util.lha.BadHuffmanTableException;

/**
 * -lh1- 𓀗p PreLzssDecoderB<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: PreLh1Decoder.java,v $
 * Revision 1.1  2002/12/01 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * add to version control
 * [bug fix]
 *     available ̌vZÂ̂CB
 * [maintenance]
 *     \[X
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public class PreLh1Decoder implements PreLzssDecoder{


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  LZSS parameter
    //------------------------------------------------------------------
    //  private static final int DictionarySize
    //  private static final int MaxMatch
    //  private static final int Threshold
    //------------------------------------------------------------------
    /** TCY */
    private static final int DictionarySize = 4096;

    /** őv */
    private static final int MaxMatch       = 60;

    /** ŏv */
    private static final int Threshold      = 3;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  source
    //------------------------------------------------------------------
    //  BitInputStream in
    //------------------------------------------------------------------
    /**
     * -lh1- ̈kf[^ BitInputStream
     */
    BitInputStream in;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  huffman decoder
    //------------------------------------------------------------------
    //  DynamicHuffman huffman
    //  int[] offHiLen
    //  short[] offHiTable
    //  int offHiTableBits
    //------------------------------------------------------------------
    /**
     * codep̓Int}
     */
    DynamicHuffman huffman;

    /**
     * ItZbg̏6bitp 
     * nt}XgB
     */
    int[] offHiLen;

    /**
     * ItZbg̏6bitpe[uB
     */
    short[] offHiTable;

    /**
     * ItZbg̏6bitpe[ûɕKvbitB
     */
    int offHiTableBits;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  backup for mark/reset
    //------------------------------------------------------------------
    //  DynamicHuffman markHuffman
    //------------------------------------------------------------------
    /** huffman ̃obNAbvp */
    DynamicHuffman markHuffman;


    //------------------------------------------------------------------
    //  constructers
    //------------------------------------------------------------------
    //  public PreLh1Decoder( InputStream in )
    //------------------------------------------------------------------
    /**
     * -lh1- 𓀗p PreLzssDecoder \zB
     * 
     * @param in -lh1- ňkꂽf[^̓Xg[
     */
    public PreLh1Decoder( InputStream in ){
        if( in != null ){
            if( in instanceof BitInputStream ){
                this.in         = (BitInputStream)in;
            }else{
                this.in         = new BitInputStream( in );
            }
            this.huffman        = new DynamicHuffman( 314 );
            this.markHuffman    = null;

            this.offHiLen       = PreLh1Decoder.createLenList();
            try{
                this.offHiTable = StaticHuffman.createTable( this.offHiLen );
            }catch( BadHuffmanTableException exception ){
            }
            this.offHiTableBits = Bits.len( this.offHiTable.length - 1 );
        }else{
            throw new NullPointerException( "in" );
        }
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  read
    //------------------------------------------------------------------
    //  public int readCode()
    //  public int readOffset()
    //------------------------------------------------------------------
    /**
     * -lh1- ňkꂽ 
     * 1byte LZSSk̃f[^A
     * ͈kR[ĥvǂݍށB<br>
     * 
     * @return 1byte  k̃f[^́A
     *         kꂽkR[ĥv
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException EndOfStreamɒBꍇ
     */
    public int readCode() throws IOException {
        int node = this.huffman.childNode( DynamicHuffman.ROOT );
        while( 0 <= node ){
            node = this.huffman.childNode( node - ( in.readBoolean() ? 1 : 0 ) );//throws EOFException,IOException
        }
        int code = ~node;
        this.huffman.update( code );
        return code;
    }

    /**
     * -lh1- ňkꂽ
     * LZSSkR[ĥvʒuǂݍށB<br>
     * 
     * @return -lh1- ňkꂽkR[ĥvʒu
     * 
     * @exception IOException  o̓G[ꍇB
     * @exception EOFException f[^r܂łȂ
     *                         \ EndOfStream ɓBꍇB
     * @exception BitDataBrokenException
     *                         f[^r܂łȂ
     *                         \ EndOfStream ɓBA
     *                         ̓o̓G[B  
     * @exception NotEnoughBitsException
     *                         f[^r܂łȂ
     *                         \ EndOfStream ɓBA
     *                         ̓o̓G[B  
     */
    public int readOffset() throws IOException {
        //offHi킷̂ɍŒZ̏ꍇ 0  3bit 
        //offHiTableBits  8bit ҂̍ 5bitB 
        //̂߁A6bitǂݍގ
        //ȃf[^ł peekBits  
        //NotEnoughBitsException 𓊂邱Ƃ͖B
        int offHi = this.offHiTable[ this.in.peekBits( this.offHiTableBits ) ]; //throws NotEnoughBitsException IOException
        this.in.skipBits( this.offHiLen[ offHi ] );                             //throws IOException

        return ( offHi << 6 ) | this.in.readBits( 6 );                          //throws BitDataBrokenException NotEnoughBitsException IOException
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  mark / reset
    //------------------------------------------------------------------
    //  public void mark( int readLimit )
    //  public void reset()
    //  public boolean markSupported()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[݈̌ʒuɃ}[Nݒ肵A
     * reset() \bhŃ}[N_ ǂݍ݈ʒu
     * ߂悤ɂB<br>
     * InputStream  mark() ƈႢAreadLimit Őݒ肵
     * EoCgOɃ}[NʒuɂȂ\
     * 鎖ɒӂ邱ƁB<br>
     * 
     * @param readLimit }[Nʒuɖ߂ẼoCgB
     *                  ̃oCg𒴂ăf[^ǂ
     *                  񂾏ꍇ reset()łȂȂ
     *                  \B<br>
     * 
     * @see PreLzssDecoder#mark(int)
     */
    public void mark( int readLimit ){
        this.in.mark( readLimit * 18 / 8 + 4 );
        this.markHuffman = (DynamicHuffman)this.huffman.clone();
    }

    /**
     * ڑꂽ̓Xg[̓ǂݍ݈ʒuŌ
     * mark() \bhĂяoꂽƂ̈ʒuɐݒ肷B<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void reset() throws IOException {
        //mark()Ȃ reset() 悤ƂꍇA
        //readLimit 𒴂 reset() 悤ƂꍇA
        //ڑꂽ InputStream  markSupported()  false Ԃꍇ
        //BitInputStream  IOException 𓊂B
        this.in.reset();                                                        //throws IOException

        this.huffman = (DynamicHuffman)this.markHuffman.clone();
    }

    /**
     * ڑꂽ̓Xg[ mark()  reset() T|[g邩𓾂B<br>
     * 
     * @return Xg[ mark()  reset() 
     *         T|[gꍇ trueB<br>
     *         T|[gȂꍇ falseB<br>
     */
    public boolean markSupported(){
        return this.in.markSupported();
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public int available()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * ubNɓǂݏoƂ̏oŒoCg𓾂B<br>
     * InputStream  available() ƈႢA
     * ̍ŒoCg͕KۏႳĂȂɒӂ邱ƁB<br>
     * 
     * @return ubNȂœǂݏoŒoCgB<br>
     * 
     * @exception IOException o̓G[ꍇ
     * 
     * @see PreLzssDecoder#available()
     */
    public int available() throws IOException {
        return Math.max( this.in.availableBits() / 18 - 4, 0 );                 //throws IOException
    }

    /**
     * ̃Xg[AgpĂSĂ̎B
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        this.in.close();                                                        //throws IOException

        this.in             = null;
        this.huffman        = null;
        this.markHuffman    = null;

        this.offHiLen       = null;
        this.offHiTable     = null;
        this.offHiTableBits = 0;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.PreLzssDecoder
    //------------------------------------------------------------------
    //  get LZSS parameter
    //------------------------------------------------------------------
    //  public int getDictionarySize()
    //  public int getMaxMatch()
    //  public int getThreshold()
    //------------------------------------------------------------------
    /**
     * -lh1-`LZSS̃TCY𓾂B
     * 
     * @return -lh1-`LZSS̃TCY
     */
    public int getDictionarySize(){
        return PreLh1Decoder.DictionarySize;
    }

    /**
     * -lh1-`LZSS̍őv𓾂B
     * 
     * @return -lh1-`LZSS̍őv
     */
    public int getMaxMatch(){
        return PreLh1Decoder.MaxMatch;
    }

    /**
     * -lh1-`LZSS̈kA񈳏k臒l𓾂B
     * 
     * @return -lh1-`LZSS̈kA񈳏k臒l
     */
    public int getThreshold(){
        return PreLh1Decoder.Threshold;
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  constant huffman tree
    //------------------------------------------------------------------
    //  private static int[] createLenList()
    //------------------------------------------------------------------
    /**
     * -lh1-  offsetfR[hpStaticHuffman
     * nt}Xg𐶐B
     * 
     * @return -lh1-  offsetfR[hpStaticHuffman
     *         nt}Xg
     */
    private static int[] createLenList(){
        final int length = 64;
        final int[] list = { 3, 0x01, 0x04, 0x0C, 0x18, 0x30, 0 };

        int[] LenList = new int[ length ];
        int index = 0;
        int len = list[ index++ ];

        for( int i = 0 ; i < length ; i++ ){
            if( list[index] == i ){
                len++;
                index++;
            }
            LenList[i] = len;
        }
        return LenList;
    }

}
//end of PreLh1Decoder.java
