/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RatNum;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Arithmetic {
    public static final int INT_CODE = 1;
    public static final int LONG_CODE = 2;
    public static final int BIGINTEGER_CODE = 3;
    public static final int INTNUM_CODE = 4;
    public static final int BIGDECIMAL_CODE = 5;
    public static final int RATNUM_CODE = 6;
    public static final int FLOAT_CODE = 7;
    public static final int DOUBLE_CODE = 8;
    public static final int FLONUM_CODE = 9;
    public static final int NUMERIC_CODE = 10;
    public static final IntNum ten_exp_9 = IntNum.make(1000000000);

    public static int classifyValue(Object value) {
        if (value instanceof Numeric) {
            if (value instanceof IntNum) {
                return 4;
            }
            if (value instanceof RatNum) {
                return 6;
            }
            if (value instanceof DFloNum) {
                return 9;
            }
            return 10;
        }
        if (value instanceof Number) {
            if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
                return 1;
            }
            if (value instanceof Long) {
                return 2;
            }
            if (value instanceof Float) {
                return 7;
            }
            if (value instanceof Double) {
                return 8;
            }
            if (value instanceof BigInteger) {
                return 3;
            }
            if (value instanceof BigDecimal) {
                return 5;
            }
            return -1;
        }
        return -1;
    }

    public static int asInt(Object value) {
        return ((Number)value).intValue();
    }

    public static long asLong(Object value) {
        return ((Number)value).longValue();
    }

    public static float asFloat(Object value) {
        return ((Number)value).floatValue();
    }

    public static double asDouble(Object value) {
        return ((Number)value).doubleValue();
    }

    public static BigInteger asBigInteger(Object value) {
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof IntNum) {
            return new BigInteger(value.toString());
        }
        return BigInteger.valueOf(((Number)value).longValue());
    }

    public static IntNum asIntNum(BigDecimal value) {
        return IntNum.valueOf(value.toBigInteger().toString(), 10);
    }

    public static IntNum asIntNum(BigInteger value) {
        return IntNum.valueOf(value.toString(), 10);
    }

    public static IntNum asIntNum(Object value) {
        if (value instanceof IntNum) {
            return (IntNum)value;
        }
        if (value instanceof BigInteger) {
            return IntNum.valueOf(value.toString(), 10);
        }
        if (value instanceof BigDecimal) {
            return Arithmetic.asIntNum((BigDecimal)value);
        }
        return IntNum.make(((Number)value).longValue());
    }

    public static BigDecimal asBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return BigDecimal.valueOf(((Number)value).longValue());
        }
        return new BigDecimal(value.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static RatNum asRatNum(Object value) {
        if (value instanceof RatNum) {
            return (RatNum)value;
        }
        if (value instanceof BigInteger) {
            return IntNum.valueOf(value.toString(), 10);
        }
        if (value instanceof BigDecimal) {
            void var4_4;
            int scale;
            BigDecimal d = (BigDecimal)value;
            RatNum v = IntNum.valueOf(d.unscaledValue().toString(), 10);
            for (scale = d.scale(); scale >= 9; scale -= 9) {
                v = RatNum.divide(v, ten_exp_9);
            }
            while (scale <= -9) {
                v = RatNum.times(v, ten_exp_9);
                scale += 9;
            }
            switch (scale > 0 ? scale : -scale) {
                case 1: {
                    IntNum scaleVal = IntNum.make(10);
                    break;
                }
                case 2: {
                    IntNum scaleVal = IntNum.make(100);
                    break;
                }
                case 3: {
                    IntNum scaleVal = IntNum.make(1000);
                    break;
                }
                case 4: {
                    IntNum scaleVal = IntNum.make(10000);
                    break;
                }
                case 5: {
                    IntNum scaleVal = IntNum.make(100000);
                    break;
                }
                case 6: {
                    IntNum scaleVal = IntNum.make(1000000);
                    break;
                }
                case 7: {
                    IntNum scaleVal = IntNum.make(10000000);
                    break;
                }
                case 8: {
                    IntNum scaleVal = IntNum.make(100000000);
                    break;
                }
                default: {
                    return v;
                }
            }
            if (scale > 0) {
                return RatNum.divide(v, (RatNum)var4_4);
            }
            return RatNum.times(v, (RatNum)var4_4);
        }
        return IntNum.make(((Number)value).longValue());
    }

    public static Numeric asNumeric(Object value) {
        if (!(value instanceof Numeric)) {
            if (value instanceof BigInteger || value instanceof Long || value instanceof Short || value instanceof Byte || value instanceof Integer) {
                return Arithmetic.asIntNum(value);
            }
            if (value instanceof BigDecimal) {
                return Arithmetic.asRatNum(value);
            }
            if (value instanceof Float || value instanceof Double) {
                return new DFloNum(Arithmetic.asDouble(value));
            }
        }
        return (Numeric)value;
    }

    public static String toString(Object number, int radix) {
        int code = Arithmetic.classifyValue(number);
        switch (code) {
            case 1: {
                return Integer.toString(Arithmetic.asInt(number), radix);
            }
            case 2: {
                return Long.toString(Arithmetic.asLong(number), radix);
            }
            case 3: {
                return Arithmetic.asBigInteger(number).toString(radix);
            }
            case 4: {
                return Arithmetic.asIntNum(number).toString(radix);
            }
            case 5: {
                if (radix == 10) {
                    return Arithmetic.asBigDecimal(number).toString();
                }
            }
            case 7: {
                if (radix == 10) {
                    return Float.toString(Arithmetic.asFloat(number));
                }
            }
            case 8: 
            case 9: {
                if (radix != 10) break;
                return Double.toString(Arithmetic.asDouble(number));
            }
        }
        return Arithmetic.asNumeric(number).toString(radix);
    }

    public static Object convert(Object value, int code) {
        switch (code) {
            case 1: {
                if (value instanceof Integer) {
                    return value;
                }
                int i = ((Number)value).intValue();
                return new Integer(i);
            }
            case 2: {
                if (value instanceof Long) {
                    return value;
                }
                long l = ((Number)value).longValue();
                return new Long(l);
            }
            case 3: {
                return Arithmetic.asBigInteger(value);
            }
            case 4: {
                return Arithmetic.asIntNum(value);
            }
            case 5: {
                return Arithmetic.asBigDecimal(value);
            }
            case 6: {
                return Arithmetic.asRatNum(value);
            }
            case 7: {
                if (value instanceof Float) {
                    return value;
                }
                float f = Arithmetic.asFloat(value);
                return new Float(f);
            }
            case 8: {
                if (value instanceof Double) {
                    return value;
                }
                double d = Arithmetic.asDouble(value);
                return new Double(d);
            }
            case 9: {
                if (value instanceof DFloNum) {
                    return value;
                }
                return DFloNum.make(Arithmetic.asDouble(value));
            }
        }
        return (Number)value;
    }
}

