/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AbstractStructure;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public abstract class AbstractStructureWithAttributes
extends AbstractStructure {
    protected AttributeInfo[] attributes;

    public AttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AttributeInfo[] attributeInfoArray) {
        this.attributes = attributeInfoArray;
    }

    public AttributeInfo findAttribute(Class clazz) {
        AttributeInfo attributeInfo = null;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i].getClass() != clazz) continue;
            attributeInfo = this.attributes[i];
            break;
        }
        return attributeInfo;
    }

    protected void readAttributes(DataInput dataInput) throws InvalidByteCodeException, IOException {
        int n = dataInput.readUnsignedShort();
        this.attributes = new AttributeInfo[n];
        for (int i = 0; i < n; ++i) {
            this.attributes[i] = AttributeInfo.createOrSkip(dataInput, this.classFile);
        }
    }

    protected void writeAttributes(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        int n = this.getLength(this.attributes);
        dataOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            if (this.attributes[i] == null) {
                throw new InvalidByteCodeException("attribute " + i + " is null");
            }
            this.attributes[i].write(dataOutput);
        }
    }

    protected int getTotalAttributesLength() {
        int n = 0;
        int n2 = this.getLength(this.attributes);
        for (int i = 0; i < n2; ++i) {
            if (this.attributes[i] == null) continue;
            n += this.attributes[i].getAttributeLength();
        }
        return n;
    }
}

