# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from bumble import at


def test_tokenize_parameters():
    assert at.tokenize_parameters(b'1, 2, 3') == [b'1', b',', b'2', b',', b'3']
    assert at.tokenize_parameters(b'"1, 2, 3"') == [b'1, 2, 3']
    assert at.tokenize_parameters(b'(1, "2, 3")') == [b'(', b'1', b',', b'2, 3', b')']


def test_parse_parameters():
    assert at.parse_parameters(b'1, 2, 3') == [b'1', b'2', b'3']
    assert at.parse_parameters(b'1,, 3') == [b'1', b'', b'3']
    assert at.parse_parameters(b'"1, 2, 3"') == [b'1, 2, 3']
    assert at.parse_parameters(b'1, (2, (3))') == [b'1', [b'2', [b'3']]]
    assert at.parse_parameters(b'1, (2, "3, 4"), 5') == [b'1', [b'2', b'3, 4'], b'5']


# -----------------------------------------------------------------------------
if __name__ == '__main__':
    test_tokenize_parameters()
    test_parse_parameters()
