# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class AggregationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Allowed values are Sum, Avg, Count, Min, Max. Default is Sum."""

    SUM = "Sum"
    AVG = "Avg"
    COUNT = "Count"
    MIN = "Min"
    MAX = "Max"


class AutomatedCheckResultType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of Result."""

    SUCCESS = "Success"
    WARNING = "Warning"
    ERROR = "Error"
    INFORMATION = "Information"


class Confidence(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Confidence of the search result."""

    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DiagnosticProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of diagnostic provisioning."""

    SUCCEEDED = "Succeeded"
    """All Diagnostics in the Batch succeeded."""
    PARTIAL_COMPLETE = "PartialComplete"
    """Some Diagnostics are still running or failed."""
    FAILED = "Failed"
    """All Diagnostics failed to run."""
    RUNNING = "Running"
    """All Diagnostics are still running."""
    CANCELED = "Canceled"
    """When Diagnostic request gets canceled."""


class ExecutionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of Troubleshooter Step execution."""

    SUCCESS = "Success"
    """Step execution succeeded."""
    RUNNING = "Running"
    """Step execution running"""
    FAILED = "Failed"
    """Step execution failed"""
    WARNING = "Warning"
    """Step execution warning"""


class ImportanceLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Importance level of the insight."""

    CRITICAL = "Critical"
    """A critical insight has been found after running the diagnostic."""
    WARNING = "Warning"
    """A warning insight has been found after running the diagnostic."""
    INFORMATION = "Information"
    """An information insight has been found after running the diagnostic."""


class Name(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Trigger criterion name."""

    SOLUTION_ID = "SolutionId"
    PROBLEM_CLASSIFICATION_ID = "ProblemClassificationId"
    REPLACEMENT_KEY = "ReplacementKey"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class QuestionContentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Default is Text."""

    TEXT = "Text"
    HTML = "Html"
    MARKDOWN = "Markdown"


class QuestionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of Question."""

    RADIO_BUTTON = "RadioButton"
    """SingleChoice radio button"""
    DROPDOWN = "Dropdown"
    """SingleChoice dropdown."""
    TEXT_INPUT = "TextInput"
    """Text Input"""
    MULTI_LINE_INFO_BOX = "MultiLineInfoBox"
    """MultiLineInfoBox"""
    DATE_TIME_PICKER = "DateTimePicker"
    """DateTime Picker"""
    MULTI_SELECT = "MultiSelect"
    """Multi Select"""


class ResultType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Result type of the search result."""

    COMMUNITY = "Community"
    DOCUMENTATION = "Documentation"


class SolutionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of solution provisioning."""

    SUCCEEDED = "Succeeded"
    """All Solutions in the Batch succeeded."""
    PARTIAL_COMPLETE = "PartialComplete"
    """Some Solutions are still running or failed."""
    FAILED = "Failed"
    """All Solutions failed to run."""
    RUNNING = "Running"
    """All Solutions are still running."""
    CANCELED = "Canceled"
    """When Solutions request gets canceled."""


class SolutionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Solution Type."""

    DIAGNOSTICS = "Diagnostics"
    """Diagnostics resource type."""
    SOLUTIONS = "Solutions"
    """Solutions resource type."""
    TROUBLESHOOTERS = "Troubleshooters"
    """Troubleshooters resource type."""
    SELF_HELP = "SelfHelp"
    """SelfHelp resource type."""


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Denotes the status of the diagnostic resource."""

    FAILED = "Failed"
    """Diagnostic creation failed."""
    MISSING_INPUTS = "MissingInputs"
    """Request is missing required inputs to run."""
    RUNNING = "Running"
    """Diagnostic is still running."""
    SUCCEEDED = "Succeeded"
    """Diagnostic creation succeeded."""
    TIMEOUT = "Timeout"
    """Diagnostic was timed out."""


class TroubleshooterProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of troubleshooter provisioning."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    RUNNING = "Running"
    AUTO_CONTINUE = "AutoContinue"


class Type(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of Troubleshooting step."""

    DECISION = "Decision"
    SOLUTION = "Solution"
    INSIGHT = "Insight"
    AUTOMATED_CHECK = "AutomatedCheck"
    INPUT = "Input"


class ValidationScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Validation scope."""

    NONE = "None"
    URL_FORMAT = "URLFormat"
    GUID_FORMAT = "GuidFormat"
    IP_ADDRESS_FORMAT = "IpAddressFormat"
    NUMBER_ONLY_FORMAT = "NumberOnlyFormat"
